/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.sra;

import htsjdk.samtools.Chunk;
import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SRAIterator;
import htsjdk.samtools.ValidationStringency;
import htsjdk.samtools.sra.ReferenceCache;
import htsjdk.samtools.sra.SRAAccession;
import htsjdk.samtools.sra.SRALazyRecord;
import htsjdk.samtools.util.CloseableIterator;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import ngs.AlignmentIterator;
import ngs.ErrorMsg;
import ngs.ReadCollection;
import ngs.Reference;

public class SRAAlignmentIterator
implements CloseableIterator<SAMRecord> {
    private ValidationStringency validationStringency;
    private SRAAccession accession;
    private ReadCollection run;
    private SAMFileHeader header;
    private ReferenceCache cachedReferences;
    private List<Long> referencesLengths;
    private Iterator<Chunk> referencesChunksIterator;
    private int currentReference = -1;
    private boolean hasMoreReferences = true;
    private AlignmentIterator alignedIterator;
    private Boolean hasMoreAlignments = false;
    private SRALazyRecord lastRecord;

    public SRAAlignmentIterator(SRAAccession accession, ReadCollection run, SAMFileHeader header, ReferenceCache cachedReferences, SRAIterator.RecordRangeInfo recordRangeInfo, Chunk chunk) {
        this.accession = accession;
        this.run = run;
        this.header = header;
        this.cachedReferences = cachedReferences;
        this.referencesLengths = recordRangeInfo.getReferenceLengthsAligned();
        this.referencesChunksIterator = this.getReferenceChunks(chunk).iterator();
        try {
            this.nextReference();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean hasNext() {
        if (this.lastRecord != null) {
            this.lastRecord.detachFromIterator();
            this.lastRecord = null;
        }
        if (this.hasMoreAlignments == null) {
            try {
                this.hasMoreAlignments = this.alignedIterator.nextAlignment();
            }
            catch (ErrorMsg e) {
                throw new RuntimeException(e);
            }
        }
        while (!this.hasMoreAlignments.booleanValue() && this.hasMoreReferences) {
            this.nextReference();
        }
        return this.hasMoreAlignments;
    }

    @Override
    public SAMRecord next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException("No more alignments are available");
        }
        return this.nextAlignment();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Removal of records not implemented.");
    }

    public void setValidationStringency(ValidationStringency validationStringency) {
        this.validationStringency = validationStringency;
    }

    private SAMRecord nextAlignment() {
        try {
            this.lastRecord = new SRALazyRecord(this.header, this.accession, this.run, this.alignedIterator, this.alignedIterator.getReadId(), this.alignedIterator.getAlignmentId());
        }
        catch (ErrorMsg e) {
            throw new RuntimeException(e);
        }
        if (this.validationStringency != null) {
            this.lastRecord.setValidationStringency(this.validationStringency);
        }
        this.hasMoreAlignments = null;
        return this.lastRecord;
    }

    private void nextReference() {
        if (!this.hasMoreReferences) {
            throw new NoSuchElementException("Cannot get next reference - already at last one");
        }
        try {
            this.alignedIterator = null;
            this.hasMoreAlignments = false;
            this.hasMoreReferences = this.referencesChunksIterator.hasNext();
            if (!this.hasMoreReferences) {
                return;
            }
            ++this.currentReference;
            Chunk refChunk = this.referencesChunksIterator.next();
            if (refChunk == null) {
                return;
            }
            Reference reference = this.cachedReferences.get(this.currentReference);
            this.alignedIterator = reference.getFilteredAlignmentSlice(refChunk.getChunkStart(), refChunk.getChunkEnd() - refChunk.getChunkStart(), 3, 35, 0);
            this.hasMoreAlignments = this.alignedIterator.nextAlignment();
        }
        catch (ErrorMsg e) {
            throw new RuntimeException(e);
        }
    }

    private List<Chunk> getReferenceChunks(Chunk chunk) {
        ArrayList<Chunk> referencesChunks = new ArrayList<Chunk>();
        long refOffset = 0L;
        for (Long refLen : this.referencesLengths) {
            if (chunk.getChunkStart() - refOffset >= refLen || chunk.getChunkEnd() - refOffset <= 0L) {
                referencesChunks.add(null);
            } else {
                long refChunkStart = Math.max(chunk.getChunkStart() - refOffset, 0L);
                long refChunkEnd = Math.min(chunk.getChunkEnd() - refOffset, refLen);
                referencesChunks.add(new Chunk(refChunkStart, refChunkEnd));
            }
            refOffset += refLen.longValue();
        }
        return referencesChunks;
    }

    @Override
    public void close() {
        if (this.lastRecord != null) {
            this.lastRecord.detachFromIterator();
            this.lastRecord = null;
        }
        this.alignedIterator = null;
    }
}

