/*
 * Decompiled with CFR 0.152.
 */
package free.jin.board.prefs;

import free.jin.BadChangesException;
import free.jin.I18n;
import free.jin.board.BoardManager;
import free.jin.board.JinBoard;
import free.jin.board.prefs.BoardModifyingPrefsPanel;
import free.util.swing.ColorChooser;
import free.util.swing.PreferredSizedPanel;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JRadioButton;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class SquareCoordinatesPanel
extends BoardModifyingPrefsPanel {
    private final JRadioButton none;
    private final JRadioButton rim;
    private final JRadioButton outside;
    private final JRadioButton everySquare;
    private final ColorChooser coordsColor;

    public SquareCoordinatesPanel(BoardManager boardManager, JinBoard jinBoard) {
        super(boardManager, jinBoard);
        I18n i18n = I18n.get((Class)SquareCoordinatesPanel.class);
        int n = boardManager.getCoordsDisplayStyle();
        this.none = i18n.createRadioButton("noSquareCoordsRadioButton");
        this.rim = i18n.createRadioButton("rimSquareCoordsRadioButton");
        this.outside = i18n.createRadioButton("outsideSquareCoordsRadioButton");
        this.everySquare = i18n.createRadioButton("everySquareCoordsRadioButton");
        this.none.setSelected(n == 0);
        this.rim.setSelected(n == 1);
        this.outside.setSelected(n == 2);
        this.everySquare.setSelected(n == 3);
        this.coordsColor = i18n.createColorChooser("coordsColorChooser");
        this.coordsColor.setColor(boardManager.getCoordsDisplayColor());
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.none);
        buttonGroup.add(this.rim);
        buttonGroup.add(this.outside);
        buttonGroup.add(this.everySquare);
        this.setBorder(BorderFactory.createEmptyBorder(15, 10, 15, 10));
        this.setLayout(new BoxLayout((Container)((Object)this), 1));
        PreferredSizedPanel preferredSizedPanel = new PreferredSizedPanel();
        preferredSizedPanel.setLayout(new BoxLayout((Container)preferredSizedPanel, 1));
        preferredSizedPanel.setBorder(BorderFactory.createCompoundBorder(i18n.createTitledBorder("squareCoordsPanel"), BorderFactory.createEmptyBorder(0, 5, 5, 5)));
        this.none.setAlignmentX(0.0f);
        this.rim.setAlignmentX(0.0f);
        this.outside.setAlignmentX(0.0f);
        this.everySquare.setAlignmentX(0.0f);
        this.coordsColor.setAlignmentX(0.0f);
        preferredSizedPanel.add(this.none);
        preferredSizedPanel.add(this.rim);
        preferredSizedPanel.add(this.outside);
        preferredSizedPanel.add(this.everySquare);
        preferredSizedPanel.add((Component)this.coordsColor);
        preferredSizedPanel.add(Box.createVerticalGlue());
        preferredSizedPanel.setAlignmentX(0.0f);
        this.add((Component)preferredSizedPanel);
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SquareCoordinatesPanel.this.previewBoard.setCoordsDisplayStyle(SquareCoordinatesPanel.this.getCoordsDisplayStyle());
                SquareCoordinatesPanel.this.fireStateChanged();
            }
        };
        this.none.addActionListener(actionListener);
        this.rim.addActionListener(actionListener);
        this.outside.addActionListener(actionListener);
        this.everySquare.addActionListener(actionListener);
        this.coordsColor.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                SquareCoordinatesPanel.this.previewBoard.setCoordsDisplayColor(SquareCoordinatesPanel.this.coordsColor.getColor());
                SquareCoordinatesPanel.this.fireStateChanged();
            }
        });
    }

    private int getCoordsDisplayStyle() {
        if (this.none.isSelected()) {
            return 0;
        }
        if (this.rim.isSelected()) {
            return 1;
        }
        if (this.outside.isSelected()) {
            return 2;
        }
        if (this.everySquare.isSelected()) {
            return 3;
        }
        throw new IllegalStateException("None of the radio buttons are selected");
    }

    public void initPreviewBoard() {
        this.previewBoard.setCoordsDisplayStyle(this.getCoordsDisplayStyle());
        this.previewBoard.setCoordsDisplayColor(this.coordsColor.getColor());
    }

    public void applyChanges() throws BadChangesException {
        this.boardManager.setCoordsDisplayStyle(this.getCoordsDisplayStyle());
        this.boardManager.setCoordsDisplayColor(this.coordsColor.getColor());
    }
}

