/*
 * Decompiled with CFR 0.152.
 */
package free.util.swing;

import free.util.ImageUtilities;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import javax.swing.JDesktopPane;

public class AdvancedJDesktopPane
extends JDesktopPane {
    public static final int CENTER = 1;
    public static final int TILE = 2;
    public static final int SCALE = 3;
    private Image wallpaper;
    private int wallpaperLayoutStyle = 1;

    public void setWallpaper(Image image) {
        this.wallpaper = image;
        if (image != null && ImageUtilities.preload(image) != 1) {
            image = null;
        }
        this.repaint();
    }

    public Image getWallpaper() {
        return this.wallpaper;
    }

    public void setWallpaperLayoutStyle(int n) {
        switch (n) {
            case 1: 
            case 2: 
            case 3: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Illegal wallpaper layout style: " + n);
            }
        }
        this.wallpaperLayoutStyle = n;
        this.repaint();
    }

    public int getWallpaperLayoutStyle() {
        return this.wallpaperLayoutStyle;
    }

    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        Dimension dimension = this.getSize();
        if (this.wallpaper != null) {
            int n = this.wallpaper.getWidth(this);
            int n2 = this.wallpaper.getHeight(this);
            if (n == -1 || n2 == -1) {
                return;
            }
            if (this.wallpaperLayoutStyle == 3) {
                graphics.drawImage(this.wallpaper, 0, 0, dimension.width, dimension.height, this);
            } else if (this.wallpaperLayoutStyle == 1) {
                int n3 = (dimension.width - n) / 2;
                int n4 = (dimension.height - n2) / 2;
                graphics.drawImage(this.wallpaper, n3, n4, this);
            } else if (this.wallpaperLayoutStyle == 2) {
                for (int i = 0; i < dimension.width; i += n) {
                    for (int j = 0; j < dimension.height; j += n2) {
                        graphics.drawImage(this.wallpaper, i, j, this);
                    }
                }
            }
        }
    }
}

