/*
 * Decompiled with CFR 0.152.
 */
package free.chess;

import free.chess.Piece;
import free.chess.PieceIcon;
import free.chess.PiecePainter;
import free.util.AWTUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Hashtable;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.KeyStroke;

public class PieceChooser
extends JComponent
implements ActionListener {
    private final Hashtable buttonsToPieces = new Hashtable();
    private final Hashtable piecesToButtons = new Hashtable();
    private Piece chosenPiece = null;

    public PieceChooser(Piece[] pieceArray, PiecePainter piecePainter) {
        int n = (int)Math.round(Math.ceil(Math.sqrt(pieceArray.length)));
        this.setLayout(new GridLayout(n, n, 10, 10));
        for (int i = 0; i < pieceArray.length; ++i) {
            Piece piece = pieceArray[i];
            JButton jButton = new JButton(piece.getTypeName(), new PieceIcon(piece, piecePainter, 32, 32));
            jButton.setVerticalTextPosition(3);
            jButton.setHorizontalTextPosition(0);
            jButton.setRolloverEnabled(true);
            this.add(jButton);
            this.buttonsToPieces.put(jButton, piece);
            this.piecesToButtons.put(piece, jButton);
            jButton.addActionListener(this);
        }
    }

    public Piece getSelectedPiece() {
        return this.chosenPiece;
    }

    public JButton buttonForPiece(Piece piece) {
        return (JButton)this.piecesToButtons.get(piece);
    }

    public static Piece showPieceChooser(Component component, int n, int n2, Piece[] pieceArray, PiecePainter piecePainter, Piece piece) {
        final JDialog jDialog = new JDialog(JOptionPane.getFrameForComponent(component), "Choose a piece", true);
        JPanel jPanel = new JPanel(new BorderLayout());
        jDialog.setContentPane(jPanel);
        PieceChooser pieceChooser = new PieceChooser(pieceArray, piecePainter);
        jPanel.add((Component)pieceChooser, "Center");
        jPanel.registerKeyboardAction(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                jDialog.dispose();
            }
        }, KeyStroke.getKeyStroke(27, 0), 2);
        pieceChooser.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                jDialog.dispose();
            }
        });
        JButton jButton = pieceChooser.buttonForPiece(piece);
        jDialog.getRootPane().setDefaultButton(jButton);
        jDialog.pack();
        Point point = component.getLocationOnScreen();
        int n3 = point.x + n - jButton.getX() - jButton.getWidth() / 2;
        int n4 = point.y + n2 - jButton.getY() - jButton.getHeight() / 2 - 20;
        jDialog.setLocation(n3, n4);
        AWTUtilities.forceToScreen((Window)jDialog);
        jDialog.setVisible(true);
        Piece piece2 = pieceChooser.getSelectedPiece();
        if (piece2 == null) {
            piece2 = piece;
        }
        return piece2;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.chosenPiece = (Piece)this.buttonsToPieces.get(actionEvent.getSource());
        this.fireActionPerformed(actionEvent);
    }

    public void addActionListener(ActionListener actionListener) {
        this.listenerList.add(ActionListener.class, actionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        this.listenerList.remove(ActionListener.class, actionListener);
    }

    protected void fireActionPerformed(ActionEvent actionEvent) {
        Object[] objectArray = this.listenerList.getListenerList();
        ActionEvent actionEvent2 = new ActionEvent(this, 1001, actionEvent.getActionCommand(), actionEvent.getModifiers());
        for (int i = 0; i < objectArray.length; i += 2) {
            if (objectArray[i] != (class$java$awt$event$ActionListener == null ? PieceChooser.class$("java.awt.event.ActionListener") : class$java$awt$event$ActionListener)) continue;
            ((ActionListener)objectArray[i + 1]).actionPerformed(actionEvent2);
        }
    }
}

