/*
 * Decompiled with CFR 0.152.
 */
package gnu.classpath.jdwp.util;

import gnu.classpath.jdwp.VMIdManager;
import gnu.classpath.jdwp.exception.JdwpException;
import gnu.classpath.jdwp.exception.JdwpInternalErrorException;
import gnu.classpath.jdwp.exception.NotImplementedException;
import gnu.classpath.jdwp.id.ObjectId;
import gnu.classpath.jdwp.util.JdwpString;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;

public class Value {
    public static void writeUntaggedValue(DataOutputStream os, Object obj) throws JdwpException, IOException {
        Value.writeValue(os, obj, false);
    }

    public static void writeTaggedValue(DataOutputStream os, Object obj) throws JdwpException, IOException {
        Value.writeValue(os, obj, true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final void writeValue(DataOutputStream os, Object obj, boolean tagged) throws IOException, JdwpException {
        Class clazz = obj.getClass();
        if (clazz.isPrimitive()) {
            if (clazz == Byte.TYPE) {
                if (tagged) {
                    os.writeByte(66);
                }
                os.writeByte(((Byte)obj).byteValue());
                return;
            } else if (clazz == Character.TYPE) {
                if (tagged) {
                    os.writeByte(67);
                }
                os.writeChar(((Character)obj).charValue());
                return;
            } else if (clazz == Float.TYPE) {
                if (tagged) {
                    os.writeByte(70);
                }
                os.writeFloat(((Float)obj).floatValue());
                return;
            } else if (clazz == Double.TYPE) {
                if (tagged) {
                    os.writeByte(68);
                }
                os.writeDouble((Double)obj);
                return;
            } else if (clazz == Integer.TYPE) {
                if (tagged) {
                    os.writeByte(66);
                }
                os.writeInt((Integer)obj);
                return;
            } else if (clazz == Long.TYPE) {
                if (tagged) {
                    os.writeByte(74);
                }
                os.writeLong((Long)obj);
                return;
            } else if (clazz == Short.TYPE) {
                if (tagged) {
                    os.writeByte(83);
                }
                os.writeInt(((Short)obj).shortValue());
                return;
            } else if (clazz == Void.TYPE) {
                if (!tagged) return;
                os.writeByte(86);
                return;
            } else {
                if (clazz != Boolean.TYPE) throw new JdwpInternalErrorException("Field has invalid primitive!");
                if (tagged) {
                    os.writeByte(90);
                }
                os.writeBoolean((Boolean)obj);
            }
            return;
        } else {
            if (tagged) {
                if (clazz.isArray()) {
                    os.writeByte(91);
                } else if (obj instanceof String) {
                    os.writeByte(115);
                } else if (obj instanceof Thread) {
                    os.writeByte(116);
                } else if (obj instanceof ThreadGroup) {
                    os.writeByte(103);
                } else if (obj instanceof ClassLoader) {
                    os.writeByte(108);
                } else if (obj instanceof Class) {
                    os.writeByte(99);
                } else {
                    os.writeByte(76);
                }
            }
            ObjectId oid = VMIdManager.getDefault().getObjectId(obj);
            oid.write(os);
        }
    }

    public static Object getObj(ByteBuffer bb) throws JdwpException, IOException {
        return Value.getUntaggedObj(bb, bb.get());
    }

    public static Object getUntaggedObj(ByteBuffer bb, Class type) throws JdwpException, IOException {
        if (type.isPrimitive()) {
            if (type == Byte.TYPE) {
                return new Byte(bb.get());
            }
            if (type == Character.TYPE) {
                return new Character(bb.getChar());
            }
            if (type == Float.TYPE) {
                return new Float(bb.getFloat());
            }
            if (type == Double.TYPE) {
                return new Double(bb.getDouble());
            }
            if (type == Integer.TYPE) {
                return new Integer(bb.getInt());
            }
            if (type == Long.TYPE) {
                return new Long(bb.getLong());
            }
            if (type == Short.TYPE) {
                return new Short(bb.getShort());
            }
            if (type == Boolean.TYPE) {
                return bb.get() == 0 ? new Boolean(false) : new Boolean(true);
            }
            if (type == Void.TYPE) {
                return new byte[0];
            }
            throw new JdwpInternalErrorException("Field has invalid primitive!");
        }
        ObjectId oid = VMIdManager.getDefault().readObjectId(bb);
        return oid.getObject();
    }

    public static Object getUntaggedObj(ByteBuffer bb, byte tag) throws JdwpException, IOException {
        switch (tag) {
            case 66: {
                return new Byte(bb.get());
            }
            case 67: {
                return new Character(bb.getChar());
            }
            case 70: {
                return new Float(bb.getFloat());
            }
            case 68: {
                return new Double(bb.getDouble());
            }
            case 73: {
                return new Integer(bb.getInt());
            }
            case 74: {
                return new Long(bb.getLong());
            }
            case 83: {
                return new Short(bb.getShort());
            }
            case 86: {
                return new byte[0];
            }
            case 90: {
                return bb.get() == 0 ? new Boolean(false) : new Boolean(true);
            }
            case 115: {
                return JdwpString.readString(bb);
            }
            case 76: 
            case 91: 
            case 99: 
            case 103: 
            case 108: 
            case 116: {
                ObjectId oid = VMIdManager.getDefault().readObjectId(bb);
                return oid.getObject();
            }
        }
        throw new NotImplementedException("Tag " + tag + " is not implemented.");
    }
}

