/*
 * Decompiled with CFR 0.152.
 */
package gnu.xml.dom;

import gnu.xml.dom.DomDOMException;
import gnu.xml.dom.DomDocument;
import gnu.xml.dom.DomNode;
import org.w3c.dom.CharacterData;
import org.w3c.dom.events.MutationEvent;

public abstract class DomCharacterData
extends DomNode
implements CharacterData {
    private String text;

    public void appendData(String arg) {
        if (this.isReadonly()) {
            throw new DomDOMException(7);
        }
        String value = this.text + arg;
        this.mutating(value);
        this.text = value;
    }

    public void deleteData(int offset, int count) {
        if (this.isReadonly()) {
            throw new DomDOMException(7);
        }
        char[] raw = this.text.toCharArray();
        if (offset < 0 || count < 0 || offset > raw.length) {
            throw new DomDOMException(1);
        }
        if (offset + count > raw.length) {
            count = raw.length - offset;
        }
        if (count == 0) {
            return;
        }
        try {
            char[] buf = new char[raw.length - count];
            System.arraycopy(raw, 0, buf, 0, offset);
            System.arraycopy(raw, offset + count, buf, offset, raw.length - (offset + count));
            String value = new String(buf);
            this.mutating(value);
            this.text = value;
        }
        catch (IndexOutOfBoundsException x) {
            throw new DomDOMException(1);
        }
    }

    public String getNodeValue() {
        return this.text;
    }

    public final String getData() {
        return this.text;
    }

    public int getLength() {
        return this.text.length();
    }

    public void insertData(int offset, String arg) {
        if (this.isReadonly()) {
            throw new DomDOMException(7);
        }
        char[] raw = this.text.toCharArray();
        char[] tmp = arg.toCharArray();
        char[] buf = new char[raw.length + tmp.length];
        try {
            System.arraycopy(raw, 0, buf, 0, offset);
            System.arraycopy(tmp, 0, buf, offset, tmp.length);
            System.arraycopy(raw, offset, buf, offset + tmp.length, raw.length - offset);
            String value = new String(buf);
            this.mutating(value);
            this.text = value;
        }
        catch (IndexOutOfBoundsException x) {
            throw new DomDOMException(1);
        }
    }

    public void replaceData(int offset, int count, String arg) {
        if (this.readonly) {
            throw new DomDOMException(7);
        }
        char[] raw = this.text.toCharArray();
        if (offset < 0 || count < 0 || offset > raw.length) {
            throw new DomDOMException(1);
        }
        if (offset + count > raw.length) {
            count = raw.length - offset;
        }
        try {
            char[] buf = new char[raw.length - count];
            System.arraycopy(raw, 0, buf, 0, offset);
            System.arraycopy(raw, offset + count, buf, offset, raw.length - (offset + count));
            char[] tmp = arg.toCharArray();
            char[] buf2 = new char[buf.length + tmp.length];
            System.arraycopy(raw, 0, buf, 0, offset);
            System.arraycopy(tmp, 0, buf, offset, tmp.length);
            System.arraycopy(raw, offset, buf, offset + tmp.length, raw.length - offset);
            String value = new String(buf);
            this.mutating(value);
            this.text = value;
        }
        catch (IndexOutOfBoundsException x) {
            throw new DomDOMException(1);
        }
    }

    public void setNodeValue(String value) {
        if (this.isReadonly()) {
            throw new DomDOMException(7);
        }
        if (value == null) {
            value = "";
        }
        this.mutating(value);
        this.text = value;
    }

    public final void setData(String data) {
        this.setNodeValue(data);
    }

    public String substringData(int offset, int count) {
        try {
            return this.text.substring(offset, count);
        }
        catch (StringIndexOutOfBoundsException e) {
            if (offset >= 0 && count >= 0 && offset < this.text.length()) {
                return this.text.substring(offset);
            }
            throw new DomDOMException(1);
        }
    }

    public final String getBaseURI() {
        return null;
    }

    private final void mutating(String newValue) {
        MutationEvent event = (MutationEvent)this.createEvent("MutationEvents");
        event.initMutationEvent("DOMCharacterDataModified", true, false, null, this.text, newValue, null, (short)0);
        this.dispatchEvent(event);
    }

    DomCharacterData(short nodeType, DomDocument doc, String value) {
        super(nodeType, doc);
        this.text = value == null ? "" : value;
    }

    DomCharacterData(short nodeType, DomDocument doc, char[] buf, int offset, int length) {
        super(nodeType, doc);
        this.text = buf == null ? "" : new String(buf, offset, length);
    }
}

