/*
 * Decompiled with CFR 0.152.
 */
package gnu.xml.xpath;

import gnu.xml.transform.Bindings;
import gnu.xml.xpath.Expr;
import javax.xml.namespace.QName;
import javax.xml.xpath.XPathVariableResolver;
import org.w3c.dom.Node;

public class VariableReference
extends Expr {
    final XPathVariableResolver resolver;
    final QName name;

    public Object evaluate(Node context, int pos, int len) {
        if (this.resolver != null) {
            if (this.resolver instanceof Bindings) {
                return ((Bindings)this.resolver).get(this.name, context, pos, len);
            }
            return this.resolver.resolveVariable(this.name);
        }
        throw new IllegalStateException("no variable resolver");
    }

    public Expr clone(Object context) {
        XPathVariableResolver r = this.resolver;
        if (context instanceof XPathVariableResolver) {
            r = (XPathVariableResolver)context;
        }
        return new VariableReference(r, this.name);
    }

    public boolean references(QName var) {
        return this.name.equals(var);
    }

    public String toString() {
        StringBuffer buf = new StringBuffer("$");
        String prefix = this.name.getPrefix();
        if (prefix != null && !"".equals(prefix)) {
            buf.append(prefix);
            buf.append(':');
        }
        buf.append(this.name.getLocalPart());
        return buf.toString();
    }

    public VariableReference(XPathVariableResolver resolver, QName name) {
        this.resolver = resolver;
        this.name = name;
    }
}

