/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public class Hashtable
extends Dictionary
implements Map,
Cloneable,
Serializable {
    private static final int DEFAULT_CAPACITY = 11;
    static final int KEYS = 0;
    static final int VALUES = 1;
    static final int ENTRIES = 2;
    private static final float DEFAULT_LOAD_FACTOR = 0.75f;
    private static final long serialVersionUID = 1421746759512286392L;
    private int threshold;
    private final float loadFactor;
    transient HashEntry[] buckets;
    transient int modCount;
    transient int size;
    private transient Set keys;
    private transient Collection values;
    private transient Set entries;

    public synchronized int size() {
        return this.size;
    }

    public synchronized boolean isEmpty() {
        boolean bl = false;
        if (this.size == 0) {
            bl = true;
        }
        return bl;
    }

    public Enumeration keys() {
        return new Enumerator(0);
    }

    public Enumeration elements() {
        return new Enumerator(1);
    }

    public synchronized boolean contains(Object value) {
        int i = this.buckets.length - 1;
        while (i >= 0) {
            HashEntry e = this.buckets[i];
            while (e != null) {
                if (value.equals(e.value)) {
                    return true;
                }
                e = e.next;
            }
            --i;
        }
        if (value == null) {
            throw new NullPointerException();
        }
        return false;
    }

    public boolean containsValue(Object value) {
        return this.contains(value);
    }

    public synchronized boolean containsKey(Object key) {
        int idx = this.hash(key);
        HashEntry e = this.buckets[idx];
        while (e != null) {
            if (key.equals(e.key)) {
                return true;
            }
            e = e.next;
        }
        return false;
    }

    public synchronized Object get(Object key) {
        int idx = this.hash(key);
        HashEntry e = this.buckets[idx];
        while (e != null) {
            if (key.equals(e.key)) {
                return e.value;
            }
            e = e.next;
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    public synchronized Object put(Object key, Object value) {
        idx = this.hash(key);
        e = this.buckets[idx];
        if (value != null) ** GOTO lbl10
        throw new NullPointerException();
lbl-1000:
        // 1 sources

        {
            if (key.equals(e.key)) {
                r = e.value;
                e.value = value;
                return r;
            }
            e = e.next;
lbl10:
            // 2 sources

            ** while (e != null)
        }
lbl11:
        // 1 sources

        ++this.modCount;
        if (++this.size > this.threshold) {
            this.rehash();
            idx = this.hash(key);
        }
        e = new HashEntry(key, value);
        e.next = this.buckets[idx];
        this.buckets[idx] = e;
        return null;
    }

    public synchronized Object remove(Object key) {
        int idx = this.hash(key);
        HashEntry e = this.buckets[idx];
        HashEntry last = null;
        while (e != null) {
            if (key.equals(e.key)) {
                ++this.modCount;
                if (last == null) {
                    this.buckets[idx] = e.next;
                } else {
                    last.next = e.next;
                }
                --this.size;
                return e.value;
            }
            last = e;
            e = e.next;
        }
        return null;
    }

    public synchronized void putAll(Map m) {
        Iterator itr = m.entrySet().iterator();
        while (itr.hasNext()) {
            Map.Entry e = (Map.Entry)itr.next();
            if (e instanceof AbstractMap.BasicMapEntry) {
                AbstractMap.BasicMapEntry entry = (AbstractMap.BasicMapEntry)e;
                this.put(entry.key, entry.value);
                continue;
            }
            this.put(e.getKey(), e.getValue());
        }
    }

    public synchronized void clear() {
        if (this.size > 0) {
            ++this.modCount;
            Arrays.fill(this.buckets, null);
            this.size = 0;
        }
    }

    public synchronized Object clone() {
        Hashtable copy = null;
        try {
            copy = (Hashtable)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        copy.buckets = new HashEntry[this.buckets.length];
        copy.putAllInternal(this);
        copy.keys = null;
        copy.values = null;
        copy.entries = null;
        return copy;
    }

    public synchronized String toString() {
        HashIterator entries = new HashIterator(2);
        StringBuffer r = new StringBuffer("{");
        int pos = this.size;
        while (pos > 0) {
            r.append(entries.next());
            if (pos > 1) {
                r.append(", ");
            }
            --pos;
        }
        r.append("}");
        return r.toString();
    }

    public Set keySet() {
        if (this.keys == null) {
            AbstractSet r = new AbstractSet(){

                public final int size() {
                    return Hashtable.this.size;
                }

                public final Iterator iterator() {
                    return new HashIterator(0);
                }

                public final void clear() {
                    Hashtable.this.clear();
                }

                public final boolean contains(Object o) {
                    if (o == null) {
                        return false;
                    }
                    return Hashtable.this.containsKey(o);
                }

                public final boolean remove(Object o) {
                    boolean bl = false;
                    if (Hashtable.this.remove(o) != null) {
                        bl = true;
                    }
                    return bl;
                }
            };
            this.keys = new Collections.SynchronizedSet((Object)this, r);
        }
        return this.keys;
    }

    public Collection values() {
        if (this.values == null) {
            AbstractCollection r = new AbstractCollection(){

                public final int size() {
                    return Hashtable.this.size;
                }

                public final Iterator iterator() {
                    return new HashIterator(1);
                }

                public final void clear() {
                    Hashtable.this.clear();
                }
            };
            this.values = new Collections.SynchronizedCollection(this, r);
        }
        return this.values;
    }

    public Set entrySet() {
        if (this.entries == null) {
            AbstractSet r = new AbstractSet(){

                public final int size() {
                    return Hashtable.this.size;
                }

                public final Iterator iterator() {
                    return new HashIterator(2);
                }

                public final void clear() {
                    Hashtable.this.clear();
                }

                public final boolean contains(Object o) {
                    boolean bl = false;
                    if (Hashtable.this.getEntry(o) != null) {
                        bl = true;
                    }
                    return bl;
                }

                public final boolean remove(Object o) {
                    HashEntry e = Hashtable.this.getEntry(o);
                    if (e != null) {
                        Hashtable.this.remove(e.key);
                        return true;
                    }
                    return false;
                }
            };
            this.entries = new Collections.SynchronizedSet((Object)this, r);
        }
        return this.entries;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Map)) {
            return false;
        }
        return this.entrySet().equals(((Map)o).entrySet());
    }

    public synchronized int hashCode() {
        HashIterator itr = new HashIterator(2);
        int hashcode = 0;
        int pos = this.size;
        while (pos > 0) {
            hashcode += itr.next().hashCode();
            --pos;
        }
        return hashcode;
    }

    private final int hash(Object key) {
        int hash = key.hashCode() % this.buckets.length;
        return hash < 0 ? -hash : hash;
    }

    HashEntry getEntry(Object o) {
        if (!(o instanceof Map.Entry)) {
            return null;
        }
        Object key = ((Map.Entry)o).getKey();
        if (key == null) {
            return null;
        }
        int idx = this.hash(key);
        HashEntry e = this.buckets[idx];
        while (e != null) {
            if (o.equals(e)) {
                return e;
            }
            e = e.next;
        }
        return null;
    }

    void putAllInternal(Map m) {
        Iterator itr = m.entrySet().iterator();
        this.size = 0;
        while (itr.hasNext()) {
            ++this.size;
            Map.Entry e = (Map.Entry)itr.next();
            Object key = e.getKey();
            int idx = this.hash(key);
            HashEntry he = new HashEntry(key, e.getValue());
            he.next = this.buckets[idx];
            this.buckets[idx] = he;
        }
    }

    protected void rehash() {
        HashEntry[] oldBuckets = this.buckets;
        int newcapacity = this.buckets.length * 2 + 1;
        this.threshold = (int)((float)newcapacity * this.loadFactor);
        this.buckets = new HashEntry[newcapacity];
        int i = oldBuckets.length - 1;
        while (i >= 0) {
            HashEntry e = oldBuckets[i];
            while (e != null) {
                int idx = this.hash(e.key);
                HashEntry dest = this.buckets[idx];
                if (dest != null) {
                    while (dest.next != null) {
                        dest = dest.next;
                    }
                    dest.next = e;
                } else {
                    this.buckets[idx] = e;
                }
                HashEntry next = e.next;
                e.next = null;
                e = next;
            }
            --i;
        }
    }

    private final synchronized void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        s.writeInt(this.buckets.length);
        s.writeInt(this.size);
        HashIterator it = new HashIterator(2);
        while (it.hasNext()) {
            HashEntry entry = (HashEntry)it.next();
            s.writeObject(entry.key);
            s.writeObject(entry.value);
        }
    }

    private final void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.buckets = new HashEntry[s.readInt()];
        int len = s.readInt();
        while (--len >= 0) {
            this.put(s.readObject(), s.readObject());
        }
    }

    public Hashtable() {
        this(11, 0.75f);
    }

    public Hashtable(Map m) {
        this(Math.max(m.size() * 2, 11), 0.75f);
        this.putAll(m);
    }

    public Hashtable(int initialCapacity) {
        this(initialCapacity, 0.75f);
    }

    public Hashtable(int initialCapacity, float loadFactor) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("Illegal Capacity: " + initialCapacity);
        }
        if (!(loadFactor > 0.0f)) {
            throw new IllegalArgumentException("Illegal Load: " + loadFactor);
        }
        if (initialCapacity == 0) {
            initialCapacity = 1;
        }
        this.buckets = new HashEntry[initialCapacity];
        this.loadFactor = loadFactor;
        this.threshold = (int)((float)initialCapacity * loadFactor);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private final class Enumerator
    implements Enumeration {
        final int type;
        int count;
        int idx;
        HashEntry next;

        public final boolean hasMoreElements() {
            boolean bl = false;
            if (this.count > 0) {
                bl = true;
            }
            return bl;
        }

        public final Object nextElement() {
            if (this.count == 0) {
                throw new NoSuchElementException("Hashtable Enumerator");
            }
            --this.count;
            HashEntry e = this.next;
            while (e == null) {
                e = Hashtable.this.buckets[--this.idx];
            }
            this.next = e.next;
            return this.type == 1 ? e.value : e.key;
        }

        private final /* synthetic */ void this() {
            this.count = Hashtable.this.size;
            this.idx = Hashtable.this.buckets.length;
        }

        Enumerator(int type) {
            this.this();
            this.type = type;
        }
    }

    private static final class HashEntry
    extends AbstractMap.BasicMapEntry {
        HashEntry next;

        public final Object setValue(Object newVal) {
            if (newVal == null) {
                throw new NullPointerException();
            }
            return super.setValue(newVal);
        }

        HashEntry(Object key, Object value) {
            super(key, value);
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private final class HashIterator
    implements Iterator {
        final int type;
        int knownMod;
        int count;
        int idx;
        HashEntry last;
        HashEntry next;

        public final boolean hasNext() {
            if (this.knownMod != Hashtable.this.modCount) {
                throw new ConcurrentModificationException();
            }
            boolean bl = false;
            if (this.count > 0) {
                bl = true;
            }
            return bl;
        }

        public final Object next() {
            if (this.knownMod != Hashtable.this.modCount) {
                throw new ConcurrentModificationException();
            }
            if (this.count == 0) {
                throw new NoSuchElementException();
            }
            --this.count;
            HashEntry e = this.next;
            while (e == null) {
                e = Hashtable.this.buckets[--this.idx];
            }
            this.next = e.next;
            this.last = e;
            if (this.type == 1) {
                return e.value;
            }
            if (this.type == 0) {
                return e.key;
            }
            return e;
        }

        public final void remove() {
            if (this.knownMod != Hashtable.this.modCount) {
                throw new ConcurrentModificationException();
            }
            if (this.last == null) {
                throw new IllegalStateException();
            }
            Hashtable.this.remove(this.last.key);
            this.last = null;
            ++this.knownMod;
        }

        private final /* synthetic */ void this() {
            this.knownMod = Hashtable.this.modCount;
            this.count = Hashtable.this.size;
            this.idx = Hashtable.this.buckets.length;
        }

        HashIterator(int type) {
            this.this();
            this.type = type;
        }
    }
}

