/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import gnu.classpath.VMStackWalker;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class ResourceBundle {
    private static Map bundleCache;
    private static Locale lastDefaultLocale;
    private static final Locale emptyLocale;
    private static BundleKey lookupKey;
    private static Object nullEntry;
    protected ResourceBundle parent;
    private Locale locale;
    static /* synthetic */ Class class$java$util$ResourceBundle;

    public final String getString(String key) {
        return (String)this.getObject(key);
    }

    public final String[] getStringArray(String key) {
        return (String[])this.getObject(key);
    }

    public final Object getObject(String key) {
        ResourceBundle bundle = this;
        while (bundle != null) {
            Object o = bundle.handleGetObject(key);
            if (o != null) {
                return o;
            }
            bundle = bundle.parent;
        }
        String className = this.getClass().getName();
        throw new MissingResourceException("Key '" + key + "'not found in Bundle: " + className, className, key);
    }

    public Locale getLocale() {
        return this.locale;
    }

    protected void setParent(ResourceBundle parent) {
        this.parent = parent;
    }

    public static ResourceBundle getBundle(String baseName) {
        ClassLoader cl = VMStackWalker.getCallingClassLoader();
        if (cl == null) {
            cl = ClassLoader.getSystemClassLoader();
        }
        return ResourceBundle.getBundle(baseName, Locale.getDefault(), cl);
    }

    public static ResourceBundle getBundle(String baseName, Locale locale) {
        ClassLoader cl = VMStackWalker.getCallingClassLoader();
        if (cl == null) {
            cl = ClassLoader.getSystemClassLoader();
        }
        return ResourceBundle.getBundle(baseName, locale, cl);
    }

    public static synchronized ResourceBundle getBundle(String baseName, Locale locale, ClassLoader classLoader) {
        Locale defaultLocale = Locale.getDefault();
        if (defaultLocale != lastDefaultLocale) {
            bundleCache = new HashMap();
            lastDefaultLocale = defaultLocale;
        }
        lookupKey.set(baseName, locale, classLoader);
        Object obj = bundleCache.get(lookupKey);
        Object rb = null;
        if (obj instanceof ResourceBundle) {
            return (ResourceBundle)obj;
        }
        if (obj != nullEntry) {
            boolean wantBase = locale.equals(defaultLocale);
            ResourceBundle bundle = ResourceBundle.tryBundle(baseName, locale, classLoader, wantBase);
            if (bundle == null && !locale.equals(defaultLocale)) {
                bundle = ResourceBundle.tryBundle(baseName, defaultLocale, classLoader, true);
            }
            BundleKey key = new BundleKey(baseName, locale, classLoader);
            if (bundle == null) {
                bundleCache.put(key, nullEntry);
            } else {
                bundleCache.put(key, bundle);
                return bundle;
            }
        }
        throw new MissingResourceException("Bundle " + baseName + " not found for locale " + locale + " by classloader " + classLoader, baseName, "");
    }

    protected abstract Object handleGetObject(String var1);

    public abstract Enumeration getKeys();

    private static final ResourceBundle tryBundle(String localizedName, ClassLoader classloader) {
        ResourceBundle bundle = null;
        try {
            Class rbClass = classloader == null ? Class.forName(localizedName) : classloader.loadClass(localizedName);
            Class clazz = class$java$util$ResourceBundle;
            if (clazz == null) {
                clazz = class$java$util$ResourceBundle = ResourceBundle.class("[Ljava.util.ResourceBundle;", false);
            }
            if (clazz.isAssignableFrom(rbClass)) {
                bundle = (ResourceBundle)rbClass.newInstance();
            }
        }
        catch (IllegalAccessException ex) {
        }
        catch (InstantiationException ex) {
        }
        catch (ClassNotFoundException ex) {
            // empty catch block
        }
        if (bundle == null) {
            try {
                String resourceName = localizedName.replace('.', '/') + ".properties";
                InputStream is = classloader == null ? ClassLoader.getSystemResourceAsStream(resourceName) : classloader.getResourceAsStream(resourceName);
                if (is != null) {
                    bundle = new PropertyResourceBundle(is);
                }
            }
            catch (IOException ex) {
                MissingResourceException mre = new MissingResourceException("Failed to load bundle: " + localizedName, localizedName, "");
                mre.initCause(ex);
                throw mre;
            }
        }
        return bundle;
    }

    private static final ResourceBundle tryBundle(String baseName, Locale locale, ClassLoader classLoader, boolean wantBase) {
        String language = locale.getLanguage();
        String country = locale.getCountry();
        String variant = locale.getVariant();
        int baseLen = baseName.length();
        StringBuffer sb = new StringBuffer(baseLen + variant.length() + 7);
        sb.append(baseName);
        if (language.length() > 0) {
            sb.append('_');
            sb.append(language);
            if (country.length() > 0) {
                sb.append('_');
                sb.append(country);
                if (variant.length() > 0) {
                    sb.append('_');
                    sb.append(variant);
                }
            }
        }
        String bundleName = sb.toString();
        ResourceBundle first = null;
        ResourceBundle last = null;
        while (true) {
            int idx;
            ResourceBundle foundBundle;
            if ((foundBundle = ResourceBundle.tryBundle(bundleName, classLoader)) != null) {
                if (first == null) {
                    first = foundBundle;
                }
                if (last != null) {
                    last.parent = foundBundle;
                }
                foundBundle.locale = locale;
                last = foundBundle;
            }
            if ((idx = bundleName.lastIndexOf(95)) <= baseLen && (idx != baseLen || first == null && !wantBase)) break;
            bundleName = bundleName.substring(0, idx);
        }
        return first;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    static {
        emptyLocale = new Locale("");
        lookupKey = new BundleKey();
        nullEntry = new Object();
    }

    private static class BundleKey {
        String baseName;
        Locale locale;
        ClassLoader classLoader;
        int hashcode;

        void set(String s, Locale l, ClassLoader cl) {
            this.baseName = s;
            this.locale = l;
            this.classLoader = cl;
            this.hashcode = this.baseName.hashCode() ^ this.locale.hashCode() ^ this.classLoader.hashCode();
        }

        public int hashCode() {
            return this.hashcode;
        }

        public boolean equals(Object o) {
            if (!(o instanceof BundleKey)) {
                return false;
            }
            BundleKey key = (BundleKey)o;
            boolean bl = false;
            if (this.hashcode == key.hashcode && this.baseName.equals(key.baseName) && this.locale.equals(key.locale) && this.classLoader.equals(key.classLoader)) {
                bl = true;
            }
            return bl;
        }

        BundleKey() {
        }

        BundleKey(String s, Locale l, ClassLoader cl) {
            this.set(s, l, cl);
        }
    }
}

