/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.Dimension;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleHyperlink;
import javax.accessibility.AccessibleHypertext;
import javax.accessibility.AccessibleStateSet;
import javax.accessibility.AccessibleText;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultEditorKit;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class JEditorPane
extends JTextComponent {
    private static final long serialVersionUID = 3140472492599046285L;
    private URL page;
    private EditorKit editorKit;
    boolean focus_root;
    static /* synthetic */ Class class$javax$swing$event$HyperlinkListener;
    private static final /* synthetic */ boolean assert;

    protected EditorKit createDefaultEditorKit() {
        return new DefaultEditorKit();
    }

    public static EditorKit createEditorKitForContentType(String type) {
        return new DefaultEditorKit();
    }

    public void fireHyperlinkUpdate(HyperlinkEvent event) {
        HyperlinkListener[] listeners = this.getHyperlinkListeners();
        int index = 0;
        while (index < listeners.length) {
            listeners[index].hyperlinkUpdate(event);
            ++index;
        }
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = this.getEditorKit() instanceof HTMLEditorKit ? new AccessibleJEditorPaneHTML() : new AccessibleJEditorPane();
        }
        return this.accessibleContext;
    }

    public final String getContentType() {
        return this.getEditorKit().getContentType();
    }

    public EditorKit getEditorKit() {
        if (this.editorKit == null) {
            this.setEditorKit(this.createDefaultEditorKit());
        }
        return this.editorKit;
    }

    public static String getEditorKitClassNameForContentType(String type) {
        return "text/plain";
    }

    public EditorKit getEditorKitForContentType(String type) {
        return this.editorKit;
    }

    public Dimension getPreferredSize() {
        return super.getPreferredSize();
    }

    public boolean getScrollableTracksViewportHeight() {
        return this.isValid();
    }

    public boolean getScrollableTracksViewportWidth() {
        return this.isValid();
    }

    public URL getPage() {
        return this.page;
    }

    protected InputStream getStream(URL page) throws IOException {
        return page.openStream();
    }

    public String getText() {
        return super.getText();
    }

    public String getUIClassID() {
        return "EditorPaneUI";
    }

    public boolean isFocusCycleRoot() {
        return this.focus_root;
    }

    protected String paramString() {
        return "JEditorPane";
    }

    public void read(InputStream in, Object desc) throws IOException {
        EditorKit kit = this.getEditorKit();
        if (kit instanceof HTMLEditorKit && desc instanceof HTMLDocument) {
            Document doc = (Document)desc;
            try {
                kit.read(in, doc, 0);
            }
            catch (BadLocationException ex) {
                if (!assert) {
                    throw new AssertionError((Object)"BadLocationException must not be thrown here.");
                }
            }
        } else {
            InputStreamReader inRead = new InputStreamReader(in);
            super.read(inRead, desc);
        }
    }

    public static void registerEditorKitForContentType(String type, String classname) {
    }

    public static void registerEditorKitForContentType(String type, String classname, ClassLoader loader) {
    }

    public void replaceSelection(String content) {
    }

    public void scrollToReference(String reference) {
    }

    public final void setContentType(String type) {
        if (this.editorKit != null && this.editorKit.getContentType().equals(type)) {
            return;
        }
        EditorKit kit = this.getEditorKitForContentType(type);
        if (kit != null) {
            this.setEditorKit(kit);
        }
    }

    public void setEditorKit(EditorKit newValue) {
        if (this.editorKit == newValue) {
            return;
        }
        if (this.editorKit != null) {
            this.editorKit.deinstall(this);
        }
        EditorKit oldValue = this.editorKit;
        this.editorKit = newValue;
        if (this.editorKit != null) {
            this.editorKit.install(this);
            this.setDocument(this.editorKit.createDefaultDocument());
        }
        this.firePropertyChange("editorKit", oldValue, newValue);
        this.invalidate();
        this.repaint();
        this.accessibleContext = null;
    }

    public void setEditorKitForContentType(String type, EditorKit k) {
    }

    public void setPage(String url) throws IOException {
        this.setPage(new URL(url));
    }

    public void setPage(URL page) throws IOException {
        if (page == null) {
            throw new IOException("invalid url");
        }
        try {
            this.page = page;
            this.getEditorKit().read(page.openStream(), this.getDocument(), 0);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    public void setText(String t) {
        super.setText(t);
    }

    public void addHyperlinkListener(HyperlinkListener listener) {
        Class clazz = class$javax$swing$event$HyperlinkListener;
        if (clazz == null) {
            clazz = class$javax$swing$event$HyperlinkListener = JEditorPane.class("[Ljavax.swing.event.HyperlinkListener;", false);
        }
        this.listenerList.add(clazz, listener);
    }

    public void removeHyperlinkListener(HyperlinkListener listener) {
        Class clazz = class$javax$swing$event$HyperlinkListener;
        if (clazz == null) {
            clazz = class$javax$swing$event$HyperlinkListener = JEditorPane.class("[Ljavax.swing.event.HyperlinkListener;", false);
        }
        this.listenerList.remove(clazz, listener);
    }

    public HyperlinkListener[] getHyperlinkListeners() {
        Class clazz = class$javax$swing$event$HyperlinkListener;
        if (clazz == null) {
            clazz = class$javax$swing$event$HyperlinkListener = JEditorPane.class("[Ljavax.swing.event.HyperlinkListener;", false);
        }
        return (HyperlinkListener[])this.getListeners(clazz);
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    public JEditorPane() {
        this.setEditorKit(this.createDefaultEditorKit());
    }

    public JEditorPane(String url) throws IOException {
        this(new URL(url));
    }

    public JEditorPane(String type, String text) {
        this.setEditorKit(JEditorPane.createEditorKitForContentType(type));
        this.setText(text);
    }

    public JEditorPane(URL url) throws IOException {
        this();
        this.setPage(url);
    }

    static {
        assert = Class.forName("[Ljavax.swing.JEditorPane;").getComponentType().desiredAssertionStatus() ^ true;
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    protected class AccessibleJEditorPaneHTML
    extends AccessibleJEditorPane {
        public AccessibleText getAccessibleText() {
            return new JEditorPaneAccessibleHypertextSupport();
        }

        protected AccessibleJEditorPaneHTML() {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    protected class AccessibleJEditorPane
    extends JTextComponent.AccessibleJTextComponent {
        public String getAccessibleDescription() {
            String descr = super.getAccessibleDescription();
            if (descr == null) {
                return JEditorPane.this.getContentType();
            }
            return descr;
        }

        public AccessibleStateSet getAccessibleStateSet() {
            AccessibleStateSet state = super.getAccessibleStateSet();
            return state;
        }

        protected AccessibleJEditorPane() {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    protected class JEditorPaneAccessibleHypertextSupport
    extends AccessibleJEditorPane
    implements AccessibleHypertext {
        public int getLinkCount() {
            HTMLDocument doc = (HTMLDocument)JEditorPane.this.getDocument();
            HTMLDocument.Iterator linkIter = doc.getIterator(HTML.Tag.A);
            int count = 0;
            while (linkIter.isValid()) {
                ++count;
                linkIter.next();
            }
            return count;
        }

        public AccessibleHyperlink getLink(int i) {
            HTMLDocument doc = (HTMLDocument)JEditorPane.this.getDocument();
            HTMLDocument.Iterator linkIter = doc.getIterator(HTML.Tag.A);
            int count = 0;
            while (linkIter.isValid()) {
                if (++count == i) break;
                linkIter.next();
            }
            if (linkIter.isValid()) {
                int offset = linkIter.getStartOffset();
                Element el = doc.getCharacterElement(offset);
                HTMLLink link = new HTMLLink(el);
                return link;
            }
            return null;
        }

        public int getLinkIndex(int c) {
            HTMLDocument doc = (HTMLDocument)JEditorPane.this.getDocument();
            HTMLDocument.Iterator linkIter = doc.getIterator(HTML.Tag.A);
            int count = 0;
            while (linkIter.isValid()) {
                if (linkIter.getStartOffset() <= c && linkIter.getEndOffset() > c) break;
                ++count;
                linkIter.next();
            }
            if (linkIter.isValid()) {
                return count;
            }
            return -1;
        }

        public String getLinkText(int i) {
            HTMLDocument doc = (HTMLDocument)JEditorPane.this.getDocument();
            HTMLDocument.Iterator linkIter = doc.getIterator(HTML.Tag.A);
            int count = 0;
            while (linkIter.isValid()) {
                if (++count == i) break;
                linkIter.next();
            }
            if (linkIter.isValid()) {
                int offset = linkIter.getStartOffset();
                Element el = doc.getCharacterElement(offset);
                try {
                    String text = doc.getText(el.getStartOffset(), el.getEndOffset() - el.getStartOffset());
                    return text;
                }
                catch (BadLocationException ex) {
                    throw (AssertionError)((Object)((Throwable)((Object)new AssertionError((Object)"BadLocationException must not be thrown here."))).initCause(ex));
                }
            }
            return null;
        }

        protected JEditorPaneAccessibleHypertextSupport() {
        }

        /*
         * Illegal identifiers - consider using --renameillegalidents true
         */
        public class HTMLLink
        extends AccessibleHyperlink {
            Element element;

            public boolean isValid() {
                HTMLDocument doc = (HTMLDocument)JEditorPane.this.getDocument();
                boolean bl = false;
                if (doc.getCharacterElement(this.element.getStartOffset()) == this.element) {
                    bl = true;
                }
                return bl;
            }

            public int getAccessibleActionCount() {
                return 1;
            }

            public boolean doAccessibleAction(int i) {
                String href = (String)this.element.getAttributes().getAttribute("href");
                HTMLDocument doc = (HTMLDocument)JEditorPane.this.getDocument();
                try {
                    URL url = new URL(doc.getBase(), href);
                    JEditorPane.this.setPage(url);
                    String desc = doc.getText(this.element.getStartOffset(), this.element.getEndOffset() - this.element.getStartOffset());
                    HyperlinkEvent ev = new HyperlinkEvent(JEditorPane.this, HyperlinkEvent.EventType.ACTIVATED, url, desc, this.element);
                    JEditorPane.this.fireHyperlinkUpdate(ev);
                    return true;
                }
                catch (Exception ex) {
                    return false;
                }
            }

            public String getAccessibleActionDescription(int i) {
                HTMLDocument doc = (HTMLDocument)JEditorPane.this.getDocument();
                try {
                    return doc.getText(this.element.getStartOffset(), this.element.getEndOffset() - this.element.getStartOffset());
                }
                catch (BadLocationException ex) {
                    throw (AssertionError)((Object)((Throwable)((Object)new AssertionError((Object)"BadLocationException must not be thrown here."))).initCause(ex));
                }
            }

            public Object getAccessibleActionObject(int i) {
                String href = (String)this.element.getAttributes().getAttribute("href");
                HTMLDocument doc = (HTMLDocument)JEditorPane.this.getDocument();
                try {
                    URL url = new URL(doc.getBase(), href);
                    return url;
                }
                catch (MalformedURLException ex) {
                    return null;
                }
            }

            public Object getAccessibleActionAnchor(int i) {
                return this.getAccessibleActionDescription(i);
            }

            public int getStartIndex() {
                return this.element.getStartOffset();
            }

            public int getEndIndex() {
                return this.element.getEndOffset();
            }

            public HTMLLink(Element el) {
                this.element = el;
            }
        }
    }
}

