/*
 * Decompiled with CFR 0.152.
 */
package gnu.xml.dom;

import gnu.xml.dom.DomAttr;
import gnu.xml.dom.DomDOMException;
import gnu.xml.dom.DomDoctype;
import gnu.xml.dom.DomDocument;
import gnu.xml.dom.DomNamedNodeMap;
import gnu.xml.dom.DomNode;
import gnu.xml.dom.DomNsNode;
import java.util.HashSet;
import java.util.Set;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.TypeInfo;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class DomElement
extends DomNsNode
implements Element {
    Set userIdAttrs;
    private DomNamedNodeMap attributes;
    String xmlSpace;

    public NamedNodeMap getAttributes() {
        if (this.attributes == null) {
            this.attributes = new DomNamedNodeMap(this, 2);
        }
        return this.attributes;
    }

    public boolean hasAttributes() {
        boolean bl = false;
        if (this.attributes != null && this.attributes.length != 0) {
            bl = true;
        }
        return bl;
    }

    public Object clone() {
        DomElement node2 = (DomElement)super.clone();
        if (this.attributes != null) {
            node2.attributes = new DomNamedNodeMap(node2, 2);
            DomNode ctx = this.attributes.first;
            while (ctx != null) {
                node2.attributes.setNamedItemNS(ctx.cloneNode(true));
                ctx = ctx.next;
            }
        }
        return node2;
    }

    void setOwner(DomDocument doc) {
        if (this.attributes != null) {
            DomNode ctx = this.attributes.first;
            while (ctx != null) {
                ctx.setOwner(doc);
                ctx = ctx.next;
            }
        }
        super.setOwner(doc);
    }

    public void makeReadonly() {
        super.makeReadonly();
        if (this.attributes != null) {
            this.attributes.makeReadonly();
        }
    }

    public final String getTagName() {
        return this.getNodeName();
    }

    public String getAttribute(String name) {
        if ("xml:space" == name) {
            return this.xmlSpace;
        }
        Attr attr = this.getAttributeNode(name);
        return attr == null ? "" : attr.getValue();
    }

    public boolean hasAttribute(String name) {
        boolean bl = false;
        if (this.getAttributeNode(name) != null) {
            bl = true;
        }
        return bl;
    }

    public boolean hasAttributeNS(String namespaceURI, String local) {
        boolean bl = false;
        if (this.getAttributeNodeNS(namespaceURI, local) != null) {
            bl = true;
        }
        return bl;
    }

    public String getAttributeNS(String namespaceURI, String local) {
        Attr attr = this.getAttributeNodeNS(namespaceURI, local);
        return attr == null ? "" : attr.getValue();
    }

    public Attr getAttributeNode(String name) {
        return this.attributes == null ? null : (Attr)this.attributes.getNamedItem(name);
    }

    public Attr getAttributeNodeNS(String namespace, String localPart) {
        return this.attributes == null ? null : (Attr)this.attributes.getNamedItemNS(namespace, localPart);
    }

    public void setAttribute(String name, String value) {
        Attr attr = this.getAttributeNode(name);
        if (attr != null) {
            attr.setNodeValue(value);
            ((DomAttr)attr).setSpecified(true);
            return;
        }
        attr = this.owner.createAttribute(name);
        attr.setNodeValue(value);
        this.setAttributeNode(attr);
    }

    public void setAttributeNS(String uri, String aname, String value) {
        if (("xmlns".equals(aname) || aname.startsWith("xmlns:")) && !"http://www.w3.org/2000/xmlns/".equals(uri)) {
            throw new DomDOMException(14, "setting xmlns attribute to illegal value", this, 0);
        }
        Attr attr = this.getAttributeNodeNS(uri, aname);
        if (attr != null) {
            attr.setNodeValue(value);
            return;
        }
        attr = this.owner.createAttributeNS(uri, aname);
        attr.setNodeValue(value);
        this.setAttributeNodeNS(attr);
    }

    public Attr setAttributeNode(Attr attr) {
        return (Attr)this.getAttributes().setNamedItem(attr);
    }

    public Attr setAttributeNodeNS(Attr attr) {
        return (Attr)this.getAttributes().setNamedItemNS(attr);
    }

    public void removeAttribute(String name) {
        block3: {
            if (this.attributes == null) {
                return;
            }
            try {
                this.attributes.removeNamedItem(name);
            }
            catch (DomDOMException e) {
                if (e.code == 8) break block3;
                throw e;
            }
        }
    }

    public Attr removeAttributeNode(Attr node2) {
        if (this.attributes == null) {
            throw new DomDOMException(8, null, node2, 0);
        }
        return (Attr)this.attributes.removeNamedItem(node2.getNodeName());
    }

    public void removeAttributeNS(String namespace, String localPart) {
        if (this.attributes == null) {
            throw new DomDOMException(8, localPart, null, 0);
        }
        this.attributes.removeNamedItemNS(namespace, localPart);
    }

    public String lookupPrefix(String namespaceURI) {
        if (namespaceURI == null) {
            return null;
        }
        String namespace = this.getNamespaceURI();
        if (namespace != null && namespace.equals(namespaceURI)) {
            return this.getPrefix();
        }
        if (this.attributes != null) {
            DomNode ctx = this.attributes.first;
            while (ctx != null) {
                String value;
                if ("http://www.w3.org/2000/xmlns/".equals(ctx.getNamespaceURI()) && (value = ctx.getNodeValue()).equals(namespaceURI)) {
                    return ctx.getLocalName();
                }
                ctx = ctx.next;
            }
        }
        return super.lookupPrefix(namespaceURI);
    }

    public boolean isDefaultNamespace(String namespaceURI) {
        String namespace = this.getNamespaceURI();
        if (namespace != null && namespace.equals(namespaceURI)) {
            boolean bl = false;
            if (this.getPrefix() == null) {
                bl = true;
            }
            return bl;
        }
        if (this.attributes != null) {
            DomNode ctx = this.attributes.first;
            while (ctx != null) {
                if ("http://www.w3.org/2000/xmlns/".equals(ctx.getNamespaceURI())) {
                    String qName = ctx.getNodeName();
                    return "xmlns".equals(qName);
                }
                ctx = ctx.next;
            }
        }
        return super.isDefaultNamespace(namespaceURI);
    }

    public String lookupNamespaceURI(String prefix) {
        String namespace = this.getNamespaceURI();
        if (namespace != null && this.equal(prefix, this.getPrefix())) {
            return namespace;
        }
        if (this.attributes != null) {
            DomNode ctx = this.attributes.first;
            while (ctx != null) {
                if ("http://www.w3.org/2000/xmlns/".equals(ctx.getNamespaceURI()) && (prefix == null ? "xmlns".equals(ctx.getNodeName()) : prefix.equals(ctx.getLocalName()))) {
                    return ctx.getNodeValue();
                }
                ctx = ctx.next;
            }
        }
        return super.lookupNamespaceURI(prefix);
    }

    public String getBaseURI() {
        Node xmlBase;
        if (this.attributes != null && (xmlBase = this.attributes.getNamedItemNS("http://www.w3.org/XML/1998/namespace", "base")) != null) {
            return xmlBase.getNodeValue();
        }
        return super.getBaseURI();
    }

    public TypeInfo getSchemaTypeInfo() {
        DomDoctype doctype = (DomDoctype)this.owner.getDoctype();
        if (doctype != null) {
            return doctype.getElementTypeInfo(this.getNodeName());
        }
        return null;
    }

    public void setIdAttribute(String name, boolean isId) {
        NamedNodeMap attrs = this.getAttributes();
        Attr attr = (Attr)attrs.getNamedItem(name);
        this.setIdAttributeNode(attr, isId);
    }

    public void setIdAttributeNode(Attr attr, boolean isId) {
        if (this.readonly) {
            throw new DomDOMException(7);
        }
        if (attr == null || attr.getOwnerElement() != this) {
            throw new DomDOMException(8);
        }
        if (isId) {
            if (this.userIdAttrs == null) {
                this.userIdAttrs = new HashSet();
            }
            this.userIdAttrs.add(attr);
        } else if (this.userIdAttrs != null) {
            this.userIdAttrs.remove(attr);
            if (this.userIdAttrs.isEmpty()) {
                this.userIdAttrs = null;
            }
        }
    }

    public void setIdAttributeNS(String namespaceURI, String localName, boolean isId) {
        NamedNodeMap attrs = this.getAttributes();
        Attr attr = (Attr)attrs.getNamedItemNS(namespaceURI, localName);
        this.setIdAttributeNode(attr, isId);
    }

    private final /* synthetic */ void this() {
        this.xmlSpace = "";
    }

    protected DomElement(DomDocument owner, String namespaceURI, String name) {
        super((short)1, owner, namespaceURI, name);
        this.this();
    }
}

