/*
 * Decompiled with CFR 0.152.
 */
package java.text;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Currency;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class DecimalFormatSymbols
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 5772796243397350300L;
    private String currencySymbol;
    private char decimalSeparator;
    private char digit;
    private char exponential;
    private char groupingSeparator;
    private String infinity;
    private String intlCurrencySymbol;
    private char minusSign;
    private char monetarySeparator;
    private String NaN;
    private char patternSeparator;
    private char percent;
    private char perMill;
    private int serialVersionOnStream;
    private char zeroDigit;
    private Locale locale;
    private transient Currency currency;

    public final Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    private final String safeGetString(ResourceBundle bundle, String name, String def) {
        if (bundle != null) {
            try {
                return bundle.getString(name);
            }
            catch (MissingResourceException x) {
                // empty catch block
            }
        }
        return def;
    }

    private final char safeGetChar(ResourceBundle bundle, String name, char def) {
        String r = null;
        if (bundle != null) {
            try {
                r = bundle.getString(name);
            }
            catch (MissingResourceException x) {
                // empty catch block
            }
        }
        if (r == null || r.length() < 1) {
            return def;
        }
        return r.charAt(0);
    }

    public final boolean equals(Object obj) {
        if (!(obj instanceof DecimalFormatSymbols)) {
            return false;
        }
        DecimalFormatSymbols dfs = (DecimalFormatSymbols)obj;
        boolean bl = false;
        if (this.currencySymbol.equals(dfs.currencySymbol) && this.decimalSeparator == dfs.decimalSeparator && this.digit == dfs.digit && this.exponential == dfs.exponential && this.groupingSeparator == dfs.groupingSeparator && this.infinity.equals(dfs.infinity) && this.intlCurrencySymbol.equals(dfs.intlCurrencySymbol) && this.minusSign == dfs.minusSign && this.monetarySeparator == dfs.monetarySeparator && this.NaN.equals(dfs.NaN) && this.patternSeparator == dfs.patternSeparator && this.percent == dfs.percent && this.perMill == dfs.perMill && this.zeroDigit == dfs.zeroDigit) {
            bl = true;
        }
        return bl;
    }

    public final Currency getCurrency() {
        return this.currency;
    }

    public final String getCurrencySymbol() {
        return this.currencySymbol;
    }

    public final char getDecimalSeparator() {
        return this.decimalSeparator;
    }

    public final char getDigit() {
        return this.digit;
    }

    final char getExponential() {
        return this.exponential;
    }

    public final char getGroupingSeparator() {
        return this.groupingSeparator;
    }

    public final String getInfinity() {
        return this.infinity;
    }

    public final String getInternationalCurrencySymbol() {
        return this.intlCurrencySymbol;
    }

    public final char getMinusSign() {
        return this.minusSign;
    }

    public final char getMonetaryDecimalSeparator() {
        return this.monetarySeparator;
    }

    public final String getNaN() {
        return this.NaN;
    }

    public final char getPatternSeparator() {
        return this.patternSeparator;
    }

    public final char getPercent() {
        return this.percent;
    }

    public final char getPerMill() {
        return this.perMill;
    }

    public final char getZeroDigit() {
        return this.zeroDigit;
    }

    public final int hashCode() {
        return this.zeroDigit << 16 + this.groupingSeparator << 8 + this.decimalSeparator;
    }

    public final void setCurrency(Currency currency) {
        this.intlCurrencySymbol = currency.getCurrencyCode();
        this.currencySymbol = currency.getSymbol();
        this.currency = currency;
    }

    public final void setCurrencySymbol(String currency) {
        this.currencySymbol = currency;
    }

    public final void setDecimalSeparator(char decimalSep) {
        this.decimalSeparator = decimalSep;
    }

    public final void setDigit(char digit) {
        this.digit = digit;
    }

    final void setExponential(char exp) {
        this.exponential = exp;
    }

    public final void setGroupingSeparator(char groupSep) {
        this.groupingSeparator = groupSep;
    }

    public final void setInfinity(String infinity) {
        this.infinity = infinity;
    }

    public final void setInternationalCurrencySymbol(String currencyCode) {
        this.intlCurrencySymbol = currencyCode;
        try {
            this.currency = Currency.getInstance(currencyCode);
        }
        catch (IllegalArgumentException exception) {
            this.currency = null;
        }
        if (this.currency != null) {
            this.setCurrencySymbol(this.currency.getSymbol(this.locale));
        }
    }

    public final void setMinusSign(char minusSign) {
        this.minusSign = minusSign;
    }

    public final void setMonetaryDecimalSeparator(char decimalSep) {
        this.monetarySeparator = decimalSep;
    }

    public final void setNaN(String nan) {
        this.NaN = nan;
    }

    public final void setPatternSeparator(char patternSep) {
        this.patternSeparator = patternSep;
    }

    public final void setPercent(char percent) {
        this.percent = percent;
    }

    public final void setPerMill(char perMill) {
        this.perMill = perMill;
    }

    public final void setZeroDigit(char zeroDigit) {
        this.zeroDigit = zeroDigit;
    }

    private final void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        if (this.serialVersionOnStream < 1) {
            this.monetarySeparator = this.decimalSeparator;
            this.exponential = (char)69;
        }
        if (this.serialVersionOnStream < 2) {
            this.locale = Locale.getDefault();
        }
        this.serialVersionOnStream = 2;
    }

    private final /* synthetic */ void this() {
        this.serialVersionOnStream = 2;
    }

    public DecimalFormatSymbols() {
        this(Locale.getDefault());
    }

    public DecimalFormatSymbols(Locale loc) {
        ResourceBundle res;
        this.this();
        this.currency = Currency.getInstance("XXX");
        this.currencySymbol = "?";
        this.intlCurrencySymbol = "XXX";
        try {
            res = ResourceBundle.getBundle("gnu.java.locale.LocaleInformation", loc, ClassLoader.getSystemClassLoader());
        }
        catch (MissingResourceException x) {
            res = null;
        }
        try {
            Currency localeCurrency = Currency.getInstance(loc);
            if (localeCurrency != null) {
                this.setCurrency(localeCurrency);
            }
        }
        catch (IllegalArgumentException exception) {
            // empty catch block
        }
        this.decimalSeparator = this.safeGetChar(res, "decimalSeparator", '.');
        this.digit = this.safeGetChar(res, "digit", '#');
        this.exponential = this.safeGetChar(res, "exponential", 'E');
        this.groupingSeparator = this.safeGetChar(res, "groupingSeparator", ',');
        this.infinity = this.safeGetString(res, "infinity", "\u221e");
        try {
            this.monetarySeparator = this.safeGetChar(res, "monetarySeparator", '.');
        }
        catch (MissingResourceException x) {
            this.monetarySeparator = this.decimalSeparator;
        }
        this.minusSign = this.safeGetChar(res, "minusSign", '-');
        this.NaN = this.safeGetString(res, "NaN", "\ufffd");
        this.patternSeparator = this.safeGetChar(res, "patternSeparator", ';');
        this.percent = this.safeGetChar(res, "percent", '%');
        this.perMill = this.safeGetChar(res, "perMill", '\u2030');
        this.zeroDigit = this.safeGetChar(res, "zeroDigit", '0');
        this.locale = loc;
    }
}

