/*
 * Decompiled with CFR 0.152.
 */
package java.util.prefs;

import gnu.java.util.prefs.NodeWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.TreeSet;
import java.util.prefs.BackingStoreException;
import java.util.prefs.NodeChangeListener;
import java.util.prefs.PreferenceChangeListener;
import java.util.prefs.Preferences;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class AbstractPreferences
extends Preferences {
    protected final Object lock;
    protected boolean newNode;
    private final AbstractPreferences parent;
    private final String name;
    private boolean removed;
    private HashMap childCache;

    public String absolutePath() {
        if (this.parent == null) {
            return "/";
        }
        return this.parent.path() + '/' + this.name;
    }

    private final String path() {
        if (this.parent == null) {
            return "";
        }
        return this.parent.path() + '/' + this.name;
    }

    public boolean isUserNode() {
        AbstractPreferences root = this;
        while (root.parent != null) {
            root = root.parent;
        }
        boolean bl = false;
        if (root == Preferences.userRoot()) {
            bl = true;
        }
        return bl;
    }

    public String name() {
        return this.name;
    }

    public String toString() {
        return (this.isUserNode() ? "User" : "System") + " Preference Node: " + this.absolutePath();
    }

    protected final AbstractPreferences[] cachedChildren() {
        return (AbstractPreferences[])this.childCache.values().toArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String[] childrenNames() throws BackingStoreException {
        Object object = this.lock;
        synchronized (object) {
            if (this.isRemoved()) {
                throw new IllegalStateException("Node removed");
            }
            TreeSet childrenNames = new TreeSet();
            childrenNames.addAll(this.childCache.keySet());
            String[] names = this.childrenNamesSpi();
            int i = 0;
            while (i < names.length) {
                childrenNames.add(names[i]);
                ++i;
            }
            Object[] children = new String[childrenNames.size()];
            childrenNames.toArray(children);
            return children;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Preferences node(String path) {
        Preferences preferences;
        block9: {
            block7: {
                Object object = this.lock;
                synchronized (object) {
                    if (this.isRemoved()) {
                        throw new IllegalStateException("Node removed");
                    }
                    if (!path.startsWith("/")) {
                        if (path.indexOf("//") == -1 && !path.endsWith("/")) {
                            return this.getNode(path);
                        }
                        throw new IllegalArgumentException(path);
                    }
                    // MONITOREXIT @DISABLED, blocks:[0, 1, 2] lbl12 : MonitorExitStatement: MONITOREXIT : var2_2
                    if (!this.isUserNode()) break block7;
                }
                preferences = AbstractPreferences.userRoot();
                break block9;
            }
            preferences = AbstractPreferences.systemRoot();
        }
        Preferences root = preferences;
        return root.node(path.substring(1));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final Preferences getNode(String path) {
        String childPath;
        String childName;
        if (path.length() == 0) {
            return this;
        }
        int nextSlash = path.indexOf(47);
        if (nextSlash == -1) {
            childName = path;
            childPath = "";
        } else {
            childName = path.substring(0, nextSlash);
            childPath = path.substring(nextSlash + 1);
        }
        AbstractPreferences child = (AbstractPreferences)this.childCache.get(childName);
        if (child == null) {
            if (childName.length() > 80) {
                throw new IllegalArgumentException(childName);
            }
            child = this.childSpi(childName);
            this.childCache.put(childName, child);
        }
        Object object = child.lock;
        synchronized (object) {
            return child.getNode(childPath);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean nodeExists(String path) throws BackingStoreException {
        Preferences preferences;
        block9: {
            block7: {
                Object object = this.lock;
                synchronized (object) {
                    if (this.isRemoved() && path.length() != 0) {
                        throw new IllegalStateException("Node removed");
                    }
                    if (!path.startsWith("/")) {
                        if (path.indexOf("//") == -1 && !path.endsWith("/")) {
                            return this.existsNode(path);
                        }
                        throw new IllegalArgumentException(path);
                    }
                    // MONITOREXIT @DISABLED, blocks:[0, 1, 2] lbl12 : MonitorExitStatement: MONITOREXIT : var2_2
                    if (!this.isUserNode()) break block7;
                }
                preferences = AbstractPreferences.userRoot();
                break block9;
            }
            preferences = AbstractPreferences.systemRoot();
        }
        Preferences root = preferences;
        return root.nodeExists(path.substring(1));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final boolean existsNode(String path) throws BackingStoreException {
        String childPath;
        String childName;
        if (path.length() == 0) {
            return this.isRemoved() ^ true;
        }
        int nextSlash = path.indexOf(47);
        if (nextSlash == -1) {
            childName = path;
            childPath = "";
        } else {
            childName = path.substring(0, nextSlash);
            childPath = path.substring(nextSlash + 1);
        }
        AbstractPreferences child = (AbstractPreferences)this.childCache.get(childName);
        if (child == null) {
            if (childName.length() > 80) {
                throw new IllegalArgumentException(childName);
            }
            child = this.getChild(childName);
            if (child == null) {
                return false;
            }
            this.childCache.put(childName, child);
        }
        Object object = child.lock;
        synchronized (object) {
            return child.existsNode(childPath);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected AbstractPreferences getChild(String name) throws BackingStoreException {
        Object object = this.lock;
        synchronized (object) {
            String[] names = this.childrenNamesSpi();
            int i = 0;
            while (i < names.length) {
                if (name.equals(names[i])) {
                    return this.childSpi(name);
                }
                ++i;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean isRemoved() {
        Object object = this.lock;
        synchronized (object) {
            return this.removed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Preferences parent() {
        Object object = this.lock;
        synchronized (object) {
            if (this.isRemoved()) {
                throw new IllegalStateException("Node removed");
            }
            return this.parent;
        }
    }

    public void exportNode(OutputStream os) throws BackingStoreException, IOException {
        NodeWriter nodeWriter = new NodeWriter((Preferences)this, os);
        nodeWriter.writePrefs();
    }

    public void exportSubtree(OutputStream os) throws BackingStoreException, IOException {
        NodeWriter nodeWriter = new NodeWriter((Preferences)this, os);
        nodeWriter.writePrefsTree();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String[] keys() throws BackingStoreException {
        Object object = this.lock;
        synchronized (object) {
            if (this.isRemoved()) {
                throw new IllegalStateException("Node removed");
            }
            return this.keysSpi();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String get(String key, String defaultVal) {
        if (key.length() > 80) {
            throw new IllegalArgumentException(key);
        }
        Object object = this.lock;
        synchronized (object) {
            String value;
            if (this.isRemoved()) {
                throw new IllegalStateException("Node removed");
            }
            try {
                value = this.getSpi(key);
            }
            catch (ThreadDeath death) {
                throw death;
            }
            catch (Throwable t) {
                value = null;
            }
            if (value != null) {
                return value;
            }
            return defaultVal;
        }
    }

    public boolean getBoolean(String key, boolean defaultVal) {
        String value = this.get(key, null);
        if ("true".equalsIgnoreCase(value)) {
            return true;
        }
        if ("false".equalsIgnoreCase(value)) {
            return false;
        }
        return defaultVal;
    }

    public byte[] getByteArray(String key, byte[] defaultVal) {
        String value = this.get(key, null);
        byte[] b = null;
        if (value != null) {
            b = AbstractPreferences.decode64(value);
        }
        if (b != null) {
            return b;
        }
        return defaultVal;
    }

    private static final byte[] decode64(String s) {
        ByteArrayOutputStream bs = new ByteArrayOutputStream(s.length() / 4 * 3);
        char[] c = new char[s.length()];
        s.getChars(0, s.length(), c, 0);
        int endchar = -1;
        int j = 0;
        while (j < c.length && endchar == -1) {
            if (c[j] >= 'A' && c[j] <= 'Z') {
                int n = j;
                c[n] = (char)(c[n] - 65);
            } else if (c[j] >= 'a' && c[j] <= 'z') {
                c[j] = (char)(c[j] + 26 - 97);
            } else if (c[j] >= '0' && c[j] <= '9') {
                c[j] = (char)(c[j] + 52 - 48);
            } else if (c[j] == '+') {
                c[j] = 62;
            } else if (c[j] == '/') {
                c[j] = 63;
            } else if (c[j] == '=') {
                endchar = j;
            } else {
                return null;
            }
            ++j;
        }
        int remaining = endchar == -1 ? c.length : endchar;
        int i = 0;
        while (remaining > 0) {
            byte b0 = (byte)(c[i] << 2);
            if (remaining >= 2) {
                b0 = (byte)(b0 + ((c[i + 1] & 0x30) >> 4));
            }
            bs.write(b0);
            if (remaining >= 3) {
                byte b1 = (byte)((c[i + 1] & 0xF) << 4);
                b1 = (byte)(b1 + (byte)((c[i + 2] & 0x3C) >> 2));
                bs.write(b1);
            }
            if (remaining >= 4) {
                byte b2 = (byte)((c[i + 2] & 3) << 6);
                b2 = (byte)(b2 + c[i + 3]);
                bs.write(b2);
            }
            i += 4;
            remaining -= 4;
        }
        return bs.toByteArray();
    }

    public double getDouble(String key, double defaultVal) {
        String value = this.get(key, null);
        if (value != null) {
            try {
                return Double.parseDouble(value);
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
        }
        return defaultVal;
    }

    public float getFloat(String key, float defaultVal) {
        String value = this.get(key, null);
        if (value != null) {
            try {
                return Float.parseFloat(value);
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
        }
        return defaultVal;
    }

    public int getInt(String key, int defaultVal) {
        String value = this.get(key, null);
        if (value != null) {
            try {
                return Integer.parseInt(value);
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
        }
        return defaultVal;
    }

    public long getLong(String key, long defaultVal) {
        String value = this.get(key, null);
        if (value != null) {
            try {
                return Long.parseLong(value);
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
        }
        return defaultVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void put(String key, String value) {
        if (key.length() > 80 || value.length() > 8192) {
            throw new IllegalArgumentException("key (" + key.length() + ") or value (" + value.length() + ") to large");
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.isRemoved()) {
                throw new IllegalStateException("Node removed");
            }
            this.putSpi(key, value);
            return;
        }
    }

    public void putBoolean(String key, boolean value) {
        this.put(key, String.valueOf(value));
    }

    public void putByteArray(String key, byte[] value) {
        this.put(key, AbstractPreferences.encode64(value));
    }

    private static final String encode64(byte[] b) {
        StringBuffer sb = new StringBuffer(b.length / 3 * 4);
        int i = 0;
        int remaining = b.length;
        char[] c = new char[4];
        while (remaining > 0) {
            c[0] = (char)((b[i] & 0xFC) >> 2);
            c[1] = (char)((b[i] & 3) << 4);
            if (remaining >= 2) {
                c[1] = (char)(c[1] + (char)((b[i + 1] & 0xF0) >> 4));
                c[2] = (char)((b[i + 1] & 0xF) << 2);
                if (remaining >= 3) {
                    c[2] = (char)(c[2] + (char)((b[i + 2] & 0xC0) >> 6));
                    c[3] = (char)(b[i + 2] & 0x3F);
                } else {
                    c[3] = 64;
                }
            } else {
                c[2] = 64;
                c[3] = 64;
            }
            int j = 0;
            while (j < 4) {
                if (c[j] < '\u001a') {
                    int n = j;
                    c[n] = (char)(c[n] + 65);
                } else {
                    c[j] = c[j] < '4' ? (int)(c[j] - 26 + 97) : (c[j] < '>' ? (int)(c[j] - 52 + 48) : (c[j] == '>' ? 43 : (c[j] == '?' ? 47 : 61)));
                }
                ++j;
            }
            sb.append(c);
            i += 3;
            remaining -= 3;
        }
        return sb.toString();
    }

    public void putDouble(String key, double value) {
        this.put(key, Double.toString(value));
    }

    public void putFloat(String key, float value) {
        this.put(key, Float.toString(value));
    }

    public void putInt(String key, int value) {
        this.put(key, Integer.toString(value));
    }

    public void putLong(String key, long value) {
        this.put(key, Long.toString(value));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void remove(String key) {
        if (key.length() > 80) {
            throw new IllegalArgumentException(key);
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.isRemoved()) {
                throw new IllegalStateException("Node removed");
            }
            this.removeSpi(key);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void clear() throws BackingStoreException {
        Object object = this.lock;
        synchronized (object) {
            if (this.isRemoved()) {
                throw new IllegalStateException("Node Removed");
            }
            String[] keys = this.keys();
            int i = 0;
            while (i < keys.length) {
                this.removeSpi(keys[i]);
                ++i;
            }
            return;
        }
    }

    public void flush() throws BackingStoreException {
        this.flushNode(false);
    }

    public void sync() throws BackingStoreException {
        this.flushNode(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private final void flushNode(boolean sync) throws BackingStoreException {
        String[] keys;
        block8: {
            block7: {
                keys = null;
                Object object = this.lock;
                // MONITORENTER : object
                if (!sync) break block7;
                this.syncSpi();
                break block8;
            }
            this.flushSpi();
        }
        keys = (String[])this.childCache.keySet().toArray(new String[0]);
        // MONITOREXIT : object
        if (keys == null) return;
        int i = 0;
        while (i < keys.length) {
            block9: {
                AbstractPreferences subNode;
                AbstractPreferences abstractPreferences = this;
                // MONITORENTER : abstractPreferences
                {
                    subNode = (AbstractPreferences)this.childCache.get(keys[i]);
                    // MONITOREXIT : abstractPreferences
                    if (subNode == null) break block9;
                }
                subNode.flushNode(sync);
            }
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void removeNode() throws BackingStoreException {
        if (this.parent == null) {
            throw new UnsupportedOperationException("Cannot remove root node");
        }
        AbstractPreferences abstractPreferences = this.parent;
        synchronized (abstractPreferences) {
            AbstractPreferences abstractPreferences2 = this;
            synchronized (abstractPreferences2) {
                if (this.isRemoved()) {
                    throw new IllegalStateException("Node Removed");
                }
                this.purge();
                // MONITOREXIT @DISABLED, blocks:[0, 1, 2, 3] lbl12 : MonitorExitStatement: MONITOREXIT : var3_2
                this.parent.childCache.remove(this.name);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void purge() throws BackingStoreException {
        String[] children = this.childrenNamesSpi();
        int i = 0;
        while (i < children.length) {
            if (this.childCache.get(children[i]) == null) {
                this.childCache.put(children[i], this.childSpi(children[i]));
            }
            ++i;
        }
        Iterator i2 = this.childCache.values().iterator();
        while (i2.hasNext()) {
            AbstractPreferences node2 = (AbstractPreferences)i2.next();
            AbstractPreferences abstractPreferences = node2;
            synchronized (abstractPreferences) {
                node2.purge();
            }
        }
        this.childCache.clear();
        this.removeNodeSpi();
        this.removed = true;
    }

    public void addNodeChangeListener(NodeChangeListener listener) {
    }

    public void addPreferenceChangeListener(PreferenceChangeListener listener) {
    }

    public void removeNodeChangeListener(NodeChangeListener listener) {
    }

    public void removePreferenceChangeListener(PreferenceChangeListener listener) {
    }

    protected abstract String[] childrenNamesSpi() throws BackingStoreException;

    protected abstract AbstractPreferences childSpi(String var1);

    protected abstract String[] keysSpi() throws BackingStoreException;

    protected abstract String getSpi(String var1);

    protected abstract void putSpi(String var1, String var2);

    protected abstract void removeSpi(String var1);

    protected abstract void flushSpi() throws BackingStoreException;

    protected abstract void syncSpi() throws BackingStoreException;

    protected abstract void removeNodeSpi() throws BackingStoreException;

    private final /* synthetic */ void this() {
        this.lock = new Object();
        this.newNode = false;
        this.removed = false;
        this.childCache = new HashMap();
    }

    protected AbstractPreferences(AbstractPreferences parent, String name) {
        this.this();
        if (name == null || name.length() > 80 || parent == null && name.length() != 0 || parent != null && name.length() == 0 || name.indexOf(47) != -1) {
            throw new IllegalArgumentException("Illegal name argument '" + name + "' (parent is " + (parent == null ? "" : "not ") + "null)");
        }
        this.parent = parent;
        this.name = name;
    }
}

