/*
 * Decompiled with CFR 0.152.
 */
package javax.sound.midi;

import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MidiMessage;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class MetaMessage
extends MidiMessage {
    public static final int META = 255;
    private int lengthLength;

    public void setMessage(int type, byte[] data, int length) throws InvalidMidiDataException {
        if (type > 127) {
            throw new InvalidMidiDataException("Meta type 0x" + Integer.toHexString(type) + " must be less than 128");
        }
        this.lengthLength = 0;
        int lengthValue = length;
        do {
            ++this.lengthLength;
        } while ((lengthValue >>= 7) > 0);
        this.length = 2 + this.lengthLength + length;
        this.data = new byte[this.length];
        this.data[0] = -1;
        this.data[1] = (byte)type;
        long buffer = length & 0x7F;
        while ((length >>= 7) > 0) {
            buffer <<= 8;
            buffer |= (long)(length & 0x7F | 0x80);
        }
        int index = 2;
        while (true) {
            this.data[index++] = (byte)(buffer & 0xFFL);
            if ((buffer & 0x80L) == 0L) break;
            buffer >>= 8;
        }
        System.arraycopy(data, 0, this.data, index, length);
    }

    public int getType() {
        return this.data[1];
    }

    public byte[] getData() {
        int dataLength = this.length - 2 - this.lengthLength;
        byte[] result = new byte[dataLength];
        System.arraycopy(this.data, 2 + this.lengthLength, result, 0, dataLength);
        return result;
    }

    public Object clone() {
        byte[] message = new byte[this.length];
        System.arraycopy(this.data, 0, message, 0, this.length);
        return new MetaMessage(message);
    }

    private final /* synthetic */ void this() {
        this.lengthLength = 0;
    }

    public MetaMessage() {
        super(new byte[4]);
        this.this();
        this.data[0] = -1;
        this.data[1] = 0;
        this.data[2] = 1;
        this.data[3] = 0;
        this.lengthLength = 1;
    }

    public MetaMessage(byte[] data) {
        super(data);
        this.this();
        int index = 2;
        this.lengthLength = 1;
        while ((data[index++] & 0x80) > 0) {
            ++this.lengthLength;
        }
    }
}

