/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.jtransforms.fft;

import edu.emory.mathcs.jtransforms.fft.DoubleFFT_1D;
import edu.emory.mathcs.utils.ConcurrencyUtils;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public class DoubleFFT_2D {
    private int n1;
    private int n2;
    private int[] ip;
    private double[] w;
    private double[] t;
    private DoubleFFT_1D fftn2;
    private DoubleFFT_1D fftn1;
    private int oldNthread;
    private int nt;

    public DoubleFFT_2D(int n, int n2) {
        if (!ConcurrencyUtils.isPowerOf2(n) || !ConcurrencyUtils.isPowerOf2(n2)) {
            throw new IllegalArgumentException("n1, n2 must be power of two numbers");
        }
        if (n <= 1 || n2 <= 1) {
            throw new IllegalArgumentException("n1, n2 must be greater than 1");
        }
        this.n1 = n;
        this.n2 = n2;
        this.ip = new int[2 + (int)Math.ceil(Math.sqrt(Math.max(n, n2)))];
        this.w = new double[(int)Math.ceil(Math.max(Math.max(n / 2, n2 / 2), Math.max(n / 2, n2 / 4) + n2 / 4))];
        this.fftn2 = new DoubleFFT_1D(n2, this.ip, this.w);
        this.fftn1 = new DoubleFFT_1D(n, this.ip, this.w);
        this.oldNthread = ConcurrencyUtils.getNumberOfProcessors();
        this.nt = 8 * this.oldNthread * n;
        if (2 * n2 == 4 * this.oldNthread) {
            this.nt >>= 1;
        } else if (2 * n2 < 4 * this.oldNthread) {
            this.nt >>= 2;
        }
        this.t = new double[this.nt];
    }

    public void complexForward(double[] dArray) {
        int n;
        int n2 = this.n2;
        this.n2 = 2 * this.n2;
        int n3 = this.n1 << 1;
        if (n3 < this.n2) {
            n3 = this.n2;
        }
        if (n3 > this.ip[0] << 2) {
            this.makewt(n3 >> 2);
        }
        if ((n = ConcurrencyUtils.getNumberOfProcessors()) != this.oldNthread) {
            this.nt = 8 * n * this.n1;
            if (this.n2 == 4 * n) {
                this.nt >>= 1;
            } else if (this.n2 < 4 * n) {
                this.nt >>= 2;
            }
            this.t = new double[this.nt];
            this.oldNthread = n;
        }
        if (n > 1 && this.n1 * n2 >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            this.xdft2d0_subth1(0, -1, dArray, true);
            this.cdft2d_subth(-1, dArray, true);
        } else {
            for (int i = 0; i < this.n1; ++i) {
                this.fftn2.complexForward(dArray, i * this.n2);
            }
            this.cdft2d_sub(-1, dArray, true);
        }
        this.n2 = n2;
    }

    public void complexForward(double[][] dArray) {
        int n;
        int n2 = this.n2;
        this.n2 = 2 * this.n2;
        int n3 = this.n1 << 1;
        if (n3 < this.n2) {
            n3 = this.n2;
        }
        if (n3 > this.ip[0] << 2) {
            this.makewt(n3 >> 2);
        }
        if ((n = ConcurrencyUtils.getNumberOfProcessors()) != this.oldNthread) {
            this.nt = 8 * n * this.n1;
            if (this.n2 == 4 * n) {
                this.nt >>= 1;
            } else if (this.n2 < 4 * n) {
                this.nt >>= 2;
            }
            this.t = new double[this.nt];
            this.oldNthread = n;
        }
        if (n > 1 && this.n1 * n2 >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            this.xdft2d0_subth1(0, -1, dArray, true);
            this.cdft2d_subth(-1, dArray, true);
        } else {
            for (int i = 0; i < this.n1; ++i) {
                this.fftn2.complexForward(dArray[i]);
            }
            this.cdft2d_sub(-1, dArray, true);
        }
        this.n2 = n2;
    }

    public void complexInverse(double[] dArray, boolean bl) {
        int n;
        int n2 = this.n2;
        this.n2 = 2 * this.n2;
        int n3 = this.n1 << 1;
        if (n3 < this.n2) {
            n3 = this.n2;
        }
        if (n3 > this.ip[0] << 2) {
            this.makewt(n3 >> 2);
        }
        if ((n = ConcurrencyUtils.getNumberOfProcessors()) != this.oldNthread) {
            this.nt = 8 * n * this.n1;
            if (this.n2 == 4 * n) {
                this.nt >>= 1;
            } else if (this.n2 < 4 * n) {
                this.nt >>= 2;
            }
            this.t = new double[this.nt];
            this.oldNthread = n;
        }
        if (n > 1 && this.n1 * n2 >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            this.xdft2d0_subth1(0, 1, dArray, bl);
            this.cdft2d_subth(1, dArray, bl);
        } else {
            for (int i = 0; i < this.n1; ++i) {
                this.fftn2.complexInverse(dArray, i * this.n2, bl);
            }
            this.cdft2d_sub(1, dArray, bl);
        }
        this.n2 = n2;
    }

    public void complexInverse(double[][] dArray, boolean bl) {
        int n;
        int n2 = this.n2;
        this.n2 = 2 * this.n2;
        int n3 = this.n1 << 1;
        if (n3 < this.n2) {
            n3 = this.n2;
        }
        if (n3 > this.ip[0] << 2) {
            this.makewt(n3 >> 2);
        }
        if ((n = ConcurrencyUtils.getNumberOfProcessors()) != this.oldNthread) {
            this.nt = 8 * n * this.n1;
            if (this.n2 == 4 * n) {
                this.nt >>= 1;
            } else if (this.n2 < 4 * n) {
                this.nt >>= 2;
            }
            this.t = new double[this.nt];
            this.oldNthread = n;
        }
        if (n > 1 && this.n1 * n2 >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            this.xdft2d0_subth1(0, 1, dArray, bl);
            this.cdft2d_subth(1, dArray, bl);
        } else {
            for (int i = 0; i < this.n1; ++i) {
                this.fftn2.complexInverse(dArray[i], bl);
            }
            this.cdft2d_sub(1, dArray, bl);
        }
        this.n2 = n2;
    }

    public void realForward(double[] dArray) {
        int n;
        int n2;
        int n3;
        int n4 = this.n1 << 1;
        if (n4 < this.n2) {
            n4 = this.n2;
        }
        if (n4 > (n3 = this.ip[0]) << 2) {
            n3 = n4 >> 2;
            this.makewt(n3);
        }
        if (this.n2 > (n2 = this.ip[1]) << 2) {
            n2 = this.n2 >> 2;
            this.makect(n2, this.w, n3);
        }
        if ((n = ConcurrencyUtils.getNumberOfProcessors()) != this.oldNthread) {
            this.nt = 8 * n * this.n1;
            if (this.n2 == 4 * n) {
                this.nt >>= 1;
            } else if (this.n2 < 4 * n) {
                this.nt >>= 2;
            }
            this.t = new double[this.nt];
            this.oldNthread = n;
        }
        if (n > 1 && this.n1 * this.n2 >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            this.xdft2d0_subth1(1, 1, dArray, true);
            this.cdft2d_subth(-1, dArray, true);
            this.rdft2d_sub(1, dArray);
        } else {
            for (int i = 0; i < this.n1; ++i) {
                this.fftn2.realForward(dArray, i * this.n2);
            }
            this.cdft2d_sub(-1, dArray, true);
            this.rdft2d_sub(1, dArray);
        }
    }

    public void realForward(double[][] dArray) {
        int n;
        int n2;
        int n3;
        int n4 = this.n1 << 1;
        if (n4 < this.n2) {
            n4 = this.n2;
        }
        if (n4 > (n3 = this.ip[0]) << 2) {
            n3 = n4 >> 2;
            this.makewt(n3);
        }
        if (this.n2 > (n2 = this.ip[1]) << 2) {
            n2 = this.n2 >> 2;
            this.makect(n2, this.w, n3);
        }
        if ((n = ConcurrencyUtils.getNumberOfProcessors()) != this.oldNthread) {
            this.nt = 8 * n * this.n1;
            if (this.n2 == 4 * n) {
                this.nt >>= 1;
            } else if (this.n2 < 4 * n) {
                this.nt >>= 2;
            }
            this.t = new double[this.nt];
            this.oldNthread = n;
        }
        if (n > 1 && this.n1 * this.n2 >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            this.xdft2d0_subth1(1, 1, dArray, true);
            this.cdft2d_subth(-1, dArray, true);
            this.rdft2d_sub(1, dArray);
        } else {
            for (int i = 0; i < this.n1; ++i) {
                this.fftn2.realForward(dArray[i]);
            }
            this.cdft2d_sub(-1, dArray, true);
            this.rdft2d_sub(1, dArray);
        }
    }

    public void realForwardFull(double[] dArray) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7 = this.n1 << 1;
        if (n7 < this.n2) {
            n7 = this.n2;
        }
        if (n7 > (n6 = this.ip[0]) << 2) {
            n6 = n7 >> 2;
            this.makewt(n6);
        }
        if (this.n2 > (n5 = this.ip[1]) << 2) {
            n5 = this.n2 >> 2;
            this.makect(n5, this.w, n6);
        }
        if ((n4 = ConcurrencyUtils.getNumberOfProcessors()) != this.oldNthread) {
            this.nt = 8 * n4 * this.n1;
            if (this.n2 == 4 * n4) {
                this.nt >>= 1;
            } else if (this.n2 < 4 * n4) {
                this.nt >>= 2;
            }
            this.t = new double[this.nt];
            this.oldNthread = n4;
        }
        if (n4 > 1 && this.n1 * this.n2 >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            this.xdft2d0_subth1(1, 1, dArray, true);
            this.cdft2d_subth(-1, dArray, true);
            this.rdft2d_sub(1, dArray);
        } else {
            for (int i = 0; i < this.n1; ++i) {
                this.fftn2.realForward(dArray, i * this.n2);
            }
            this.cdft2d_sub(-1, dArray, true);
            this.rdft2d_sub(1, dArray);
        }
        int n8 = 2 * this.n2;
        int n9 = this.n1 / 2;
        for (n3 = this.n1 - 1; n3 >= 1; --n3) {
            int n10 = n3 * this.n2;
            n2 = 2 * n10;
            for (n = 0; n < this.n2; n += 2) {
                dArray[n2 + n] = dArray[n10 + n];
                dArray[n10 + n] = 0.0;
                dArray[n2 + n + 1] = dArray[n10 + n + 1];
                dArray[n10 + n + 1] = 0.0;
            }
        }
        if (n4 > 1 && this.n1 * this.n2 >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            this.fillSymmetric(dArray);
        } else {
            int n11;
            for (n3 = 1; n3 < n9; ++n3) {
                n2 = n3 * n8;
                n11 = (this.n1 - n3) * n8;
                dArray[n2 + this.n2] = dArray[n11 + 1];
                dArray[n2 + this.n2 + 1] = -dArray[n11];
            }
            for (n3 = 1; n3 < n9; ++n3) {
                for (n = this.n2 + 2; n < n8; n += 2) {
                    n2 = n3 * n8;
                    n11 = (this.n1 - n3) * n8;
                    dArray[n2 + n] = dArray[n11 + n8 - n];
                    dArray[n2 + n + 1] = -dArray[n11 + n8 - n + 1];
                }
            }
            for (n3 = 0; n3 <= this.n1 / 2; ++n3) {
                for (n = 0; n < n8; n += 2) {
                    n2 = n3 * n8 + n;
                    n11 = (this.n1 - n3) % this.n1 * n8 + (n8 - n) % n8;
                    dArray[n11] = dArray[n2];
                    dArray[n11 + 1] = -dArray[n2 + 1];
                }
            }
        }
        dArray[this.n2] = -dArray[1];
        dArray[1] = 0.0;
        dArray[n9 * n8 + this.n2] = -dArray[n9 * n8 + 1];
        dArray[n9 * n8 + 1] = 0.0;
        dArray[n9 * n8 + this.n2 + 1] = 0.0;
    }

    public void realForwardFull(double[][] dArray) {
        int n;
        int n2;
        int n3;
        int n4 = this.n1 << 1;
        if (n4 < this.n2) {
            n4 = this.n2;
        }
        if (n4 > (n3 = this.ip[0]) << 2) {
            n3 = n4 >> 2;
            this.makewt(n3);
        }
        if (this.n2 > (n2 = this.ip[1]) << 2) {
            n2 = this.n2 >> 2;
            this.makect(n2, this.w, n3);
        }
        if ((n = ConcurrencyUtils.getNumberOfProcessors()) != this.oldNthread) {
            this.nt = 8 * n * this.n1;
            if (this.n2 == 4 * n) {
                this.nt >>= 1;
            } else if (this.n2 < 4 * n) {
                this.nt >>= 2;
            }
            this.t = new double[this.nt];
            this.oldNthread = n;
        }
        if (n > 1 && this.n1 * this.n2 >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            this.xdft2d0_subth1(1, 1, dArray, true);
            this.cdft2d_subth(-1, dArray, true);
            this.rdft2d_sub(1, dArray);
        } else {
            for (int i = 0; i < this.n1; ++i) {
                this.fftn2.realForward(dArray[i]);
            }
            this.cdft2d_sub(-1, dArray, true);
            this.rdft2d_sub(1, dArray);
        }
        int n5 = 2 * this.n2;
        int n6 = this.n1 / 2;
        if (n > 1 && this.n1 * this.n2 >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            this.fillSymmetric(dArray);
        } else {
            int n7;
            int n8;
            for (n8 = 1; n8 < n6; ++n8) {
                dArray[n8][this.n2] = dArray[this.n1 - n8][1];
                dArray[n8][this.n2 + 1] = -dArray[this.n1 - n8][0];
            }
            for (n8 = 1; n8 < n6; ++n8) {
                for (n7 = this.n2 + 2; n7 < n5; n7 += 2) {
                    dArray[n8][n7] = dArray[this.n1 - n8][n5 - n7];
                    dArray[n8][n7 + 1] = -dArray[this.n1 - n8][n5 - n7 + 1];
                }
            }
            for (n8 = 0; n8 <= this.n1 / 2; ++n8) {
                for (n7 = 0; n7 < n5; n7 += 2) {
                    dArray[(this.n1 - n8) % this.n1][(n5 - n7) % n5] = dArray[n8][n7];
                    dArray[(this.n1 - n8) % this.n1][(n5 - n7) % n5 + 1] = -dArray[n8][n7 + 1];
                }
            }
        }
        dArray[0][this.n2] = -dArray[0][1];
        dArray[0][1] = 0.0;
        dArray[n6][this.n2] = -dArray[n6][1];
        dArray[n6][1] = 0.0;
        dArray[n6][this.n2 + 1] = 0.0;
    }

    public void realInverse(double[] dArray, boolean bl) {
        int n;
        int n2;
        int n3;
        int n4 = this.n1 << 1;
        if (n4 < this.n2) {
            n4 = this.n2;
        }
        if (n4 > (n3 = this.ip[0]) << 2) {
            n3 = n4 >> 2;
            this.makewt(n3);
        }
        if (this.n2 > (n2 = this.ip[1]) << 2) {
            n2 = this.n2 >> 2;
            this.makect(n2, this.w, n3);
        }
        if ((n = ConcurrencyUtils.getNumberOfProcessors()) != this.oldNthread) {
            this.nt = 8 * n * this.n1;
            if (this.n2 == 4 * n) {
                this.nt >>= 1;
            } else if (this.n2 < 4 * n) {
                this.nt >>= 2;
            }
            this.t = new double[this.nt];
            this.oldNthread = n;
        }
        if (n > 1 && this.n1 * this.n2 >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            this.rdft2d_sub(-1, dArray);
            this.cdft2d_subth(1, dArray, bl);
            this.xdft2d0_subth1(1, -1, dArray, bl);
        } else {
            this.rdft2d_sub(-1, dArray);
            this.cdft2d_sub(1, dArray, bl);
            for (int i = 0; i < this.n1; ++i) {
                this.fftn2.realInverse(dArray, i * this.n2, bl);
            }
        }
    }

    public void realInverse(double[][] dArray, boolean bl) {
        int n;
        int n2;
        int n3;
        int n4 = this.n1 << 1;
        if (n4 < this.n2) {
            n4 = this.n2;
        }
        if (n4 > (n3 = this.ip[0]) << 2) {
            n3 = n4 >> 2;
            this.makewt(n3);
        }
        if (this.n2 > (n2 = this.ip[1]) << 2) {
            n2 = this.n2 >> 2;
            this.makect(n2, this.w, n3);
        }
        if ((n = ConcurrencyUtils.getNumberOfProcessors()) != this.oldNthread) {
            this.nt = 8 * n * this.n1;
            if (this.n2 == 4 * n) {
                this.nt >>= 1;
            } else if (this.n2 < 4 * n) {
                this.nt >>= 2;
            }
            this.t = new double[this.nt];
            this.oldNthread = n;
        }
        if (n > 1 && this.n1 * this.n2 >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            this.rdft2d_sub(-1, dArray);
            this.cdft2d_subth(1, dArray, bl);
            this.xdft2d0_subth1(1, -1, dArray, bl);
        } else {
            this.rdft2d_sub(-1, dArray);
            this.cdft2d_sub(1, dArray, bl);
            for (int i = 0; i < this.n1; ++i) {
                this.fftn2.realInverse(dArray[i], bl);
            }
        }
    }

    public void realInverseFull(double[] dArray, boolean bl) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7 = this.n1 << 1;
        if (n7 < this.n2) {
            n7 = this.n2;
        }
        if (n7 > (n6 = this.ip[0]) << 2) {
            n6 = n7 >> 2;
            this.makewt(n6);
        }
        if (this.n2 > (n5 = this.ip[1]) << 2) {
            n5 = this.n2 >> 2;
            this.makect(n5, this.w, n6);
        }
        if ((n4 = ConcurrencyUtils.getNumberOfProcessors()) != this.oldNthread) {
            this.nt = 8 * n4 * this.n1;
            if (this.n2 == 4 * n4) {
                this.nt >>= 1;
            } else if (this.n2 < 4 * n4) {
                this.nt >>= 2;
            }
            this.t = new double[this.nt];
            this.oldNthread = n4;
        }
        if (n4 > 1 && this.n1 * this.n2 >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            this.xdft2d0_subth2(1, -1, dArray, bl);
            this.cdft2d_subth(1, dArray, bl);
            this.rdft2d_sub(1, dArray);
        } else {
            for (int i = 0; i < this.n1; ++i) {
                this.fftn2.realInverse2(dArray, i * this.n2, bl);
            }
            this.cdft2d_sub(1, dArray, bl);
            this.rdft2d_sub(1, dArray);
        }
        int n8 = 2 * this.n2;
        int n9 = this.n1 / 2;
        for (n3 = this.n1 - 1; n3 >= 1; --n3) {
            int n10 = n3 * this.n2;
            n2 = 2 * n10;
            for (n = 0; n < this.n2; n += 2) {
                dArray[n2 + n] = dArray[n10 + n];
                dArray[n10 + n] = 0.0;
                dArray[n2 + n + 1] = dArray[n10 + n + 1];
                dArray[n10 + n + 1] = 0.0;
            }
        }
        if (n4 > 1 && this.n1 * this.n2 >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            this.fillSymmetric(dArray);
        } else {
            int n11;
            for (n3 = 1; n3 < n9; ++n3) {
                n2 = n3 * n8;
                n11 = (this.n1 - n3) * n8;
                dArray[n2 + this.n2] = dArray[n11 + 1];
                dArray[n2 + this.n2 + 1] = -dArray[n11];
            }
            for (n3 = 1; n3 < n9; ++n3) {
                for (n = this.n2 + 2; n < n8; n += 2) {
                    n2 = n3 * n8;
                    n11 = (this.n1 - n3) * n8;
                    dArray[n2 + n] = dArray[n11 + n8 - n];
                    dArray[n2 + n + 1] = -dArray[n11 + n8 - n + 1];
                }
            }
            for (n3 = 0; n3 <= this.n1 / 2; ++n3) {
                for (n = 0; n < n8; n += 2) {
                    n2 = n3 * n8 + n;
                    n11 = (this.n1 - n3) % this.n1 * n8 + (n8 - n) % n8;
                    dArray[n11] = dArray[n2];
                    dArray[n11 + 1] = -dArray[n2 + 1];
                }
            }
        }
        dArray[this.n2] = -dArray[1];
        dArray[1] = 0.0;
        dArray[n9 * n8 + this.n2] = -dArray[n9 * n8 + 1];
        dArray[n9 * n8 + 1] = 0.0;
        dArray[n9 * n8 + this.n2 + 1] = 0.0;
    }

    public void realInverseFull(double[][] dArray, boolean bl) {
        int n;
        int n2;
        int n3;
        int n4 = this.n1 << 1;
        if (n4 < this.n2) {
            n4 = this.n2;
        }
        if (n4 > (n3 = this.ip[0]) << 2) {
            n3 = n4 >> 2;
            this.makewt(n3);
        }
        if (this.n2 > (n2 = this.ip[1]) << 2) {
            n2 = this.n2 >> 2;
            this.makect(n2, this.w, n3);
        }
        if ((n = ConcurrencyUtils.getNumberOfProcessors()) != this.oldNthread) {
            this.nt = 8 * n * this.n1;
            if (this.n2 == 4 * n) {
                this.nt >>= 1;
            } else if (this.n2 < 4 * n) {
                this.nt >>= 2;
            }
            this.t = new double[this.nt];
            this.oldNthread = n;
        }
        if (n > 1 && this.n1 * this.n2 >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            this.xdft2d0_subth2(1, -1, dArray, bl);
            this.cdft2d_subth(1, dArray, bl);
            this.rdft2d_sub(1, dArray);
        } else {
            for (int i = 0; i < this.n1; ++i) {
                this.fftn2.realInverse2(dArray[i], 0, bl);
            }
            this.cdft2d_sub(1, dArray, bl);
            this.rdft2d_sub(1, dArray);
        }
        int n5 = 2 * this.n2;
        int n6 = this.n1 / 2;
        if (n > 1 && this.n1 * this.n2 >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            this.fillSymmetric(dArray);
        } else {
            int n7;
            int n8;
            for (n8 = 1; n8 < n6; ++n8) {
                dArray[n8][this.n2] = dArray[this.n1 - n8][1];
                dArray[n8][this.n2 + 1] = -dArray[this.n1 - n8][0];
            }
            for (n8 = 1; n8 < n6; ++n8) {
                for (n7 = this.n2 + 2; n7 < n5; n7 += 2) {
                    dArray[n8][n7] = dArray[this.n1 - n8][n5 - n7];
                    dArray[n8][n7 + 1] = -dArray[this.n1 - n8][n5 - n7 + 1];
                }
            }
            for (n8 = 0; n8 <= this.n1 / 2; ++n8) {
                for (n7 = 0; n7 < n5; n7 += 2) {
                    dArray[(this.n1 - n8) % this.n1][(n5 - n7) % n5] = dArray[n8][n7];
                    dArray[(this.n1 - n8) % this.n1][(n5 - n7) % n5 + 1] = -dArray[n8][n7 + 1];
                }
            }
        }
        dArray[0][this.n2] = -dArray[0][1];
        dArray[0][1] = 0.0;
        dArray[n6][this.n2] = -dArray[n6][1];
        dArray[n6][1] = 0.0;
        dArray[n6][this.n2 + 1] = 0.0;
    }

    private void makewt(int n) {
        this.ip[0] = n;
        this.ip[1] = 1;
        if (n > 2) {
            int n2;
            int n3 = n >> 1;
            double d = Math.atan(1.0) / (double)n3;
            double d2 = Math.cos(d * (double)n3);
            this.w[0] = 1.0;
            this.w[1] = d2;
            if (n3 == 4) {
                this.w[2] = Math.cos(d * 2.0);
                this.w[3] = Math.sin(d * 2.0);
            } else if (n3 > 4) {
                this.makeipt(n);
                this.w[2] = 0.5 / Math.cos(d * 2.0);
                this.w[3] = 0.5 / Math.cos(d * 6.0);
                for (n2 = 4; n2 < n3; n2 += 4) {
                    this.w[n2] = Math.cos(d * (double)n2);
                    this.w[n2 + 1] = Math.sin(d * (double)n2);
                    this.w[n2 + 2] = Math.cos(3.0 * d * (double)n2);
                    this.w[n2 + 3] = -Math.sin(3.0 * d * (double)n2);
                }
            }
            int n4 = 0;
            while (n3 > 2) {
                double d3;
                double d4;
                int n5 = n4 + n3;
                this.w[n5] = 1.0;
                this.w[n5 + 1] = d2;
                if ((n3 >>= 1) == 4) {
                    d4 = this.w[n4 + 4];
                    d3 = this.w[n4 + 5];
                    this.w[n5 + 2] = d4;
                    this.w[n5 + 3] = d3;
                } else if (n3 > 4) {
                    d4 = this.w[n4 + 4];
                    double d5 = this.w[n4 + 6];
                    this.w[n5 + 2] = 0.5 / d4;
                    this.w[n5 + 3] = 0.5 / d5;
                    for (n2 = 4; n2 < n3; n2 += 4) {
                        int n6 = n4 + 2 * n2;
                        int n7 = n5 + n2;
                        d4 = this.w[n6];
                        d3 = this.w[n6 + 1];
                        d5 = this.w[n6 + 2];
                        double d6 = this.w[n6 + 3];
                        this.w[n7] = d4;
                        this.w[n7 + 1] = d3;
                        this.w[n7 + 2] = d5;
                        this.w[n7 + 3] = d6;
                    }
                }
                n4 = n5;
            }
        }
    }

    private void makeipt(int n) {
        this.ip[2] = 0;
        this.ip[3] = 16;
        int n2 = 2;
        for (int i = n; i > 32; i >>= 2) {
            int n3 = n2 << 1;
            int n4 = n3 << 3;
            for (int j = n2; j < n3; ++j) {
                int n5;
                this.ip[n2 + j] = n5 = this.ip[j] << 2;
                this.ip[n3 + j] = n5 + n4;
            }
            n2 = n3;
        }
    }

    private void makect(int n, double[] dArray, int n2) {
        this.ip[1] = n;
        if (n > 1) {
            int n3 = n >> 1;
            double d = Math.atan(1.0) / (double)n3;
            dArray[n2] = Math.cos(d * (double)n3);
            dArray[n2 + n3] = 0.5 * dArray[n2];
            for (int i = 1; i < n3; ++i) {
                dArray[n2 + i] = 0.5 * Math.cos(d * (double)i);
                dArray[n2 + n - i] = 0.5 * Math.sin(d * (double)i);
            }
        }
    }

    private void rdft2d_sub(int n, double[] dArray) {
        int n2 = this.n1 >> 1;
        if (n < 0) {
            for (int i = 1; i < n2; ++i) {
                int n3 = this.n1 - i;
                int n4 = i * this.n2;
                int n5 = n3 * this.n2;
                double d = dArray[n4] - dArray[n5];
                int n6 = n4;
                dArray[n6] = dArray[n6] + dArray[n5];
                dArray[n5] = d;
                d = dArray[n5 + 1] - dArray[n4 + 1];
                int n7 = n4 + 1;
                dArray[n7] = dArray[n7] + dArray[n5 + 1];
                dArray[n5 + 1] = d;
            }
        } else {
            for (int i = 1; i < n2; ++i) {
                int n8 = this.n1 - i;
                int n9 = i * this.n2;
                int n10 = n8 * this.n2;
                dArray[n10] = 0.5 * (dArray[n9] - dArray[n10]);
                int n11 = n9;
                dArray[n11] = dArray[n11] - dArray[n10];
                dArray[n10 + 1] = 0.5 * (dArray[n9 + 1] + dArray[n10 + 1]);
                int n12 = n9 + 1;
                dArray[n12] = dArray[n12] - dArray[n10 + 1];
            }
        }
    }

    private void rdft2d_sub(int n, double[][] dArray) {
        int n2 = this.n1 >> 1;
        if (n < 0) {
            for (int i = 1; i < n2; ++i) {
                int n3 = this.n1 - i;
                double d = dArray[i][0] - dArray[n3][0];
                double[] dArray2 = dArray[i];
                dArray2[0] = dArray2[0] + dArray[n3][0];
                dArray[n3][0] = d;
                d = dArray[n3][1] - dArray[i][1];
                double[] dArray3 = dArray[i];
                dArray3[1] = dArray3[1] + dArray[n3][1];
                dArray[n3][1] = d;
            }
        } else {
            for (int i = 1; i < n2; ++i) {
                int n4 = this.n1 - i;
                dArray[n4][0] = 0.5 * (dArray[i][0] - dArray[n4][0]);
                double[] dArray4 = dArray[i];
                dArray4[0] = dArray4[0] - dArray[n4][0];
                dArray[n4][1] = 0.5 * (dArray[i][1] + dArray[n4][1]);
                double[] dArray5 = dArray[i];
                dArray5[1] = dArray5[1] - dArray[n4][1];
            }
        }
    }

    private void cdft2d_sub(int n, double[] dArray, boolean bl) {
        block21: {
            block19: {
                int n2;
                int n3;
                int n4;
                block22: {
                    int n5;
                    int n6;
                    int n7;
                    int n8;
                    block20: {
                        if (n != -1) break block19;
                        if (this.n2 <= 4) break block20;
                        for (int i = 0; i < this.n2; i += 8) {
                            int n9;
                            int n10;
                            int n11;
                            int n12;
                            int n13;
                            int n14;
                            for (n14 = 0; n14 < this.n1; ++n14) {
                                n13 = n14 * this.n2 + i;
                                n12 = 2 * n14;
                                n11 = 2 * this.n1 + 2 * n14;
                                n10 = n11 + 2 * this.n1;
                                n9 = n10 + 2 * this.n1;
                                this.t[n12] = dArray[n13];
                                this.t[n12 + 1] = dArray[n13 + 1];
                                this.t[n11] = dArray[n13 + 2];
                                this.t[n11 + 1] = dArray[n13 + 3];
                                this.t[n10] = dArray[n13 + 4];
                                this.t[n10 + 1] = dArray[n13 + 5];
                                this.t[n9] = dArray[n13 + 6];
                                this.t[n9 + 1] = dArray[n13 + 7];
                            }
                            this.fftn1.complexForward(this.t, 0);
                            this.fftn1.complexForward(this.t, 2 * this.n1);
                            this.fftn1.complexForward(this.t, 4 * this.n1);
                            this.fftn1.complexForward(this.t, 6 * this.n1);
                            for (n14 = 0; n14 < this.n1; ++n14) {
                                n13 = n14 * this.n2 + i;
                                n12 = 2 * n14;
                                n11 = 2 * this.n1 + 2 * n14;
                                n10 = n11 + 2 * this.n1;
                                n9 = n10 + 2 * this.n1;
                                dArray[n13] = this.t[n12];
                                dArray[n13 + 1] = this.t[n12 + 1];
                                dArray[n13 + 2] = this.t[n11];
                                dArray[n13 + 3] = this.t[n11 + 1];
                                dArray[n13 + 4] = this.t[n10];
                                dArray[n13 + 5] = this.t[n10 + 1];
                                dArray[n13 + 6] = this.t[n9];
                                dArray[n13 + 7] = this.t[n9 + 1];
                            }
                        }
                        break block21;
                    }
                    if (this.n2 != 4) break block22;
                    for (n8 = 0; n8 < this.n1; ++n8) {
                        n7 = n8 * this.n2;
                        n6 = 2 * n8;
                        n5 = 2 * this.n1 + 2 * n8;
                        this.t[n6] = dArray[n7];
                        this.t[n6 + 1] = dArray[n7 + 1];
                        this.t[n5] = dArray[n7 + 2];
                        this.t[n5 + 1] = dArray[n7 + 3];
                    }
                    this.fftn1.complexForward(this.t, 0);
                    this.fftn1.complexForward(this.t, 2 * this.n1);
                    for (n8 = 0; n8 < this.n1; ++n8) {
                        n7 = n8 * this.n2;
                        n6 = 2 * n8;
                        n5 = 2 * this.n1 + 2 * n8;
                        dArray[n7] = this.t[n6];
                        dArray[n7 + 1] = this.t[n6 + 1];
                        dArray[n7 + 2] = this.t[n5];
                        dArray[n7 + 3] = this.t[n5 + 1];
                    }
                    break block21;
                }
                if (this.n2 != 2) break block21;
                for (n4 = 0; n4 < this.n1; ++n4) {
                    n3 = n4 * this.n2;
                    n2 = 2 * n4;
                    this.t[n2] = dArray[n3];
                    this.t[n2 + 1] = dArray[n3 + 1];
                }
                this.fftn1.complexForward(this.t, 0);
                for (n4 = 0; n4 < this.n1; ++n4) {
                    n3 = n4 * this.n2;
                    n2 = 2 * n4;
                    dArray[n3] = this.t[n2];
                    dArray[n3 + 1] = this.t[n2 + 1];
                }
                break block21;
            }
            if (this.n2 > 4) {
                for (int i = 0; i < this.n2; i += 8) {
                    int n15;
                    int n16;
                    int n17;
                    int n18;
                    int n19;
                    int n20;
                    for (n20 = 0; n20 < this.n1; ++n20) {
                        n19 = n20 * this.n2 + i;
                        n18 = 2 * n20;
                        n17 = 2 * this.n1 + 2 * n20;
                        n16 = n17 + 2 * this.n1;
                        n15 = n16 + 2 * this.n1;
                        this.t[n18] = dArray[n19];
                        this.t[n18 + 1] = dArray[n19 + 1];
                        this.t[n17] = dArray[n19 + 2];
                        this.t[n17 + 1] = dArray[n19 + 3];
                        this.t[n16] = dArray[n19 + 4];
                        this.t[n16 + 1] = dArray[n19 + 5];
                        this.t[n15] = dArray[n19 + 6];
                        this.t[n15 + 1] = dArray[n19 + 7];
                    }
                    this.fftn1.complexInverse(this.t, 0, bl);
                    this.fftn1.complexInverse(this.t, 2 * this.n1, bl);
                    this.fftn1.complexInverse(this.t, 4 * this.n1, bl);
                    this.fftn1.complexInverse(this.t, 6 * this.n1, bl);
                    for (n20 = 0; n20 < this.n1; ++n20) {
                        n19 = n20 * this.n2 + i;
                        n18 = 2 * n20;
                        n17 = 2 * this.n1 + 2 * n20;
                        n16 = n17 + 2 * this.n1;
                        n15 = n16 + 2 * this.n1;
                        dArray[n19] = this.t[n18];
                        dArray[n19 + 1] = this.t[n18 + 1];
                        dArray[n19 + 2] = this.t[n17];
                        dArray[n19 + 3] = this.t[n17 + 1];
                        dArray[n19 + 4] = this.t[n16];
                        dArray[n19 + 5] = this.t[n16 + 1];
                        dArray[n19 + 6] = this.t[n15];
                        dArray[n19 + 7] = this.t[n15 + 1];
                    }
                }
            } else if (this.n2 == 4) {
                int n21;
                int n22;
                int n23;
                int n24;
                for (n24 = 0; n24 < this.n1; ++n24) {
                    n23 = n24 * this.n2;
                    n22 = 2 * n24;
                    n21 = 2 * this.n1 + 2 * n24;
                    this.t[n22] = dArray[n23];
                    this.t[n22 + 1] = dArray[n23 + 1];
                    this.t[n21] = dArray[n23 + 2];
                    this.t[n21 + 1] = dArray[n23 + 3];
                }
                this.fftn1.complexInverse(this.t, 0, bl);
                this.fftn1.complexInverse(this.t, 2 * this.n1, bl);
                for (n24 = 0; n24 < this.n1; ++n24) {
                    n23 = n24 * this.n2;
                    n22 = 2 * n24;
                    n21 = 2 * this.n1 + 2 * n24;
                    dArray[n23] = this.t[n22];
                    dArray[n23 + 1] = this.t[n22 + 1];
                    dArray[n23 + 2] = this.t[n21];
                    dArray[n23 + 3] = this.t[n21 + 1];
                }
            } else if (this.n2 == 2) {
                int n25;
                int n26;
                int n27;
                for (n27 = 0; n27 < this.n1; ++n27) {
                    n26 = n27 * this.n2;
                    n25 = 2 * n27;
                    this.t[n25] = dArray[n26];
                    this.t[n25 + 1] = dArray[n26 + 1];
                }
                this.fftn1.complexInverse(this.t, 0, bl);
                for (n27 = 0; n27 < this.n1; ++n27) {
                    n26 = n27 * this.n2;
                    n25 = 2 * n27;
                    dArray[n26] = this.t[n25];
                    dArray[n26 + 1] = this.t[n25 + 1];
                }
            }
        }
    }

    private void cdft2d_sub(int n, double[][] dArray, boolean bl) {
        block21: {
            block19: {
                int n2;
                int n3;
                block22: {
                    int n4;
                    int n5;
                    int n6;
                    block20: {
                        if (n != -1) break block19;
                        if (this.n2 <= 4) break block20;
                        for (int i = 0; i < this.n2; i += 8) {
                            int n7;
                            int n8;
                            int n9;
                            int n10;
                            int n11;
                            for (n11 = 0; n11 < this.n1; ++n11) {
                                n10 = 2 * n11;
                                n9 = 2 * this.n1 + 2 * n11;
                                n8 = n9 + 2 * this.n1;
                                n7 = n8 + 2 * this.n1;
                                this.t[n10] = dArray[n11][i];
                                this.t[n10 + 1] = dArray[n11][i + 1];
                                this.t[n9] = dArray[n11][i + 2];
                                this.t[n9 + 1] = dArray[n11][i + 3];
                                this.t[n8] = dArray[n11][i + 4];
                                this.t[n8 + 1] = dArray[n11][i + 5];
                                this.t[n7] = dArray[n11][i + 6];
                                this.t[n7 + 1] = dArray[n11][i + 7];
                            }
                            this.fftn1.complexForward(this.t, 0);
                            this.fftn1.complexForward(this.t, 2 * this.n1);
                            this.fftn1.complexForward(this.t, 4 * this.n1);
                            this.fftn1.complexForward(this.t, 6 * this.n1);
                            for (n11 = 0; n11 < this.n1; ++n11) {
                                n10 = 2 * n11;
                                n9 = 2 * this.n1 + 2 * n11;
                                n8 = n9 + 2 * this.n1;
                                n7 = n8 + 2 * this.n1;
                                dArray[n11][i] = this.t[n10];
                                dArray[n11][i + 1] = this.t[n10 + 1];
                                dArray[n11][i + 2] = this.t[n9];
                                dArray[n11][i + 3] = this.t[n9 + 1];
                                dArray[n11][i + 4] = this.t[n8];
                                dArray[n11][i + 5] = this.t[n8 + 1];
                                dArray[n11][i + 6] = this.t[n7];
                                dArray[n11][i + 7] = this.t[n7 + 1];
                            }
                        }
                        break block21;
                    }
                    if (this.n2 != 4) break block22;
                    for (n6 = 0; n6 < this.n1; ++n6) {
                        n5 = 2 * n6;
                        n4 = 2 * this.n1 + 2 * n6;
                        this.t[n5] = dArray[n6][0];
                        this.t[n5 + 1] = dArray[n6][1];
                        this.t[n4] = dArray[n6][2];
                        this.t[n4 + 1] = dArray[n6][3];
                    }
                    this.fftn1.complexForward(this.t, 0);
                    this.fftn1.complexForward(this.t, 2 * this.n1);
                    for (n6 = 0; n6 < this.n1; ++n6) {
                        n5 = 2 * n6;
                        n4 = 2 * this.n1 + 2 * n6;
                        dArray[n6][0] = this.t[n5];
                        dArray[n6][1] = this.t[n5 + 1];
                        dArray[n6][2] = this.t[n4];
                        dArray[n6][3] = this.t[n4 + 1];
                    }
                    break block21;
                }
                if (this.n2 != 2) break block21;
                for (n3 = 0; n3 < this.n1; ++n3) {
                    n2 = 2 * n3;
                    this.t[n2] = dArray[n3][0];
                    this.t[n2 + 1] = dArray[n3][1];
                }
                this.fftn1.complexForward(this.t, 0);
                for (n3 = 0; n3 < this.n1; ++n3) {
                    n2 = 2 * n3;
                    dArray[n3][0] = this.t[n2];
                    dArray[n3][1] = this.t[n2 + 1];
                }
                break block21;
            }
            if (this.n2 > 4) {
                for (int i = 0; i < this.n2; i += 8) {
                    int n12;
                    int n13;
                    int n14;
                    int n15;
                    int n16;
                    for (n16 = 0; n16 < this.n1; ++n16) {
                        n15 = 2 * n16;
                        n14 = 2 * this.n1 + 2 * n16;
                        n13 = n14 + 2 * this.n1;
                        n12 = n13 + 2 * this.n1;
                        this.t[n15] = dArray[n16][i];
                        this.t[n15 + 1] = dArray[n16][i + 1];
                        this.t[n14] = dArray[n16][i + 2];
                        this.t[n14 + 1] = dArray[n16][i + 3];
                        this.t[n13] = dArray[n16][i + 4];
                        this.t[n13 + 1] = dArray[n16][i + 5];
                        this.t[n12] = dArray[n16][i + 6];
                        this.t[n12 + 1] = dArray[n16][i + 7];
                    }
                    this.fftn1.complexInverse(this.t, 0, bl);
                    this.fftn1.complexInverse(this.t, 2 * this.n1, bl);
                    this.fftn1.complexInverse(this.t, 4 * this.n1, bl);
                    this.fftn1.complexInverse(this.t, 6 * this.n1, bl);
                    for (n16 = 0; n16 < this.n1; ++n16) {
                        n15 = 2 * n16;
                        n14 = 2 * this.n1 + 2 * n16;
                        n13 = n14 + 2 * this.n1;
                        n12 = n13 + 2 * this.n1;
                        dArray[n16][i] = this.t[n15];
                        dArray[n16][i + 1] = this.t[n15 + 1];
                        dArray[n16][i + 2] = this.t[n14];
                        dArray[n16][i + 3] = this.t[n14 + 1];
                        dArray[n16][i + 4] = this.t[n13];
                        dArray[n16][i + 5] = this.t[n13 + 1];
                        dArray[n16][i + 6] = this.t[n12];
                        dArray[n16][i + 7] = this.t[n12 + 1];
                    }
                }
            } else if (this.n2 == 4) {
                int n17;
                int n18;
                int n19;
                for (n19 = 0; n19 < this.n1; ++n19) {
                    n18 = 2 * n19;
                    n17 = 2 * this.n1 + 2 * n19;
                    this.t[n18] = dArray[n19][0];
                    this.t[n18 + 1] = dArray[n19][1];
                    this.t[n17] = dArray[n19][2];
                    this.t[n17 + 1] = dArray[n19][3];
                }
                this.fftn1.complexInverse(this.t, 0, bl);
                this.fftn1.complexInverse(this.t, 2 * this.n1, bl);
                for (n19 = 0; n19 < this.n1; ++n19) {
                    n18 = 2 * n19;
                    n17 = 2 * this.n1 + 2 * n19;
                    dArray[n19][0] = this.t[n18];
                    dArray[n19][1] = this.t[n18 + 1];
                    dArray[n19][2] = this.t[n17];
                    dArray[n19][3] = this.t[n17 + 1];
                }
            } else if (this.n2 == 2) {
                int n20;
                int n21;
                for (n21 = 0; n21 < this.n1; ++n21) {
                    n20 = 2 * n21;
                    this.t[n20] = dArray[n21][0];
                    this.t[n20 + 1] = dArray[n21][1];
                }
                this.fftn1.complexInverse(this.t, 0, bl);
                for (n21 = 0; n21 < this.n1; ++n21) {
                    n20 = 2 * n21;
                    dArray[n21][0] = this.t[n20];
                    dArray[n21][1] = this.t[n20 + 1];
                }
            }
        }
    }

    private void xdft2d0_subth1(final int n, final int n2, final double[] dArray, final boolean bl) {
        int n3;
        int n4 = ConcurrencyUtils.getNumberOfProcessors();
        final int n5 = n4 > this.n1 ? this.n1 : n4;
        Future[] futureArray = new Future[n5];
        for (int i = 0; i < n5; ++i) {
            n3 = i;
            futureArray[i] = ConcurrencyUtils.threadPool.submit(new Runnable(){

                public void run() {
                    if (n == 0) {
                        if (n2 == -1) {
                            for (int i = n3; i < DoubleFFT_2D.this.n1; i += n5) {
                                DoubleFFT_2D.this.fftn2.complexForward(dArray, i * DoubleFFT_2D.this.n2);
                            }
                        } else {
                            for (int i = n3; i < DoubleFFT_2D.this.n1; i += n5) {
                                DoubleFFT_2D.this.fftn2.complexInverse(dArray, i * DoubleFFT_2D.this.n2, bl);
                            }
                        }
                    } else if (n2 == 1) {
                        for (int i = n3; i < DoubleFFT_2D.this.n1; i += n5) {
                            DoubleFFT_2D.this.fftn2.realForward(dArray, i * DoubleFFT_2D.this.n2);
                        }
                    } else {
                        for (int i = n3; i < DoubleFFT_2D.this.n1; i += n5) {
                            DoubleFFT_2D.this.fftn2.realInverse(dArray, i * DoubleFFT_2D.this.n2, bl);
                        }
                    }
                }
            });
        }
        try {
            for (n3 = 0; n3 < n5; ++n3) {
                futureArray[n3].get();
            }
        }
        catch (ExecutionException executionException) {
            executionException.printStackTrace();
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
    }

    private void xdft2d0_subth2(final int n, final int n2, final double[] dArray, final boolean bl) {
        int n3;
        int n4 = ConcurrencyUtils.getNumberOfProcessors();
        final int n5 = n4 > this.n1 ? this.n1 : n4;
        Future[] futureArray = new Future[n5];
        for (int i = 0; i < n5; ++i) {
            n3 = i;
            futureArray[i] = ConcurrencyUtils.threadPool.submit(new Runnable(){

                public void run() {
                    if (n == 0) {
                        if (n2 == -1) {
                            for (int i = n3; i < DoubleFFT_2D.this.n1; i += n5) {
                                DoubleFFT_2D.this.fftn2.complexForward(dArray, i * DoubleFFT_2D.this.n2);
                            }
                        } else {
                            for (int i = n3; i < DoubleFFT_2D.this.n1; i += n5) {
                                DoubleFFT_2D.this.fftn2.complexInverse(dArray, i * DoubleFFT_2D.this.n2, bl);
                            }
                        }
                    } else if (n2 == 1) {
                        for (int i = n3; i < DoubleFFT_2D.this.n1; i += n5) {
                            DoubleFFT_2D.this.fftn2.realForward(dArray, i * DoubleFFT_2D.this.n2);
                        }
                    } else {
                        for (int i = n3; i < DoubleFFT_2D.this.n1; i += n5) {
                            DoubleFFT_2D.this.fftn2.realInverse2(dArray, i * DoubleFFT_2D.this.n2, bl);
                        }
                    }
                }
            });
        }
        try {
            for (n3 = 0; n3 < n5; ++n3) {
                futureArray[n3].get();
            }
        }
        catch (ExecutionException executionException) {
            executionException.printStackTrace();
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
    }

    private void xdft2d0_subth1(final int n, final int n2, final double[][] dArray, final boolean bl) {
        int n3;
        int n4 = ConcurrencyUtils.getNumberOfProcessors();
        final int n5 = n4 > this.n1 ? this.n1 : n4;
        Future[] futureArray = new Future[n5];
        for (int i = 0; i < n5; ++i) {
            n3 = i;
            futureArray[i] = ConcurrencyUtils.threadPool.submit(new Runnable(){

                public void run() {
                    if (n == 0) {
                        if (n2 == -1) {
                            for (int i = n3; i < DoubleFFT_2D.this.n1; i += n5) {
                                DoubleFFT_2D.this.fftn2.complexForward(dArray[i]);
                            }
                        } else {
                            for (int i = n3; i < DoubleFFT_2D.this.n1; i += n5) {
                                DoubleFFT_2D.this.fftn2.complexInverse(dArray[i], bl);
                            }
                        }
                    } else if (n2 == 1) {
                        for (int i = n3; i < DoubleFFT_2D.this.n1; i += n5) {
                            DoubleFFT_2D.this.fftn2.realForward(dArray[i]);
                        }
                    } else {
                        for (int i = n3; i < DoubleFFT_2D.this.n1; i += n5) {
                            DoubleFFT_2D.this.fftn2.realInverse(dArray[i], bl);
                        }
                    }
                }
            });
        }
        try {
            for (n3 = 0; n3 < n5; ++n3) {
                futureArray[n3].get();
            }
        }
        catch (ExecutionException executionException) {
            executionException.printStackTrace();
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
    }

    private void xdft2d0_subth2(final int n, final int n2, final double[][] dArray, final boolean bl) {
        int n3;
        int n4 = ConcurrencyUtils.getNumberOfProcessors();
        final int n5 = n4 > this.n1 ? this.n1 : n4;
        Future[] futureArray = new Future[n5];
        for (int i = 0; i < n5; ++i) {
            n3 = i;
            futureArray[i] = ConcurrencyUtils.threadPool.submit(new Runnable(){

                public void run() {
                    if (n == 0) {
                        if (n2 == -1) {
                            for (int i = n3; i < DoubleFFT_2D.this.n1; i += n5) {
                                DoubleFFT_2D.this.fftn2.complexForward(dArray[i]);
                            }
                        } else {
                            for (int i = n3; i < DoubleFFT_2D.this.n1; i += n5) {
                                DoubleFFT_2D.this.fftn2.complexInverse(dArray[i], bl);
                            }
                        }
                    } else if (n2 == 1) {
                        for (int i = n3; i < DoubleFFT_2D.this.n1; i += n5) {
                            DoubleFFT_2D.this.fftn2.realForward(dArray[i]);
                        }
                    } else {
                        for (int i = n3; i < DoubleFFT_2D.this.n1; i += n5) {
                            DoubleFFT_2D.this.fftn2.realInverse2(dArray[i], 0, bl);
                        }
                    }
                }
            });
        }
        try {
            for (n3 = 0; n3 < n5; ++n3) {
                futureArray[n3].get();
            }
        }
        catch (ExecutionException executionException) {
            executionException.printStackTrace();
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
    }

    private void cdft2d_subth(final int n, final double[] dArray, final boolean bl) {
        int n2;
        int n3;
        int n4 = n3 = ConcurrencyUtils.getNumberOfProcessors();
        int n5 = 8 * this.n1;
        if (this.n2 == 4 * n3) {
            n5 >>= 1;
        } else if (this.n2 < 4 * n3) {
            n4 = this.n2 >> 1;
            n5 >>= 2;
        }
        Future[] futureArray = new Future[n4];
        final int n6 = n4;
        for (int i = 0; i < n4; ++i) {
            n2 = i;
            final int n7 = n5 * i;
            futureArray[i] = ConcurrencyUtils.threadPool.submit(new Runnable(){

                public void run() {
                    block21: {
                        block19: {
                            int n24;
                            int n25;
                            int n3;
                            block22: {
                                int n4;
                                int n5;
                                int n62;
                                int n72;
                                block20: {
                                    if (n != -1) break block19;
                                    if (DoubleFFT_2D.this.n2 <= 4 * n6) break block20;
                                    for (int i = 8 * n2; i < DoubleFFT_2D.this.n2; i += 8 * n6) {
                                        int n8;
                                        int n9;
                                        int n10;
                                        int n11;
                                        int n12;
                                        int n13;
                                        for (n13 = 0; n13 < DoubleFFT_2D.this.n1; ++n13) {
                                            n12 = n13 * DoubleFFT_2D.this.n2 + i;
                                            n11 = n7 + 2 * n13;
                                            n10 = n7 + 2 * DoubleFFT_2D.this.n1 + 2 * n13;
                                            n9 = n10 + 2 * DoubleFFT_2D.this.n1;
                                            n8 = n9 + 2 * DoubleFFT_2D.this.n1;
                                            ((DoubleFFT_2D)DoubleFFT_2D.this).t[n11] = dArray[n12];
                                            ((DoubleFFT_2D)DoubleFFT_2D.this).t[n11 + 1] = dArray[n12 + 1];
                                            ((DoubleFFT_2D)DoubleFFT_2D.this).t[n10] = dArray[n12 + 2];
                                            ((DoubleFFT_2D)DoubleFFT_2D.this).t[n10 + 1] = dArray[n12 + 3];
                                            ((DoubleFFT_2D)DoubleFFT_2D.this).t[n9] = dArray[n12 + 4];
                                            ((DoubleFFT_2D)DoubleFFT_2D.this).t[n9 + 1] = dArray[n12 + 5];
                                            ((DoubleFFT_2D)DoubleFFT_2D.this).t[n8] = dArray[n12 + 6];
                                            ((DoubleFFT_2D)DoubleFFT_2D.this).t[n8 + 1] = dArray[n12 + 7];
                                        }
                                        DoubleFFT_2D.this.fftn1.complexForward(DoubleFFT_2D.this.t, n7);
                                        DoubleFFT_2D.this.fftn1.complexForward(DoubleFFT_2D.this.t, n7 + 2 * DoubleFFT_2D.this.n1);
                                        DoubleFFT_2D.this.fftn1.complexForward(DoubleFFT_2D.this.t, n7 + 4 * DoubleFFT_2D.this.n1);
                                        DoubleFFT_2D.this.fftn1.complexForward(DoubleFFT_2D.this.t, n7 + 6 * DoubleFFT_2D.this.n1);
                                        for (n13 = 0; n13 < DoubleFFT_2D.this.n1; ++n13) {
                                            n12 = n13 * DoubleFFT_2D.this.n2 + i;
                                            n11 = n7 + 2 * n13;
                                            n10 = n7 + 2 * DoubleFFT_2D.this.n1 + 2 * n13;
                                            n9 = n10 + 2 * DoubleFFT_2D.this.n1;
                                            n8 = n9 + 2 * DoubleFFT_2D.this.n1;
                                            dArray[n12] = DoubleFFT_2D.this.t[n11];
                                            dArray[n12 + 1] = DoubleFFT_2D.this.t[n11 + 1];
                                            dArray[n12 + 2] = DoubleFFT_2D.this.t[n10];
                                            dArray[n12 + 3] = DoubleFFT_2D.this.t[n10 + 1];
                                            dArray[n12 + 4] = DoubleFFT_2D.this.t[n9];
                                            dArray[n12 + 5] = DoubleFFT_2D.this.t[n9 + 1];
                                            dArray[n12 + 6] = DoubleFFT_2D.this.t[n8];
                                            dArray[n12 + 7] = DoubleFFT_2D.this.t[n8 + 1];
                                        }
                                    }
                                    break block21;
                                }
                                if (DoubleFFT_2D.this.n2 != 4 * n6) break block22;
                                for (n72 = 0; n72 < DoubleFFT_2D.this.n1; ++n72) {
                                    n62 = n72 * DoubleFFT_2D.this.n2 + 4 * n2;
                                    n5 = n7 + 2 * n72;
                                    n4 = n7 + 2 * DoubleFFT_2D.this.n1 + 2 * n72;
                                    ((DoubleFFT_2D)DoubleFFT_2D.this).t[n5] = dArray[n62];
                                    ((DoubleFFT_2D)DoubleFFT_2D.this).t[n5 + 1] = dArray[n62 + 1];
                                    ((DoubleFFT_2D)DoubleFFT_2D.this).t[n4] = dArray[n62 + 2];
                                    ((DoubleFFT_2D)DoubleFFT_2D.this).t[n4 + 1] = dArray[n62 + 3];
                                }
                                DoubleFFT_2D.this.fftn1.complexForward(DoubleFFT_2D.this.t, n7);
                                DoubleFFT_2D.this.fftn1.complexForward(DoubleFFT_2D.this.t, n7 + 2 * DoubleFFT_2D.this.n1);
                                for (n72 = 0; n72 < DoubleFFT_2D.this.n1; ++n72) {
                                    n62 = n72 * DoubleFFT_2D.this.n2 + 4 * n2;
                                    n5 = n7 + 2 * n72;
                                    n4 = n7 + 2 * DoubleFFT_2D.this.n1 + 2 * n72;
                                    dArray[n62] = DoubleFFT_2D.this.t[n5];
                                    dArray[n62 + 1] = DoubleFFT_2D.this.t[n5 + 1];
                                    dArray[n62 + 2] = DoubleFFT_2D.this.t[n4];
                                    dArray[n62 + 3] = DoubleFFT_2D.this.t[n4 + 1];
                                }
                                break block21;
                            }
                            if (DoubleFFT_2D.this.n2 != 2 * n6) break block21;
                            for (n3 = 0; n3 < DoubleFFT_2D.this.n1; ++n3) {
                                n25 = n3 * DoubleFFT_2D.this.n2 + 2 * n2;
                                n24 = n7 + 2 * n3;
                                ((DoubleFFT_2D)DoubleFFT_2D.this).t[n24] = dArray[n25];
                                ((DoubleFFT_2D)DoubleFFT_2D.this).t[n24 + 1] = dArray[n25 + 1];
                            }
                            DoubleFFT_2D.this.fftn1.complexForward(DoubleFFT_2D.this.t, n7);
                            for (n3 = 0; n3 < DoubleFFT_2D.this.n1; ++n3) {
                                n25 = n3 * DoubleFFT_2D.this.n2 + 2 * n2;
                                n24 = n7 + 2 * n3;
                                dArray[n25] = DoubleFFT_2D.this.t[n24];
                                dArray[n25 + 1] = DoubleFFT_2D.this.t[n24 + 1];
                            }
                            break block21;
                        }
                        if (DoubleFFT_2D.this.n2 > 4 * n6) {
                            for (int i = 8 * n2; i < DoubleFFT_2D.this.n2; i += 8 * n6) {
                                int n26;
                                int n14;
                                int n15;
                                int n16;
                                int n17;
                                int n18;
                                for (n18 = 0; n18 < DoubleFFT_2D.this.n1; ++n18) {
                                    n17 = n18 * DoubleFFT_2D.this.n2 + i;
                                    n16 = n7 + 2 * n18;
                                    n15 = n7 + 2 * DoubleFFT_2D.this.n1 + 2 * n18;
                                    n14 = n15 + 2 * DoubleFFT_2D.this.n1;
                                    n26 = n14 + 2 * DoubleFFT_2D.this.n1;
                                    ((DoubleFFT_2D)DoubleFFT_2D.this).t[n16] = dArray[n17];
                                    ((DoubleFFT_2D)DoubleFFT_2D.this).t[n16 + 1] = dArray[n17 + 1];
                                    ((DoubleFFT_2D)DoubleFFT_2D.this).t[n15] = dArray[n17 + 2];
                                    ((DoubleFFT_2D)DoubleFFT_2D.this).t[n15 + 1] = dArray[n17 + 3];
                                    ((DoubleFFT_2D)DoubleFFT_2D.this).t[n14] = dArray[n17 + 4];
                                    ((DoubleFFT_2D)DoubleFFT_2D.this).t[n14 + 1] = dArray[n17 + 5];
                                    ((DoubleFFT_2D)DoubleFFT_2D.this).t[n26] = dArray[n17 + 6];
                                    ((DoubleFFT_2D)DoubleFFT_2D.this).t[n26 + 1] = dArray[n17 + 7];
                                }
                                DoubleFFT_2D.this.fftn1.complexInverse(DoubleFFT_2D.this.t, n7, bl);
                                DoubleFFT_2D.this.fftn1.complexInverse(DoubleFFT_2D.this.t, n7 + 2 * DoubleFFT_2D.this.n1, bl);
                                DoubleFFT_2D.this.fftn1.complexInverse(DoubleFFT_2D.this.t, n7 + 4 * DoubleFFT_2D.this.n1, bl);
                                DoubleFFT_2D.this.fftn1.complexInverse(DoubleFFT_2D.this.t, n7 + 6 * DoubleFFT_2D.this.n1, bl);
                                for (n18 = 0; n18 < DoubleFFT_2D.this.n1; ++n18) {
                                    n17 = n18 * DoubleFFT_2D.this.n2 + i;
                                    n16 = n7 + 2 * n18;
                                    n15 = n7 + 2 * DoubleFFT_2D.this.n1 + 2 * n18;
                                    n14 = n15 + 2 * DoubleFFT_2D.this.n1;
                                    n26 = n14 + 2 * DoubleFFT_2D.this.n1;
                                    dArray[n17] = DoubleFFT_2D.this.t[n16];
                                    dArray[n17 + 1] = DoubleFFT_2D.this.t[n16 + 1];
                                    dArray[n17 + 2] = DoubleFFT_2D.this.t[n15];
                                    dArray[n17 + 3] = DoubleFFT_2D.this.t[n15 + 1];
                                    dArray[n17 + 4] = DoubleFFT_2D.this.t[n14];
                                    dArray[n17 + 5] = DoubleFFT_2D.this.t[n14 + 1];
                                    dArray[n17 + 6] = DoubleFFT_2D.this.t[n26];
                                    dArray[n17 + 7] = DoubleFFT_2D.this.t[n26 + 1];
                                }
                            }
                        } else if (DoubleFFT_2D.this.n2 == 4 * n6) {
                            int n27;
                            int n19;
                            int n20;
                            int n21;
                            for (n21 = 0; n21 < DoubleFFT_2D.this.n1; ++n21) {
                                n20 = n21 * DoubleFFT_2D.this.n2 + 4 * n2;
                                n19 = n7 + 2 * n21;
                                n27 = n7 + 2 * DoubleFFT_2D.this.n1 + 2 * n21;
                                ((DoubleFFT_2D)DoubleFFT_2D.this).t[n19] = dArray[n20];
                                ((DoubleFFT_2D)DoubleFFT_2D.this).t[n19 + 1] = dArray[n20 + 1];
                                ((DoubleFFT_2D)DoubleFFT_2D.this).t[n27] = dArray[n20 + 2];
                                ((DoubleFFT_2D)DoubleFFT_2D.this).t[n27 + 1] = dArray[n20 + 3];
                            }
                            DoubleFFT_2D.this.fftn1.complexInverse(DoubleFFT_2D.this.t, n7, bl);
                            DoubleFFT_2D.this.fftn1.complexInverse(DoubleFFT_2D.this.t, n7 + 2 * DoubleFFT_2D.this.n1, bl);
                            for (n21 = 0; n21 < DoubleFFT_2D.this.n1; ++n21) {
                                n20 = n21 * DoubleFFT_2D.this.n2 + 4 * n2;
                                n19 = n7 + 2 * n21;
                                n27 = n7 + 2 * DoubleFFT_2D.this.n1 + 2 * n21;
                                dArray[n20] = DoubleFFT_2D.this.t[n19];
                                dArray[n20 + 1] = DoubleFFT_2D.this.t[n19 + 1];
                                dArray[n20 + 2] = DoubleFFT_2D.this.t[n27];
                                dArray[n20 + 3] = DoubleFFT_2D.this.t[n27 + 1];
                            }
                        } else if (DoubleFFT_2D.this.n2 == 2 * n6) {
                            int n28;
                            int n22;
                            int n23;
                            for (n23 = 0; n23 < DoubleFFT_2D.this.n1; ++n23) {
                                n22 = n23 * DoubleFFT_2D.this.n2 + 2 * n2;
                                n28 = n7 + 2 * n23;
                                ((DoubleFFT_2D)DoubleFFT_2D.this).t[n28] = dArray[n22];
                                ((DoubleFFT_2D)DoubleFFT_2D.this).t[n28 + 1] = dArray[n22 + 1];
                            }
                            DoubleFFT_2D.this.fftn1.complexInverse(DoubleFFT_2D.this.t, n7, bl);
                            for (n23 = 0; n23 < DoubleFFT_2D.this.n1; ++n23) {
                                n22 = n23 * DoubleFFT_2D.this.n2 + 2 * n2;
                                n28 = n7 + 2 * n23;
                                dArray[n22] = DoubleFFT_2D.this.t[n28];
                                dArray[n22 + 1] = DoubleFFT_2D.this.t[n28 + 1];
                            }
                        }
                    }
                }
            });
        }
        try {
            for (n2 = 0; n2 < n4; ++n2) {
                futureArray[n2].get();
            }
        }
        catch (ExecutionException executionException) {
            executionException.printStackTrace();
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
    }

    private void cdft2d_subth(final int n, final double[][] dArray, final boolean bl) {
        int n2;
        int n3;
        int n4 = n3 = ConcurrencyUtils.getNumberOfProcessors();
        int n5 = 8 * this.n1;
        if (this.n2 == 4 * n3) {
            n5 >>= 1;
        } else if (this.n2 < 4 * n3) {
            n4 = this.n2 >> 1;
            n5 >>= 2;
        }
        Future[] futureArray = new Future[n4];
        final int n6 = n4;
        for (int i = 0; i < n4; ++i) {
            n2 = i;
            final int n7 = n5 * i;
            futureArray[i] = ConcurrencyUtils.threadPool.submit(new Runnable(){

                public void run() {
                    block21: {
                        block19: {
                            int n18;
                            int n22;
                            block22: {
                                int n3;
                                int n4;
                                int n5;
                                block20: {
                                    if (n != -1) break block19;
                                    if (DoubleFFT_2D.this.n2 <= 4 * n6) break block20;
                                    for (int i = 8 * n2; i < DoubleFFT_2D.this.n2; i += 8 * n6) {
                                        int n62;
                                        int n72;
                                        int n8;
                                        int n9;
                                        int n10;
                                        for (n10 = 0; n10 < DoubleFFT_2D.this.n1; ++n10) {
                                            n9 = n7 + 2 * n10;
                                            n8 = n7 + 2 * DoubleFFT_2D.this.n1 + 2 * n10;
                                            n72 = n8 + 2 * DoubleFFT_2D.this.n1;
                                            n62 = n72 + 2 * DoubleFFT_2D.this.n1;
                                            ((DoubleFFT_2D)DoubleFFT_2D.this).t[n9] = dArray[n10][i];
                                            ((DoubleFFT_2D)DoubleFFT_2D.this).t[n9 + 1] = dArray[n10][i + 1];
                                            ((DoubleFFT_2D)DoubleFFT_2D.this).t[n8] = dArray[n10][i + 2];
                                            ((DoubleFFT_2D)DoubleFFT_2D.this).t[n8 + 1] = dArray[n10][i + 3];
                                            ((DoubleFFT_2D)DoubleFFT_2D.this).t[n72] = dArray[n10][i + 4];
                                            ((DoubleFFT_2D)DoubleFFT_2D.this).t[n72 + 1] = dArray[n10][i + 5];
                                            ((DoubleFFT_2D)DoubleFFT_2D.this).t[n62] = dArray[n10][i + 6];
                                            ((DoubleFFT_2D)DoubleFFT_2D.this).t[n62 + 1] = dArray[n10][i + 7];
                                        }
                                        DoubleFFT_2D.this.fftn1.complexForward(DoubleFFT_2D.this.t, n7);
                                        DoubleFFT_2D.this.fftn1.complexForward(DoubleFFT_2D.this.t, n7 + 2 * DoubleFFT_2D.this.n1);
                                        DoubleFFT_2D.this.fftn1.complexForward(DoubleFFT_2D.this.t, n7 + 4 * DoubleFFT_2D.this.n1);
                                        DoubleFFT_2D.this.fftn1.complexForward(DoubleFFT_2D.this.t, n7 + 6 * DoubleFFT_2D.this.n1);
                                        for (n10 = 0; n10 < DoubleFFT_2D.this.n1; ++n10) {
                                            n9 = n7 + 2 * n10;
                                            n8 = n7 + 2 * DoubleFFT_2D.this.n1 + 2 * n10;
                                            n72 = n8 + 2 * DoubleFFT_2D.this.n1;
                                            n62 = n72 + 2 * DoubleFFT_2D.this.n1;
                                            dArray[n10][i] = DoubleFFT_2D.this.t[n9];
                                            dArray[n10][i + 1] = DoubleFFT_2D.this.t[n9 + 1];
                                            dArray[n10][i + 2] = DoubleFFT_2D.this.t[n8];
                                            dArray[n10][i + 3] = DoubleFFT_2D.this.t[n8 + 1];
                                            dArray[n10][i + 4] = DoubleFFT_2D.this.t[n72];
                                            dArray[n10][i + 5] = DoubleFFT_2D.this.t[n72 + 1];
                                            dArray[n10][i + 6] = DoubleFFT_2D.this.t[n62];
                                            dArray[n10][i + 7] = DoubleFFT_2D.this.t[n62 + 1];
                                        }
                                    }
                                    break block21;
                                }
                                if (DoubleFFT_2D.this.n2 != 4 * n6) break block22;
                                for (n5 = 0; n5 < DoubleFFT_2D.this.n1; ++n5) {
                                    n4 = n7 + 2 * n5;
                                    n3 = n7 + 2 * DoubleFFT_2D.this.n1 + 2 * n5;
                                    ((DoubleFFT_2D)DoubleFFT_2D.this).t[n4] = dArray[n5][4 * n2];
                                    ((DoubleFFT_2D)DoubleFFT_2D.this).t[n4 + 1] = dArray[n5][4 * n2 + 1];
                                    ((DoubleFFT_2D)DoubleFFT_2D.this).t[n3] = dArray[n5][4 * n2 + 2];
                                    ((DoubleFFT_2D)DoubleFFT_2D.this).t[n3 + 1] = dArray[n5][4 * n2 + 3];
                                }
                                DoubleFFT_2D.this.fftn1.complexForward(DoubleFFT_2D.this.t, n7);
                                DoubleFFT_2D.this.fftn1.complexForward(DoubleFFT_2D.this.t, n7 + 2 * DoubleFFT_2D.this.n1);
                                for (n5 = 0; n5 < DoubleFFT_2D.this.n1; ++n5) {
                                    n4 = n7 + 2 * n5;
                                    n3 = n7 + 2 * DoubleFFT_2D.this.n1 + 2 * n5;
                                    dArray[n5][4 * n2] = DoubleFFT_2D.this.t[n4];
                                    dArray[n5][4 * n2 + 1] = DoubleFFT_2D.this.t[n4 + 1];
                                    dArray[n5][4 * n2 + 2] = DoubleFFT_2D.this.t[n3];
                                    dArray[n5][4 * n2 + 3] = DoubleFFT_2D.this.t[n3 + 1];
                                }
                                break block21;
                            }
                            if (DoubleFFT_2D.this.n2 != 2 * n6) break block21;
                            for (n22 = 0; n22 < DoubleFFT_2D.this.n1; ++n22) {
                                n18 = n7 + 2 * n22;
                                ((DoubleFFT_2D)DoubleFFT_2D.this).t[n18] = dArray[n22][2 * n2];
                                ((DoubleFFT_2D)DoubleFFT_2D.this).t[n18 + 1] = dArray[n22][2 * n2 + 1];
                            }
                            DoubleFFT_2D.this.fftn1.complexForward(DoubleFFT_2D.this.t, n7);
                            for (n22 = 0; n22 < DoubleFFT_2D.this.n1; ++n22) {
                                n18 = n7 + 2 * n22;
                                dArray[n22][2 * n2] = DoubleFFT_2D.this.t[n18];
                                dArray[n22][2 * n2 + 1] = DoubleFFT_2D.this.t[n18 + 1];
                            }
                            break block21;
                        }
                        if (DoubleFFT_2D.this.n2 > 4 * n6) {
                            for (int i = 8 * n2; i < DoubleFFT_2D.this.n2; i += 8 * n6) {
                                int n19;
                                int n11;
                                int n12;
                                int n13;
                                int n14;
                                for (n14 = 0; n14 < DoubleFFT_2D.this.n1; ++n14) {
                                    n13 = n7 + 2 * n14;
                                    n12 = n7 + 2 * DoubleFFT_2D.this.n1 + 2 * n14;
                                    n11 = n12 + 2 * DoubleFFT_2D.this.n1;
                                    n19 = n11 + 2 * DoubleFFT_2D.this.n1;
                                    ((DoubleFFT_2D)DoubleFFT_2D.this).t[n13] = dArray[n14][i];
                                    ((DoubleFFT_2D)DoubleFFT_2D.this).t[n13 + 1] = dArray[n14][i + 1];
                                    ((DoubleFFT_2D)DoubleFFT_2D.this).t[n12] = dArray[n14][i + 2];
                                    ((DoubleFFT_2D)DoubleFFT_2D.this).t[n12 + 1] = dArray[n14][i + 3];
                                    ((DoubleFFT_2D)DoubleFFT_2D.this).t[n11] = dArray[n14][i + 4];
                                    ((DoubleFFT_2D)DoubleFFT_2D.this).t[n11 + 1] = dArray[n14][i + 5];
                                    ((DoubleFFT_2D)DoubleFFT_2D.this).t[n19] = dArray[n14][i + 6];
                                    ((DoubleFFT_2D)DoubleFFT_2D.this).t[n19 + 1] = dArray[n14][i + 7];
                                }
                                DoubleFFT_2D.this.fftn1.complexInverse(DoubleFFT_2D.this.t, n7, bl);
                                DoubleFFT_2D.this.fftn1.complexInverse(DoubleFFT_2D.this.t, n7 + 2 * DoubleFFT_2D.this.n1, bl);
                                DoubleFFT_2D.this.fftn1.complexInverse(DoubleFFT_2D.this.t, n7 + 4 * DoubleFFT_2D.this.n1, bl);
                                DoubleFFT_2D.this.fftn1.complexInverse(DoubleFFT_2D.this.t, n7 + 6 * DoubleFFT_2D.this.n1, bl);
                                for (n14 = 0; n14 < DoubleFFT_2D.this.n1; ++n14) {
                                    n13 = n7 + 2 * n14;
                                    n12 = n7 + 2 * DoubleFFT_2D.this.n1 + 2 * n14;
                                    n11 = n12 + 2 * DoubleFFT_2D.this.n1;
                                    n19 = n11 + 2 * DoubleFFT_2D.this.n1;
                                    dArray[n14][i] = DoubleFFT_2D.this.t[n13];
                                    dArray[n14][i + 1] = DoubleFFT_2D.this.t[n13 + 1];
                                    dArray[n14][i + 2] = DoubleFFT_2D.this.t[n12];
                                    dArray[n14][i + 3] = DoubleFFT_2D.this.t[n12 + 1];
                                    dArray[n14][i + 4] = DoubleFFT_2D.this.t[n11];
                                    dArray[n14][i + 5] = DoubleFFT_2D.this.t[n11 + 1];
                                    dArray[n14][i + 6] = DoubleFFT_2D.this.t[n19];
                                    dArray[n14][i + 7] = DoubleFFT_2D.this.t[n19 + 1];
                                }
                            }
                        } else if (DoubleFFT_2D.this.n2 == 4 * n6) {
                            int n20;
                            int n15;
                            int n16;
                            for (n16 = 0; n16 < DoubleFFT_2D.this.n1; ++n16) {
                                n15 = n7 + 2 * n16;
                                n20 = n7 + 2 * DoubleFFT_2D.this.n1 + 2 * n16;
                                ((DoubleFFT_2D)DoubleFFT_2D.this).t[n15] = dArray[n16][4 * n2];
                                ((DoubleFFT_2D)DoubleFFT_2D.this).t[n15 + 1] = dArray[n16][4 * n2 + 1];
                                ((DoubleFFT_2D)DoubleFFT_2D.this).t[n20] = dArray[n16][4 * n2 + 2];
                                ((DoubleFFT_2D)DoubleFFT_2D.this).t[n20 + 1] = dArray[n16][4 * n2 + 3];
                            }
                            DoubleFFT_2D.this.fftn1.complexInverse(DoubleFFT_2D.this.t, n7, bl);
                            DoubleFFT_2D.this.fftn1.complexInverse(DoubleFFT_2D.this.t, n7 + 2 * DoubleFFT_2D.this.n1, bl);
                            for (n16 = 0; n16 < DoubleFFT_2D.this.n1; ++n16) {
                                n15 = n7 + 2 * n16;
                                n20 = n7 + 2 * DoubleFFT_2D.this.n1 + 2 * n16;
                                dArray[n16][4 * n2] = DoubleFFT_2D.this.t[n15];
                                dArray[n16][4 * n2 + 1] = DoubleFFT_2D.this.t[n15 + 1];
                                dArray[n16][4 * n2 + 2] = DoubleFFT_2D.this.t[n20];
                                dArray[n16][4 * n2 + 3] = DoubleFFT_2D.this.t[n20 + 1];
                            }
                        } else if (DoubleFFT_2D.this.n2 == 2 * n6) {
                            int n21;
                            int n17;
                            for (n17 = 0; n17 < DoubleFFT_2D.this.n1; ++n17) {
                                n21 = n7 + 2 * n17;
                                ((DoubleFFT_2D)DoubleFFT_2D.this).t[n21] = dArray[n17][2 * n2];
                                ((DoubleFFT_2D)DoubleFFT_2D.this).t[n21 + 1] = dArray[n17][2 * n2 + 1];
                            }
                            DoubleFFT_2D.this.fftn1.complexInverse(DoubleFFT_2D.this.t, n7, bl);
                            for (n17 = 0; n17 < DoubleFFT_2D.this.n1; ++n17) {
                                n21 = n7 + 2 * n17;
                                dArray[n17][2 * n2] = DoubleFFT_2D.this.t[n21];
                                dArray[n17][2 * n2 + 1] = DoubleFFT_2D.this.t[n21 + 1];
                            }
                        }
                    }
                }
            });
        }
        try {
            for (n2 = 0; n2 < n4; ++n2) {
                futureArray[n2].get();
            }
        }
        catch (ExecutionException executionException) {
            executionException.printStackTrace();
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
    }

    private void fillSymmetric(final double[] dArray) {
        int n;
        int n2 = ConcurrencyUtils.getNumberOfProcessors();
        Future[] futureArray = new Future[n2];
        int n3 = this.n1 / 2;
        int n4 = n3 / n2;
        final int n5 = 2 * this.n2;
        for (n = 0; n < n2; ++n) {
            final int n6 = n == 0 ? n * n4 + 1 : n * n4;
            final int n7 = n * n4 + n4;
            final int n8 = n * n4;
            final int n9 = n == n2 - 1 ? n * n4 + n4 + 1 : n * n4 + n4;
            futureArray[n] = ConcurrencyUtils.threadPool.submit(new Runnable(){

                public void run() {
                    int n;
                    int n2;
                    int n3;
                    int n4;
                    for (n4 = n6; n4 < n7; ++n4) {
                        n3 = n4 * n5;
                        n2 = (DoubleFFT_2D.this.n1 - n4) * n5;
                        dArray[n3 + ((DoubleFFT_2D)DoubleFFT_2D.this).n2] = dArray[n2 + 1];
                        dArray[n3 + ((DoubleFFT_2D)DoubleFFT_2D.this).n2 + 1] = -dArray[n2];
                    }
                    for (n4 = n6; n4 < n7; ++n4) {
                        for (n = DoubleFFT_2D.this.n2 + 2; n < n5; n += 2) {
                            n3 = n4 * n5;
                            n2 = (DoubleFFT_2D.this.n1 - n4) * n5 + n5 - n;
                            dArray[n3 + n] = dArray[n2];
                            dArray[n3 + n + 1] = -dArray[n2 + 1];
                        }
                    }
                    for (n4 = n8; n4 < n9; ++n4) {
                        for (n = 0; n < n5; n += 2) {
                            n3 = (DoubleFFT_2D.this.n1 - n4) % DoubleFFT_2D.this.n1 * n5 + (n5 - n) % n5;
                            n2 = n4 * n5 + n;
                            dArray[n3] = dArray[n2];
                            dArray[n3 + 1] = -dArray[n2 + 1];
                        }
                    }
                }
            });
        }
        try {
            for (n = 0; n < n2; ++n) {
                futureArray[n].get();
            }
        }
        catch (ExecutionException executionException) {
            executionException.printStackTrace();
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
    }

    private void fillSymmetric(final double[][] dArray) {
        int n;
        int n2 = ConcurrencyUtils.getNumberOfProcessors();
        Future[] futureArray = new Future[n2];
        int n3 = this.n1 / 2;
        int n4 = n3 / n2;
        final int n5 = 2 * this.n2;
        for (n = 0; n < n2; ++n) {
            final int n6 = n == 0 ? n * n4 + 1 : n * n4;
            final int n7 = n * n4 + n4;
            final int n8 = n * n4;
            final int n9 = n == n2 - 1 ? n * n4 + n4 + 1 : n * n4 + n4;
            futureArray[n] = ConcurrencyUtils.threadPool.submit(new Runnable(){

                public void run() {
                    int n;
                    int n2;
                    for (n2 = n6; n2 < n7; ++n2) {
                        dArray[n2][((DoubleFFT_2D)DoubleFFT_2D.this).n2] = dArray[DoubleFFT_2D.this.n1 - n2][1];
                        dArray[n2][((DoubleFFT_2D)DoubleFFT_2D.this).n2 + 1] = -dArray[DoubleFFT_2D.this.n1 - n2][0];
                    }
                    for (n2 = n6; n2 < n7; ++n2) {
                        for (n = DoubleFFT_2D.this.n2 + 2; n < n5; n += 2) {
                            dArray[n2][n] = dArray[DoubleFFT_2D.this.n1 - n2][n5 - n];
                            dArray[n2][n + 1] = -dArray[DoubleFFT_2D.this.n1 - n2][n5 - n + 1];
                        }
                    }
                    for (n2 = n8; n2 < n9; ++n2) {
                        for (n = 0; n < n5; n += 2) {
                            dArray[(((DoubleFFT_2D)DoubleFFT_2D.this).n1 - n2) % ((DoubleFFT_2D)DoubleFFT_2D.this).n1][(n5 - n) % n5] = dArray[n2][n];
                            dArray[(((DoubleFFT_2D)DoubleFFT_2D.this).n1 - n2) % ((DoubleFFT_2D)DoubleFFT_2D.this).n1][(n5 - n) % n5 + 1] = -dArray[n2][n + 1];
                        }
                    }
                }
            });
        }
        try {
            for (n = 0; n < n2; ++n) {
                futureArray[n].get();
            }
        }
        catch (ExecutionException executionException) {
            executionException.printStackTrace();
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
    }
}

