package TDS::List::Dictionary;
# $Id: Dictionary.pm,v 1.7 2000/08/24 17:50:25 tom Exp $
################################################################

use strict;
use vars qw(@ISA
	    $LineTemplate $ContentTemplate
	    $IndexSeparator $IndexTemplate $IndexTemplateNonExist
	    $SkeltonFilename $CacheFilename $DataFilename
	    @row);

use Template;
use CGI::Tools;

use TDS;
use TDS::List::Base;
use TDS::Replacer::Dictionary;

@ISA = qw(TDS::List::Base TDS::Replacer::Dictionary);

attributes qw(exist_index);

# temlate for HTMLize
$LineTemplate = qq(<hr><h2><a name="_%encoded_char">%char</a></h2>);
# $ContentTemplate is used for old format, this will be obsoluted.
$ContentTemplate = qq(<h3><a href="#%encoded_term" name="%encoded_term">%term</a>[%yomi]</h3><div style="margin-left: 2em">%explain</div>\n);

$IndexSeparator = " | ";
$IndexTemplate = qq(<a href="\#_%encoded_char">%char</a>);
$IndexTemplateNonExist = qq(%char);

$SkeltonFilename = "dictionary_skelton.html";
$CacheFilename = "dictionary.html";
$DataFilename = "dictionary.dat";

@row = (["", "", "", "", ""],
	["", "", "", "", "",
	 "", "", "", "", ""],
	["", "", "", "", "",
	 "", "", "", "", ""],
	   ["", "", "", "", "",
	    "", "", "", "", ""],
	   ["", "", "", "", ""],
	   ["", "", "", "", "",
	    "", "", "", "", "",
	    "", "", "", "", ""],
	   ["", "", "", "", ""],
	   ["", "", ""],
	   ["", "", "", "", ""],
	   ["", ""]);

################################################################

sub initialize($)
{
    my $self = shift;

    $self->exist_index({});
    # super class
    $self->TDS::List::Base::initialize;
    $self->TDS::Replacer::Dictionary::initialize;
}

sub Read ($)
{
    my $self = shift;

    if ($self->IsFresh){
	open(F, $self->GetCacheFilename);
	my $lines = join('', <F>);
	close F;
	$self->cache_html($lines);
    } else {
	$self->TDS::Replacer::Dictionary::Read;
    }
}    

sub SetMacros($)
{
    my $self = shift;

    my @alphabet = qw(A B C D E F G H I J K L M N
		      O P Q R S T U V W X Y Z
		      0 1 2 3 4 5 6 7 8 9);

    # replacer
    my $url = new TDS::Replacer::Url;
    my $dic = new TDS::Replacer::Dictionary(replacer_url=>$url);
    $url->Read;
    $dic->Read;
    my %content;
    
    my $item;
    for $item (@{$self->parser->top->{content}}){
	my $tmp = $item->AsHTML({});
	
	$dic->ReplaceLine(\$tmp);
	$url->ReplaceLine(\$tmp);
	
	my $first_char = $self->get_first_char($item);
	push(@{$self->exist_index->{$first_char}->{html}}, $tmp);
    }
    $self->SetMacro("DICTIONARY_CONTENT", sub {
	my $html;
	
	my %header;
	my $item;
	
	# japanese
	my $i = 0;
	for (@row){
	    my $line_html;
	    for (@$_){
		next unless ref $self->exist_index->{$_};
		$self->exist_index->{$_}->{shown} = 1;
		for (@{$self->exist_index->{$_}->{html}}){
		    $line_html .= $_;
		}
	    }
	    if ($line_html){
		$html .= Expand($LineTemplate,
				{char=>$row[$i][0],
				 encoded_char=>UrlEncode($row[$i][0])
				 }) .
				     $line_html;
	    }
	    $i++;
	}
	# alphabet
	for (@alphabet){
	    next unless ref $self->exist_index->{$_};
	    $self->exist_index->{$_}->{shown} = 1;
	    $html .= Expand($LineTemplate, {char=>$_, encoded_char=>$_});
	    for (@{$self->exist_index->{$_}->{html}}){
		$html .= $_;
	    }
	}
	# not yet shown
	my $tmp_html;
	my $index;
	for $index (sort keys %{$self->exist_index}){
	    next unless ref $self->exist_index->{$index};
#		print "key: $_<br>";
	    next if $self->exist_index->{$index}->{shown};
	    $tmp_html .= join('', @{$self->exist_index->{$index}->{html}})
		if $self->exist_index->{$index}->{html};
	}
	if ($tmp_html){
	    $html .= Expand($LineTemplate, {char=>'etc'}) .
		$tmp_html;
	}
	return $html;
    });
    
    $self->SetMacro("HEADING_INDEX", sub {
	my $self = shift;

	# japanese
	my $line_ja;
	my $i;
	for (@row){
	    my $exist_col;
	    for (@$_){
		$exist_col ||= $self->exist_index->{$_};
	    }
	    $line_ja .= $IndexSeparator if $line_ja;
	    my $template = $exist_col ? $IndexTemplate : $IndexTemplateNonExist;
	    my $char = $row[$i][0];
	    $line_ja .= Expand($template,
			       {encoded_char=>UrlEncode($char),
				char=>$char});
	    $i++;
	}
	# english
	my $line_en;
	for (@alphabet){
	    $line_en .= $IndexSeparator if $line_en;
	    my $template =
		($self->exist_index->{$_}) ? $IndexTemplate : $IndexTemplateNonExist;
	    $line_en .= Expand($template,
			       {encoded_char=>$_,
				char=>$_});
	}
	return "$line_ja<br>$line_en";
    });
    
    $self->SUPER::SetMacros;
}
################################################################
# static functions
sub get_first_char($$)
{
    my ($self, $item) = @_;

    $item->{ext_attrs} =~ /^(.)/;
    if ($1 =~ /(\w)/){
	return uc($1);
    } else {
	$item->{pronounce} =~ /^(..)/;
#	print $item->{pronounce}, ", ";
	return $1;
    }
}
1;
