/*
 * Decompiled with CFR 0.152.
 */
package com.glavsoft.viewer.swing;

import com.glavsoft.viewer.AbstractConnectionWorkerFactory;
import com.glavsoft.viewer.ConnectionPresenter;
import com.glavsoft.viewer.NetworkConnectionWorker;
import com.glavsoft.viewer.RfbConnectionWorker;
import com.glavsoft.viewer.swing.SwingNetworkConnectionWorker;
import com.glavsoft.viewer.swing.SwingRfbConnectionWorker;
import com.glavsoft.viewer.swing.SwingViewerWindowFactory;
import javax.swing.JFrame;

public class SwingConnectionWorkerFactory
extends AbstractConnectionWorkerFactory {
    private JFrame parentWindow;
    private String predefinedPassword;
    private final ConnectionPresenter presenter;
    private final SwingViewerWindowFactory viewerWindowFactory;

    public SwingConnectionWorkerFactory(JFrame parentWindow, String predefinedPassword, ConnectionPresenter presenter, SwingViewerWindowFactory viewerWindowFactory) {
        this.parentWindow = parentWindow;
        this.predefinedPassword = predefinedPassword;
        this.presenter = presenter;
        this.viewerWindowFactory = viewerWindowFactory;
    }

    @Override
    public NetworkConnectionWorker createNetworkConnectionWorker() {
        return new SwingNetworkConnectionWorker(this.parentWindow);
    }

    @Override
    public RfbConnectionWorker createRfbConnectionWorker() {
        return new SwingRfbConnectionWorker(this.predefinedPassword, this.presenter, this.parentWindow, this.viewerWindowFactory);
    }

    @Override
    public void setPredefinedPassword(String predefinedPassword) {
        this.predefinedPassword = predefinedPassword;
    }
}

