;;Example of a ViDAL (ViSta Data Analysis Language) script file.
;;Load this file with the Load-Edit command.

;;Principal Components and Multivariate Regression Example

;;These commands do a principal components analysis of car preferences
;;followed by a multivariate regression analysis that projects 
;;car ratings into the principal components space.


(when *guidemap* (send *guidemap* :close))  
(show-workmap)


(load-data (strcat *examples-data-dir-name* "carrats.lsp"))
(normalize-data)
(load-data (strcat *examples-data-dir-name* "carprf14.lsp"))
(principal-components)
(create-data)
(setcd scores-pca-car-prefs)
(setcd norm-carratings)
(merge-variables "rats-scores")
(multiple-regression
 :data rats-scores
 :redundancy 2
 :responses (send carratings :variables)
 :predictors '("PC0" "PC1" "PC2" "PC3" "PC4"))
(create-data)
(visualize-model)
(vista-message "Principal Components and Multivariate Regression Example Finished")