#!/usr/pkg/bin/perl
#
#  getfile.pl:		uh, Fri May 15 1998
#
#  Written by:		Ullrich Hafner
#  
#  Copyright (C) 1998 Ullrich Hafner <hafner@bigfoot.de>
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111, USA.
#
#  $Id: gettile.pl.in,v 1.20 1999/03/07 18:13:18 hafner Exp $
#  $Date: 1999/03/07 18:13:18 $
#  $Author: hafner $
#  $Revision: 1.20 $
#  $State: Exp $
#

################################################################################
###
###	usage : gettile.pl infile outfile
### 
###     gets 'infile' via HTTP request and writes output to 'outfile'
###
################################################################################

use File::Basename;

sub quit;

if ($#ARGV != 1)
{
   quit ("usage: $0 infile outfile");
}

# get commandline parameters
$infile  = $ARGV[0];
$outfile = $ARGV[1];

# Changed for Debian, so we can use whatever's available
if (-x "/usr/bin/lynx")
{
   $wwwget = "/usr/bin/lynx";
   $getscript = "lynx.pl";
}
elsif (-x "/usr/bin/wget")
{
   $wwwget = "/usr/bin/wget";
   $getscript = "wget.pl";
}
else
{
   $getscript = "libwww.pl";
}

$include = $0;
$include =~ s/getfile.pl/$getscript/;

$url 	 = $infile;
$tmpfile = $outfile;

do "$include"; 
quit ("$@") if ($@);

sub quit
{
   $msg = shift;
   unlink $tmpfile if -r $tmpfile;
   die "$msg";
}
