require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&_RISCV_PTE_H_)) {
    eval 'sub _RISCV_PTE_H_ () {1;}' unless defined(&_RISCV_PTE_H_);
    if(defined(&_LP64)) {
	eval 'sub PTE_PPN () { &__BITS(53, 10);}' unless defined(&PTE_PPN);
	eval 'sub PTE_PPN0 () { &__BITS(18, 10);}' unless defined(&PTE_PPN0);
	eval 'sub PTE_PPN1 () { &__BITS(27, 19);}' unless defined(&PTE_PPN1);
	eval 'sub PTE_PPN2 () { &__BITS(53, 28);}' unless defined(&PTE_PPN2);
	eval 'sub atomic_cas_pte () { &atomic_cas_64;}' unless defined(&atomic_cas_pte);
    } else {
	eval 'sub PTE_PPN () { &__BITS(31, 10);}' unless defined(&PTE_PPN);
	eval 'sub PTE_PPN0 () { &__BITS(19, 10);}' unless defined(&PTE_PPN0);
	eval 'sub PTE_PPN1 () { &__BITS(31, 20);}' unless defined(&PTE_PPN1);
	eval 'sub atomic_cas_pte () { &atomic_cas_32;}' unless defined(&atomic_cas_pte);
    }
    eval 'sub PTE_PPN_SHIFT () {10;}' unless defined(&PTE_PPN_SHIFT);
    eval 'sub NPTEPG () {( &NBPG / $sizeof{ &pt_entry_t});}' unless defined(&NPTEPG);
    eval 'sub NSEGPG () { &NPTEPG;}' unless defined(&NSEGPG);
    eval 'sub NPDEPG () { &NPTEPG;}' unless defined(&NPDEPG);
    eval 'sub PTE_N () { &__BIT(63);}' unless defined(&PTE_N);
    eval 'sub PTE_PBMT () { &__BITS(62, 61);}' unless defined(&PTE_PBMT);
    eval 'sub PTE_reserved0 () { &__BITS(60, 54);}' unless defined(&PTE_reserved0);
    eval 'sub PTE_RSW () { &__BITS(9, 8);}' unless defined(&PTE_RSW);
    eval 'sub PTE_WIRED () { &__BIT(9);}' unless defined(&PTE_WIRED);
    eval 'sub PTE_D () { &__BIT(7);}' unless defined(&PTE_D);
    eval 'sub PTE_A () { &__BIT(6);}' unless defined(&PTE_A);
    eval 'sub PTE_G () { &__BIT(5);}' unless defined(&PTE_G);
    eval 'sub PTE_U () { &__BIT(4);}' unless defined(&PTE_U);
    eval 'sub PTE_X () { &__BIT(3);}' unless defined(&PTE_X);
    eval 'sub PTE_W () { &__BIT(2);}' unless defined(&PTE_W);
    eval 'sub PTE_R () { &__BIT(1);}' unless defined(&PTE_R);
    eval 'sub PTE_V () { &__BIT(0);}' unless defined(&PTE_V);
    eval 'sub PTE_HARDWIRED () {( &PTE_A |  &PTE_D);}' unless defined(&PTE_HARDWIRED);
    eval 'sub PTE_USER () {( &PTE_V |  &PTE_U);}' unless defined(&PTE_USER);
    eval 'sub PTE_KERN () {( &PTE_V |  &PTE_G);}' unless defined(&PTE_KERN);
    eval 'sub PTE_RW () {( &PTE_R |  &PTE_W);}' unless defined(&PTE_RW);
    eval 'sub PTE_RX () {( &PTE_R |  &PTE_X);}' unless defined(&PTE_RX);
    eval 'sub PTE_RWX () {( &PTE_R |  &PTE_W |  &PTE_X);}' unless defined(&PTE_RWX);
    eval 'sub PTE_ISLEAF_P {
        my($pte) = @_;
	    eval q(((($pte) &  &PTE_RWX) != 0));
    }' unless defined(&PTE_ISLEAF_P);
    eval 'sub PA_TO_PTE {
        my($pa) = @_;
	    eval q(((($pa) >>  &PGSHIFT) <<  &PTE_PPN_SHIFT));
    }' unless defined(&PA_TO_PTE);
    eval 'sub PTE_TO_PA {
        my($pte) = @_;
	    eval q(((($pte) >>  &PTE_PPN_SHIFT) <<  &PGSHIFT));
    }' unless defined(&PTE_TO_PA);
    if(defined(&_KERNEL)) {
	eval 'sub pte_valid_p {
	    my($pte) = @_;
    	    eval q({ ($pte &  &PTE_V) != 0; });
	}' unless defined(&pte_valid_p);
	eval 'sub pte_wired_p {
	    my($pte) = @_;
    	    eval q({ ($pte &  &PTE_WIRED) != 0; });
	}' unless defined(&pte_wired_p);
	eval 'sub pte_modified_p {
	    my($pte) = @_;
    	    eval q({ ($pte &  &PTE_D) != 0; });
	}' unless defined(&pte_modified_p);
	eval 'sub pte_cached_p {
	    my($pte) = @_;
    	    eval q({  &true; });
	}' unless defined(&pte_cached_p);
	eval 'sub pte_deferred_exec_p {
	    my($pte) = @_;
    	    eval q({  &false; });
	}' unless defined(&pte_deferred_exec_p);
	eval 'sub pte_wire_entry {
	    my($pte) = @_;
    	    eval q({ $pte |  &PTE_HARDWIRED |  &PTE_WIRED; });
	}' unless defined(&pte_wire_entry);
	eval 'sub pte_unwire_entry {
	    my($pte) = @_;
    	    eval q({ $pte & ~( &PTE_HARDWIRED |  &PTE_WIRED); });
	}' unless defined(&pte_unwire_entry);
	eval 'sub pte_to_paddr {
	    my($pte) = @_;
    	    eval q({  &PTE_TO_PA($pte); });
	}' unless defined(&pte_to_paddr);
	eval 'sub pte_nv_entry {
	    my($kernel_p) = @_;
    	    eval q({ 0; });
	}' unless defined(&pte_nv_entry);
	eval 'sub pte_prot_nowrite {
	    my($pte) = @_;
    	    eval q({ $pte & ~ &PTE_W; });
	}' unless defined(&pte_prot_nowrite);
	eval 'sub pte_prot_downgrade {
	    my($pte,$newprot) = @_;
    	    eval q({  &if (($newprot &  &VM_PROT_READ) == 0) $pte &= ~ &PTE_R;  &if (($newprot &  &VM_PROT_WRITE) == 0) $pte &= ~ &PTE_W;  &if (($newprot &  &VM_PROT_EXECUTE) == 0) $pte &= ~ &PTE_X; $pte; });
	}' unless defined(&pte_prot_downgrade);
	eval 'sub pte_prot_bits {
	    my($mdpg,$prot,$kernel_p) = @_;
    	    eval q({  &KASSERT($prot &  &VM_PROT_READ);  &pt_entry_t  &pte =  &PTE_R;  &if ($prot &  &VM_PROT_EXECUTE) {  &pte |=  &PTE_X; }  &if ($prot &  &VM_PROT_WRITE) {  &pte |=  &PTE_W; }  &pte; });
	}' unless defined(&pte_prot_bits);
	eval 'sub pte_flag_bits {
	    my($mdpg,$flags,$kernel_p) = @_;
    	    eval q({ 0; });
	}' unless defined(&pte_flag_bits);
	eval 'sub pte_make_enter {
	    my($pa,$mdpg,$prot,$flags,$kernel_p) = @_;
    	    eval q({  &pt_entry_t  &pte = ( &pt_entry_t) &PA_TO_PTE($pa);  &pte |= $kernel_p ?  &PTE_KERN :  &PTE_USER;  &pte |=  &pte_flag_bits($mdpg, $flags, $kernel_p);  &pte |=  &pte_prot_bits($mdpg, $prot, $kernel_p);  &if ($mdpg !=  &NULL) {  &if (($prot &  &VM_PROT_WRITE) != 0 && (($flags &  &VM_PROT_WRITE) != 0||  &VM_PAGEMD_MODIFIED_P($mdpg))) {  &pte |=  &PTE_A; }  &else  &if (($flags &  &VM_PROT_ALL) ||  &VM_PAGEMD_REFERENCED_P($mdpg)) {  &pte |=  &PTE_A; } }  &else {  &pte |=  &PTE_A |  &PTE_D; }  &pte; });
	}' unless defined(&pte_make_enter);
	eval 'sub pte_make_kenter_pa {
	    my($pa,$mdpg,$prot,$flags) = @_;
    	    eval q({  &pt_entry_t  &pte = ( &pt_entry_t) &PA_TO_PTE($pa);  &pte |=  &PTE_KERN |  &PTE_HARDWIRED |  &PTE_WIRED;  &pte |=  &pte_flag_bits( &NULL, $flags,  &true);  &pte |=  &pte_prot_bits( &NULL, $prot,  &true);  &pte; });
	}' unless defined(&pte_make_kenter_pa);
	eval 'sub pte_set {
	    my($ptep,$pte) = @_;
    	    eval q({ *$ptep = $pte; });
	}' unless defined(&pte_set);
	eval 'sub pte_invalid_pde {
	    my($void) = @_;
    	    eval q({ 0; });
	}' unless defined(&pte_invalid_pde);
	eval 'sub pte_pde_pdetab {
	    my($pa,$kernel_p) = @_;
    	    eval q({  &PTE_V |  &PA_TO_PTE($pa); });
	}' unless defined(&pte_pde_pdetab);
	eval 'sub pte_pde_ptpage {
	    my($pa,$kernel_p) = @_;
    	    eval q({  &PTE_V |  &PA_TO_PTE($pa); });
	}' unless defined(&pte_pde_ptpage);
	eval 'sub pte_pde_valid_p {
	    my($pde) = @_;
    	    eval q({ ($pde & ( &PTE_X |  &PTE_W |  &PTE_R |  &PTE_V)) ==  &PTE_V; });
	}' unless defined(&pte_pde_valid_p);
	eval 'sub pte_pde_to_paddr {
	    my($pde) = @_;
    	    eval q({  &pte_to_paddr(( &pt_entry_t)$pde); });
	}' unless defined(&pte_pde_to_paddr);
# some #ifdef were dropped here -- fill in the blanks
	eval 'sub pte_pde_cas {
	    my($pdep,$opde,$npde) = @_;
    	    eval q({  &else *$pdep = $npde; 0;  &endif });
	}' unless defined(&pte_pde_cas);
	eval 'sub pte_pde_set {
	    my($pdep,$npde) = @_;
    	    eval q({ *$pdep = $npde; });
	}' unless defined(&pte_pde_set);
	eval 'sub pte_value {
	    my($pte) = @_;
    	    eval q({ $pte; });
	}' unless defined(&pte_value);
    }
}
1;
