/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.med.icb.util;

import it.unimi.dsi.lang.MutableString;
import org.apache.commons.io.FilenameUtils;

public class ICBFilenameUtils {
    private ICBFilenameUtils() {
    }

    public static String concatPathParts(String ... parts) {
        if (parts == null || parts.length == 0) {
            return null;
        }
        int estimatedLength = parts.length;
        for (String part : parts) {
            if (part == null) {
                return null;
            }
            estimatedLength += part.length();
        }
        MutableString result = new MutableString(estimatedLength);
        for (int i = 0; i < parts.length; ++i) {
            String part = FilenameUtils.separatorsToUnix((String)parts[i]);
            if (part.length() == 0) continue;
            if (i == 0) {
                result.append(part);
                continue;
            }
            int skipInitialChars = 0;
            while (part.charAt(skipInitialChars) == '/') {
                ++skipInitialChars;
            }
            if (!result.endsWith("/")) {
                result.append('/');
            }
            result.append((CharSequence)part, skipInitialChars, part.length());
        }
        return result.toString();
    }
}

