require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&_RISCV_VMPARAM_H_)) {
    eval 'sub _RISCV_VMPARAM_H_ () {1;}' unless defined(&_RISCV_VMPARAM_H_);
    require 'riscv/param.ph';
    if(defined(&_KERNEL_OPT)) {
	require './riscv/opt_multiprocessor.ph';
    }
    eval 'sub PAGE_SHIFT () { &PGSHIFT;}' unless defined(&PAGE_SHIFT);
    eval 'sub PAGE_SIZE () {(1<<  &PAGE_SHIFT);}' unless defined(&PAGE_SIZE);
    eval 'sub PAGE_MASK () {( &PAGE_SIZE - 1);}' unless defined(&PAGE_MASK);
    eval 'sub USRSTACK () {( &VM_MAXUSER_ADDRESS -  &PAGE_SIZE);}' unless defined(&USRSTACK);
    eval 'sub USRSTACK32 () {(( &uint32_t) &VM_MAXUSER_ADDRESS32 -  &PAGE_SIZE);}' unless defined(&USRSTACK32);
    unless(defined(&MAXTSIZ)) {
	eval 'sub MAXTSIZ () {(128*1024*1024);}' unless defined(&MAXTSIZ);
    }
    unless(defined(&DFLDSIZ)) {
	eval 'sub DFLDSIZ () {(256*1024*1024);}' unless defined(&DFLDSIZ);
    }
    unless(defined(&MAXDSIZ)) {
	eval 'sub MAXDSIZ () {(1536*1024*1024);}' unless defined(&MAXDSIZ);
    }
    unless(defined(&DFLSSIZ)) {
	eval 'sub DFLSSIZ () {(4*1024*1024);}' unless defined(&DFLSSIZ);
    }
    unless(defined(&MAXSSIZ)) {
	eval 'sub MAXSSIZ () {(120*1024*1024);}' unless defined(&MAXSSIZ);
    }
    unless(defined(&DFLDSIZ32)) {
	eval 'sub DFLDSIZ32 () { &DFLDSIZ;}' unless defined(&DFLDSIZ32);
    }
    unless(defined(&MAXDSIZ32)) {
	eval 'sub MAXDSIZ32 () { &MAXDSIZ;}' unless defined(&MAXDSIZ32);
    }
    unless(defined(&DFLSSIZ32)) {
	eval 'sub DFLSSIZ32 () { &DFLTSIZ;}' unless defined(&DFLSSIZ32);
    }
    unless(defined(&MAXSSIZ32)) {
	eval 'sub MAXSSIZ32 () { &MAXSSIZ;}' unless defined(&MAXSSIZ32);
    }
    unless(defined(&USRIOSIZE)) {
	eval 'sub USRIOSIZE () {( &MAXBSIZE/ &PAGE_SIZE * 8);}' unless defined(&USRIOSIZE);
    }
    eval 'sub VM_MIN_ADDRESS () {(( &vaddr_t) &PAGE_SIZE);}' unless defined(&VM_MIN_ADDRESS);
    if(defined(&_LP64)) {
	eval 'sub VM_MAXUSER_ADDRESS () {(( &vaddr_t)0x4000000000 - 16*  &PAGE_SIZE);}' unless defined(&VM_MAXUSER_ADDRESS);
	eval 'sub VM_MIN_KERNEL_ADDRESS () {(( &vaddr_t)0xffffffc000000000);}' unless defined(&VM_MIN_KERNEL_ADDRESS);
	eval 'sub VM_MAX_KERNEL_ADDRESS () {(( &vaddr_t)0xffffffd000000000);}' unless defined(&VM_MAX_KERNEL_ADDRESS);
    } else {
	eval 'sub VM_MAXUSER_ADDRESS () {(( &vaddr_t)-0x7fffffff-1);}' unless defined(&VM_MAXUSER_ADDRESS);
	eval 'sub VM_MIN_KERNEL_ADDRESS () {(( &vaddr_t)-0x7fffffff-1);}' unless defined(&VM_MIN_KERNEL_ADDRESS);
	eval 'sub VM_MAX_KERNEL_ADDRESS () {(( &vaddr_t)-0x10000000);}' unless defined(&VM_MAX_KERNEL_ADDRESS);
    }
    eval 'sub VM_KERNEL_BASE () { &VM_MIN_KERNEL_ADDRESS;}' unless defined(&VM_KERNEL_BASE);
    eval 'sub VM_KERNEL_SIZE () {0x2000000;}' unless defined(&VM_KERNEL_SIZE);
    eval 'sub VM_KERNEL_DTB_BASE () {( &VM_KERNEL_BASE +  &VM_KERNEL_SIZE);}' unless defined(&VM_KERNEL_DTB_BASE);
    eval 'sub VM_KERNEL_DTB_SIZE () {0x1000000;}' unless defined(&VM_KERNEL_DTB_SIZE);
    eval 'sub VM_KERNEL_IO_BASE () {( &VM_KERNEL_DTB_BASE +  &VM_KERNEL_DTB_SIZE);}' unless defined(&VM_KERNEL_IO_BASE);
    eval 'sub VM_KERNEL_IO_SIZE () {0x1000000;}' unless defined(&VM_KERNEL_IO_SIZE);
    eval 'sub VM_KERNEL_RESERVED () {( &VM_KERNEL_SIZE +  &VM_KERNEL_DTB_SIZE +  &VM_KERNEL_IO_SIZE);}' unless defined(&VM_KERNEL_RESERVED);
    eval 'sub VM_KERNEL_VM_BASE () {( &VM_MIN_KERNEL_ADDRESS +  &VM_KERNEL_RESERVED);}' unless defined(&VM_KERNEL_VM_BASE);
    eval 'sub VM_KERNEL_VM_SIZE () {( &VM_MAX_KERNEL_ADDRESS -  &VM_KERNEL_VM_BASE);}' unless defined(&VM_KERNEL_VM_SIZE);
    eval 'sub VM_MAX_ADDRESS () { &VM_MAXUSER_ADDRESS;}' unless defined(&VM_MAX_ADDRESS);
    eval 'sub VM_MAXUSER_ADDRESS32 () {(( &vaddr_t)(1 << 31));}' unless defined(&VM_MAXUSER_ADDRESS32);
    if(defined(&_LP64)) {
	eval 'sub RISCV_DIRECTMAP_MASK () {(( &vaddr_t) 0xffffffe000000000);}' unless defined(&RISCV_DIRECTMAP_MASK);
	eval 'sub RISCV_DIRECTMAP_SIZE () {(- &RISCV_DIRECTMAP_MASK -  &PAGE_SIZE);}' unless defined(&RISCV_DIRECTMAP_SIZE);
	eval 'sub RISCV_DIRECTMAP_START () { &RISCV_DIRECTMAP_MASK;}' unless defined(&RISCV_DIRECTMAP_START);
	eval 'sub RISCV_DIRECTMAP_END () {( &RISCV_DIRECTMAP_START +  &RISCV_DIRECTMAP_SIZE);}' unless defined(&RISCV_DIRECTMAP_END);
	eval 'sub RISCV_DIRECTMAP_P {
	    my($va) = @_;
    	    eval q(((( &vaddr_t) ($va) &  &RISCV_DIRECTMAP_MASK) ==  &RISCV_DIRECTMAP_MASK));
	}' unless defined(&RISCV_DIRECTMAP_P);
	eval 'sub RISCV_PA_TO_KVA {
	    my($pa) = @_;
    	    eval q((( &vaddr_t) (($pa) |  &RISCV_DIRECTMAP_START)));
	}' unless defined(&RISCV_PA_TO_KVA);
	eval 'sub RISCV_KVA_TO_PA {
	    my($va) = @_;
    	    eval q((( &paddr_t) (($va) & ~ &RISCV_DIRECTMAP_MASK)));
	}' unless defined(&RISCV_KVA_TO_PA);
    }
    eval 'sub __USE_TOPDOWN_VM () {1;}' unless defined(&__USE_TOPDOWN_VM);
    eval 'sub VM_DEFAULT_ADDRESS_TOPDOWN {
        my($da, $sz) = @_;
	    eval q( &trunc_page( &USRSTACK -  &MAXSSIZ - ($sz) -  &user_stack_guard_size));
    }' unless defined(&VM_DEFAULT_ADDRESS_TOPDOWN);
    eval 'sub VM_DEFAULT_ADDRESS_BOTTOMUP {
        my($da, $sz) = @_;
	    eval q( &round_page(( &vaddr_t)($da) + ( &vsize_t) &maxdmap));
    }' unless defined(&VM_DEFAULT_ADDRESS_BOTTOMUP);
    eval 'sub VM_DEFAULT_ADDRESS32_TOPDOWN {
        my($da, $sz) = @_;
	    eval q( &trunc_page( &USRSTACK32 -  &MAXSSIZ32 - ($sz) -  &user_stack_guard_size));
    }' unless defined(&VM_DEFAULT_ADDRESS32_TOPDOWN);
    eval 'sub VM_DEFAULT_ADDRESS32_BOTTOMUP {
        my($da, $sz) = @_;
	    eval q( &round_page(( &vaddr_t)($da) + ( &vsize_t) &MAXDSIZ32));
    }' unless defined(&VM_DEFAULT_ADDRESS32_BOTTOMUP);
    eval 'sub VM_PHYS_SIZE () {( &USRIOSIZE* &PAGE_SIZE);}' unless defined(&VM_PHYS_SIZE);
    eval 'sub VM_PHYSSEG_MAX () {64;}' unless defined(&VM_PHYSSEG_MAX);
    eval 'sub VM_PHYSSEG_STRAT () { &VM_PSTRAT_BSEARCH;}' unless defined(&VM_PHYSSEG_STRAT);
    unless(defined(&VM_NFREELIST)) {
	eval 'sub VM_NFREELIST () {2;}' unless defined(&VM_NFREELIST);
	eval 'sub VM_FREELIST_DEFAULT () {0;}' unless defined(&VM_FREELIST_DEFAULT);
	eval 'sub VM_FREELIST_DIRECTMAP () {1;}' unless defined(&VM_FREELIST_DIRECTMAP);
    }
    if(defined(&_KERNEL)) {
	if(defined(&_LP64)) {
	}
    }
}
1;
