/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.util;

import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import org.broad.igv.util.FilterElement;

public abstract class Filter {
    private String name;
    private LinkedHashSet<FilterElement> elements = new LinkedHashSet();
    private boolean isEnabled = true;

    public Filter(String name, List<? extends FilterElement> elements) {
        this.name = name;
        if (elements != null) {
            this.elements.addAll(elements);
        }
    }

    public void removeAll() {
        this.elements.clear();
    }

    public void setEnabled(boolean value) {
        this.isEnabled = value;
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    public boolean isEmpty() {
        return this.elements.isEmpty();
    }

    public Iterator getFilterElements() {
        return this.elements.iterator();
    }

    public void add(FilterElement element) {
        this.elements.add(element);
    }

    public void remove(FilterElement element) {
        this.elements.remove(element);
    }

    protected abstract void evaluate();

    public String getName() {
        return this.name;
    }
}

