/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.structure;

import htsjdk.samtools.BinaryTagCodec;
import htsjdk.samtools.SAMBinaryTagAndUnsignedArrayValue;
import htsjdk.samtools.SAMBinaryTagAndValue;
import htsjdk.samtools.SAMTag;
import htsjdk.samtools.ValidationStringency;
import htsjdk.samtools.cram.BAIEntry;
import htsjdk.samtools.cram.CRAIEntry;
import htsjdk.samtools.cram.CRAMException;
import htsjdk.samtools.cram.build.CRAMReferenceRegion;
import htsjdk.samtools.cram.common.CRAMVersion;
import htsjdk.samtools.cram.common.CramVersions;
import htsjdk.samtools.cram.digest.ContentDigests;
import htsjdk.samtools.cram.encoding.reader.CramRecordReader;
import htsjdk.samtools.cram.encoding.writer.CramRecordWriter;
import htsjdk.samtools.cram.io.CramIntArray;
import htsjdk.samtools.cram.io.ITF8;
import htsjdk.samtools.cram.io.InputStreamUtils;
import htsjdk.samtools.cram.io.LTF8;
import htsjdk.samtools.cram.ref.ReferenceContext;
import htsjdk.samtools.cram.structure.AlignmentContext;
import htsjdk.samtools.cram.structure.AlignmentSpan;
import htsjdk.samtools.cram.structure.CRAMCompressionRecord;
import htsjdk.samtools.cram.structure.CompressionHeader;
import htsjdk.samtools.cram.structure.CompressorCache;
import htsjdk.samtools.cram.structure.SliceBlocks;
import htsjdk.samtools.cram.structure.block.Block;
import htsjdk.samtools.cram.structure.block.BlockContentType;
import htsjdk.samtools.util.BinaryCodec;
import htsjdk.samtools.util.Log;
import htsjdk.samtools.util.RuntimeIOException;
import htsjdk.samtools.util.SequenceUtil;
import htsjdk.utils.ValidationUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Array;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class Slice {
    private static final Log log = Log.getInstance(Slice.class);
    private static final int MD5_BYTE_SIZE = 16;
    public static final int UNINITIALIZED_INDEXING_PARAMETER = -1;
    public static final int EMBEDDED_REFERENCE_ABSENT_CONTENT_ID = -1;
    private final AlignmentContext alignmentContext;
    private final int nRecords;
    private final long globalRecordCounter;
    private final int nSliceBlocks;
    private List<Integer> contentIDs;
    private int embeddedReferenceBlockContentID = -1;
    private byte[] referenceMD5 = new byte[16];
    private SAMBinaryTagAndValue sliceTags;
    private final CompressionHeader compressionHeader;
    private final SliceBlocks sliceBlocks;
    private final long byteOffsetOfContainer;
    private Block sliceHeaderBlock;
    private Block embeddedReferenceBlock;
    private long baseCount;
    private int mappedReadsCount = 0;
    private int unmappedReadsCount = 0;
    private int unplacedReadsCount = 0;
    private int byteOffsetOfSliceHeaderBlock = -1;
    private int byteSizeOfSliceBlocks = -1;
    private int landmarkIndex = -1;

    public Slice(CRAMVersion cramVersion, CompressionHeader compressionHeader, InputStream inputStream, long containerByteOffset) {
        this.sliceHeaderBlock = Block.read(cramVersion, inputStream);
        if (this.sliceHeaderBlock.getContentType() != BlockContentType.MAPPED_SLICE) {
            throw new RuntimeException("Slice Header Block expected, found:  " + this.sliceHeaderBlock.getContentType().name());
        }
        ByteArrayInputStream parseInputStream = new ByteArrayInputStream(this.sliceHeaderBlock.getRawContent());
        this.compressionHeader = compressionHeader;
        this.byteOffsetOfContainer = containerByteOffset;
        ReferenceContext refContext = new ReferenceContext(ITF8.readUnsignedITF8(parseInputStream));
        int alignmentStart = ITF8.readUnsignedITF8(parseInputStream);
        int alignmentSpan = ITF8.readUnsignedITF8(parseInputStream);
        this.alignmentContext = new AlignmentContext(refContext, alignmentStart, alignmentSpan);
        this.nRecords = ITF8.readUnsignedITF8(parseInputStream);
        this.globalRecordCounter = LTF8.readUnsignedLTF8(parseInputStream);
        this.nSliceBlocks = ITF8.readUnsignedITF8(parseInputStream);
        this.setContentIDs(CramIntArray.arrayAsList(parseInputStream));
        this.embeddedReferenceBlockContentID = ITF8.readUnsignedITF8(parseInputStream);
        this.referenceMD5 = new byte[16];
        InputStreamUtils.readFully(parseInputStream, this.referenceMD5, 0, this.referenceMD5.length);
        byte[] readTagBytes = InputStreamUtils.readFully(parseInputStream);
        if (cramVersion.getMajor() >= CramVersions.CRAM_v3.getMajor()) {
            this.setSliceTags(BinaryTagCodec.readTags(readTagBytes, 0, readTagBytes.length, ValidationStringency.DEFAULT_STRINGENCY));
        }
        this.sliceBlocks = new SliceBlocks(cramVersion, this.nSliceBlocks, inputStream);
        if (this.embeddedReferenceBlockContentID != -1) {
            this.setEmbeddedReferenceBlock(this.sliceBlocks.getExternalBlock(this.embeddedReferenceBlockContentID));
        }
    }

    public Slice(List<CRAMCompressionRecord> records, CompressionHeader compressionHeader, long containerByteOffset, long globalRecordCounter) {
        ValidationUtils.validateArg(globalRecordCounter >= 0L, "record counter must be >= 0");
        this.compressionHeader = compressionHeader;
        this.byteOffsetOfContainer = containerByteOffset;
        ContentDigests hasher = ContentDigests.create(ContentDigests.ALL);
        HashSet<ReferenceContext> referenceContexts = new HashSet<ReferenceContext>();
        int singleRefAlignmentStart = Integer.MAX_VALUE;
        int singleRefAlignmentEnd = 0;
        int baseCount = 0;
        for (CRAMCompressionRecord record : records) {
            hasher.add(record);
            baseCount += record.getReadLength();
            if (record.isPlaced()) {
                referenceContexts.add(new ReferenceContext(record.getReferenceIndex()));
                singleRefAlignmentStart = Math.min(record.getAlignmentStart(), singleRefAlignmentStart);
                singleRefAlignmentEnd = Math.max(record.getAlignmentEnd(), singleRefAlignmentEnd);
                if (record.isSegmentUnmapped()) {
                    ++this.unmappedReadsCount;
                } else {
                    ++this.mappedReadsCount;
                }
            } else {
                referenceContexts.add(ReferenceContext.UNMAPPED_UNPLACED_CONTEXT);
            }
            if (record.getAlignmentStart() != 0) continue;
            ++this.unplacedReadsCount;
        }
        this.alignmentContext = Slice.getDerivedAlignmentContext(referenceContexts, singleRefAlignmentStart, singleRefAlignmentEnd);
        this.sliceTags = hasher.getAsTags();
        this.nRecords = records.size();
        this.baseCount = baseCount;
        this.globalRecordCounter = globalRecordCounter;
        CramRecordWriter writer = new CramRecordWriter(this);
        this.sliceBlocks = writer.writeToSliceBlocks(records, this.alignmentContext.getAlignmentStart());
        this.nSliceBlocks = this.caclulateNumberOfBlocks();
    }

    public Block getSliceHeaderBlock() {
        return this.sliceHeaderBlock;
    }

    public AlignmentContext getAlignmentContext() {
        return this.alignmentContext;
    }

    public SliceBlocks getSliceBlocks() {
        return this.sliceBlocks;
    }

    public int getNumberOfRecords() {
        return this.nRecords;
    }

    public long getGlobalRecordCounter() {
        return this.globalRecordCounter;
    }

    public int getNumberOfBlocks() {
        return this.nSliceBlocks;
    }

    public List<Integer> getContentIDs() {
        return this.contentIDs;
    }

    private void setContentIDs(List<Integer> contentIDs) {
        this.contentIDs = contentIDs;
    }

    public byte[] getReferenceMD5() {
        return this.referenceMD5;
    }

    public int getByteOffsetOfSliceHeaderBlock() {
        return this.byteOffsetOfSliceHeaderBlock;
    }

    public void setByteOffsetOfSliceHeaderBlock(int byteOffsetOfSliceHeaderBlock) {
        this.byteOffsetOfSliceHeaderBlock = byteOffsetOfSliceHeaderBlock;
    }

    public int getByteSizeOfSliceBlocks() {
        return this.byteSizeOfSliceBlocks;
    }

    public void setByteSizeOfSliceBlocks(int byteSizeOfSliceBlocks) {
        this.byteSizeOfSliceBlocks = byteSizeOfSliceBlocks;
    }

    public void setLandmarkIndex(int landmarkIndex) {
        this.landmarkIndex = landmarkIndex;
    }

    public long getBaseCount() {
        return this.baseCount;
    }

    public SAMBinaryTagAndValue getSliceTags() {
        return this.sliceTags;
    }

    private void setSliceTags(SAMBinaryTagAndValue sliceTags) {
        this.sliceTags = sliceTags;
    }

    private int getMappedReadsCount() {
        return this.mappedReadsCount;
    }

    private int getUnmappedReadsCount() {
        return this.unmappedReadsCount;
    }

    private int getUnplacedReadsCount() {
        return this.unplacedReadsCount;
    }

    public void setEmbeddedReferenceContentID(int embeddedReferenceBlockContentID) {
        if (this.embeddedReferenceBlockContentID != -1 && this.embeddedReferenceBlockContentID != embeddedReferenceBlockContentID) {
            throw new CRAMException(String.format("Can't reset embedded reference content ID (old %d new %d)", this.embeddedReferenceBlockContentID, embeddedReferenceBlockContentID));
        }
        if (this.embeddedReferenceBlock != null && this.embeddedReferenceBlock.getContentId() != embeddedReferenceBlockContentID) {
            throw new CRAMException(String.format("Attempt to set embedded reference block content ID (%d) that is in conflictwith the content ID (%d) of the existing reference block ID", embeddedReferenceBlockContentID, this.embeddedReferenceBlock.getContentId()));
        }
        this.embeddedReferenceBlockContentID = embeddedReferenceBlockContentID;
    }

    public int getEmbeddedReferenceContentID() {
        return this.embeddedReferenceBlockContentID;
    }

    public void setEmbeddedReferenceBlock(Block embeddedReferenceBlock) {
        ValidationUtils.nonNull(embeddedReferenceBlock, "Embedded reference block must be non-null");
        ValidationUtils.validateArg(embeddedReferenceBlock.getContentId() != -1, String.format("Invalid content ID (%d) for embedded reference block", embeddedReferenceBlock.getContentId()));
        ValidationUtils.validateArg(embeddedReferenceBlock.getContentType() == BlockContentType.EXTERNAL, String.format("Invalid embedded reference block type (%s)", new Object[]{embeddedReferenceBlock.getContentType()}));
        if (this.embeddedReferenceBlock != null) {
            throw new CRAMException("Can't reset the slice embedded reference block");
        }
        if (this.embeddedReferenceBlockContentID != -1 && embeddedReferenceBlock.getContentId() != this.embeddedReferenceBlockContentID) {
            throw new CRAMException(String.format("Embedded reference block content id (%d) conflicts with existing block if (%d)", embeddedReferenceBlock.getContentId(), this.embeddedReferenceBlockContentID));
        }
        this.setEmbeddedReferenceContentID(embeddedReferenceBlock.getContentId());
        this.embeddedReferenceBlock = embeddedReferenceBlock;
    }

    public Block getEmbeddedReferenceBlock() {
        return this.embeddedReferenceBlock;
    }

    public CompressionHeader getCompressionHeader() {
        return this.compressionHeader;
    }

    public ArrayList<CRAMCompressionRecord> deserializeCRAMRecords(CompressorCache compressorCache, ValidationStringency validationStringency) {
        CramRecordReader cramRecordReader = new CramRecordReader(this, compressorCache, validationStringency);
        ArrayList<CRAMCompressionRecord> cramCompressionRecords = new ArrayList<CRAMCompressionRecord>(this.nRecords);
        int prevAlignmentStart = this.alignmentContext.getAlignmentStart();
        for (int i = 0; i < this.nRecords; ++i) {
            CRAMCompressionRecord cramCompressionRecord = cramRecordReader.readCRAMRecord(this.globalRecordCounter + (long)i, prevAlignmentStart);
            prevAlignmentStart = cramCompressionRecord.getAlignmentStart();
            cramCompressionRecords.add(cramCompressionRecord);
        }
        return cramCompressionRecords;
    }

    public void normalizeCRAMRecords(List<CRAMCompressionRecord> cramCompressionRecords, CRAMReferenceRegion cramReferenceRegion) {
        byte[] referenceBases = null;
        boolean hasEmbeddedReference = false;
        if (this.compressionHeader.isReferenceRequired()) {
            if (this.getAlignmentContext().getReferenceContext().isMappedSingleRef() && !this.referenceMD5IsValid(referenceBases = cramReferenceRegion.getReferenceBases(this.getAlignmentContext().getReferenceContext().getReferenceSequenceID()))) {
                throw new CRAMException(String.format("Reference sequence MD5 mismatch for slice: %s, expected MD5 %s", this.getAlignmentContext(), String.format("%032x", new BigInteger(1, this.getReferenceMD5()))));
            }
        } else {
            Block embeddedReferenceBlock = this.getEmbeddedReferenceBlock();
            if (embeddedReferenceBlock != null) {
                hasEmbeddedReference = true;
                cramReferenceRegion.setEmbeddedReference(embeddedReferenceBlock.getUncompressedContent(new CompressorCache()), this.getAlignmentContext().getReferenceContext().getReferenceSequenceID());
            }
        }
        for (CRAMCompressionRecord record : cramCompressionRecords) {
            if (!record.isReadPaired() || record.isDetached() || !record.isHasMateDownStream()) continue;
            CRAMCompressionRecord downMate = cramCompressionRecords.get((int)(record.getSequentialIndex() + (long)record.getRecordsToNextFragment() + 1L - this.globalRecordCounter));
            record.setNextSegment(downMate);
            downMate.setPreviousSegment(record);
        }
        for (CRAMCompressionRecord record : cramCompressionRecords) {
            if (record.getPreviousSegment() != null || record.getNextSegment() == null) continue;
            record.restoreMateInfo();
        }
        for (CRAMCompressionRecord record : cramCompressionRecords) {
            record.assignReadName();
        }
        for (CRAMCompressionRecord record : cramCompressionRecords) {
            if (record.isSegmentUnmapped()) continue;
            if (this.compressionHeader.isReferenceRequired()) {
                referenceBases = cramReferenceRegion.getReferenceBases(record.getReferenceIndex());
            } else if (hasEmbeddedReference) {
                referenceBases = cramReferenceRegion.getCurrentReferenceBases();
            }
            record.restoreReadBases(referenceBases, this.getReferenceOffset(hasEmbeddedReference), this.getCompressionHeader().getSubstitutionMatrix());
        }
        for (CRAMCompressionRecord record : cramCompressionRecords) {
            record.resolveQualityScores();
            record.setIsNormalized();
        }
    }

    private int getReferenceOffset(boolean hasEmbeddedReference) {
        ReferenceContext sliceReferenceContext = this.getAlignmentContext().getReferenceContext();
        return sliceReferenceContext.isMappedSingleRef() && hasEmbeddedReference ? this.getAlignmentContext().getAlignmentStart() - 1 : 0;
    }

    private int caclulateNumberOfBlocks() {
        return 1 + this.getSliceBlocks().getNumberOfExternalBlocks();
    }

    public void write(CRAMVersion cramVersion, OutputStream outputStream) {
        this.sliceHeaderBlock = Block.createRawSliceHeaderBlock(this.createSliceHeaderBlockContent(cramVersion));
        this.sliceHeaderBlock.write(cramVersion, outputStream);
        this.getSliceBlocks().writeBlocks(cramVersion, outputStream);
    }

    private byte[] createSliceHeaderBlockContent(CRAMVersion cramVersion) {
        SAMBinaryTagAndValue samBinaryTagAndValue;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ITF8.writeUnsignedITF8(this.getAlignmentContext().getReferenceContext().getReferenceContextID(), byteArrayOutputStream);
        ITF8.writeUnsignedITF8(this.getAlignmentContext().getAlignmentStart(), byteArrayOutputStream);
        ITF8.writeUnsignedITF8(this.getAlignmentContext().getAlignmentSpan(), byteArrayOutputStream);
        ITF8.writeUnsignedITF8(this.getNumberOfRecords(), byteArrayOutputStream);
        LTF8.writeUnsignedLTF8(this.getGlobalRecordCounter(), byteArrayOutputStream);
        ITF8.writeUnsignedITF8(this.getNumberOfBlocks(), byteArrayOutputStream);
        this.setContentIDs(this.getSliceBlocks().getExternalContentIDs());
        CramIntArray.write(this.getContentIDs(), (OutputStream)byteArrayOutputStream);
        ITF8.writeUnsignedITF8(this.getEmbeddedReferenceContentID(), byteArrayOutputStream);
        try {
            byteArrayOutputStream.write(this.getReferenceMD5() == null ? new byte[16] : this.getReferenceMD5());
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
        if (cramVersion.getMajor() >= CramVersions.CRAM_v3.getMajor() && (samBinaryTagAndValue = this.getSliceTags()) != null) {
            try (BinaryCodec binaryCodec = new BinaryCodec(byteArrayOutputStream);){
                BinaryTagCodec binaryTagCodec = new BinaryTagCodec(binaryCodec);
                while (samBinaryTagAndValue != null) {
                    binaryTagCodec.writeTag(samBinaryTagAndValue.tag, samBinaryTagAndValue.value, samBinaryTagAndValue.isUnsignedArray());
                    samBinaryTagAndValue = samBinaryTagAndValue.getNext();
                }
            }
        }
        return byteArrayOutputStream.toByteArray();
    }

    private void baiIndexInitializationCheck() {
        StringBuilder error = new StringBuilder();
        if (this.byteOffsetOfSliceHeaderBlock == -1) {
            error.append("Cannot index this Slice for BAI because its byteOffsetFromCompressionHeaderStart is unknown.").append(System.lineSeparator());
        }
        if (this.landmarkIndex == -1) {
            error.append("Cannot index this Slice for BAI because its index is unknown.").append(System.lineSeparator());
        }
        if (error.length() > 0) {
            throw new CRAMException(error.toString());
        }
    }

    private void craiIndexInitializationCheck() {
        StringBuilder error = new StringBuilder();
        if (this.byteOffsetOfSliceHeaderBlock == -1) {
            error.append("Cannot index this Slice for CRAI because its byteOffsetFromCompressionHeaderStart is unknown.").append(System.lineSeparator());
        }
        if (this.byteSizeOfSliceBlocks == -1) {
            error.append("Cannot index this Slice for CRAI because its byteSize is unknown.").append(System.lineSeparator());
        }
        if (error.length() > 0) {
            throw new CRAMException(error.toString());
        }
    }

    private static final AlignmentContext getDerivedAlignmentContext(Set<ReferenceContext> sliceReferenceContexts, int singleRefAlignmentStart, int singleRefAlignmentEnd) {
        ReferenceContext referenceContext;
        switch (sliceReferenceContexts.size()) {
            case 0: {
                referenceContext = ReferenceContext.UNMAPPED_UNPLACED_CONTEXT;
                break;
            }
            case 1: {
                referenceContext = sliceReferenceContexts.iterator().next();
                break;
            }
            default: {
                referenceContext = ReferenceContext.MULTIPLE_REFERENCE_CONTEXT;
            }
        }
        if (referenceContext.isMappedSingleRef()) {
            AlignmentContext.validateAlignmentContext(true, referenceContext, singleRefAlignmentStart, singleRefAlignmentEnd - singleRefAlignmentStart + 1);
            return new AlignmentContext(referenceContext, singleRefAlignmentStart, singleRefAlignmentEnd - singleRefAlignmentStart + 1);
        }
        if (referenceContext.isUnmappedUnplaced()) {
            return AlignmentContext.UNMAPPED_UNPLACED_CONTEXT;
        }
        return AlignmentContext.MULTIPLE_REFERENCE_CONTEXT;
    }

    private void validateAlignmentSpanForReference(byte[] referenceBases) {
        if (this.alignmentContext.getReferenceContext().isUnmappedUnplaced()) {
            return;
        }
        if (referenceBases == null && this.alignmentContext.getAlignmentStart() > 0 && this.alignmentContext.getReferenceContext().isMappedSingleRef()) {
            throw new CRAMException("No reference bases found for mapped slice .");
        }
        if (this.alignmentContext.getAlignmentStart() > referenceBases.length) {
            log.warn(String.format("Slice mapped outside of reference: seqID=%s, start=%d, record counter=%d.", this.alignmentContext.getReferenceContext(), this.alignmentContext.getAlignmentStart(), this.globalRecordCounter));
        }
        if (this.alignmentContext.getAlignmentStart() - 1 + this.alignmentContext.getAlignmentSpan() > referenceBases.length) {
            log.warn(String.format("Slice mapped outside of reference: seqID=%s, start=%d, span=%d, counter=%d.", this.alignmentContext.getReferenceContext(), this.alignmentContext.getAlignmentStart(), this.alignmentContext.getAlignmentSpan(), this.globalRecordCounter));
        }
    }

    boolean referenceMD5IsValid(byte[] referenceBases) {
        if (this.alignmentContext.getReferenceContext().isMappedSingleRef() && this.compressionHeader.isReferenceRequired()) {
            this.validateAlignmentSpanForReference(referenceBases);
            if (!Slice.referenceMD5IsValid(referenceBases, this.alignmentContext.getAlignmentStart(), this.alignmentContext.getAlignmentSpan(), this.referenceMD5)) {
                throw new CRAMException(String.format("Reference MD5 failed to validate against %s", String.format("%032x", new BigInteger(1, this.referenceMD5))));
            }
        }
        return true;
    }

    private static boolean referenceMD5IsValid(byte[] referenceBases, int alignmentStart, int alignmentSpan, byte[] expectedMD5) {
        int span = Math.min(alignmentSpan, referenceBases.length - alignmentStart + 1);
        byte[] md5 = SequenceUtil.calculateMD5(referenceBases, alignmentStart - 1, span);
        return Arrays.equals(md5, expectedMD5);
    }

    public String toString() {
        return String.format("slice: %s globalRecordCounter=%d, nRecords=%d, sliceHeaderOffset=%d, sizeOfBlocks=%d, landmark=%d, mapped/unmapped/unplaced: %d/%d/%d, md5=%s", this.alignmentContext, this.globalRecordCounter, this.nRecords, this.getByteOffsetOfSliceHeaderBlock(), this.getByteSizeOfSliceBlocks(), this.landmarkIndex, this.mappedReadsCount, this.unmappedReadsCount, this.unmappedReadsCount, String.format("%032x", new BigInteger(1, this.getReferenceMD5())));
    }

    public void setReferenceMD5(byte[] ref) {
        this.validateAlignmentSpanForReference(ref);
        if (!this.alignmentContext.getReferenceContext().isMappedSingleRef() && this.alignmentContext.getAlignmentStart() < 1) {
            this.referenceMD5 = new byte[16];
        } else {
            int span = Math.min(this.alignmentContext.getAlignmentSpan(), ref.length - this.alignmentContext.getAlignmentStart() + 1);
            if (this.alignmentContext.getAlignmentStart() + span > ref.length + 1) {
                throw new CRAMException("Invalid alignment boundaries.");
            }
            this.referenceMD5 = SequenceUtil.calculateMD5(ref, this.alignmentContext.getAlignmentStart() - 1, span);
        }
    }

    public void setAttribute(String tag, Object value) {
        if (value != null && value.getClass().isArray() && Array.getLength(value) == 0) {
            throw new IllegalArgumentException("Empty value passed for tag " + tag);
        }
        this.setAttribute(SAMTag.makeBinaryTag(tag), value);
    }

    void setAttribute(short tag, Object value) {
        this.setAttribute(tag, value, false);
    }

    void setAttribute(short tag, Object value, boolean isUnsignedArray) {
        if (value == null) {
            if (this.sliceTags != null) {
                this.sliceTags = this.sliceTags.remove(tag);
            }
        } else {
            SAMBinaryTagAndValue tmp = !isUnsignedArray ? new SAMBinaryTagAndValue(tag, value) : new SAMBinaryTagAndUnsignedArrayValue(tag, value);
            this.sliceTags = this.sliceTags == null ? tmp : this.sliceTags.insert(tmp);
        }
    }

    public Map<ReferenceContext, AlignmentSpan> getMultiRefAlignmentSpans(CompressorCache compressorCache, ValidationStringency validationStringency) {
        if (!this.getAlignmentContext().getReferenceContext().isMultiRef()) {
            throw new IllegalStateException("can only create multiref span reader for multiref context slice");
        }
        ArrayList<CRAMCompressionRecord> cramCompressionRecords = this.deserializeCRAMRecords(compressorCache, validationStringency);
        HashMap spans = new HashMap();
        cramCompressionRecords.forEach(r -> this.mergeRecordSpan((CRAMCompressionRecord)r, spans));
        return Collections.unmodifiableMap(spans);
    }

    private void mergeRecordSpan(CRAMCompressionRecord cramCompressionRecord, Map<ReferenceContext, AlignmentSpan> spans) {
        if (cramCompressionRecord.isSegmentUnmapped()) {
            if (cramCompressionRecord.getAlignmentStart() == 0) {
                AlignmentSpan span = new AlignmentSpan(0, 0, 0, 1, 1);
                spans.merge(ReferenceContext.UNMAPPED_UNPLACED_CONTEXT, span, AlignmentSpan::combine);
            } else {
                AlignmentSpan span = new AlignmentSpan(cramCompressionRecord.getAlignmentStart(), cramCompressionRecord.getReadLength(), 0, 1, 0);
                int refIndex = cramCompressionRecord.getReferenceIndex();
                spans.merge(new ReferenceContext(refIndex), span, AlignmentSpan::combine);
            }
        } else {
            AlignmentSpan span = new AlignmentSpan(cramCompressionRecord.getAlignmentStart(), cramCompressionRecord.getAlignmentEnd() - cramCompressionRecord.getAlignmentStart(), 1, 0, 0);
            ReferenceContext recordContext = new ReferenceContext(cramCompressionRecord.getReferenceIndex());
            spans.merge(recordContext, span, AlignmentSpan::combine);
        }
    }

    public List<CRAIEntry> getCRAIEntries(CompressorCache compressorCache) {
        this.craiIndexInitializationCheck();
        if (this.alignmentContext.getReferenceContext().isMultiRef()) {
            Map<ReferenceContext, AlignmentSpan> spans = this.getMultiRefAlignmentSpans(compressorCache, ValidationStringency.DEFAULT_STRINGENCY);
            return spans.entrySet().stream().map(e -> new CRAIEntry(((ReferenceContext)e.getKey()).getReferenceContextID(), ((AlignmentSpan)e.getValue()).getAlignmentStart(), ((AlignmentSpan)e.getValue()).getAlignmentSpan(), this.byteOffsetOfContainer, this.byteOffsetOfSliceHeaderBlock, this.byteSizeOfSliceBlocks)).sorted().collect(Collectors.toList());
        }
        int sequenceId = this.alignmentContext.getReferenceContext().getReferenceContextID();
        return Collections.singletonList(new CRAIEntry(sequenceId, this.alignmentContext.getAlignmentStart(), this.alignmentContext.getAlignmentSpan(), this.byteOffsetOfContainer, this.byteOffsetOfSliceHeaderBlock, this.byteSizeOfSliceBlocks));
    }

    public List<BAIEntry> getBAIEntries(CompressorCache compressorCache) {
        this.baiIndexInitializationCheck();
        ArrayList<BAIEntry> baiEntries = new ArrayList<BAIEntry>();
        switch (this.getAlignmentContext().getReferenceContext().getType()) {
            case UNMAPPED_UNPLACED_TYPE: {
                baiEntries.add(new BAIEntry(this.getAlignmentContext().getReferenceContext(), new AlignmentSpan(0, 0, this.mappedReadsCount, this.unmappedReadsCount, this.unplacedReadsCount), this.byteOffsetOfContainer, this.byteOffsetOfSliceHeaderBlock, this.landmarkIndex));
                break;
            }
            case MULTIPLE_REFERENCE_TYPE: {
                Map<ReferenceContext, AlignmentSpan> sliceSpanMap = this.getMultiRefAlignmentSpans(compressorCache, ValidationStringency.LENIENT);
                sliceSpanMap.entrySet().stream().filter(as -> !((ReferenceContext)as.getKey()).equals(ReferenceContext.UNMAPPED_UNPLACED_CONTEXT)).forEach(entry -> baiEntries.add(new BAIEntry((ReferenceContext)entry.getKey(), new AlignmentSpan(((AlignmentSpan)entry.getValue()).getAlignmentStart(), ((AlignmentSpan)entry.getValue()).getAlignmentSpan(), ((AlignmentSpan)entry.getValue()).getMappedCount(), ((AlignmentSpan)entry.getValue()).getUnmappedCount(), ((AlignmentSpan)entry.getValue()).getUnmappedUnplacedCount()), this.byteOffsetOfContainer, this.byteOffsetOfSliceHeaderBlock, this.landmarkIndex)));
                AlignmentSpan unmappedSpan = sliceSpanMap.get(ReferenceContext.UNMAPPED_UNPLACED_CONTEXT);
                if (unmappedSpan == null) break;
                baiEntries.add(new BAIEntry(ReferenceContext.UNMAPPED_UNPLACED_CONTEXT, unmappedSpan, this.byteOffsetOfContainer, this.byteOffsetOfSliceHeaderBlock, this.landmarkIndex));
                break;
            }
            default: {
                baiEntries.add(new BAIEntry(this.getAlignmentContext().getReferenceContext(), new AlignmentSpan(this.getAlignmentContext().getAlignmentStart(), this.getAlignmentContext().getAlignmentSpan(), this.getMappedReadsCount(), this.getUnmappedReadsCount(), this.getUnplacedReadsCount()), this.byteOffsetOfContainer, this.byteOffsetOfSliceHeaderBlock, this.landmarkIndex));
            }
        }
        return baiEntries;
    }
}

