/*
 * Decompiled with CFR 0.152.
 */
package phase;

import beagleutil.PbwtUpdater;
import java.util.BitSet;
import java.util.Optional;
import java.util.stream.IntStream;
import phase.FixedPhaseData;
import vcf.GT;
import vcf.RefGT;

public class PbwtRecPhaser {
    private final GT targGT;
    private final Optional<RefGT> optRef;
    private final int phasedOverlap;
    private final int nTargHaps;
    private final int nTargSamples;
    private final int nHaps;
    private final int[] a;
    private final int[] invA;
    private final PbwtUpdater pbwt;

    public PbwtRecPhaser(FixedPhaseData fixedPhaseData) {
        this.targGT = fixedPhaseData.stage1TargGT();
        this.optRef = fixedPhaseData.stage1RefGT();
        this.phasedOverlap = fixedPhaseData.stage1Overlap();
        this.nTargHaps = this.targGT.nHaps();
        this.nTargSamples = this.targGT.nSamples();
        this.nHaps = this.targGT.nHaps() + (this.optRef.isPresent() ? this.optRef.get().nHaps() : 0);
        this.a = IntStream.range(0, this.nHaps).toArray();
        this.invA = IntStream.range(0, this.nHaps).toArray();
        this.pbwt = new PbwtUpdater(this.nHaps);
    }

    public int nHaps() {
        return this.nHaps;
    }

    public GT targGT() {
        return this.targGT;
    }

    public int[] phase(int n, int[] nArray, int n2, boolean[] blArray, boolean[] blArray2) {
        this.checkArrays(nArray, blArray, blArray2);
        if (n != -1) {
            this.pbwt.update(nArray, this.targGT.marker(n).nAlleles(), this.a);
        }
        int[] nArray2 = this.setAlleles(n2, nArray, blArray2, blArray);
        if (n2 >= this.phasedOverlap) {
            this.phase(nArray, blArray2);
        }
        return nArray2;
    }

    private void checkArrays(int[] nArray, boolean[] blArray, boolean[] blArray2) {
        if (nArray.length != this.nHaps) {
            throw new IllegalArgumentException(String.valueOf(nArray.length));
        }
        if (blArray.length != this.nTargSamples) {
            throw new IllegalArgumentException(String.valueOf(blArray.length));
        }
        if (blArray2.length != this.nTargSamples) {
            throw new IllegalArgumentException(String.valueOf(blArray2.length));
        }
    }

    private void phase(int[] nArray, boolean[] blArray) {
        this.setInvA(this.a);
        int n = 2;
        boolean bl = true;
        while (n > 0 || bl) {
            bl = false;
            for (int i = 0; i < this.nTargSamples; ++i) {
                if (blArray[i]) {
                    bl |= this.phase(i, n, nArray, blArray, this.a);
                    continue;
                }
                int n2 = i << 1;
                int n3 = n2 | 1;
                if (nArray[n2] == -1) {
                    nArray[n2] = this.impute(nArray, blArray, this.a, this.invA[n2]);
                    bl |= nArray[n2] >= 0;
                }
                if (nArray[n3] != -1) continue;
                nArray[n3] = this.impute(nArray, blArray, this.a, this.invA[n3]);
                bl |= nArray[n3] >= 0;
            }
            if (bl) continue;
            --n;
        }
    }

    private boolean phase(int n, int n2, int[] nArray, boolean[] blArray, int[] nArray2) {
        int n3;
        int n4 = n << 1;
        int n5 = n4 | 1;
        int n6 = nArray[n4];
        int n7 = nArray[n5];
        assert (n6 >= 0 && n7 >= 0 && n6 != n7);
        int n8 = this.phaseCnt(nArray2, nArray, blArray, this.invA[n4], n6, n7);
        int n9 = n8 + (n3 = this.phaseCnt(nArray2, nArray, blArray, this.invA[n5], n7, n6));
        if (n9 >= n2) {
            blArray[n] = false;
            return true;
        }
        if (n9 <= -n2) {
            nArray[n4] = n7;
            nArray[n5] = n6;
            blArray[n] = false;
            return true;
        }
        return false;
    }

    private int phaseCnt(int[] nArray, int[] nArray2, boolean[] blArray, int n, int n2, int n3) {
        int n4;
        int n5;
        int n6 = 0;
        if (!(n <= 0 || (n5 = (n4 = nArray[n - 1]) >> 1) < blArray.length && blArray[n5])) {
            n6 += PbwtRecPhaser.phaseCnt(nArray2[n4], n2, n3);
        }
        if (!(n + 1 >= nArray2.length || (n5 = (n4 = nArray[n + 1]) >> 1) < blArray.length && blArray[n5])) {
            n6 += PbwtRecPhaser.phaseCnt(nArray2[n4], n2, n3);
        }
        return n6;
    }

    private static int phaseCnt(int n, int n2, int n3) {
        if (n == n2) {
            return 1;
        }
        if (n == n3) {
            return -1;
        }
        return 0;
    }

    private int impute(int[] nArray, boolean[] blArray, int[] nArray2, int n) {
        int n2;
        int n3;
        int n4 = -1;
        int n5 = -1;
        if (!(n <= 0 || (n3 = (n2 = nArray2[n - 1]) >> 1) < blArray.length && blArray[n3])) {
            n4 = nArray[n2];
        }
        if (!(n + 1 >= nArray2.length || (n3 = (n2 = nArray2[n + 1]) >> 1) < blArray.length && blArray[n3])) {
            n5 = nArray[n2];
        }
        if (n4 >= 0 && (n4 == n5 || n5 < 0)) {
            return n4;
        }
        if (n4 < 0 && n5 >= 0) {
            return n5;
        }
        return -1;
    }

    private void setInvA(int[] nArray) {
        for (int i = 0; i < nArray.length; ++i) {
            this.invA[nArray[i]] = i;
        }
    }

    private int[] setAlleles(int n, int[] nArray, boolean[] blArray, boolean[] blArray2) {
        int[] nArray2 = new int[this.targGT.marker(n).nAlleles()];
        this.setTargAlleles(n, nArray, blArray, blArray2, nArray2);
        if (this.optRef.isPresent()) {
            this.setRefAlleles(n, nArray, nArray2);
        }
        for (int i = 1; i < nArray2.length; ++i) {
            int n2 = i;
            nArray2[n2] = nArray2[n2] + nArray2[i - 1];
        }
        return nArray2;
    }

    private void setTargAlleles(int n, int[] nArray, boolean[] blArray, boolean[] blArray2, int[] nArray2) {
        for (int i = 0; i < this.nTargSamples; ++i) {
            int n2 = i << 1;
            int n3 = n2 | 1;
            int n4 = this.targGT.allele(n, n2);
            int n5 = this.targGT.allele(n, n3);
            nArray[n2] = n4;
            nArray[n3] = n5;
            blArray[i] = n >= this.phasedOverlap && n4 >= 0 && n5 >= 0 && n4 != n5;
            boolean bl = blArray2[i] = n4 < 0 || n5 < 0;
            if (n4 >= 0) {
                int n6 = n4;
                nArray2[n6] = nArray2[n6] + 1;
            }
            if (n5 < 0) continue;
            int n7 = n5;
            nArray2[n7] = nArray2[n7] + 1;
        }
    }

    private void setRefAlleles(int n, int[] nArray, int[] nArray2) {
        assert (this.optRef.isPresent());
        RefGT refGT = this.optRef.get();
        int n2 = 0;
        for (int i = this.nTargHaps; i < this.nHaps; i += 2) {
            int n3 = i | 1;
            int n4 = refGT.allele(n, n2++);
            int n5 = refGT.allele(n, n2++);
            nArray[i] = n4;
            nArray[n3] = n5;
            int n6 = n4;
            nArray2[n6] = nArray2[n6] + 1;
            int n7 = n5;
            nArray2[n7] = nArray2[n7] + 1;
        }
    }

    public static BitSet[] bitSets(int n, int n3) {
        if (n < 0) {
            throw new IllegalArgumentException(String.valueOf(n));
        }
        return (BitSet[])IntStream.range(0, n).mapToObj(n2 -> new BitSet(n3)).toArray(BitSet[]::new);
    }
}

