/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.user.client.ui;

import com.google.gwt.dom.client.Element;
import com.google.gwt.i18n.client.BidiUtils;
import com.google.gwt.i18n.client.HasDirection;
import com.google.gwt.i18n.shared.BidiFormatter;
import com.google.gwt.i18n.shared.DirectionEstimator;
import com.google.gwt.i18n.shared.HasDirectionEstimator;
import com.google.gwt.i18n.shared.WordCountDirectionEstimator;

public class DirectionalTextHelper
implements HasDirectionEstimator {
    public static final DirectionEstimator DEFAULT_DIRECTION_ESTIMATOR = WordCountDirectionEstimator.get();
    private DirectionEstimator directionEstimator;
    private final Element element;
    private HasDirection.Direction initialElementDir;
    private boolean isDirectionExplicitlySet;
    private final boolean isElementInline;
    private boolean isSpanWrapped;
    private HasDirection.Direction textDir;

    public DirectionalTextHelper(Element element, boolean isElementInline) {
        this.element = element;
        this.isElementInline = isElementInline;
        this.isSpanWrapped = false;
        this.textDir = this.initialElementDir = BidiUtils.getDirectionOnElement(element);
        this.isDirectionExplicitlySet = true;
    }

    @Override
    public DirectionEstimator getDirectionEstimator() {
        return this.directionEstimator;
    }

    public HasDirection.Direction getTextDirection() {
        return this.textDir;
    }

    public String getTextOrHtml(boolean isHtml) {
        Element elem = this.isSpanWrapped ? this.element.getFirstChildElement() : this.element;
        return isHtml ? elem.getInnerHTML() : elem.getInnerText();
    }

    @Deprecated
    public void setDirection(HasDirection.Direction direction) {
        BidiUtils.setDirectionOnElement(this.element, direction);
        this.initialElementDir = direction;
        this.setInnerTextOrHtml(this.getTextOrHtml(true), true);
        this.isSpanWrapped = false;
        this.textDir = this.initialElementDir;
        this.isDirectionExplicitlySet = true;
    }

    @Override
    public void setDirectionEstimator(boolean enabled) {
        this.setDirectionEstimator(enabled ? DEFAULT_DIRECTION_ESTIMATOR : null);
    }

    @Override
    public void setDirectionEstimator(DirectionEstimator directionEstimator) {
        this.directionEstimator = directionEstimator;
        if (!this.isDirectionExplicitlySet) {
            this.setTextOrHtml(this.getTextOrHtml(true), true);
        }
    }

    public void setTextOrHtml(String content, boolean isHtml) {
        if (this.directionEstimator == null) {
            this.isSpanWrapped = false;
            this.setInnerTextOrHtml(content, isHtml);
            if (this.textDir != this.initialElementDir) {
                this.textDir = this.initialElementDir;
                BidiUtils.setDirectionOnElement(this.element, this.initialElementDir);
            }
        } else {
            this.setTextOrHtml(content, this.directionEstimator.estimateDirection(content, isHtml), isHtml);
        }
        this.isDirectionExplicitlySet = false;
    }

    public void setTextOrHtml(String content, HasDirection.Direction dir, boolean isHtml) {
        this.textDir = dir;
        if (this.isElementInline) {
            this.isSpanWrapped = true;
            this.element.setInnerHTML(BidiFormatter.getInstanceForCurrentLocale(true).spanWrapWithKnownDir(dir, content, isHtml));
        } else {
            this.isSpanWrapped = false;
            BidiUtils.setDirectionOnElement(this.element, dir);
            this.setInnerTextOrHtml(content, isHtml);
        }
        this.isDirectionExplicitlySet = true;
    }

    private void setInnerTextOrHtml(String content, boolean isHtml) {
        if (isHtml) {
            this.element.setInnerHTML(content);
        } else {
            this.element.setInnerText(content);
        }
    }
}

