# Copyright (C) 2008 LottaNZB Development Team
# 
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; version 3.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA.

"""Contains classes for all messages put out by the NZBLeecher module."""

from lottanzb.hellalog import LogRecord, _Plural, _ExceptionHandler
from lottanzb.util import _

class OpeningConnectionsInfo(_Plural, LogRecord): # connectServer(...)
    PATTERN = r"^\((?P<server_name>.*)\) Opening (?P<connections>\d+) connections?\.\.\.$"
    TEMPLATE = _("Opening %(connections)s connection to %(server_name)s...")
    TEMPLATE_2 = _("Opening %(connections)s connections to %(server_name)s...")

class OpenSSLNotAvailableError(LogRecord): # connectServer(...)
    PATTERN = r"^Unable to use SSL for server: (?P<server_name>.*)\npyOpenSSL is not installed:"
    TEMPLATE = _("Unable to use SSL for server %(server_name)s. The Python bindings for OpenSSL are not installed.")

class articledecoder:
    '''Contains classes for all messages put out by the NZBLeecher.ArticleDecoder module'''
    
    class SegmentDecodingError(_ExceptionHandler, LogRecord): # decode(...)
        PATTERN = r"^(?P<file_name>.+) segment: (?P<segment_number>\d+) a problem occurred during decoding"
        TEMPLATE = _("Unable to decode segment %(segment_number)s in %(file_name)s")

    # Necessary?
    class ParsingArticleFileNameFatal(LogRecord): # parseArticleData(...)
        PATTERN = r"Could not getFilenameFromArticleData"
        TEMPLATE = _("Could not get file name from article data")
    
    # Necessary?
    class ParsingArticleInvalidYBeginLineFatal(LogRecord): # parseArticleData(...)
        PATTERN = r"\* Invalid =ybegin line in part (?P<segment_number>\d+)!"
        TEMPLATE = _("Invalid =ybegin line in part %(segment_number)s.")
        
    # Necessary?
    class ParsingArticleInvalidBeginLineFatal(LogRecord): # parseArticleData(...)
        PATTERN = r"\* Invalid begin line in part (?P<segment_number>\d+)!"
        TEMPLATE = _("Invalid begin line in part %(segment_number)s.")
    
    class OutOfDiskSpaceError(LogRecord): # handleIOError(...)
        PATTERN = r"^No space left on device!$"
        TEMPLATE = _("No space left on device!")
