/*
 * Decompiled with CFR 0.152.
 */
package com.xerox.VTM.glyphs;

import com.xerox.VTM.engine.Camera;
import com.xerox.VTM.glyphs.ClosedShape;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import net.claribole.zvtm.glyphs.projection.ProjOctagon;

public class VOctagon
extends ClosedShape {
    int[] xcoords = new int[8];
    int[] ycoords = new int[8];
    long vs;
    ProjOctagon[] pc;

    public VOctagon() {
        this.vx = 0L;
        this.vy = 0L;
        this.vz = 0;
        this.vs = 10L;
        this.computeSize();
        this.orient = 0.0f;
        this.setColor(Color.white);
        this.setBorderColor(Color.black);
    }

    public VOctagon(long x, long y, int z, long s, Color c) {
        this.vx = x;
        this.vy = y;
        this.vz = z;
        this.vs = s;
        this.computeSize();
        this.orient = 0.0f;
        this.setColor(c);
        this.setBorderColor(Color.black);
    }

    public VOctagon(long x, long y, int z, long s, Color c, Color bc) {
        this.vx = x;
        this.vy = y;
        this.vz = z;
        this.vs = s;
        this.computeSize();
        this.orient = 0.0f;
        this.setColor(c);
        this.setBorderColor(bc);
    }

    public void initCams(int nbCam) {
        this.pc = new ProjOctagon[nbCam];
        for (int i = 0; i < nbCam; ++i) {
            this.pc[i] = new ProjOctagon();
        }
    }

    public void addCamera(int verifIndex) {
        if (this.pc != null) {
            if (verifIndex == this.pc.length) {
                ProjOctagon[] ta = this.pc;
                this.pc = new ProjOctagon[ta.length + 1];
                for (int i = 0; i < ta.length; ++i) {
                    this.pc[i] = ta[i];
                }
                this.pc[this.pc.length - 1] = new ProjOctagon();
            } else {
                System.err.println("VOctagon:Error while adding camera " + verifIndex);
            }
        } else if (verifIndex == 0) {
            this.pc = new ProjOctagon[1];
            this.pc[0] = new ProjOctagon();
        } else {
            System.err.println("VOctagon:Error while adding camera " + verifIndex);
        }
    }

    public void removeCamera(int index) {
        this.pc[index] = null;
    }

    public void resetMouseIn() {
        for (int i = 0; i < this.pc.length; ++i) {
            this.resetMouseIn(i);
        }
    }

    public void resetMouseIn(int i) {
        if (this.pc[i] != null) {
            this.pc[i].prevMouseIn = false;
        }
        this.borderColor = this.bColor;
    }

    public float getOrient() {
        return this.orient;
    }

    public void orientTo(float angle) {
    }

    public float getSize() {
        return this.size;
    }

    void computeSize() {
        this.size = (float)this.vs * 1.118f;
    }

    public void sizeTo(float radius) {
        this.size = radius;
        this.vs = Math.round(this.size / 1.118f);
        try {
            this.vsm.repaintNow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void reSize(float factor) {
        this.size *= factor;
        this.vs = Math.round(this.size / 1.118f);
        try {
            this.vsm.repaintNow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public boolean fillsView(long w, long h, int camIndex) {
        return this.pc[camIndex].p.contains(0, 0) && this.pc[camIndex].p.contains(w, 0.0) && this.pc[camIndex].p.contains(0.0, h) && this.pc[camIndex].p.contains(w, h);
    }

    public boolean coordInside(int jpx, int jpy, int camIndex, long cvx, long cvy) {
        return this.pc[camIndex].p.contains(jpx, jpy);
    }

    public boolean visibleInDisc(long dvx, long dvy, long dvr, Shape dvs, int camIndex, int jpx, int jpy, int dpr) {
        return this.pc[camIndex].p.intersects(jpx - dpr, jpy - dpr, 2 * dpr, 2 * dpr);
    }

    public short mouseInOut(int jpx, int jpy, int camIndex, long cvx, long cvy) {
        if (this.coordInside(jpx, jpy, camIndex, cvx, cvy)) {
            if (!this.pc[camIndex].prevMouseIn) {
                this.pc[camIndex].prevMouseIn = true;
                return 1;
            }
            return 0;
        }
        if (this.pc[camIndex].prevMouseIn) {
            this.pc[camIndex].prevMouseIn = false;
            return -1;
        }
        return 0;
    }

    public void project(Camera c, Dimension d) {
        int i = c.getIndex();
        this.coef = c.focal / (c.focal + c.altitude);
        this.pc[i].cx = d.width / 2 + Math.round((float)(this.vx - c.posx) * this.coef);
        this.pc[i].cy = d.height / 2 - Math.round((float)(this.vy - c.posy) * this.coef);
        this.pc[i].cr = Math.round((float)this.vs * this.coef);
        this.pc[i].halfcr = this.pc[i].cr / 2;
        this.xcoords[0] = this.pc[i].cx + this.pc[i].cr;
        this.ycoords[0] = this.pc[i].cy - this.pc[i].halfcr;
        this.xcoords[1] = this.pc[i].cx + this.pc[i].halfcr;
        this.ycoords[1] = this.pc[i].cy - this.pc[i].cr;
        this.xcoords[2] = this.pc[i].cx - this.pc[i].halfcr;
        this.ycoords[2] = this.pc[i].cy - this.pc[i].cr;
        this.xcoords[3] = this.pc[i].cx - this.pc[i].cr;
        this.ycoords[3] = this.pc[i].cy - this.pc[i].halfcr;
        this.xcoords[4] = this.pc[i].cx - this.pc[i].cr;
        this.ycoords[4] = this.pc[i].cy + this.pc[i].halfcr;
        this.xcoords[5] = this.pc[i].cx - this.pc[i].halfcr;
        this.ycoords[5] = this.pc[i].cy + this.pc[i].cr;
        this.xcoords[6] = this.pc[i].cx + this.pc[i].halfcr;
        this.ycoords[6] = this.pc[i].cy + this.pc[i].cr;
        this.xcoords[7] = this.pc[i].cx + this.pc[i].cr;
        this.ycoords[7] = this.pc[i].cy + this.pc[i].halfcr;
        if (this.pc[i].p == null) {
            this.pc[i].p = new Polygon(this.xcoords, this.ycoords, 8);
        } else {
            for (int j = 0; j < this.xcoords.length; ++j) {
                this.pc[i].p.xpoints[j] = this.xcoords[j];
                this.pc[i].p.ypoints[j] = this.ycoords[j];
            }
            this.pc[i].p.invalidate();
        }
    }

    public void projectForLens(Camera c, int lensWidth, int lensHeight, float lensMag, long lensx, long lensy) {
        int i = c.getIndex();
        this.coef = c.focal / (c.focal + c.altitude) * lensMag;
        this.pc[i].lcx = lensWidth / 2 + Math.round((float)(this.vx - lensx) * this.coef);
        this.pc[i].lcy = lensHeight / 2 - Math.round((float)(this.vy - lensy) * this.coef);
        this.pc[i].lcr = Math.round((float)this.vs * this.coef);
        this.pc[i].lhalfcr = this.pc[i].cr / 2;
        this.xcoords[0] = this.pc[i].lcx + this.pc[i].lcr;
        this.ycoords[0] = this.pc[i].lcy - this.pc[i].lhalfcr;
        this.xcoords[1] = this.pc[i].lcx + this.pc[i].lhalfcr;
        this.ycoords[1] = this.pc[i].lcy - this.pc[i].lcr;
        this.xcoords[2] = this.pc[i].lcx - this.pc[i].lhalfcr;
        this.ycoords[2] = this.pc[i].lcy - this.pc[i].lcr;
        this.xcoords[3] = this.pc[i].lcx - this.pc[i].lcr;
        this.ycoords[3] = this.pc[i].lcy - this.pc[i].lhalfcr;
        this.xcoords[4] = this.pc[i].lcx - this.pc[i].lcr;
        this.ycoords[4] = this.pc[i].lcy + this.pc[i].lhalfcr;
        this.xcoords[5] = this.pc[i].lcx - this.pc[i].lhalfcr;
        this.ycoords[5] = this.pc[i].lcy + this.pc[i].lcr;
        this.xcoords[6] = this.pc[i].lcx + this.pc[i].lhalfcr;
        this.ycoords[6] = this.pc[i].lcy + this.pc[i].lcr;
        this.xcoords[7] = this.pc[i].lcx + this.pc[i].lcr;
        this.ycoords[7] = this.pc[i].lcy + this.pc[i].lhalfcr;
        if (this.pc[i].lp == null) {
            this.pc[i].lp = new Polygon(this.xcoords, this.ycoords, 8);
        } else {
            for (int j = 0; j < this.xcoords.length; ++j) {
                this.pc[i].lp.xpoints[j] = this.xcoords[j];
                this.pc[i].lp.ypoints[j] = this.ycoords[j];
            }
            this.pc[i].lp.invalidate();
        }
    }

    public void draw(Graphics2D g, int vW, int vH, int i, Stroke stdS, AffineTransform stdT, int dx, int dy) {
        if (this.pc[i].cr > 1) {
            if (this.filled) {
                g.setColor(this.color);
                g.translate(dx, dy);
                g.fillPolygon(this.pc[i].p);
                g.translate(-dx, -dy);
            }
            if (this.paintBorder) {
                g.setColor(this.borderColor);
                if (this.stroke != null) {
                    g.setStroke(this.stroke);
                    g.translate(dx, dy);
                    g.drawPolygon(this.pc[i].p);
                    g.translate(-dx, -dy);
                    g.setStroke(stdS);
                } else {
                    g.translate(dx, dy);
                    g.drawPolygon(this.pc[i].p);
                    g.translate(-dx, -dy);
                }
            }
        } else {
            g.setColor(this.color);
            g.fillRect(dx + this.pc[i].cx, dy + this.pc[i].cy, 1, 1);
        }
    }

    public void drawForLens(Graphics2D g, int vW, int vH, int i, Stroke stdS, AffineTransform stdT, int dx, int dy) {
        if (this.pc[i].lcr > 1) {
            if (this.filled) {
                g.setColor(this.color);
                g.translate(dx, dy);
                g.fillPolygon(this.pc[i].lp);
                g.translate(-dx, -dy);
            }
            if (this.paintBorder) {
                g.setColor(this.borderColor);
                if (this.stroke != null) {
                    g.setStroke(this.stroke);
                    g.translate(dx, dy);
                    g.drawPolygon(this.pc[i].lp);
                    g.translate(-dx, -dy);
                    g.setStroke(stdS);
                } else {
                    g.translate(dx, dy);
                    g.drawPolygon(this.pc[i].lp);
                    g.translate(-dx, -dy);
                }
            }
        } else {
            g.setColor(this.color);
            g.fillRect(dx + this.pc[i].lcx, dy + this.pc[i].lcy, 1, 1);
        }
    }

    public Object clone() {
        VOctagon res = new VOctagon(this.vx, this.vy, 0, this.vs, this.color);
        res.borderColor = this.borderColor;
        res.mouseInsideColor = this.mouseInsideColor;
        res.bColor = this.bColor;
        return res;
    }
}

