'''OpenGL extension EXT.shader_implicit_conversions

This module customises the behaviour of the 
OpenGL.raw.GLES2.EXT.shader_implicit_conversions to provide a more 
Python-friendly API

Overview (from the spec)
	
	This extension provides support for implicitly converting signed integer
	types to unsigned types, as well as more general implicit conversion and
	function overloading infrastructure to support new data types introduced by
	other extensions.

The official definition of this extension is available here:
http://www.opengl.org/registry/specs/EXT/shader_implicit_conversions.txt
'''
from OpenGL import platform, constant, arrays
from OpenGL import extensions, wrapper
import ctypes
from OpenGL.raw.GLES2 import _types, _glgets
from OpenGL.raw.GLES2.EXT.shader_implicit_conversions import *
from OpenGL.raw.GLES2.EXT.shader_implicit_conversions import _EXTENSION_NAME

def glInitShaderImplicitConversionsEXT():
    '''Return boolean indicating whether this extension is available'''
    from OpenGL import extensions
    return extensions.hasGLExtension( _EXTENSION_NAME )


### END AUTOGENERATED SECTION