/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.xslt.trace;

import java.io.PrintWriter;
import org.apache.xalan.xslt.ElemTemplate;
import org.apache.xalan.xslt.ElemTemplateElement;
import org.apache.xalan.xslt.ElemTextLiteral;
import org.apache.xalan.xslt.trace.GenerateEvent;
import org.apache.xalan.xslt.trace.SelectionEvent;
import org.apache.xalan.xslt.trace.TraceListener;
import org.apache.xalan.xslt.trace.TracerEvent;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class PrintTraceListener
implements TraceListener {
    PrintWriter m_pw;
    public boolean m_traceTemplates = false;
    public boolean m_traceElements = false;
    public boolean m_traceGeneration = false;
    public boolean m_traceSelection = false;

    public PrintTraceListener(PrintWriter printWriter) {
        this.m_pw = printWriter;
    }

    public void trace(TracerEvent tracerEvent) {
        switch (tracerEvent.m_styleNode.getXSLToken()) {
            case 78: {
                if (!this.m_traceElements) break;
                this.m_pw.print("Line #" + tracerEvent.m_styleNode.m_lineNumber + ", " + "Column #" + tracerEvent.m_styleNode.m_columnNumber + " -- " + tracerEvent.m_styleNode.m_elemName + ": ");
                ElemTextLiteral elemTextLiteral = (ElemTextLiteral)tracerEvent.m_styleNode;
                String string = new String(elemTextLiteral.m_ch, 0, elemTextLiteral.m_ch.length);
                this.m_pw.println("    " + string.trim());
                return;
            }
            case 19: {
                if (this.m_traceTemplates || this.m_traceElements) {
                    ElemTemplate elemTemplate = (ElemTemplate)tracerEvent.m_styleNode;
                    this.m_pw.print("Line #" + elemTemplate.m_lineNumber + ", " + "Column #" + elemTemplate.m_columnNumber + ": " + elemTemplate.m_elemName + " ");
                    if (elemTemplate.m_matchPattern != null) {
                        this.m_pw.print("match='" + elemTemplate.m_matchPattern.getPatternString() + "' ");
                    }
                    if (elemTemplate.m_name != null) {
                        this.m_pw.print("name='" + elemTemplate.m_name + "' ");
                    }
                    this.m_pw.println();
                }
                return;
            }
            default: {
                if (!this.m_traceElements) break;
                this.m_pw.println("Line #" + tracerEvent.m_styleNode.m_lineNumber + ", " + "Column #" + tracerEvent.m_styleNode.m_columnNumber + ": " + tracerEvent.m_styleNode.m_elemName);
            }
        }
    }

    public void selected(SelectionEvent selectionEvent) throws SAXException {
        if (this.m_traceSelection) {
            NodeList nodeList;
            ElemTemplateElement elemTemplateElement = selectionEvent.m_styleNode;
            if (selectionEvent.m_styleNode.m_lineNumber == 0) {
                nodeList = (ElemTemplateElement)elemTemplateElement.getParentNode();
                if (nodeList == elemTemplateElement.m_stylesheet.m_stylesheetRoot.m_defaultRootRule) {
                    this.m_pw.print("(default root rule) ");
                } else if (nodeList == elemTemplateElement.m_stylesheet.m_stylesheetRoot.m_defaultTextRule) {
                    this.m_pw.print("(default text rule) ");
                } else if (nodeList == elemTemplateElement.m_stylesheet.m_stylesheetRoot.m_defaultRule) {
                    this.m_pw.print("(default rule) ");
                }
                this.m_pw.print(String.valueOf(elemTemplateElement.m_elemName) + ", " + selectionEvent.m_attributeName + "='" + selectionEvent.m_xpath.getPatternString() + "': ");
            } else {
                this.m_pw.print("Line #" + selectionEvent.m_styleNode.m_lineNumber + ", " + "Column #" + selectionEvent.m_styleNode.m_columnNumber + ": " + elemTemplateElement.m_elemName + ", " + selectionEvent.m_attributeName + "='" + selectionEvent.m_xpath.getPatternString() + "': ");
            }
            if (selectionEvent.m_selection.getType() == 4) {
                this.m_pw.println();
                nodeList = selectionEvent.m_selection.nodeset();
                int n = nodeList.getLength();
                if (n == 0) {
                    this.m_pw.println("     [empty node list]");
                    return;
                }
                int n2 = 0;
                while (n2 < n) {
                    this.m_pw.println("     " + nodeList.item(n2));
                    ++n2;
                }
                return;
            }
            this.m_pw.println(selectionEvent.m_selection.str());
        }
    }

    public void generated(GenerateEvent generateEvent) {
        if (this.m_traceGeneration) {
            switch (generateEvent.m_eventtype) {
                case 1: {
                    this.m_pw.println("STARTDOCUMENT");
                    return;
                }
                case 2: {
                    this.m_pw.println("ENDDOCUMENT");
                    return;
                }
                case 3: {
                    this.m_pw.println("STARTELEMENT: " + generateEvent.m_name);
                    return;
                }
                case 4: {
                    this.m_pw.println("ENDELEMENT: " + generateEvent.m_name);
                    return;
                }
                case 5: {
                    String string = new String(generateEvent.m_characters, generateEvent.m_start, generateEvent.m_length);
                    this.m_pw.println("CHARACTERS: " + string);
                    return;
                }
                case 10: {
                    String string = new String(generateEvent.m_characters, generateEvent.m_start, generateEvent.m_length);
                    this.m_pw.println("CDATA: " + string);
                    return;
                }
                case 8: {
                    this.m_pw.println("COMMENT: " + generateEvent.m_data);
                    return;
                }
                case 7: {
                    this.m_pw.println("PI: " + generateEvent.m_name + ", " + generateEvent.m_data);
                    return;
                }
                case 9: {
                    this.m_pw.println("ENTITYREF: " + generateEvent.m_name);
                    return;
                }
                case 6: {
                    this.m_pw.println("IGNORABLEWHITESPACE");
                    return;
                }
            }
        }
    }
}

