// This file is generated by WOK (CPPExt).
// Please do not edit this file; modify original file instead.
// The copyright and license terms as defined for the original file apply to 
// this header file considered to be the "object code" form of the original source.

#ifndef _HatchGen_Domain_HeaderFile
#define _HatchGen_Domain_HeaderFile

#include <Standard.hxx>
#include <Standard_DefineAlloc.hxx>
#include <Standard_Macro.hxx>

#include <Standard_Boolean.hxx>
#include <HatchGen_PointOnHatching.hxx>
#include <Standard_Integer.hxx>
class Standard_DomainError;
class HatchGen_PointOnHatching;



class HatchGen_Domain 
{
public:

  DEFINE_STANDARD_ALLOC

  
  //! Creates an infinite domain.
  Standard_EXPORT HatchGen_Domain();
  
  //! Creates a domain for the curve associated to a hatching.
  Standard_EXPORT HatchGen_Domain(const HatchGen_PointOnHatching& P1, const HatchGen_PointOnHatching& P2);
  
  //! Creates a semi-infinite domain for the curve associated
  //! to a hatching. The `First' flag means that the given
  //! point is the first one.
  Standard_EXPORT HatchGen_Domain(const HatchGen_PointOnHatching& P, const Standard_Boolean First);
  
  //! Sets the first and the second points of the domain.
      void SetPoints (const HatchGen_PointOnHatching& P1, const HatchGen_PointOnHatching& P2) ;
  
  //! Sets the first and the second points of the domain
  //! as the infinite.
      void SetPoints() ;
  
  //! Sets the first point of the domain.
      void SetFirstPoint (const HatchGen_PointOnHatching& P) ;
  
  //! Sets the first point of the domain at the
  //! infinite.
      void SetFirstPoint() ;
  
  //! Sets the second point of the domain.
      void SetSecondPoint (const HatchGen_PointOnHatching& P) ;
  
  //! Sets the second point of the domain at the
  //! infinite.
      void SetSecondPoint() ;
  
  //! Returns True if the domain has a first point.
      Standard_Boolean HasFirstPoint()  const;
  
  //! Returns the first point of the domain.
  //! The exception DomainError is raised if
  //! HasFirstPoint returns False.
     const  HatchGen_PointOnHatching& FirstPoint()  const;
  
  //! Returns True if the domain has a second point.
      Standard_Boolean HasSecondPoint()  const;
  
  //! Returns the second point of the domain.
  //! The exception DomainError is raised if
  //! HasSecondPoint returns False.
     const  HatchGen_PointOnHatching& SecondPoint()  const;
  
  //! Dump of the domain.
  Standard_EXPORT   void Dump (const Standard_Integer Index = 0)  const;




protected:





private:



  Standard_Boolean myHasFirstPoint;
  HatchGen_PointOnHatching myFirstPoint;
  Standard_Boolean myHasSecondPoint;
  HatchGen_PointOnHatching mySecondPoint;


};


#include <HatchGen_Domain.lxx>





#endif // _HatchGen_Domain_HeaderFile
