/**
 * A Highcharts plugin for exporting data from a rendered chart as CSV, XLS or HTML table
 * https://github.com/highcharts/export-csv
 * Commit: d5d2b83ca6588f06166b74e779288ea683e69cc5
 *
 * Author:   Torstein Honsi
 * Licence:  MIT
 * Version:  1.4.7
 */
!function(a){"object"==typeof module&&module.exports?module.exports=a:a(Highcharts)}(function(a){"use strict";function f(b,c,d,f,g){var h,i,j,k=(b.options.exporting||{}).csv||{},l=k.url||"http://www.highcharts.com/studies/csv-export/download.php";j=b.options.exporting.filename?b.options.exporting.filename:b.title?b.title.textStr.replace(/ /g,"-").toLowerCase():"chart",window.Blob&&window.navigator.msSaveOrOpenBlob?(i=new Blob([f]),window.navigator.msSaveOrOpenBlob(i,j+"."+d)):e?(h=document.createElement("a"),h.href=c,h.target="_blank",h.download=j+"."+d,b.container.append(h),h.click(),h.remove()):a.post(l,{data:f,type:g,extension:d})}var b=a.each,c=a.pick,d=a.seriesTypes,e=void 0!==document.createElement("a").download;a.setOptions({lang:{downloadCSV:"Download CSV",downloadXLS:"Download XLS",viewData:"View data table"}}),a.Chart.prototype.getDataRows=function(){var e,i,k,l,m,d=(this.options.exporting||{}).csv||{},f=this.xAxis,g={},h=[],j=[],n=d.dateFormat||"%Y-%m-%d %H:%M:%S",o=d.columnHeaderFormatter||function(b,c,d){return b instanceof a.Axis?b.options.title&&b.options.title.text||(b.isDatetimeAxis?"DateTime":"Category"):b?b.name+(d>1?" ("+c+")":""):"Category"},p=[];k=0,b(this.series,function(d){var q,e=d.options.keys,h=e||d.pointArrayMap||["y"],i=h.length,l=d.requireSorting,m={},n=a.inArray(d.xAxis,f);if(b(h,function(a){m[a]=d[a+"Axis"]&&d[a+"Axis"].categories||[]}),!1!==d.options.includeInCSVExport&&!1!==d.visible){for(a.find(p,function(a){return a[0]===n})||p.push([n,k]),q=0;q<i;)j.push(o(d,h[q],h.length)),q+=1;b(d.points,function(a,b){var f,j,e=l?a.x:b;for(q=0,g[e]||(g[e]=[],g[e].xValues=[]),g[e].x=a.x,g[e].xValues[n]=a.x,d.xAxis&&"name"!==d.exportKey||(g[e].name=a.name);q<i;)f=h[q],j=a[f],g[e][k+q]=c(m[f][j],j),q+=1}),k+=q}});for(l in g)g.hasOwnProperty(l)&&h.push(g[l]);var r,s;for(i=[j],k=p.length;k--;)r=p[k][0],s=p[k][1],e=f[r],h.sort(function(a,b){return a.xValues[r]-b.xValues[r]}),m=o(e),i[0].splice(s,0,m),b(h,function(b){var d=b.name;d||(e.isDatetimeAxis?(b.x instanceof Date&&(b.x=b.x.getTime()),d=a.dateFormat(n,b.x)):d=e.categories?c(e.names[b.x],e.categories[b.x],b.x):b.x),b.splice(s,0,d)});return i=i.concat(h)},a.Chart.prototype.getCSV=function(a){var c="",d=this.getDataRows(),e=(this.options.exporting||{}).csv||{},f=e.itemDelimiter||",",g=e.lineDelimiter||"\n";return b(d,function(b,e){for(var h="",i=b.length,j=a?1.1.toLocaleString()[1]:".";i--;)h=b[i],"string"==typeof h&&(h='"'+h+'"'),"number"==typeof h&&","===j&&(h=h.toString().replace(".",",")),b[i]=h;c+=b.join(f),e<d.length-1&&(c+=g)}),c},a.Chart.prototype.getTable=function(a){var c="<table><thead>",d=this.getDataRows();return b(d,function(b,d){var f,g,e=d?"td":"th",h=a?1.1.toLocaleString()[1]:".";for(c+="<tr>",g=0;g<b.length;g+=1)f=b[g],"number"==typeof f?(f=f.toString(),","===h&&(f=f.replace(".",h)),c+="<"+e+' class="number">'+f+"</"+e+">"):c+="<"+e+">"+(void 0===f?"":f)+"</"+e+">";c+="</tr>",d||(c+="</thead><tbody>")}),c+="</tbody></table>"},a.Chart.prototype.downloadCSV=function(){var a=this.getCSV(!0);f(this,"data:text/csv,\ufeff"+encodeURIComponent(a),"csv",a,"text/csv")},a.Chart.prototype.downloadXLS=function(){var b='<html xmlns:o="urn:schemas-microsoft-com:office:office" xmlns:x="urn:schemas-microsoft-com:office:excel" xmlns="http://www.w3.org/TR/REC-html40"><head>\x3c!--[if gte mso 9]><xml><x:ExcelWorkbook><x:ExcelWorksheets><x:ExcelWorksheet><x:Name>Ark1</x:Name><x:WorksheetOptions><x:DisplayGridlines/></x:WorksheetOptions></x:ExcelWorksheet></x:ExcelWorksheets></x:ExcelWorkbook></xml><![endif]--\x3e<style>td{border:none;font-family: Calibri, sans-serif;} .number{mso-number-format:"0.00";}</style><meta name=ProgId content=Excel.Sheet><meta charset=UTF-8></head><body>'+this.getTable(!0)+"</body></html>";f(this,"data:application/vnd.ms-excel;base64,"+function(a){return window.btoa(unescape(encodeURIComponent(a)))}(b),"xls",b,"application/vnd.ms-excel")},a.Chart.prototype.viewData=function(){this.dataTableDiv||(this.dataTableDiv=document.createElement("div"),this.dataTableDiv.className="highcharts-data-table",this.renderTo.parentNode.insertBefore(this.dataTableDiv,this.renderTo.nextSibling)),this.dataTableDiv.innerHTML=this.getTable()},a.getOptions().exporting&&a.getOptions().exporting.buttons.contextButton.menuItems.push({textKey:"downloadCSV",onclick:function(){this.downloadCSV()}},{textKey:"downloadXLS",onclick:function(){this.downloadXLS()}},{textKey:"viewData",onclick:function(){this.viewData()}}),d.map&&(d.map.prototype.exportKey="name"),d.mapbubble&&(d.mapbubble.prototype.exportKey="name"),d.treemap&&(d.treemap.prototype.exportKey="name")});