/*
 * Decompiled with CFR 0.152.
 */
package java.nio.charset;

import java.lang.ref.WeakReference;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.MalformedInputException;
import java.nio.charset.UnmappableCharacterException;
import java.util.HashMap;

public class CoderResult {
    private static final int TYPE_MALFORMED = 0;
    private static final int TYPE_OVERFLOW = 1;
    private static final int TYPE_UNDERFLOW = 2;
    private static final int TYPE_UNMAPPABLE = 3;
    public static final CoderResult OVERFLOW = new CoderResult(1, 0);
    public static final CoderResult UNDERFLOW = new CoderResult(2, 0);
    private static final String[] names = new String[]{"MALFORMED", "OVERFLOW", "UNDERFLOW", "UNMAPPABLE"};
    private static final Cache malformedCache = new Cache(){

        protected final CoderResult make(int n) {
            return new CoderResult(0, n);
        }
    };
    private static final Cache unmappableCache = new Cache(){

        protected final CoderResult make(int n) {
            return new CoderResult(3, n);
        }
    };
    private final int type;
    private final int length;

    public boolean isError() {
        boolean bl = false;
        if (this.length > 0) {
            bl = true;
        }
        return bl;
    }

    public boolean isMalformed() {
        boolean bl = false;
        if (this.type == 0) {
            bl = true;
        }
        return bl;
    }

    public boolean isOverflow() {
        boolean bl = false;
        if (this.type == 1) {
            bl = true;
        }
        return bl;
    }

    public boolean isUnderflow() {
        boolean bl = false;
        if (this.type == 2) {
            bl = true;
        }
        return bl;
    }

    public boolean isUnmappable() {
        boolean bl = false;
        if (this.type == 3) {
            bl = true;
        }
        return bl;
    }

    public int length() {
        if (this.length <= 0) {
            throw new UnsupportedOperationException();
        }
        return this.length;
    }

    public static CoderResult malformedForLength(int n) {
        return malformedCache.get(n);
    }

    public void throwException() throws CharacterCodingException {
        switch (this.type) {
            case 0: {
                throw new MalformedInputException(this.length);
            }
            case 1: {
                throw new BufferOverflowException();
            }
            case 2: {
                throw new BufferUnderflowException();
            }
            case 3: {
                throw new UnmappableCharacterException(this.length);
            }
        }
    }

    public String toString() {
        String string = names[this.type];
        return this.length > 0 ? string + '[' + this.length + ']' : string;
    }

    public static CoderResult unmappableForLength(int n) {
        return unmappableCache.get(n);
    }

    static /* synthetic */ int access$0() {
        return 0;
    }

    static /* synthetic */ int access$1() {
        return 3;
    }

    CoderResult(int n, int n2) {
        this.type = n;
        this.length = n2;
    }

    private static abstract class Cache {
        private final HashMap cache = new HashMap();

        synchronized CoderResult get(int n) {
            if (n <= 0) {
                throw new IllegalArgumentException("Non-positive length");
            }
            Integer n2 = new Integer(n);
            CoderResult coderResult = null;
            Object object = this.cache.get(n2);
            if (object != null) {
                coderResult = (CoderResult)((WeakReference)object).get();
            }
            if (coderResult == null) {
                coderResult = this.make(n);
                this.cache.put(n2, new WeakReference(coderResult));
            }
            return coderResult;
        }

        protected abstract CoderResult make(int var1);

        Cache() {
        }
    }
}

