<?php

error_reporting(-1);

if (function_exists('ini_set')) {
    @ini_set('display_errors', 1);
    @ini_set('display_startup_errors', 1);
    @ini_set('opcache.enable_cli', '0');

    if (isset($_GET['opcache_reset']) && $_GET['opcache_reset'] === md5(Phar::running(false))) {
        $GLOBALS['opcacheEnabled'] = @ini_get('opcache.enable');
    } else {
        $GLOBALS['opcacheEnabled'] = @ini_set('opcache.enable', '0');
    }
}

if (PHP_VERSION_ID < 50509) {
    die('You are using PHP '.PHP_VERSION." but you need least PHP 5.5.9 to run the Contao Manager.\n");
}

if (!extension_loaded('Phar')) {
    echo 'PHP\'s phar extension is missing. Contao Manager requires it to run. Enable the extension or recompile php without --disable-phar then try again.' . PHP_EOL;
    exit(1);
}

if (('cli' === PHP_SAPI || !isset($_SERVER['REQUEST_URI'])) && isset($_SERVER['argv'][1]) && 'test' === $_SERVER['argv'][1]) {
    die(json_encode(['version' => PHP_VERSION, 'version_id' => PHP_VERSION_ID, 'sapi' => PHP_SAPI]));
}

if (PHP_VERSION_ID < 80100) {
    Phar::mapPhar('contao-manager.phar');
    @include 'phar://contao-manager.phar/downgrade.php';
    die('<script>setTimeout(function() { window.location.reload(true) }, 1000)</script>');
}

if (function_exists('date_default_timezone_set') && function_exists('date_default_timezone_get')) {
    date_default_timezone_set(@date_default_timezone_get());
}

if ('cli' === PHP_SAPI || !isset($_SERVER['REQUEST_URI'])) {
    Phar::mapPhar('contao-manager.phar');
    require 'phar://contao-manager.phar/api/console';
} else {
    function rewrites()
    {
        // The function argument is unreliable across servers, Nginx for example is always empty
        list(,$url) = explode(basename(__FILE__), $_SERVER['REQUEST_URI'], 2);

        if (strpos($url, '..')) {
            return false;
        }

        if ('' === $url) {
            header('Location: /'.basename(__FILE__).'/');
            exit;
        }

        if (0 === strpos($url, '/api/')) {
            return '/dist/api.php'.$url;
        }

        if (!empty($url) && is_file('phar://'.__FILE__.'/dist'.$url)) {
            return '/dist'.$url;
        }

        return '/dist/index.html';
    }

    Phar::webPhar(
        null,
        'index.html',
        null,
        array(
            'log' => 'text/plain',
            'txt' => 'text/plain',
            'php' => Phar::PHP, // parse as PHP
            'css' => 'text/css',
            'gif' => 'image/gif',
            'html' => 'text/html',
            'ico' => 'image/x-ico',
            'jpg' => 'image/jpeg',
            'jpeg' => 'image/jpeg',
            'js' => 'application/x-javascript',
            'png' => 'image/png',
            'svg' => 'image/svg+xml',
            'json' => 'application/json'
        ),
        'rewrites'
    );
}

__HALT_COMPILER(); ?>
                  .box/bin/check-requirements.php  g  ^ʨ         .box/.requirements.php:  g:  *ä         .box/vendor/autoload.php   g   s      ,   .box/vendor/composer/autoload_namespaces.php   g   t!פ         .box/vendor/composer/LICENSE.  g.         $   .box/vendor/composer/ClassLoader.php>  g>  5Ky      &   .box/vendor/composer/autoload_psr4.php6  g6   0Ӥ      *   .box/vendor/composer/autoload_classmap.php,
  g,
  ӽǤ      (   .box/vendor/composer/autoload_static.phpK  gK  ?      &   .box/vendor/composer/autoload_real.php   g   yi\      .   .box/vendor/composer/semver/src/Comparator.phpu  gu  	74      *   .box/vendor/composer/semver/src/Semver.php  g  ׯ      1   .box/vendor/composer/semver/src/VersionParser.php9  g9  Wz      B   .box/vendor/composer/semver/src/Constraint/ConstraintInterface.php  g  wQ      >   .box/vendor/composer/semver/src/Constraint/MultiConstraint.php~  g~  5[e      9   .box/vendor/composer/semver/src/Constraint/Constraint.php'&  g'&  `         .box/src/Terminal.php
  g
  %V         .box/src/IO.php   g   [l%      !   .box/src/IsExtensionFulfilled.phpv  gv  '0Ҥ         .box/src/Checker.php  g  )W>      "   .box/src/IsPhpVersionFulfilled.php  g  !83      "   .box/src/RequirementCollection.php  g  Wb?         .box/src/Printer.php  g  )8AV         .box/src/IsFulfilled.phpv   gv   %*H         .box/src/Requirement.phpm  gm  B         LICENSE  g  p         dist/index.htmlH'  gH'   /-         dist/api.php--  g  L|R         dist/css/682.44f2aba0.cssO  gO  o         dist/css/612.3a60e65a.css  g  i_Ӥ         dist/css/976.9525e566.cssv?  gv?  ;K         dist/css/599.2589534e.css  g           dist/css/app.36128924.css  g           dist/css/82.e18cb2b2.css  g  26&      #   dist/css/chunk-vendors.f450b373.csst  gt  n         dist/css/545.4e766ee7.cssn  gn  ?d!         dist/css/139.11002f25.css  g  +         dist/css/306.25211792.cssl  gl  A         dist/js/120.ad9ecc53.jsp  gp           dist/js/540.60195fdd.js  g           dist/js/715.0fdc7fe3.jsu  gu  F7         dist/js/523.14592c65.js  g  3         dist/js/554.686ea2d1.js  g  Z         dist/js/477.fd78545a.js  g           dist/js/599.54ff19b0.js  g  +zN         dist/js/976.3d3e7a20.js  g  ,         dist/js/669.deb99932.jsz  gz  YH         dist/js/60.15d99754.jsI"  gI"  H[         dist/js/638.4a915bba.js  g  >         dist/js/518.16da88f4.jsk  gk  BZf         dist/js/661.81d51c50.jsM  gM  6         dist/js/44.189756d1.js  g  tmGe         dist/js/606.2d084e80.js  g  J         dist/js/682.85ea8a64.jsQ  gQ  LL         dist/js/706.36ffbd9e.js  g  8         dist/js/953.cfd6dc8d.js.  g.           dist/js/306.725ae704.jsu
  gu
  f         dist/js/958.7fdd57a1.jsS  gS  CIsƤ         dist/js/542.a77d6afc.js  g           dist/js/851.177b5f8d.js0  g0  ,bFؤ         dist/js/139.148f5cb4.jsX-  gX-  㣻         dist/js/180.25fde044.js  g  o         dist/js/874.cb764366.js  g  h[         dist/js/551.e4b6b73b.js!  g!  |         dist/js/82.85cb789b.js
  g
  l         dist/js/52.53a6eeda.js  g  yW         dist/js/520.015d305f.jsU  gU  ){3         dist/js/553.8c9f2cba.js&  g&  }         dist/js/28.ceef267d.jsw  gw  Ig0         dist/js/643.c376895b.jsΠ  gΠ  ^5'         dist/js/app.298b3095.jsʾ gʾ #c         dist/js/219.c00b841d.js
  g
  C
F         dist/js/721.92ab0b05.js  g  ƿ         dist/js/581.34ad7ec7.js  g  4         dist/js/716.a21c458e.jsA  gA  Cd         dist/js/194.1e21e427.js  g  ИU         dist/js/612.8900155c.js  g  3      !   dist/js/chunk-vendors.f2ea533d.js> g> ߤ         dist/js/560.d7458d27.js  g  Ix         dist/js/557.9a8ca5d7.js  g  =]ɤ         dist/js/140.9f138779.js=  g=  3N         dist/js/164.8ecb4c36.jsK  gK  i.q         dist/js/367.7c7b4172.js  g  IT         dist/js/710.aa0213da.js| g| gǘk         dist/js/486.dbfe136b.js  g  !         dist/js/769.46cebc27.js  g  	9      !   dist/img/button-show.2336e1d9.svgS  gS  U         dist/img/warning.9a7cd776.svg   g   fh         dist/img/logo.d9707286.svg  g  ;w          dist/img/button-add.759df12e.svg   g   O
         dist/img/favers.056e2836.svgH  gH  y,ͤ      #   dist/img/server-config.1a2d0888.svgg  gg  RN      %   dist/img/button-database.5282fc7e.svg   g   P      "   dist/img/symfony-logo.5c162c73.svg
  g
  Os@      !   dist/img/button-link.dd42e161.svg   g   ֖>      (   dist/img/button-maintenance.93830369.svgE  gE  O      $   dist/img/create-project.b22522ee.svg   g   ʅ      )   dist/img/button-incompatible.3eb2b686.svg  g  /$      #   dist/img/document-root.0e6dd2e4.svg   g   D      '   dist/img/search-by-algolia.72f0ac9a.svg  g           dist/img/boot.92149bf5.svg   g   So      #   dist/img/button-search.44ce1d4b.svgL  gL  w         dist/img/oauth.1243e742.svg.  g.  @
         dist/img/private.a1c65662.svg  g  _50w      %   dist/img/button-download.e1ba6f25.svg1  g1  O#         dist/img/person.00d78897.svg   g   w*      )   dist/img/widget-checkbox--on.8b830157.svg   g   #;      !   dist/img/button-lock.98988f08.svgc  gc  5=6z      "   dist/img/button-check.7a3b5ada.svg   g   ]R         dist/img/user.129e863d.svg   g   cǤ         dist/img/offline.0c23d1ce.svg  g  У-      (   dist/img/symfony-logo--dark.ea265042.svg  g  溤      #   dist/img/private--dark.41b90022.svg  g  b      &   dist/img/button-cloud-off.dd8ba18e.svg  g  ܡ<      "   dist/img/button-power.298a8072.svg6  g6  Kb      %   dist/img/downloads--dark.034bf7a3.svg-  g-  	Ǥ      "   dist/img/button-trash.855f57fa.svgt  gt  2}          dist/img/link-blank.eb57b3fa.svg   g   f^      &   dist/img/button-clipboard.9ef63d39.svgJ  gJ  v,N      '   dist/img/widget-radio--off.4e93f443.svg  g           dist/img/task.e9e5333f.svg{  g{  Jl      #   dist/img/button-update.ad79c617.svg\  g\  Į         dist/img/hint.ba2ac97e.svg!  g!        !   dist/img/button-hide.d23f6533.svg  g  m3(         dist/img/database.7f0a8c49.svg  g  <	         dist/img/updated.3b47bebb.svgH  gH  ʦ      $   dist/img/language--dark.a24e849e.svgx  gx  G7?      !   dist/img/button-save.3b5224de.svg  g        $   dist/img/button-details.161475b3.svg  g  &         dist/img/lock.3c42a55f.svgf  gf  gG         dist/img/downloads.c1db2a9e.svg0  g0  ¤      "   dist/img/color_scheme.d527d153.svg   g   t         dist/img/recovery.70ee118a.svg   g   OTM`      #   dist/img/button-upload.ca8e9cfc.svg3  g3  0U      !   dist/img/button-edit.40a4be06.svg  g  !.      &   dist/img/link-blank--dark.07eeaee6.svg   g   B|         dist/img/funding.cf78a0a0.svgJ  gJ  `1_      #   dist/img/button-unlock.51b76e07.svgi  gi  
         dist/img/php-logo.7376e212.svg	  g	  k9q      #   dist/img/updated--dark.c21fdd5b.svgE  gE  Ey      "   dist/img/button-cloud.bc42f267.svg  g  I[      "   dist/img/favers--dark.4765f7d4.svgE  gE        !   dist/img/button-more.e3eb2622.svg  g  v         dist/img/language.582b2920.svg{  g{  tW      &   dist/img/widget-radio--on.181461b6.svg:  g:  j
M      $   dist/img/button-console.05dcdfc4.svg   g   >y      (   dist/img/color_scheme--dark.ef0f0aed.svg:  g:  <      !   dist/img/button-gear.a2dc1f09.svg  g  0         dist/img/sad.c7de6e95.svg5  g5  h          dist/img/button-run.b6310c5a.svg  g           dist/img/close.8b27dbcb.svg   g   e      "   dist/img/link-funding.b25cd92d.svg  g  PԤ      *   dist/img/widget-checkbox--off.73856538.svg   g   ~      (   dist/icons/task-active/favicon-16x16.png3  g3  K       "   dist/icons/task-active/favicon.ico:  g:  8      (   dist/icons/task-active/favicon-32x32.pngF  gF  )fx      '   dist/icons/task-error/favicon-16x16.png;  g;        !   dist/icons/task-error/favicon.ico:  g:  u      '   dist/icons/task-error/favicon-32x32.pngB  gB        )   dist/icons/task-success/favicon-16x16.pngU  gU  {ؤ      #   dist/icons/task-success/favicon.ico:  g:  TIm      )   dist/icons/task-success/favicon-32x32.pngq  gq  ?.         dist/api.php  g  C¾         dist/assets/favicon-16x16.png  g           dist/assets/mstile-310x310.png%  g%  xH      &   dist/assets/android-chrome-384x384.png%  g%  1|&      3   dist/assets/apple-touch-startup-image-1125x2436.png  g  5      2   dist/assets/apple-touch-startup-image-1792x828.png  g  8Q      2   dist/assets/apple-touch-startup-image-1334x750.png}y  g}y  Դ         dist/assets/mstile-144x144.png  g        3   dist/assets/apple-touch-startup-image-1290x2796.pngu  gu  ^v         dist/assets/favicon.ico  g  }*~      (   dist/assets/apple-touch-icon-120x120.png
  g
        3   dist/assets/apple-touch-startup-image-2732x2048.png g .uE      &   dist/assets/android-chrome-192x192.png3  g3  '\          dist/assets/apple-touch-icon.png  g  :5      3   dist/assets/apple-touch-startup-image-1242x2688.png&  g&  :Pg      &   dist/assets/android-chrome-256x256.pngh  gh  j't      3   dist/assets/apple-touch-startup-image-2436x1125.png  g  5x         dist/assets/mstile-70x70.png  g  eݺ=      2   dist/assets/apple-touch-startup-image-640x1136.pngP  gP  n      3   dist/assets/apple-touch-startup-image-1170x2532.png@  g@  ˨      *   dist/assets/apple-touch-icon-1024x1024.pngr|  gr|  T      (   dist/assets/apple-touch-icon-152x152.png  g  o      3   dist/assets/apple-touch-startup-image-1620x2160.pngb  gb  RE      3   dist/assets/apple-touch-startup-image-1668x2388.png  g  I      2   dist/assets/apple-touch-startup-image-828x1792.pngv  gv  >H      3   dist/assets/apple-touch-startup-image-2048x1536.pngn gn xEy      (   dist/assets/apple-touch-icon-180x180.png  g  :5      (   dist/assets/yandex-browser-manifest.json   g   p#Ȥ      3   dist/assets/apple-touch-startup-image-1640x2160.pngv  gv  <o      3   dist/assets/apple-touch-startup-image-2224x1668.png+ g+       3   dist/assets/apple-touch-startup-image-1179x2556.pngZ  gZ           dist/assets/favicon-48x48.png  g  .i         dist/assets/mstile-310x150.png  g  ƒܤ      3   dist/assets/apple-touch-startup-image-1242x2208.pngٸ  gٸ  &Nf      (   dist/assets/apple-touch-icon-114x114.pngR	  gR	  M      &   dist/assets/apple-touch-icon-76x76.png)  g)  b      &   dist/assets/android-chrome-512x512.pngL6  gL6  x9      3   dist/assets/apple-touch-startup-image-2556x1179.png  g  jW      2   dist/assets/apple-touch-startup-image-1136x640.pngd  gd  %¤      3   dist/assets/apple-touch-startup-image-2532x1170.png  g  Ҫ      3   dist/assets/apple-touch-startup-image-2208x1242.png  g  PQ      3   dist/assets/apple-touch-startup-image-1488x2266.pngb  gb  Wzۤ      &   dist/assets/apple-touch-icon-57x57.png  g  1@      2   dist/assets/apple-touch-startup-image-750x1334.pnga  ga  ΃      3   dist/assets/apple-touch-startup-image-2266x1488.pngP gP aФ      ,   dist/assets/apple-touch-icon-precomposed.png  g  :5      3   dist/assets/apple-touch-startup-image-2160x1620.png" g" A'      3   dist/assets/apple-touch-startup-image-1284x2778.pngh  gh  eX:      3   dist/assets/apple-touch-startup-image-1668x2224.pngl  gl  N      3   dist/assets/apple-touch-startup-image-2688x1242.png  g  v      &   dist/assets/apple-touch-icon-72x72.png  g  ^F W      3   dist/assets/apple-touch-startup-image-2778x1284.png  g   Z      3   dist/assets/apple-touch-startup-image-1536x2048.pngW  gW  q)ݤ      3   dist/assets/apple-touch-startup-image-2388x1668.png1 g1 [3j         dist/assets/mstile-150x150.png  g  	          dist/assets/manifest.webmanifest  g  `l      3   dist/assets/apple-touch-startup-image-2796x1290.png  g  3ق      $   dist/assets/android-chrome-36x36.png+  g+        $   dist/assets/android-chrome-96x96.png  g  l@w      (   dist/assets/apple-touch-icon-167x167.png
  g
  dP      $   dist/assets/android-chrome-72x72.png  g  hQ\      &   dist/assets/apple-touch-icon-60x60.png  g        3   dist/assets/apple-touch-startup-image-2160x1640.pngV& gV& 7E      3   dist/assets/apple-touch-startup-image-2048x2732.pngDE gDE bpF      (   dist/assets/apple-touch-icon-144x144.png	  g	  Np      $   dist/assets/yandex-browser-50x50.pngX  gX  X         dist/assets/browserconfig.xmlr  gr  v,      $   dist/assets/android-chrome-48x48.png  g  .i         dist/assets/favicon-32x32.png  g  ɹ      &   dist/assets/android-chrome-144x144.png  g        %   api/HttpKernel/ApiProblemResponse.php	  g	        
   api/console--A  gA  C~Ƥ         api/Config/UploadsConfig.php9  g9  Bɤ         api/Config/UserConfig.php%  g%  bf         api/Config/ManagerConfig.php9  g9  v         api/Config/AbstractConfig.phpk  gk  L@         api/Config/ComposerConfig.php  g  5[
         api/Config/PartialConfig.php  g  +tŅ         api/Config/AuthConfig.php  g  $Ĥ      *   api/Security/PasswordlessAuthenticator.php
  g
  E&      &   api/Security/WebauthnAuthenticator.phpr)  gr)  If      #   api/Security/TokenAuthenticator.php  g  <U7         api/Security/UserProvider.php  g  &N}         api/Security/User.php/
  g/
  [      !   api/Security/JwtAuthenticator.php	  g	  %Ȥ      -   api/Security/AbstractBrowserAuthenticator.php  g  ,         api/Security/TotpBadge.php;  g;  lz      #   api/Security/LoginAuthenticator.php  g  b         api/Security/JwtManager.php  g        .   api/TaskOperation/Composer/RemoveOperation.php  g  '}٤      2   api/TaskOperation/Composer/ClearCacheOperation.php  g  [Ǥ      4   api/TaskOperation/Composer/DumpAutoloadOperation.php  g        /   api/TaskOperation/Composer/InstallOperation.php  g  Y      .   api/TaskOperation/Composer/UpdateOperation.php  g        /   api/TaskOperation/Composer/RequireOperation.php9  g9  z]3      5   api/TaskOperation/Composer/CreateProjectOperation.php  g  2F=      -   api/TaskOperation/Composer/CloudOperation.php|2  g|2  @      8   api/TaskOperation/Filesystem/InstallUploadsOperation.php  g  *դ      6   api/TaskOperation/Filesystem/RemoveVendorOperation.php  g  Nx      7   api/TaskOperation/Filesystem/RemoveUploadsOperation.php  g        5   api/TaskOperation/Filesystem/RemoveCacheOperation.php  g  (٤      1   api/TaskOperation/Manager/SelfUpdateOperation.php  g  3:      -   api/TaskOperation/AbstractInlineOperation.php  g  Sy      1   api/TaskOperation/SponsoredOperationInterface.php"  g"  :      #   api/TaskOperation/ConsoleOutput.php?  g?  Tv      .   api/TaskOperation/AbstractProcessOperation.php  g  \Dc=      5   api/TaskOperation/Contao/MaintenanceModeOperation.php$  g$  R<
      2   api/TaskOperation/Contao/BackupCreateOperation.php<  g<  w      1   api/TaskOperation/Contao/CacheWarmupOperation.phpX  gX  hzۤ      2   api/TaskOperation/Contao/CreateContaoOperation.php  g  
l      3   api/TaskOperation/Contao/BackupRestoreOperation.php{  g{  n<!      0   api/TaskOperation/Contao/CacheClearOperation.phpo  go  n      ,   api/TaskOperation/TaskOperationInterface.php  g  hG         api/Composer/CloudResolver.phpM  gM  ~2         api/Composer/CloudChanges.phpe  ge  #l֤         api/Composer/CloudJob.php	  g	  yP         api/Composer/CloudException.php  g  ߬         api/Composer/Environment.php"  g"        2   api/Resources/cache/url_generating_routes.php.meta!  g!  =      @   api/Resources/cache/Contao_ManagerApi_ApiKernelProdContainer.php  g  C*      %   api/Resources/cache/serialization.phpx   gx   [J      E   api/Resources/cache/Contao_ManagerApi_ApiKernelProdContainer.php.lock    g              E   api/Resources/cache/Contao_ManagerApi_ApiKernelProdContainer.php.metar gr \֤      -   api/Resources/cache/url_generating_routes.phpv  gv  w      +   api/Resources/cache/url_matching_routes.php5  g5  v݈      0   api/Resources/cache/url_matching_routes.php.meta!  g!  =      H   api/Resources/cache/Contao_ManagerApi_ApiKernelProdContainer.preload.phptu  gtu  t2      @   api/Resources/cache/Symfony/Config/Framework/HttpCacheConfig.php#  g#  
1      F   api/Resources/cache/Symfony/Config/Framework/Webhook/RoutingConfig.phpv  gv  j3      <   api/Resources/cache/Symfony/Config/Framework/CacheConfig.php$  g$  "      @   api/Resources/cache/Symfony/Config/Framework/FragmentsConfig.php
  g
  	[b      J   api/Resources/cache/Symfony/Config/Framework/Form/CsrfProtectionConfig.php  g  7eG      P   api/Resources/cache/Symfony/Config/Framework/HttpClient/DefaultOptionsConfig.phpxE  gxE  ^Me      i   api/Resources/cache/Symfony/Config/Framework/HttpClient/ScopedClientConfig/RetryFailed/HttpCodeConfig.php  g        d   api/Resources/cache/Symfony/Config/Framework/HttpClient/ScopedClientConfig/PeerFingerprintConfig.php
  g
  E      `   api/Resources/cache/Symfony/Config/Framework/HttpClient/ScopedClientConfig/RetryFailedConfig.php  g  #      N   api/Resources/cache/Symfony/Config/Framework/HttpClient/ScopedClientConfig.php4S  g4S  S¤      e   api/Resources/cache/Symfony/Config/Framework/HttpClient/DefaultOptions/RetryFailed/HttpCodeConfig.php  g  ,@Ϥ      `   api/Resources/cache/Symfony/Config/Framework/HttpClient/DefaultOptions/PeerFingerprintConfig.php	  g	   !j      \   api/Resources/cache/Symfony/Config/Framework/HttpClient/DefaultOptions/RetryFailedConfig.php  g  =q      I   api/Resources/cache/Symfony/Config/Framework/Serializer/MappingConfig.phpF  gF  $v      A   api/Resources/cache/Symfony/Config/Framework/ValidationConfig.php(  g(  >Ť      B   api/Resources/cache/Symfony/Config/Framework/RateLimiterConfig.php	  g	        U   api/Resources/cache/Symfony/Config/Framework/RateLimiter/LimiterConfig/RateConfig.phpm  gm  $S      J   api/Resources/cache/Symfony/Config/Framework/RateLimiter/LimiterConfig.php  g  9§      A   api/Resources/cache/Symfony/Config/Framework/Cache/PoolConfig.php  g  -.-      A   api/Resources/cache/Symfony/Config/Framework/SerializerConfig.php  g  2*      E   api/Resources/cache/Symfony/Config/Framework/CsrfProtectionConfig.php7  g7  g	      =   api/Resources/cache/Symfony/Config/Framework/AssetsConfig.php+  g+  (      N   api/Resources/cache/Symfony/Config/Framework/Notifier/AdminRecipientConfig.phpZ  gZ  ¾      @   api/Resources/cache/Symfony/Config/Framework/MessengerConfig.phpe*  ge*  ]      >   api/Resources/cache/Symfony/Config/Framework/WebhookConfig.php  g  &J      =   api/Resources/cache/Symfony/Config/Framework/RouterConfig.php  g  ^      A   api/Resources/cache/Symfony/Config/Framework/TranslatorConfig.php"  g"  f      @   api/Resources/cache/Symfony/Config/Framework/WorkflowsConfig.php  g  
      J   api/Resources/cache/Symfony/Config/Framework/Workflows/WorkflowsConfig.php~+  g~+  7      [   api/Resources/cache/Symfony/Config/Framework/Workflows/WorkflowsConfig/AuditTrailConfig.phpN  gN  VN      ]   api/Resources/cache/Symfony/Config/Framework/Workflows/WorkflowsConfig/MarkingStoreConfig.php	  g	  h4      [   api/Resources/cache/Symfony/Config/Framework/Workflows/WorkflowsConfig/TransitionConfig.php]  g]  Eg :      V   api/Resources/cache/Symfony/Config/Framework/Workflows/WorkflowsConfig/PlaceConfig.php  g  i:      :   api/Resources/cache/Symfony/Config/Framework/EsiConfig.php-  g-  5      >   api/Resources/cache/Symfony/Config/Framework/WebLinkConfig.php1  g1        F   api/Resources/cache/Symfony/Config/Framework/Mailer/EnvelopeConfig.php  g  R      D   api/Resources/cache/Symfony/Config/Framework/Mailer/HeaderConfig.php,  g,  lu      :   api/Resources/cache/Symfony/Config/Framework/SsiConfig.php-  g-  (      T   api/Resources/cache/Symfony/Config/Framework/Translator/PseudoLocalizationConfig.php  g  |Њ      J   api/Resources/cache/Symfony/Config/Framework/Translator/ProviderConfig.php
  g
  ܤ      ?   api/Resources/cache/Symfony/Config/Framework/ProfilerConfig.php  g  pé      @   api/Resources/cache/Symfony/Config/Framework/SemaphoreConfig.php  g  R8      >   api/Resources/cache/Symfony/Config/Framework/SecretsConfig.php  g  |1      E   api/Resources/cache/Symfony/Config/Framework/PropertyAccessConfig.php  g  S(      J   api/Resources/cache/Symfony/Config/Framework/Messenger/TransportConfig.php  g  	      ]   api/Resources/cache/Symfony/Config/Framework/Messenger/Serializer/SymfonySerializerConfig.php  g  +]      K   api/Resources/cache/Symfony/Config/Framework/Messenger/SerializerConfig.php  g  Ot      ^   api/Resources/cache/Symfony/Config/Framework/Messenger/TransportConfig/RetryStrategyConfig.php?  g?  [T      H   api/Resources/cache/Symfony/Config/Framework/Messenger/RoutingConfig.php]  g]  zT      U   api/Resources/cache/Symfony/Config/Framework/Messenger/BusConfig/MiddlewareConfig.php  g  i      \   api/Resources/cache/Symfony/Config/Framework/Messenger/BusConfig/DefaultMiddlewareConfig.php
  g
  Ԥ      D   api/Resources/cache/Symfony/Config/Framework/Messenger/BusConfig.php  g        C   api/Resources/cache/Symfony/Config/Framework/PropertyInfoConfig.php5  g5        =   api/Resources/cache/Symfony/Config/Framework/MailerConfig.php2  g2        :   api/Resources/cache/Symfony/Config/Framework/UidConfig.php  g  ե      B   api/Resources/cache/Symfony/Config/Framework/RemoteeventConfig.php5  g5  `      B   api/Resources/cache/Symfony/Config/Framework/AssetMapperConfig.phpY(  gY(  Pm      D   api/Resources/cache/Symfony/Config/Framework/HtmlSanitizerConfig.php*
  g*
  
?      @   api/Resources/cache/Symfony/Config/Framework/ExceptionConfig.phpO  gO        >   api/Resources/cache/Symfony/Config/Framework/SessionConfig.php`2  g`2        N   api/Resources/cache/Symfony/Config/Framework/HtmlSanitizer/SanitizerConfig.php9  g9  ,      A   api/Resources/cache/Symfony/Config/Framework/HttpClientConfig.phpm  gm        @   api/Resources/cache/Symfony/Config/Framework/PhpErrorsConfig.php  g  .m      ?   api/Resources/cache/Symfony/Config/Framework/NotifierConfig.phpS  gS  6S2      >   api/Resources/cache/Symfony/Config/Framework/RequestConfig.phpg  gg  Ϊ      B   api/Resources/cache/Symfony/Config/Framework/AnnotationsConfig.php  g  c:Ĥ      E   api/Resources/cache/Symfony/Config/Framework/Assets/PackageConfig.php!  g!  `      X   api/Resources/cache/Symfony/Config/Framework/Validation/NotCompromisedPasswordConfig.php9  g9  r9`      I   api/Resources/cache/Symfony/Config/Framework/Validation/MappingConfig.phpF  gF  Һ      M   api/Resources/cache/Symfony/Config/Framework/Validation/AutoMappingConfig.phpn  gn  }      ;   api/Resources/cache/Symfony/Config/Framework/LockConfig.php  g  $      @   api/Resources/cache/Symfony/Config/Framework/SchedulerConfig.php3  g3        ;   api/Resources/cache/Symfony/Config/Framework/FormConfig.php
  g
  ܥ;      P   api/Resources/cache/Symfony/Config/Security/ProviderConfig/Memory/UserConfig.php  g  K      I   api/Resources/cache/Symfony/Config/Security/ProviderConfig/LdapConfig.php  g  OK      K   api/Resources/cache/Symfony/Config/Security/ProviderConfig/MemoryConfig.phpO  gO  >]      J   api/Resources/cache/Symfony/Config/Security/ProviderConfig/ChainConfig.php  g  y4      D   api/Resources/cache/Symfony/Config/Security/PasswordHasherConfig.php  g  j{쾤      >   api/Resources/cache/Symfony/Config/Security/ProviderConfig.php  g  73      >   api/Resources/cache/Symfony/Config/Security/FirewallConfig.php&n  g&n        P   api/Resources/cache/Symfony/Config/Security/FirewallConfig/AccessTokenConfig.php  g  ?3      O   api/Resources/cache/Symfony/Config/Security/FirewallConfig/RememberMeConfig.php1  g1  ڊ      N   api/Resources/cache/Symfony/Config/Security/FirewallConfig/FormLoginConfig.phpA  gA  ǌ       R   api/Resources/cache/Symfony/Config/Security/FirewallConfig/JsonLoginLdapConfig.php,*  g,*  Ex      N   api/Resources/cache/Symfony/Config/Security/FirewallConfig/HttpBasicConfig.php  g  j      ]   api/Resources/cache/Symfony/Config/Security/FirewallConfig/AccessToken/TokenHandlerConfig.php  g  J      j   api/Resources/cache/Symfony/Config/Security/FirewallConfig/AccessToken/TokenHandler/OidcUserInfoConfig.php
  g
  
      b   api/Resources/cache/Symfony/Config/Security/FirewallConfig/AccessToken/TokenHandler/OidcConfig.php  g  .}e      N   api/Resources/cache/Symfony/Config/Security/FirewallConfig/JsonLoginConfig.php  g  \      X   api/Resources/cache/Symfony/Config/Security/FirewallConfig/Logout/DeleteCookieConfig.php  g  8x      O   api/Resources/cache/Symfony/Config/Security/FirewallConfig/SwitchUserConfig.php  g  j a      T   api/Resources/cache/Symfony/Config/Security/FirewallConfig/LoginThrottlingConfig.php
  g
  >      N   api/Resources/cache/Symfony/Config/Security/FirewallConfig/LoginLinkConfig.php3  g3  ~1      f   api/Resources/cache/Symfony/Config/Security/FirewallConfig/RememberMe/TokenProvider/DoctrineConfig.php  g  =      ]   api/Resources/cache/Symfony/Config/Security/FirewallConfig/RememberMe/TokenProviderConfig.php
  g
        R   api/Resources/cache/Symfony/Config/Security/FirewallConfig/FormLoginLdapConfig.phpNN  gNN  jN      R   api/Resources/cache/Symfony/Config/Security/FirewallConfig/HttpBasicLdapConfig.php  g  B      I   api/Resources/cache/Symfony/Config/Security/FirewallConfig/X509Config.php  g  I      O   api/Resources/cache/Symfony/Config/Security/FirewallConfig/RemoteUserConfig.php  g  U8      K   api/Resources/cache/Symfony/Config/Security/FirewallConfig/LogoutConfig.php#  g#        K   api/Resources/cache/Symfony/Config/Security/AccessDecisionManagerConfig.php  g  O^      C   api/Resources/cache/Symfony/Config/Security/AccessControlConfig.php  g  XAL      5   api/Resources/cache/Symfony/Config/SecurityConfig.php
1  g
1  Y~      4   api/Resources/cache/Symfony/Config/MonologConfig.php  g  FF      <   api/Resources/cache/Symfony/Config/Monolog/HandlerConfig.php* g* Ռ      V   api/Resources/cache/Symfony/Config/Monolog/HandlerConfig/ProcessPsr3MessagesConfig.php
  g
  U      L   api/Resources/cache/Symfony/Config/Monolog/HandlerConfig/PublisherConfig.php"  g"  -      H   api/Resources/cache/Symfony/Config/Monolog/HandlerConfig/RedisConfig.php  g  ע      P   api/Resources/cache/Symfony/Config/Monolog/HandlerConfig/ElasticsearchConfig.php  g  !a      Q   api/Resources/cache/Symfony/Config/Monolog/HandlerConfig/EmailPrototypeConfig.phpZ  gZ  q:_      H   api/Resources/cache/Symfony/Config/Monolog/HandlerConfig/MongoConfig.php  g  =o      R   api/Resources/cache/Symfony/Config/Monolog/HandlerConfig/VerbosityLevelsConfig.php  g  =1ޤ      I   api/Resources/cache/Symfony/Config/Monolog/HandlerConfig/PredisConfig.php:  g:  f ɤ      S   api/Resources/cache/Symfony/Config/Monolog/HandlerConfig/ExcludedHttpCodeConfig.php~  g~  4:T      K   api/Resources/cache/Symfony/Config/Monolog/HandlerConfig/ChannelsConfig.php  g  у      6   api/Resources/cache/Symfony/Config/FrameworkConfig.php' g' oA      #   api/Resources/cache/annotations.map  g  r'      T   api/Resources/cache/ContainerFvxaQPo/getSecurity_Firewall_Map_Context_ApiService.php^
  g^
  &*L      W   api/Resources/cache/ContainerFvxaQPo/getContainer_GetRoutingConditionServiceService.php  g  )      F   api/Resources/cache/ContainerFvxaQPo/getComposerController2Service.php  g  XΤ      N   api/Resources/cache/ContainerFvxaQPo/getSecurity_UserCheckerLocatorService.php  g  b=7      N   api/Resources/cache/ContainerFvxaQPo/getConsole_Command_SecretsListService.php  g  no      P   api/Resources/cache/ContainerFvxaQPo/getConsole_Command_SecretsRemoveService.php  g  !      C   api/Resources/cache/ContainerFvxaQPo/getGraphicsLibCheckService.php  g  m¤      C   api/Resources/cache/ContainerFvxaQPo/getPhpCliControllerService.php  g  "      Y   api/Resources/cache/ContainerFvxaQPo/getSecurity_Authenticator_ManagersLocatorService.php  g  3KR      D   api/Resources/cache/ContainerFvxaQPo/getTaskDeleteCommandService.php  g  Z      `   api/Resources/cache/ContainerFvxaQPo/get_Console_Command_SecretsEncryptFromLocal_LazyService.php~  g~  }V      G   api/Resources/cache/ContainerFvxaQPo/getConstraintControllerService.php  g  g
*Ƥ      V   api/Resources/cache/ContainerFvxaQPo/getArgumentResolver_BackedEnumResolverService.php  g  <l      4   api/Resources/cache/ContainerFvxaQPo/removed-ids.phpϧ  gϧ  OB      G   api/Resources/cache/ContainerFvxaQPo/getProcessRunnerCommandService.php/  g/  `-
      C   api/Resources/cache/ContainerFvxaQPo/getJwtAuthenticatorService.php  g  e      C   api/Resources/cache/ContainerFvxaQPo/getContaoControllerService.php?  g?  #ކ      E   api/Resources/cache/ContainerFvxaQPo/getSecurity_AccessMapService.php*  g*  Ov4      H   api/Resources/cache/ContainerFvxaQPo/getIntegrityCheckFactoryService.php?  g?  Ƥ      Q   api/Resources/cache/ContainerFvxaQPo/getConsole_Command_ContainerDebugService.php)  g)  ڤ      W   api/Resources/cache/ContainerFvxaQPo/get_Console_Command_ContainerDebug_LazyService.php(  g(  n:      H   api/Resources/cache/ContainerFvxaQPo/getWebauthnAuthenticatorService.php	  g	  {      F   api/Resources/cache/ContainerFvxaQPo/getJwtCookieControllerService.php:  g:  /      E   api/Resources/cache/ContainerFvxaQPo/getRouter_CacheWarmerService.phpu  gu        D   api/Resources/cache/ContainerFvxaQPo/getBackupRestoreTaskService.phpL  gL  m
      H   api/Resources/cache/ContainerFvxaQPo/getConsole_CommandLoaderService.phpN'  gN'  m/      <   api/Resources/cache/ContainerFvxaQPo/getCache_AppService.phpb  gb  ֤      M   api/Resources/cache/ContainerFvxaQPo/getConsole_Command_SecretsSetService.php  g  P1'      T   api/Resources/cache/ContainerFvxaQPo/getSecurity_Command_UserPasswordHashService.php  g  L	^      H   api/Resources/cache/ContainerFvxaQPo/getConsoleProcessFactoryService.phpd  gd  9R      \   api/Resources/cache/ContainerFvxaQPo/get_Console_Command_ConfigDumpReference_LazyService.php^  g^  x"      C   api/Resources/cache/ContainerFvxaQPo/getCache_AppClearerService.php  g  o?      A   api/Resources/cache/ContainerFvxaQPo/getUserControllerService.php  g  a;O      N   api/Resources/cache/ContainerFvxaQPo/getConsole_Command_RouterDebugService.php  g  ?@W      Q   api/Resources/cache/ContainerFvxaQPo/Contao_ManagerApi_ApiKernelProdContainer.phpa  ga  r
      W   api/Resources/cache/ContainerFvxaQPo/get_Console_Command_CachePoolPrune_LazyService.php  g  `X      D   api/Resources/cache/ContainerFvxaQPo/getTaskUpdateCommandService.php  g        A   api/Resources/cache/ContainerFvxaQPo/getTaskControllerService.php  g  )G       L   api/Resources/cache/ContainerFvxaQPo/getMaintenanceModeControllerService.php  g  $      A   api/Resources/cache/ContainerFvxaQPo/getFileControllerService.php  g  q      J   api/Resources/cache/ContainerFvxaQPo/get_ServiceLocator_Y_Xs7MwService.phpT  gT  783      A   api/Resources/cache/ContainerFvxaQPo/getRouting_LoaderService.phpN
  gN
  ݤ      >   api/Resources/cache/ContainerFvxaQPo/getEnvironmentService.php  g  ʔפ      T   api/Resources/cache/ContainerFvxaQPo/getSecurity_Listener_UserChecker_ApiService.php  g  (z      C   api/Resources/cache/ContainerFvxaQPo/getServicesResetterService.php~  g~  .$      e   api/Resources/cache/ContainerFvxaQPo/getCache_SecurityIsGrantedAttributeExpressionLanguageService.php  g  Fp      D   api/Resources/cache/ContainerFvxaQPo/getOpcacheControllerService.php  g  	      P   api/Resources/cache/ContainerFvxaQPo/getConsole_Command_AssetsInstallService.php  g  x	      Q   api/Resources/cache/ContainerFvxaQPo/getSerializer_Mapping_CacheWarmerService.php  g  @1L      E   api/Resources/cache/ContainerFvxaQPo/getLoginAuthenticatorService.php  g  \      O   api/Resources/cache/ContainerFvxaQPo/getSecurity_EventDispatcher_ApiService.php&  g&  ct$      ?   api/Resources/cache/ContainerFvxaQPo/getCache_SystemService.php  g  o      A   api/Resources/cache/ContainerFvxaQPo/getMonolog_LoggerService.php  g  j      X   api/Resources/cache/ContainerFvxaQPo/get_Console_Command_CachePoolDelete_LazyService.php+  g+  #w      J   api/Resources/cache/ContainerFvxaQPo/getMonolog_Logger_SecurityService.php  g  B      @   api/Resources/cache/ContainerFvxaQPo/getUpdateCommandService.php  g  \      Q   api/Resources/cache/ContainerFvxaQPo/getDebug_ErrorHandlerConfiguratorService.php\  g\  'W      I   api/Resources/cache/ContainerFvxaQPo/getTaskDeleteCommand_LazyService.php  g        U   api/Resources/cache/ContainerFvxaQPo/getSecurity_Access_AuthenticatedVoterService.phpL  gL        ?   api/Resources/cache/ContainerFvxaQPo/getProcessCheckService.php
  g
  Oۤ      D   api/Resources/cache/ContainerFvxaQPo/getSessionControllerService.php  g  I¤      V   api/Resources/cache/ContainerFvxaQPo/getSecurity_Listener_PasswordMigratingService.php$  g$        A   api/Resources/cache/ContainerFvxaQPo/getSelfUpdateTaskService.php*  g*  Y٤      X   api/Resources/cache/ContainerFvxaQPo/get_Console_Command_SerializerDebug_LazyService.php  g  4+      F   api/Resources/cache/ContainerFvxaQPo/getCache_GlobalClearerService.phpn  gn  Mo      >   api/Resources/cache/ContainerFvxaQPo/getTaskManagerService.php  g  /      H   api/Resources/cache/ContainerFvxaQPo/getConsole_ErrorListenerService.php  g  D&դ      K   api/Resources/cache/ContainerFvxaQPo/getUploadPackagesControllerService.php  g  c      <   api/Resources/cache/ContainerFvxaQPo/getContaoApiService.php^  g^  nl6      C   api/Resources/cache/ContainerFvxaQPo/getMemoryLimitCheckService.php  g  UGĢ      W   api/Resources/cache/ContainerFvxaQPo/get_Security_Command_DebugFirewall_LazyService.php+  g+        B   api/Resources/cache/ContainerFvxaQPo/getSysTempDirCheckService.php  g  x6      V   api/Resources/cache/ContainerFvxaQPo/get_Console_Command_SecretsRemove_LazyService.php  g  "      _   api/Resources/cache/ContainerFvxaQPo/getArgumentResolver_QueryParameterValueResolverService.php  g  e      I   api/Resources/cache/ContainerFvxaQPo/getTaskUpdateCommand_LazyService.php  g  z      C   api/Resources/cache/ContainerFvxaQPo/getConfigControllerService.php  g  |      =   api/Resources/cache/ContainerFvxaQPo/getSelfUpdateService.php  g  jG      C   api/Resources/cache/ContainerFvxaQPo/getTaskAbortCommandService.php  g  [I      @   api/Resources/cache/ContainerFvxaQPo/getCloudResolverService.php  g  Zr      ^   api/Resources/cache/ContainerFvxaQPo/get_Console_Command_SecretsDecryptToLocal_LazyService.php|  g|        F   api/Resources/cache/ContainerFvxaQPo/getAccessKeyControllerService.php:  g:  %      S   api/Resources/cache/ContainerFvxaQPo/getPropertyInfo_SerializerExtractorService.php$  g$  ]*      ?   api/Resources/cache/ContainerFvxaQPo/getUserProviderService.php  g  yNU      C   api/Resources/cache/ContainerFvxaQPo/getPhpWebControllerService.phpJ  gJ  =      D   api/Resources/cache/ContainerFvxaQPo/getAboutCommand_LazyService.php  g  A      P   api/Resources/cache/ContainerFvxaQPo/getConsole_Command_ContainerLintService.php<  g<  ;7      N   api/Resources/cache/ContainerFvxaQPo/get_Console_Command_About_LazyService.php  g  %      T   api/Resources/cache/ContainerFvxaQPo/get_Console_Command_RouterMatch_LazyService.php  g  0      =   api/Resources/cache/ContainerFvxaQPo/getTranslatorService.php  g  W_      G   api/Resources/cache/ContainerFvxaQPo/getSelfUpdateControllerService.php  g  i-      K   api/Resources/cache/ContainerFvxaQPo/getSecurity_ChannelListenerService.php  g  ݀R      L   api/Resources/cache/ContainerFvxaQPo/getArgumentResolver_VariadicService.php  g  x      D   api/Resources/cache/ContainerFvxaQPo/getManagerControllerService.php7  g7  
      C   api/Resources/cache/ContainerFvxaQPo/getBackupControllerService.php  g        B   api/Resources/cache/ContainerFvxaQPo/getSecurity_HelperService.php;  g;  t<      Q   api/Resources/cache/ContainerFvxaQPo/getSecurity_Listener_UserProviderService.php  g  y_`      Q   api/Resources/cache/ContainerFvxaQPo/get_Console_Command_YamlLint_LazyService.php  g  A      @   api/Resources/cache/ContainerFvxaQPo/getSecrets_VaultService.phpE  gE         V   api/Resources/cache/ContainerFvxaQPo/getConsole_Command_ConfigDumpReferenceService.phpN  gN  64      N   api/Resources/cache/ContainerFvxaQPo/getConsole_Command_CacheWarmupService.phpS  gS  yT      U   api/Resources/cache/ContainerFvxaQPo/getSecurity_Access_RoleHierarchyVoterService.php*  g*  F!=      T   api/Resources/cache/ContainerFvxaQPo/getArgumentResolver_RequestAttributeService.php  g  iKt      C   api/Resources/cache/ContainerFvxaQPo/getBackupCreateTaskService.phpG  gG  I      L   api/Resources/cache/ContainerFvxaQPo/getProcessRunnerCommand_LazyService.php  g  H      R   api/Resources/cache/ContainerFvxaQPo/getConsole_Command_CachePoolDeleteService.phpt  gt  L?X      B   api/Resources/cache/ContainerFvxaQPo/getCloudControllerService.phpm  gm  p      <   api/Resources/cache/ContainerFvxaQPo/getSetupTaskService.phpX  gX  5vȤ      S   api/Resources/cache/ContainerFvxaQPo/get_Console_Command_SecretsSet_LazyService.php  g  mdG      E   api/Resources/cache/ContainerFvxaQPo/getTemplateControllerService.php  g  堔      Z   api/Resources/cache/ContainerFvxaQPo/getConsole_Command_CachePoolInvalidateTagsService.php  g  c"      ]   api/Resources/cache/ContainerFvxaQPo/get_Console_Command_EventDispatcherDebug_LazyService.phpg  gg  F(Q      V   api/Resources/cache/ContainerFvxaQPo/get_Console_Command_CachePoolList_LazyService.php  g  n      W   api/Resources/cache/ContainerFvxaQPo/getConsole_Command_EventDispatcherDebugService.php  g  D頤      K   api/Resources/cache/ContainerFvxaQPo/getArgumentResolver_ServiceService.php  g  /O      `   api/Resources/cache/ContainerFvxaQPo/get_Console_Command_CachePoolInvalidateTags_LazyService.php  g  :4A      T   api/Resources/cache/ContainerFvxaQPo/get_Console_Command_CacheWarmup_LazyService.php  g        F   api/Resources/cache/ContainerFvxaQPo/getCache_SystemClearerService.php  g  |~      J   api/Resources/cache/ContainerFvxaQPo/get_ServiceLocator_BvkMlPlService.phpP  gP  Ft      G   api/Resources/cache/ContainerFvxaQPo/getMonolog_Logger_TasksService.php  g  (_̤      F   api/Resources/cache/ContainerFvxaQPo/getAdminUserControllerService.phpB  gB  ,~1      H   api/Resources/cache/ContainerFvxaQPo/getIntegrityCheckCommandService.php  g        V   api/Resources/cache/ContainerFvxaQPo/get_Console_Command_AssetsInstall_LazyService.php)  g)  --      [   api/Resources/cache/ContainerFvxaQPo/getSecurity_Firewall_EventDispatcherLocatorService.php  g  @M      R   api/Resources/cache/ContainerFvxaQPo/getConsole_Command_SerializerDebugService.php  g        E   api/Resources/cache/ContainerFvxaQPo/getPhpExtensionsCheckService.php(  g(  $      K   api/Resources/cache/ContainerFvxaQPo/getArgumentResolver_DefaultService.php  g  Y      A   api/Resources/cache/ContainerFvxaQPo/getAuthControllerService.php  g  k      L   api/Resources/cache/ContainerFvxaQPo/getArgumentResolver_DatetimeService.php  g  %      G   api/Resources/cache/ContainerFvxaQPo/getArgumentResolver_UidService.php  g  R      L   api/Resources/cache/ContainerFvxaQPo/getInstallToolLockControllerService.php  g  R       E   api/Resources/cache/ContainerFvxaQPo/getUpdateCommand_LazyService.php  g  	r      E   api/Resources/cache/ContainerFvxaQPo/getComposerControllerService.php>  g>  3ͥ      K   api/Resources/cache/ContainerFvxaQPo/getArgumentResolver_SessionService.php  g  iW      >   api/Resources/cache/ContainerFvxaQPo/getCacheWarmerService.php  g  `s;      E   api/Resources/cache/ContainerFvxaQPo/getRedirectControllerService.php  g  ,      @   api/Resources/cache/ContainerFvxaQPo/getUploadsConfigService.php  g  vx      N   api/Resources/cache/ContainerFvxaQPo/getDatabaseMigrationControllerService.php=  g=  AՅ[      K   api/Resources/cache/ContainerFvxaQPo/getConsole_Command_YamlLintService.php	  g	  f`b      G   api/Resources/cache/ContainerFvxaQPo/getConfigBuilder_WarmerService.php  g  [A      L   api/Resources/cache/ContainerFvxaQPo/getPasswordlessAuthenticatorService.php  g  ӵ3      A   api/Resources/cache/ContainerFvxaQPo/getClearCacheTaskService.phpE  gE        H   api/Resources/cache/ContainerFvxaQPo/getRootPackageControllerService.phpQ  gQ  ~cw2      E   api/Resources/cache/ContainerFvxaQPo/getCache_App_TaggableService.php  g  *X?      @   api/Resources/cache/ContainerFvxaQPo/getContaoConsoleService.php  g  *Τ      @   api/Resources/cache/ContainerFvxaQPo/getManagerConfigService.php  g  ny      M   api/Resources/cache/ContainerFvxaQPo/getSecurity_UserValueResolverService.php  g  b_      X   api/Resources/cache/ContainerFvxaQPo/get_Console_Command_DebugAutowiring_LazyService.php8  g8        Q   api/Resources/cache/ContainerFvxaQPo/getSecurity_Command_DebugFirewallService.php  g  ryA      b   api/Resources/cache/ContainerFvxaQPo/getSecurity_Listener_CheckAuthenticatorCredentialsService.phpH  gH  H      W   api/Resources/cache/ContainerFvxaQPo/get_Console_Command_CachePoolClear_LazyService.php  g  ΁d      M   api/Resources/cache/ContainerFvxaQPo/getConsole_Command_CacheClearService.php  g  }Q      D   api/Resources/cache/ContainerFvxaQPo/getPhpinfoControllerService.php  g  瞤      P   api/Resources/cache/ContainerFvxaQPo/getConsole_Command_CachePoolListService.php  g  Sp.7      U   api/Resources/cache/ContainerFvxaQPo/getSecurity_Authenticator_Manager_ApiService.php  g  '3      E   api/Resources/cache/ContainerFvxaQPo/getAllowUrlFopenCheckService.php(  g(  x!      C   api/Resources/cache/ContainerFvxaQPo/getRebuildCacheTaskService.phpp  gp  J&      V   api/Resources/cache/ContainerFvxaQPo/getSecurity_Firewall_Authenticator_ApiService.php  g  \޻      [   api/Resources/cache/ContainerFvxaQPo/get_Console_Command_SecretsGenerateKey_LazyService.phpE  gE  hHɤ      T   api/Resources/cache/ContainerFvxaQPo/get_Console_Command_RouterDebug_LazyService.php  g  e      Q   api/Resources/cache/ContainerFvxaQPo/getConsole_Command_CachePoolClearService.php_  g_  .      @   api/Resources/cache/ContainerFvxaQPo/getLogControllerService.php*  g*  b'      L   api/Resources/cache/ContainerFvxaQPo/getContainer_EnvVarProcessorService.php,  g,  /_6-      U   api/Resources/cache/ContainerFvxaQPo/getSecurity_Listener_Api_UserProviderService.php!  g!  Rؤ      >   api/Resources/cache/ContainerFvxaQPo/getInstallTaskService.php#  g#  U      T   api/Resources/cache/ContainerFvxaQPo/getContainer_EnvVarProcessorsLocatorService.php
  g
  c      D   api/Resources/cache/ContainerFvxaQPo/getExceptionListenerService.php  g  \#      ?   api/Resources/cache/ContainerFvxaQPo/getSymlinkCheckService.php  g  J/      :   api/Resources/cache/ContainerFvxaQPo/getRequestService.php  g  WGq      ?   api/Resources/cache/ContainerFvxaQPo/getSessionCheckService.php
  g
  lMՉ      L   api/Resources/cache/ContainerFvxaQPo/getMissingPackagesControllerService.phpe  ge  
      U   api/Resources/cache/ContainerFvxaQPo/getConsole_Command_SecretsGenerateKeyService.php8  g8  8nQ      =   api/Resources/cache/ContainerFvxaQPo/getUpdateTaskService.php  g  o	t      T   api/Resources/cache/ContainerFvxaQPo/get_Console_Command_SecretsList_LazyService.php  g  P      A   api/Resources/cache/ContainerFvxaQPo/getComposerConfigService.php   g   D	      Z   api/Resources/cache/ContainerFvxaQPo/getConsole_Command_SecretsEncryptFromLocalService.php`  g`  =!p      J   api/Resources/cache/ContainerFvxaQPo/getSecurity_AccessListenerService.php  g  =p      Q   api/Resources/cache/ContainerFvxaQPo/getConsole_Command_CachePoolPruneService.php  g  Fq      Z   api/Resources/cache/ContainerFvxaQPo/get_Security_Command_UserPasswordHash_LazyService.php6  g6  cx      N   api/Resources/cache/ContainerFvxaQPo/getSecurity_RouteLoader_LogoutService.php  g  o      T   api/Resources/cache/ContainerFvxaQPo/get_Console_Command_ConfigDebug_LazyService.php  g  2H      E   api/Resources/cache/ContainerFvxaQPo/getDatabaseControllerService.php  g  p.      X   api/Resources/cache/ContainerFvxaQPo/getConsole_Command_SecretsDecryptToLocalService.phpd  gd  !      J   api/Resources/cache/ContainerFvxaQPo/getLocalPackagesControllerService.php[  g[  3J      ?   api/Resources/cache/ContainerFvxaQPo/getAboutCommandService.php  g  ;Z      H   api/Resources/cache/ContainerFvxaQPo/getTaskAbortCommand_LazyService.php  g  }=	      V   api/Resources/cache/ContainerFvxaQPo/getSecurity_SecurityTokenValueResolverService.php@  g@  zo      E   api/Resources/cache/ContainerFvxaQPo/getTokenAuthenticatorService.php  g  ;      R   api/Resources/cache/ContainerFvxaQPo/getConsole_Command_DebugAutowiringService.php  g  q      =   api/Resources/cache/ContainerFvxaQPo/getServerInfoService.php  g  ;hͤ      N   api/Resources/cache/ContainerFvxaQPo/getConsole_Command_RouterMatchService.php  g  _      M   api/Resources/cache/ContainerFvxaQPo/getIntegrityCheckCommand_LazyService.php  g   ͤ      J   api/Resources/cache/ContainerFvxaQPo/get_ServiceLocator_AH5O6SdService.phph  gh  &      B   api/Resources/cache/ContainerFvxaQPo/getErrorControllerService.php  g  D'      J   api/Resources/cache/ContainerFvxaQPo/get_ServiceLocator_EZsc_DOService.phpb  gb  C      S   api/Resources/cache/ContainerFvxaQPo/get_Console_Command_CacheClear_LazyService.php  g  4֤      K   api/Resources/cache/ContainerFvxaQPo/getArgumentResolver_RequestService.php  g  g      P   api/Resources/cache/ContainerFvxaQPo/RequestPayloadValueResolverGhost8d82153.phpp  gp  #촤      H   api/Resources/cache/ContainerFvxaQPo/getConsole_Command_AboutService.php  g  ?~Q?      C   api/Resources/cache/ContainerFvxaQPo/getDumpAutoloadTaskService.phpO  gO  h9L      V   api/Resources/cache/ContainerFvxaQPo/get_Console_Command_ContainerLint_LazyService.php8  g8  bD      N   api/Resources/cache/ContainerFvxaQPo/getConsole_Command_ConfigDebugService.php  g  c      "   api/Resources/config/services.yamlx
  gx
  K~I      $   api/Resources/config/config_dev.yaml  g        %   api/Resources/config/config_prod.yaml   g   H          api/Resources/config/config.yaml*  g*  "H         api/Resources/i18n/cs.ymll  gl  z         api/Resources/i18n/br.yml  g           api/Resources/i18n/es.yml  g  k3?         api/Resources/i18n/pt.yml  g  DM̤         api/Resources/i18n/de.yml  g  |E         api/Resources/i18n/it.yml  g  k6         api/Resources/i18n/pl.yml  g  Oy         api/Resources/i18n/fa.yml;	  g;	  1,         api/Resources/i18n/sv.yml  g  9詤         api/Resources/i18n/en.yml!  g!  s         api/Resources/i18n/ja.ymlX  gX  d         api/Resources/i18n/ru.ymlh  gh  
V         api/Resources/i18n/sr.yml  g  "\         api/Resources/i18n/fr.yml  g  0         api/Resources/i18n/lv.ymlx  gx  M         api/Resources/i18n/tr.yml8  g8  Ey         api/Resources/i18n/nl.yml  g   U         api/Resources/i18n/zh.yml
  g
  ;Ϥ         api/ApiApplication.php  g  -r      #   api/Tests/Composer/CloudJobTest.php  g  !L      '   api/Tests/Controller/LogPatternTest.php0  g0  Ly      !   api/Controller/FileController.phpU  gU  _ќ      !   api/Controller/UserController.php>  g>  Տ"          api/Controller/LogController.php  g  '%      (   api/Controller/Config/AuthController.phpg  gg  rI6      2   api/Controller/Config/AbstractConfigController.php  g  <V      ,   api/Controller/Config/ComposerController.php  g  gƤ      +   api/Controller/Config/ManagerController.php  g  ݤ      !   api/Controller/TaskController.php  g  W5      *   api/Controller/Server/PhpWebController.phpD  gD  1eŤ      *   api/Controller/Server/ContaoController.php"  g"  ͚v      ,   api/Controller/Server/DatabaseController.php2
  g2
  W?      -   api/Controller/Server/AdminUserController.php
  g
  DV      +   api/Controller/Server/PhpinfoController.phpr  gr  %E      +   api/Controller/Server/OpcacheController.php  g  "      *   api/Controller/Server/ConfigController.php  g  $      ,   api/Controller/Server/ComposerController.php  g  G6      *   api/Controller/Server/PhpCliController.php  g  K|Q      .   api/Controller/Server/SelfUpdateController.php  g  $w      $   api/Controller/SessionController.phps  gs  YK~      5   api/Controller/Packages/MissingPackagesController.php
  g
  2c      4   api/Controller/Packages/UploadPackagesController.php'  g'  +T      1   api/Controller/Packages/RootPackageController.php'  g'  &H)      +   api/Controller/Packages/CloudController.phpf  gf  Vu      3   api/Controller/Packages/LocalPackagesController.phpN  gN        '   api/Controller/ConstraintController.phpY  gY  kۤ      3   api/Controller/Contao/InstallToolLockController.php3  g3  AÖ      5   api/Controller/Contao/DatabaseMigrationController.php%  g%  Zb      -   api/Controller/Contao/AccessKeyController.php0  g0  I>      *   api/Controller/Contao/BackupController.php,  g,  >]6      3   api/Controller/Contao/MaintenanceModeController.php  g  $iW      -   api/Controller/Contao/JwtCookieController.php  g  bˤ         api/ApiKernel.php=&  g=&  eդ         api/System/ServerInfo.phpq  gq  ƾq         api/System/Request.php[  g[  y9[<         api/System/SelfUpdate.phpD  gD  qׂ         api/Task/TaskStatus.php  g  S!~'      &   api/Task/Composer/DumpAutoloadTask.php  g  Wj      $   api/Task/Composer/ClearCacheTask.php  g        #   api/Task/Manager/SelfUpdateTask.php  g  @?&         api/Task/AbstractTask.php
  g
  ΪG         api/Task/Packages/SetupTask.php
  g
  3P          api/Task/Packages/UpdateTask.phpE(  gE(  +      !   api/Task/Packages/InstallTask.php  g  }Kݤ      *   api/Task/Packages/AbstractPackagesTask.phpY  gY        $   api/Task/Contao/BackupCreateTask.php  g  E      %   api/Task/Contao/BackupRestoreTask.php  g  UF      $   api/Task/Contao/RebuildCacheTask.php  g  lK         api/Task/TaskManager.php  g  )FŤ         api/Task/TaskInterface.php  g  1m         api/Task/TaskConfig.php	  g	  /ʤ      %   api/Command/IntegrityCheckCommand.php	  g	           api/Command/UpdateCommand.php  g  %          api/Command/TaskAbortCommand.phpJ  gJ  {P峤      !   api/Command/TaskUpdateCommand.phpz  gz  k      $   api/Command/ProcessRunnerCommand.phpy  gy  `݃y         api/Command/AboutCommand.php  g  pSe      !   api/Command/TaskDeleteCommand.phpa  ga  
W         api/I18n/Translator.php
  g
  q
      %   api/Exception/ApiProblemException.php5  g5  W{       (   api/Exception/ProcessOutputException.php  g  o      &   api/Exception/InvalidTotpException.php  g  ʤ      &   api/Exception/InvalidJsonException.php
  g
  8Y      "   api/Exception/RequestException.php  g  Ű      )   api/IntegrityCheck/AllowUrlFopenCheck.php%  g%  z2Ť      '   api/IntegrityCheck/GraphicsLibCheck.php  g  kp¤         api/IntegrityCheck/ZipCheck.php  g  k"      &   api/IntegrityCheck/SysTempDirCheck.php  g  Ƥ      .   api/IntegrityCheck/IntegrityCheckInterface.php~  g~        #   api/IntegrityCheck/ProcessCheck.php  g  \.sg      #   api/IntegrityCheck/SymlinkCheck.php  g  ;W      #   api/IntegrityCheck/SessionCheck.php  g  ˭K      '   api/IntegrityCheck/MemoryLimitCheck.phpK  gK  ^      )   api/IntegrityCheck/PhpExtensionsCheck.php  g  	:      -   api/IntegrityCheck/AbstractIntegrityCheck.php  g        ,   api/IntegrityCheck/IntegrityCheckFactory.php  g  R,         api/Process/ContaoApi.phpF  gF  B      !   api/Process/ProcessController.php  g  ٧e      %   api/Process/Forker/AbstractForker.php
  g
  ȮH      &   api/Process/Forker/ForkerInterface.phpn  gn  |5oq      #   api/Process/Forker/DisownForker.php  g  w4h      "   api/Process/Forker/NohupForker.php  g  ZA      )   api/Process/Forker/WindowsStartForker.php  g  a\"      #   api/Process/Forker/InlineForker.php  g  Ѷ#         api/Process/Utf8Process.php  g  x         api/Process/ProcessRunner.php  g  |E         api/Process/AbstractProcess.php  g  6?=         api/Process/ContaoConsole.php   g   v)1      #   api/Process/PhpExecutableFinder.php  g  r      %   api/Process/ConsoleProcessFactory.php  g  k         api/console8  g8  i.      $   api/EventListener/LocaleListener.php.  g.        '   api/EventListener/ExceptionListener.php~
  g~
  
      &   api/EventListener/SecurityListener.php  g  O      '   api/EventListener/CheckTotpListener.php  g  5%T      )   api/EventListener/JsonRequestListener.phpM  gM  ä      
   downgrade.php0  g0  8-ˤ      $   vendor/seld/phar-utils/composer.lock/  g/  cւ(         vendor/seld/phar-utils/LICENSE"  g"  ?e          vendor/seld/phar-utils/README.mde  ge  :N      $   vendor/seld/phar-utils/composer.json;  g;  =      %   vendor/seld/phar-utils/src/Linter.php
  g
  #:	      )   vendor/seld/phar-utils/src/Timestamps.phpk  gk  F         vendor/seld/jsonlint/LICENSE"  g"  asy      !   vendor/seld/jsonlint/bin/jsonlint  g   
      !   vendor/seld/jsonlint/CHANGELOG.md	  g	  ݣʤ         vendor/seld/jsonlint/README.md
  g
  f      "   vendor/seld/jsonlint/composer.jsonU  gU  TR      @   vendor/seld/jsonlint/src/Seld/JsonLint/DuplicateKeyException.php  g  ArQ      ;   vendor/seld/jsonlint/src/Seld/JsonLint/ParsingException.php  g  m2;      0   vendor/seld/jsonlint/src/Seld/JsonLint/Lexer.php"  g"  ;      4   vendor/seld/jsonlint/src/Seld/JsonLint/Undefined.php*  g*        5   vendor/seld/jsonlint/src/Seld/JsonLint/JsonParser.php,_  g,_  v      "   vendor/seld/signal-handler/LICENSE"  g"  ?e      (   vendor/seld/signal-handler/composer.json  g  c      0   vendor/seld/signal-handler/src/SignalHandler.phpO  gO  ,C         vendor/autoload.php  g  yDw      $   vendor/phpstan/phpdoc-parser/LICENSEQ  gQ  w      &   vendor/phpstan/phpdoc-parser/README.md  g  0h      )   vendor/phpstan/phpdoc-parser/UPGRADING.md#  g#  &~g      *   vendor/phpstan/phpdoc-parser/composer.json  g  R	      0   vendor/phpstan/phpdoc-parser/src/Lexer/Lexer.php  g  &eo      5   vendor/phpstan/phpdoc-parser/src/Printer/DiffElem.php  g  
      3   vendor/phpstan/phpdoc-parser/src/Printer/Differ.phpj  gj  yT      4   vendor/phpstan/phpdoc-parser/src/Printer/Printer.phpG  gG  |"&v      ;   vendor/phpstan/phpdoc-parser/src/Parser/ParserException.php	  g	  2Ф      8   vendor/phpstan/phpdoc-parser/src/Parser/PhpDocParser.phpޭ  gޭ   a      ;   vendor/phpstan/phpdoc-parser/src/Parser/ConstExprParser.php!  g!  HH      ;   vendor/phpstan/phpdoc-parser/src/Parser/StringUnescaper.php\
  g\
  k'#      6   vendor/phpstan/phpdoc-parser/src/Parser/TypeParser.php_  g_  YeG      9   vendor/phpstan/phpdoc-parser/src/Parser/TokenIterator.php8)  g8)  \j      1   vendor/phpstan/phpdoc-parser/src/ParserConfig.php`  g`  Kä      V   vendor/phpstan/phpdoc-parser/src/Ast/PhpDoc/PureUnlessCallableIsImpureTagValueNode.php  g  ;      A   vendor/phpstan/phpdoc-parser/src/Ast/PhpDoc/MixinTagValueNode.php  g  0      D   vendor/phpstan/phpdoc-parser/src/Ast/PhpDoc/TemplateTagValueNode.php  g        B   vendor/phpstan/phpdoc-parser/src/Ast/PhpDoc/AssertTagValueNode.php:  g:  
f      B   vendor/phpstan/phpdoc-parser/src/Ast/PhpDoc/ThrowsTagValueNode.php  g  }      U   vendor/phpstan/phpdoc-parser/src/Ast/PhpDoc/ParamLaterInvokedCallableTagValueNode.php  g  OS^      B   vendor/phpstan/phpdoc-parser/src/Ast/PhpDoc/PhpDocTagValueNode.php   g   ck      J   vendor/phpstan/phpdoc-parser/src/Ast/PhpDoc/AssertTagPropertyValueNode.php  g  -      M   vendor/phpstan/phpdoc-parser/src/Ast/PhpDoc/RequireImplementsTagValueNode.php  g  Z3      F   vendor/phpstan/phpdoc-parser/src/Ast/PhpDoc/ImplementsTagValueNode.php  g  ^Ĥ      >   vendor/phpstan/phpdoc-parser/src/Ast/PhpDoc/PhpDocTextNode.php  g  h%      :   vendor/phpstan/phpdoc-parser/src/Ast/PhpDoc/PhpDocNode.phpI)  gI)        L   vendor/phpstan/phpdoc-parser/src/Ast/PhpDoc/ParamClosureThisTagValueNode.php-  g-  =H      C   vendor/phpstan/phpdoc-parser/src/Ast/PhpDoc/GenericTagValueNode.php  g  ~T      E   vendor/phpstan/phpdoc-parser/src/Ast/PhpDoc/TypeAliasTagValueNode.phpc  gc        B   vendor/phpstan/phpdoc-parser/src/Ast/PhpDoc/ReturnTagValueNode.php  g  ^T      @   vendor/phpstan/phpdoc-parser/src/Ast/PhpDoc/UsesTagValueNode.php  g  Z!K      K   vendor/phpstan/phpdoc-parser/src/Ast/PhpDoc/MethodTagValueParameterNode.php4  g4  ܤ      I   vendor/phpstan/phpdoc-parser/src/Ast/PhpDoc/Doctrine/DoctrineArgument.php  g  =      K   vendor/phpstan/phpdoc-parser/src/Ast/PhpDoc/Doctrine/DoctrineAnnotation.php  g  ;k      M   vendor/phpstan/phpdoc-parser/src/Ast/PhpDoc/Doctrine/DoctrineTagValueNode.php  g  j$Ѥ      J   vendor/phpstan/phpdoc-parser/src/Ast/PhpDoc/Doctrine/DoctrineArrayItem.php  g  K      F   vendor/phpstan/phpdoc-parser/src/Ast/PhpDoc/Doctrine/DoctrineArray.php  g  (Ҥ      C   vendor/phpstan/phpdoc-parser/src/Ast/PhpDoc/InvalidTagValueNode.php  g  ^ߤ      ?   vendor/phpstan/phpdoc-parser/src/Ast/PhpDoc/VarTagValueNode.phpL  gL  KHx      =   vendor/phpstan/phpdoc-parser/src/Ast/PhpDoc/PhpDocTagNode.php  g  ɿ      D   vendor/phpstan/phpdoc-parser/src/Ast/PhpDoc/ParamOutTagValueNode.php%  g%        I   vendor/phpstan/phpdoc-parser/src/Ast/PhpDoc/TypelessParamTagValueNode.php  g  m#w      H   vendor/phpstan/phpdoc-parser/src/Ast/PhpDoc/AssertTagMethodValueNode.php  g  {֤      K   vendor/phpstan/phpdoc-parser/src/Ast/PhpDoc/TypeAliasImportTagValueNode.php  g  jW      D   vendor/phpstan/phpdoc-parser/src/Ast/PhpDoc/PropertyTagValueNode.php   g   7b!      [   vendor/phpstan/phpdoc-parser/src/Ast/PhpDoc/ParamImmediatelyInvokedCallableTagValueNode.php  g  'D      ?   vendor/phpstan/phpdoc-parser/src/Ast/PhpDoc/PhpDocChildNode.php   g   )5Q      C   vendor/phpstan/phpdoc-parser/src/Ast/PhpDoc/ExtendsTagValueNode.php  g  ݤ      A   vendor/phpstan/phpdoc-parser/src/Ast/PhpDoc/ParamTagValueNode.phpU  gU  ~,      B   vendor/phpstan/phpdoc-parser/src/Ast/PhpDoc/MethodTagValueNode.php  g  7Ǥ      C   vendor/phpstan/phpdoc-parser/src/Ast/PhpDoc/SelfOutTagValueNode.php  g  L~      F   vendor/phpstan/phpdoc-parser/src/Ast/PhpDoc/DeprecatedTagValueNode.php  g  K]C      J   vendor/phpstan/phpdoc-parser/src/Ast/PhpDoc/RequireExtendsTagValueNode.php  g  >      A   vendor/phpstan/phpdoc-parser/src/Ast/ConstExpr/ConstFetchNode.php  g  "iT      E   vendor/phpstan/phpdoc-parser/src/Ast/ConstExpr/ConstExprArrayNode.phpF  gF  Y7      @   vendor/phpstan/phpdoc-parser/src/Ast/ConstExpr/ConstExprNode.php   g         F   vendor/phpstan/phpdoc-parser/src/Ast/ConstExpr/ConstExprStringNode.php  g  &m      D   vendor/phpstan/phpdoc-parser/src/Ast/ConstExpr/ConstExprTrueNode.php5  g5  #6      G   vendor/phpstan/phpdoc-parser/src/Ast/ConstExpr/ConstExprIntegerNode.php  g  80      E   vendor/phpstan/phpdoc-parser/src/Ast/ConstExpr/ConstExprFalseNode.php7  g7  c󷯤      I   vendor/phpstan/phpdoc-parser/src/Ast/ConstExpr/ConstExprArrayItemNode.php  g  ۋ      D   vendor/phpstan/phpdoc-parser/src/Ast/ConstExpr/ConstExprNullNode.php5  g5  "      N   vendor/phpstan/phpdoc-parser/src/Ast/ConstExpr/DoctrineConstExprStringNode.phpt  gt  <      E   vendor/phpstan/phpdoc-parser/src/Ast/ConstExpr/ConstExprFloatNode.php  g  Gʤ      4   vendor/phpstan/phpdoc-parser/src/Ast/NodeVisitor.php
  g
  һc      C   vendor/phpstan/phpdoc-parser/src/Ast/NodeVisitor/CloningVisitor.php  g        2   vendor/phpstan/phpdoc-parser/src/Ast/Attribute.phpp  gp  B      -   vendor/phpstan/phpdoc-parser/src/Ast/Node.php  g  I       ;   vendor/phpstan/phpdoc-parser/src/Ast/Type/UnionTypeNode.php  g  '¤      B   vendor/phpstan/phpdoc-parser/src/Ast/Type/IntersectionTypeNode.php
  g
  m      @   vendor/phpstan/phpdoc-parser/src/Ast/Type/IdentifierTypeNode.php  g  z21      @   vendor/phpstan/phpdoc-parser/src/Ast/Type/ArrayShapeItemNode.php  g  o=      ;   vendor/phpstan/phpdoc-parser/src/Ast/Type/ConstTypeNode.php  g  V0	      G   vendor/phpstan/phpdoc-parser/src/Ast/Type/CallableTypeParameterNode.php  g        >   vendor/phpstan/phpdoc-parser/src/Ast/Type/CallableTypeNode.phpz  gz  z"      6   vendor/phpstan/phpdoc-parser/src/Ast/Type/TypeNode.php   g   9      A   vendor/phpstan/phpdoc-parser/src/Ast/Type/ObjectShapeItemNode.php  g  [Z      :   vendor/phpstan/phpdoc-parser/src/Ast/Type/ThisTypeNode.php'  g'  |      =   vendor/phpstan/phpdoc-parser/src/Ast/Type/ObjectShapeNode.phpR  gR  7Nf      =   vendor/phpstan/phpdoc-parser/src/Ast/Type/InvalidTypeNode.phpg  gg  L      B   vendor/phpstan/phpdoc-parser/src/Ast/Type/OffsetAccessTypeNode.php  g  4      A   vendor/phpstan/phpdoc-parser/src/Ast/Type/ConditionalTypeNode.php  g  Rפ      H   vendor/phpstan/phpdoc-parser/src/Ast/Type/ArrayShapeUnsealedTypeNode.php  g  t       M   vendor/phpstan/phpdoc-parser/src/Ast/Type/ConditionalTypeForParameterNode.php  g  +$      >   vendor/phpstan/phpdoc-parser/src/Ast/Type/NullableTypeNode.php  g  qo      <   vendor/phpstan/phpdoc-parser/src/Ast/Type/ArrayShapeNode.php  g  \鿤      =   vendor/phpstan/phpdoc-parser/src/Ast/Type/GenericTypeNode.php.  g.  3      ;   vendor/phpstan/phpdoc-parser/src/Ast/Type/ArrayTypeNode.phpi  gi  <p      <   vendor/phpstan/phpdoc-parser/src/Ast/AbstractNodeVisitor.php  g  }$      0   vendor/phpstan/phpdoc-parser/src/Ast/Comment.php  g  c軤      7   vendor/phpstan/phpdoc-parser/src/Ast/NodeAttributes.php+  g+        6   vendor/phpstan/phpdoc-parser/src/Ast/NodeTraverser.php*  g*           vendor/lcobucci/clock/LICENSE.  g.  >z      #   vendor/lcobucci/clock/renovate.json   g   ]G(      #   vendor/lcobucci/clock/composer.json,  g,  ;      #   vendor/lcobucci/clock/src/Clock.php   g   *	      )   vendor/lcobucci/clock/src/FrozenClock.php*  g*  8o      )   vendor/lcobucci/clock/src/SystemClock.php  g            vendor/bin/yaml-lint
  g
  8<h      "   vendor/bin/patch-type-declarations`
  g`
  +դ         vendor/bin/validate-json0
  g0
  ̤         vendor/bin/composer	
  g	
  k?ۤ         vendor/bin/var-dump-server?
  g?
  &j         vendor/bin/jsonlint  g  X      $   vendor/web-auth/webauthn-lib/LICENSE1  g1  2      *   vendor/web-auth/webauthn-lib/composer.json	  g	  =K      <   vendor/web-auth/webauthn-lib/src/FakeCredentialGenerator.php1  g1  cF,Ȥ      1   vendor/web-auth/webauthn-lib/src/StringStream.php'  g'  K1ۤ      @   vendor/web-auth/webauthn-lib/src/CeremonyStep/CheckAlgorithm.php$  g$  $      D   vendor/web-auth/webauthn-lib/src/CeremonyStep/TopOriginValidator.php   g   Q      A   vendor/web-auth/webauthn-lib/src/CeremonyStep/CheckUserHandle.php  g         P   vendor/web-auth/webauthn-lib/src/CeremonyStep/CheckHasAttestedCredentialData.phpC  gC  $Q      E   vendor/web-auth/webauthn-lib/src/CeremonyStep/CeremonyStepManager.php  g  \TP      G   vendor/web-auth/webauthn-lib/src/CeremonyStep/CheckUserVerification.php3  g3  PX,      L   vendor/web-auth/webauthn-lib/src/CeremonyStep/CheckAllowedCredentialList.php  g        C   vendor/web-auth/webauthn-lib/src/CeremonyStep/CheckCredentialId.php  g  \	      W   vendor/web-auth/webauthn-lib/src/CeremonyStep/CheckAttestationFormatIsKnownAndValid.phpH  gH  $@s      @   vendor/web-auth/webauthn-lib/src/CeremonyStep/CheckSignature.php  g  !Ǥ      H   vendor/web-auth/webauthn-lib/src/CeremonyStep/HostTopOriginValidator.php
  g
  #o      K   vendor/web-auth/webauthn-lib/src/CeremonyStep/CheckRelyingPartyIdIdHash.php
  g
  Oû      N   vendor/web-auth/webauthn-lib/src/CeremonyStep/CheckBackupBitsAreConsistent.php  g  a      E   vendor/web-auth/webauthn-lib/src/CeremonyStep/CheckUserWasPresent.php  g  w      N   vendor/web-auth/webauthn-lib/src/CeremonyStep/CheckClientDataCollectorType.php  g  =&      @   vendor/web-auth/webauthn-lib/src/CeremonyStep/CheckChallenge.php  g  g      >   vendor/web-auth/webauthn-lib/src/CeremonyStep/CeremonyStep.php  g  ujv      >   vendor/web-auth/webauthn-lib/src/CeremonyStep/CheckCounter.php  g  ʤ      @   vendor/web-auth/webauthn-lib/src/CeremonyStep/CheckTopOrigin.php  g  "      =   vendor/web-auth/webauthn-lib/src/CeremonyStep/CheckOrigin.php  g  Ť      A   vendor/web-auth/webauthn-lib/src/CeremonyStep/CheckExtensions.phpt  gt  =      H   vendor/web-auth/webauthn-lib/src/CeremonyStep/CheckMetadataStatement.php	   g	   `      L   vendor/web-auth/webauthn-lib/src/CeremonyStep/CeremonyStepManagerFactory.php  g  ^fr      B   vendor/web-auth/webauthn-lib/src/PublicKeyCredentialUserEntity.php  g  yP      7   vendor/web-auth/webauthn-lib/src/CertificateToolbox.php  g  µ      V   vendor/web-auth/webauthn-lib/src/AuthenticationExtensions/AuthenticationExtensions.php  g  ;k      [   vendor/web-auth/webauthn-lib/src/AuthenticationExtensions/ExtensionOutputCheckerHandler.php}  g}  %}h      b   vendor/web-auth/webauthn-lib/src/AuthenticationExtensions/AuthenticationExtensionsClientInputs.php  g  `i      R   vendor/web-auth/webauthn-lib/src/AuthenticationExtensions/ExtensionOutputError.php  g  H'      U   vendor/web-auth/webauthn-lib/src/AuthenticationExtensions/AuthenticationExtension.php  g  R      T   vendor/web-auth/webauthn-lib/src/AuthenticationExtensions/ExtensionOutputChecker.php   g   DA      c   vendor/web-auth/webauthn-lib/src/AuthenticationExtensions/AuthenticationExtensionsClientOutputs.php  g  
QT      i   vendor/web-auth/webauthn-lib/src/AuthenticationExtensions/AuthenticationExtensionsClientOutputsLoader.php  g  D+      e   vendor/web-auth/webauthn-lib/src/AttestationStatement/AndroidSafetyNetAttestationStatementSupport.php66  g66  v      \   vendor/web-auth/webauthn-lib/src/AttestationStatement/FidoU2FAttestationStatementSupport.phpZ  gZ  T      Z   vendor/web-auth/webauthn-lib/src/AttestationStatement/AppleAttestationStatementSupport.phpR  gR  9      Y   vendor/web-auth/webauthn-lib/src/AttestationStatement/NoneAttestationStatementSupport.phpz  gz  |       U   vendor/web-auth/webauthn-lib/src/AttestationStatement/AttestationStatementSupport.php  g  0Hä      Q   vendor/web-auth/webauthn-lib/src/AttestationStatement/AttestationObjectLoader.php  g  a      [   vendor/web-auth/webauthn-lib/src/AttestationStatement/PackedAttestationStatementSupport.php+  g+  ɯ      K   vendor/web-auth/webauthn-lib/src/AttestationStatement/AttestationObject.php  g  _f      _   vendor/web-auth/webauthn-lib/src/AttestationStatement/AndroidKeyAttestationStatementSupport.phpM"  gM"  O~O      \   vendor/web-auth/webauthn-lib/src/AttestationStatement/AttestationStatementSupportManager.php  g  o      X   vendor/web-auth/webauthn-lib/src/AttestationStatement/TPMAttestationStatementSupport.php=  g=  $3Y      N   vendor/web-auth/webauthn-lib/src/AttestationStatement/AttestationStatement.php  g  *      >   vendor/web-auth/webauthn-lib/src/PublicKeyCredentialLoader.php  g  x&      B   vendor/web-auth/webauthn-lib/src/SimpleFakeCredentialGenerator.php  g  Aݤ      >   vendor/web-auth/webauthn-lib/src/TokenBinding/TokenBinding.php  g  jhդ      H   vendor/web-auth/webauthn-lib/src/TokenBinding/SecTokenBindingHandler.php  g        K   vendor/web-auth/webauthn-lib/src/TokenBinding/IgnoreTokenBindingHandler.php  g  ɗCڤ      Q   vendor/web-auth/webauthn-lib/src/TokenBinding/TokenBindingNotSupportedHandler.php  g  W      E   vendor/web-auth/webauthn-lib/src/TokenBinding/TokenBindingHandler.phph  gh        <   vendor/web-auth/webauthn-lib/src/Util/CoseSignatureFixer.php`  g`  _nW      0   vendor/web-auth/webauthn-lib/src/Util/Base64.phps  gs  ݤ      ;   vendor/web-auth/webauthn-lib/src/AttestedCredentialData.php
  g
  sr      /   vendor/web-auth/webauthn-lib/src/Credential.php  g  h      N   vendor/web-auth/webauthn-lib/src/AuthenticatorAttestationResponseValidator.phpd2  gd2  s      B   vendor/web-auth/webauthn-lib/src/PublicKeyCredentialParameters.php	  g	  #8r      B   vendor/web-auth/webauthn-lib/src/PublicKeyCredentialDescriptor.php 
  g 
  9\o      @   vendor/web-auth/webauthn-lib/src/PublicKeyCredentialRpEntity.phpX  gX  {B      E   vendor/web-auth/webauthn-lib/src/AuthenticatorAttestationResponse.php  g  J      ?   vendor/web-auth/webauthn-lib/src/PublicKeyCredentialOptions.php  g  ^9      6   vendor/web-auth/webauthn-lib/src/AuthenticatorData.phpo
  go
  Wo      L   vendor/web-auth/webauthn-lib/src/PublicKeyCredentialDescriptorCollection.php  g  
?Ҥ      :   vendor/web-auth/webauthn-lib/src/AuthenticatorResponse.php  g  J      L   vendor/web-auth/webauthn-lib/src/AuthenticatorAssertionResponseValidator.php0  g0  Dߤ      C   vendor/web-auth/webauthn-lib/src/AuthenticatorAssertionResponse.php=  g=  Ȫ       W   vendor/web-auth/webauthn-lib/src/CertificateChainChecker/PhpCertificateChainChecker.php  g  {Ϥ      T   vendor/web-auth/webauthn-lib/src/CertificateChainChecker/CertificateChainChecker.php  g  2Ƥ      F   vendor/web-auth/webauthn-lib/src/PublicKeyCredentialRequestOptions.php.  g.  Dg      <   vendor/web-auth/webauthn-lib/src/AuthenticatorDataLoader.php  g  Lڤ      H   vendor/web-auth/webauthn-lib/src/PublicKeyCredentialSourceRepository.php   g   z      >   vendor/web-auth/webauthn-lib/src/TrustPath/TrustPathLoader.php  g  @b      B   vendor/web-auth/webauthn-lib/src/TrustPath/EcdaaKeyIdTrustPath.php  g  ,q      8   vendor/web-auth/webauthn-lib/src/TrustPath/TrustPath.php  g  "ߣ      =   vendor/web-auth/webauthn-lib/src/TrustPath/EmptyTrustPath.php  g  b_      C   vendor/web-auth/webauthn-lib/src/TrustPath/CertificateTrustPath.php  g  A#      >   vendor/web-auth/webauthn-lib/src/PublicKeyCredentialEntity.php  g         L   vendor/web-auth/webauthn-lib/src/ClientDataCollector/ClientDataCollector.phpA  gA  У      S   vendor/web-auth/webauthn-lib/src/ClientDataCollector/ClientDataCollectorManager.php  g  [6      X   vendor/web-auth/webauthn-lib/src/ClientDataCollector/WebauthnAuthenticationCollector.php  g  =m      D   vendor/web-auth/webauthn-lib/src/Counter/ThrowExceptionIfInvalid.phpw  gw  <Sڤ      ;   vendor/web-auth/webauthn-lib/src/Counter/CounterChecker.php  g        V   vendor/web-auth/webauthn-lib/src/Denormalizer/AuthenticationExtensionsDenormalizer.php	  g	  Jo0Ӥ      R   vendor/web-auth/webauthn-lib/src/Denormalizer/AttestationStatementDenormalizer.php  g        S   vendor/web-auth/webauthn-lib/src/Denormalizer/AuthenticationExtensionNormalizer.php  g  9A      G   vendor/web-auth/webauthn-lib/src/Denormalizer/TrustPathDenormalizer.php  g        Q   vendor/web-auth/webauthn-lib/src/Denormalizer/PublicKeyCredentialDenormalizer.php  g  ژؤ      K   vendor/web-auth/webauthn-lib/src/Denormalizer/WebauthnSerializerFactory.phpF
  gF
  y      Q   vendor/web-auth/webauthn-lib/src/Denormalizer/CollectedClientDataDenormalizer.php  g  ߺ䥤      [   vendor/web-auth/webauthn-lib/src/Denormalizer/PublicKeyCredentialParametersDenormalizer.php  g  1      ^   vendor/web-auth/webauthn-lib/src/Denormalizer/AuthenticatorAttestationResponseDenormalizer.php:  g:  .֤      R   vendor/web-auth/webauthn-lib/src/Denormalizer/AttestedCredentialDataNormalizer.phpj  gj  !wJ      Y   vendor/web-auth/webauthn-lib/src/Denormalizer/PublicKeyCredentialDescriptorNormalizer.phpy  gy  薆      O   vendor/web-auth/webauthn-lib/src/Denormalizer/AuthenticatorDataDenormalizer.php  g  IV      O   vendor/web-auth/webauthn-lib/src/Denormalizer/AttestationObjectDenormalizer.php|  g|  =G      W   vendor/web-auth/webauthn-lib/src/Denormalizer/PublicKeyCredentialSourceDenormalizer.php  g  h2eԤ      [   vendor/web-auth/webauthn-lib/src/Denormalizer/PublicKeyCredentialUserEntityDenormalizer.php  g  Wݤ      Q   vendor/web-auth/webauthn-lib/src/Denormalizer/ExtensionDescriptorDenormalizer.php(  g(  PwФ      _   vendor/web-auth/webauthn-lib/src/Denormalizer/VerificationMethodANDCombinationsDenormalizer.php  g  Eڵ      \   vendor/web-auth/webauthn-lib/src/Denormalizer/AuthenticatorAssertionResponseDenormalizer.php  g  s2P      S   vendor/web-auth/webauthn-lib/src/Denormalizer/AuthenticatorResponseDenormalizer.php  g  Wi      X   vendor/web-auth/webauthn-lib/src/Denormalizer/PublicKeyCredentialOptionsDenormalizer.php  g  w~      8   vendor/web-auth/webauthn-lib/src/PublicKeyCredential.php  g        D   vendor/web-auth/webauthn-lib/src/MetadataService/Psr18HttpClient.phpf  gf  	\      K   vendor/web-auth/webauthn-lib/src/MetadataService/StatusReportRepository.php3  g3  |`4&      _   vendor/web-auth/webauthn-lib/src/MetadataService/CertificateChain/CertificateChainValidator.phpT  gT  Ѓv      X   vendor/web-auth/webauthn-lib/src/MetadataService/CertificateChain/CertificateToolbox.php  g  W֮y      b   vendor/web-auth/webauthn-lib/src/MetadataService/CertificateChain/PhpCertificateChainValidator.php'  g'  K%C      ?   vendor/web-auth/webauthn-lib/src/MetadataService/CanLogData.php   g   .j       P   vendor/web-auth/webauthn-lib/src/MetadataService/MetadataStatementRepository.php  g  8T      R   vendor/web-auth/webauthn-lib/src/MetadataService/Statement/ExtensionDescriptor.php  g  I      U   vendor/web-auth/webauthn-lib/src/MetadataService/Statement/CodeAccuracyDescriptor.php	  g	  P2      X   vendor/web-auth/webauthn-lib/src/MetadataService/Statement/PatternAccuracyDescriptor.php	  g	  7\      P   vendor/web-auth/webauthn-lib/src/MetadataService/Statement/MetadataStatement.phpQ  gQ  02      S   vendor/web-auth/webauthn-lib/src/MetadataService/Statement/AuthenticatorGetInfo.php  g  ;T      `   vendor/web-auth/webauthn-lib/src/MetadataService/Statement/VerificationMethodANDCombinations.php  g  J      T   vendor/web-auth/webauthn-lib/src/MetadataService/Statement/BiometricStatusReport.php  g  t%{      R   vendor/web-auth/webauthn-lib/src/MetadataService/Statement/AuthenticatorStatus.php  g  IJ>      Q   vendor/web-auth/webauthn-lib/src/MetadataService/Statement/AbstractDescriptor.phpC  gC  e0@      O   vendor/web-auth/webauthn-lib/src/MetadataService/Statement/EcdaaTrustAnchor.php0
  g0
  Ҩ      K   vendor/web-auth/webauthn-lib/src/MetadataService/Statement/StatusReport.php7  g7  P	      [   vendor/web-auth/webauthn-lib/src/MetadataService/Statement/VerificationMethodDescriptor.php!  g!   +9      V   vendor/web-auth/webauthn-lib/src/MetadataService/Statement/AlternativeDescriptions.php+  g+  c      Z   vendor/web-auth/webauthn-lib/src/MetadataService/Statement/BiometricAccuracyDescriptor.php	  g	  nX}}      F   vendor/web-auth/webauthn-lib/src/MetadataService/Statement/Version.phpV	  gV	        N   vendor/web-auth/webauthn-lib/src/MetadataService/Statement/RgbPaletteEntry.php\	  g\	  Pnu      M   vendor/web-auth/webauthn-lib/src/MetadataService/Statement/RogueListEntry.php  g  x"#      b   vendor/web-auth/webauthn-lib/src/MetadataService/Statement/DisplayPNGCharacteristicsDescriptor.php  g  ꠼      @   vendor/web-auth/webauthn-lib/src/MetadataService/ValueFilter.phpo  go  jPOϤ      a   vendor/web-auth/webauthn-lib/src/MetadataService/Denormalizer/ExtensionDescriptorDenormalizer.php  g  Ћz      d   vendor/web-auth/webauthn-lib/src/MetadataService/Denormalizer/MetadataStatementSerializerFactory.php  g  yx      a   vendor/web-auth/webauthn-lib/src/MetadataService/Service/FidoAllianceCompliantMetadataService.php'  g'  +X5դ      P   vendor/web-auth/webauthn-lib/src/MetadataService/Service/JsonMetadataService.php	  g	  K      R   vendor/web-auth/webauthn-lib/src/MetadataService/Service/StringMetadataService.php  g  :)Ĥ      U   vendor/web-auth/webauthn-lib/src/MetadataService/Service/MetadataBLOBPayloadEntry.php  g  7      [   vendor/web-auth/webauthn-lib/src/MetadataService/Service/DistantResourceMetadataService.php  g  fB      P   vendor/web-auth/webauthn-lib/src/MetadataService/Service/MetadataBLOBPayload.php  g  4n      L   vendor/web-auth/webauthn-lib/src/MetadataService/Service/MetadataService.php  g        Y   vendor/web-auth/webauthn-lib/src/MetadataService/Service/LocalResourceMetadataService.php

  g

  i      T   vendor/web-auth/webauthn-lib/src/MetadataService/Service/ChainedMetadataServices.php  g        Z   vendor/web-auth/webauthn-lib/src/MetadataService/Service/FolderResourceMetadataService.php
  g
  -NZ      T   vendor/web-auth/webauthn-lib/src/MetadataService/Service/InMemoryMetadataService.phpA  gA  T      Z   vendor/web-auth/webauthn-lib/src/MetadataService/Exception/InvalidCertificateException.php  g  z]      W   vendor/web-auth/webauthn-lib/src/MetadataService/Exception/MetadataServiceException.php  g  Y1ص      Z   vendor/web-auth/webauthn-lib/src/MetadataService/Exception/ExpiredCertificateException.php  g  g/      S   vendor/web-auth/webauthn-lib/src/MetadataService/Exception/CertificateException.phpq  gq  h      `   vendor/web-auth/webauthn-lib/src/MetadataService/Exception/MissingMetadataStatementException.php  g  m %      Z   vendor/web-auth/webauthn-lib/src/MetadataService/Exception/RevokedCertificateException.php  g  /      `   vendor/web-auth/webauthn-lib/src/MetadataService/Exception/MetadataStatementLoadingException.php  g  /V      Y   vendor/web-auth/webauthn-lib/src/MetadataService/Exception/MetadataStatementException.php  g  c       X   vendor/web-auth/webauthn-lib/src/MetadataService/Exception/CertificateChainException.php  g  ]ཤ      a   vendor/web-auth/webauthn-lib/src/MetadataService/Exception/CertificateRevocationListException.php  g  [      L   vendor/web-auth/webauthn-lib/src/MetadataService/Event/CanDispatchEvents.phpU  gU  x      H   vendor/web-auth/webauthn-lib/src/MetadataService/Event/WebauthnEvent.phpA  gA  o      [   vendor/web-auth/webauthn-lib/src/MetadataService/Event/BeforeCertificateChainValidation.php  g  <s
      [   vendor/web-auth/webauthn-lib/src/MetadataService/Event/CertificateChainValidationFailed.php  g  @2      ^   vendor/web-auth/webauthn-lib/src/MetadataService/Event/CertificateChainValidationSucceeded.php  g  
$      Q   vendor/web-auth/webauthn-lib/src/MetadataService/Event/MetadataStatementFound.phpp  gp  3	      N   vendor/web-auth/webauthn-lib/src/MetadataService/Event/NullEventDispatcher.phpa  ga  D
      C   vendor/web-auth/webauthn-lib/src/AuthenticatorSelectionCriteria.phpH   gH   EѤ      X   vendor/web-auth/webauthn-lib/src/Exception/AttestationStatementVerificationException.phpn  gn  66      J   vendor/web-auth/webauthn-lib/src/Exception/InvalidCertificateException.php  g  ,s      S   vendor/web-auth/webauthn-lib/src/Exception/InvalidAttestationStatementException.php  g        G   vendor/web-auth/webauthn-lib/src/Exception/MetadataServiceException.php1  g1  \	      O   vendor/web-auth/webauthn-lib/src/Exception/AuthenticationExtensionException.php:  g:  CVs      @   vendor/web-auth/webauthn-lib/src/Exception/WebauthnException.php*  g*  m2      H   vendor/web-auth/webauthn-lib/src/Exception/InvalidTrustPathException.php3  g3  ".      Y   vendor/web-auth/webauthn-lib/src/Exception/AuthenticatorResponseVerificationException.php>  g>  
      J   vendor/web-auth/webauthn-lib/src/Exception/ExpiredCertificateException.php  g  p      J   vendor/web-auth/webauthn-lib/src/Exception/UnsupportedFeatureException.php5  g5  G      C   vendor/web-auth/webauthn-lib/src/Exception/CertificateException.phpO  gO  Zl      P   vendor/web-auth/webauthn-lib/src/Exception/MissingMetadataStatementException.php;  g;  )<Ԥ      J   vendor/web-auth/webauthn-lib/src/Exception/RevokedCertificateException.php   g   cO      L   vendor/web-auth/webauthn-lib/src/Exception/AttestationStatementException.php   g   n      P   vendor/web-auth/webauthn-lib/src/Exception/MetadataStatementLoadingException.phpz  gz  $BC      ?   vendor/web-auth/webauthn-lib/src/Exception/CounterException.phpL  gL        I   vendor/web-auth/webauthn-lib/src/Exception/MetadataStatementException.php   g   ng      H   vendor/web-auth/webauthn-lib/src/Exception/CertificateChainException.php  g  [4ۤ      S   vendor/web-auth/webauthn-lib/src/Exception/AttestationStatementLoadingException.php  g        C   vendor/web-auth/webauthn-lib/src/Exception/InvalidDataException.php  g  ޘ+      Q   vendor/web-auth/webauthn-lib/src/Exception/CertificateRevocationListException.php  g  q9      I   vendor/web-auth/webauthn-lib/src/Exception/InvalidUserHandleException.phpe  ge  |      1   vendor/web-auth/webauthn-lib/src/U2FPublicKey.php  g  T      <   vendor/web-auth/webauthn-lib/src/Event/CanDispatchEvents.php  g  ':      c   vendor/web-auth/webauthn-lib/src/Event/AuthenticatorAttestationResponseValidationSucceededEvent.php7  g7  \Z      8   vendor/web-auth/webauthn-lib/src/Event/WebauthnEvent.phpg   gg   >G      B   vendor/web-auth/webauthn-lib/src/Event/AttestationObjectLoaded.php  g  ob      a   vendor/web-auth/webauthn-lib/src/Event/AuthenticatorAssertionResponseValidationSucceededEvent.php  g         ^   vendor/web-auth/webauthn-lib/src/Event/AuthenticatorAssertionResponseValidationFailedEvent.php  g  o~֤      K   vendor/web-auth/webauthn-lib/src/Event/BeforeCertificateChainValidation.phpX  gX  /      K   vendor/web-auth/webauthn-lib/src/Event/CertificateChainValidationFailed.phpX  gX  p      N   vendor/web-auth/webauthn-lib/src/Event/CertificateChainValidationSucceeded.php[  g[  (ɤ      A   vendor/web-auth/webauthn-lib/src/Event/MetadataStatementFound.php  g  
      >   vendor/web-auth/webauthn-lib/src/Event/NullEventDispatcher.php8  g8  }o      `   vendor/web-auth/webauthn-lib/src/Event/AuthenticatorAttestationResponseValidationFailedEvent.php  g  <?      E   vendor/web-auth/webauthn-lib/src/Event/AttestationStatementLoaded.php  g  |7      >   vendor/web-auth/webauthn-lib/src/PublicKeyCredentialSource.php"  g"  Ik      G   vendor/web-auth/webauthn-lib/src/PublicKeyCredentialCreationOptions.phpo)  go)  í      8   vendor/web-auth/webauthn-lib/src/CollectedClientData.phpr  gr  +Ĥ          vendor/web-auth/cose-lib/LICENSE,  g,  C      "   vendor/web-auth/cose-lib/README.md  g  Ŭ      &   vendor/web-auth/cose-lib/composer.json  g  B:+j      $   vendor/web-auth/cose-lib/SECURITY.md  g  Y{      %   vendor/web-auth/cose-lib/src/Hash.php  g  8pȤ      (   vendor/web-auth/cose-lib/src/Key/Key.php	  g	  o      +   vendor/web-auth/cose-lib/src/Key/RsaKey.php
  g
  ZΤ      1   vendor/web-auth/cose-lib/src/Key/SymmetricKey.php  g  f      +   vendor/web-auth/cose-lib/src/Key/Ec2Key.php  g  ʤ      +   vendor/web-auth/cose-lib/src/Key/OkpKey.php
  g
  ?      9   vendor/web-auth/cose-lib/src/Algorithm/ManagerFactory.php  g  E      @   vendor/web-auth/cose-lib/src/Algorithm/Signature/ECDSA/ES256.php  g  U0      @   vendor/web-auth/cose-lib/src/Algorithm/Signature/ECDSA/ECDSA.php  g  Af      @   vendor/web-auth/cose-lib/src/Algorithm/Signature/ECDSA/ES384.php  g  "8      F   vendor/web-auth/cose-lib/src/Algorithm/Signature/ECDSA/ECSignature.php  g  3y      A   vendor/web-auth/cose-lib/src/Algorithm/Signature/ECDSA/ES256K.php  g  8      @   vendor/web-auth/cose-lib/src/Algorithm/Signature/ECDSA/ES512.php  g  ˤ      <   vendor/web-auth/cose-lib/src/Algorithm/Signature/RSA/RS1.php  g  ]2      <   vendor/web-auth/cose-lib/src/Algorithm/Signature/RSA/RSA.php  g  #2      >   vendor/web-auth/cose-lib/src/Algorithm/Signature/RSA/RS384.php  g  
f¤      >   vendor/web-auth/cose-lib/src/Algorithm/Signature/RSA/PS256.php  g  掤      >   vendor/web-auth/cose-lib/src/Algorithm/Signature/RSA/PS384.php  g  {      >   vendor/web-auth/cose-lib/src/Algorithm/Signature/RSA/RS256.php  g        >   vendor/web-auth/cose-lib/src/Algorithm/Signature/RSA/RS512.php  g  *(z      ?   vendor/web-auth/cose-lib/src/Algorithm/Signature/RSA/PSSRSA.php\  g\  i"      >   vendor/web-auth/cose-lib/src/Algorithm/Signature/RSA/PS512.php  g  kJ      @   vendor/web-auth/cose-lib/src/Algorithm/Signature/EdDSA/Ed512.php  g  ƩK      @   vendor/web-auth/cose-lib/src/Algorithm/Signature/EdDSA/EdDSA.php  g  ~e0      @   vendor/web-auth/cose-lib/src/Algorithm/Signature/EdDSA/Ed256.php  g  Xy      B   vendor/web-auth/cose-lib/src/Algorithm/Signature/EdDSA/Ed25519.php@  g@  	      >   vendor/web-auth/cose-lib/src/Algorithm/Signature/Signature.phpV  gV  ;      4   vendor/web-auth/cose-lib/src/Algorithm/Algorithm.php   g   =
h      4   vendor/web-auth/cose-lib/src/Algorithm/Mac/HS512.php  g  4X e      3   vendor/web-auth/cose-lib/src/Algorithm/Mac/Hmac.php  g  Jd      2   vendor/web-auth/cose-lib/src/Algorithm/Mac/Mac.phpJ  gJ  l'      4   vendor/web-auth/cose-lib/src/Algorithm/Mac/HS384.php  g  5YF      ?   vendor/web-auth/cose-lib/src/Algorithm/Mac/HS256Truncated64.php  g  y      4   vendor/web-auth/cose-lib/src/Algorithm/Mac/HS256.php  g        2   vendor/web-auth/cose-lib/src/Algorithm/Manager.php  g  ,      +   vendor/web-auth/cose-lib/src/BigInteger.php  g  Yy      +   vendor/web-auth/cose-lib/src/Algorithms.phpX  gX  S@      '   vendor/composer/autoload_namespaces.php   g   /t      &   vendor/composer/xdebug-handler/LICENSE)  g)  #;^      +   vendor/composer/xdebug-handler/CHANGELOG.md  g  !YsK      (   vendor/composer/xdebug-handler/README.md4  g4  S%      ,   vendor/composer/xdebug-handler/composer.jsony  gy  -      0   vendor/composer/xdebug-handler/src/PhpConfig.php  g  ]      -   vendor/composer/xdebug-handler/src/Status.phpz  gz  "      4   vendor/composer/xdebug-handler/src/XdebugHandler.phpKV  gKV  Eb      .   vendor/composer/xdebug-handler/src/Process.phpH  gH  G      +   vendor/composer/class-map-generator/LICENSE  g  DӤ      -   vendor/composer/class-map-generator/README.mdN  gN  K(      1   vendor/composer/class-map-generator/composer.json  g  |(~      =   vendor/composer/class-map-generator/src/ClassMapGenerator.phpk6  gk6  2Bgn      :   vendor/composer/class-map-generator/src/PhpFileCleaner.php?  g?  s      4   vendor/composer/class-map-generator/src/FileList.phpc  gc  r5      9   vendor/composer/class-map-generator/src/PhpFileParser.php  g  8C      4   vendor/composer/class-map-generator/src/ClassMap.php  g           vendor/composer/LICENSE.  g.            vendor/composer/ClassLoader.php?  g?  2@u      +   vendor/composer/composer/phpstan/rules.neon  g  ~d      1   vendor/composer/composer/res/composer-schema.json  g  -Zy       6   vendor/composer/composer/res/composer-lock-schema.json
  g
  rf      <   vendor/composer/composer/res/composer-repository-schema.json   g   븂      &   vendor/composer/composer/composer.lockK gK R          vendor/composer/composer/LICENSE,  g,  Vg      %   vendor/composer/composer/bin/composer  g  -0~      $   vendor/composer/composer/bin/compile  g  \0      &   vendor/composer/composer/composer.json  g  Sv'      S   vendor/composer/composer/src/Composer/PHPStan/RuleReasonDataReturnTypeExtension.php
  g
  
      K   vendor/composer/composer/src/Composer/PHPStan/ConfigReturnTypeExtension.phpL"  gL"  W      1   vendor/composer/composer/src/Composer/Factory.php  g  z0      H   vendor/composer/composer/src/Composer/Repository/RepositoryInterface.php  g  й      R   vendor/composer/composer/src/Composer/Repository/InstalledFilesystemRepository.php  g  J=      F   vendor/composer/composer/src/Composer/Repository/PackageRepository.phpl  gl  +Z%      H   vendor/composer/composer/src/Composer/Repository/LockArrayRepository.php  g  Ȥ      G   vendor/composer/composer/src/Composer/Repository/PlatformRepository.php  g  ,+      F   vendor/composer/composer/src/Composer/Repository/RepositoryFactory.php$   g$   8l      Q   vendor/composer/composer/src/Composer/Repository/InstalledRepositoryInterface.php  g  +      P   vendor/composer/composer/src/Composer/Repository/WritableRepositoryInterface.php@  g@  ek      D   vendor/composer/composer/src/Composer/Repository/RepositoryUtils.php
  g
        P   vendor/composer/composer/src/Composer/Repository/RepositorySecurityException.php  g  l	Ф      H   vendor/composer/composer/src/Composer/Repository/CompositeRepository.php  g  $	)      D   vendor/composer/composer/src/Composer/Repository/ArrayRepository.phpw(  gw(  x)      L   vendor/composer/composer/src/Composer/Repository/WritableArrayRepository.php	  g	  X      B   vendor/composer/composer/src/Composer/Repository/VcsRepository.phpR  gR  Bq      G   vendor/composer/composer/src/Composer/Repository/ComposerRepository.php1 g1 h)      C   vendor/composer/composer/src/Composer/Repository/PearRepository.php`  g`        B   vendor/composer/composer/src/Composer/Repository/RepositorySet.phpA  gA  _O      G   vendor/composer/composer/src/Composer/Repository/ArtifactRepository.php  g  e      J   vendor/composer/composer/src/Composer/Repository/RootPackageRepository.php:  g:  V>      F   vendor/composer/composer/src/Composer/Repository/RepositoryManager.php  g  nH      E   vendor/composer/composer/src/Composer/Repository/Vcs/GitHubDriver.phpZ  gZ  U s      B   vendor/composer/composer/src/Composer/Repository/Vcs/VcsDriver.php  g  rO      B   vendor/composer/composer/src/Composer/Repository/Vcs/SvnDriver.php3  g3  ʍE      A   vendor/composer/composer/src/Composer/Repository/Vcs/HgDriver.php6  g6         G   vendor/composer/composer/src/Composer/Repository/Vcs/PerforceDriver.php  g  %6ɤ      K   vendor/composer/composer/src/Composer/Repository/Vcs/GitBitbucketDriver.php8  g8  Mn      B   vendor/composer/composer/src/Composer/Repository/Vcs/GitDriver.php!  g!  Zf      E   vendor/composer/composer/src/Composer/Repository/Vcs/GitLabDriver.php4R  g4R  \6L      K   vendor/composer/composer/src/Composer/Repository/Vcs/VcsDriverInterface.php
  g
  O
4ۤ      E   vendor/composer/composer/src/Composer/Repository/Vcs/FossilDriver.php\  g\  b:      C   vendor/composer/composer/src/Composer/Repository/PathRepository.phpK"  gK"  -Ƥ      J   vendor/composer/composer/src/Composer/Repository/VersionCacheInterface.phpd  gd  ~      K   vendor/composer/composer/src/Composer/Repository/CanonicalPackagesTrait.php  g  =      E   vendor/composer/composer/src/Composer/Repository/FilterRepository.php  g  X      H   vendor/composer/composer/src/Composer/Repository/InstalledRepository.phpI3  gI3  ̤      N   vendor/composer/composer/src/Composer/Repository/AdvisoryProviderInterface.php  g  XD@      I   vendor/composer/composer/src/Composer/Repository/FilesystemRepository.php??  g??  W      M   vendor/composer/composer/src/Composer/Repository/InstalledArrayRepository.php  g  f~      T   vendor/composer/composer/src/Composer/Repository/ConfigurableRepositoryInterface.php  g  F*'      O   vendor/composer/composer/src/Composer/Repository/InvalidRepositoryException.php  g  f=      <   vendor/composer/composer/src/Composer/Util/PackageSorter.phpN  gN  8
      >   vendor/composer/composer/src/Composer/Util/ConfigValidator.php[$  g[$   zf      2   vendor/composer/composer/src/Composer/Util/Git.phpqi  gqi        2   vendor/composer/composer/src/Composer/Util/Svn.php&  g&  sH      =   vendor/composer/composer/src/Composer/Util/NoProxyPattern.php)  g)  x      =   vendor/composer/composer/src/Composer/Util/ComposerMirror.phpW	  gW	  ~w      :   vendor/composer/composer/src/Composer/Util/PackageInfo.phpA  gA  #R      9   vendor/composer/composer/src/Composer/Util/AuthHelper.php8  g8        2   vendor/composer/composer/src/Composer/Util/Zip.phpR
  gR
  Aä      7   vendor/composer/composer/src/Composer/Util/Silencer.php/  g/  <      9   vendor/composer/composer/src/Composer/Util/Filesystem.phpd{  gd{  d}`      2   vendor/composer/composer/src/Composer/Util/Tar.php  g  
Ǥ      5   vendor/composer/composer/src/Composer/Util/GitHub.php!  g!  j\	v      5   vendor/composer/composer/src/Composer/Util/GitLab.php/  g/  |!      8   vendor/composer/composer/src/Composer/Util/Bitbucket.php9&  g9&  	ǽ      =   vendor/composer/composer/src/Composer/Util/HttpDownloader.php)H  g)H  s%G      8   vendor/composer/composer/src/Composer/Util/IniHelper.phpm  gm  7r      7   vendor/composer/composer/src/Composer/Util/Platform.php*  g*  hP      C   vendor/composer/composer/src/Composer/Util/StreamContextFactory.php"  g"  ?x      8   vendor/composer/composer/src/Composer/Util/TlsHelper.php  g  5FϤ      2   vendor/composer/composer/src/Composer/Util/Url.php  g  ʉ٤      7   vendor/composer/composer/src/Composer/Util/Perforce.php2L  g2L  
Ǥ      @   vendor/composer/composer/src/Composer/Util/Http/ProxyManager.php  g  ewY      <   vendor/composer/composer/src/Composer/Util/Http/Response.phpa  ga  ^      @   vendor/composer/composer/src/Composer/Util/Http/RequestProxy.php  g  Mg      B   vendor/composer/composer/src/Composer/Util/Http/CurlDownloader.phpy  gy  'B      @   vendor/composer/composer/src/Composer/Util/Http/CurlResponse.php  g  1'ɤ      =   vendor/composer/composer/src/Composer/Util/Http/ProxyItem.php  g  =eY      ?   vendor/composer/composer/src/Composer/Util/MetadataMinifier.php  g  #`      >   vendor/composer/composer/src/Composer/Util/ProcessExecutor.phpE  gE  5U      1   vendor/composer/composer/src/Composer/Util/Hg.php  g  Q5      ?   vendor/composer/composer/src/Composer/Util/RemoteFilesystem.php?l  g?l  q'      ;   vendor/composer/composer/src/Composer/Util/ErrorHandler.php,
  g,
  JC      9   vendor/composer/composer/src/Composer/Util/SyncHelper.php
  g
  ެpQ      3   vendor/composer/composer/src/Composer/Util/Loop.php2  g2        A   vendor/composer/composer/src/Composer/Config/JsonConfigSource.phpv)  gv)        F   vendor/composer/composer/src/Composer/Config/ConfigSourceInterface.phpf  gf  (פ      =   vendor/composer/composer/src/Composer/SelfUpdate/Versions.php  g  .]!      9   vendor/composer/composer/src/Composer/SelfUpdate/Keys.php  g  -*      /   vendor/composer/composer/src/Composer/Cache.php+  g+  @U      ?   vendor/composer/composer/src/Composer/EventDispatcher/Event.php  g  ~ k      R   vendor/composer/composer/src/Composer/EventDispatcher/ScriptExecutionException.php  g  ;;      I   vendor/composer/composer/src/Composer/EventDispatcher/EventDispatcher.php4  g4  Dפ      R   vendor/composer/composer/src/Composer/EventDispatcher/EventSubscriberInterface.phpu  gu  h_}      9   vendor/composer/composer/src/Composer/PartialComposer.php'
  g'
  c      :   vendor/composer/composer/src/Composer/Platform/Runtime.php
	  g
	  :K(      ?   vendor/composer/composer/src/Composer/Platform/HhvmDetector.php  g  H껥      :   vendor/composer/composer/src/Composer/Platform/Version.php
  g
  \      5   vendor/composer/composer/src/Composer/IO/BufferIO.php  g  '˄      6   vendor/composer/composer/src/Composer/IO/ConsoleIO.phpK)  gK)  51      3   vendor/composer/composer/src/Composer/IO/BaseIO.phpX#  gX#        3   vendor/composer/composer/src/Composer/IO/NullIO.php	  g	  {      8   vendor/composer/composer/src/Composer/IO/IOInterface.phpZ   gZ   
      =   vendor/composer/composer/src/Composer/Plugin/PluginEvents.phpe  ge  1+ˤ      C   vendor/composer/composer/src/Composer/Plugin/PreCommandRunEvent.php2  g2  :q@      K   vendor/composer/composer/src/Composer/Plugin/Capability/CommandProvider.php  g  d,      F   vendor/composer/composer/src/Composer/Plugin/Capability/Capability.php  g  Lk      G   vendor/composer/composer/src/Composer/Plugin/PluginBlockedException.php  g  Nu      =   vendor/composer/composer/src/Composer/Plugin/CommandEvent.phpy  gy  /      @   vendor/composer/composer/src/Composer/Plugin/PluginInterface.php?  g?  #?"      >   vendor/composer/composer/src/Composer/Plugin/PluginManager.phpP  gP  .r      E   vendor/composer/composer/src/Composer/Plugin/PreFileDownloadEvent.php9  g9        F   vendor/composer/composer/src/Composer/Plugin/PostFileDownloadEvent.php
  g
        8   vendor/composer/composer/src/Composer/Plugin/Capable.php  g  u      C   vendor/composer/composer/src/Composer/Plugin/PrePoolCreateEvent.php  g  H      B   vendor/composer/composer/src/Composer/Downloader/RarDownloader.php	  g	  "Ĥ      R   vendor/composer/composer/src/Composer/Downloader/VcsCapableDownloaderInterface.phpC  gC  H      B   vendor/composer/composer/src/Composer/Downloader/VcsDownloader.php4  g4  \4=      H   vendor/composer/composer/src/Composer/Downloader/FilesystemException.php  g  J      D   vendor/composer/composer/src/Composer/Downloader/DownloadManager.phpR<  gR<  H      B   vendor/composer/composer/src/Composer/Downloader/TarDownloader.php  g  K7J      E   vendor/composer/composer/src/Composer/Downloader/FossilDownloader.php  g  WΤ      Q   vendor/composer/composer/src/Composer/Downloader/MaxFileSizeExceededException.php  g  `ܤ      H   vendor/composer/composer/src/Composer/Downloader/DownloaderInterface.php  g  x      A   vendor/composer/composer/src/Composer/Downloader/XzDownloader.phpQ  gQ  aYŤ      A   vendor/composer/composer/src/Composer/Downloader/HgDownloader.php  g  p      B   vendor/composer/composer/src/Composer/Downloader/SvnDownloader.php"  g"  rv      C   vendor/composer/composer/src/Composer/Downloader/FileDownloader.phpCS  gCS  R      J   vendor/composer/composer/src/Composer/Downloader/ChangeReportInterface.php'  g'  }s$      G   vendor/composer/composer/src/Composer/Downloader/TransportException.php  g  ʤ      F   vendor/composer/composer/src/Composer/Downloader/ArchiveDownloader.php!  g!  {Z      L   vendor/composer/composer/src/Composer/Downloader/DvcsDownloaderInterface.php6  g6  1N}      C   vendor/composer/composer/src/Composer/Downloader/PharDownloader.php  g  /&֤      C   vendor/composer/composer/src/Composer/Downloader/PathDownloader.php6  g6  ,_      G   vendor/composer/composer/src/Composer/Downloader/PerforceDownloader.php
  g
  R.      B   vendor/composer/composer/src/Composer/Downloader/GitDownloader.phpa  ga  5Ȥ      B   vendor/composer/composer/src/Composer/Downloader/ZipDownloader.phpL9  gL9  0      C   vendor/composer/composer/src/Composer/Downloader/GzipDownloader.php  g  S      0   vendor/composer/composer/src/Composer/Config.phpCa  gCa  ~s      6   vendor/composer/composer/src/Composer/Script/Event.php  g  D]      =   vendor/composer/composer/src/Composer/Script/ScriptEvents.php  g  KGꮤ      M   vendor/composer/composer/src/Composer/Question/StrictConfirmationQuestion.php  g  `a      2   vendor/composer/composer/src/Composer/Composer.php  g  o]Ƥ      F   vendor/composer/composer/src/Composer/Json/JsonValidationException.phpl  gl  exˤ      <   vendor/composer/composer/src/Composer/Json/JsonFormatter.phpe  ge        7   vendor/composer/composer/src/Composer/Json/JsonFile.php3  g3  N      >   vendor/composer/composer/src/Composer/Json/JsonManipulator.php8S  g8S  WT      ;   vendor/composer/composer/src/Composer/InstalledVersions.phpIB  gIB   "      W   vendor/composer/composer/src/Composer/DependencyResolver/Operation/InstallOperation.phpz  gz  =~i      b   vendor/composer/composer/src/Composer/DependencyResolver/Operation/MarkAliasInstalledOperation.phpx  gx  nҤ      Y   vendor/composer/composer/src/Composer/DependencyResolver/Operation/OperationInterface.php  g  }|(̤      V   vendor/composer/composer/src/Composer/DependencyResolver/Operation/UpdateOperation.phpw  gw  c;      V   vendor/composer/composer/src/Composer/DependencyResolver/Operation/SolverOperation.php  g  Iw      Y   vendor/composer/composer/src/Composer/DependencyResolver/Operation/UninstallOperation.phpb  gb  &Yl      d   vendor/composer/composer/src/Composer/DependencyResolver/Operation/MarkAliasUninstalledOperation.php~  g~        H   vendor/composer/composer/src/Composer/DependencyResolver/Transaction.php8  g8  |Ԥ      L   vendor/composer/composer/src/Composer/DependencyResolver/PolicyInterface.php  g         Q   vendor/composer/composer/src/Composer/DependencyResolver/LocalRepoTransaction.php(  g(  tʺ      K   vendor/composer/composer/src/Composer/DependencyResolver/RuleWatchGraph.phpA  gA  >      H   vendor/composer/composer/src/Composer/DependencyResolver/GenericRule.php  g  >>MV      L   vendor/composer/composer/src/Composer/DependencyResolver/LockTransaction.php  g  h      C   vendor/composer/composer/src/Composer/DependencyResolver/Solver.phph  gh  s      A   vendor/composer/composer/src/Composer/DependencyResolver/Rule.phpN  gN  d ۤ      J   vendor/composer/composer/src/Composer/DependencyResolver/Rule2Literals.php
  g
  dײ      T   vendor/composer/composer/src/Composer/DependencyResolver/SolverProblemsException.php  g  18M      O   vendor/composer/composer/src/Composer/DependencyResolver/SolverBugException.php  g  /d      J   vendor/composer/composer/src/Composer/DependencyResolver/DefaultPolicy.php(  g(  
8      J   vendor/composer/composer/src/Composer/DependencyResolver/RuleWatchNode.php  g  '      D   vendor/composer/composer/src/Composer/DependencyResolver/RuleSet.phpX  gX  q      A   vendor/composer/composer/src/Composer/DependencyResolver/Pool.php   g   ?6lJ      N   vendor/composer/composer/src/Composer/DependencyResolver/MultiConflictRule.phpq  gq  S8e      D   vendor/composer/composer/src/Composer/DependencyResolver/Request.php!  g!  1      J   vendor/composer/composer/src/Composer/DependencyResolver/PoolOptimizer.phpM  gM  	zA      M   vendor/composer/composer/src/Composer/DependencyResolver/RuleSetGenerator.php6  g6  w      F   vendor/composer/composer/src/Composer/DependencyResolver/Decisions.php  g  Q      H   vendor/composer/composer/src/Composer/DependencyResolver/PoolBuilder.php  g  	dA"      D   vendor/composer/composer/src/Composer/DependencyResolver/Problem.php-  g-  3C      L   vendor/composer/composer/src/Composer/DependencyResolver/RuleSetIterator.phpC
  gC
  r      K   vendor/composer/composer/src/Composer/DependencyResolver/RuleWatchChain.php  g  ]      D   vendor/composer/composer/src/Composer/Autoload/AutoloadGenerator.phpM  gM  pN      >   vendor/composer/composer/src/Composer/Autoload/ClassLoader.phpg>  gg>  v      D   vendor/composer/composer/src/Composer/Autoload/ClassMapGenerator.php  g  I%c       A   vendor/composer/composer/src/Composer/Command/SuggestsCommand.php;  g;  :&|      ?   vendor/composer/composer/src/Composer/Command/SearchCommand.php  g  k^      =   vendor/composer/composer/src/Composer/Command/BumpCommand.php&  g&  r      @   vendor/composer/composer/src/Composer/Command/ArchiveCommand.php*!  g*!  sM      >   vendor/composer/composer/src/Composer/Command/AuditCommand.php3  g3  jl      A   vendor/composer/composer/src/Composer/Command/ValidateCommand.phpm$  gm$  撌r      =   vendor/composer/composer/src/Composer/Command/FundCommand.php  g  {      G   vendor/composer/composer/src/Composer/Command/PackageDiscoveryTrait.phpO  gO  G:      D   vendor/composer/composer/src/Composer/Command/ScriptAliasCommand.php
  g
  \       F   vendor/composer/composer/src/Composer/Command/CreateProjectCommand.php^  g^  4Ѥ      =   vendor/composer/composer/src/Composer/Command/BaseCommand.phpB  gB  ?a      A   vendor/composer/composer/src/Composer/Command/OutdatedCommand.phpB  gB  G      E   vendor/composer/composer/src/Composer/Command/DumpAutoloadCommand.php  g        =   vendor/composer/composer/src/Composer/Command/HomeCommand.phpC  gC  rj      B   vendor/composer/composer/src/Composer/Command/ReinstallCommand.php#  g#  "       ?   vendor/composer/composer/src/Composer/Command/RemoveCommand.php;  g;        =   vendor/composer/composer/src/Composer/Command/ShowCommand.php% g% 	EO      @   vendor/composer/composer/src/Composer/Command/InstallCommand.php  g  
q      =   vendor/composer/composer/src/Composer/Command/InitCommand.php([  g([  (!#ͤ      B   vendor/composer/composer/src/Composer/Command/RunScriptCommand.php  g  rm      ?   vendor/composer/composer/src/Composer/Command/ConfigCommand.phpȜ  gȜ  J瑤      A   vendor/composer/composer/src/Composer/Command/LicensesCommand.php  g  8$䂤      ?   vendor/composer/composer/src/Composer/Command/UpdateCommand.phpeN  geN  J(      ?   vendor/composer/composer/src/Composer/Command/StatusCommand.php{   g{   C      G   vendor/composer/composer/src/Composer/Command/BaseDependencyCommand.php3  g3        @   vendor/composer/composer/src/Composer/Command/DependsCommand.php  g  vN      B   vendor/composer/composer/src/Composer/Command/ProhibitsCommand.php  g   &      J   vendor/composer/composer/src/Composer/Command/CheckPlatformReqsCommand.php  g  Yj      C   vendor/composer/composer/src/Composer/Command/SelfUpdateCommand.phpi  gi        @   vendor/composer/composer/src/Composer/Command/RequireCommand.phps  gs  ^;      A   vendor/composer/composer/src/Composer/Command/CompletionTrait.php#  g#  "i      C   vendor/composer/composer/src/Composer/Command/ClearCacheCommand.phpX
  gX
  (      A   vendor/composer/composer/src/Composer/Command/DiagnoseCommand.phpF  gF  Þ      ?   vendor/composer/composer/src/Composer/Command/GlobalCommand.php  g  ~i      >   vendor/composer/composer/src/Composer/Command/AboutCommand.php  g  
      =   vendor/composer/composer/src/Composer/Command/ExecCommand.php>  g>  Ƙi      3   vendor/composer/composer/src/Composer/Installer.php  g  MI      m   vendor/composer/composer/src/Composer/Filter/PlatformRequirementFilter/PlatformRequirementFilterInterface.php  g         m   vendor/composer/composer/src/Composer/Filter/PlatformRequirementFilter/IgnoreAllPlatformRequirementFilter.php  g  u      n   vendor/composer/composer/src/Composer/Filter/PlatformRequirementFilter/IgnoreListPlatformRequirementFilter.php  g  f      q   vendor/composer/composer/src/Composer/Filter/PlatformRequirementFilter/IgnoreNothingPlatformRequirementFilter.php  g  u      k   vendor/composer/composer/src/Composer/Filter/PlatformRequirementFilter/PlatformRequirementFilterFactory.php  g  $¤      A   vendor/composer/composer/src/Composer/Installer/PackageEvents.php"  g"  ]m      C   vendor/composer/composer/src/Composer/Installer/BinaryInstaller.php8  g8  b>      C   vendor/composer/composer/src/Composer/Installer/PluginInstaller.phpw  gw  0\      K   vendor/composer/composer/src/Composer/Installer/BinaryPresenceInterface.php  g  <P      C   vendor/composer/composer/src/Composer/Installer/InstallerEvents.php  g  "e      @   vendor/composer/composer/src/Composer/Installer/PackageEvent.php  g  T      B   vendor/composer/composer/src/Composer/Installer/InstallerEvent.php  g  r>      D   vendor/composer/composer/src/Composer/Installer/LibraryInstaller.php&,  g&,        F   vendor/composer/composer/src/Composer/Installer/InstallerInterface.php1  g1  K;      H   vendor/composer/composer/src/Composer/Installer/MetapackageInstaller.php  g  ն٤      D   vendor/composer/composer/src/Composer/Installer/ProjectInstaller.php
  g
        M   vendor/composer/composer/src/Composer/Installer/SuggestedPackagesReporter.php  g  vӤ      G   vendor/composer/composer/src/Composer/Installer/InstallationManager.php`  g`  @!      A   vendor/composer/composer/src/Composer/Installer/NoopInstaller.phpY  gY  ^.      C   vendor/composer/composer/src/Composer/Advisory/SecurityAdvisory.php  g  ݭ      J   vendor/composer/composer/src/Composer/Advisory/PartialSecurityAdvisory.php  g  u      :   vendor/composer/composer/src/Composer/Advisory/Auditor.php=  g=  ̶Ҥ      J   vendor/composer/composer/src/Composer/Advisory/IgnoredSecurityAdvisory.phpk  gk  K`      R   vendor/composer/composer/src/Composer/Exception/IrrecoverableDownloadException.php  g        B   vendor/composer/composer/src/Composer/Exception/NoSslException.php  g  ;P      2   vendor/composer/composer/src/Composer/Compiler.php-  g-  zq      9   vendor/composer/composer/src/Composer/Package/Package.phpD  gD  i?f      6   vendor/composer/composer/src/Composer/Package/Link.php
  g
  +H      J   vendor/composer/composer/src/Composer/Package/CompletePackageInterface.php  g  }{+      I   vendor/composer/composer/src/Composer/Package/Archiver/ArchiveManager.php$  g$        P   vendor/composer/composer/src/Composer/Package/Archiver/ArchivableFilesFinder.phpq  gq  ߶q      G   vendor/composer/composer/src/Composer/Package/Archiver/PharArchiver.php  g  ǁM      L   vendor/composer/composer/src/Composer/Package/Archiver/BaseExcludeFilter.php  g  @ݤ      P   vendor/composer/composer/src/Composer/Package/Archiver/ArchivableFilesFilter.php  g  ߵ      K   vendor/composer/composer/src/Composer/Package/Archiver/GitExcludeFilter.php  g  ^      P   vendor/composer/composer/src/Composer/Package/Archiver/ComposerExcludeFilter.php  g  ޣ      L   vendor/composer/composer/src/Composer/Package/Archiver/ArchiverInterface.php  g  ;w      F   vendor/composer/composer/src/Composer/Package/Archiver/ZipArchiver.php  g  L      F   vendor/composer/composer/src/Composer/Package/CompleteAliasPackage.php  g  lN(      >   vendor/composer/composer/src/Composer/Package/AliasPackage.phpe'  ge'  Ҥ      8   vendor/composer/composer/src/Composer/Package/Locker.php/X  g/X        B   vendor/composer/composer/src/Composer/Package/PackageInterface.php00  g00  "'      G   vendor/composer/composer/src/Composer/Package/Version/VersionBumper.phpS  gS  p      I   vendor/composer/composer/src/Composer/Package/Version/StabilityFilter.php  g  5      H   vendor/composer/composer/src/Composer/Package/Version/VersionGuesser.phpWH  gWH  kS      I   vendor/composer/composer/src/Composer/Package/Version/VersionSelector.php0  g0  
      G   vendor/composer/composer/src/Composer/Package/Version/VersionParser.php  g  
?      N   vendor/composer/composer/src/Composer/Package/Loader/ValidatingArrayLoader.phpu  gu  _U      P   vendor/composer/composer/src/Composer/Package/Loader/InvalidPackageException.phpo  go  ,Ҥ      D   vendor/composer/composer/src/Composer/Package/Loader/ArrayLoader.phpF  gF  W
      H   vendor/composer/composer/src/Composer/Package/Loader/LoaderInterface.phpj  gj  7      J   vendor/composer/composer/src/Composer/Package/Loader/RootPackageLoader.phpO.  gO.  pk      C   vendor/composer/composer/src/Composer/Package/Loader/JsonLoader.phpc  gc  ܝ@      =   vendor/composer/composer/src/Composer/Package/BasePackage.php  g  $8      C   vendor/composer/composer/src/Composer/Package/Comparer/Comparer.php  g  fɋ      B   vendor/composer/composer/src/Composer/Package/RootAliasPackage.php  g  r      A   vendor/composer/composer/src/Composer/Package/CompletePackage.php@  g@  ew      F   vendor/composer/composer/src/Composer/Package/RootPackageInterface.php  g  S      =   vendor/composer/composer/src/Composer/Package/RootPackage.phpZ  gZ  k      D   vendor/composer/composer/src/Composer/Package/Dumper/ArrayDumper.php  g  )=      =   vendor/composer/composer/src/Composer/Console/Application.php$  g$  d      C   vendor/composer/composer/src/Composer/Console/GithubActionError.phpl  gl  g`+      E   vendor/composer/composer/src/Composer/Console/Input/InputArgument.php
  g
  &o      C   vendor/composer/composer/src/Composer/Console/Input/InputOption.php  g  (C      E   vendor/composer/composer/src/Composer/Console/HtmlOutputFormatter.php1  g1  g?Ѥ      *   vendor/composer/composer/src/bootstrap.php7  g7  t      (   vendor/composer/ca-bundle/res/cacert.pem/ g/ \{      !   vendor/composer/ca-bundle/LICENSE  g  *!^`      #   vendor/composer/ca-bundle/README.md1  g1  >VuĤ      '   vendor/composer/ca-bundle/composer.json5  g5  y:      *   vendor/composer/ca-bundle/src/CaBundle.phpE+  gE+  &V      !   vendor/composer/autoload_psr4.php  g        %   vendor/composer/autoload_classmap.phpE gE 
f      "   vendor/composer/platform_check.php  g        #   vendor/composer/autoload_static.phpm gm (GR      !   vendor/composer/autoload_real.php  g  `O         vendor/composer/semver/LICENSE  g  Bh      #   vendor/composer/semver/CHANGELOG.mdi'  gi'  [L          vendor/composer/semver/README.mdH
  gH
   }Τ      $   vendor/composer/semver/composer.json  g  z)      /   vendor/composer/semver/src/CompilingMatcher.php
  g
  F      '   vendor/composer/semver/src/Interval.phpu  gu         )   vendor/composer/semver/src/Comparator.php<
  g<
  <L      (   vendor/composer/semver/src/Intervals.phpLP  gLP  K.      %   vendor/composer/semver/src/Semver.phpr
  gr
  Τ      ,   vendor/composer/semver/src/VersionParser.phpSU  gSU  <J?F      =   vendor/composer/semver/src/Constraint/ConstraintInterface.php  g  겤      9   vendor/composer/semver/src/Constraint/MultiConstraint.php#  g#  o      4   vendor/composer/semver/src/Constraint/Constraint.php2  g2  *      <   vendor/composer/semver/src/Constraint/MatchAllConstraint.php,  g,  [j<      =   vendor/composer/semver/src/Constraint/MatchNoneConstraint.php(  g(  h      /   vendor/composer/semver/src/Constraint/Bound.php
  g
        "   vendor/composer/autoload_files.phpD  gD  ̲hѤ      %   vendor/composer/InstalledVersions.phpIB  gIB   "         vendor/composer/installed.php_  g_  F		         vendor/composer/pcre/LICENSE  g  hg^         vendor/composer/pcre/README.md!  g!  B      #   vendor/composer/pcre/extension.neon  g  &&1      "   vendor/composer/pcre/composer.json  g  r7      E   vendor/composer/pcre/src/PHPStan/PregMatchTypeSpecifyingExtension.php  g  UJl      L   vendor/composer/pcre/src/PHPStan/PregReplaceCallbackClosureTypeExtension.php`
  g`
  |~      G   vendor/composer/pcre/src/PHPStan/PregMatchParameterOutTypeExtension.php  g        <   vendor/composer/pcre/src/PHPStan/InvalidRegexPatternRule.phpV  gV   r      3   vendor/composer/pcre/src/PHPStan/PregMatchFlags.php		  g		  wD3B      ?   vendor/composer/pcre/src/PHPStan/UnsafeStrictGroupsCallRule.php
  g
  tCs      (   vendor/composer/pcre/src/MatchResult.php  g  ڇҤ      "   vendor/composer/pcre/src/Regex.php  g  ɤ      6   vendor/composer/pcre/src/MatchAllWithOffsetsResult.php  g        3   vendor/composer/pcre/src/MatchWithOffsetsResult.php  g  o      7   vendor/composer/pcre/src/MatchAllStrictGroupsResult.phpw  gw  Q      9   vendor/composer/pcre/src/UnexpectedNullMatchException.php"  g"  _      4   vendor/composer/pcre/src/MatchStrictGroupsResult.php  g        +   vendor/composer/pcre/src/MatchAllResult.php  g  	Z      *   vendor/composer/pcre/src/ReplaceResult.php  g  /      !   vendor/composer/pcre/src/Preg.phpE  gE  ]G      *   vendor/composer/pcre/src/PcreException.phpw  gw  'v      )   vendor/composer/metadata-minifier/LICENSE  g  hg^      +   vendor/composer/metadata-minifier/README.mdL  gL  Mv<      3   vendor/composer/metadata-minifier/phpstan.neon.distB   gB   #f      /   vendor/composer/metadata-minifier/composer.json  g  D0פ      :   vendor/composer/metadata-minifier/src/MetadataMinifier.php
  g
         6   vendor/composer/spdx-licenses/res/spdx-exceptions.json  g  "m      4   vendor/composer/spdx-licenses/res/spdx-licenses.json  g  
x       %   vendor/composer/spdx-licenses/LICENSE  g  Bh      *   vendor/composer/spdx-licenses/CHANGELOG.mdS  gS  p+      '   vendor/composer/spdx-licenses/README.md<  g<  se      /   vendor/composer/spdx-licenses/phpstan.neon.dist   g   -      +   vendor/composer/spdx-licenses/composer.json  g   '      2   vendor/composer/spdx-licenses/src/SpdxLicenses.php%  g%  ]H
      .   vendor/phpdocumentor/reflection-common/LICENSE9  g9  *2Ȑ      0   vendor/phpdocumentor/reflection-common/README.mdO  gO  
һ      4   vendor/phpdocumentor/reflection-common/composer.json  g  k6      6   vendor/phpdocumentor/reflection-common/src/Element.php  g  7      =   vendor/phpdocumentor/reflection-common/src/ProjectFactory.phpf  gf        3   vendor/phpdocumentor/reflection-common/src/File.php  g  s      6   vendor/phpdocumentor/reflection-common/src/Project.php  g  c=      4   vendor/phpdocumentor/reflection-common/src/Fqsen.php  g  p      7   vendor/phpdocumentor/reflection-common/src/Location.php  g  ;      *   vendor/phpdocumentor/type-resolver/LICENSE8  g8  ʤ      2   vendor/phpdocumentor/type-resolver/phpdoc.dist.xml  g  DA낤      ,   vendor/phpdocumentor/type-resolver/README.md#  g#  ܵ\      0   vendor/phpdocumentor/type-resolver/composer.json  g  \[      7   vendor/phpdocumentor/type-resolver/src/TypeResolver.phpc]  gc]  v      ;   vendor/phpdocumentor/type-resolver/src/Types/Expression.phpF  gF  PM      8   vendor/phpdocumentor/type-resolver/src/Types/Boolean.php|  g|  M65      8   vendor/phpdocumentor/type-resolver/src/Types/Integer.phpx  gx  jJ&      6   vendor/phpdocumentor/type-resolver/src/Types/Self_.php  g  SY      6   vendor/phpdocumentor/type-resolver/src/Types/Void_.php  g  Dk'٤      6   vendor/phpdocumentor/type-resolver/src/Types/Null_.php  g  G      :   vendor/phpdocumentor/type-resolver/src/Types/Resource_.php  g  JϤ      7   vendor/phpdocumentor/type-resolver/src/Types/Float_.phpu  gu  Hդ      8   vendor/phpdocumentor/type-resolver/src/Types/Object_.php  g  "]!      8   vendor/phpdocumentor/type-resolver/src/Types/String_.php  g  V̤      9   vendor/phpdocumentor/type-resolver/src/Types/Nullable.php`  g`  uy      :   vendor/phpdocumentor/type-resolver/src/Types/Callable_.php  g  l      @   vendor/phpdocumentor/type-resolver/src/Types/InterfaceString.php  g  >^      :   vendor/phpdocumentor/type-resolver/src/Types/Iterable_.phpF  gF   'y      B   vendor/phpdocumentor/type-resolver/src/Types/CallableParameter.php  g  /      9   vendor/phpdocumentor/type-resolver/src/Types/ArrayKey.php  g  ?n)      7   vendor/phpdocumentor/type-resolver/src/Types/Never_.php  g  	'      8   vendor/phpdocumentor/type-resolver/src/Types/Static_.php  g  {6@      <   vendor/phpdocumentor/type-resolver/src/Types/ClassString.php_  g_  g      8   vendor/phpdocumentor/type-resolver/src/Types/Parent_.php  g  ip      7   vendor/phpdocumentor/type-resolver/src/Types/Scalar.php  g  ؤ      8   vendor/phpdocumentor/type-resolver/src/Types/Context.php  g  fYK      =   vendor/phpdocumentor/type-resolver/src/Types/AbstractList.php  g  &      ;   vendor/phpdocumentor/type-resolver/src/Types/Collection.php  g  䅝      =   vendor/phpdocumentor/type-resolver/src/Types/Intersection.php$  g$        ?   vendor/phpdocumentor/type-resolver/src/Types/ContextFactory.php7  g7  v#      ?   vendor/phpdocumentor/type-resolver/src/Types/AggregatedType.php
  g
  C`      9   vendor/phpdocumentor/type-resolver/src/Types/Compound.php  g        5   vendor/phpdocumentor/type-resolver/src/Types/This.phpg  gg  ~+6      7   vendor/phpdocumentor/type-resolver/src/Types/Array_.php  g   NK      7   vendor/phpdocumentor/type-resolver/src/Types/Mixed_.php  g        /   vendor/phpdocumentor/type-resolver/src/Type.php  g  q4      8   vendor/phpdocumentor/type-resolver/src/FqsenResolver.php	  g	  ͢      B   vendor/phpdocumentor/type-resolver/src/PseudoTypes/StringValue.php  g  FI      <   vendor/phpdocumentor/type-resolver/src/PseudoTypes/List_.php  g  O      E   vendor/phpdocumentor/type-resolver/src/PseudoTypes/NonEmptyString.php}  g}   i      @   vendor/phpdocumentor/type-resolver/src/PseudoTypes/ShapeItem.php+  g+  NG      C   vendor/phpdocumentor/type-resolver/src/PseudoTypes/IntegerRange.phpA  gA  ֭Z$      E   vendor/phpdocumentor/type-resolver/src/PseudoTypes/CallableString.php|  g|        D   vendor/phpdocumentor/type-resolver/src/PseudoTypes/ListShapeItem.php   g   곤      ?   vendor/phpdocumentor/type-resolver/src/PseudoTypes/Numeric_.php(  g(  ^6      =   vendor/phpdocumentor/type-resolver/src/PseudoTypes/False_.php  g  /      F   vendor/phpdocumentor/type-resolver/src/PseudoTypes/ObjectShapeItem.php   g   IC3      B   vendor/phpdocumentor/type-resolver/src/PseudoTypes/TraitString.phpv  gv  {      A   vendor/phpdocumentor/type-resolver/src/PseudoTypes/FloatValue.php  g  4AY      D   vendor/phpdocumentor/type-resolver/src/PseudoTypes/NumericString.phpz  gz  *      H   vendor/phpdocumentor/type-resolver/src/PseudoTypes/HtmlEscapedString.php  g  y"Ѥ      C   vendor/phpdocumentor/type-resolver/src/PseudoTypes/IntegerValue.php  g  R4      D   vendor/phpdocumentor/type-resolver/src/PseudoTypes/LiteralString.phpz  gz        C   vendor/phpdocumentor/type-resolver/src/PseudoTypes/NonEmptyList.php  g  I      F   vendor/phpdocumentor/type-resolver/src/PseudoTypes/ConstExpression.php  g  oe4      A   vendor/phpdocumentor/type-resolver/src/PseudoTypes/ArrayShape.php  g  frd      N   vendor/phpdocumentor/type-resolver/src/PseudoTypes/NonEmptyLowercaseString.php  g        D   vendor/phpdocumentor/type-resolver/src/PseudoTypes/NonEmptyArray.php  g  ,      F   vendor/phpdocumentor/type-resolver/src/PseudoTypes/LowercaseString.php~  g~  kc      <   vendor/phpdocumentor/type-resolver/src/PseudoTypes/True_.php  g  W      @   vendor/phpdocumentor/type-resolver/src/PseudoTypes/ListShape.php3  g3  p      F   vendor/phpdocumentor/type-resolver/src/PseudoTypes/NegativeInteger.phpw  gw  p      E   vendor/phpdocumentor/type-resolver/src/PseudoTypes/ArrayShapeItem.phpe  ge  7      B   vendor/phpdocumentor/type-resolver/src/PseudoTypes/ObjectShape.phpM  gM  *9      F   vendor/phpdocumentor/type-resolver/src/PseudoTypes/PositiveInteger.phpw  gw  .      5   vendor/phpdocumentor/type-resolver/src/PseudoType.php|  g|  }      0   vendor/phpdocumentor/reflection-docblock/LICENSE8  g8  ʤ      2   vendor/phpdocumentor/reflection-docblock/README.md[  g[  \S      6   vendor/phpdocumentor/reflection-docblock/composer.json  g        @   vendor/phpdocumentor/reflection-docblock/src/DocBlockFactory.php0  g0  O?&      D   vendor/phpdocumentor/reflection-docblock/src/DocBlock/Serializer.phpH  gH  gդ      G   vendor/phpdocumentor/reflection-docblock/src/DocBlock/ExampleFinder.phpI  gI  	T      =   vendor/phpdocumentor/reflection-docblock/src/DocBlock/Tag.php  g  ῤ      D   vendor/phpdocumentor/reflection-docblock/src/DocBlock/TagFactory.php
  g
  ROJ      L   vendor/phpdocumentor/reflection-docblock/src/DocBlock/DescriptionFactory.php<  g<  FJ      D   vendor/phpdocumentor/reflection-docblock/src/DocBlock/Tags/Since.php
  g
  ,      L   vendor/phpdocumentor/reflection-docblock/src/DocBlock/Tags/PropertyWrite.php  g  ֻ      N   vendor/phpdocumentor/reflection-docblock/src/DocBlock/Tags/MethodParameter.php  g  K銤      C   vendor/phpdocumentor/reflection-docblock/src/DocBlock/Tags/Link.php  g  j
      I   vendor/phpdocumentor/reflection-docblock/src/DocBlock/Tags/InvalidTag.php  g  _<j      F   vendor/phpdocumentor/reflection-docblock/src/DocBlock/Tags/BaseTag.php  g  y{      C   vendor/phpdocumentor/reflection-docblock/src/DocBlock/Tags/Var_.php  g  x֤      D   vendor/phpdocumentor/reflection-docblock/src/DocBlock/Tags/Param.php9  g9  ֩      D   vendor/phpdocumentor/reflection-docblock/src/DocBlock/Tags/Mixin.php  g        P   vendor/phpdocumentor/reflection-docblock/src/DocBlock/Tags/TemplateCovariant.php  g  ͤ      E   vendor/phpdocumentor/reflection-docblock/src/DocBlock/Tags/Method.php'  g'  ʤ      H   vendor/phpdocumentor/reflection-docblock/src/DocBlock/Tags/Formatter.php,  g,  <c      C   vendor/phpdocumentor/reflection-docblock/src/DocBlock/Tags/Uses.phpV
  gV
  .Ѥ      F   vendor/phpdocumentor/reflection-docblock/src/DocBlock/Tags/Return_.php  g  }þ      ]   vendor/phpdocumentor/reflection-docblock/src/DocBlock/Tags/Formatter/PassthroughFormatter.php  g  ZL      W   vendor/phpdocumentor/reflection-docblock/src/DocBlock/Tags/Formatter/AlignFormatter.php  g  e&A      Q   vendor/phpdocumentor/reflection-docblock/src/DocBlock/Tags/TemplateImplements.php  g  r      K   vendor/phpdocumentor/reflection-docblock/src/DocBlock/Tags/PropertyRead.php  g  )r      G   vendor/phpdocumentor/reflection-docblock/src/DocBlock/Tags/Property.php  g  q}      F   vendor/phpdocumentor/reflection-docblock/src/DocBlock/Tags/Version.php
  g
  .2      B   vendor/phpdocumentor/reflection-docblock/src/DocBlock/Tags/See.php5  g5  
      G   vendor/phpdocumentor/reflection-docblock/src/DocBlock/Tags/Extends_.php,  g,  gE      F   vendor/phpdocumentor/reflection-docblock/src/DocBlock/Tags/Generic.php	  g	        J   vendor/phpdocumentor/reflection-docblock/src/DocBlock/Tags/TagWithType.php	  g	  _UG      E   vendor/phpdocumentor/reflection-docblock/src/DocBlock/Tags/Source.php  g  cM      G   vendor/phpdocumentor/reflection-docblock/src/DocBlock/Tags/Template.phpM	  gM	        J   vendor/phpdocumentor/reflection-docblock/src/DocBlock/Tags/Implements_.php5  g5  q      E   vendor/phpdocumentor/reflection-docblock/src/DocBlock/Tags/Author.php	  g	  8"      E   vendor/phpdocumentor/reflection-docblock/src/DocBlock/Tags/Throws.php  g        X   vendor/phpdocumentor/reflection-docblock/src/DocBlock/Tags/Factory/ImplementsFactory.php  g  5      N   vendor/phpdocumentor/reflection-docblock/src/DocBlock/Tags/Factory/Factory.phpJ  gJ  \Τ      Z   vendor/phpdocumentor/reflection-docblock/src/DocBlock/Tags/Factory/PropertyReadFactory.php*  g*  )܈      U   vendor/phpdocumentor/reflection-docblock/src/DocBlock/Tags/Factory/ExtendsFactory.php  g  if      S   vendor/phpdocumentor/reflection-docblock/src/DocBlock/Tags/Factory/StaticMethod.php%  g%  cTg      ]   vendor/phpdocumentor/reflection-docblock/src/DocBlock/Tags/Factory/AbstractPHPStanFactory.php  g  0      [   vendor/phpdocumentor/reflection-docblock/src/DocBlock/Tags/Factory/PropertyWriteFactory.php.  g.  k      Q   vendor/phpdocumentor/reflection-docblock/src/DocBlock/Tags/Factory/VarFactory.php  g  $      T   vendor/phpdocumentor/reflection-docblock/src/DocBlock/Tags/Factory/MethodFactory.phpC
  gC
  [<      V   vendor/phpdocumentor/reflection-docblock/src/DocBlock/Tags/Factory/TemplateFactory.phpJ  gJ  !rs      `   vendor/phpdocumentor/reflection-docblock/src/DocBlock/Tags/Factory/TemplateImplementsFactory.php  g  {׮      S   vendor/phpdocumentor/reflection-docblock/src/DocBlock/Tags/Factory/ParamFactory.php  g  j      ]   vendor/phpdocumentor/reflection-docblock/src/DocBlock/Tags/Factory/MethodParameterFactory.phpN	  gN	  ^E      U   vendor/phpdocumentor/reflection-docblock/src/DocBlock/Tags/Factory/PHPStanFactory.php  g  gɉ      ]   vendor/phpdocumentor/reflection-docblock/src/DocBlock/Tags/Factory/TemplateExtendsFactory.php  g  %?      V   vendor/phpdocumentor/reflection-docblock/src/DocBlock/Tags/Factory/PropertyFactory.php  g  dB      T   vendor/phpdocumentor/reflection-docblock/src/DocBlock/Tags/Factory/ReturnFactory.php  g  z      R   vendor/phpdocumentor/reflection-docblock/src/DocBlock/Tags/Reference/Reference.php  g  g      L   vendor/phpdocumentor/reflection-docblock/src/DocBlock/Tags/Reference/Url.php  g  ޛ      N   vendor/phpdocumentor/reflection-docblock/src/DocBlock/Tags/Reference/Fqsen.php*  g*        N   vendor/phpdocumentor/reflection-docblock/src/DocBlock/Tags/TemplateExtends.php  g        F   vendor/phpdocumentor/reflection-docblock/src/DocBlock/Tags/Example.php  g  c      I   vendor/phpdocumentor/reflection-docblock/src/DocBlock/Tags/Deprecated.php  g  v      E   vendor/phpdocumentor/reflection-docblock/src/DocBlock/Tags/Covers.php
  g
  
C      L   vendor/phpdocumentor/reflection-docblock/src/DocBlock/StandardTagFactory.php4  g4  ~      E   vendor/phpdocumentor/reflection-docblock/src/DocBlock/Description.php<  g<  TT|      6   vendor/phpdocumentor/reflection-docblock/src/Utils.php	  g	  Ԥ      I   vendor/phpdocumentor/reflection-docblock/src/DocBlockFactoryInterface.php  g  δ      9   vendor/phpdocumentor/reflection-docblock/src/DocBlock.php  g  Zr      H   vendor/phpdocumentor/reflection-docblock/src/Exception/PcreException.php  g  ~	g      1   vendor/paragonie/constant_time_encoding/README.md~
  g~
  uLR      3   vendor/paragonie/constant_time_encoding/LICENSE.txte	  ge	  |[      5   vendor/paragonie/constant_time_encoding/composer.json  g  `Zo>      =   vendor/paragonie/constant_time_encoding/src/Base64UrlSafe.phpm  gm  W}¤      9   vendor/paragonie/constant_time_encoding/src/Base32Hex.php9
  g9
  fm      >   vendor/paragonie/constant_time_encoding/src/Base64DotSlash.php  g  %o      8   vendor/paragonie/constant_time_encoding/src/Encoding.php,  g,  R2~      @   vendor/paragonie/constant_time_encoding/src/EncoderInterface.php  g  s:      6   vendor/paragonie/constant_time_encoding/src/Base32.php<  g<  $HC      3   vendor/paragonie/constant_time_encoding/src/Hex.php  g  bFǤ      E   vendor/paragonie/constant_time_encoding/src/Base64DotSlashOrdered.php
  g
  ?Na      6   vendor/paragonie/constant_time_encoding/src/Binary.php
  g
  ތ      7   vendor/paragonie/constant_time_encoding/src/RFC4648.php  g        6   vendor/paragonie/constant_time_encoding/src/Base64.phpc$  gc$  K      #   vendor/spomky-labs/cbor-php/LICENSE,  g,  C      %   vendor/spomky-labs/cbor-php/README.md[+  g[+        )   vendor/spomky-labs/cbor-php/composer.json'  g'  -k      '   vendor/spomky-labs/cbor-php/SECURITY.md  g  Ǥ      0   vendor/spomky-labs/cbor-php/src/StringStream.phpe  ge  &o      :   vendor/spomky-labs/cbor-php/src/OtherObject/TrueObject.php  g  b1F      ;   vendor/spomky-labs/cbor-php/src/OtherObject/BreakObject.phpX  gX  &c      D   vendor/spomky-labs/cbor-php/src/OtherObject/OtherObjectInterface.phpt  gt  аȤ      J   vendor/spomky-labs/cbor-php/src/OtherObject/SinglePrecisionFloatObject.phpQ  gQ  t      =   vendor/spomky-labs/cbor-php/src/OtherObject/GenericObject.php  g  ku5      ;   vendor/spomky-labs/cbor-php/src/OtherObject/FalseObject.php  g  =
      ?   vendor/spomky-labs/cbor-php/src/OtherObject/UndefinedObject.phpd  gd  IM(      J   vendor/spomky-labs/cbor-php/src/OtherObject/DoublePrecisionFloatObject.php  g  ]      K   vendor/spomky-labs/cbor-php/src/OtherObject/OtherObjectManagerInterface.php   g   I      H   vendor/spomky-labs/cbor-php/src/OtherObject/HalfPrecisionFloatObject.phpq  gq  WF       <   vendor/spomky-labs/cbor-php/src/OtherObject/SimpleObject.php	  g	  :j      :   vendor/spomky-labs/cbor-php/src/OtherObject/NullObject.php  g  .      B   vendor/spomky-labs/cbor-php/src/OtherObject/OtherObjectManager.php~  g~  =*F      4   vendor/spomky-labs/cbor-php/src/DecoderInterface.php   g   \f      4   vendor/spomky-labs/cbor-php/src/ByteStringObject.php  g  Bl      D   vendor/spomky-labs/cbor-php/src/IndefiniteLengthTextStringObject.php*  g*  `갤      '   vendor/spomky-labs/cbor-php/src/Tag.phpc  gc  }      +   vendor/spomky-labs/cbor-php/src/Decoder.php#  g#  "I      9   vendor/spomky-labs/cbor-php/src/UnsignedIntegerObject.php  g  򽩜      6   vendor/spomky-labs/cbor-php/src/AbstractCBORObject.phpY  gY  @z>      0   vendor/spomky-labs/cbor-php/src/Normalizable.php   g   xӤ      4   vendor/spomky-labs/cbor-php/src/LengthCalculator.php|  g|  N`      /   vendor/spomky-labs/cbor-php/src/OtherObject.php  g  ?73      *   vendor/spomky-labs/cbor-php/src/Stream.php   g   $c      4   vendor/spomky-labs/cbor-php/src/TextStringObject.php  g  1aM      D   vendor/spomky-labs/cbor-php/src/IndefiniteLengthByteStringObject.php3  g3  Q      >   vendor/spomky-labs/cbor-php/src/IndefiniteLengthListObject.php  g  cR¤      =   vendor/spomky-labs/cbor-php/src/IndefiniteLengthMapObject.php  g  y8      +   vendor/spomky-labs/cbor-php/src/MapItem.php  g         )   vendor/spomky-labs/cbor-php/src/Utils.phpv  gv  p#      .   vendor/spomky-labs/cbor-php/src/ListObject.php  g  0S      -   vendor/spomky-labs/cbor-php/src/MapObject.phpg  gg  /k      .   vendor/spomky-labs/cbor-php/src/CBORObject.php~  g~  4      .   vendor/spomky-labs/cbor-php/src/Tag/UriTag.php  g  )      <   vendor/spomky-labs/cbor-php/src/Tag/Base64UrlEncodingTag.php  g  ܤ      =   vendor/spomky-labs/cbor-php/src/Tag/NegativeBigIntegerTag.php_  g_  [ؠd      :   vendor/spomky-labs/cbor-php/src/Tag/DecimalFractionTag.php
  g
        ;   vendor/spomky-labs/cbor-php/src/Tag/TagManagerInterface.php  g  cG      4   vendor/spomky-labs/cbor-php/src/Tag/TagInterface.phph  gh        4   vendor/spomky-labs/cbor-php/src/Tag/Base64UrlTag.php  g  }       3   vendor/spomky-labs/cbor-php/src/Tag/BigFloatTag.php
  g
  M@Ǥ      /   vendor/spomky-labs/cbor-php/src/Tag/CBORTag.php}  g}  %Ƥ      /   vendor/spomky-labs/cbor-php/src/Tag/MimeTag.php  g  <,      3   vendor/spomky-labs/cbor-php/src/Tag/DatetimeTag.php  g  bʤ      7   vendor/spomky-labs/cbor-php/src/Tag/CBOREncodingTag.php  g   lM      1   vendor/spomky-labs/cbor-php/src/Tag/Base64Tag.php  g  |㨤      9   vendor/spomky-labs/cbor-php/src/Tag/Base16EncodingTag.php  g  M9      =   vendor/spomky-labs/cbor-php/src/Tag/UnsignedBigIntegerTag.php  g  |}      2   vendor/spomky-labs/cbor-php/src/Tag/TagManager.phpE  gE  a      4   vendor/spomky-labs/cbor-php/src/Tag/TimestampTag.php  g  qJ      2   vendor/spomky-labs/cbor-php/src/Tag/GenericTag.php  g  22      9   vendor/spomky-labs/cbor-php/src/Tag/Base64EncodingTag.php  g   k      9   vendor/spomky-labs/cbor-php/src/NegativeIntegerObject.php  g  bx7      (   vendor/spomky-labs/pki-framework/LICENSES  gS  t      *   vendor/spomky-labs/pki-framework/README.md  g  7/V      .   vendor/spomky-labs/pki-framework/composer.json
  g
  eD      ,   vendor/spomky-labs/pki-framework/SECURITY.mdI  gI  ,)      5   vendor/spomky-labs/pki-framework/src/ASN1/Element.php<  g<  9t      9   vendor/spomky-labs/pki-framework/src/ASN1/Util/BigInt.php  g  `}      8   vendor/spomky-labs/pki-framework/src/ASN1/Util/Flags.php  g  
      B   vendor/spomky-labs/pki-framework/src/ASN1/Component/Identifier.php  g  J=      >   vendor/spomky-labs/pki-framework/src/ASN1/Component/Length.php  g  ri
      @   vendor/spomky-labs/pki-framework/src/ASN1/Type/PrimitiveType.php,  g,  SZe2      =   vendor/spomky-labs/pki-framework/src/ASN1/Type/BaseString.php  g  M"~      F   vendor/spomky-labs/pki-framework/src/ASN1/Type/Primitive/BMPString.php_  g_  .      D   vendor/spomky-labs/pki-framework/src/ASN1/Type/Primitive/Boolean.php9  g9  p@      D   vendor/spomky-labs/pki-framework/src/ASN1/Type/Primitive/Integer.phpa  ga  @n      H   vendor/spomky-labs/pki-framework/src/ASN1/Type/Primitive/RelativeOID.php  g  lb      J   vendor/spomky-labs/pki-framework/src/ASN1/Type/Primitive/VisibleString.php  g  wn      C   vendor/spomky-labs/pki-framework/src/ASN1/Type/Primitive/Number.php  g  zڡ      G   vendor/spomky-labs/pki-framework/src/ASN1/Type/Primitive/UTF8String.php  g  b      F   vendor/spomky-labs/pki-framework/src/ASN1/Type/Primitive/BitString.php  g  +      F   vendor/spomky-labs/pki-framework/src/ASN1/Type/Primitive/IA5String.php  g  c&k      L   vendor/spomky-labs/pki-framework/src/ASN1/Type/Primitive/UniversalString.php  g  l0ޤ      J   vendor/spomky-labs/pki-framework/src/ASN1/Type/Primitive/GraphicString.php  g  W      M   vendor/spomky-labs/pki-framework/src/ASN1/Type/Primitive/ObjectDescriptor.php  g  Y1      A   vendor/spomky-labs/pki-framework/src/ASN1/Type/Primitive/Real.phpQ  gQ  ~^      L   vendor/spomky-labs/pki-framework/src/ASN1/Type/Primitive/PrintableString.php  g  iTȘ      @   vendor/spomky-labs/pki-framework/src/ASN1/Type/Primitive/EOC.php  g  !¤      E   vendor/spomky-labs/pki-framework/src/ASN1/Type/Primitive/NullType.php  g  o      M   vendor/spomky-labs/pki-framework/src/ASN1/Type/Primitive/ObjectIdentifier.php  g  z&      G   vendor/spomky-labs/pki-framework/src/ASN1/Type/Primitive/Enumerated.php:  g:  N      J   vendor/spomky-labs/pki-framework/src/ASN1/Type/Primitive/NumericString.php  g  y{      H   vendor/spomky-labs/pki-framework/src/ASN1/Type/Primitive/OctetString.php2  g2  y      L   vendor/spomky-labs/pki-framework/src/ASN1/Type/Primitive/GeneralizedTime.php7  g7  l
      D   vendor/spomky-labs/pki-framework/src/ASN1/Type/Primitive/UTCTime.php:	  g:	  3W-N      K   vendor/spomky-labs/pki-framework/src/ASN1/Type/Primitive/VideotexString.php  g  =đ      L   vendor/spomky-labs/pki-framework/src/ASN1/Type/Primitive/CharacterString.php>  g>         F   vendor/spomky-labs/pki-framework/src/ASN1/Type/Primitive/T61String.php  g  _      J   vendor/spomky-labs/pki-framework/src/ASN1/Type/Primitive/GeneralString.php  g  wӺ      ;   vendor/spomky-labs/pki-framework/src/ASN1/Type/TimeType.php;  g;  -R
      I   vendor/spomky-labs/pki-framework/src/ASN1/Type/Tagged/ImplicitTagging.php  g  Wq      M   vendor/spomky-labs/pki-framework/src/ASN1/Type/Tagged/ContextSpecificType.php   g   X      N   vendor/spomky-labs/pki-framework/src/ASN1/Type/Tagged/ExplicitlyTaggedType.php&  g&        E   vendor/spomky-labs/pki-framework/src/ASN1/Type/Tagged/PrivateType.php   g   4eY      I   vendor/spomky-labs/pki-framework/src/ASN1/Type/Tagged/ApplicationType.php   g   CF      N   vendor/spomky-labs/pki-framework/src/ASN1/Type/Tagged/ImplicitlyTaggedType.php@  g@        G   vendor/spomky-labs/pki-framework/src/ASN1/Type/Tagged/DERTaggedType.php  g  }LV      H   vendor/spomky-labs/pki-framework/src/ASN1/Type/Tagged/TaggedTypeWrap.php'  g'  :      I   vendor/spomky-labs/pki-framework/src/ASN1/Type/Tagged/ExplicitTagging.php  g  \      G   vendor/spomky-labs/pki-framework/src/ASN1/Type/Constructed/Sequence.php[  g[  x       B   vendor/spomky-labs/pki-framework/src/ASN1/Type/Constructed/Set.php$  g$  ~      P   vendor/spomky-labs/pki-framework/src/ASN1/Type/Constructed/ConstructedString.php  g  2L:      B   vendor/spomky-labs/pki-framework/src/ASN1/Type/PrimitiveString.php  g  @$      <   vendor/spomky-labs/pki-framework/src/ASN1/Type/Structure.phpM  gM  f<      ;   vendor/spomky-labs/pki-framework/src/ASN1/Type/BaseTime.php  g  CLb      B   vendor/spomky-labs/pki-framework/src/ASN1/Type/UnspecifiedType.php/?  g/?  ?qФ      =   vendor/spomky-labs/pki-framework/src/ASN1/Type/TaggedType.php	  g	  m      =   vendor/spomky-labs/pki-framework/src/ASN1/Type/StringType.php  g  &      A   vendor/spomky-labs/pki-framework/src/ASN1/Type/UniversalClass.php  g  o      5   vendor/spomky-labs/pki-framework/src/ASN1/DERData.php  g  ($Ĥ      A   vendor/spomky-labs/pki-framework/src/ASN1/Feature/ElementBase.php  g  }<t      @   vendor/spomky-labs/pki-framework/src/ASN1/Feature/Stringable.phps  gs  FM      ?   vendor/spomky-labs/pki-framework/src/ASN1/Feature/Encodable.php   g   ܴ;      G   vendor/spomky-labs/pki-framework/src/ASN1/Exception/DecodeException.php   g   }Ӥ      ;   vendor/spomky-labs/pki-framework/src/CryptoEncoding/PEM.php  g  |f"ˤ      A   vendor/spomky-labs/pki-framework/src/CryptoEncoding/PEMBundle.php  g  La      J   vendor/spomky-labs/pki-framework/src/CryptoBridge/Crypto/OpenSSLCrypto.php  g        <   vendor/spomky-labs/pki-framework/src/CryptoBridge/Crypto.php  g  @      >   vendor/spomky-labs/pki-framework/src/X509/Certificate/Time.php	  g	  n      b   vendor/spomky-labs/pki-framework/src/X509/Certificate/Extension/CRLDistributionPointsExtension.php
  g
  X      g   vendor/spomky-labs/pki-framework/src/X509/Certificate/Extension/SubjectDirectoryAttributesExtension.php&  g&  K+Y      n   vendor/spomky-labs/pki-framework/src/X509/Certificate/Extension/AccessDescription/SubjectAccessDescription.phpw  gw  e\      g   vendor/spomky-labs/pki-framework/src/X509/Certificate/Extension/AccessDescription/AccessDescription.php  g        p   vendor/spomky-labs/pki-framework/src/X509/Certificate/Extension/AccessDescription/AuthorityAccessDescription.phpJ  gJ  (~s      b   vendor/spomky-labs/pki-framework/src/X509/Certificate/Extension/NoRevocationAvailableExtension.php  g        ^   vendor/spomky-labs/pki-framework/src/X509/Certificate/Extension/PolicyConstraintsExtension.php  g  v!      g   vendor/spomky-labs/pki-framework/src/X509/Certificate/Extension/AuthorityInformationAccessExtension.php
  g
        e   vendor/spomky-labs/pki-framework/src/X509/Certificate/Extension/SubjectInformationAccessExtension.php'
  g'
   .î      ^   vendor/spomky-labs/pki-framework/src/X509/Certificate/Extension/TargetInformationExtension.phpN
  gN
  tc(      U   vendor/spomky-labs/pki-framework/src/X509/Certificate/Extension/KeyUsageExtension.php  g  W).      U   vendor/spomky-labs/pki-framework/src/X509/Certificate/Extension/Target/TargetName.php  g  HA      R   vendor/spomky-labs/pki-framework/src/X509/Certificate/Extension/Target/Targets.php
  g
  `%      Q   vendor/spomky-labs/pki-framework/src/X509/Certificate/Extension/Target/Target.phps  gs  G]b      V   vendor/spomky-labs/pki-framework/src/X509/Certificate/Extension/Target/TargetGroup.php  g  1*      `   vendor/spomky-labs/pki-framework/src/X509/Certificate/Extension/PolicyMappings/PolicyMapping.phph  gh  Ť      \   vendor/spomky-labs/pki-framework/src/X509/Certificate/Extension/NameConstraintsExtension.phpp  gp  i      X   vendor/spomky-labs/pki-framework/src/X509/Certificate/Extension/FreshestCRLExtension.phpU  gU  E      T   vendor/spomky-labs/pki-framework/src/X509/Certificate/Extension/UnknownExtension.php  g  m      b   vendor/spomky-labs/pki-framework/src/X509/Certificate/Extension/IssuerAlternativeNameExtension.php  g  7@A^      `   vendor/spomky-labs/pki-framework/src/X509/Certificate/Extension/CertificatePoliciesExtension.phpx
  gx
        ]   vendor/spomky-labs/pki-framework/src/X509/Certificate/Extension/InhibitAnyPolicyExtension.phpf  gf  UP      b   vendor/spomky-labs/pki-framework/src/X509/Certificate/Extension/DistributionPoint/RelativeName.phpe  ge  iwX      g   vendor/spomky-labs/pki-framework/src/X509/Certificate/Extension/DistributionPoint/DistributionPoint.php  g  pӿ      ^   vendor/spomky-labs/pki-framework/src/X509/Certificate/Extension/DistributionPoint/FullName.php  g  4      a   vendor/spomky-labs/pki-framework/src/X509/Certificate/Extension/DistributionPoint/ReasonFlags.php  g  dŤ      k   vendor/spomky-labs/pki-framework/src/X509/Certificate/Extension/DistributionPoint/DistributionPointName.php  g  TQ      c   vendor/spomky-labs/pki-framework/src/X509/Certificate/Extension/NameConstraints/GeneralSubtrees.php  g  hL\      b   vendor/spomky-labs/pki-framework/src/X509/Certificate/Extension/NameConstraints/GeneralSubtree.php
  g
  K      ]   vendor/spomky-labs/pki-framework/src/X509/Certificate/Extension/ExtendedKeyUsageExtension.php  g  WL      W   vendor/spomky-labs/pki-framework/src/X509/Certificate/Extension/AAControlsExtension.php  g  er      e   vendor/spomky-labs/pki-framework/src/X509/Certificate/Extension/CertificatePolicy/NoticeReference.phpa  ga  
      i   vendor/spomky-labs/pki-framework/src/X509/Certificate/Extension/CertificatePolicy/PolicyQualifierInfo.php  g  Dr      i   vendor/spomky-labs/pki-framework/src/X509/Certificate/Extension/CertificatePolicy/UserNoticeQualifier.php	  g	  4s      g   vendor/spomky-labs/pki-framework/src/X509/Certificate/Extension/CertificatePolicy/PolicyInformation.phpt  gt  ҫ       a   vendor/spomky-labs/pki-framework/src/X509/Certificate/Extension/CertificatePolicy/DisplayText.php6  g6  Ť      b   vendor/spomky-labs/pki-framework/src/X509/Certificate/Extension/CertificatePolicy/CPSQualifier.phpK  gK  $vu      [   vendor/spomky-labs/pki-framework/src/X509/Certificate/Extension/PolicyMappingsExtension.php  g  p'i      M   vendor/spomky-labs/pki-framework/src/X509/Certificate/Extension/Extension.php'  g'  b      c   vendor/spomky-labs/pki-framework/src/X509/Certificate/Extension/AuthorityKeyIdentifierExtension.php  g  pT      c   vendor/spomky-labs/pki-framework/src/X509/Certificate/Extension/SubjectAlternativeNameExtension.php  g  6+      ]   vendor/spomky-labs/pki-framework/src/X509/Certificate/Extension/BasicConstraintsExtension.php	  g	  ?z      a   vendor/spomky-labs/pki-framework/src/X509/Certificate/Extension/SubjectKeyIdentifierExtension.php  g  )VS      E   vendor/spomky-labs/pki-framework/src/X509/Certificate/Certificate.php  g  7;      J   vendor/spomky-labs/pki-framework/src/X509/Certificate/UniqueIdentifier.php  g  q      J   vendor/spomky-labs/pki-framework/src/X509/Certificate/CertificateChain.php  g  N8      B   vendor/spomky-labs/pki-framework/src/X509/Certificate/Validity.phpx  gx  $Ҥ      K   vendor/spomky-labs/pki-framework/src/X509/Certificate/CertificateBundle.phpC  gC        H   vendor/spomky-labs/pki-framework/src/X509/Certificate/TBSCertificate.php8  g8  b^      D   vendor/spomky-labs/pki-framework/src/X509/Certificate/Extensions.php$  g$  [      F   vendor/spomky-labs/pki-framework/src/X509/GeneralName/RegisteredID.php  g  Z3      G   vendor/spomky-labs/pki-framework/src/X509/GeneralName/DirectoryName.php]  g]  ^      F   vendor/spomky-labs/pki-framework/src/X509/GeneralName/EDIPartyName.php  g  Noߤ      C   vendor/spomky-labs/pki-framework/src/X509/GeneralName/OtherName.php  g  V$d      C   vendor/spomky-labs/pki-framework/src/X509/GeneralName/IPAddress.php  g  ?U      E   vendor/spomky-labs/pki-framework/src/X509/GeneralName/X400Address.php  g  T      E   vendor/spomky-labs/pki-framework/src/X509/GeneralName/IPv4Address.php!  g!  #      F   vendor/spomky-labs/pki-framework/src/X509/GeneralName/GeneralNames.php  g  \֤      S   vendor/spomky-labs/pki-framework/src/X509/GeneralName/UniformResourceIdentifier.php  g  e      D   vendor/spomky-labs/pki-framework/src/X509/GeneralName/RFC822Name.php  g  Mpn      E   vendor/spomky-labs/pki-framework/src/X509/GeneralName/GeneralName.phpD
  gD
        E   vendor/spomky-labs/pki-framework/src/X509/GeneralName/IPv6Address.php  g   Ip      A   vendor/spomky-labs/pki-framework/src/X509/GeneralName/DNSName.php(  g(  Yj      D   vendor/spomky-labs/pki-framework/src/X509/Feature/DateTimeHelper.php  g  $u      c   vendor/spomky-labs/pki-framework/src/X509/CertificationPath/PathValidation/PathValidationConfig.php  g  U\      c   vendor/spomky-labs/pki-framework/src/X509/CertificationPath/PathValidation/PathValidationResult.php\  g\  c[      ]   vendor/spomky-labs/pki-framework/src/X509/CertificationPath/PathValidation/ValidatorState.php)  g)  0p      \   vendor/spomky-labs/pki-framework/src/X509/CertificationPath/PathValidation/PathValidator.phpB  gB  ~i      e   vendor/spomky-labs/pki-framework/src/X509/CertificationPath/PathBuilding/CertificationPathBuilder.php  g  h      _   vendor/spomky-labs/pki-framework/src/X509/CertificationPath/Exception/PathBuildingException.php  g  v      a   vendor/spomky-labs/pki-framework/src/X509/CertificationPath/Exception/PathValidationException.phpC  gC  Wb'      Q   vendor/spomky-labs/pki-framework/src/X509/CertificationPath/Policy/PolicyNode.phpT  gT  Rn      Q   vendor/spomky-labs/pki-framework/src/X509/CertificationPath/Policy/PolicyTree.php+5  g+5  1ؤ      Q   vendor/spomky-labs/pki-framework/src/X509/CertificationPath/CertificationPath.php  g  s      O   vendor/spomky-labs/pki-framework/src/X509/Exception/X509ValidationException.php   g   ?$      i   vendor/spomky-labs/pki-framework/src/X509/AttributeCertificate/Attribute/AccessIdentityAttributeValue.php5  g5  3c      Z   vendor/spomky-labs/pki-framework/src/X509/AttributeCertificate/Attribute/IetfAttrValue.php  g  f#       Y   vendor/spomky-labs/pki-framework/src/X509/AttributeCertificate/Attribute/SvceAuthInfo.php	  g	  Gh      m   vendor/spomky-labs/pki-framework/src/X509/AttributeCertificate/Attribute/AuthenticationInfoAttributeValue.phpN  gN  ˯Ť      k   vendor/spomky-labs/pki-framework/src/X509/AttributeCertificate/Attribute/ChargingIdentityAttributeValue.php  g  d      `   vendor/spomky-labs/pki-framework/src/X509/AttributeCertificate/Attribute/GroupAttributeValue.php  g  vR      [   vendor/spomky-labs/pki-framework/src/X509/AttributeCertificate/Attribute/IetfAttrSyntax.php  g        _   vendor/spomky-labs/pki-framework/src/X509/AttributeCertificate/Attribute/RoleAttributeValue.php  g  q1      M   vendor/spomky-labs/pki-framework/src/X509/AttributeCertificate/Attributes.php   g   pr      O   vendor/spomky-labs/pki-framework/src/X509/AttributeCertificate/IssuerSerial.php  g  hU      I   vendor/spomky-labs/pki-framework/src/X509/AttributeCertificate/Holder.php  g  pS      I   vendor/spomky-labs/pki-framework/src/X509/AttributeCertificate/V2Form.php  g  ~      [   vendor/spomky-labs/pki-framework/src/X509/AttributeCertificate/AttributeCertificateInfo.phpK&  gK&  lz      S   vendor/spomky-labs/pki-framework/src/X509/AttributeCertificate/ObjectDigestInfo.php	  g	  >      P   vendor/spomky-labs/pki-framework/src/X509/AttributeCertificate/AttCertIssuer.phpB  gB  y0      W   vendor/spomky-labs/pki-framework/src/X509/AttributeCertificate/AttributeCertificate.php  g        X   vendor/spomky-labs/pki-framework/src/X509/AttributeCertificate/AttCertValidityPeriod.php$  g$  t      Y   vendor/spomky-labs/pki-framework/src/X509/AttributeCertificate/Validation/ACValidator.php  g        m   vendor/spomky-labs/pki-framework/src/X509/AttributeCertificate/Validation/Exception/ACValidationException.php
  g
  K      `   vendor/spomky-labs/pki-framework/src/X509/AttributeCertificate/Validation/ACValidationConfig.php  g  6      W   vendor/spomky-labs/pki-framework/src/X509/CertificationRequest/CertificationRequest.php  g  `      b   vendor/spomky-labs/pki-framework/src/X509/CertificationRequest/Attribute/ExtensionRequestValue.phpD  gD  
      M   vendor/spomky-labs/pki-framework/src/X509/CertificationRequest/Attributes.php  g        [   vendor/spomky-labs/pki-framework/src/X509/CertificationRequest/CertificationRequestInfo.php  g  X      6   vendor/spomky-labs/pki-framework/src/X501/ASN1/RDN.php  g  u晤      @   vendor/spomky-labs/pki-framework/src/X501/ASN1/AttributeType.php@  g@  7P      R   vendor/spomky-labs/pki-framework/src/X501/ASN1/Collection/SequenceOfAttributes.php  g  xDc      M   vendor/spomky-labs/pki-framework/src/X501/ASN1/Collection/SetOfAttributes.php2  g2  %      Q   vendor/spomky-labs/pki-framework/src/X501/ASN1/Collection/AttributeCollection.php"  g"  ,L      <   vendor/spomky-labs/pki-framework/src/X501/ASN1/Attribute.php#  g#  9      S   vendor/spomky-labs/pki-framework/src/X501/ASN1/AttributeValue/LocalityNameValue.php  g  `      P   vendor/spomky-labs/pki-framework/src/X501/ASN1/AttributeValue/GivenNameValue.php  g  g      W   vendor/spomky-labs/pki-framework/src/X501/ASN1/AttributeValue/OrganizationNameValue.php  g  09      L   vendor/spomky-labs/pki-framework/src/X501/ASN1/AttributeValue/TitleValue.php  g  f2      S   vendor/spomky-labs/pki-framework/src/X501/ASN1/AttributeValue/SerialNumberValue.php  g  G      P   vendor/spomky-labs/pki-framework/src/X501/ASN1/AttributeValue/AttributeValue.php  g  Sg&      R   vendor/spomky-labs/pki-framework/src/X501/ASN1/AttributeValue/DescriptionValue.php  g  GϤ      R   vendor/spomky-labs/pki-framework/src/X501/ASN1/AttributeValue/CountryNameValue.php  g  k      Q   vendor/spomky-labs/pki-framework/src/X501/ASN1/AttributeValue/CommonNameValue.php  g  40L      N   vendor/spomky-labs/pki-framework/src/X501/ASN1/AttributeValue/SurnameValue.php  g  l      P   vendor/spomky-labs/pki-framework/src/X501/ASN1/AttributeValue/PseudonymValue.php  g        Z   vendor/spomky-labs/pki-framework/src/X501/ASN1/AttributeValue/StateOrProvinceNameValue.php  g  ˤ      ^   vendor/spomky-labs/pki-framework/src/X501/ASN1/AttributeValue/Feature/PrintableStringValue.php  g  Rp      Y   vendor/spomky-labs/pki-framework/src/X501/ASN1/AttributeValue/Feature/DirectoryString.php  g  W      W   vendor/spomky-labs/pki-framework/src/X501/ASN1/AttributeValue/UnknownAttributeValue.php<	  g<	  %U      ]   vendor/spomky-labs/pki-framework/src/X501/ASN1/AttributeValue/OrganizationalUnitNameValue.php  g  6ۺ      K   vendor/spomky-labs/pki-framework/src/X501/ASN1/AttributeValue/NameValue.php  g        H   vendor/spomky-labs/pki-framework/src/X501/ASN1/AttributeTypeAndValue.phpe  ge  z\      7   vendor/spomky-labs/pki-framework/src/X501/ASN1/Name.phpP  gP  :      9   vendor/spomky-labs/pki-framework/src/X501/DN/DNParser.phpd(  gd(        G   vendor/spomky-labs/pki-framework/src/X501/MatchingRule/MatchingRule.phpP  gP  ~j2      J   vendor/spomky-labs/pki-framework/src/X501/MatchingRule/CaseIgnoreMatch.php  g   Eʤ      I   vendor/spomky-labs/pki-framework/src/X501/MatchingRule/CaseExactMatch.php  g  }      Q   vendor/spomky-labs/pki-framework/src/X501/MatchingRule/StringPrepMatchingRule.php{  g{  峿      F   vendor/spomky-labs/pki-framework/src/X501/MatchingRule/BinaryMatch.php  g  	r      @   vendor/spomky-labs/pki-framework/src/X501/StringPrep/MapStep.phpn  gn  T      F   vendor/spomky-labs/pki-framework/src/X501/StringPrep/NormalizeStep.php
  g
  q      D   vendor/spomky-labs/pki-framework/src/X501/StringPrep/PrepareStep.php  g  o*      F   vendor/spomky-labs/pki-framework/src/X501/StringPrep/TranscodeStep.phpA	  gA	  B      F   vendor/spomky-labs/pki-framework/src/X501/StringPrep/CheckBidiStep.php  g  tId      G   vendor/spomky-labs/pki-framework/src/X501/StringPrep/StringPreparer.php  g  o<I      E   vendor/spomky-labs/pki-framework/src/X501/StringPrep/ProhibitStep.php  g        [   vendor/spomky-labs/pki-framework/src/X501/StringPrep/InsignificantNonSubstringSpaceStep.php!  g!  Q6|      O   vendor/spomky-labs/pki-framework/src/CryptoTypes/Signature/Ed25519Signature.php  g        M   vendor/spomky-labs/pki-framework/src/CryptoTypes/Signature/Ed448Signature.php  g  Pb      O   vendor/spomky-labs/pki-framework/src/CryptoTypes/Signature/GenericSignature.phpB  gB   ~      J   vendor/spomky-labs/pki-framework/src/CryptoTypes/Signature/ECSignature.php  g        K   vendor/spomky-labs/pki-framework/src/CryptoTypes/Signature/RSASignature.phpY  gY  ފ-      H   vendor/spomky-labs/pki-framework/src/CryptoTypes/Signature/Signature.php  g  U(      P   vendor/spomky-labs/pki-framework/src/CryptoTypes/Asymmetric/OneAsymmetricKey.php)  g)  NM@      d   vendor/spomky-labs/pki-framework/src/CryptoTypes/Asymmetric/Attribute/OneAsymmetricKeyAttributes.php  g  H      P   vendor/spomky-labs/pki-framework/src/CryptoTypes/Asymmetric/RSA/RSAPublicKey.php
  g
  3:      Q   vendor/spomky-labs/pki-framework/src/CryptoTypes/Asymmetric/RSA/RSAPrivateKey.phpO  gO  U      W   vendor/spomky-labs/pki-framework/src/CryptoTypes/Asymmetric/RSA/RSASSAPSSPrivateKey.phpj  gj  f*      N   vendor/spomky-labs/pki-framework/src/CryptoTypes/Asymmetric/EC/ECPublicKey.phpm  gm  Ҥ      O   vendor/spomky-labs/pki-framework/src/CryptoTypes/Asymmetric/EC/ECPrivateKey.php*  g*  QOM2      O   vendor/spomky-labs/pki-framework/src/CryptoTypes/Asymmetric/EC/ECConversion.php  g  Ғ      I   vendor/spomky-labs/pki-framework/src/CryptoTypes/Asymmetric/PublicKey.php3  g3  Zh      N   vendor/spomky-labs/pki-framework/src/CryptoTypes/Asymmetric/PrivateKeyInfo.php  g  Ln+      Y   vendor/spomky-labs/pki-framework/src/CryptoTypes/Asymmetric/RFC8410/RFC8410PrivateKey.phpj
  gj
  "      X   vendor/spomky-labs/pki-framework/src/CryptoTypes/Asymmetric/RFC8410/RFC8410PublicKey.php  g  ;.      ^   vendor/spomky-labs/pki-framework/src/CryptoTypes/Asymmetric/RFC8410/Curve448/X448PublicKey.php  g  O      _   vendor/spomky-labs/pki-framework/src/CryptoTypes/Asymmetric/RFC8410/Curve448/Ed448PublicKey.php  g  +/      _   vendor/spomky-labs/pki-framework/src/CryptoTypes/Asymmetric/RFC8410/Curve448/X448PrivateKey.php  g  Q      `   vendor/spomky-labs/pki-framework/src/CryptoTypes/Asymmetric/RFC8410/Curve448/Ed448PrivateKey.php  g  	      b   vendor/spomky-labs/pki-framework/src/CryptoTypes/Asymmetric/RFC8410/Curve25519/X25519PublicKey.php  g  .)      f   vendor/spomky-labs/pki-framework/src/CryptoTypes/Asymmetric/RFC8410/Curve25519/Curve25519PublicKey.php  g  4I      c   vendor/spomky-labs/pki-framework/src/CryptoTypes/Asymmetric/RFC8410/Curve25519/X25519PrivateKey.php  g  vV      g   vendor/spomky-labs/pki-framework/src/CryptoTypes/Asymmetric/RFC8410/Curve25519/Curve25519PrivateKey.php3  g3  D3      c   vendor/spomky-labs/pki-framework/src/CryptoTypes/Asymmetric/RFC8410/Curve25519/Ed25519PublicKey.php  g  ʙ      d   vendor/spomky-labs/pki-framework/src/CryptoTypes/Asymmetric/RFC8410/Curve25519/Ed25519PrivateKey.php  g  .:      M   vendor/spomky-labs/pki-framework/src/CryptoTypes/Asymmetric/PublicKeyInfo.php  g  3D      J   vendor/spomky-labs/pki-framework/src/CryptoTypes/Asymmetric/PrivateKey.php0  g0  Ix      d   vendor/spomky-labs/pki-framework/src/CryptoTypes/AlgorithmIdentifier/SpecificAlgorithmIdentifier.phpW  gW  y      \   vendor/spomky-labs/pki-framework/src/CryptoTypes/AlgorithmIdentifier/AlgorithmIdentifier.phpp  gp  %H      }   vendor/spomky-labs/pki-framework/src/CryptoTypes/AlgorithmIdentifier/Signature/SHA384WithRSAEncryptionAlgorithmIdentifier.php  g  O+      z   vendor/spomky-labs/pki-framework/src/CryptoTypes/AlgorithmIdentifier/Signature/MD2WithRSAEncryptionAlgorithmIdentifier.php  g  Qߕޤ      u   vendor/spomky-labs/pki-framework/src/CryptoTypes/AlgorithmIdentifier/Signature/ECDSAWithSHA256AlgorithmIdentifier.php  g  -      u   vendor/spomky-labs/pki-framework/src/CryptoTypes/AlgorithmIdentifier/Signature/ECDSAWithSHA224AlgorithmIdentifier.php  g  
      z   vendor/spomky-labs/pki-framework/src/CryptoTypes/AlgorithmIdentifier/Signature/MD5WithRSAEncryptionAlgorithmIdentifier.php  g  +      y   vendor/spomky-labs/pki-framework/src/CryptoTypes/AlgorithmIdentifier/Signature/RFC3279RSASignatureAlgorithmIdentifier.php  g  )af      z   vendor/spomky-labs/pki-framework/src/CryptoTypes/AlgorithmIdentifier/Signature/MD4WithRSAEncryptionAlgorithmIdentifier.php  g  wl      y   vendor/spomky-labs/pki-framework/src/CryptoTypes/AlgorithmIdentifier/Signature/RFC4055RSASignatureAlgorithmIdentifier.phpl  gl  _esԤ      u   vendor/spomky-labs/pki-framework/src/CryptoTypes/AlgorithmIdentifier/Signature/ECDSAWithSHA512AlgorithmIdentifier.php  g  6f{      r   vendor/spomky-labs/pki-framework/src/CryptoTypes/AlgorithmIdentifier/Signature/RSASignatureAlgorithmIdentifier.php  g  |Ǥ      }   vendor/spomky-labs/pki-framework/src/CryptoTypes/AlgorithmIdentifier/Signature/SHA256WithRSAEncryptionAlgorithmIdentifier.php  g  `%      s   vendor/spomky-labs/pki-framework/src/CryptoTypes/AlgorithmIdentifier/Signature/ECDSAWithSHA1AlgorithmIdentifier.php  g  bd      u   vendor/spomky-labs/pki-framework/src/CryptoTypes/AlgorithmIdentifier/Signature/ECDSAWithSHA384AlgorithmIdentifier.php  g  ,P      q   vendor/spomky-labs/pki-framework/src/CryptoTypes/AlgorithmIdentifier/Signature/ECSignatureAlgorithmIdentifier.php  g  _<      }   vendor/spomky-labs/pki-framework/src/CryptoTypes/AlgorithmIdentifier/Signature/SHA512WithRSAEncryptionAlgorithmIdentifier.php  g        {   vendor/spomky-labs/pki-framework/src/CryptoTypes/AlgorithmIdentifier/Signature/SHA1WithRSAEncryptionAlgorithmIdentifier.php  g  1      }   vendor/spomky-labs/pki-framework/src/CryptoTypes/AlgorithmIdentifier/Signature/SHA224WithRSAEncryptionAlgorithmIdentifier.php  g  &n      o   vendor/spomky-labs/pki-framework/src/CryptoTypes/AlgorithmIdentifier/Hash/HMACWithSHA224AlgorithmIdentifier.php  g  Ф      g   vendor/spomky-labs/pki-framework/src/CryptoTypes/AlgorithmIdentifier/Hash/SHA224AlgorithmIdentifier.php  g  1]̤      o   vendor/spomky-labs/pki-framework/src/CryptoTypes/AlgorithmIdentifier/Hash/HMACWithSHA256AlgorithmIdentifier.php  g  L      g   vendor/spomky-labs/pki-framework/src/CryptoTypes/AlgorithmIdentifier/Hash/SHA256AlgorithmIdentifier.php  g  F      l   vendor/spomky-labs/pki-framework/src/CryptoTypes/AlgorithmIdentifier/Hash/RFC4231HMACAlgorithmIdentifier.phps  gs  TE      o   vendor/spomky-labs/pki-framework/src/CryptoTypes/AlgorithmIdentifier/Hash/HMACWithSHA512AlgorithmIdentifier.php  g  N      g   vendor/spomky-labs/pki-framework/src/CryptoTypes/AlgorithmIdentifier/Hash/SHA512AlgorithmIdentifier.php  g  Iˤ      m   vendor/spomky-labs/pki-framework/src/CryptoTypes/AlgorithmIdentifier/Hash/HMACWithSHA1AlgorithmIdentifier.php  g  l	d      e   vendor/spomky-labs/pki-framework/src/CryptoTypes/AlgorithmIdentifier/Hash/SHA2AlgorithmIdentifier.php  g  	      d   vendor/spomky-labs/pki-framework/src/CryptoTypes/AlgorithmIdentifier/Hash/MD5AlgorithmIdentifier.php  g  :      e   vendor/spomky-labs/pki-framework/src/CryptoTypes/AlgorithmIdentifier/Hash/SHA1AlgorithmIdentifier.phpy  gy        o   vendor/spomky-labs/pki-framework/src/CryptoTypes/AlgorithmIdentifier/Hash/HMACWithSHA384AlgorithmIdentifier.php  g  /4      g   vendor/spomky-labs/pki-framework/src/CryptoTypes/AlgorithmIdentifier/Hash/SHA384AlgorithmIdentifier.php  g  MaA4      i   vendor/spomky-labs/pki-framework/src/CryptoTypes/AlgorithmIdentifier/Cipher/RC2CBCAlgorithmIdentifier.php  g        m   vendor/spomky-labs/pki-framework/src/CryptoTypes/AlgorithmIdentifier/Cipher/DESEDE3CBCAlgorithmIdentifier.phpg  gg  p      l   vendor/spomky-labs/pki-framework/src/CryptoTypes/AlgorithmIdentifier/Cipher/AES192CBCAlgorithmIdentifier.php  g        i   vendor/spomky-labs/pki-framework/src/CryptoTypes/AlgorithmIdentifier/Cipher/AESCBCAlgorithmIdentifier.php  g  qz      i   vendor/spomky-labs/pki-framework/src/CryptoTypes/AlgorithmIdentifier/Cipher/CipherAlgorithmIdentifier.php8  g8   "¤      i   vendor/spomky-labs/pki-framework/src/CryptoTypes/AlgorithmIdentifier/Cipher/DESCBCAlgorithmIdentifier.php  g  HY      n   vendor/spomky-labs/pki-framework/src/CryptoTypes/AlgorithmIdentifier/Cipher/BlockCipherAlgorithmIdentifier.phpd  gd  ~      l   vendor/spomky-labs/pki-framework/src/CryptoTypes/AlgorithmIdentifier/Cipher/AES128CBCAlgorithmIdentifier.php|  g|  Wϸ      l   vendor/spomky-labs/pki-framework/src/CryptoTypes/AlgorithmIdentifier/Cipher/AES256CBCAlgorithmIdentifier.php  g  |Ĥ      r   vendor/spomky-labs/pki-framework/src/CryptoTypes/AlgorithmIdentifier/Asymmetric/ECPublicKeyAlgorithmIdentifier.php/  g/  D      m   vendor/spomky-labs/pki-framework/src/CryptoTypes/AlgorithmIdentifier/Asymmetric/X25519AlgorithmIdentifier.php+  g+  0Ŕ      k   vendor/spomky-labs/pki-framework/src/CryptoTypes/AlgorithmIdentifier/Asymmetric/X448AlgorithmIdentifier.php#  g#  oœ#      p   vendor/spomky-labs/pki-framework/src/CryptoTypes/AlgorithmIdentifier/Asymmetric/RFC8410EdAlgorithmIdentifier.php  g   ߎ      t   vendor/spomky-labs/pki-framework/src/CryptoTypes/AlgorithmIdentifier/Asymmetric/RSAEncryptionAlgorithmIdentifier.php  g  seR      l   vendor/spomky-labs/pki-framework/src/CryptoTypes/AlgorithmIdentifier/Asymmetric/Ed448AlgorithmIdentifier.php  g  ְ      o   vendor/spomky-labs/pki-framework/src/CryptoTypes/AlgorithmIdentifier/Asymmetric/RFC8410XAlgorithmIdentifier.php  g  L~.      z   vendor/spomky-labs/pki-framework/src/CryptoTypes/AlgorithmIdentifier/Asymmetric/RSAPSSSSAEncryptionAlgorithmIdentifier.php  g  Z      n   vendor/spomky-labs/pki-framework/src/CryptoTypes/AlgorithmIdentifier/Asymmetric/Ed25519AlgorithmIdentifier.php  g         c   vendor/spomky-labs/pki-framework/src/CryptoTypes/AlgorithmIdentifier/AlgorithmIdentifierFactory.php$  g$  #ꨤ      m   vendor/spomky-labs/pki-framework/src/CryptoTypes/AlgorithmIdentifier/Feature/SignatureAlgorithmIdentifier.php  g  3!      g   vendor/spomky-labs/pki-framework/src/CryptoTypes/AlgorithmIdentifier/Feature/PRFAlgorithmIdentifier.php   g   !$      t   vendor/spomky-labs/pki-framework/src/CryptoTypes/AlgorithmIdentifier/Feature/AsymmetricCryptoAlgorithmIdentifier.php
  g
  C      h   vendor/spomky-labs/pki-framework/src/CryptoTypes/AlgorithmIdentifier/Feature/HashAlgorithmIdentifier.php   g   &-      n   vendor/spomky-labs/pki-framework/src/CryptoTypes/AlgorithmIdentifier/Feature/EncryptionAlgorithmIdentifier.php   g   bO      h   vendor/spomky-labs/pki-framework/src/CryptoTypes/AlgorithmIdentifier/Feature/AlgorithmIdentifierType.phpy  gy  l̤      d   vendor/spomky-labs/pki-framework/src/CryptoTypes/AlgorithmIdentifier/AlgorithmIdentifierProvider.php  g  k\d      c   vendor/spomky-labs/pki-framework/src/CryptoTypes/AlgorithmIdentifier/GenericAlgorithmIdentifier.php  g  CI	          vendor/spomky-labs/otphp/LICENSE@  g@  xi      "   vendor/spomky-labs/otphp/README.md%  g%  z@      &   vendor/spomky-labs/otphp/composer.json  g  ;       $   vendor/spomky-labs/otphp/SECURITY.md  g  ?	m      %   vendor/spomky-labs/otphp/src/TOTP.php  g  >s?      (   vendor/spomky-labs/otphp/src/Factory.php+  g+  0$      -   vendor/spomky-labs/otphp/src/OTPInterface.php
  g
  zr      .   vendor/spomky-labs/otphp/src/TOTPInterface.php  g  *      $   vendor/spomky-labs/otphp/src/OTP.php  g  B      %   vendor/spomky-labs/otphp/src/HOTP.php=
  g=
  hct      .   vendor/spomky-labs/otphp/src/HOTPInterface.php=  g=  ߤ      1   vendor/spomky-labs/otphp/src/FactoryInterface.phpr  gr  ¤      /   vendor/spomky-labs/otphp/src/ParameterTrait.php  g  da&      $   vendor/spomky-labs/otphp/src/Url.php#
  g#
  >쐡      .   vendor/spomky-labs/otphp/src/InternalClock.php5  g5  GƤ      $   vendor/doctrine/deprecations/LICENSE)  g)  "0      &   vendor/doctrine/deprecations/README.md
  g
  {      *   vendor/doctrine/deprecations/composer.json  g  x+      ?   vendor/doctrine/deprecations/src/PHPUnit/VerifyDeprecations.php  g  V      0   vendor/doctrine/deprecations/src/Deprecation.php$  g$  )         vendor/firebase/php-jwt/LICENSE  g  #      $   vendor/firebase/php-jwt/CHANGELOG.md'  g'  ާ      !   vendor/firebase/php-jwt/README.md4  g4        %   vendor/firebase/php-jwt/composer.json  g  ܤ      9   vendor/firebase/php-jwt/src/SignatureInvalidException.phpu   gu   Ͻ      4   vendor/firebase/php-jwt/src/BeforeValidException.phpt  gt  u0      ,   vendor/firebase/php-jwt/src/CachedKeySet.php  g   ؤ      #   vendor/firebase/php-jwt/src/Key.php  g  lx+      #   vendor/firebase/php-jwt/src/JWK.phpA,  gA,        @   vendor/firebase/php-jwt/src/JWTExceptionWithPayloadInterface.php  g  ky      0   vendor/firebase/php-jwt/src/ExpiredException.phpp  gp  7      #   vendor/firebase/php-jwt/src/JWT.php\  g\  X
w         vendor/brick/math/LICENSEA  gA  ݸL         vendor/brick/math/CHANGELOG.mdL  gL  K/%      $   vendor/brick/math/psalm-baseline.xml	  g	           vendor/brick/math/composer.jsonR  gR  IG      &   vendor/brick/math/src/RoundingMode.php
  g
        ;   vendor/brick/math/src/Internal/Calculator/GmpCalculator.php'
  g'
  ;0      >   vendor/brick/math/src/Internal/Calculator/BcMathCalculator.php  g  ,1      >   vendor/brick/math/src/Internal/Calculator/NativeCalculator.php7  g7  #.      -   vendor/brick/math/src/Internal/Calculator.phpI  gI  }      $   vendor/brick/math/src/BigInteger.php0  g0  d2      #   vendor/brick/math/src/BigNumber.php>  g>  Eä      $   vendor/brick/math/src/BigDecimal.phpV  gV  M@Ƥ      1   vendor/brick/math/src/Exception/MathException.php   g   E:      9   vendor/brick/math/src/Exception/NumberFormatException.php  g  ojQ      ;   vendor/brick/math/src/Exception/NegativeNumberException.php  g  +;      ;   vendor/brick/math/src/Exception/DivisionByZeroException.php  g  Ɓj      <   vendor/brick/math/src/Exception/IntegerOverflowException.php,  g,  1C>*      >   vendor/brick/math/src/Exception/RoundingNecessaryException.php  g  A      %   vendor/brick/math/src/BigRational.php.  g.  2h      (   vendor/justinrainbow/json-schema/LICENSE   g         2   vendor/justinrainbow/json-schema/bin/validate-json  g        F   vendor/justinrainbow/json-schema/dist/schema/json-schema-draft-03.json  g  -aߤ      F   vendor/justinrainbow/json-schema/dist/schema/json-schema-draft-04.json  g  Nߤ      *   vendor/justinrainbow/json-schema/README.mdz  gz  ˱      .   vendor/justinrainbow/json-schema/composer.json  g  7      ;   vendor/justinrainbow/json-schema/src/JsonSchema/Rfc3339.php  g  ̤      =   vendor/justinrainbow/json-schema/src/JsonSchema/Validator.php
  g
         I   vendor/justinrainbow/json-schema/src/JsonSchema/UriRetrieverInterface.php  g  hJ      P   vendor/justinrainbow/json-schema/src/JsonSchema/Constraints/ObjectConstraint.php{  g{  =6      G   vendor/justinrainbow/json-schema/src/JsonSchema/Constraints/Factory.php  g  ߤ      P   vendor/justinrainbow/json-schema/src/JsonSchema/Constraints/NumberConstraint.php
  g
  Uj      N   vendor/justinrainbow/json-schema/src/JsonSchema/Constraints/TypeConstraint.php  g  MY      N   vendor/justinrainbow/json-schema/src/JsonSchema/Constraints/BaseConstraint.php   g   ֤      N   vendor/justinrainbow/json-schema/src/JsonSchema/Constraints/EnumConstraint.php  g  l$М      P   vendor/justinrainbow/json-schema/src/JsonSchema/Constraints/StringConstraint.php  g  ^      S   vendor/justinrainbow/json-schema/src/JsonSchema/Constraints/ConstraintInterface.php3  g3  9¤      T   vendor/justinrainbow/json-schema/src/JsonSchema/Constraints/CollectionConstraint.php  g  5q      J   vendor/justinrainbow/json-schema/src/JsonSchema/Constraints/Constraint.php  g  d5      P   vendor/justinrainbow/json-schema/src/JsonSchema/Constraints/FormatConstraint.php.#  g.#  '      \   vendor/justinrainbow/json-schema/src/JsonSchema/Constraints/TypeCheck/TypeCheckInterface.php  g  y      Y   vendor/justinrainbow/json-schema/src/JsonSchema/Constraints/TypeCheck/StrictTypeCheck.php:  g:  *9      X   vendor/justinrainbow/json-schema/src/JsonSchema/Constraints/TypeCheck/LooseTypeCheck.php  g  r(      S   vendor/justinrainbow/json-schema/src/JsonSchema/Constraints/UndefinedConstraint.php<  g<  U>      P   vendor/justinrainbow/json-schema/src/JsonSchema/Constraints/SchemaConstraint.php!  g!        F   vendor/justinrainbow/json-schema/src/JsonSchema/Entity/JsonPointer.php4
  g4
        H   vendor/justinrainbow/json-schema/src/JsonSchema/UriResolverInterface.php   g   "      K   vendor/justinrainbow/json-schema/src/JsonSchema/Iterator/ObjectIterator.php
  g
  hl      A   vendor/justinrainbow/json-schema/src/JsonSchema/SchemaStorage.php  g  Nq      X   vendor/justinrainbow/json-schema/src/JsonSchema/Uri/Retrievers/UriRetrieverInterface.php  g  -,      T   vendor/justinrainbow/json-schema/src/JsonSchema/Uri/Retrievers/AbstractRetriever.php  g  _Ǥ      G   vendor/justinrainbow/json-schema/src/JsonSchema/Uri/Retrievers/Curl.php  g  x(      R   vendor/justinrainbow/json-schema/src/JsonSchema/Uri/Retrievers/FileGetContents.php^
  g^
        R   vendor/justinrainbow/json-schema/src/JsonSchema/Uri/Retrievers/PredefinedArray.php
  g
  /8      D   vendor/justinrainbow/json-schema/src/JsonSchema/Uri/UriRetriever.php$  g$  Aq      C   vendor/justinrainbow/json-schema/src/JsonSchema/Uri/UriResolver.php  g  _9<      W   vendor/justinrainbow/json-schema/src/JsonSchema/Exception/ResourceNotFoundException.phpb  gb  `      P   vendor/justinrainbow/json-schema/src/JsonSchema/Exception/ExceptionInterface.phpX   gX   [      N   vendor/justinrainbow/json-schema/src/JsonSchema/Exception/RuntimeException.phpo  go  Cr      W   vendor/justinrainbow/json-schema/src/JsonSchema/Exception/InvalidSourceUriException.phpj  gj  *5      V   vendor/justinrainbow/json-schema/src/JsonSchema/Exception/InvalidArgumentException.php  g  N      ^   vendor/justinrainbow/json-schema/src/JsonSchema/Exception/UnresolvableJsonPointerException.php  g  ZHe      Q   vendor/justinrainbow/json-schema/src/JsonSchema/Exception/ValidationException.php'  g'  Aj      T   vendor/justinrainbow/json-schema/src/JsonSchema/Exception/InvalidConfigException.php_  g_  P      S   vendor/justinrainbow/json-schema/src/JsonSchema/Exception/JsonDecodingException.php  g  nW      T   vendor/justinrainbow/json-schema/src/JsonSchema/Exception/InvalidSchemaException.php\  g\  @S6      R   vendor/justinrainbow/json-schema/src/JsonSchema/Exception/UriResolverException.phpX  gX  Ӕ      ]   vendor/justinrainbow/json-schema/src/JsonSchema/Exception/InvalidSchemaMediaTypeException.phpe  ge  U3$      J   vendor/justinrainbow/json-schema/src/JsonSchema/SchemaStorageInterface.php.  g.  VԠg      1   vendor/crell/api-problem/docker/php/81/Dockerfile   g   D1      1   vendor/crell/api-problem/docker/php/81/xdebug.inil   gl   b0      >   vendor/crell/api-problem/docker/php/conf.d/error_reporting.ini   g   lc¤      !   vendor/crell/api-problem/Makefile]  g]  Zib      *   vendor/crell/api-problem/phpstan.neon.dist0   g0   b      +   vendor/crell/api-problem/docker-compose.ymlb  gb  Ruv      &   vendor/crell/api-problem/composer.json  g  VN+      $   vendor/crell/api-problem/SECURITY.mdw	  gw	  _yU      %   vendor/crell/api-problem/default-.env  g  ]h	Q      4   vendor/crell/api-problem/src/JsonEncodeException.php   g   ewF      .   vendor/crell/api-problem/src/HttpConverter.php6
  g6
  1B      3   vendor/crell/api-problem/src/JsonParseException.phpH  gH  %P(      .   vendor/crell/api-problem/src/JsonException.php  g  5-      +   vendor/crell/api-problem/src/ApiProblem.phpdH  gdH  'M         vendor/psr/cache/CHANGELOG.md  g  -	G         vendor/psr/cache/README.md"  g"  (AcӤ         vendor/psr/cache/LICENSE.txt8  g8  Df         vendor/psr/cache/composer.json4  g4  C      /   vendor/psr/cache/src/CacheItemPoolInterface.php  g  Y      +   vendor/psr/cache/src/CacheItemInterface.php&  g&  =b      1   vendor/psr/cache/src/InvalidArgumentException.php:  g:  MY      '   vendor/psr/cache/src/CacheException.php   g   BJ      #   vendor/psr/event-dispatcher/LICENSE(  g(  }]      %   vendor/psr/event-dispatcher/README.mdE  gE  S      )   vendor/psr/event-dispatcher/composer.jsonb  gb  q      =   vendor/psr/event-dispatcher/src/ListenerProviderInterface.php  g  bh      <   vendor/psr/event-dispatcher/src/EventDispatcherInterface.php  g        ;   vendor/psr/event-dispatcher/src/StoppableEventInterface.php!  g!  T>q         vendor/psr/http-message/LICENSE=  g=        $   vendor/psr/http-message/CHANGELOG.md3  g3  :\Y      !   vendor/psr/http-message/README.md  g        %   vendor/psr/http-message/composer.json  g  7      6   vendor/psr/http-message/src/ServerRequestInterface.phpH(  gH(  #      ,   vendor/psr/http-message/src/UriInterface.php/2  g/2  קY      /   vendor/psr/http-message/src/StreamInterface.php  g        5   vendor/psr/http-message/src/UploadedFileInterface.php  g  	      0   vendor/psr/http-message/src/RequestInterface.phpG  gG  ir      1   vendor/psr/http-message/src/ResponseInterface.phpZ
  gZ
  aG      0   vendor/psr/http-message/src/MessageInterface.php  g  |C         vendor/psr/container/LICENSEy  gy  Op         vendor/psr/container/README.mdB  gB  g?      "   vendor/psr/container/composer.json  g  nY      7   vendor/psr/container/src/NotFoundExceptionInterface.php   g   B@      /   vendor/psr/container/src/ContainerInterface.php%  g%  )      8   vendor/psr/container/src/ContainerExceptionInterface.php   g              vendor/psr/http-client/LICENSE=  g=  S      #   vendor/psr/http-client/CHANGELOG.md  g  z򪌤          vendor/psr/http-client/README.md%  g%  F      $   vendor/psr/http-client/composer.json  g  bϤ      8   vendor/psr/http-client/src/NetworkExceptionInterface.php  g  6SB      8   vendor/psr/http-client/src/RequestExceptionInterface.phph  gh  *c=      .   vendor/psr/http-client/src/ClientInterface.php!  g!  {0      7   vendor/psr/http-client/src/ClientExceptionInterface.php   g   xz         vendor/psr/log/LICENSE=  g=  pO         vendor/psr/log/README.mdB  gB  '         vendor/psr/log/composer.json`  g`  ],      +   vendor/psr/log/src/LoggerAwareInterface.php   g   ow         vendor/psr/log/src/LogLevel.phpH  gH  u      '   vendor/psr/log/src/LoggerAwareTrait.phpj  gj  dz      /   vendor/psr/log/src/InvalidArgumentException.phpo   go   MWd      !   vendor/psr/log/src/NullLogger.php  g   <      &   vendor/psr/log/src/LoggerInterface.php
  g
  c=      "   vendor/psr/log/src/LoggerTrait.php
  g
  
      %   vendor/psr/log/src/AbstractLogger.php  g  q         vendor/psr/clock/LICENSE8  g8  l         vendor/psr/clock/CHANGELOG.md   g   <         vendor/psr/clock/README.md  g  GL[         vendor/psr/clock/composer.json2  g2  $DCM      '   vendor/psr/clock/src/ClockInterface.php   g   H%         vendor/psr/http-factory/LICENSE(  g(  }]      !   vendor/psr/http-factory/README.md,  g,  zwf      %   vendor/psr/http-factory/composer.json8  g8        8   vendor/psr/http-factory/src/ResponseFactoryInterface.php2  g2  ձ}      6   vendor/psr/http-factory/src/StreamFactoryInterface.php  g  e      <   vendor/psr/http-factory/src/UploadedFileFactoryInterface.phpJ  gJ  nʉ      3   vendor/psr/http-factory/src/UriFactoryInterface.phpU  gU        =   vendor/psr/http-factory/src/ServerRequestFactoryInterface.php  g  w9      7   vendor/psr/http-factory/src/RequestFactoryInterface.php  g  4(         vendor/monolog/monolog/LICENSE'  g'        #   vendor/monolog/monolog/CHANGELOG.md  g  䳑          vendor/monolog/monolog/README.mdA  gA  o      $   vendor/monolog/monolog/composer.json3
  g3
        >   vendor/monolog/monolog/src/Monolog/Handler/SendGridHandler.php  g   i      @   vendor/monolog/monolog/src/Monolog/Handler/InsightOpsHandler.php  g  &      :   vendor/monolog/monolog/src/Monolog/Handler/TestHandler.php  g  )Bs      ;   vendor/monolog/monolog/src/Monolog/Handler/IFTTTHandler.php  g  ps      H   vendor/monolog/monolog/src/Monolog/Handler/WebRequestRecognizerTrait.php  g  cJ      <   vendor/monolog/monolog/src/Monolog/Handler/SocketHandler.phpY/  gY/  q]      C   vendor/monolog/monolog/src/Monolog/Handler/SymfonyMailerHandler.phpJ  gJ  H      :   vendor/monolog/monolog/src/Monolog/Handler/NoopHandler.php  g  :      <   vendor/monolog/monolog/src/Monolog/Handler/BufferHandler.php	  g	  7q      <   vendor/monolog/monolog/src/Monolog/Handler/SyslogHandler.php  g  ~      =   vendor/monolog/monolog/src/Monolog/Handler/RollbarHandler.php
  g
  kVʤ      D   vendor/monolog/monolog/src/Monolog/Handler/FingersCrossedHandler.phpz   gz   U6X      >   vendor/monolog/monolog/src/Monolog/Handler/OverflowHandler.php  g  8      =   vendor/monolog/monolog/src/Monolog/Handler/HandlerWrapper.phpO
  gO
        Y   vendor/monolog/monolog/src/Monolog/Handler/FingersCrossed/ActivationStrategyInterface.php  g  z.      Z   vendor/monolog/monolog/src/Monolog/Handler/FingersCrossed/ErrorLevelActivationStrategy.php  g         \   vendor/monolog/monolog/src/Monolog/Handler/FingersCrossed/ChannelLevelActivationStrategy.php	  g	  ;Ӥ      ;   vendor/monolog/monolog/src/Monolog/Handler/GroupHandler.php  g  Y      C   vendor/monolog/monolog/src/Monolog/Handler/ElasticsearchHandler.php  g         >   vendor/monolog/monolog/src/Monolog/Handler/SamplingHandler.phpz  gz  E^      6   vendor/monolog/monolog/src/Monolog/Handler/Handler.php  g  |      >   vendor/monolog/monolog/src/Monolog/Handler/AbstractHandler.php
  g
  7m      >   vendor/monolog/monolog/src/Monolog/Handler/FlowdockHandler.phpG
  gG
  
B      >   vendor/monolog/monolog/src/Monolog/Handler/PushoverHandler.phpJ  gJ  1      J   vendor/monolog/monolog/src/Monolog/Handler/ProcessableHandlerInterface.php  g  'W      H   vendor/monolog/monolog/src/Monolog/Handler/MissingExtensionException.php  g   
l      D   vendor/monolog/monolog/src/Monolog/Handler/AbstractSyslogHandler.php  g  
$      ?   vendor/monolog/monolog/src/Monolog/Handler/SyslogUdpHandler.php4  g4        D   vendor/monolog/monolog/src/Monolog/Handler/BrowserConsoleHandler.php$  g$   Aߤ      <   vendor/monolog/monolog/src/Monolog/Handler/FilterHandler.php  g        9   vendor/monolog/monolog/src/Monolog/Handler/SqsHandler.php  g  -
M      B   vendor/monolog/monolog/src/Monolog/Handler/RotatingFileHandler.php>  g>  ^n      C   vendor/monolog/monolog/src/Monolog/Handler/FallbackGroupHandler.php  g  <      B   vendor/monolog/monolog/src/Monolog/Handler/NativeMailerHandler.php  g  }      =   vendor/monolog/monolog/src/Monolog/Handler/MongoDBHandler.php	  g	  nD      =   vendor/monolog/monolog/src/Monolog/Handler/ProcessHandler.phpU  gU  ٤      F   vendor/monolog/monolog/src/Monolog/Handler/FormattableHandlerTrait.php  g  N'x~      :   vendor/monolog/monolog/src/Monolog/Handler/GelfHandler.php  g  ca      A   vendor/monolog/monolog/src/Monolog/Handler/ZendMonitorHandler.php  g        @   vendor/monolog/monolog/src/Monolog/Handler/PHPConsoleHandler.phpQ0  gQ0  v֤      >   vendor/monolog/monolog/src/Monolog/Handler/ErrorLogHandler.php
  g
  nXk      @   vendor/monolog/monolog/src/Monolog/Handler/LogEntriesHandler.php  g  D      >   vendor/monolog/monolog/src/Monolog/Handler/LogmaticHandler.php	  g	  go      C   vendor/monolog/monolog/src/Monolog/Handler/DeduplicationHandler.phpY  gY  h      =   vendor/monolog/monolog/src/Monolog/Handler/FirePHPHandler.php  g        8   vendor/monolog/monolog/src/Monolog/Handler/Curl/Util.php  g  ɤ      E   vendor/monolog/monolog/src/Monolog/Handler/DoctrineCouchDBHandler.php  g  O!֤      >   vendor/monolog/monolog/src/Monolog/Handler/DynamoDbHandler.php  g  %Tg      J   vendor/monolog/monolog/src/Monolog/Handler/FormattableHandlerInterface.php  g        A   vendor/monolog/monolog/src/Monolog/Handler/RedisPubSubHandler.php  g  ޤ      :   vendor/monolog/monolog/src/Monolog/Handler/MailHandler.php  g  Nv      <   vendor/monolog/monolog/src/Monolog/Handler/StreamHandler.php5   g5   EW      <   vendor/monolog/monolog/src/Monolog/Handler/LogglyHandler.phpa  ga  Ӥ      B   vendor/monolog/monolog/src/Monolog/Handler/SlackWebhookHandler.php  g  Kdﮤ      >   vendor/monolog/monolog/src/Monolog/Handler/ElasticaHandler.php  g        F   vendor/monolog/monolog/src/Monolog/Handler/WhatFailureGroupHandler.php  g  f      ?   vendor/monolog/monolog/src/Monolog/Handler/ChromePHPHandler.php/  g/  m      @   vendor/monolog/monolog/src/Monolog/Handler/Slack/SlackRecord.php'  g'        9   vendor/monolog/monolog/src/Monolog/Handler/PsrHandler.php	  g	  |cU      >   vendor/monolog/monolog/src/Monolog/Handler/NewRelicHandler.php)  g)  ̤      F   vendor/monolog/monolog/src/Monolog/Handler/ProcessableHandlerTrait.php  g  PK      ?   vendor/monolog/monolog/src/Monolog/Handler/HandlerInterface.php
  g
  2      ;   vendor/monolog/monolog/src/Monolog/Handler/SlackHandler.php  g  '      ?   vendor/monolog/monolog/src/Monolog/Handler/FleepHookHandler.phpI
  gI
   T      :   vendor/monolog/monolog/src/Monolog/Handler/NullHandler.php|  g|  Wb      :   vendor/monolog/monolog/src/Monolog/Handler/AmqpHandler.php%  g%  paĤ      A   vendor/monolog/monolog/src/Monolog/Handler/TelegramBotHandler.php$  g$  39      >   vendor/monolog/monolog/src/Monolog/Handler/MandrillHandler.php
  g
  \+w      H   vendor/monolog/monolog/src/Monolog/Handler/AbstractProcessingHandler.php  g  cl      =   vendor/monolog/monolog/src/Monolog/Handler/CouchDBHandler.php	  g	  (ٌ      ;   vendor/monolog/monolog/src/Monolog/Handler/RedisHandler.php
  g
        :   vendor/monolog/monolog/src/Monolog/Handler/CubeHandler.phpF  gF  !fB      B   vendor/monolog/monolog/src/Monolog/Handler/SyslogUdp/UdpSocket.php  g  bH      H   vendor/monolog/monolog/src/Monolog/JsonSerializableDateTimeImmutable.php  g  kܤ      -   vendor/monolog/monolog/src/Monolog/Logger.php;Y  g;Y  {      C   vendor/monolog/monolog/src/Monolog/Attribute/AsMonologProcessor.php  g  b      C   vendor/monolog/monolog/src/Monolog/Attribute/WithMonologChannel.php  g  GL      8   vendor/monolog/monolog/src/Monolog/DateTimeImmutable.phph  gh  x\G      4   vendor/monolog/monolog/src/Monolog/Test/TestCase.php  g  Fԧc      /   vendor/monolog/monolog/src/Monolog/Registry.php  g  =      B   vendor/monolog/monolog/src/Monolog/Processor/HostnameProcessor.php  g  	'1      G   vendor/monolog/monolog/src/Monolog/Processor/PsrLogMessageProcessor.phpI  gI        =   vendor/monolog/monolog/src/Monolog/Processor/WebProcessor.phpU
  gU
  8      I   vendor/monolog/monolog/src/Monolog/Processor/MemoryPeakUsageProcessor.php|  g|  _`x      C   vendor/monolog/monolog/src/Monolog/Processor/ProcessIdProcessor.php  g  +@      E   vendor/monolog/monolog/src/Monolog/Processor/LoadAverageProcessor.php\  g\  s      H   vendor/monolog/monolog/src/Monolog/Processor/ClosureContextProcessor.php  g  :Eg      C   vendor/monolog/monolog/src/Monolog/Processor/MercurialProcessor.php  g  O      =   vendor/monolog/monolog/src/Monolog/Processor/TagProcessor.php  g  G?o      =   vendor/monolog/monolog/src/Monolog/Processor/GitProcessor.php  g  \@      @   vendor/monolog/monolog/src/Monolog/Processor/MemoryProcessor.php  g  )      G   vendor/monolog/monolog/src/Monolog/Processor/IntrospectionProcessor.php\  g\  h      =   vendor/monolog/monolog/src/Monolog/Processor/UidProcessor.php  g  Hz      C   vendor/monolog/monolog/src/Monolog/Processor/ProcessorInterface.php]  g]  l(      E   vendor/monolog/monolog/src/Monolog/Processor/MemoryUsageProcessor.phpi  gi  3;w      :   vendor/monolog/monolog/src/Monolog/ResettableInterface.php  g  Z̤      4   vendor/monolog/monolog/src/Monolog/SignalHandler.phpZ  gZ  N      ,   vendor/monolog/monolog/src/Monolog/Level.php  g  c#      B   vendor/monolog/monolog/src/Monolog/Formatter/LogmaticFormatter.php;  g;  
ؤ      B   vendor/monolog/monolog/src/Monolog/Formatter/ElasticaFormatter.php  g  e      >   vendor/monolog/monolog/src/Monolog/Formatter/LineFormatter.php&  g&  D;      >   vendor/monolog/monolog/src/Monolog/Formatter/JsonFormatter.phpm  gm  l S      B   vendor/monolog/monolog/src/Monolog/Formatter/FlowdockFormatter.phpC	  gC	  mӼ      C   vendor/monolog/monolog/src/Monolog/Formatter/FormatterInterface.php  g  ̍Q      B   vendor/monolog/monolog/src/Monolog/Formatter/LogstashFormatter.phpQ
  gQ
  n@      @   vendor/monolog/monolog/src/Monolog/Formatter/LogglyFormatter.php  g  א      G   vendor/monolog/monolog/src/Monolog/Formatter/ElasticsearchFormatter.phpI  gI  4      @   vendor/monolog/monolog/src/Monolog/Formatter/ScalarFormatter.php  g  Pa      A   vendor/monolog/monolog/src/Monolog/Formatter/MongoDBFormatter.php  g  դ      C   vendor/monolog/monolog/src/Monolog/Formatter/ChromePHPFormatter.php  g        A   vendor/monolog/monolog/src/Monolog/Formatter/FluentdFormatter.php  g  (QG      E   vendor/monolog/monolog/src/Monolog/Formatter/GelfMessageFormatter.phpO  gO  H      B   vendor/monolog/monolog/src/Monolog/Formatter/WildfireFormatter.php  g  :      L   vendor/monolog/monolog/src/Monolog/Formatter/GoogleCloudLoggingFormatter.php  g        @   vendor/monolog/monolog/src/Monolog/Formatter/SyslogFormatter.php  g  氂      D   vendor/monolog/monolog/src/Monolog/Formatter/NormalizerFormatter.php'  g'  6xq      >   vendor/monolog/monolog/src/Monolog/Formatter/HtmlFormatter.php  g  x       0   vendor/monolog/monolog/src/Monolog/LogRecord.php
  g
  
      3   vendor/monolog/monolog/src/Monolog/ErrorHandler.php'  g'  4_      ,   vendor/monolog/monolog/src/Monolog/Utils.phpr"  gr"  c      !   vendor/studio24/rotate/LICENSE.md>  g>  3ä      "   vendor/studio24/rotate/phpunit.xml   g   gE          vendor/studio24/rotate/README.md  g  ?/      $   vendor/studio24/rotate/composer.json  g  WѤ      .   vendor/studio24/rotate/src/RotateException.php_   g_    ;      %   vendor/studio24/rotate/src/Rotate.php#  g#  j      -   vendor/studio24/rotate/src/FilenameFormat.php  g  =D      -   vendor/studio24/rotate/src/RotateAbstract.php  g  D      6   vendor/studio24/rotate/src/FilenameFormatException.phpg   gg   ܙ      %   vendor/studio24/rotate/src/Delete.php|#  g|#  ؤ      0   vendor/studio24/rotate/src/DirectoryIterator.phpk  gk  mA      G   vendor/symfony/framework-bundle/DataCollector/AbstractDataCollector.php  g  xϤ      E   vendor/symfony/framework-bundle/DataCollector/RouterDataCollector.phpD  gD  }      U   vendor/symfony/framework-bundle/DataCollector/TemplateAwareDataCollectorInterface.phpU  gU  ~suܤ      '   vendor/symfony/framework-bundle/LICENSE,  g,  U      7   vendor/symfony/framework-bundle/Test/KernelTestCase.phpA  gA  R      B   vendor/symfony/framework-bundle/Test/DomCrawlerAssertionsTrait.php  g  3      >   vendor/symfony/framework-bundle/Test/MailerAssertionsTrait.phpe  ge  }w      D   vendor/symfony/framework-bundle/Test/NotificationAssertionsTrait.php$  g$  E      B   vendor/symfony/framework-bundle/Test/HttpClientAssertionsTrait.php  g  7      B   vendor/symfony/framework-bundle/Test/BrowserKitAssertionsTrait.php!  g!  탤      9   vendor/symfony/framework-bundle/Test/TestBrowserToken.php  g  ¾      4   vendor/symfony/framework-bundle/Test/WebTestCase.php  g  5      ?   vendor/symfony/framework-bundle/Test/WebTestAssertionsTrait.php  g  *      6   vendor/symfony/framework-bundle/Test/TestContainer.phpP  gP  Ԕq      ,   vendor/symfony/framework-bundle/CHANGELOG.md  g  ķ      :   vendor/symfony/framework-bundle/Translation/Translator.phpR  gR  
H      7   vendor/symfony/framework-bundle/Secrets/SodiumVault.phpK#  gK#  ?/      7   vendor/symfony/framework-bundle/Secrets/DotenvVault.php8  g8  U:      9   vendor/symfony/framework-bundle/Secrets/AbstractVault.php  g  ~p      I   vendor/symfony/framework-bundle/Resources/bin/check-unused-known-tags.php  g  1      A   vendor/symfony/framework-bundle/Resources/config/asset_mapper.php$  g$  O)      8   vendor/symfony/framework-bundle/Resources/config/esi.php  g        @   vendor/symfony/framework-bundle/Resources/config/translation.phpM   gM   Tפ      ?   vendor/symfony/framework-bundle/Resources/config/serializer.phpy'  gy'  PF      ?   vendor/symfony/framework-bundle/Resources/config/form_debug.php  g  "      >   vendor/symfony/framework-bundle/Resources/config/validator.php  g  iL6Ǥ      >   vendor/symfony/framework-bundle/Resources/config/semaphore.php  g  4.      @   vendor/symfony/framework-bundle/Resources/config/annotations.php
  g
  ݋\      >   vendor/symfony/framework-bundle/Resources/config/profiling.php=  g=  +      ;   vendor/symfony/framework-bundle/Resources/config/mailer.phpC
  gC
  l      F   vendor/symfony/framework-bundle/Resources/config/fragment_listener.phpw  gw  Vg      F   vendor/symfony/framework-bundle/Resources/config/translation_debug.php  g  $      C   vendor/symfony/framework-bundle/Resources/config/notifier_debug.php  g  w0      A   vendor/symfony/framework-bundle/Resources/config/rate_limiter.php  g  |s      9   vendor/symfony/framework-bundle/Resources/config/lock.php  g  z      H   vendor/symfony/framework-bundle/Resources/config/identity_translator.php  g  W      @   vendor/symfony/framework-bundle/Resources/config/http_client.phpx
  gx
  ^?Ϥ      A   vendor/symfony/framework-bundle/Resources/config/mailer_debug.php  g  `܄       =   vendor/symfony/framework-bundle/Resources/config/services.php]#  g]#  k      :   vendor/symfony/framework-bundle/Resources/config/cache.php"  g"  -l7      <   vendor/symfony/framework-bundle/Resources/config/session.php  g  wr      F   vendor/symfony/framework-bundle/Resources/config/mailer_transports.php  g  i?
      J   vendor/symfony/framework-bundle/Resources/config/translation_providers.php	  g	  ?H      :   vendor/symfony/framework-bundle/Resources/config/debug.php  g  L_      E   vendor/symfony/framework-bundle/Resources/config/notifier_webhook.php  g  ,      F   vendor/symfony/framework-bundle/Resources/config/fragment_renderer.php	  g	         =   vendor/symfony/framework-bundle/Resources/config/web_link.phpZ  gZ  Oj      <   vendor/symfony/framework-bundle/Resources/config/routing.php  g  A      G   vendor/symfony/framework-bundle/Resources/config/schema/symfony-1.0.xsdg  gg  #`R      =   vendor/symfony/framework-bundle/Resources/config/notifier.php  g  Ec      F   vendor/symfony/framework-bundle/Resources/config/http_client_debug.php  g  "5$      <   vendor/symfony/framework-bundle/Resources/config/request.php  g  kP?      9   vendor/symfony/framework-bundle/Resources/config/test.php  g        <   vendor/symfony/framework-bundle/Resources/config/webhook.php  g  P쌤      D   vendor/symfony/framework-bundle/Resources/config/validator_debug.php  g  GU      C   vendor/symfony/framework-bundle/Resources/config/error_renderer.php/  g/        >   vendor/symfony/framework-bundle/Resources/config/mime_type.php  g  H̤      >   vendor/symfony/framework-bundle/Resources/config/messenger.php?#  g?#  Y      <   vendor/symfony/framework-bundle/Resources/config/console.php3  g3  uҤ      8   vendor/symfony/framework-bundle/Resources/config/uid.php=  g=  S      B   vendor/symfony/framework-bundle/Resources/config/property_info.php	  g	  j      >   vendor/symfony/framework-bundle/Resources/config/scheduler.php  g  1@w      8   vendor/symfony/framework-bundle/Resources/config/ssi.php  g  5{      8   vendor/symfony/framework-bundle/Resources/config/web.php  g  k?֓      D   vendor/symfony/framework-bundle/Resources/config/messenger_debug.php  g  o灤      ?   vendor/symfony/framework-bundle/Resources/config/collectors.phpq  gq  %(      C   vendor/symfony/framework-bundle/Resources/config/routing/errors.xml  g  >      D   vendor/symfony/framework-bundle/Resources/config/routing/webhook.xml  g  Vc      C   vendor/symfony/framework-bundle/Resources/config/html_sanitizer.php  g  Pդ      <   vendor/symfony/framework-bundle/Resources/config/secrets.php  g  *n      9   vendor/symfony/framework-bundle/Resources/config/form.php  g  m17      E   vendor/symfony/framework-bundle/Resources/config/serializer_debug.php  g        C   vendor/symfony/framework-bundle/Resources/config/workflow_debug.php  g  RRT      C   vendor/symfony/framework-bundle/Resources/config/mailer_webhook.php
  g
  dea      >   vendor/symfony/framework-bundle/Resources/config/form_csrf.phpD  gD  A3U      =   vendor/symfony/framework-bundle/Resources/config/workflow.php  g  #m7Y      B   vendor/symfony/framework-bundle/Resources/config/security_csrf.php  g  ~ܤ      H   vendor/symfony/framework-bundle/Resources/config/notifier_transports.php^3  g^3  |      ?   vendor/symfony/framework-bundle/Resources/config/debug_prod.php  g  _Q      D   vendor/symfony/framework-bundle/Resources/config/property_access.php  g  Bʤ      ;   vendor/symfony/framework-bundle/Resources/config/assets.php  g  v'      @   vendor/symfony/framework-bundle/Resources/config/cache_debug.php  g  %]      A   vendor/symfony/framework-bundle/Resources/config/remote_event.php  g  
ä      <   vendor/symfony/framework-bundle/Resources/config/process.phpc  gc        1   vendor/symfony/framework-bundle/KernelBrowser.php  g        D   vendor/symfony/framework-bundle/CacheWarmer/ValidatorCacheWarmer.php^
  g^
  hr      H   vendor/symfony/framework-bundle/CacheWarmer/ConfigBuilderCacheWarmer.phpc  gc  gp      J   vendor/symfony/framework-bundle/CacheWarmer/AbstractPhpFileCacheWarmer.php
  g
  $bΤ      A   vendor/symfony/framework-bundle/CacheWarmer/RouterCacheWarmer.php  g  )      G   vendor/symfony/framework-bundle/CacheWarmer/TranslationsCacheWarmer.php  g  2e      E   vendor/symfony/framework-bundle/CacheWarmer/SerializerCacheWarmer.php  g  ^M      K   vendor/symfony/framework-bundle/CacheWarmer/CachePoolClearerCacheWarmer.php  g  ҧ      F   vendor/symfony/framework-bundle/CacheWarmer/AnnotationsCacheWarmer.php  g  l      A   vendor/symfony/framework-bundle/Controller/AbstractController.phpH  gH        A   vendor/symfony/framework-bundle/Controller/TemplateController.php	  g	  k      A   vendor/symfony/framework-bundle/Controller/ControllerResolver.php3  g3  0      A   vendor/symfony/framework-bundle/Controller/RedirectController.php  g  HǤ      )   vendor/symfony/framework-bundle/README.md!  g!  q      7   vendor/symfony/framework-bundle/HttpCache/HttpCache.php
  g
  R      3   vendor/symfony/framework-bundle/FrameworkBundle.php3  g3  ب       >   vendor/symfony/framework-bundle/Command/SecretsListCommand.php
  g
  cc4      J   vendor/symfony/framework-bundle/Command/CachePoolInvalidateTagsCommand.phpK  gK  ,ؤ      @   vendor/symfony/framework-bundle/Command/SecretsRemoveCommand.phpw
  gw
  A      =   vendor/symfony/framework-bundle/Command/CacheClearCommand.php(  g(  ~      <   vendor/symfony/framework-bundle/Command/XliffLintCommand.php  g  vtc      H   vendor/symfony/framework-bundle/Command/SecretsDecryptToLocalCommand.php
  g
        A   vendor/symfony/framework-bundle/Command/AbstractConfigCommand.phpi  gi  VP      >   vendor/symfony/framework-bundle/Command/RouterDebugCommand.php  g  s`i      D   vendor/symfony/framework-bundle/Command/TranslationUpdateCommand.php{D  g{D  R      F   vendor/symfony/framework-bundle/Command/ConfigDumpReferenceCommand.php8  g8  !      @   vendor/symfony/framework-bundle/Command/AssetsInstallCommand.php'  g'  ]3%      A   vendor/symfony/framework-bundle/Command/CachePoolPruneCommand.php  g  ~T}      A   vendor/symfony/framework-bundle/Command/CachePoolClearCommand.php  g  ZQ~      @   vendor/symfony/framework-bundle/Command/ContainerLintCommand.php\  g\  ]6      J   vendor/symfony/framework-bundle/Command/SecretsEncryptFromLocalCommand.php1	  g1	  dƃ|      B   vendor/symfony/framework-bundle/Command/DebugAutowiringCommand.php  g  \      >   vendor/symfony/framework-bundle/Command/CacheWarmupCommand.php  g  :5Τ      ?   vendor/symfony/framework-bundle/Command/WorkflowDumpCommand.phpD  gD  &      G   vendor/symfony/framework-bundle/Command/EventDispatcherDebugCommand.php  g   ّY      A   vendor/symfony/framework-bundle/Command/ContainerDebugCommand.phps<  gs<  _ q      C   vendor/symfony/framework-bundle/Command/TranslationDebugCommand.phpa<  ga<  1g      ;   vendor/symfony/framework-bundle/Command/YamlLintCommand.phpA  gA  Fs      @   vendor/symfony/framework-bundle/Command/CachePoolListCommand.php  g  ;q      F   vendor/symfony/framework-bundle/Command/SecretsGenerateKeysCommand.php  g  ֤      B   vendor/symfony/framework-bundle/Command/CachePoolDeleteCommand.php  g  yUɤ      D   vendor/symfony/framework-bundle/Command/BuildDebugContainerTrait.php
  g
  ҥ      8   vendor/symfony/framework-bundle/Command/AboutCommand.php  g  n٤      >   vendor/symfony/framework-bundle/Command/RouterMatchCommand.php7  g7  }S      =   vendor/symfony/framework-bundle/Command/SecretsSetCommand.php:  g:        >   vendor/symfony/framework-bundle/Command/ConfigDebugCommand.php4)  g4)  E^%      J   vendor/symfony/framework-bundle/Routing/RedirectableCompiledUrlMatcher.php!  g!  )\      J   vendor/symfony/framework-bundle/Routing/AttributeRouteControllerLoader.php  g  v1)      O   vendor/symfony/framework-bundle/Routing/Attribute/AsRoutingConditionService.php  g  ny      @   vendor/symfony/framework-bundle/Routing/RouteLoaderInterface.php  g  b       2   vendor/symfony/framework-bundle/Routing/Router.php  g  ~Un      <   vendor/symfony/framework-bundle/Routing/DelegatingLoader.php
  g
  դ      J   vendor/symfony/framework-bundle/Routing/AnnotatedRouteControllerLoader.php
  g
  y,      E   vendor/symfony/framework-bundle/DependencyInjection/Configuration.php<A g<A       J   vendor/symfony/framework-bundle/DependencyInjection/FrameworkExtension.php g &      O   vendor/symfony/framework-bundle/DependencyInjection/VirtualRequestStackPass.php  g  
w      ^   vendor/symfony/framework-bundle/DependencyInjection/Compiler/ContainerBuilderDebugDumpPass.phpS  gS  n>.      `   vendor/symfony/framework-bundle/DependencyInjection/Compiler/TestServiceContainerRealRefPass.php	  g	  j(v      c   vendor/symfony/framework-bundle/DependencyInjection/Compiler/AddExpressionLanguageProvidersPass.phpW  gW  W*ͤ      O   vendor/symfony/framework-bundle/DependencyInjection/Compiler/UnusedTagsPass.phpt  gt  b"      R   vendor/symfony/framework-bundle/DependencyInjection/Compiler/AssetsContextPass.php  g  o      X   vendor/symfony/framework-bundle/DependencyInjection/Compiler/ErrorLoggerCompilerPass.php  g  9/      ]   vendor/symfony/framework-bundle/DependencyInjection/Compiler/TranslationUpdateCommandPass.php  g        Z   vendor/symfony/framework-bundle/DependencyInjection/Compiler/WorkflowGuardListenerPass.php#  g#  ,      Z   vendor/symfony/framework-bundle/DependencyInjection/Compiler/EnableLoggerDebugModePass.php  g  }V      `   vendor/symfony/framework-bundle/DependencyInjection/Compiler/TestServiceContainerWeakRefPass.php@	  g@	  y`1      V   vendor/symfony/framework-bundle/DependencyInjection/Compiler/LoggingTranslatorPass.phpY  gY  Nx      \   vendor/symfony/framework-bundle/DependencyInjection/Compiler/DataCollectorTranslatorPass.phpV  gV  0#      _   vendor/symfony/framework-bundle/DependencyInjection/Compiler/AddAnnotationsCachedReaderPass.php  g  ~Y      M   vendor/symfony/framework-bundle/DependencyInjection/Compiler/ProfilerPass.php	  g	  &1      j   vendor/symfony/framework-bundle/DependencyInjection/Compiler/RemoveUnusedSessionMarshallingHandlerPass.php   g   k)̤      Y   vendor/symfony/framework-bundle/DependencyInjection/Compiler/AddDebugLogProcessorPass.php  g  `:W      -   vendor/symfony/framework-bundle/composer.json  g  cFD
      ;   vendor/symfony/framework-bundle/Kernel/MicroKernelTrait.phpd   gd   ٟO      7   vendor/symfony/framework-bundle/Console/Application.phpE   gE   '23      E   vendor/symfony/framework-bundle/Console/Descriptor/TextDescriptor.phpm  gm  JL      D   vendor/symfony/framework-bundle/Console/Descriptor/XmlDescriptor.phpj  gj  ksnU      A   vendor/symfony/framework-bundle/Console/Descriptor/Descriptor.php6  g6        E   vendor/symfony/framework-bundle/Console/Descriptor/JsonDescriptor.phpD  gD  vF      I   vendor/symfony/framework-bundle/Console/Descriptor/MarkdownDescriptor.php8I  g8I  h      C   vendor/symfony/framework-bundle/Console/Helper/DescriptorHelper.php  g  *      I   vendor/symfony/framework-bundle/EventListener/ConsoleProfilerListener.php  g  c      Q   vendor/symfony/framework-bundle/EventListener/SuggestMissingPackageSubscriber.php	  g	  Su      %   vendor/symfony/monolog-bundle/LICENSE)  g)  Ǥ      *   vendor/symfony/monolog-bundle/CHANGELOG.md  g  :L      :   vendor/symfony/monolog-bundle/Resources/config/monolog.xml.  g.   0yK      E   vendor/symfony/monolog-bundle/Resources/config/schema/monolog-1.0.xsd'  g'  )X      <   vendor/symfony/monolog-bundle/SwiftMailer/MessageFactory.php  g        '   vendor/symfony/monolog-bundle/README.mdY  gY        /   vendor/symfony/monolog-bundle/MonologBundle.php  g  @g      F   vendor/symfony/monolog-bundle/DependencyInjection/MonologExtension.phpi  gi  ve      C   vendor/symfony/monolog-bundle/DependencyInjection/Configuration.php  g  vr      P   vendor/symfony/monolog-bundle/DependencyInjection/Compiler/AddProcessorsPass.php  g  R      P   vendor/symfony/monolog-bundle/DependencyInjection/Compiler/LoggerChannelPass.php  g        O   vendor/symfony/monolog-bundle/DependencyInjection/Compiler/DebugHandlerPass.php
  g
  HS      Q   vendor/symfony/monolog-bundle/DependencyInjection/Compiler/FixEmptyLoggerPass.php  g  DN      Z   vendor/symfony/monolog-bundle/DependencyInjection/Compiler/AddSwiftMailerTransportPass.php  g   *Q      +   vendor/symfony/monolog-bundle/composer.json  g  Ǉ      %   vendor/symfony/polyfill-php73/LICENSE,  g,        '   vendor/symfony/polyfill-php73/Php73.phps  gs  D\      ?   vendor/symfony/polyfill-php73/Resources/stubs/JsonException.phpE  gE  8S      +   vendor/symfony/polyfill-php73/bootstrap.php  g  |      '   vendor/symfony/polyfill-php73/README.md/  g/  m      +   vendor/symfony/polyfill-php73/composer.json  g  t      C   vendor/symfony/serializer/DataCollector/SerializerDataCollector.php?  g?  8      (   vendor/symfony/serializer/Serializer.phpG  gG  =у      I   vendor/symfony/serializer/Mapping/ClassDiscriminatorFromClassMetadata.phpu
  gu
  5      <   vendor/symfony/serializer/Mapping/ClassMetadataInterface.php3  g3  闙      3   vendor/symfony/serializer/Mapping/ClassMetadata.phpV
  gV
  ŏ=      <   vendor/symfony/serializer/Mapping/Loader/AttributeLoader.php+5  g+5  y      7   vendor/symfony/serializer/Mapping/Loader/FileLoader.phpF  gF  hդ      <   vendor/symfony/serializer/Mapping/Loader/LoaderInterface.phpY  gY  
lޤ      ;   vendor/symfony/serializer/Mapping/Loader/YamlFileLoader.php  g  rF      a   vendor/symfony/serializer/Mapping/Loader/schema/dic/serializer-mapping/serializer-mapping-1.0.xsd  g  7      :   vendor/symfony/serializer/Mapping/Loader/XmlFileLoader.php  g  W      8   vendor/symfony/serializer/Mapping/Loader/LoaderChain.php  g  S*      =   vendor/symfony/serializer/Mapping/Loader/AnnotationLoader.php  g  a      I   vendor/symfony/serializer/Mapping/ClassDiscriminatorResolverInterface.php  g  2      @   vendor/symfony/serializer/Mapping/AttributeMetadataInterface.php  g  v5      ?   vendor/symfony/serializer/Mapping/ClassDiscriminatorMapping.php  g  2q      J   vendor/symfony/serializer/Mapping/Factory/ClassMetadataFactoryCompiler.phpp  gp  A
      @   vendor/symfony/serializer/Mapping/Factory/ClassResolverTrait.php+  g+  u鏤      B   vendor/symfony/serializer/Mapping/Factory/ClassMetadataFactory.php  g  5      G   vendor/symfony/serializer/Mapping/Factory/CacheClassMetadataFactory.php  g        J   vendor/symfony/serializer/Mapping/Factory/CompiledClassMetadataFactory.php7  g7  @IP      K   vendor/symfony/serializer/Mapping/Factory/ClassMetadataFactoryInterface.php  g  /      7   vendor/symfony/serializer/Mapping/AttributeMetadata.php  g  j\      1   vendor/symfony/serializer/SerializerInterface.php}  g}  wp      F   vendor/symfony/serializer/Context/Encoder/CsvEncoderContextBuilder.php  g  H      F   vendor/symfony/serializer/Context/Encoder/XmlEncoderContextBuilder.php_  g_  gdr      G   vendor/symfony/serializer/Context/Encoder/YamlEncoderContextBuilder.php  g  \      G   vendor/symfony/serializer/Context/Encoder/JsonEncoderContextBuilder.php  g  8      9   vendor/symfony/serializer/Context/ContextBuilderTrait.php  g  W6      >   vendor/symfony/serializer/Context/SerializerContextBuilder.php  g  ޵R      =   vendor/symfony/serializer/Context/ContextBuilderInterface.php  g  n
      O   vendor/symfony/serializer/Context/Normalizer/ObjectNormalizerContextBuilder.php#  g#  D      Q   vendor/symfony/serializer/Context/Normalizer/DateTimeNormalizerContextBuilder.php  g  ,P      R   vendor/symfony/serializer/Context/Normalizer/FormErrorNormalizerContextBuilder.php  g  sڤ      U   vendor/symfony/serializer/Context/Normalizer/GetSetMethodNormalizerContextBuilder.php/  g/  gB      Y   vendor/symfony/serializer/Context/Normalizer/JsonSerializableNormalizerContextBuilder.php1  g1  z      P   vendor/symfony/serializer/Context/Normalizer/ProblemNormalizerContextBuilder.php  g  \oq      W   vendor/symfony/serializer/Context/Normalizer/AbstractObjectNormalizerContextBuilder.phpQ  gQ  2      S   vendor/symfony/serializer/Context/Normalizer/BackedEnumNormalizerContextBuilder.phpg  gg  S      `   vendor/symfony/serializer/Context/Normalizer/ConstraintViolationListNormalizerContextBuilder.php7  g7  gO      U   vendor/symfony/serializer/Context/Normalizer/UnwrappingDenormalizerContextBuilder.php!  g!  t;9      Q   vendor/symfony/serializer/Context/Normalizer/AbstractNormalizerContextBuilder.php  g  r㽤      L   vendor/symfony/serializer/Context/Normalizer/UidNormalizerContextBuilder.php  g  B4      Q   vendor/symfony/serializer/Context/Normalizer/PropertyNormalizerContextBuilder.php  g  8      U   vendor/symfony/serializer/Context/Normalizer/DateIntervalNormalizerContextBuilder.phpB  gB  Ѥ      6   vendor/symfony/serializer/Attribute/SerializedName.php  g  pl      .   vendor/symfony/serializer/Attribute/Ignore.php  g        /   vendor/symfony/serializer/Attribute/Context.php	  g	  Oq'      8   vendor/symfony/serializer/Attribute/DiscriminatorMap.php  g  Ӥ      6   vendor/symfony/serializer/Attribute/SerializedPath.php  g  <      0   vendor/symfony/serializer/Attribute/MaxDepth.php  g  [v      .   vendor/symfony/serializer/Attribute/Groups.php  g  !x
      !   vendor/symfony/serializer/LICENSE,  g,  U      &   vendor/symfony/serializer/CHANGELOG.md6<  g6<  qSx      0   vendor/symfony/serializer/Encoder/CsvEncoder.php&  g&  .B5&      B   vendor/symfony/serializer/Encoder/ContextAwareDecoderInterface.php  g  o׍      2   vendor/symfony/serializer/Encoder/ChainEncoder.phpg  gg  A0      6   vendor/symfony/serializer/Encoder/DecoderInterface.php/  g/  
      B   vendor/symfony/serializer/Encoder/ContextAwareEncoderInterface.php  g  Q{N      A   vendor/symfony/serializer/Encoder/NormalizationAwareInterface.phpv  gv  
/g      6   vendor/symfony/serializer/Encoder/EncoderInterface.php  g  _J      2   vendor/symfony/serializer/Encoder/ChainDecoder.php  g  }[      0   vendor/symfony/serializer/Encoder/JsonEncode.php  g  ۤ      1   vendor/symfony/serializer/Encoder/JsonEncoder.php  g  w      0   vendor/symfony/serializer/Encoder/JsonDecode.php<  g<  Dh$      1   vendor/symfony/serializer/Encoder/YamlEncoder.phpq
  gq
  !y]      0   vendor/symfony/serializer/Encoder/XmlEncoder.phpH  gH  pbR      J   vendor/symfony/serializer/CacheWarmer/CompiledClassMetadataCacheWarmer.php7  g7  Ƭc      7   vendor/symfony/serializer/Annotation/SerializedName.php[  g[  PR      /   vendor/symfony/serializer/Annotation/Ignore.phpC  gC  𽩤      0   vendor/symfony/serializer/Annotation/Context.php  g  ;i*      9   vendor/symfony/serializer/Annotation/DiscriminatorMap.phpB  gB  R?      7   vendor/symfony/serializer/Annotation/SerializedPath.php[  g[  ޢ6X      1   vendor/symfony/serializer/Annotation/MaxDepth.phpI  gI  BY      /   vendor/symfony/serializer/Annotation/Groups.php^  g^  wLN      L   vendor/symfony/serializer/Extractor/ObjectPropertyListExtractorInterface.php^  g^  $7      C   vendor/symfony/serializer/Extractor/ObjectPropertyListExtractor.php{  g{  E      6   vendor/symfony/serializer/SerializerAwareInterface.php  g  M      #   vendor/symfony/serializer/README.mdJ  gJ  Mc%      B   vendor/symfony/serializer/NameConverter/NameConverterInterface.php  g  pvEq      J   vendor/symfony/serializer/NameConverter/AdvancedNameConverterInterface.php  g  6      F   vendor/symfony/serializer/NameConverter/MetadataAwareNameConverter.php  g  .]      M   vendor/symfony/serializer/NameConverter/CamelCaseToSnakeCaseNameConverter.php8  g8  \Ѥ      2   vendor/symfony/serializer/Command/DebugCommand.phpy  gy  2 3      ;   vendor/symfony/serializer/Normalizer/DateTimeNormalizer.php  g  aZ      >   vendor/symfony/serializer/Normalizer/MimeMessageNormalizer.phpD  gD  Br͌      @   vendor/symfony/serializer/Normalizer/DenormalizableInterface.phpv  gv        :   vendor/symfony/serializer/Normalizer/ProblemNormalizer.php  g  K      I   vendor/symfony/serializer/Normalizer/CacheableSupportsMethodInterface.php"  g"  Jgɤ      >   vendor/symfony/serializer/Normalizer/ObjectToPopulateTrait.php-  g-  Ґ~}      <   vendor/symfony/serializer/Normalizer/FormErrorNormalizer.php	  g	  cI      J   vendor/symfony/serializer/Normalizer/ContextAwareDenormalizerInterface.php7  g7  #      :   vendor/symfony/serializer/Normalizer/ArrayDenormalizer.php  g        A   vendor/symfony/serializer/Normalizer/AbstractObjectNormalizer.phpו  gו  X      ?   vendor/symfony/serializer/Normalizer/DateTimeZoneNormalizer.php  g  6Ǥ      ?   vendor/symfony/serializer/Normalizer/UnwrappingDenormalizer.php}
  g}
  /)      =   vendor/symfony/serializer/Normalizer/NormalizerAwareTrait.phpk  gk  #      A   vendor/symfony/serializer/Normalizer/NormalizerAwareInterface.php%  g%  :]R      C   vendor/symfony/serializer/Normalizer/JsonSerializableNormalizer.php1
  g1
  PC      :   vendor/symfony/serializer/Normalizer/DataUriNormalizer.php  g  %      H   vendor/symfony/serializer/Normalizer/ContextAwareNormalizerInterface.php  g  +      9   vendor/symfony/serializer/Normalizer/CustomNormalizer.phpB  gB  O(      C   vendor/symfony/serializer/Normalizer/DenormalizerAwareInterface.php/  g/  <ǖ      ?   vendor/symfony/serializer/Normalizer/DateIntervalNormalizer.php  g  zԋ      ;   vendor/symfony/serializer/Normalizer/PropertyNormalizer.php   g   :      9   vendor/symfony/serializer/Normalizer/ObjectNormalizer.php6'  g6'  ЯOQ      ;   vendor/symfony/serializer/Normalizer/AbstractNormalizer.phpa  ga  Pt      ?   vendor/symfony/serializer/Normalizer/TranslatableNormalizer.php  g  Z7(G      6   vendor/symfony/serializer/Normalizer/UidNormalizer.php  g   ru      >   vendor/symfony/serializer/Normalizer/DenormalizerInterface.php
  g
  Vi3      >   vendor/symfony/serializer/Normalizer/NormalizableInterface.php  g        ?   vendor/symfony/serializer/Normalizer/GetSetMethodNormalizer.php  g  58m      =   vendor/symfony/serializer/Normalizer/BackedEnumNormalizer.php,  g,  g      J   vendor/symfony/serializer/Normalizer/ConstraintViolationListNormalizer.php  g  o      <   vendor/symfony/serializer/Normalizer/NormalizerInterface.php  g  e      ?   vendor/symfony/serializer/Normalizer/DenormalizerAwareTrait.php{  g{  o      2   vendor/symfony/serializer/SerializerAwareTrait.php`  g`  ĝ|      @   vendor/symfony/serializer/DependencyInjection/SerializerPass.php
  g
        6   vendor/symfony/serializer/Exception/LogicException.php  g  A      :   vendor/symfony/serializer/Exception/ExceptionInterface.php  g  Za      L   vendor/symfony/serializer/Exception/MissingConstructorArgumentsException.php  g  a      @   vendor/symfony/serializer/Exception/UnexpectedValueException.php  g  rǤ      8   vendor/symfony/serializer/Exception/RuntimeException.php  g  VX      E   vendor/symfony/serializer/Exception/NotNormalizableValueException.phpc  gc  N͜      @   vendor/symfony/serializer/Exception/InvalidArgumentException.php  g  n      B   vendor/symfony/serializer/Exception/CircularReferenceException.php  g  s5      >   vendor/symfony/serializer/Exception/BadMethodCallException.php  g  }
      8   vendor/symfony/serializer/Exception/MappingException.php  g  Ǡۤ      <   vendor/symfony/serializer/Exception/UnsupportedException.php  g         B   vendor/symfony/serializer/Exception/NotEncodableValueException.php  g  \53      G   vendor/symfony/serializer/Exception/PartialDenormalizationException.phpM  gM  D      B   vendor/symfony/serializer/Exception/UnsupportedFormatException.php  g  G`k      @   vendor/symfony/serializer/Exception/ExtraAttributesException.php  g  3ٌ      '   vendor/symfony/serializer/composer.json	  g	  ɮ      4   vendor/symfony/serializer/Debug/TraceableEncoder.php'  g'  hͤ      7   vendor/symfony/serializer/Debug/TraceableSerializer.php  g  &Ix      7   vendor/symfony/serializer/Debug/TraceableNormalizer.phpa  ga  ;ݤ      *   vendor/symfony/polyfill-php80/PhpToken.php  g  s`      %   vendor/symfony/polyfill-php80/LICENSE,  g,  K      :   vendor/symfony/polyfill-php80/Resources/stubs/PhpToken.phpw  gw  =7T8      <   vendor/symfony/polyfill-php80/Resources/stubs/ValueError.php>  g>  g      ;   vendor/symfony/polyfill-php80/Resources/stubs/Attribute.php  g  MK<      E   vendor/symfony/polyfill-php80/Resources/stubs/UnhandledMatchError.phpG  gG  ֈ+      <   vendor/symfony/polyfill-php80/Resources/stubs/Stringable.php  g  t]\ڤ      +   vendor/symfony/polyfill-php80/bootstrap.php  g  .Ĥ      '   vendor/symfony/polyfill-php80/README.md  g  "tF      '   vendor/symfony/polyfill-php80/Php80.php  g  H      +   vendor/symfony/polyfill-php80/composer.jsonb  gb  F      7   vendor/symfony/monolog-bridge/Handler/MailerHandler.php  g  1d      H   vendor/symfony/monolog-bridge/Handler/CompatibilityProcessingHandler.php  g        8   vendor/symfony/monolog-bridge/Handler/ConsoleHandler.php  g  Ѻ	      S   vendor/symfony/monolog-bridge/Handler/FingersCrossed/HttpCodeActivationStrategy.php  g  c      S   vendor/symfony/monolog-bridge/Handler/FingersCrossed/NotFoundActivationStrategy.phpT  gT  s      :   vendor/symfony/monolog-bridge/Handler/ServerLogHandler.php  g  \~      >   vendor/symfony/monolog-bridge/Handler/CompatibilityHandler.php  g  !E      9   vendor/symfony/monolog-bridge/Handler/NotifierHandler.php	  g	  %ˤ      8   vendor/symfony/monolog-bridge/Handler/FirePHPHandler.php  g  J      :   vendor/symfony/monolog-bridge/Handler/ChromePhpHandler.php0  g0  ݤ      F   vendor/symfony/monolog-bridge/Handler/ElasticsearchLogstashHandler.php  g  I6      (   vendor/symfony/monolog-bridge/Logger.php-
  g-
  y      %   vendor/symfony/monolog-bridge/LICENSE,  g,  U      *   vendor/symfony/monolog-bridge/CHANGELOG.md
  g
  `s      :   vendor/symfony/monolog-bridge/Processor/TokenProcessor.php<  g<  ]      D   vendor/symfony/monolog-bridge/Processor/SwitchUserTokenProcessor.php  g  A܊      8   vendor/symfony/monolog-bridge/Processor/WebProcessor.php  g        B   vendor/symfony/monolog-bridge/Processor/CompatibilityProcessor.php!  g!  6$      :   vendor/symfony/monolog-bridge/Processor/RouteProcessor.php	  g	  <      C   vendor/symfony/monolog-bridge/Processor/ConsoleCommandProcessor.phpJ  gJ  ZU      B   vendor/symfony/monolog-bridge/Processor/AbstractTokenProcessor.php  g  dC      :   vendor/symfony/monolog-bridge/Processor/DebugProcessor.php  g  c4      '   vendor/symfony/monolog-bridge/README.md  g  =~      <   vendor/symfony/monolog-bridge/Formatter/ConsoleFormatter.php  g  Pp      >   vendor/symfony/monolog-bridge/Formatter/VarDumperFormatter.php0  g0  r~ݤ      B   vendor/symfony/monolog-bridge/Formatter/CompatibilityFormatter.php  g  ˦k      :   vendor/symfony/monolog-bridge/Command/ServerLogCommand.php  g        +   vendor/symfony/monolog-bridge/composer.json  g  -}b      9   vendor/symfony/cache/DataCollector/CacheDataCollector.php  g  b:XP      "   vendor/symfony/cache/CacheItem.php  g  g9      #   vendor/symfony/cache/Psr16Cache.php=  g=  8`c         vendor/symfony/cache/LICENSE,  g,  X      +   vendor/symfony/cache/PruneableInterface.php  g  a]      !   vendor/symfony/cache/CHANGELOG.mdo  go  ʗXJ      5   vendor/symfony/cache/Traits/RedisClusterNodeProxy.php  g  &yF      /   vendor/symfony/cache/Traits/RelayProxyTrait.php  g  R      *   vendor/symfony/cache/Traits/RedisTrait.phpBu  gBu  pU      +   vendor/symfony/cache/Traits/Redis5Proxy.php׷  g׷  \٤      2   vendor/symfony/cache/Traits/RedisCluster6Proxy.phps  gs  Q      *   vendor/symfony/cache/Traits/ProxyTrait.php%  g%  P      5   vendor/symfony/cache/Traits/FilesystemCommonTrait.php9  g9        1   vendor/symfony/cache/Traits/RedisClusterProxy.php  g  `"      *   vendor/symfony/cache/Traits/RedisProxy.php  g  G.r      .   vendor/symfony/cache/Traits/ContractsTrait.php&  g&  .M=      *   vendor/symfony/cache/Traits/RelayProxy.php  g  Vz"      0   vendor/symfony/cache/Traits/Redis6ProxyTrait.php  g  P      ,   vendor/symfony/cache/Traits/ValueWrapper.phpE  gE  i7      2   vendor/symfony/cache/Traits/RedisCluster5Proxy.php\  g\  UҤ      /   vendor/symfony/cache/Traits/FilesystemTrait.php  g  7      +   vendor/symfony/cache/Traits/Redis6Proxy.php  g  X      4   vendor/symfony/cache/Traits/Relay/GeosearchTrait.php'  g'  7      /   vendor/symfony/cache/Traits/Relay/MoveTrait.php  g  b      2   vendor/symfony/cache/Traits/Relay/PfcountTrait.php  g  D      /   vendor/symfony/cache/Traits/Relay/CopyTrait.php  g  ѽ      9   vendor/symfony/cache/Traits/Relay/NullableReturnTrait.phpZ  gZ  *zʤ      /   vendor/symfony/cache/Traits/Relay/HsetTrait.php  g  E      3   vendor/symfony/cache/Traits/Relay/GetrangeTrait.php  g  XԖ      4   vendor/symfony/cache/Traits/AbstractAdapterTrait.php\0  g\0  1Ť      7   vendor/symfony/cache/Traits/RedisCluster6ProxyTrait.php  g  Xm      -   vendor/symfony/cache/Adapter/ProxyAdapter.php_  g_  <      ,   vendor/symfony/cache/Adapter/ApcuAdapter.phpX  gX  S      ;   vendor/symfony/cache/Adapter/CouchbaseCollectionAdapter.php  g  ƫ}      1   vendor/symfony/cache/Adapter/TraceableAdapter.php  g  
bJ6      +   vendor/symfony/cache/Adapter/PdoAdapter.phpA  gA        -   vendor/symfony/cache/Adapter/ArrayAdapter.php,  g,  4      5   vendor/symfony/cache/Adapter/RedisTagAwareAdapter.php0  g0  1      7   vendor/symfony/cache/Adapter/CouchbaseBucketAdapter.php  g  <^      ,   vendor/symfony/cache/Adapter/NullAdapter.php  g  :@      4   vendor/symfony/cache/Adapter/ParameterNormalizer.php  g  +      0   vendor/symfony/cache/Adapter/TagAwareAdapter.php,  g,  mX      0   vendor/symfony/cache/Adapter/PhpFilesAdapter.php(  g(   &      4   vendor/symfony/cache/Adapter/DoctrineDbalAdapter.phpA  gA  nƬq      9   vendor/symfony/cache/Adapter/TagAwareAdapterInterface.php	  g	  ?      1   vendor/symfony/cache/Adapter/MemcachedAdapter.php4  g4  l9
      -   vendor/symfony/cache/Adapter/RedisAdapter.php/  g/  -U=$      1   vendor/symfony/cache/Adapter/AdapterInterface.php  g  $B      :   vendor/symfony/cache/Adapter/FilesystemTagAwareAdapter.php#  g#  ˤ      9   vendor/symfony/cache/Adapter/TraceableTagAwareAdapter.php  g  6s:      -   vendor/symfony/cache/Adapter/Psr16Adapter.php*  g*  $\      -   vendor/symfony/cache/Adapter/ChainAdapter.php]"  g]"  x      2   vendor/symfony/cache/Adapter/FilesystemAdapter.php  g  (Acb      0   vendor/symfony/cache/Adapter/AbstractAdapter.php2  g2  @2      8   vendor/symfony/cache/Adapter/AbstractTagAwareAdapter.php1  g1  ;,      0   vendor/symfony/cache/Adapter/PhpArrayAdapter.php/  g/   Ť      %   vendor/symfony/cache/LockRegistry.php  g  )?Ӥ      ,   vendor/symfony/cache/ResettableInterface.php  g  NR         vendor/symfony/cache/README.md  g  `t:      9   vendor/symfony/cache/Messenger/EarlyExpirationHandler.php7
  g7
  r      9   vendor/symfony/cache/Messenger/EarlyExpirationMessage.php
  g
  %      <   vendor/symfony/cache/Messenger/EarlyExpirationDispatcher.php	  g	  q      5   vendor/symfony/cache/Marshaller/DefaultMarshaller.phpK  gK  h&      5   vendor/symfony/cache/Marshaller/DeflateMarshaller.php  g  C      7   vendor/symfony/cache/Marshaller/MarshallerInterface.php3  g3  Ǚ      6   vendor/symfony/cache/Marshaller/TagAwareMarshaller.php  g  t      4   vendor/symfony/cache/Marshaller/SodiumMarshaller.php`	  g`	  F      :   vendor/symfony/cache/DependencyInjection/CachePoolPass.php,'  g,'  VM      @   vendor/symfony/cache/DependencyInjection/CachePoolPrunerPass.php  g  m}      ?   vendor/symfony/cache/DependencyInjection/CacheCollectorPass.php  g  t      A   vendor/symfony/cache/DependencyInjection/CachePoolClearerPass.php  g  Ł:      1   vendor/symfony/cache/Exception/LogicException.php  g  9d      ;   vendor/symfony/cache/Exception/InvalidArgumentException.php  g  j      1   vendor/symfony/cache/Exception/CacheException.php  g  Q4      "   vendor/symfony/cache/composer.json  g  Fw      -   vendor/symfony/polyfill-ctype/bootstrap80.phpr  gr  F)      %   vendor/symfony/polyfill-ctype/LICENSE,  g,        +   vendor/symfony/polyfill-ctype/bootstrap.php@  g@  jQ9      '   vendor/symfony/polyfill-ctype/README.md^  g^  lHk      '   vendor/symfony/polyfill-ctype/Ctype.php  g   /      +   vendor/symfony/polyfill-ctype/composer.json  g  9      %   vendor/symfony/polyfill-php81/LICENSE,  g,  0      F   vendor/symfony/polyfill-php81/Resources/stubs/ReturnTypeWillChange.php  g  5+      @   vendor/symfony/polyfill-php81/Resources/stubs/CURLStringFile.php  g  JT      +   vendor/symfony/polyfill-php81/bootstrap.php  g  <P      '   vendor/symfony/polyfill-php81/README.md  g        '   vendor/symfony/polyfill-php81/Php81.php  g  3E      +   vendor/symfony/polyfill-php81/composer.json  g  #@      F   vendor/symfony/security-bundle/DataCollector/SecurityDataCollector.php>.  g>.  n      &   vendor/symfony/security-bundle/LICENSE,  g,  U      +   vendor/symfony/security-bundle/CHANGELOG.mdCD  gCD  ;      ?   vendor/symfony/security-bundle/Security/LazyFirewallContext.php	  g	  Ӈ      =   vendor/symfony/security-bundle/Security/UserAuthenticator.php>  g>  @      ;   vendor/symfony/security-bundle/Security/FirewallContext.phpC  gC  7{Ȥ      7   vendor/symfony/security-bundle/Security/FirewallMap.php;	  g;	  5r\      :   vendor/symfony/security-bundle/Security/FirewallConfig.php	  g	  `9p      >   vendor/symfony/security-bundle/Security/FirewallAwareTrait.php  g  s      W   vendor/symfony/security-bundle/Resources/config/security_authenticator_access_token.php  g  43MU      C   vendor/symfony/security-bundle/Resources/config/templating_twig.php  g  @']      F   vendor/symfony/security-bundle/Resources/config/security_listeners.php  g  Ne      U   vendor/symfony/security-bundle/Resources/config/security_authenticator_login_link.php	  g	  +      B   vendor/symfony/security-bundle/Resources/config/security_debug.php3  g3  6!H!      A   vendor/symfony/security-bundle/Resources/config/debug_console.php   g         G   vendor/symfony/security-bundle/Resources/config/schema/security-1.0.xsdX  gX  f#      ;   vendor/symfony/security-bundle/Resources/config/console.php  g  ,      C   vendor/symfony/security-bundle/Resources/config/password_hasher.php  g  J      >   vendor/symfony/security-bundle/Resources/config/collectors.php  g  u|      J   vendor/symfony/security-bundle/Resources/config/security_authenticator.php  g  VQ      <   vendor/symfony/security-bundle/Resources/config/security.php	.  g	.  អ      V   vendor/symfony/security-bundle/Resources/config/security_authenticator_remember_me.php  g  K      A   vendor/symfony/security-bundle/Resources/views/Collector/icon.svg  g  0צ      K   vendor/symfony/security-bundle/Resources/views/Collector/security.html.twige  ge  Y      D   vendor/symfony/security-bundle/CacheWarmer/ExpressionCacheWarmer.phpq  gq  50      1   vendor/symfony/security-bundle/SecurityBundle.php  g  7-X      (   vendor/symfony/security-bundle/README.md  g  [A      H   vendor/symfony/security-bundle/RememberMe/DecoratedRememberMeHandler.php^  g^  H:y      L   vendor/symfony/security-bundle/RememberMe/FirewallAwareRememberMeHandler.php@  g@  G٤      ?   vendor/symfony/security-bundle/Command/DebugFirewallCommand.php"  g"  ž&x      <   vendor/symfony/security-bundle/Routing/LogoutRouteLoader.php=  g=  פ      +   vendor/symfony/security-bundle/Security.php%  g%        J   vendor/symfony/security-bundle/LoginLink/FirewallAwareLoginLinkHandler.php	  g	  ߡ      H   vendor/symfony/security-bundle/DependencyInjection/MainConfiguration.phpS9  gS9  |      c   vendor/symfony/security-bundle/DependencyInjection/Security/AccessToken/OidcTokenHandlerFactory.php3  g3  V      k   vendor/symfony/security-bundle/DependencyInjection/Security/AccessToken/OidcUserInfoTokenHandlerFactory.php
  g
  ~G      f   vendor/symfony/security-bundle/DependencyInjection/Security/AccessToken/ServiceTokenHandlerFactory.php  g  CWߤ      h   vendor/symfony/security-bundle/DependencyInjection/Security/AccessToken/TokenHandlerFactoryInterface.php  g  w(      X   vendor/symfony/security-bundle/DependencyInjection/Security/UserProvider/LdapFactory.php	  g	  HX      \   vendor/symfony/security-bundle/DependencyInjection/Security/UserProvider/InMemoryFactory.php  g  bHq      i   vendor/symfony/security-bundle/DependencyInjection/Security/UserProvider/UserProviderFactoryInterface.php  g  vi      X   vendor/symfony/security-bundle/DependencyInjection/Security/Factory/LoginLinkFactory.phpm  gm  pSʤ      \   vendor/symfony/security-bundle/DependencyInjection/Security/Factory/HttpBasicLdapFactory.php  g  (腊      \   vendor/symfony/security-bundle/DependencyInjection/Security/Factory/JsonLoginLdapFactory.php  g  Rz      Z   vendor/symfony/security-bundle/DependencyInjection/Security/Factory/AccessTokenFactory.php  g  AY      X   vendor/symfony/security-bundle/DependencyInjection/Security/Factory/FormLoginFactory.phpv  gv  zä      \   vendor/symfony/security-bundle/DependencyInjection/Security/Factory/FormLoginLdapFactory.phpK  gK  pR      b   vendor/symfony/security-bundle/DependencyInjection/Security/Factory/CustomAuthenticatorFactory.php  g  Xi      Y   vendor/symfony/security-bundle/DependencyInjection/Security/Factory/RemoteUserFactory.php  g  :Pդ      e   vendor/symfony/security-bundle/DependencyInjection/Security/Factory/AuthenticatorFactoryInterface.phpG  gG  3S      Y   vendor/symfony/security-bundle/DependencyInjection/Security/Factory/RememberMeFactory.php*  g*  隤      W   vendor/symfony/security-bundle/DependencyInjection/Security/Factory/AbstractFactory.php  g  p      S   vendor/symfony/security-bundle/DependencyInjection/Security/Factory/X509Factory.php  g  Vr@      a   vendor/symfony/security-bundle/DependencyInjection/Security/Factory/SignatureAlgorithmFactory.phpf  gf  P      h   vendor/symfony/security-bundle/DependencyInjection/Security/Factory/FirewallListenerFactoryInterface.php  g  }/      X   vendor/symfony/security-bundle/DependencyInjection/Security/Factory/JsonLoginFactory.php  g  
      n   vendor/symfony/security-bundle/DependencyInjection/Security/Factory/StatelessAuthenticatorFactoryInterface.php	  g	  9̤      X   vendor/symfony/security-bundle/DependencyInjection/Security/Factory/HttpBasicFactory.php  g  soF      X   vendor/symfony/security-bundle/DependencyInjection/Security/Factory/LdapFactoryTrait.phpm	  gm	  盤      ^   vendor/symfony/security-bundle/DependencyInjection/Security/Factory/LoginThrottlingFactory.php  g  .b      H   vendor/symfony/security-bundle/DependencyInjection/SecurityExtension.php  g  =2W[      b   vendor/symfony/security-bundle/DependencyInjection/Compiler/AddExpressionLanguageProvidersPass.php  g  ߐ*7      ^   vendor/symfony/security-bundle/DependencyInjection/Compiler/RegisterTokenUsageTrackingPass.php	  g	  І;      W   vendor/symfony/security-bundle/DependencyInjection/Compiler/RegisterLdapLocatorPass.phpW  gW  9k      h   vendor/symfony/security-bundle/DependencyInjection/Compiler/RegisterGlobalSecurityEventListenersPass.php 
  g 
  Ǔ      Y   vendor/symfony/security-bundle/DependencyInjection/Compiler/SortFirewallListenersPass.phpO  gO  դ      e   vendor/symfony/security-bundle/DependencyInjection/Compiler/ReplaceDecoratedRememberMeHandlerPass.php	  g	  >y      ^   vendor/symfony/security-bundle/DependencyInjection/Compiler/AddSessionDomainConstraintPass.php  g  x      U   vendor/symfony/security-bundle/DependencyInjection/Compiler/AddSecurityVotersPass.php
  g
  rҤ      V   vendor/symfony/security-bundle/DependencyInjection/Compiler/RegisterEntryPointPass.php  g  d%      i   vendor/symfony/security-bundle/DependencyInjection/Compiler/MakeFirewallsEventDispatcherTraceablePass.php`
  g`
  U
p3      [   vendor/symfony/security-bundle/DependencyInjection/Compiler/CleanRememberMeVerifierPass.php  g  "*A      X   vendor/symfony/security-bundle/DependencyInjection/Compiler/RegisterCsrfFeaturesPass.php	  g	  8I      ,   vendor/symfony/security-bundle/composer.json  g  ֛      B   vendor/symfony/security-bundle/Debug/TraceableFirewallListener.phpN  gN  Z.      8   vendor/symfony/security-bundle/Debug/WrappedListener.php  g  D      ?   vendor/symfony/security-bundle/Debug/TraceableListenerTrait.phpj  gj  qU      <   vendor/symfony/security-bundle/Debug/WrappedLazyListener.php  g  
9      A   vendor/symfony/security-bundle/EventListener/FirewallListener.php  g  +C      =   vendor/symfony/security-bundle/EventListener/VoteListener.phpB  gB  <ˊϤ      4   vendor/symfony/config/ResourceCheckerConfigCache.php~  g~  p         vendor/symfony/config/LICENSE,  g,  U      '   vendor/symfony/config/Util/XmlUtils.php$  g$  U6      <   vendor/symfony/config/Util/Exception/XmlParsingException.php  g  䢗      <   vendor/symfony/config/Util/Exception/InvalidXmlException.php4  g4        "   vendor/symfony/config/CHANGELOG.mde  ge  (,      .   vendor/symfony/config/ConfigCacheInterface.php  g  	1      .   vendor/symfony/config/FileLocatorInterface.php  g        %   vendor/symfony/config/ConfigCache.php  g  S      5   vendor/symfony/config/ConfigCacheFactoryInterface.php  g  ^&      %   vendor/symfony/config/FileLocator.php4
  g4
  =      2   vendor/symfony/config/ResourceCheckerInterface.php  g  åؤ         vendor/symfony/config/README.mdT  gT        '   vendor/symfony/config/Loader/Loader.php  g  IѤ      >   vendor/symfony/config/Loader/DirectoryAwareLoaderInterface.php  g  j=      +   vendor/symfony/config/Loader/FileLoader.php  g  bUL      2   vendor/symfony/config/Loader/ParamConfigurator.phpq  gq  n݁      0   vendor/symfony/config/Loader/LoaderInterface.phpy  gy  ঽ      8   vendor/symfony/config/Loader/LoaderResolverInterface.php  g  G/3      /   vendor/symfony/config/Loader/LoaderResolver.phpF  gF  )%%      1   vendor/symfony/config/Loader/DelegatingLoader.php  g  Κ%      /   vendor/symfony/config/Loader/GlobFileLoader.php  g  [      .   vendor/symfony/config/Definition/FloatNode.php  g  Ť      -   vendor/symfony/config/Definition/BaseNode.php:  g:  qY6      0   vendor/symfony/config/Definition/NumericNode.php)  g)  	ä      :   vendor/symfony/config/Definition/ConfigurableInterface.phpo  go  jש,      0   vendor/symfony/config/Definition/IntegerNode.phpV  gV  (      ;   vendor/symfony/config/Definition/PrototypeNodeInterface.phpp  gp  <5@      2   vendor/symfony/config/Definition/Configuration.php  g  j      8   vendor/symfony/config/Definition/PrototypedArrayNode.php,  g,  d#      .   vendor/symfony/config/Definition/Processor.php	  g	   \      @   vendor/symfony/config/Definition/Loader/DefinitionFileLoader.php  g   "      2   vendor/symfony/config/Definition/NodeInterface.phpL  gL  Q      -   vendor/symfony/config/Definition/EnumNode.php
  g
  |      0   vendor/symfony/config/Definition/BooleanNode.php  g  
B      H   vendor/symfony/config/Definition/Configurator/DefinitionConfigurator.phpy  gy  =      .   vendor/symfony/config/Definition/ArrayNode.php.  g.  ͤ      /   vendor/symfony/config/Definition/ScalarNode.php}  g}  GrI      ;   vendor/symfony/config/Definition/ConfigurationInterface.php  g  _+      8   vendor/symfony/config/Definition/Builder/ExprBuilder.phpL  gL  :^      ?   vendor/symfony/config/Definition/Builder/EnumNodeDefinition.php  g  <      9   vendor/symfony/config/Definition/Builder/MergeBuilder.php  g  |      B   vendor/symfony/config/Definition/Builder/NumericNodeDefinition.phpm  gm  Mg      8   vendor/symfony/config/Definition/Builder/NodeBuilder.php  g  |פ      C   vendor/symfony/config/Definition/Builder/VariableNodeDefinition.phpg  gg  ?      @   vendor/symfony/config/Definition/Builder/ArrayNodeDefinition.php=  g=  M}      B   vendor/symfony/config/Definition/Builder/BuilderAwareInterface.phpl  gl  %      >   vendor/symfony/config/Definition/Builder/ValidationBuilder.php  g  ]
      8   vendor/symfony/config/Definition/Builder/TreeBuilder.phpE  gE  O      B   vendor/symfony/config/Definition/Builder/IntegerNodeDefinition.php  g  \+F}      @   vendor/symfony/config/Definition/Builder/NodeParentInterface.php  g  ʤ      A   vendor/symfony/config/Definition/Builder/NormalizationBuilder.php  g  Xä      B   vendor/symfony/config/Definition/Builder/BooleanNodeDefinition.php  g  YDq      J   vendor/symfony/config/Definition/Builder/ParentNodeDefinitionInterface.php  g  Σ      A   vendor/symfony/config/Definition/Builder/ScalarNodeDefinition.php  g  *@      @   vendor/symfony/config/Definition/Builder/FloatNodeDefinition.php  g  ю      ;   vendor/symfony/config/Definition/Builder/NodeDefinition.phpf  gf  3Ԥ      D   vendor/symfony/config/Definition/Exception/DuplicateKeyException.phpS  gS  g      I   vendor/symfony/config/Definition/Exception/InvalidDefinitionException.php  g  re      C   vendor/symfony/config/Definition/Exception/InvalidTypeException.php  g  2      @   vendor/symfony/config/Definition/Exception/UnsetKeyException.php*  g*  %2d      L   vendor/symfony/config/Definition/Exception/InvalidConfigurationException.php  g  i      J   vendor/symfony/config/Definition/Exception/ForbiddenOverwriteException.php_  g_  :      8   vendor/symfony/config/Definition/Exception/Exception.php  g  RrO      1   vendor/symfony/config/Definition/VariableNode.php
  g
  o      ?   vendor/symfony/config/Definition/Dumper/YamlReferenceDumper.php   g   0      >   vendor/symfony/config/Definition/Dumper/XmlReferenceDumper.php'  g'        @   vendor/symfony/config/Resource/SelfCheckingResourceInterface.php  g  2Ф      /   vendor/symfony/config/Resource/FileResource.php  g  a      :   vendor/symfony/config/Resource/ReflectionClassResource.php  g  h[      >   vendor/symfony/config/Resource/SelfCheckingResourceChecker.php}  g}  r      3   vendor/symfony/config/Resource/ComposerResource.php2  g2  3Pu      8   vendor/symfony/config/Resource/FileExistenceResource.php  g  w}      4   vendor/symfony/config/Resource/ResourceInterface.php  g  8I      9   vendor/symfony/config/Resource/ClassExistenceResource.php   g   T$      4   vendor/symfony/config/Resource/DirectoryResource.php
  g
  C      /   vendor/symfony/config/Resource/GlobResource.phpW!  gW!  ׏3      8   vendor/symfony/config/Builder/ConfigBuilderInterface.php  g  {O      (   vendor/symfony/config/Builder/Method.php  g  @֤      .   vendor/symfony/config/Builder/ClassBuilder.php  g        *   vendor/symfony/config/Builder/Property.php,  g,  _      A   vendor/symfony/config/Builder/ConfigBuilderGeneratorInterface.php  g        8   vendor/symfony/config/Builder/ConfigBuilderGenerator.phpR  gR  &	      7   vendor/symfony/config/Exception/LoaderLoadException.php  g  /z      N   vendor/symfony/config/Exception/FileLoaderImportCircularReferenceException.php[  g[  `ܤ      D   vendor/symfony/config/Exception/FileLocatorFileNotFoundException.phpK  gK  f      #   vendor/symfony/config/composer.json   g   M      ,   vendor/symfony/config/ConfigCacheFactory.phpS  gS  cġ      ;   vendor/symfony/config/ResourceCheckerConfigCacheFactory.php5  g5  Yb      D   vendor/symfony/security-http/RateLimiter/DefaultLoginRateLimiter.php  g  b      4   vendor/symfony/security-http/Attribute/IsGranted.php  g  `A      6   vendor/symfony/security-http/Attribute/CurrentUser.php!  g!  C      $   vendor/symfony/security-http/LICENSE,  g,  U      5   vendor/symfony/security-http/Util/TargetPathTrait.phpb  gb  6=Y      )   vendor/symfony/security-http/CHANGELOG.md  g  k      ,   vendor/symfony/security-http/FirewallMap.phpf  gf  r      )   vendor/symfony/security-http/Firewall.php]  g]        J   vendor/symfony/security-http/AccessToken/AccessTokenExtractorInterface.phpf  gf  }P      H   vendor/symfony/security-http/AccessToken/AccessTokenHandlerInterface.php  g  msl      G   vendor/symfony/security-http/AccessToken/HeaderAccessTokenExtractor.php8  g8  h      F   vendor/symfony/security-http/AccessToken/ChainAccessTokenExtractor.php'  g'  g
      J   vendor/symfony/security-http/AccessToken/Oidc/OidcUserInfoTokenHandler.php  g  mɤ      ;   vendor/symfony/security-http/AccessToken/Oidc/OidcTrait.php  g  ̤      B   vendor/symfony/security-http/AccessToken/Oidc/OidcTokenHandler.php  g  !]6      U   vendor/symfony/security-http/AccessToken/Oidc/Exception/InvalidSignatureException.php  g  +FL      Q   vendor/symfony/security-http/AccessToken/Oidc/Exception/MissingClaimException.php  g  	      E   vendor/symfony/security-http/AccessToken/FormEncodedBodyExtractor.phpm  gm  }      F   vendor/symfony/security-http/AccessToken/QueryAccessTokenExtractor.php  g  w      :   vendor/symfony/security-http/Logout/LogoutUrlGenerator.phpv  gv  +      /   vendor/symfony/security-http/SecurityEvents.php  g  7      8   vendor/symfony/security-http/Firewall/AccessListener.php
  g
  8ä      9   vendor/symfony/security-http/Firewall/ContextListener.php5  g5  M-      :   vendor/symfony/security-http/Firewall/AbstractListener.phpq  gq        F   vendor/symfony/security-http/Firewall/AuthenticatorManagerListener.phpj  gj  ʯ      ;   vendor/symfony/security-http/Firewall/ExceptionListener.phpf(  gf(  ti      C   vendor/symfony/security-http/Firewall/FirewallListenerInterface.php=  g=  9      9   vendor/symfony/security-http/Firewall/ChannelListener.php  g  2      <   vendor/symfony/security-http/Firewall/SwitchUserListener.phpE$  gE$  hް      8   vendor/symfony/security-http/Firewall/LogoutListener.php  g  (3\      F   vendor/symfony/security-http/Controller/SecurityTokenValueResolver.php  g  J;Y      =   vendor/symfony/security-http/Controller/UserValueResolver.php  g  ؉M      &   vendor/symfony/security-http/README.md  g  k      <   vendor/symfony/security-http/RememberMe/ResponseListener.php  g         G   vendor/symfony/security-http/RememberMe/PersistentRememberMeHandler.phpc  gc  TKљ      F   vendor/symfony/security-http/RememberMe/RememberMeHandlerInterface.php
  g
  	~¤      =   vendor/symfony/security-http/RememberMe/RememberMeDetails.phpQ  gQ  Gk<[      E   vendor/symfony/security-http/RememberMe/AbstractRememberMeHandler.phpX  gX  a*      F   vendor/symfony/security-http/RememberMe/SignatureRememberMeHandler.php
  g
  xo$f      M   vendor/symfony/security-http/EntryPoint/AuthenticationEntryPointInterface.php  g  3i      N   vendor/symfony/security-http/EntryPoint/Exception/NotAnEntryPointException.php  g  (6      *   vendor/symfony/security-http/HttpUtils.php  g  e      5   vendor/symfony/security-http/FirewallMapInterface.php  g  9J      L   vendor/symfony/security-http/Authenticator/Token/PostAuthenticationToken.phpT  gT  H      P   vendor/symfony/security-http/Authenticator/InteractiveAuthenticatorInterface.phpj  gj  9      M   vendor/symfony/security-http/Authenticator/AbstractLoginFormAuthenticator.php	  g	  e      E   vendor/symfony/security-http/Authenticator/AuthenticatorInterface.phpS
  gS
  v
      A   vendor/symfony/security-http/Authenticator/FallbackUserLoader.php  g  ٤      D   vendor/symfony/security-http/Authenticator/AbstractAuthenticator.php  g   R      E   vendor/symfony/security-http/Authenticator/HttpBasicAuthenticator.phpe  ge  Z      E   vendor/symfony/security-http/Authenticator/LoginLinkAuthenticator.php?  g?  !6      E   vendor/symfony/security-http/Authenticator/JsonLoginAuthenticator.php  g  7$;      N   vendor/symfony/security-http/Authenticator/Passport/SelfValidatingPassport.php  g  YWW      @   vendor/symfony/security-http/Authenticator/Passport/Passport.php$  g$   ;!2      X   vendor/symfony/security-http/Authenticator/Passport/Credentials/CredentialsInterface.php  g  P      U   vendor/symfony/security-http/Authenticator/Passport/Credentials/CustomCredentials.php  g  @1      W   vendor/symfony/security-http/Authenticator/Passport/Credentials/PasswordCredentials.phpV  gV  R      W   vendor/symfony/security-http/Authenticator/Passport/Badge/PreAuthenticatedUserBadge.php  g  yΤ      L   vendor/symfony/security-http/Authenticator/Passport/Badge/CsrfTokenBadge.phpi  gi  $      R   vendor/symfony/security-http/Authenticator/Passport/Badge/PasswordUpgradeBadge.phpV  gV  Ĥ      G   vendor/symfony/security-http/Authenticator/Passport/Badge/UserBadge.php  g  V5פ      M   vendor/symfony/security-http/Authenticator/Passport/Badge/RememberMeBadge.phpK  gK  p"      L   vendor/symfony/security-http/Authenticator/Passport/Badge/BadgeInterface.php  g  ˙Au      @   vendor/symfony/security-http/Authenticator/X509Authenticator.php	  g	  }      G   vendor/symfony/security-http/Authenticator/AccessTokenAuthenticator.php  g  YTS      F   vendor/symfony/security-http/Authenticator/RemoteUserAuthenticator.php  g  _]z      E   vendor/symfony/security-http/Authenticator/FormLoginAuthenticator.phpS  gS  eQ8      T   vendor/symfony/security-http/Authenticator/AbstractPreAuthenticatedAuthenticator.php  g  hʆ`      K   vendor/symfony/security-http/Authenticator/Debug/TraceableAuthenticator.phpO  gO  ӊ2      Z   vendor/symfony/security-http/Authenticator/Debug/TraceableAuthenticatorManagerListener.phpg  gg        F   vendor/symfony/security-http/Authenticator/RememberMeAuthenticator.php  g  Au      K   vendor/symfony/security-http/Authorization/AccessDeniedHandlerInterface.phpz  gz  (      3   vendor/symfony/security-http/AccessMapInterface.phpi  gi  HY%      ;   vendor/symfony/security-http/LoginLink/LoginLinkDetails.phpe  ge  Z/      ;   vendor/symfony/security-http/LoginLink/LoginLinkHandler.php  g  ̸      @   vendor/symfony/security-http/LoginLink/LoginLinkNotification.php
  g
  ֽ      D   vendor/symfony/security-http/LoginLink/LoginLinkHandlerInterface.php  g  \S      W   vendor/symfony/security-http/LoginLink/Exception/InvalidLoginLinkExceptionInterface.php  g  HF      N   vendor/symfony/security-http/LoginLink/Exception/InvalidLoginLinkException.php  g        \   vendor/symfony/security-http/LoginLink/Exception/InvalidLoginLinkAuthenticationException.php  g  <Yķ      N   vendor/symfony/security-http/LoginLink/Exception/ExpiredLoginLinkException.phpI  gI  Z      S   vendor/symfony/security-http/Authentication/DefaultAuthenticationFailureHandler.phph  gh  [)-G      M   vendor/symfony/security-http/Authentication/AuthenticatorManagerInterface.php  g  1      R   vendor/symfony/security-http/Authentication/CustomAuthenticationSuccessHandler.php  g  W"¤      U   vendor/symfony/security-http/Authentication/AuthenticationFailureHandlerInterface.php>  g>        C   vendor/symfony/security-http/Authentication/AuthenticationUtils.php	  g	  ج      R   vendor/symfony/security-http/Authentication/CustomAuthenticationFailureHandler.php  g  c      U   vendor/symfony/security-http/Authentication/AuthenticationSuccessHandlerInterface.phpI  gI  &4Q      J   vendor/symfony/security-http/Authentication/UserAuthenticatorInterface.php  g  
>      D   vendor/symfony/security-http/Authentication/AuthenticatorManager.php6  g6  c
9      S   vendor/symfony/security-http/Authentication/DefaultAuthenticationSuccessHandler.php  g  N"      *   vendor/symfony/security-http/AccessMap.php~  g~  t<y      8   vendor/symfony/security-http/Event/LoginFailureEvent.php;
  g;
  (Ϥ      8   vendor/symfony/security-http/Event/LoginSuccessEvent.php<  g<  .      8   vendor/symfony/security-http/Event/LazyResponseEvent.php  g  /H
      6   vendor/symfony/security-http/Event/SwitchUserEvent.php  g  U      F   vendor/symfony/security-http/Event/AuthenticationTokenCreatedEvent.phpW  gW  c|      9   vendor/symfony/security-http/Event/CheckPassportEvent.php  g  g      <   vendor/symfony/security-http/Event/InteractiveLoginEvent.phpG  gG  <KB      2   vendor/symfony/security-http/Event/LogoutEvent.php  g        @   vendor/symfony/security-http/Event/TokenDeauthenticatedEvent.php  g  X2      D   vendor/symfony/security-http/Impersonate/ImpersonateUrlGenerator.php%  g%  ./ U      2   vendor/symfony/security-http/ParameterBagUtils.php  g  [7b      *   vendor/symfony/security-http/composer.json\  g\  7      :   vendor/symfony/security-http/SecurityRequestAttributes.php  g  J      J   vendor/symfony/security-http/EventListener/ClearSiteDataLogoutListener.php  g  jͤ      D   vendor/symfony/security-http/EventListener/SessionLogoutListener.php  g  t      D   vendor/symfony/security-http/EventListener/DefaultLogoutListener.phpm  gm        H   vendor/symfony/security-http/EventListener/PasswordMigratingListener.php  g  £פ      A   vendor/symfony/security-http/EventListener/RememberMeListener.php  g  vx.ʤ      F   vendor/symfony/security-http/EventListener/LoginThrottlingListener.php
  g
  L      C   vendor/symfony/security-http/EventListener/UserProviderListener.phpf  gf  6i      K   vendor/symfony/security-http/EventListener/CookieClearingLogoutListener.php  g  o[      G   vendor/symfony/security-http/EventListener/CheckCredentialsListener.php  g  );L      F   vendor/symfony/security-http/EventListener/SessionStrategyListener.php  g  Yؤ      N   vendor/symfony/security-http/EventListener/CsrfTokenClearingLogoutListener.phpp  gp  u      B   vendor/symfony/security-http/EventListener/UserCheckerListener.phpi  gi  g%      I   vendor/symfony/security-http/EventListener/IsGrantedAttributeListener.php  g  5D      E   vendor/symfony/security-http/EventListener/CsrfProtectionListener.php  g        P   vendor/symfony/security-http/EventListener/CheckRememberMeConditionsListener.php
  g
  wj      O   vendor/symfony/security-http/Session/SessionAuthenticationStrategyInterface.phpC  gC  'ʤ      F   vendor/symfony/security-http/Session/SessionAuthenticationStrategy.php]  g]  Q         vendor/symfony/uid/UuidV8.phpK  gK  {dL      !   vendor/symfony/uid/BinaryUtil.php-  g-   Ҥ         vendor/symfony/uid/NilUuid.php  g  MzĤ         vendor/symfony/uid/LICENSE,  g,  K         vendor/symfony/uid/NilUlid.php  g  [         vendor/symfony/uid/CHANGELOG.md  g        "   vendor/symfony/uid/AbstractUid.php[  g[  boO         vendor/symfony/uid/Ulid.phpP  gP  ݤ         vendor/symfony/uid/Uuid.php  g  t0[O         vendor/symfony/uid/MaxUlid.php  g  >Z         vendor/symfony/uid/MaxUuid.php  g  Sw4         vendor/symfony/uid/README.md\  g\        2   vendor/symfony/uid/Command/GenerateUuidCommand.php(  g(  vF@      2   vendor/symfony/uid/Command/GenerateUlidCommand.php  g  ->      1   vendor/symfony/uid/Command/InspectUuidCommand.php
  g
  +}      1   vendor/symfony/uid/Command/InspectUlidCommand.php  g  0>Ȉ         vendor/symfony/uid/UuidV1.phpV  gV  ʤ         vendor/symfony/uid/UuidV3.php^  g^  (L         vendor/symfony/uid/UuidV6.phpN  gN  ͤ         vendor/symfony/uid/UuidV7.php  g  ,aä      3   vendor/symfony/uid/Factory/TimeBasedUuidFactory.php-  g-  i`mU      *   vendor/symfony/uid/Factory/UuidFactory.php>
  g>
   Xw      5   vendor/symfony/uid/Factory/RandomBasedUuidFactory.php[  g[  \(R      *   vendor/symfony/uid/Factory/UlidFactory.php  g  )ݿ      3   vendor/symfony/uid/Factory/NameBasedUuidFactory.php  g  0 A          vendor/symfony/uid/composer.json  g  s	ۤ      ,   vendor/symfony/uid/TimeBasedUidInterface.php  g  Q         vendor/symfony/uid/UuidV5.php^  g^  A         vendor/symfony/uid/UuidV4.php  g  <      <   vendor/symfony/event-dispatcher/EventDispatcherInterface.php  g  a      =   vendor/symfony/event-dispatcher/Attribute/AsEventListener.php  g  $      '   vendor/symfony/event-dispatcher/LICENSE,  g,  U      ,   vendor/symfony/event-dispatcher/CHANGELOG.md]  g]  uE~      3   vendor/symfony/event-dispatcher/EventDispatcher.php9#  g9#  ή&      )   vendor/symfony/event-dispatcher/README.mdW  gW  ,fB      <   vendor/symfony/event-dispatcher/EventSubscriberInterface.php  g  A{)      <   vendor/symfony/event-dispatcher/ImmutableEventDispatcher.php  g  w      0   vendor/symfony/event-dispatcher/GenericEvent.php
  g
  d      M   vendor/symfony/event-dispatcher/DependencyInjection/RegisterListenersPass.php   g   i٤      K   vendor/symfony/event-dispatcher/DependencyInjection/AddEventAliasesPass.php  g  &{      -   vendor/symfony/event-dispatcher/composer.json  g  R      B   vendor/symfony/event-dispatcher/Debug/TraceableEventDispatcher.php0  g0  U*u      9   vendor/symfony/event-dispatcher/Debug/WrappedListener.php  g  okŤ      +   vendor/symfony/var-dumper/Cloner/Cursor.phpH  gH  cq      .   vendor/symfony/var-dumper/Cloner/VarCloner.php)  g)  
      4   vendor/symfony/var-dumper/Cloner/ClonerInterface.php  g  ze      7   vendor/symfony/var-dumper/Cloner/Internal/NoDefault.php4  g4  ߞ      4   vendor/symfony/var-dumper/Cloner/DumperInterface.phpo  go  k      3   vendor/symfony/var-dumper/Cloner/AbstractCloner.php]  g]  $^      )   vendor/symfony/var-dumper/Cloner/Data.php5  g5  G      )   vendor/symfony/var-dumper/Cloner/Stub.phpk  gk  Xܤ      !   vendor/symfony/var-dumper/LICENSE,  g,  .z      5   vendor/symfony/var-dumper/Test/VarDumperTestTrait.phpV
  gV
  F      &   vendor/symfony/var-dumper/CHANGELOG.md	  g	  "D      .   vendor/symfony/var-dumper/Caster/GmpCaster.php
  g
  "       5   vendor/symfony/var-dumper/Caster/ReflectionCaster.php;  g;  -,      /   vendor/symfony/var-dumper/Caster/StubCaster.php	  g	  @v      2   vendor/symfony/var-dumper/Caster/SymfonyCaster.php
  g
  Ҥ      .   vendor/symfony/var-dumper/Caster/FrameStub.php  g  aa      7   vendor/symfony/var-dumper/Caster/ProxyManagerCaster.php#  g#  DJ      .   vendor/symfony/var-dumper/Caster/FFICaster.php  g  ь      /   vendor/symfony/var-dumper/Caster/DateCaster.php;  g;  C7>      .   vendor/symfony/var-dumper/Caster/PdoCaster.php  g  ɤ      6   vendor/symfony/var-dumper/Caster/XmlResourceCaster.php|	  g|	        3   vendor/symfony/var-dumper/Caster/ResourceCaster.php  g  ~      4   vendor/symfony/var-dumper/Caster/ExceptionCaster.phpmA  gmA  SL      6   vendor/symfony/var-dumper/Caster/UninitializedStub.phpy  gy  0:      -   vendor/symfony/var-dumper/Caster/DsCaster.phpS  gS  c      -   vendor/symfony/var-dumper/Caster/LinkStub.phpH
  gH
  ϼ      4   vendor/symfony/var-dumper/Caster/MemcachedCaster.php  g  Y#g	      3   vendor/symfony/var-dumper/Caster/DoctrineCaster.phpG  gG  55      2   vendor/symfony/var-dumper/Caster/RdKafkaCaster.php  g  9#      1   vendor/symfony/var-dumper/Caster/MysqliCaster.php  g        ,   vendor/symfony/var-dumper/Caster/ImgStub.php  g  ͤ      .   vendor/symfony/var-dumper/Caster/ClassStub.php?  g?  7V      .   vendor/symfony/var-dumper/Caster/TraceStub.php  g  _      1   vendor/symfony/var-dumper/Caster/CutArrayStub.php  g  QG      0   vendor/symfony/var-dumper/Caster/PgSqlCaster.phpj  gj  'K4      +   vendor/symfony/var-dumper/Caster/Caster.php*  g*  n      .   vendor/symfony/var-dumper/Caster/SplCaster.php]  g]  4Dӻ      .   vendor/symfony/var-dumper/Caster/ConstStub.php   g   3Ôk      /   vendor/symfony/var-dumper/Caster/ScalarStub.phpF  gF  fA      /   vendor/symfony/var-dumper/Caster/DsPairStub.phpn  gn  0
      /   vendor/symfony/var-dumper/Caster/IntlCaster.php  g        0   vendor/symfony/var-dumper/Caster/RedisCaster.php  g  $OP      0   vendor/symfony/var-dumper/Caster/FiberCaster.phpf  gf  K      2   vendor/symfony/var-dumper/Caster/ImagineCaster.php  g  |gdߤ      /   vendor/symfony/var-dumper/Caster/AmqpCaster.phpH  gH        .   vendor/symfony/var-dumper/Caster/DOMCaster.phpN  gN  t      /   vendor/symfony/var-dumper/Caster/UuidCaster.php  g  E7      4   vendor/symfony/var-dumper/Caster/XmlReaderCaster.php  g  5      -   vendor/symfony/var-dumper/Caster/ArgsStub.php	  g	  O      -   vendor/symfony/var-dumper/Caster/EnumStub.php  g  `"      ,   vendor/symfony/var-dumper/Caster/CutStub.php  g        7   vendor/symfony/var-dumper/Resources/bin/var-dump-server  g  '      :   vendor/symfony/var-dumper/Resources/css/htmlDescriptor.css  g  Dva      8   vendor/symfony/var-dumper/Resources/js/htmlDescriptor.jsb  gb  h|      6   vendor/symfony/var-dumper/Resources/functions/dump.phpU  gU  <      /   vendor/symfony/var-dumper/Server/Connection.php
  g
  xΤ      /   vendor/symfony/var-dumper/Server/DumpServer.php  g  U駤      #   vendor/symfony/var-dumper/README.md_  g_  Fq      7   vendor/symfony/var-dumper/Command/ServerDumpCommand.php  g  S+      H   vendor/symfony/var-dumper/Command/Descriptor/DumpDescriptorInterface.php  g  a*      >   vendor/symfony/var-dumper/Command/Descriptor/CliDescriptor.php
  g
  d      ?   vendor/symfony/var-dumper/Command/Descriptor/HtmlDescriptor.php  g  	      ?   vendor/symfony/var-dumper/Exception/ThrowingCasterException.php  g  ä      1   vendor/symfony/var-dumper/Dumper/ServerDumper.php  g  DZ      8   vendor/symfony/var-dumper/Dumper/DataDumperInterface.php@  g@  o/      M   vendor/symfony/var-dumper/Dumper/ContextProvider/ContextProviderInterface.php(  g(  EFf      K   vendor/symfony/var-dumper/Dumper/ContextProvider/RequestContextProvider.php  g  oꭤ      G   vendor/symfony/var-dumper/Dumper/ContextProvider/CliContextProvider.php  g  y9.L      J   vendor/symfony/var-dumper/Dumper/ContextProvider/SourceContextProvider.php  g  u      3   vendor/symfony/var-dumper/Dumper/AbstractDumper.php0  g0        .   vendor/symfony/var-dumper/Dumper/CliDumper.phpZ  gZ  '      9   vendor/symfony/var-dumper/Dumper/ContextualizedDumper.php  g  U      /   vendor/symfony/var-dumper/Dumper/HtmlDumper.php<  g<   F      '   vendor/symfony/var-dumper/composer.jsonw  gw  %E      '   vendor/symfony/var-dumper/VarDumper.php  g  Ϥ      !   vendor/symfony/filesystem/LICENSE,  g,  U      &   vendor/symfony/filesystem/CHANGELOG.md  g  I      (   vendor/symfony/filesystem/Filesystem.phpt  gt  1      "   vendor/symfony/filesystem/Path.php
f  g
f  ׀s      #   vendor/symfony/filesystem/README.md  g        <   vendor/symfony/filesystem/Exception/IOExceptionInterface.php  g        :   vendor/symfony/filesystem/Exception/ExceptionInterface.php  g  (l`Ф      8   vendor/symfony/filesystem/Exception/RuntimeException.php  g  A      3   vendor/symfony/filesystem/Exception/IOException.php  g  0      @   vendor/symfony/filesystem/Exception/InvalidArgumentException.php  g  $
      =   vendor/symfony/filesystem/Exception/FileNotFoundException.php  g   [:      '   vendor/symfony/filesystem/composer.json{  g{  zq      G   vendor/symfony/security-csrf/TokenStorage/NativeSessionTokenStorage.php
  g
  .פ      A   vendor/symfony/security-csrf/TokenStorage/SessionTokenStorage.phpK  gK  <_      L   vendor/symfony/security-csrf/TokenStorage/ClearableTokenStorageInterface.php3  g3        C   vendor/symfony/security-csrf/TokenStorage/TokenStorageInterface.php  g  7䭤      $   vendor/symfony/security-csrf/LICENSE,  g,  U      )   vendor/symfony/security-csrf/CHANGELOG.md  g  >*      *   vendor/symfony/security-csrf/CsrfToken.php  g  3      &   vendor/symfony/security-csrf/README.md  g        :   vendor/symfony/security-csrf/CsrfTokenManagerInterface.php  g  yɤ      E   vendor/symfony/security-csrf/TokenGenerator/UriSafeTokenGenerator.php  g  1      G   vendor/symfony/security-csrf/TokenGenerator/TokenGeneratorInterface.php  g  <xx      1   vendor/symfony/security-csrf/CsrfTokenManager.php  g  Zؤ      A   vendor/symfony/security-csrf/Exception/TokenNotFoundException.php  g   U      *   vendor/symfony/security-csrf/composer.json  g  -      ,   vendor/symfony/polyfill-uuid/bootstrap80.php  g  jx      $   vendor/symfony/polyfill-uuid/LICENSE,  g,        %   vendor/symfony/polyfill-uuid/Uuid.phpqB  gqB  E      *   vendor/symfony/polyfill-uuid/bootstrap.php#  g#  )      &   vendor/symfony/polyfill-uuid/README.md[  g[  Ƥ      *   vendor/symfony/polyfill-uuid/composer.json  g  {Ĥ      7   vendor/symfony/polyfill-intl-normalizer/bootstrap80.php  g  ,      /   vendor/symfony/polyfill-intl-normalizer/LICENSE,  g,  H      6   vendor/symfony/polyfill-intl-normalizer/Normalizer.php8$  g8$  &(C      F   vendor/symfony/polyfill-intl-normalizer/Resources/stubs/Normalizer.php  g  %      L   vendor/symfony/polyfill-intl-normalizer/Resources/unidata/combiningClass.php.  g.  Cb      T   vendor/symfony/polyfill-intl-normalizer/Resources/unidata/canonicalDecomposition.phpx  gx        R   vendor/symfony/polyfill-intl-normalizer/Resources/unidata/canonicalComposition.php=  g=  V{      X   vendor/symfony/polyfill-intl-normalizer/Resources/unidata/compatibilityDecomposition.php  g  [
+      5   vendor/symfony/polyfill-intl-normalizer/bootstrap.php  g  #p      1   vendor/symfony/polyfill-intl-normalizer/README.md  g  +tK      5   vendor/symfony/polyfill-intl-normalizer/composer.jsonx  gx        F   vendor/symfony/event-dispatcher-contracts/EventDispatcherInterface.php,  g,  ۃf      3   vendor/symfony/event-dispatcher-contracts/Event.php  g  +Vg      1   vendor/symfony/event-dispatcher-contracts/LICENSE,  g,        6   vendor/symfony/event-dispatcher-contracts/CHANGELOG.md   g   h{#      3   vendor/symfony/event-dispatcher-contracts/README.mdZ  gZ  9{Am      7   vendor/symfony/event-dispatcher-contracts/composer.json?  g?  O*      8   vendor/symfony/property-access/PropertyPathInterface.php  g  z      7   vendor/symfony/property-access/PropertyPathIterator.php  g  ax      &   vendor/symfony/property-access/LICENSE,  g,  U      @   vendor/symfony/property-access/PropertyPathIteratorInterface.php  g  
M      +   vendor/symfony/property-access/CHANGELOG.md
  g
  <4      <   vendor/symfony/property-access/PropertyAccessorInterface.php  g  {Q      /   vendor/symfony/property-access/PropertyPath.php  g  cA      :   vendor/symfony/property-access/PropertyAccessorBuilder.php  g  0l      (   vendor/symfony/property-access/README.md1  g1  !Q      3   vendor/symfony/property-access/PropertyAccessor.phpq{  gq{  UBp      1   vendor/symfony/property-access/PropertyAccess.php  g        6   vendor/symfony/property-access/PropertyPathBuilder.php!  g!  2{      <   vendor/symfony/property-access/Exception/AccessException.php  g  KW      K   vendor/symfony/property-access/Exception/UninitializedPropertyException.php  g  ,      ?   vendor/symfony/property-access/Exception/ExceptionInterface.php  g  l      A   vendor/symfony/property-access/Exception/OutOfBoundsException.php  g  ؤ      =   vendor/symfony/property-access/Exception/RuntimeException.php  g  Cn      E   vendor/symfony/property-access/Exception/InvalidArgumentException.php  g  IF[3      I   vendor/symfony/property-access/Exception/InvalidPropertyPathException.php  g  zޤ      D   vendor/symfony/property-access/Exception/UnexpectedTypeException.phpy  gy  bR      A   vendor/symfony/property-access/Exception/NoSuchIndexException.php  g  NQp      D   vendor/symfony/property-access/Exception/NoSuchPropertyException.php  g  ?      ,   vendor/symfony/property-access/composer.json~  g~        %   vendor/symfony/finder/SplFileInfo.php  g  9$̤      5   vendor/symfony/finder/Comparator/NumberComparator.php
  g
        /   vendor/symfony/finder/Comparator/Comparator.php  g  @x      3   vendor/symfony/finder/Comparator/DateComparator.php  g  ~Q          vendor/symfony/finder/Finder.phpc  gc  v>         vendor/symfony/finder/LICENSE,  g,  U      "   vendor/symfony/finder/CHANGELOG.md
  g
  3g         vendor/symfony/finder/Glob.php2  g2  A         vendor/symfony/finder/README.md  g  C      /   vendor/symfony/finder/Iterator/LazyIterator.php  g  Wđ      ;   vendor/symfony/finder/Iterator/VcsIgnoredFilterIterator.php'  g'  n!      <   vendor/symfony/finder/Iterator/FilecontentFilterIterator.php  g  \v:c      =   vendor/symfony/finder/Iterator/MultiplePcreFilterIterator.php  g  N      :   vendor/symfony/finder/Iterator/SizeRangeFilterIterator.phpk  gk  4-      9   vendor/symfony/finder/Iterator/FilenameFilterIterator.phpn  gn  MNQ      :   vendor/symfony/finder/Iterator/DateRangeFilterIterator.php  g  9z֤      7   vendor/symfony/finder/Iterator/CustomFilterIterator.php  g  	ʤ      =   vendor/symfony/finder/Iterator/RecursiveDirectoryIterator.phpO  gO        A   vendor/symfony/finder/Iterator/ExcludeDirectoryFilterIterator.php5
  g5
  `      3   vendor/symfony/finder/Iterator/SortableIterator.php3  g3  뛽       ;   vendor/symfony/finder/Iterator/DepthRangeFilterIterator.phpn  gn  O      9   vendor/symfony/finder/Iterator/FileTypeFilterIterator.php|  g|  Aj      5   vendor/symfony/finder/Iterator/PathFilterIterator.php  g  (      #   vendor/symfony/finder/Gitignore.php  g  Q)      9   vendor/symfony/finder/Exception/AccessDeniedException.php  g        >   vendor/symfony/finder/Exception/DirectoryNotFoundException.php  g  )      #   vendor/symfony/finder/composer.json*  g*  _      -   vendor/symfony/polyfill-php83/bootstrap81.php  g  p$      %   vendor/symfony/polyfill-php83/LICENSE,  g,  t=      B   vendor/symfony/polyfill-php83/Resources/stubs/SQLite3Exception.phpH  gH  <ܐ      ;   vendor/symfony/polyfill-php83/Resources/stubs/DateError.php=  g=  ˤ      :   vendor/symfony/polyfill-php83/Resources/stubs/Override.php  g  NsE      ?   vendor/symfony/polyfill-php83/Resources/stubs/DateException.phpE  gE        O   vendor/symfony/polyfill-php83/Resources/stubs/DateInvalidOperationException.phpY  gY  Mߤ      A   vendor/symfony/polyfill-php83/Resources/stubs/DateObjectError.phpG  gG  
.I      T   vendor/symfony/polyfill-php83/Resources/stubs/DateMalformedPeriodStringException.php^  g^  K      N   vendor/symfony/polyfill-php83/Resources/stubs/DateMalformedStringException.phpX  gX  Wߤ      @   vendor/symfony/polyfill-php83/Resources/stubs/DateRangeError.phpF  gF  L;      N   vendor/symfony/polyfill-php83/Resources/stubs/DateInvalidTimeZoneException.phpX  gX  g      V   vendor/symfony/polyfill-php83/Resources/stubs/DateMalformedIntervalStringException.php`  g`  6      +   vendor/symfony/polyfill-php83/bootstrap.php  g  {Jc      '   vendor/symfony/polyfill-php83/README.md  g  }      '   vendor/symfony/polyfill-php83/Php83.php
  g
  \9>      +   vendor/symfony/polyfill-php83/composer.json  g  {V      >   vendor/symfony/http-kernel/DataCollector/DumpDataCollector.php%+  g%+  p	q      @   vendor/symfony/http-kernel/DataCollector/MemoryDataCollector.php  g  ]%      G   vendor/symfony/http-kernel/DataCollector/LateDataCollectorInterface.php/  g/  D
      @   vendor/symfony/http-kernel/DataCollector/RouterDataCollector.php	  g	  W}}      >   vendor/symfony/http-kernel/DataCollector/TimeDataCollector.php
  g
  R       C   vendor/symfony/http-kernel/DataCollector/DataCollectorInterface.php  g        A   vendor/symfony/http-kernel/DataCollector/RequestDataCollector.phpo>  go>  se      >   vendor/symfony/http-kernel/DataCollector/AjaxDataCollector.phpl  gl  kD      :   vendor/symfony/http-kernel/DataCollector/DataCollector.phpB  gB  r      @   vendor/symfony/http-kernel/DataCollector/LoggerDataCollector.phpV)  gV)  >W      @   vendor/symfony/http-kernel/DataCollector/ConfigDataCollector.php<  g<        ?   vendor/symfony/http-kernel/DataCollector/EventDataCollector.phpG  gG  Jݤ      C   vendor/symfony/http-kernel/DataCollector/ExceptionDataCollector.phpU  gU  	      5   vendor/symfony/http-kernel/Attribute/AsController.php  g  UT      @   vendor/symfony/http-kernel/Attribute/AsTargetedValueResolver.php
  g
  w      .   vendor/symfony/http-kernel/Attribute/Cache.phpX
  gX
  LҌ      7   vendor/symfony/http-kernel/Attribute/MapQueryString.php  g  u~      7   vendor/symfony/http-kernel/Attribute/WithHttpStatus.php^  g^  
      4   vendor/symfony/http-kernel/Attribute/MapDateTime.php   g   j      :   vendor/symfony/http-kernel/Attribute/MapRequestPayload.php)  g)  -"y      5   vendor/symfony/http-kernel/Attribute/WithLogLevel.php  g  FH      6   vendor/symfony/http-kernel/Attribute/ValueResolver.php  g  \      :   vendor/symfony/http-kernel/Attribute/MapQueryParameter.php\  g\  %      "   vendor/symfony/http-kernel/LICENSE,  g,  U      R   vendor/symfony/http-kernel/ControllerMetadata/ArgumentMetadataFactoryInterface.php  g  ͞1      B   vendor/symfony/http-kernel/ControllerMetadata/ArgumentMetadata.php  g  S      I   vendor/symfony/http-kernel/ControllerMetadata/ArgumentMetadataFactory.php  g  D{\Ǥ      '   vendor/symfony/http-kernel/CHANGELOG.mdQ  gQ        1   vendor/symfony/http-kernel/Config/FileLocator.phpw  gw        /   vendor/symfony/http-kernel/HttpClientKernel.php  g  u*D      2   vendor/symfony/http-kernel/TerminableInterface.php  g        A   vendor/symfony/http-kernel/CacheClearer/CacheClearerInterface.php*  g*  雗      =   vendor/symfony/http-kernel/CacheClearer/ChainCacheClearer.phpJ  gJ  7      <   vendor/symfony/http-kernel/CacheClearer/Psr6CacheClearer.php  g  r2      5   vendor/symfony/http-kernel/Resources/welcome.html.php  g  i      )   vendor/symfony/http-kernel/HttpKernel.php-  g-  ¤      ?   vendor/symfony/http-kernel/CacheWarmer/CacheWarmerAggregate.php  g  Q      6   vendor/symfony/http-kernel/CacheWarmer/CacheWarmer.php  g  QĤ      <   vendor/symfony/http-kernel/CacheWarmer/WarmableInterface.php3  g3  P@ˤ      ?   vendor/symfony/http-kernel/CacheWarmer/CacheWarmerInterface.php  g  {w]b      ,   vendor/symfony/http-kernel/Bundle/Bundle.php  g  ~o      5   vendor/symfony/http-kernel/Bundle/BundleInterface.php  g  "z      4   vendor/symfony/http-kernel/Bundle/AbstractBundle.php  g  |`      5   vendor/symfony/http-kernel/Bundle/BundleExtension.php	  g	  Y]=      .   vendor/symfony/http-kernel/KernelInterface.php  g  J:      :   vendor/symfony/http-kernel/Controller/ArgumentResolver.php  g  <n      =   vendor/symfony/http-kernel/Controller/ControllerReference.php5  g5  Ul      9   vendor/symfony/http-kernel/Controller/ErrorController.php>  g>  B      E   vendor/symfony/http-kernel/Controller/ContainerControllerResolver.php  g  f      P   vendor/symfony/http-kernel/Controller/ArgumentResolver/VariadicValueResolver.php@  g@  S      O   vendor/symfony/http-kernel/Controller/ArgumentResolver/ServiceValueResolver.php|  g|  wS      O   vendor/symfony/http-kernel/Controller/ArgumentResolver/DefaultValueResolver.php  g  ^(2      V   vendor/symfony/http-kernel/Controller/ArgumentResolver/QueryParameterValueResolver.php  g  g,      K   vendor/symfony/http-kernel/Controller/ArgumentResolver/UidValueResolver.php  g  ybޤ      R   vendor/symfony/http-kernel/Controller/ArgumentResolver/BackedEnumValueResolver.php0  g0  Ns      V   vendor/symfony/http-kernel/Controller/ArgumentResolver/RequestPayloadValueResolver.phpD"  gD"  rn      P   vendor/symfony/http-kernel/Controller/ArgumentResolver/DateTimeValueResolver.php
  g
  7      O   vendor/symfony/http-kernel/Controller/ArgumentResolver/RequestValueResolver.php  g  05      O   vendor/symfony/http-kernel/Controller/ArgumentResolver/SessionValueResolver.php  g  o      X   vendor/symfony/http-kernel/Controller/ArgumentResolver/RequestAttributeValueResolver.php  g  q?柤      [   vendor/symfony/http-kernel/Controller/ArgumentResolver/NotTaggedControllerValueResolver.php:
  g:
  <      Q   vendor/symfony/http-kernel/Controller/ArgumentResolver/TraceableValueResolver.php3  g3  8?      C   vendor/symfony/http-kernel/Controller/ArgumentResolverInterface.phpt  gt  q/m      E   vendor/symfony/http-kernel/Controller/ControllerResolverInterface.phpy  gy  5ݰʤ      C   vendor/symfony/http-kernel/Controller/TraceableArgumentResolver.php  g  D      @   vendor/symfony/http-kernel/Controller/ValueResolverInterface.php  g  @9      <   vendor/symfony/http-kernel/Controller/ControllerResolver.php0(  g0(  7nl      E   vendor/symfony/http-kernel/Controller/TraceableControllerResolver.phpJ  gJ  #@      H   vendor/symfony/http-kernel/Controller/ArgumentValueResolverInterface.php  g  %      $   vendor/symfony/http-kernel/README.md  g  7      E   vendor/symfony/http-kernel/Fragment/FragmentUriGeneratorInterface.php:  g:  Ze      >   vendor/symfony/http-kernel/Fragment/InlineFragmentRenderer.php  g  b^b      ;   vendor/symfony/http-kernel/Fragment/SsiFragmentRenderer.php%  g%  	      I   vendor/symfony/http-kernel/Fragment/AbstractSurrogateFragmentRenderer.php  g  ,J      A   vendor/symfony/http-kernel/Fragment/FragmentRendererInterface.php  g  Ǜ<      <   vendor/symfony/http-kernel/Fragment/FragmentUriGenerator.php$  g$        ;   vendor/symfony/http-kernel/Fragment/EsiFragmentRenderer.php%  g%  p      @   vendor/symfony/http-kernel/Fragment/HIncludeFragmentRenderer.php/
  g/
  r0      7   vendor/symfony/http-kernel/Fragment/FragmentHandler.php  g  <̤      @   vendor/symfony/http-kernel/Fragment/RoutableFragmentRenderer.php+  g+  rT      +   vendor/symfony/http-kernel/KernelEvents.phpd  gd  Z$      ,   vendor/symfony/http-kernel/HttpCache/Esi.php
  g
  
K\      2   vendor/symfony/http-kernel/HttpCache/HttpCache.phpk  gk  J      .   vendor/symfony/http-kernel/HttpCache/Store.php9  g9  j=      ;   vendor/symfony/http-kernel/HttpCache/SurrogateInterface.php  g  r      G   vendor/symfony/http-kernel/HttpCache/ResponseCacheStrategyInterface.php:  g:  )Ou      >   vendor/symfony/http-kernel/HttpCache/ResponseCacheStrategy.php!  g!  t      7   vendor/symfony/http-kernel/HttpCache/StoreInterface.php  g  +      ,   vendor/symfony/http-kernel/HttpCache/Ssi.phpR
  gR
  Y      :   vendor/symfony/http-kernel/HttpCache/AbstractSurrogate.php  g  ڄ      :   vendor/symfony/http-kernel/HttpCache/SubRequestHandler.php1  g1  イ      2   vendor/symfony/http-kernel/HttpKernelInterface.php  g   Z      )   vendor/symfony/http-kernel/Log/Logger.php2  g2  Y8X      7   vendor/symfony/http-kernel/Log/DebugLoggerInterface.phpD  gD  'V      :   vendor/symfony/http-kernel/Log/DebugLoggerConfigurator.phpH  gH  ,      ;   vendor/symfony/http-kernel/Profiler/FileProfilerStorage.php(  g(  |r      /   vendor/symfony/http-kernel/Profiler/Profile.phpo  go   #      0   vendor/symfony/http-kernel/Profiler/Profiler.php  g  27ya      @   vendor/symfony/http-kernel/Profiler/ProfilerStorageInterface.php  g  0Ĥ      G   vendor/symfony/http-kernel/DependencyInjection/FragmentRendererPass.php  g  P      C   vendor/symfony/http-kernel/DependencyInjection/ServicesResetter.php  g  /v      R   vendor/symfony/http-kernel/DependencyInjection/RegisterLocaleAwareServicesPass.php  g  2@      H   vendor/symfony/http-kernel/DependencyInjection/ResettableServicePass.php  g  &ˏ      R   vendor/symfony/http-kernel/DependencyInjection/MergeExtensionConfigurationPass.php  g  T
      Q   vendor/symfony/http-kernel/DependencyInjection/AddAnnotatedClassesToCachePass.php  g  :      H   vendor/symfony/http-kernel/DependencyInjection/ConfigurableExtension.php  g  6v      =   vendor/symfony/http-kernel/DependencyInjection/LoggerPass.php)  g)  Q*      <   vendor/symfony/http-kernel/DependencyInjection/Extension.php_  g_  ʍ/      V   vendor/symfony/http-kernel/DependencyInjection/ControllerArgumentValueResolverPass.phpY  gY  FT      Y   vendor/symfony/http-kernel/DependencyInjection/RegisterControllerArgumentLocatorsPass.php.  g.  zM      \   vendor/symfony/http-kernel/DependencyInjection/RemoveEmptyControllerArgumentLocatorsPass.php
  g
  5
դ      M   vendor/symfony/http-kernel/DependencyInjection/LazyLoadingFragmentHandler.php  g        E   vendor/symfony/http-kernel/Exception/TooManyRequestsHttpException.php  g  <      >   vendor/symfony/http-kernel/Exception/ConflictHttpException.phpc  gc        6   vendor/symfony/http-kernel/Exception/HttpException.phpN  gN  դ      B   vendor/symfony/http-kernel/Exception/UnauthorizedHttpException.php  g  8      A   vendor/symfony/http-kernel/Exception/InvalidMetadataException.phpj  gj  ;녤      D   vendor/symfony/http-kernel/Exception/LengthRequiredHttpException.phpi  gi  
l      I   vendor/symfony/http-kernel/Exception/UnprocessableEntityHttpException.phpw  gw  3      H   vendor/symfony/http-kernel/Exception/PreconditionFailedHttpException.phpm  gm  m%      :   vendor/symfony/http-kernel/Exception/GoneHttpException.php_  g_  ey      J   vendor/symfony/http-kernel/Exception/UnsupportedMediaTypeHttpException.phpo  go  aM}      H   vendor/symfony/http-kernel/Exception/UnexpectedSessionUsageException.php  g  Zis      <   vendor/symfony/http-kernel/Exception/LockedHttpException.phpe  ge  peh      H   vendor/symfony/http-kernel/Exception/ServiceUnavailableHttpException.phpm  gm  =      ?   vendor/symfony/http-kernel/Exception/HttpExceptionInterface.php}  g}  ֚5      B   vendor/symfony/http-kernel/Exception/AccessDeniedHttpException.php  g  6HHg      @   vendor/symfony/http-kernel/Exception/BadRequestHttpException.phpe  ge  Ց      Q   vendor/symfony/http-kernel/Exception/ControllerDoesNotReturnResponseException.php  g  t<
e      C   vendor/symfony/http-kernel/Exception/NotAcceptableHttpException.phph  gh  (ޤ      J   vendor/symfony/http-kernel/Exception/PreconditionRequiredHttpException.php  g  cԤ      >   vendor/symfony/http-kernel/Exception/NotFoundHttpException.phpj  gj  Vz      F   vendor/symfony/http-kernel/Exception/MethodNotAllowedHttpException.php  g  iנ      B   vendor/symfony/http-kernel/Exception/ResolverNotFoundException.php  g  y	+      4   vendor/symfony/http-kernel/Event/ControllerEvent.phpj  gj  w.Ƥ      3   vendor/symfony/http-kernel/Event/ExceptionEvent.php  g  p-      7   vendor/symfony/http-kernel/Event/FinishRequestEvent.php  g  TY      2   vendor/symfony/http-kernel/Event/ResponseEvent.php  g  ,7      3   vendor/symfony/http-kernel/Event/TerminateEvent.php  g  VC      =   vendor/symfony/http-kernel/Event/ControllerArgumentsEvent.php  g  nT      0   vendor/symfony/http-kernel/Event/KernelEvent.php  g  DBc      1   vendor/symfony/http-kernel/Event/RequestEvent.php  g  ׁ      .   vendor/symfony/http-kernel/Event/ViewEvent.php  g        (   vendor/symfony/http-kernel/composer.jsonm  gm  -m      2   vendor/symfony/http-kernel/RebootableInterface.php<  g<  pLX1      %   vendor/symfony/http-kernel/Kernel.phpw  gw  >      (   vendor/symfony/http-kernel/UriSigner.php  g  2[{      8   vendor/symfony/http-kernel/Debug/VirtualRequestStack.phpI  gI  U&      =   vendor/symfony/http-kernel/Debug/ErrorHandlerConfigurator.php  g  P      =   vendor/symfony/http-kernel/Debug/TraceableEventDispatcher.phps
  gs
  |      6   vendor/symfony/http-kernel/Debug/FileLinkFormatter.php  g        0   vendor/symfony/http-kernel/HttpKernelBrowser.php  g  i\      E   vendor/symfony/http-kernel/EventListener/StreamedResponseListener.php  g  }>Ť      =   vendor/symfony/http-kernel/EventListener/ResponseListener.php  g  PUȤ      ;   vendor/symfony/http-kernel/EventListener/LocaleListener.php  g  7)<      =   vendor/symfony/http-kernel/EventListener/FragmentListener.php8  g8  v      C   vendor/symfony/http-kernel/EventListener/CacheAttributeListener.php1  g1  ۤ      D   vendor/symfony/http-kernel/EventListener/AbstractSessionListener.phpd0  gd0  o!      D   vendor/symfony/http-kernel/EventListener/ValidateRequestListener.php  g  x      K   vendor/symfony/http-kernel/EventListener/DisallowRobotsIndexingListener.phpo  go  >JȤ      F   vendor/symfony/http-kernel/EventListener/AddRequestFormatsListener.php  g  q       =   vendor/symfony/http-kernel/EventListener/ProfilerListener.php<  g<  <3W      >   vendor/symfony/http-kernel/EventListener/SurrogateListener.phpU  gU  M      B   vendor/symfony/http-kernel/EventListener/DebugHandlersListener.php  g  n      @   vendor/symfony/http-kernel/EventListener/LocaleAwareListener.php	  g	        9   vendor/symfony/http-kernel/EventListener/DumpListener.php%  g%  ۤ      :   vendor/symfony/http-kernel/EventListener/ErrorListener.php!  g!  	O      <   vendor/symfony/http-kernel/EventListener/SessionListener.php  g        ;   vendor/symfony/http-kernel/EventListener/RouterListener.php  g  G]9         vendor/symfony/yaml/LICENSE,  g,  U         vendor/symfony/yaml/Parser.phpI  gI  qŤ          vendor/symfony/yaml/CHANGELOG.md  g  Ĥ         vendor/symfony/yaml/Escaper.php  g  
      +   vendor/symfony/yaml/Resources/bin/yaml-lint  g  3VԈ         vendor/symfony/yaml/README.md  g  ـT      !   vendor/symfony/yaml/Unescaper.phpK  gK   脱         vendor/symfony/yaml/Dumper.php  g  h         vendor/symfony/yaml/Inline.php  g  Xwt         vendor/symfony/yaml/Yaml.php  g  LϽ      +   vendor/symfony/yaml/Command/LintCommand.php'  g'  te      /   vendor/symfony/yaml/Exception/DumpException.php  g  ?<̤      4   vendor/symfony/yaml/Exception/ExceptionInterface.php  g  ,P      2   vendor/symfony/yaml/Exception/RuntimeException.php  g  #OU      0   vendor/symfony/yaml/Exception/ParseException.php  g  mFB      '   vendor/symfony/yaml/Tag/TaggedValue.php  g  s$      !   vendor/symfony/yaml/composer.json  g   Zܦ      )   vendor/symfony/string/CodePointString.phpN  gN  J         vendor/symfony/string/LICENSE,  g,  զ_Ϥ      "   vendor/symfony/string/CHANGELOG.mdz  gz  ub      (   vendor/symfony/string/AbstractString.phpI  gI  k      -   vendor/symfony/string/Resources/functions.phpc  gc  Ȥ      <   vendor/symfony/string/Resources/data/wcswidth_table_zero.phpF  gF  MI      <   vendor/symfony/string/Resources/data/wcswidth_table_wide.phpk  gk  /      3   vendor/symfony/string/Inflector/FrenchInflector.php  g  Q      6   vendor/symfony/string/Inflector/InflectorInterface.phpR  gR  _      4   vendor/symfony/string/Inflector/EnglishInflector.phpC  gC  Q~         vendor/symfony/string/README.md+  g+  L      /   vendor/symfony/string/AbstractUnicodeString.phppb  gpb  c|Q      $   vendor/symfony/string/LazyString.php  g        $   vendor/symfony/string/ByteString.phpv9  gv9  }      '   vendor/symfony/string/UnicodeString.php1  g1        6   vendor/symfony/string/Exception/ExceptionInterface.php_  g_  :      4   vendor/symfony/string/Exception/RuntimeException.php~  g~  )Ʉ      <   vendor/symfony/string/Exception/InvalidArgumentException.php  g  B;8      #   vendor/symfony/string/composer.json  g  #      2   vendor/symfony/string/Slugger/SluggerInterface.php  g        .   vendor/symfony/string/Slugger/AsciiSlugger.php  g  [=M      4   vendor/symfony/security-core/Role/SwitchUserRole.php  g  'v      <   vendor/symfony/security-core/Role/RoleHierarchyInterface.php]  g]  Բ'      *   vendor/symfony/security-core/Role/Role.php  g  i֜      3   vendor/symfony/security-core/Role/RoleHierarchy.php  g  UՈ      C   vendor/symfony/security-core/Validator/Constraints/UserPassword.php"  g"  <0      L   vendor/symfony/security-core/Validator/Constraints/UserPasswordValidator.php~
  g~
  ^      $   vendor/symfony/security-core/LICENSE,  g,  U      D   vendor/symfony/security-core/Test/AccessDecisionStrategyTestCase.php	  g	  A      B   vendor/symfony/security-core/Signature/ExpiredSignatureStorage.php  g  `5      N   vendor/symfony/security-core/Signature/Exception/InvalidSignatureException.php  g  [.ܤ      N   vendor/symfony/security-core/Signature/Exception/ExpiredSignatureException.php  g  (:      :   vendor/symfony/security-core/Signature/SignatureHasher.php  g  d5A      )   vendor/symfony/security-core/CHANGELOG.md  g  &      C   vendor/symfony/security-core/Resources/translations/security.sq.xlfS  gS  B&^      C   vendor/symfony/security-core/Resources/translations/security.ru.xlf  g  m      C   vendor/symfony/security-core/Resources/translations/security.hy.xlf  g  B      C   vendor/symfony/security-core/Resources/translations/security.fr.xlfU  gU  $      C   vendor/symfony/security-core/Resources/translations/security.fa.xlf  g  IѤ      C   vendor/symfony/security-core/Resources/translations/security.pl.xlf  g  u      C   vendor/symfony/security-core/Resources/translations/security.sv.xlf  g  cn      C   vendor/symfony/security-core/Resources/translations/security.el.xlf8  g8  yva      H   vendor/symfony/security-core/Resources/translations/security.sr_Cyrl.xlf  g        C   vendor/symfony/security-core/Resources/translations/security.en.xlfl  gl  gBZ      C   vendor/symfony/security-core/Resources/translations/security.ja.xlf  g  H      F   vendor/symfony/security-core/Resources/translations/security.pt_BR.xlf  g  iH!      C   vendor/symfony/security-core/Resources/translations/security.no.xlf  g  ~RҤ      C   vendor/symfony/security-core/Resources/translations/security.vi.xlf,  g,  a      C   vendor/symfony/security-core/Resources/translations/security.ur.xlf  g  g      C   vendor/symfony/security-core/Resources/translations/security.nn.xlf  g  l      C   vendor/symfony/security-core/Resources/translations/security.nl.xlf  g  "֤      C   vendor/symfony/security-core/Resources/translations/security.cy.xlfv  gv  FŤ      C   vendor/symfony/security-core/Resources/translations/security.af.xlf  g  ojo      C   vendor/symfony/security-core/Resources/translations/security.lv.xlfc  gc  @ۤ      C   vendor/symfony/security-core/Resources/translations/security.ar.xlf  g  OD      C   vendor/symfony/security-core/Resources/translations/security.lb.xlf)  g)  z7      C   vendor/symfony/security-core/Resources/translations/security.tr.xlf  g  0˵      C   vendor/symfony/security-core/Resources/translations/security.lt.xlfv  gv  @Ȥ      F   vendor/symfony/security-core/Resources/translations/security.zh_CN.xlf  g  D      C   vendor/symfony/security-core/Resources/translations/security.ca.xlf  g  
      C   vendor/symfony/security-core/Resources/translations/security.be.xlf.  g.  
ZZ      C   vendor/symfony/security-core/Resources/translations/security.th.xlf  g  x=ݤ      C   vendor/symfony/security-core/Resources/translations/security.uz.xlfl  gl  M      C   vendor/symfony/security-core/Resources/translations/security.mk.xlf  g  ڞ      C   vendor/symfony/security-core/Resources/translations/security.bs.xlf  g  %}o      C   vendor/symfony/security-core/Resources/translations/security.bg.xlf  g  d캤      H   vendor/symfony/security-core/Resources/translations/security.sr_Latn.xlf6  g6  dξ      C   vendor/symfony/security-core/Resources/translations/security.uk.xlf  g  6V      F   vendor/symfony/security-core/Resources/translations/security.zh_TW.xlf  g  Ȉf      C   vendor/symfony/security-core/Resources/translations/security.cs.xlf  g  S0k3      C   vendor/symfony/security-core/Resources/translations/security.tl.xlf  g  %$      C   vendor/symfony/security-core/Resources/translations/security.my.xlf  g  [v      C   vendor/symfony/security-core/Resources/translations/security.nb.xlf  g  ~RҤ      C   vendor/symfony/security-core/Resources/translations/security.mn.xlf  g  އ      C   vendor/symfony/security-core/Resources/translations/security.az.xlf^  g^  9      C   vendor/symfony/security-core/Resources/translations/security.eu.xlf  g  bs`      C   vendor/symfony/security-core/Resources/translations/security.he.xlfh  gh  u      C   vendor/symfony/security-core/Resources/translations/security.hr.xlf[  g[        C   vendor/symfony/security-core/Resources/translations/security.pt.xlf  g  5>      C   vendor/symfony/security-core/Resources/translations/security.et.xlf  g  s      C   vendor/symfony/security-core/Resources/translations/security.de.xlfV  gV  :      C   vendor/symfony/security-core/Resources/translations/security.sl.xlf  g  A      C   vendor/symfony/security-core/Resources/translations/security.it.xlf  g  a      C   vendor/symfony/security-core/Resources/translations/security.gl.xlf8  g8  Ϗ      C   vendor/symfony/security-core/Resources/translations/security.es.xlfQ  gQ  cP)      C   vendor/symfony/security-core/Resources/translations/security.hu.xlf:  g:  KY      C   vendor/symfony/security-core/Resources/translations/security.da.xlf  g  mm      C   vendor/symfony/security-core/Resources/translations/security.fi.xlf  g   T      C   vendor/symfony/security-core/Resources/translations/security.id.xlf  g  x"      C   vendor/symfony/security-core/Resources/translations/security.sk.xlf  g  ^P      C   vendor/symfony/security-core/Resources/translations/security.ro.xlfy  gy  Aze      J   vendor/symfony/security-core/User/AttributesBasedUserProviderInterface.phpN  gN  u      .   vendor/symfony/security-core/User/OidcUser.php  g        9   vendor/symfony/security-core/User/InMemoryUserChecker.php  g  l      3   vendor/symfony/security-core/User/UserInterface.php<  g<  l      ;   vendor/symfony/security-core/User/UserProviderInterface.phpI	  gI	  ̤      9   vendor/symfony/security-core/User/MissingUserProvider.php  g  E      6   vendor/symfony/security-core/User/ChainUserChecker.phpd  gd  OϤ      N   vendor/symfony/security-core/User/LegacyPasswordAuthenticatedUserInterface.php1  g1  ,      ?   vendor/symfony/security-core/User/PasswordUpgraderInterface.php  g  }m      2   vendor/symfony/security-core/User/InMemoryUser.phpX  gX  H      :   vendor/symfony/security-core/User/InMemoryUserProvider.php  g  ,aR      8   vendor/symfony/security-core/User/EquatableInterface.phpm  gm  C      H   vendor/symfony/security-core/User/PasswordAuthenticatedUserInterface.php  g  hΤ      :   vendor/symfony/security-core/User/UserCheckerInterface.phpb  gb  P      7   vendor/symfony/security-core/User/ChainUserProvider.php	  g	         &   vendor/symfony/security-core/README.md  g  {u!      L   vendor/symfony/security-core/Authorization/AuthorizationCheckerInterface.php2  g2  O      I   vendor/symfony/security-core/Authorization/ExpressionLanguageProvider.phpV  gV  @)5      M   vendor/symfony/security-core/Authorization/TraceableAccessDecisionManager.php
  g
  T(      D   vendor/symfony/security-core/Authorization/AccessDecisionManager.phpl  gl  0ո      M   vendor/symfony/security-core/Authorization/AccessDecisionManagerInterface.php}  g}  ,t      C   vendor/symfony/security-core/Authorization/Voter/VoterInterface.php  g  ])      L   vendor/symfony/security-core/Authorization/Voter/CacheableVoterInterface.php~  g~  9      D   vendor/symfony/security-core/Authorization/Voter/ExpressionVoter.php3
  g3
        G   vendor/symfony/security-core/Authorization/Voter/RoleHierarchyVoter.phpl  gl  H??      C   vendor/symfony/security-core/Authorization/Voter/TraceableVoter.php)  g)  'J      :   vendor/symfony/security-core/Authorization/Voter/Voter.phpf  gf  5~      >   vendor/symfony/security-core/Authorization/Voter/RoleVoter.php  g  Pj^      G   vendor/symfony/security-core/Authorization/Voter/AuthenticatedVoter.phpC  gC  A      A   vendor/symfony/security-core/Authorization/ExpressionLanguage.php  g  8Cy      C   vendor/symfony/security-core/Authorization/AuthorizationChecker.php  g  w      H   vendor/symfony/security-core/Authorization/Strategy/PriorityStrategy.php  g   7^      I   vendor/symfony/security-core/Authorization/Strategy/UnanimousStrategy.php/  g/        K   vendor/symfony/security-core/Authorization/Strategy/AffirmativeStrategy.php  g  
م      I   vendor/symfony/security-core/Authorization/Strategy/ConsensusStrategy.php  g  դ      W   vendor/symfony/security-core/Authorization/Strategy/AccessDecisionStrategyInterface.php]  g]  pf      )   vendor/symfony/security-core/Security.php
	  g
	        @   vendor/symfony/security-core/Exception/AccessDeniedException.phpZ  gZ  pth      D   vendor/symfony/security-core/Exception/InvalidCsrfTokenException.php}  g}  O      :   vendor/symfony/security-core/Exception/LogoutException.php  g  y'פ      9   vendor/symfony/security-core/Exception/LogicException.php  g  $2      @   vendor/symfony/security-core/Exception/LazyResponseException.php  g  .'      S   vendor/symfony/security-core/Exception/CustomUserMessageAuthenticationException.php	  g	  qHV      =   vendor/symfony/security-core/Exception/ExceptionInterface.php  g  ^      B   vendor/symfony/security-core/Exception/BadCredentialsException.php  g  h	      ;   vendor/symfony/security-core/Exception/RuntimeException.php  g  >
      <   vendor/symfony/security-core/Exception/DisabledException.phpv  gv  Ϥֽ      A   vendor/symfony/security-core/Exception/TokenNotFoundException.php  g  (      D   vendor/symfony/security-core/Exception/ProviderNotFoundException.php  g  R      F   vendor/symfony/security-core/Exception/SessionUnavailableException.phpz  gz  {Y      C   vendor/symfony/security-core/Exception/InvalidArgumentException.php  g  W.      B   vendor/symfony/security-core/Exception/AccountExpiredException.php  g  O
      I   vendor/symfony/security-core/Exception/AuthenticationExpiredException.phpG  gG  %.D      V   vendor/symfony/security-core/Exception/TooManyLoginAttemptsAuthenticationException.php}  g}  j      ?   vendor/symfony/security-core/Exception/CookieTheftException.php  g  m	      I   vendor/symfony/security-core/Exception/AuthenticationServiceException.php  g  t%      C   vendor/symfony/security-core/Exception/UnsupportedUserException.phpJ  gJ  jۤ      A   vendor/symfony/security-core/Exception/AccountStatusException.php  g  c%      R   vendor/symfony/security-core/Exception/CustomUserMessageAccountStatusException.php  g  *
      N   vendor/symfony/security-core/Exception/InsufficientAuthenticationException.php&  g&  [d      :   vendor/symfony/security-core/Exception/LockedException.phpl  gl  0믤      B   vendor/symfony/security-core/Exception/AuthenticationException.php+  g+  l      @   vendor/symfony/security-core/Exception/UserNotFoundException.php@  g@  򼓤      U   vendor/symfony/security-core/Exception/AuthenticationCredentialsNotFoundException.php  g  bb      F   vendor/symfony/security-core/Exception/CredentialsExpiredException.php  g  8h      C   vendor/symfony/security-core/Authentication/Token/AbstractToken.phpb  gb  ߤ7	      ?   vendor/symfony/security-core/Authentication/Token/NullToken.php   g   iƤ      W   vendor/symfony/security-core/Authentication/Token/Storage/UsageTrackingTokenStorage.php	  g	  l	      J   vendor/symfony/security-core/Authentication/Token/Storage/TokenStorage.php4  g4  g      S   vendor/symfony/security-core/Authentication/Token/Storage/TokenStorageInterface.php  g  %N      E   vendor/symfony/security-core/Authentication/Token/RememberMeToken.php  g  
5Lq      E   vendor/symfony/security-core/Authentication/Token/SwitchUserToken.phpm  gm  8      K   vendor/symfony/security-core/Authentication/Token/PreAuthenticatedToken.php  g  .      D   vendor/symfony/security-core/Authentication/Token/TokenInterface.php1	  g1	  =N*ݤ      K   vendor/symfony/security-core/Authentication/Token/UsernamePasswordToken.php  g  z      T   vendor/symfony/security-core/Authentication/AuthenticationTrustResolverInterface.php`  g`  J      K   vendor/symfony/security-core/Authentication/AuthenticationTrustResolver.phpw  gw  4
      S   vendor/symfony/security-core/Authentication/RememberMe/PersistentTokenInterface.php  g        P   vendor/symfony/security-core/Authentication/RememberMe/InMemoryTokenProvider.php'  g'  =      M   vendor/symfony/security-core/Authentication/RememberMe/CacheTokenVerifier.php	  g	  -Lu      J   vendor/symfony/security-core/Authentication/RememberMe/PersistentToken.php  g  Ij       Q   vendor/symfony/security-core/Authentication/RememberMe/TokenVerifierInterface.php  g  Ҥ      Q   vendor/symfony/security-core/Authentication/RememberMe/TokenProviderInterface.php  g  ܪ      A   vendor/symfony/security-core/Event/AuthenticationSuccessEvent.phpu  gu        :   vendor/symfony/security-core/Event/AuthenticationEvent.php  g  :7x      0   vendor/symfony/security-core/Event/VoteEvent.php-  g-        *   vendor/symfony/security-core/composer.json  g  x4      5   vendor/symfony/security-core/AuthenticationEvents.php  g  "a䚤      ,   vendor/symfony/deprecation-contracts/LICENSE,  g,  K      1   vendor/symfony/deprecation-contracts/CHANGELOG.md   g   h{#      1   vendor/symfony/deprecation-contracts/function.php  g  Oݤ      .   vendor/symfony/deprecation-contracts/README.md  g  X      2   vendor/symfony/deprecation-contracts/composer.jsonS  gS  =6      (   vendor/symfony/routing/CompiledRoute.php6  g6  k栤      *   vendor/symfony/routing/Attribute/Route.php  g  MT|         vendor/symfony/routing/LICENSE,  g,  U      (   vendor/symfony/routing/RouteCompiler.php8  g8  u      #   vendor/symfony/routing/CHANGELOG.md6  g6  V^      )   vendor/symfony/routing/RequestContext.php`  g`  )-ͤ      +   vendor/symfony/routing/Annotation/Route.php  g  m\      :   vendor/symfony/routing/Matcher/RequestMatcherInterface.php+  g+  <      =   vendor/symfony/routing/Matcher/ExpressionLanguageProvider.php  g  ~      -   vendor/symfony/routing/Matcher/UrlMatcher.php'  g'  #Ф      B   vendor/symfony/routing/Matcher/RedirectableUrlMatcherInterface.phpo  go  0
H      6   vendor/symfony/routing/Matcher/UrlMatcherInterface.php  g  P-2Ȥ      5   vendor/symfony/routing/Matcher/CompiledUrlMatcher.php  g  *g      6   vendor/symfony/routing/Matcher/TraceableUrlMatcher.phpJ  gJ  @      B   vendor/symfony/routing/Matcher/Dumper/CompiledUrlMatcherDumper.phpJ  gJ   3I      7   vendor/symfony/routing/Matcher/Dumper/MatcherDumper.php  g  \Pܤ      @   vendor/symfony/routing/Matcher/Dumper/MatcherDumperInterface.phpg  gg  xI{$      A   vendor/symfony/routing/Matcher/Dumper/CompiledUrlMatcherTrait.php  g  kR      @   vendor/symfony/routing/Matcher/Dumper/StaticPrefixCollection.php  g  ˥      9   vendor/symfony/routing/Matcher/RedirectableUrlMatcher.php<  g<  ðKʤ          vendor/symfony/routing/README.md  g  rɤ      9   vendor/symfony/routing/Generator/CompiledUrlGenerator.php
  g
  XA~      1   vendor/symfony/routing/Generator/UrlGenerator.php;  g;  Yn'      F   vendor/symfony/routing/Generator/ConfigurableRequirementsInterface.php  g  dfФ      :   vendor/symfony/routing/Generator/UrlGeneratorInterface.php
  g
  Y3
8      D   vendor/symfony/routing/Generator/Dumper/GeneratorDumperInterface.phpi  gi  fE      F   vendor/symfony/routing/Generator/Dumper/CompiledUrlGeneratorDumper.php  g        ;   vendor/symfony/routing/Generator/Dumper/GeneratorDumper.php$  g$  αh      *   vendor/symfony/routing/RouteCollection.phpO+  gO+  u      6   vendor/symfony/routing/Requirement/EnumRequirement.php  g        2   vendor/symfony/routing/Requirement/Requirement.phpR  gR  1$      7   vendor/symfony/routing/RequestContextAwareInterface.php6  g6  t      7   vendor/symfony/routing/Loader/AnnotationClassLoader.php  g  tD0      :   vendor/symfony/routing/Loader/AttributeDirectoryLoader.php  g  Tst      5   vendor/symfony/routing/Loader/AttributeFileLoader.php  g  MKI      0   vendor/symfony/routing/Loader/YamlFileLoader.php/  g/  14%      6   vendor/symfony/routing/Loader/AnnotationFileLoader.php  g        <   vendor/symfony/routing/Loader/schema/routing/routing-1.0.xsd9  g9  *#      /   vendor/symfony/routing/Loader/PhpFileLoader.php  g  @      5   vendor/symfony/routing/Loader/Psr4DirectoryLoader.php  g  *>      /   vendor/symfony/routing/Loader/XmlFileLoader.phpF  gF  =k      .   vendor/symfony/routing/Loader/ObjectLoader.phpq  gq  !v|      ?   vendor/symfony/routing/Loader/Configurator/Traits/HostTrait.php!  g!        A   vendor/symfony/routing/Loader/Configurator/Traits/PrefixTrait.php
  g
  (      I   vendor/symfony/routing/Loader/Configurator/Traits/LocalizedRouteTrait.php3
  g3
  }2       @   vendor/symfony/routing/Loader/Configurator/Traits/RouteTrait.php9  g9  ,s      >   vendor/symfony/routing/Loader/Configurator/Traits/AddTrait.phpS  gS  Ӥ      @   vendor/symfony/routing/Loader/Configurator/RouteConfigurator.php  g  {      E   vendor/symfony/routing/Loader/Configurator/CollectionConfigurator.php  g  ֠P      @   vendor/symfony/routing/Loader/Configurator/AliasConfigurator.php  g        B   vendor/symfony/routing/Loader/Configurator/RoutingConfigurator.php  g  a      A   vendor/symfony/routing/Loader/Configurator/ImportConfigurator.php  g  O      6   vendor/symfony/routing/Loader/AttributeClassLoader.php>  g>  K      1   vendor/symfony/routing/Loader/ContainerLoader.php  g  :      1   vendor/symfony/routing/Loader/DirectoryLoader.php  g  ]/      0   vendor/symfony/routing/Loader/GlobFileLoader.php  g  .]      /   vendor/symfony/routing/Loader/ClosureLoader.php  g  
       ;   vendor/symfony/routing/Loader/AnnotationDirectoryLoader.php  g  7
h          vendor/symfony/routing/Route.php/  g/  _      *   vendor/symfony/routing/RouterInterface.php"  g"  WF      !   vendor/symfony/routing/Router.phpt/  gt/  -X      1   vendor/symfony/routing/RouteCompilerInterface.php  g  T          vendor/symfony/routing/Alias.php	  g	  ä      Q   vendor/symfony/routing/DependencyInjection/AddExpressionLanguageProvidersPass.php  g  Tw      B   vendor/symfony/routing/DependencyInjection/RoutingResolverPass.php"  g"  K˶      >   vendor/symfony/routing/Exception/ResourceNotFoundException.php2  g2  FL"1      7   vendor/symfony/routing/Exception/ExceptionInterface.php  g  &      ;   vendor/symfony/routing/Exception/RouteNotFoundException.php  g  	C      5   vendor/symfony/routing/Exception/RuntimeException.php  g  $>G      H   vendor/symfony/routing/Exception/MissingMandatoryParametersException.phpC  gC  jYKФ      =   vendor/symfony/routing/Exception/InvalidArgumentException.php  g  ֤      >   vendor/symfony/routing/Exception/MethodNotAllowedException.phpp  gp  .ִ      =   vendor/symfony/routing/Exception/NoConfigurationException.php  g  r      D   vendor/symfony/routing/Exception/RouteCircularReferenceException.php>  g>  \T      >   vendor/symfony/routing/Exception/InvalidParameterException.php  g  !N      $   vendor/symfony/routing/composer.jsony  gy  P      ?   vendor/symfony/service-contracts/ServiceSubscriberInterface.php
  g
  }uP      ?   vendor/symfony/service-contracts/ServiceCollectionInterface.php  g  }V      @   vendor/symfony/service-contracts/Attribute/SubscribedService.php  g  i      7   vendor/symfony/service-contracts/Attribute/Required.php  g  `e      (   vendor/symfony/service-contracts/LICENSE,  g,        @   vendor/symfony/service-contracts/Test/ServiceLocatorTestCase.phpH  gH  5#!1      <   vendor/symfony/service-contracts/Test/ServiceLocatorTest.php  g  ]1C      -   vendor/symfony/service-contracts/CHANGELOG.md   g   h{#      *   vendor/symfony/service-contracts/README.mdJ  gJ  Г      3   vendor/symfony/service-contracts/ResetInterface.php  g  B4      =   vendor/symfony/service-contracts/ServiceProviderInterface.php  g  B쯇      ;   vendor/symfony/service-contracts/ServiceSubscriberTrait.php
  g
  F      B   vendor/symfony/service-contracts/ServiceMethodsSubscriberTrait.php&  g&        8   vendor/symfony/service-contracts/ServiceLocatorTrait.php  g  ?      .   vendor/symfony/service-contracts/composer.json  g  3'      9   vendor/symfony/property-info/PhpStan/NameScopeFactory.php  g  r      2   vendor/symfony/property-info/PhpStan/NameScope.php  g  d)ݤ      ?   vendor/symfony/property-info/PropertyInfoExtractorInterface.php  g  U-R      %   vendor/symfony/property-info/Type.php  g  1ɤ      $   vendor/symfony/property-info/LICENSE,  g,  H      6   vendor/symfony/property-info/Util/PhpDocTypeHelper.php  g  0Ƥ      7   vendor/symfony/property-info/Util/PhpStanTypeHelper.php#  g#  >       )   vendor/symfony/property-info/CHANGELOG.md  g  .      ;   vendor/symfony/property-info/PropertyInfoCacheExtractor.phpE  gE  ؍      D   vendor/symfony/property-info/PropertyWriteInfoExtractorInterface.php  g  xBy\      A   vendor/symfony/property-info/PropertyAccessExtractorInterface.php  g  2$C      ?   vendor/symfony/property-info/PropertyTypeExtractorInterface.phpQ  gQ        1   vendor/symfony/property-info/PropertyReadInfo.php  g  
      ;   vendor/symfony/property-info/Extractor/PhpStanExtractor.php.  g.  G      >   vendor/symfony/property-info/Extractor/SerializerExtractor.php  g        ?   vendor/symfony/property-info/Extractor/ConstructorExtractor.php  g  -U      T   vendor/symfony/property-info/Extractor/ConstructorArgumentTypeExtractorInterface.php  g  jv\      >   vendor/symfony/property-info/Extractor/ReflectionExtractor.php  g        :   vendor/symfony/property-info/Extractor/PhpDocExtractor.php&0  g&0  dd      F   vendor/symfony/property-info/PropertyDescriptionExtractorInterface.php   g   
8      2   vendor/symfony/property-info/PropertyWriteInfo.php  g  C      &   vendor/symfony/property-info/README.md  g  '7      C   vendor/symfony/property-info/PropertyReadInfoExtractorInterface.php  g  :|`դ      H   vendor/symfony/property-info/PropertyInitializableExtractorInterface.php  g  OW      6   vendor/symfony/property-info/PropertyInfoExtractor.php  g  yh      ?   vendor/symfony/property-info/PropertyListExtractorInterface.php  g  J$      P   vendor/symfony/property-info/DependencyInjection/PropertyInfoConstructorPass.phpY  gY  [c      E   vendor/symfony/property-info/DependencyInjection/PropertyInfoPass.php)  g)         *   vendor/symfony/property-info/composer.json  g  j      3   vendor/symfony/http-foundation/StreamedResponse.php  g  <      :   vendor/symfony/http-foundation/RequestMatcherInterface.php|  g|  3Q      5   vendor/symfony/http-foundation/BinaryFileResponse.php2  g2  އ      +   vendor/symfony/http-foundation/InputBag.php7  g7  sĤ      I   vendor/symfony/http-foundation/RateLimiter/AbstractRequestRateLimiter.php	  g	  -3      J   vendor/symfony/http-foundation/RateLimiter/RequestRateLimiterInterface.php
  g
  ¤      R   vendor/symfony/http-foundation/RateLimiter/PeekableRequestRateLimiterInterface.php  g  U      &   vendor/symfony/http-foundation/LICENSE,  g,  U      J   vendor/symfony/http-foundation/Test/Constraint/ResponseCookieValueSame.phpL  gL  f_      D   vendor/symfony/http-foundation/Test/Constraint/ResponseHasCookie.phpJ  gJ  Z^      M   vendor/symfony/http-foundation/Test/Constraint/ResponseHeaderLocationSame.php  g  U      I   vendor/symfony/http-foundation/Test/Constraint/ResponseStatusCodeSame.php  g  I[x`      G   vendor/symfony/http-foundation/Test/Constraint/ResponseIsSuccessful.php.  g.  P      J   vendor/symfony/http-foundation/Test/Constraint/ResponseIsUnprocessable.phpE  gE  K¤      G   vendor/symfony/http-foundation/Test/Constraint/ResponseIsRedirected.php,  g,        D   vendor/symfony/http-foundation/Test/Constraint/ResponseHasHeader.php<  g<  &      L   vendor/symfony/http-foundation/Test/Constraint/RequestAttributeValueSame.php  g  '`7      E   vendor/symfony/http-foundation/Test/Constraint/ResponseFormatSame.php  g  ^)      E   vendor/symfony/http-foundation/Test/Constraint/ResponseHeaderSame.php  g  <پJ      ,   vendor/symfony/http-foundation/ServerBag.php  g        +   vendor/symfony/http-foundation/CHANGELOG.mduL  guL  M      ,   vendor/symfony/http-foundation/File/File.php  g  ޯԤ      .   vendor/symfony/http-foundation/File/Stream.php  g  x      4   vendor/symfony/http-foundation/File/UploadedFile.php^'  g^'  b[      G   vendor/symfony/http-foundation/File/Exception/AccessDeniedException.phpi  gi  Y      A   vendor/symfony/http-foundation/File/Exception/NoFileException.php  g  -A      F   vendor/symfony/http-foundation/File/Exception/IniSizeFileException.php  g  I      J   vendor/symfony/http-foundation/File/Exception/CannotWriteFileException.php  g  :ݤ      H   vendor/symfony/http-foundation/File/Exception/ExtensionFileException.php  g  )      ?   vendor/symfony/http-foundation/File/Exception/FileException.php  g  j2      A   vendor/symfony/http-foundation/File/Exception/UploadException.php  g  S      I   vendor/symfony/http-foundation/File/Exception/UnexpectedTypeException.php9  g9  d-      G   vendor/symfony/http-foundation/File/Exception/FormSizeFileException.php  g  m;      G   vendor/symfony/http-foundation/File/Exception/FileNotFoundException.phpY  gY  {WɈ      F   vendor/symfony/http-foundation/File/Exception/PartialFileException.php  g  *      G   vendor/symfony/http-foundation/File/Exception/NoTmpDirFileException.php  g  n      +   vendor/symfony/http-foundation/Response.php  g  u      )   vendor/symfony/http-foundation/Cookie.phpJ/  gJ/  "f      /   vendor/symfony/http-foundation/AcceptHeader.php{
  g{
  G      1   vendor/symfony/http-foundation/RequestMatcher.php  g  յnҤ      4   vendor/symfony/http-foundation/ResponseHeaderBag.php  g  4֭      .   vendor/symfony/http-foundation/HeaderUtils.php$  g$  4      F   vendor/symfony/http-foundation/RequestMatcher/MethodRequestMatcher.php>  g>        D   vendor/symfony/http-foundation/RequestMatcher/PathRequestMatcher.phpd  gd  w|      F   vendor/symfony/http-foundation/RequestMatcher/IsJsonRequestMatcher.php  g  TK      D   vendor/symfony/http-foundation/RequestMatcher/PortRequestMatcher.php  g  2      D   vendor/symfony/http-foundation/RequestMatcher/HostRequestMatcher.phpR  gR  s      J   vendor/symfony/http-foundation/RequestMatcher/AttributesRequestMatcher.php  g  d      J   vendor/symfony/http-foundation/RequestMatcher/ExpressionRequestMatcher.php  g  Q̤      F   vendor/symfony/http-foundation/RequestMatcher/SchemeRequestMatcher.php,  g,  s>M      C   vendor/symfony/http-foundation/RequestMatcher/IpsRequestMatcher.php2  g2  ti      /   vendor/symfony/http-foundation/RequestStack.php  g   J      3   vendor/symfony/http-foundation/RedirectResponse.php9
  g9
  V      /   vendor/symfony/http-foundation/JsonResponse.phpj  gj  OP/      (   vendor/symfony/http-foundation/README.md  g  &      *   vendor/symfony/http-foundation/Request.php g BFF      ;   vendor/symfony/http-foundation/ExpressionRequestMatcher.php  g  |*      /   vendor/symfony/http-foundation/ParameterBag.php  g  6      *   vendor/symfony/http-foundation/IpUtils.php   g   Rz^      3   vendor/symfony/http-foundation/AcceptHeaderItem.php  g  :6      7   vendor/symfony/http-foundation/StreamedJsonResponse.php  g  ؕSҤ      ,   vendor/symfony/http-foundation/UrlHelper.phpq  gq  `Kl      6   vendor/symfony/http-foundation/ChainRequestMatcher.phpx  gx  X!      ,   vendor/symfony/http-foundation/HeaderBag.php  g  ZdL      *   vendor/symfony/http-foundation/FileBag.php  g  "4Ϥ      H   vendor/symfony/http-foundation/Exception/ConflictingHeadersException.php  g  ,Ň      E   vendor/symfony/http-foundation/Exception/UnexpectedValueException.phpx  gx   ȕ      F   vendor/symfony/http-foundation/Exception/RequestExceptionInterface.php  g  R      @   vendor/symfony/http-foundation/Exception/BadRequestException.php  g  Uڤ      I   vendor/symfony/http-foundation/Exception/SuspiciousOperationException.php  g  '      :   vendor/symfony/http-foundation/Exception/JsonException.php  g        E   vendor/symfony/http-foundation/Exception/SessionNotFoundException.phpY  gY  1      ,   vendor/symfony/http-foundation/composer.jsonv  gv  ^D      ,   vendor/symfony/http-foundation/UriSigner.php!
  g!
         J   vendor/symfony/http-foundation/Session/Attribute/AttributeBagInterface.php  g  Gf=      A   vendor/symfony/http-foundation/Session/Attribute/AttributeBag.php
  g
        H   vendor/symfony/http-foundation/Session/FlashBagAwareSessionInterface.php4  g4        B   vendor/symfony/http-foundation/Session/SessionFactoryInterface.php  g  f*      2   vendor/symfony/http-foundation/Session/Session.php  g  <)      7   vendor/symfony/http-foundation/Session/SessionUtils.php  g  '      M   vendor/symfony/http-foundation/Session/Storage/Handler/NullSessionHandler.php  g  r@      Q   vendor/symfony/http-foundation/Session/Storage/Handler/AbstractSessionHandler.php  g  դ      P   vendor/symfony/http-foundation/Session/Storage/Handler/SessionHandlerFactory.php)  g)  o      L   vendor/symfony/http-foundation/Session/Storage/Handler/PdoSessionHandler.php  g  AS      T   vendor/symfony/http-foundation/Session/Storage/Handler/MarshallingSessionHandler.php~  g~  |%      S   vendor/symfony/http-foundation/Session/Storage/Handler/NativeFileSessionHandler.php  g  wb      R   vendor/symfony/http-foundation/Session/Storage/Handler/MigratingSessionHandler.php  g  Dt|      M   vendor/symfony/http-foundation/Session/Storage/Handler/IdentityMarshaller.php  g  Gҭq      P   vendor/symfony/http-foundation/Session/Storage/Handler/MongoDbSessionHandler.phpG  gG  $      N   vendor/symfony/http-foundation/Session/Storage/Handler/RedisSessionHandler.php  g  G      O   vendor/symfony/http-foundation/Session/Storage/Handler/StrictSessionHandler.php	  g	  mI      R   vendor/symfony/http-foundation/Session/Storage/Handler/MemcachedSessionHandler.php  g  oڤ      G   vendor/symfony/http-foundation/Session/Storage/NativeSessionStorage.php7  g7  w`      J   vendor/symfony/http-foundation/Session/Storage/SessionStorageInterface.php/  g/  {      P   vendor/symfony/http-foundation/Session/Storage/MockFileSessionStorageFactory.php  g  YPZ      L   vendor/symfony/http-foundation/Session/Storage/Proxy/SessionHandlerProxy.phpB	  gB	        F   vendor/symfony/http-foundation/Session/Storage/Proxy/AbstractProxy.php  g  <      N   vendor/symfony/http-foundation/Session/Storage/NativeSessionStorageFactory.php!  g!  	      J   vendor/symfony/http-foundation/Session/Storage/PhpBridgeSessionStorage.php  g  f      Q   vendor/symfony/http-foundation/Session/Storage/SessionStorageFactoryInterface.phpw  gw  ]n      I   vendor/symfony/http-foundation/Session/Storage/MockFileSessionStorage.php  g  *8      Q   vendor/symfony/http-foundation/Session/Storage/PhpBridgeSessionStorageFactory.php  g  ɤ      >   vendor/symfony/http-foundation/Session/Storage/MetadataBag.php
  g
        J   vendor/symfony/http-foundation/Session/Storage/MockArraySessionStorage.php	  g	  Q3U      ;   vendor/symfony/http-foundation/Session/SessionInterface.php  g  OY>      C   vendor/symfony/http-foundation/Session/Flash/AutoExpireFlashBag.php  g  Ԗޤ      B   vendor/symfony/http-foundation/Session/Flash/FlashBagInterface.php  g  u1Ф      9   vendor/symfony/http-foundation/Session/Flash/FlashBag.php	  g	  vɅ      9   vendor/symfony/http-foundation/Session/SessionFactory.phpG  gG  
      :   vendor/symfony/http-foundation/Session/SessionBagProxy.php  g  
      >   vendor/symfony/http-foundation/Session/SessionBagInterface.phpW  gW  #9      ,   vendor/symfony/var-exporter/Instantiator.php	  g	  
      +   vendor/symfony/var-exporter/ProxyHelper.php'W  g'W  eF      #   vendor/symfony/var-exporter/LICENSE,  g,        (   vendor/symfony/var-exporter/CHANGELOG.md  g  t?      (   vendor/symfony/var-exporter/Hydrator.php  g  aZ(      8   vendor/symfony/var-exporter/Internal/LazyObjectState.php  g  7!4      ;   vendor/symfony/var-exporter/Internal/LazyObjectRegistry.php4  g4  Őܤ      /   vendor/symfony/var-exporter/Internal/Values.php  g  `ǿ      8   vendor/symfony/var-exporter/Internal/LazyObjectTrait.php)  g)  ;ޣ      1   vendor/symfony/var-exporter/Internal/Hydrator.php*  g*  bj%      1   vendor/symfony/var-exporter/Internal/Registry.php@  g@  #      2   vendor/symfony/var-exporter/Internal/Reference.php
  g
  #Jn      1   vendor/symfony/var-exporter/Internal/Exporter.phpyA  gyA  GUS      .   vendor/symfony/var-exporter/LazyGhostTrait.php";  g";  SԤ      %   vendor/symfony/var-exporter/README.md-  g-  "      .   vendor/symfony/var-exporter/LazyProxyTrait.php1  g1  !      +   vendor/symfony/var-exporter/VarExporter.phpR  gR  eH      3   vendor/symfony/var-exporter/LazyObjectInterface.phpa  ga  @#      8   vendor/symfony/var-exporter/Exception/LogicException.php  g  -ʤ      <   vendor/symfony/var-exporter/Exception/ExceptionInterface.phpd  gd        @   vendor/symfony/var-exporter/Exception/ClassNotFoundException.php1  g1  w w      F   vendor/symfony/var-exporter/Exception/NotInstantiableTypeException.php>  g>  }      )   vendor/symfony/var-exporter/composer.jsonr  gr  ~j      E   vendor/symfony/error-handler/ErrorEnhancer/ErrorEnhancerInterface.php	  g	  ޺      I   vendor/symfony/error-handler/ErrorEnhancer/ClassNotFoundErrorEnhancer.phpR  gR        M   vendor/symfony/error-handler/ErrorEnhancer/UndefinedFunctionErrorEnhancer.php*  g*  ^z      K   vendor/symfony/error-handler/ErrorEnhancer/UndefinedMethodErrorEnhancer.php  g  1'      $   vendor/symfony/error-handler/LICENSE,  g,  զ_Ϥ      )   vendor/symfony/error-handler/CHANGELOG.md  g  D9      B   vendor/symfony/error-handler/Resources/bin/patch-type-declarations
  g
  d"m      M   vendor/symfony/error-handler/Resources/bin/extract-tentative-return-types.php   g   mE      ?   vendor/symfony/error-handler/Resources/views/exception.html.php/  g/        <   vendor/symfony/error-handler/Resources/views/traces.html.php
  g
  n       A   vendor/symfony/error-handler/Resources/views/traces_text.html.php  g  j+2      :   vendor/symfony/error-handler/Resources/views/logs.html.php)	  g)	  _&      ;   vendor/symfony/error-handler/Resources/views/trace.html.php`  g`  39      ;   vendor/symfony/error-handler/Resources/views/error.html.phpd  gd  x      D   vendor/symfony/error-handler/Resources/views/exception_full.html.php  g  Eޤ      ?   vendor/symfony/error-handler/Resources/assets/css/exception.css	B  g	B  R      D   vendor/symfony/error-handler/Resources/assets/css/exception_full.css
  g
  *bc      ;   vendor/symfony/error-handler/Resources/assets/css/error.css  g  %7      J   vendor/symfony/error-handler/Resources/assets/images/icon-minus-square.svgQ  gQ  p      B   vendor/symfony/error-handler/Resources/assets/images/icon-book.svg  g        E   vendor/symfony/error-handler/Resources/assets/images/icon-support.svgz  gz  S̤      F   vendor/symfony/error-handler/Resources/assets/images/chevron-right.svg  g        J   vendor/symfony/error-handler/Resources/assets/images/symfony-ghost.svg.php   g   9꒤      I   vendor/symfony/error-handler/Resources/assets/images/icon-plus-square.svg  g  U      E   vendor/symfony/error-handler/Resources/assets/images/symfony-logo.svg  g  %0ɤ      B   vendor/symfony/error-handler/Resources/assets/images/icon-copy.svg	  g	  "Ȗ      G   vendor/symfony/error-handler/Resources/assets/images/favicon.png.base64  g  "i^      K   vendor/symfony/error-handler/Resources/assets/images/icon-plus-square-o.svg  g  -      L   vendor/symfony/error-handler/Resources/assets/images/icon-minus-square-o.svg  g  s0      =   vendor/symfony/error-handler/Resources/assets/js/exception.js4  g4  C#      8   vendor/symfony/error-handler/Internal/TentativeTypes.php  g        &   vendor/symfony/error-handler/Debug.phpH  gH  s
ߤ      F   vendor/symfony/error-handler/ErrorRenderer/SerializerErrorRenderer.php
  g
  <      ?   vendor/symfony/error-handler/ErrorRenderer/CliErrorRenderer.php  g  
+2      E   vendor/symfony/error-handler/ErrorRenderer/ErrorRendererInterface.php  g  sۤ      @   vendor/symfony/error-handler/ErrorRenderer/HtmlErrorRenderer.php]  g]  Yc      @   vendor/symfony/error-handler/ErrorRenderer/FileLinkFormatter.phpP  gP  Y      &   vendor/symfony/error-handler/README.md=  g=  \      1   vendor/symfony/error-handler/DebugClassLoader.php#  g#  qY      0   vendor/symfony/error-handler/BufferingLogger.phpA  gA  Z      -   vendor/symfony/error-handler/ErrorHandler.phpuk  guk  w)      /   vendor/symfony/error-handler/ThrowableUtils.php{  g{  -F      7   vendor/symfony/error-handler/Error/OutOfMemoryError.php[  g[  N      ;   vendor/symfony/error-handler/Error/UndefinedMethodError.php  g  V[      1   vendor/symfony/error-handler/Error/FatalError.php
  g
  Ff      =   vendor/symfony/error-handler/Error/UndefinedFunctionError.php  g  lnB      9   vendor/symfony/error-handler/Error/ClassNotFoundError.php  g  Ep      ;   vendor/symfony/error-handler/Exception/FlattenException.phpI.  gI.  ޱњ      ?   vendor/symfony/error-handler/Exception/SilencedErrorContext.phpr  gr  +      *   vendor/symfony/error-handler/composer.json  g  ny&      4   vendor/symfony/cache-contracts/CallbackInterface.php]  g]  oW$      0   vendor/symfony/cache-contracts/ItemInterface.php6  g6  #
      &   vendor/symfony/cache-contracts/LICENSE,  g,        +   vendor/symfony/cache-contracts/CHANGELOG.md   g   h{#      1   vendor/symfony/cache-contracts/CacheInterface.php2	  g2	  5      (   vendor/symfony/cache-contracts/README.mdF  gF  _      -   vendor/symfony/cache-contracts/CacheTrait.php	  g	  iW      9   vendor/symfony/cache-contracts/TagAwareCacheInterface.php  g  1swc      ,   vendor/symfony/cache-contracts/composer.json  g  Av      7   vendor/symfony/dependency-injection/EnvVarProcessor.php2  g2  sF      ;   vendor/symfony/dependency-injection/ContainerAwareTrait.phpO  gO  4rS      B   vendor/symfony/dependency-injection/ExpressionLanguageProvider.php\  g\  lD      1   vendor/symfony/dependency-injection/Container.php6  g6  S      8   vendor/symfony/dependency-injection/ReverseContainer.php	  g	  4)Ȥ      0   vendor/symfony/dependency-injection/Variable.php  g  hp      P   vendor/symfony/dependency-injection/Extension/ConfigurableExtensionInterface.php#  g#  ᅋ~      D   vendor/symfony/dependency-injection/Extension/ExtensionInterface.php`  g`  ^
N      C   vendor/symfony/dependency-injection/Extension/AbstractExtension.php  g  W$      @   vendor/symfony/dependency-injection/Extension/ExtensionTrait.php  g  V      ;   vendor/symfony/dependency-injection/Extension/Extension.php  g  0B      K   vendor/symfony/dependency-injection/Extension/PrependExtensionInterface.phpS  gS  NC6      Q   vendor/symfony/dependency-injection/Extension/ConfigurationExtensionInterface.phpS  gS  )      ?   vendor/symfony/dependency-injection/Attribute/Autoconfigure.php  g  ZӤ      B   vendor/symfony/dependency-injection/Attribute/AutowireIterator.php  g  o      =   vendor/symfony/dependency-injection/Attribute/AsDecorator.phpo  go  Y|      H   vendor/symfony/dependency-injection/Attribute/AutowireServiceClosure.php  g  ^#5      >   vendor/symfony/dependency-injection/Attribute/AsTaggedItem.php  g  k      8   vendor/symfony/dependency-injection/Attribute/Target.php  g  A      6   vendor/symfony/dependency-injection/Attribute/When.php  g  Xˤ      C   vendor/symfony/dependency-injection/Attribute/AutowireDecorated.php  g  +h      @   vendor/symfony/dependency-injection/Attribute/TaggedIterator.php  g  u      A   vendor/symfony/dependency-injection/Attribute/AutowireLocator.phpe
  ge
        B   vendor/symfony/dependency-injection/Attribute/AutowireCallable.phpT  gT  鼎`      :   vendor/symfony/dependency-injection/Attribute/Autowire.php]
  g]
  sO      B   vendor/symfony/dependency-injection/Attribute/AutoconfigureTag.php  g  	       ?   vendor/symfony/dependency-injection/Attribute/TaggedLocator.php  g  鱞      >   vendor/symfony/dependency-injection/Attribute/MapDecorated.phpb  gb  \      9   vendor/symfony/dependency-injection/Attribute/Exclude.php  g  a)      9   vendor/symfony/dependency-injection/Attribute/AsAlias.php  g        +   vendor/symfony/dependency-injection/LICENSE,  g,  U      0   vendor/symfony/dependency-injection/CHANGELOG.mdhI  ghI  Z[      Q   vendor/symfony/dependency-injection/Config/ContainerParametersResourceChecker.php)  g)  }~      J   vendor/symfony/dependency-injection/Config/ContainerParametersResource.php  g  5      J   vendor/symfony/dependency-injection/Argument/ReferenceSetArgumentTrait.php	  g	  /      A   vendor/symfony/dependency-injection/Argument/AbstractArgument.php  g  1i      D   vendor/symfony/dependency-injection/Argument/RewindableGenerator.php  g  s      G   vendor/symfony/dependency-injection/Argument/ServiceLocatorArgument.php  g  /c=      >   vendor/symfony/dependency-injection/Argument/BoundArgument.php  g  >))      A   vendor/symfony/dependency-injection/Argument/IteratorArgument.php6  g6  2Ҥ      <   vendor/symfony/dependency-injection/Argument/LazyClosure.php_
  g_
  a5Ѥ      G   vendor/symfony/dependency-injection/Argument/TaggedIteratorArgument.phpu
  gu
        B   vendor/symfony/dependency-injection/Argument/ArgumentInterface.phpN  gN        ?   vendor/symfony/dependency-injection/Argument/ServiceLocator.php#  g#  ěs@      G   vendor/symfony/dependency-injection/Argument/ServiceClosureArgument.php*  g*  k      8   vendor/symfony/dependency-injection/ContainerBuilder.php  g  AcZ      7   vendor/symfony/dependency-injection/ChildDefinition.phpp
  gp
  /o      1   vendor/symfony/dependency-injection/Reference.php  g  ͯ      J   vendor/symfony/dependency-injection/ParameterBag/ParameterBagInterface.php	  g	  U]      O   vendor/symfony/dependency-injection/ParameterBag/EnvPlaceholderParameterBag.php  g  !      A   vendor/symfony/dependency-injection/ParameterBag/ParameterBag.php$  g$  AҤ      J   vendor/symfony/dependency-injection/ParameterBag/ContainerBagInterface.php  g        A   vendor/symfony/dependency-injection/ParameterBag/ContainerBag.php  g  #O      G   vendor/symfony/dependency-injection/ParameterBag/FrozenParameterBag.php  g  0P      2   vendor/symfony/dependency-injection/Definition.phpP  gP  D      @   vendor/symfony/dependency-injection/EnvVarProcessorInterface.php  g  90      -   vendor/symfony/dependency-injection/README.mdC  gC  <      :   vendor/symfony/dependency-injection/ContainerInterface.phpd	  gd	  ʤ      9   vendor/symfony/dependency-injection/Loader/FileLoader.php<  g<  (٤      =   vendor/symfony/dependency-injection/Loader/YamlFileLoader.php
  g
  Qd2      O   vendor/symfony/dependency-injection/Loader/schema/dic/services/services-1.0.xsdB  gB  o      <   vendor/symfony/dependency-injection/Loader/PhpFileLoader.php!  g!  g      <   vendor/symfony/dependency-injection/Loader/XmlFileLoader.php  g  Bd      <   vendor/symfony/dependency-injection/Loader/IniFileLoader.php  g  j}      P   vendor/symfony/dependency-injection/Loader/Configurator/ServicesConfigurator.php4  g4  g      P   vendor/symfony/dependency-injection/Loader/Configurator/DefaultsConfigurator.php9	  g9	  Ca      Q   vendor/symfony/dependency-injection/Loader/Configurator/ReferenceConfigurator.php  g  w      T   vendor/symfony/dependency-injection/Loader/Configurator/FromCallableConfigurator.php  g  6n      M   vendor/symfony/dependency-injection/Loader/Configurator/Traits/ClassTrait.php1  g1  D      L   vendor/symfony/dependency-injection/Loader/Configurator/Traits/CallTrait.phpN  gN  X_^      Q   vendor/symfony/dependency-injection/Loader/Configurator/Traits/SyntheticTrait.php  g  .      P   vendor/symfony/dependency-injection/Loader/Configurator/Traits/PropertyTrait.phpl  gl  
s_      P   vendor/symfony/dependency-injection/Loader/Configurator/Traits/ArgumentTrait.php  g  
      T   vendor/symfony/dependency-injection/Loader/Configurator/Traits/ConfiguratorTrait.php  g  M      N   vendor/symfony/dependency-injection/Loader/Configurator/Traits/ParentTrait.php  g  (      O   vendor/symfony/dependency-injection/Loader/Configurator/Traits/FactoryTrait.phpd  gd  'D      K   vendor/symfony/dependency-injection/Loader/Configurator/Traits/TagTrait.php  g  p       N   vendor/symfony/dependency-injection/Loader/Configurator/Traits/PublicTrait.php  g        P   vendor/symfony/dependency-injection/Loader/Configurator/Traits/DecorateTrait.php{  g{  2Ѥ      U   vendor/symfony/dependency-injection/Loader/Configurator/Traits/AutoconfigureTrait.phpE  gE  ^7      T   vendor/symfony/dependency-injection/Loader/Configurator/Traits/FromCallableTrait.php	  g	  \      Q   vendor/symfony/dependency-injection/Loader/Configurator/Traits/DeprecateTrait.phpb  gb  *'Ѥ      L   vendor/symfony/dependency-injection/Loader/Configurator/Traits/BindTrait.php[  g[  Bf      L   vendor/symfony/dependency-injection/Loader/Configurator/Traits/LazyTrait.phpD  gD  5R      L   vendor/symfony/dependency-injection/Loader/Configurator/Traits/FileTrait.phpG  gG  F8      P   vendor/symfony/dependency-injection/Loader/Configurator/Traits/AbstractTrait.php  g  ge      M   vendor/symfony/dependency-injection/Loader/Configurator/Traits/ShareTrait.phpL  gL  b      P   vendor/symfony/dependency-injection/Loader/Configurator/Traits/AutowireTrait.phpM  gM  P      S   vendor/symfony/dependency-injection/Loader/Configurator/Traits/ConstructorTrait.phpU  gU  86$      P   vendor/symfony/dependency-injection/Loader/Configurator/AbstractConfigurator.php  g  ԏ)      X   vendor/symfony/dependency-injection/Loader/Configurator/ClosureReferenceConfigurator.php  g  #y      K   vendor/symfony/dependency-injection/Loader/Configurator/EnvConfigurator.phpj  gj        W   vendor/symfony/dependency-injection/Loader/Configurator/AbstractServiceConfigurator.php  g  fۤ      R   vendor/symfony/dependency-injection/Loader/Configurator/InstanceofConfigurator.php  g  !R      Q   vendor/symfony/dependency-injection/Loader/Configurator/ContainerConfigurator.php  g  4      M   vendor/symfony/dependency-injection/Loader/Configurator/AliasConfigurator.php  g  RF,b      U   vendor/symfony/dependency-injection/Loader/Configurator/InlineServiceConfigurator.phpR  gR  <      Q   vendor/symfony/dependency-injection/Loader/Configurator/PrototypeConfigurator.php
  g
  o      R   vendor/symfony/dependency-injection/Loader/Configurator/ParametersConfigurator.php  g  "      O   vendor/symfony/dependency-injection/Loader/Configurator/ServiceConfigurator.php  g  A[_v      >   vendor/symfony/dependency-injection/Loader/DirectoryLoader.php2  g2  	      =   vendor/symfony/dependency-injection/Loader/GlobFileLoader.php`  g`        <   vendor/symfony/dependency-injection/Loader/ClosureLoader.php  g  5      =   vendor/symfony/dependency-injection/LazyProxy/ProxyHelper.php  g  Ğ}      K   vendor/symfony/dependency-injection/LazyProxy/PhpDumper/DumperInterface.php  g  5=      M   vendor/symfony/dependency-injection/LazyProxy/PhpDumper/LazyServiceDumper.php  g  p<      F   vendor/symfony/dependency-injection/LazyProxy/PhpDumper/NullDumper.php  g  vOΤ      V   vendor/symfony/dependency-injection/LazyProxy/Instantiator/LazyServiceInstantiator.php  g  (d      V   vendor/symfony/dependency-injection/LazyProxy/Instantiator/RealServiceInstantiator.phpd  gd  翓      T   vendor/symfony/dependency-injection/LazyProxy/Instantiator/InstantiatorInterface.php~  g~  0ND      :   vendor/symfony/dependency-injection/ExpressionLanguage.phpb  gb  !UO      6   vendor/symfony/dependency-injection/ServiceLocator.php  g  9x"D      6   vendor/symfony/dependency-injection/TypedReference.php3  g3  adt      -   vendor/symfony/dependency-injection/Alias.php  g  nZԤ      U   vendor/symfony/dependency-injection/Exception/ParameterCircularReferenceException.php  g  t9      @   vendor/symfony/dependency-injection/Exception/LogicException.php  g  }|Ȥ      F   vendor/symfony/dependency-injection/Exception/EnvNotFoundException.php  g  &      L   vendor/symfony/dependency-injection/Exception/ParameterNotFoundException.php"  g"  
      D   vendor/symfony/dependency-injection/Exception/ExceptionInterface.php~  g~        F   vendor/symfony/dependency-injection/Exception/OutOfBoundsException.php  g  On      S   vendor/symfony/dependency-injection/Exception/ServiceCircularReferenceException.php_  g_  Ke&      J   vendor/symfony/dependency-injection/Exception/ServiceNotFoundException.php  g  Ф      B   vendor/symfony/dependency-injection/Exception/RuntimeException.php	  g	  
      J   vendor/symfony/dependency-injection/Exception/InvalidArgumentException.php'  g'        H   vendor/symfony/dependency-injection/Exception/BadMethodCallException.php  g  ,w      K   vendor/symfony/dependency-injection/Exception/AutowiringFailedException.php  g  M      O   vendor/symfony/dependency-injection/Exception/InvalidParameterTypeException.php0  g0  I      G   vendor/symfony/dependency-injection/Exception/EnvParameterException.php  g  =&)      @   vendor/symfony/dependency-injection/TaggedContainerInterface.php  g  J.      1   vendor/symfony/dependency-injection/Parameter.phpf  gf  sD      E   vendor/symfony/dependency-injection/Compiler/DecoratorServicePass.php  g  'f      M   vendor/symfony/dependency-injection/Compiler/ResolveInvalidReferencesPass.php  g  ]      L   vendor/symfony/dependency-injection/Compiler/ValidateEnvPlaceholdersPass.php  g        M   vendor/symfony/dependency-injection/Compiler/RegisterEnvVarProcessorsPass.php@  g@  p脤      T   vendor/symfony/dependency-injection/Compiler/RegisterAutoconfigureAttributesPass.php  g        L   vendor/symfony/dependency-injection/Compiler/CheckDefinitionValidityPass.php!  g!  gPK      ;   vendor/symfony/dependency-injection/Compiler/PassConfig.phpm  gm  1&      F   vendor/symfony/dependency-injection/Compiler/ServiceReferenceGraph.php
  g
  j      E   vendor/symfony/dependency-injection/Compiler/ResolveNoPreloadPass.phpK  gK  7ɤ      J   vendor/symfony/dependency-injection/Compiler/ServiceReferenceGraphNode.php  g        J   vendor/symfony/dependency-injection/Compiler/CheckTypeDeclarationsPass.php1  g1  W       M   vendor/symfony/dependency-injection/Compiler/InlineServiceDefinitionsPass.php  g        H   vendor/symfony/dependency-injection/Compiler/ResolveFactoryClassPass.php   g   %d      D   vendor/symfony/dependency-injection/Compiler/ResolveBindingsPass.php$*  g$*  
B      H   vendor/symfony/dependency-injection/Compiler/AutowireAsDecoratorPass.php  g  3      K   vendor/symfony/dependency-injection/Compiler/PriorityTaggedServiceTrait.php  g  v3      M   vendor/symfony/dependency-injection/Compiler/RegisterReverseContainerPass.php  g  QY      F   vendor/symfony/dependency-injection/Compiler/AbstractRecursivePass.php8*  g8*  c3      R   vendor/symfony/dependency-injection/Compiler/AliasDeprecatedPublicServicesPass.php  g  Hl      R   vendor/symfony/dependency-injection/Compiler/ResolveInstanceofConditionalsPass.php8  g8  y      O   vendor/symfony/dependency-injection/Compiler/ResolveReferencesToAliasesPass.php  g  cW      K   vendor/symfony/dependency-injection/Compiler/CheckArgumentsValidityPass.php3  g3  췤      O   vendor/symfony/dependency-injection/Compiler/AttributeAutoconfigurationPass.php  g  1x      O   vendor/symfony/dependency-injection/Compiler/AutowireRequiredPropertiesPass.php-
  g-
  zh      J   vendor/symfony/dependency-injection/Compiler/ResolveNamedArgumentsPass.php'  g'  $      I   vendor/symfony/dependency-injection/Compiler/RemovePrivateAliasesPass.php  g  XB      P   vendor/symfony/dependency-injection/Compiler/MergeExtensionConfigurationPass.php!  g!  ?      J   vendor/symfony/dependency-injection/Compiler/ServiceReferenceGraphEdge.phpi  gi  ^n      M   vendor/symfony/dependency-injection/Compiler/DefinitionErrorExceptionPass.phpB
  gB
  B      L   vendor/symfony/dependency-injection/Compiler/RemoveUnusedDefinitionsPass.php  g  xp      =   vendor/symfony/dependency-injection/Compiler/AutowirePass.php8{  g8{  an+      F   vendor/symfony/dependency-injection/Compiler/ServiceLocatorTagPass.php  g  J      R   vendor/symfony/dependency-injection/Compiler/ResolveTaggedIteratorArgumentPass.phpq  gq  ?      K   vendor/symfony/dependency-injection/Compiler/ResolveEnvPlaceholdersPass.php  g  ]      L   vendor/symfony/dependency-injection/Compiler/CheckCircularReferencesPass.php  g  gG      ]   vendor/symfony/dependency-injection/Compiler/CheckExceptionOnInvalidReferenceBehaviorPass.php  g  Lפ      J   vendor/symfony/dependency-injection/Compiler/RemoveBuildParametersPass.php  g  vg      E   vendor/symfony/dependency-injection/Compiler/AutoAliasServicePass.php  g  zp
      Q   vendor/symfony/dependency-injection/Compiler/ResolveParameterPlaceHoldersPass.php  g  F0      A   vendor/symfony/dependency-injection/Compiler/ResolveClassPass.php]  g]  v`      N   vendor/symfony/dependency-injection/Compiler/RemoveAbstractDefinitionsPass.php  g  Q      K   vendor/symfony/dependency-injection/Compiler/CheckReferenceValidityPass.php6  g6  YB      O   vendor/symfony/dependency-injection/Compiler/RegisterServiceSubscribersPass.php  g  a%      C   vendor/symfony/dependency-injection/Compiler/ResolveHotPathPass.php<	  g<	  sY[      J   vendor/symfony/dependency-injection/Compiler/ResolveDecoratorStackPass.php  g  lD      N   vendor/symfony/dependency-injection/Compiler/ResolveServiceSubscribersPass.php  g  ٭v      F   vendor/symfony/dependency-injection/Compiler/CompilerPassInterface.php  g  &      S   vendor/symfony/dependency-injection/Compiler/ReplaceAliasByActualDefinitionPass.phpa  ga  p6      L   vendor/symfony/dependency-injection/Compiler/ResolveChildDefinitionsPass.php&  g&  W      9   vendor/symfony/dependency-injection/Compiler/Compiler.php
  g
  ˤ      F   vendor/symfony/dependency-injection/Compiler/ExtensionCompilerPass.php  g        M   vendor/symfony/dependency-injection/Compiler/AnalyzeServiceReferencesPass.php  g  ^0      L   vendor/symfony/dependency-injection/Compiler/AutowireRequiredMethodsPass.php  g  `#{      =   vendor/symfony/dependency-injection/Dumper/GraphvizDumper.php#  g#  sO      9   vendor/symfony/dependency-injection/Dumper/YamlDumper.php"8  g"8  Oˤ      8   vendor/symfony/dependency-injection/Dumper/Preloader.php  g  v{      8   vendor/symfony/dependency-injection/Dumper/XmlDumper.phpH  gH  ]߸      >   vendor/symfony/dependency-injection/Dumper/DumperInterface.phpV  gV  s#      5   vendor/symfony/dependency-injection/Dumper/Dumper.php  g  U;a      8   vendor/symfony/dependency-injection/Dumper/PhpDumper.php g 6      1   vendor/symfony/dependency-injection/composer.json  g  2      =   vendor/symfony/dependency-injection/EnvVarLoaderInterface.php  g  bkr      ?   vendor/symfony/dependency-injection/ContainerAwareInterface.php  g  =>         vendor/symfony/clock/LICENSE,  g,  t=      1   vendor/symfony/clock/Test/ClockSensitiveTrait.php  g  I      !   vendor/symfony/clock/CHANGELOG.md  g  CJ      &   vendor/symfony/clock/Resources/now.php  g  5䏤      (   vendor/symfony/clock/ClockAwareTrait.php  g  3         vendor/symfony/clock/README.md  g  I      "   vendor/symfony/clock/MockClock.php  g  $i         vendor/symfony/clock/Clock.phpS	  gS	  *R'      '   vendor/symfony/clock/MonotonicClock.php
  g
  }Z      '   vendor/symfony/clock/ClockInterface.phpL  gL  z֚&      "   vendor/symfony/clock/DatePoint.php  g  Ф      "   vendor/symfony/clock/composer.json  g  GPҤ      $   vendor/symfony/clock/NativeClock.php/  g/  ur+      :   vendor/symfony/password-hasher/PasswordHasherInterface.php  g  -<      >   vendor/symfony/password-hasher/Hasher/SodiumPasswordHasher.php  g  ^~      B   vendor/symfony/password-hasher/Hasher/CheckPasswordLengthTrait.php  g  B+.      <   vendor/symfony/password-hasher/Hasher/UserPasswordHasher.phpK  gK  r,Ф      >   vendor/symfony/password-hasher/Hasher/Pbkdf2PasswordHasher.php  g  S8      F   vendor/symfony/password-hasher/Hasher/PasswordHasherAwareInterface.php  g  ϡ*      >   vendor/symfony/password-hasher/Hasher/NativePasswordHasher.php  g  Q      E   vendor/symfony/password-hasher/Hasher/MessageDigestPasswordHasher.php 
  g 
  r6k      E   vendor/symfony/password-hasher/Hasher/UserPasswordHasherInterface.phpr  gr  4Τ      A   vendor/symfony/password-hasher/Hasher/PlaintextPasswordHasher.php[	  g[	        H   vendor/symfony/password-hasher/Hasher/PasswordHasherFactoryInterface.php  g  @      A   vendor/symfony/password-hasher/Hasher/MigratingPasswordHasher.php  g  rG      ?   vendor/symfony/password-hasher/Hasher/PasswordHasherFactory.php&!  g&!  FA      &   vendor/symfony/password-hasher/LICENSE,  g,  U      +   vendor/symfony/password-hasher/CHANGELOG.md   g   ڰ      @   vendor/symfony/password-hasher/LegacyPasswordHasherInterface.php  g  t      (   vendor/symfony/password-hasher/README.md  g  !      B   vendor/symfony/password-hasher/Command/UserPasswordHashCommand.php'  g'  8      ;   vendor/symfony/password-hasher/Exception/LogicException.php  g  A      ?   vendor/symfony/password-hasher/Exception/ExceptionInterface.php  g  EWL      E   vendor/symfony/password-hasher/Exception/InvalidPasswordException.php  g  L      ,   vendor/symfony/password-hasher/composer.json  g           vendor/symfony/process/LICENSE,  g,  U      +   vendor/symfony/process/ExecutableFinder.php
  g
  wt      #   vendor/symfony/process/CHANGELOG.md  g   %8          vendor/symfony/process/README.md  g  \3$Ϥ      *   vendor/symfony/process/Pipes/UnixPipes.php  g  Q\      -   vendor/symfony/process/Pipes/WindowsPipes.php  g  Q      .   vendor/symfony/process/Pipes/AbstractPipes.php  g  e      /   vendor/symfony/process/Pipes/PipesInterface.php  g        &   vendor/symfony/process/InputStream.php	  g	  6ee      6   vendor/symfony/process/Messenger/RunProcessContext.php|  g|  ɔ      6   vendor/symfony/process/Messenger/RunProcessMessage.php  g  2$      =   vendor/symfony/process/Messenger/RunProcessMessageHandler.php%  g%  0      %   vendor/symfony/process/PhpProcess.php	  g	  3x      (   vendor/symfony/process/PhpSubprocess.php  g  :1      .   vendor/symfony/process/PhpExecutableFinder.php%	  g%	  ޏx      =   vendor/symfony/process/Exception/ProcessSignaledException.php  g  -n_      3   vendor/symfony/process/Exception/LogicException.php  g  iUQ      7   vendor/symfony/process/Exception/ExceptionInterface.php  g  
j%W      ;   vendor/symfony/process/Exception/ProcessFailedException.phpp  gp   ۋ      5   vendor/symfony/process/Exception/RuntimeException.php  g  P      =   vendor/symfony/process/Exception/ProcessTimedOutException.php  g  8^Q      =   vendor/symfony/process/Exception/InvalidArgumentException.php  g  ڴ      >   vendor/symfony/process/Exception/RunProcessFailedException.php  g  ؤ      $   vendor/symfony/process/composer.json  g  S.t      '   vendor/symfony/process/ProcessUtils.php  g  a鍤      "   vendor/symfony/process/Process.php  g  8      =   vendor/symfony/console/DataCollector/CommandDataCollector.php  g  &      (   vendor/symfony/console/ConsoleEvents.php  g  .
      !   vendor/symfony/console/Cursor.php  g  \Fä      &   vendor/symfony/console/Application.php  g  !(      /   vendor/symfony/console/Logger/ConsoleLogger.phpY  gY  Ġ      .   vendor/symfony/console/Attribute/AsCommand.phpJ  gJ  c         vendor/symfony/console/LICENSE,  g,  U      #   vendor/symfony/console/CHANGELOG.md)  g)   b_e      9   vendor/symfony/console/Input/StreamableInputInterface.php  g  3y-      +   vendor/symfony/console/Input/ArrayInput.phpH  gH  ůx      *   vendor/symfony/console/Input/ArgvInput.php0  g0  #      .   vendor/symfony/console/Input/InputArgument.php:  g:  ț      4   vendor/symfony/console/Input/InputAwareInterface.phpc  gc  Q      ,   vendor/symfony/console/Input/InputOption.php!  g!  !1g=      0   vendor/symfony/console/Input/InputDefinition.phpU.  gU.  )ͤ      ,   vendor/symfony/console/Input/StringInput.php
  g
  G      &   vendor/symfony/console/Input/Input.phpl  gl  ;      /   vendor/symfony/console/Input/InputInterface.php|  g|  kx'      #   vendor/symfony/console/Terminal.php  g  `HN      2   vendor/symfony/console/CI/GithubActionReporter.php+  g+  @      0   vendor/symfony/console/Resources/completion.bash  g  %}      4   vendor/symfony/console/Resources/bin/hiddeninput.exe $  g $  v      /   vendor/symfony/console/Resources/completion.zsh  g  ʤ      0   vendor/symfony/console/Resources/completion.fish  g  Keդ      5   vendor/symfony/console/Output/TrimmedBufferOutput.phpY  gY  G>d      8   vendor/symfony/console/Output/ConsoleOutputInterface.php=  g=  B:      0   vendor/symfony/console/Output/BufferedOutput.phpQ  gQ  *AS      1   vendor/symfony/console/Output/OutputInterface.php6  g6  j8q      /   vendor/symfony/console/Output/AnsiColorMode.php
  g
  oi+      (   vendor/symfony/console/Output/Output.php  g  \Τ      6   vendor/symfony/console/Output/ConsoleSectionOutput.php9!  g9!         /   vendor/symfony/console/Output/ConsoleOutput.php  g  :*      ,   vendor/symfony/console/Output/NullOutput.phpO  gO  p       .   vendor/symfony/console/Output/StreamOutput.php  g  +%ؤ      A   vendor/symfony/console/Completion/Output/FishCompletionOutput.php  g  `      A   vendor/symfony/console/Completion/Output/BashCompletionOutput.php	  g	  Q2      F   vendor/symfony/console/Completion/Output/CompletionOutputInterface.php  g  :]      @   vendor/symfony/console/Completion/Output/ZshCompletionOutput.php1  g1        0   vendor/symfony/console/Completion/Suggestion.php7  g7  /)	Ϥ      ;   vendor/symfony/console/Completion/CompletionSuggestions.php^  g^  lx      5   vendor/symfony/console/Completion/CompletionInput.php   g   jfO      ,   vendor/symfony/console/Style/OutputStyle.php  g  Vy      -   vendor/symfony/console/Style/SymfonyStyle.php;  g;  
&ˤ      /   vendor/symfony/console/Style/StyleInterface.php
  g
  .      2   vendor/symfony/console/Question/ChoiceQuestion.php1  g1  JY      ,   vendor/symfony/console/Question/Question.php>  g>  o[դ      8   vendor/symfony/console/Question/ConfirmationQuestion.php,  g,  %          vendor/symfony/console/README.md  g  Æf      9   vendor/symfony/console/Formatter/OutputFormatterStyle.php  g  yM      B   vendor/symfony/console/Formatter/OutputFormatterStyleInterface.php  g  ǡ      =   vendor/symfony/console/Formatter/NullOutputFormatterStyle.phpl  gl        =   vendor/symfony/console/Formatter/OutputFormatterInterface.php"  g"  7V6_      4   vendor/symfony/console/Formatter/OutputFormatter.phpM   gM   =b      8   vendor/symfony/console/Formatter/NullOutputFormatter.php  g  B[      F   vendor/symfony/console/Formatter/WrappableOutputFormatterInterface.php  g  *
      >   vendor/symfony/console/Formatter/OutputFormatterStyleStack.php?
  g?
  :;      6   vendor/symfony/console/Messenger/RunCommandMessage.php  g  
M      6   vendor/symfony/console/Messenger/RunCommandContext.php  g  !B      =   vendor/symfony/console/Messenger/RunCommandMessageHandler.php  g  yzo          vendor/symfony/console/Color.php(  g(  -      8   vendor/symfony/console/SignalRegistry/SignalRegistry.php  g  G,eͤ      3   vendor/symfony/console/SignalRegistry/SignalMap.php  g  (      3   vendor/symfony/console/SingleCommandApplication.php>  g>  OA      ?   vendor/symfony/console/CommandLoader/CommandLoaderInterface.phpV  gV  X2      ?   vendor/symfony/console/CommandLoader/ContainerCommandLoader.php  g  ƒ      =   vendor/symfony/console/CommandLoader/FactoryCommandLoader.phpK  gK  <      4   vendor/symfony/console/Descriptor/TextDescriptor.php0  g0  f      <   vendor/symfony/console/Descriptor/ApplicationDescription.php(  g(  #1      3   vendor/symfony/console/Descriptor/XmlDescriptor.php&  g&  ,Eb      9   vendor/symfony/console/Descriptor/DescriptorInterface.phpm  gm  B      0   vendor/symfony/console/Descriptor/Descriptor.php
  g
  j      @   vendor/symfony/console/Descriptor/ReStructuredTextDescriptor.php')  g')  Ǿ4      4   vendor/symfony/console/Descriptor/JsonDescriptor.php%  g%  
֤      8   vendor/symfony/console/Descriptor/MarkdownDescriptor.php  g  4Qj      /   vendor/symfony/console/Tester/CommandTester.phpL	  gL	  5Ykؤ      -   vendor/symfony/console/Tester/TesterTrait.phpr  gr  Ƥ      3   vendor/symfony/console/Tester/ApplicationTester.php
  g
  Z3      9   vendor/symfony/console/Tester/CommandCompletionTester.phpD  gD  T      @   vendor/symfony/console/Tester/Constraint/CommandIsSuccessful.php+  g+  1      3   vendor/symfony/console/Command/TraceableCommand.php](  g](         .   vendor/symfony/console/Command/LazyCommand.php  g  oͤ      0   vendor/symfony/console/Command/LockableTrait.php3  g3        .   vendor/symfony/console/Command/HelpCommand.php	  g	  6_3      2   vendor/symfony/console/Command/CompleteCommand.php#  g#  sJ!      .   vendor/symfony/console/Command/ListCommand.php	  g	  e\{      8   vendor/symfony/console/Command/DumpCompletionCommand.php  g  +CQ      =   vendor/symfony/console/Command/SignalableCommandInterface.phpE  gE  bO      *   vendor/symfony/console/Command/Command.php!Z  g!Z  a 啤      ,   vendor/symfony/console/Helper/TableStyle.php!1  g!1  'p,      +   vendor/symfony/console/Helper/TableRows.php[  g[  {m֤      7   vendor/symfony/console/Helper/SymfonyQuestionHelper.php)
  g)
  7N      1   vendor/symfony/console/Helper/HelperInterface.phpV  gV  ̊      +   vendor/symfony/console/Helper/TableCell.php  g  e9S      /   vendor/symfony/console/Helper/ProcessHelper.php  g  e      0   vendor/symfony/console/Helper/TableSeparator.php!  g!  n2      /   vendor/symfony/console/Helper/OutputWrapper.php  g  lؤ      1   vendor/symfony/console/Helper/FormatterHelper.php  g  0ɤ      0   vendor/symfony/console/Helper/TableCellStyle.php)  g)  KӘ      -   vendor/symfony/console/Helper/ProgressBar.phpL  gL  r      6   vendor/symfony/console/Helper/DebugFormatterHelper.php

  g

  &      +   vendor/symfony/console/Helper/HelperSet.phpc  gc  V.      (   vendor/symfony/console/Helper/Dumper.phpz  gz  `      2   vendor/symfony/console/Helper/InputAwareHelper.php  g  pc      0   vendor/symfony/console/Helper/QuestionHelper.phpXL  gXL  ʱbܤ      (   vendor/symfony/console/Helper/Helper.php  g  +u      '   vendor/symfony/console/Helper/Table.php6{  g6{  De      3   vendor/symfony/console/Helper/ProgressIndicator.php  g  bN&      2   vendor/symfony/console/Helper/DescriptorHelper.phpd
  gd
        D   vendor/symfony/console/DependencyInjection/AddConsoleCommandPass.php  g  4      3   vendor/symfony/console/Exception/LogicException.php  g  5      ;   vendor/symfony/console/Exception/InvalidOptionException.php  g  %:      >   vendor/symfony/console/Exception/RunCommandFailedException.php>  g>  ~      7   vendor/symfony/console/Exception/ExceptionInterface.php  g  oOȤ      5   vendor/symfony/console/Exception/RuntimeException.php  g        ?   vendor/symfony/console/Exception/NamespaceNotFoundException.php  g  xD      =   vendor/symfony/console/Exception/InvalidArgumentException.php  g  x
Τ      :   vendor/symfony/console/Exception/MissingInputException.php  g  L      =   vendor/symfony/console/Exception/CommandNotFoundException.php  g  ͆Ť      6   vendor/symfony/console/Event/ConsoleTerminateEvent.php  g  [5Ť      2   vendor/symfony/console/Event/ConsoleErrorEvent.php  g  z      4   vendor/symfony/console/Event/ConsoleCommandEvent.php>  g>  y      -   vendor/symfony/console/Event/ConsoleEvent.php  g  8(M      3   vendor/symfony/console/Event/ConsoleSignalEvent.php  g  =|Ѯ      $   vendor/symfony/console/composer.jsonH  gH  +      +   vendor/symfony/console/Debug/CliRequest.phpq  gq  ekX      6   vendor/symfony/console/EventListener/ErrorListener.php  g  h
      0   vendor/symfony/polyfill-mbstring/bootstrap80.php'  g'  L#\M      (   vendor/symfony/polyfill-mbstring/LICENSE,  g,  H      B   vendor/symfony/polyfill-mbstring/Resources/unidata/caseFolding.php  g  ]SC      @   vendor/symfony/polyfill-mbstring/Resources/unidata/lowerCase.phpU  gU  D׎      F   vendor/symfony/polyfill-mbstring/Resources/unidata/titleCaseRegexp.php  g  oቤ      @   vendor/symfony/polyfill-mbstring/Resources/unidata/upperCase.phpO[  gO[  (      -   vendor/symfony/polyfill-mbstring/Mbstring.php  g  g_      .   vendor/symfony/polyfill-mbstring/bootstrap.php!  g!  d      *   vendor/symfony/polyfill-mbstring/README.mdr  gr  A`      .   vendor/symfony/polyfill-mbstring/composer.json8  g8        5   vendor/symfony/polyfill-intl-grapheme/bootstrap80.phpg
  gg
  E{      -   vendor/symfony/polyfill-intl-grapheme/LICENSE,  g,  H      2   vendor/symfony/polyfill-intl-grapheme/Grapheme.php&  g&  8      3   vendor/symfony/polyfill-intl-grapheme/bootstrap.php  g        /   vendor/symfony/polyfill-intl-grapheme/README.mdK  gK  C>      3   vendor/symfony/polyfill-intl-grapheme/composer.json   g   +          vendor/ramsey/collection/LICENSE7  g7  ŸԤ      "   vendor/ramsey/collection/README.md  g  3 Ӥ      &   vendor/ramsey/collection/composer.json|  g|   v֤      $   vendor/ramsey/collection/SECURITY.md  g        1   vendor/ramsey/collection/src/DoubleEndedQueue.php  g  e      ,   vendor/ramsey/collection/src/AbstractSet.php  g  <!      /   vendor/ramsey/collection/src/QueueInterface.php  g  *      3   vendor/ramsey/collection/src/AbstractCollection.phpa+  ga+  d?      .   vendor/ramsey/collection/src/AbstractArray.php  g  z P      &   vendor/ramsey/collection/src/Queue.php3  g3  D      $   vendor/ramsey/collection/src/Set.php0  g0  H      :   vendor/ramsey/collection/src/DoubleEndedQueueInterface.php(  g(  6'&      6   vendor/ramsey/collection/src/Map/TypedMapInterface.php2  g2  z      5   vendor/ramsey/collection/src/Map/AbstractTypedMap.phpc  gc  cͤ      1   vendor/ramsey/collection/src/Map/MapInterface.php  g  OA      -   vendor/ramsey/collection/src/Map/TypedMap.php
  g
  >)      8   vendor/ramsey/collection/src/Map/AssociativeArrayMap.php0  g0  PǤ      6   vendor/ramsey/collection/src/Map/NamedParameterMap.php   g   `@Q      0   vendor/ramsey/collection/src/Map/AbstractMap.php  g  I?      -   vendor/ramsey/collection/src/GenericArray.php  g        /   vendor/ramsey/collection/src/ArrayInterface.php'  g'  5a      %   vendor/ramsey/collection/src/Sort.php{  g{  Ȥ      +   vendor/ramsey/collection/src/Collection.php	  g	  0       4   vendor/ramsey/collection/src/CollectionInterface.php$  g$  r      H   vendor/ramsey/collection/src/Exception/UnsupportedOperationException.phpL  gL  ff      ?   vendor/ramsey/collection/src/Exception/OutOfBoundsException.phpw  gw        >   vendor/ramsey/collection/src/Exception/CollectionException.php  g  Ĵ@      C   vendor/ramsey/collection/src/Exception/InvalidArgumentException.phps  gs  ڤ      A   vendor/ramsey/collection/src/Exception/NoSuchElementException.phpD  gD  	Ln      B   vendor/ramsey/collection/src/Exception/InvalidPropertyOrMethod.php  g        F   vendor/ramsey/collection/src/Exception/CollectionMismatchException.phpM  gM  \ć      8   vendor/ramsey/collection/src/Tool/ValueToStringTrait.php	  g	  ;5      /   vendor/ramsey/collection/src/Tool/TypeTrait.phpD  gD  e      9   vendor/ramsey/collection/src/Tool/ValueExtractorTrait.php  g  q          vendor/ramsey/uuid/LICENSE7  g7  T̤         vendor/ramsey/uuid/README.md  g  $          vendor/ramsey/uuid/composer.json  g  VҤ      $   vendor/ramsey/uuid/src/functions.php5  g5  	oj      5   vendor/ramsey/uuid/src/Validator/GenericValidator.php  g  )      7   vendor/ramsey/uuid/src/Validator/ValidatorInterface.php  g  B$o      >   vendor/ramsey/uuid/src/Converter/Time/GenericTimeConverter.php
  g
  .V      ;   vendor/ramsey/uuid/src/Converter/Time/UnixTimeConverter.php	  g	  Q53Τ      :   vendor/ramsey/uuid/src/Converter/Time/PhpTimeConverter.phpg  gg  ;Q
      ?   vendor/ramsey/uuid/src/Converter/Time/DegradedTimeConverter.phpu  gu  ?      @   vendor/ramsey/uuid/src/Converter/Time/BigNumberTimeConverter.phpt  gt  ,      C   vendor/ramsey/uuid/src/Converter/Number/DegradedNumberConverter.php|  g|  7@s&      >   vendor/ramsey/uuid/src/Converter/Number/BigNumberConverter.php0  g0  Ǥ      B   vendor/ramsey/uuid/src/Converter/Number/GenericNumberConverter.php  g  =0N      ;   vendor/ramsey/uuid/src/Converter/TimeConverterInterface.php?  g?  t      =   vendor/ramsey/uuid/src/Converter/NumberConverterInterface.php9  g9  z      5   vendor/ramsey/uuid/src/DeprecatedUuidMethodsTrait.php5  g5  TE      8   vendor/ramsey/uuid/src/Codec/TimestampFirstCombCodec.php#
  g#
  &      1   vendor/ramsey/uuid/src/Codec/OrderedTimeCodec.php
  g
  7|o      /   vendor/ramsey/uuid/src/Codec/CodecInterface.php/  g/  T|      0   vendor/ramsey/uuid/src/Codec/GuidStringCodec.php   g   @+      ,   vendor/ramsey/uuid/src/Codec/StringCodec.php  g  Ǟ      7   vendor/ramsey/uuid/src/Codec/TimestampLastCombCodec.php\  g\  l         vendor/ramsey/uuid/src/Uuid.phpd  gd  b      @   vendor/ramsey/uuid/src/Provider/DceSecurityProviderInterface.php  g  }      A   vendor/ramsey/uuid/src/Provider/Dce/SystemDceSecurityProvider.php{  g{  #~٣      9   vendor/ramsey/uuid/src/Provider/NodeProviderInterface.php  g  	"      ;   vendor/ramsey/uuid/src/Provider/Time/SystemTimeProvider.php   g   a      :   vendor/ramsey/uuid/src/Provider/Time/FixedTimeProvider.php  g  SVۤ      9   vendor/ramsey/uuid/src/Provider/TimeProviderInterface.phpS  gS  m+      ;   vendor/ramsey/uuid/src/Provider/Node/RandomNodeProvider.php  g  o>O      =   vendor/ramsey/uuid/src/Provider/Node/FallbackNodeProvider.phpj  gj  u}      ;   vendor/ramsey/uuid/src/Provider/Node/SystemNodeProvider.php  g  p      ?   vendor/ramsey/uuid/src/Provider/Node/NodeProviderCollection.php  g   60      ;   vendor/ramsey/uuid/src/Provider/Node/StaticNodeProvider.php4  g4  L      %   vendor/ramsey/uuid/src/FeatureSet.php 2  g 2  wP      2   vendor/ramsey/uuid/src/Rfc4122/FieldsInterface.phpO  gO  `      )   vendor/ramsey/uuid/src/Rfc4122/UuidV8.php;	  g;	  `$      ,   vendor/ramsey/uuid/src/Rfc4122/Validator.php  g  YB      +   vendor/ramsey/uuid/src/Rfc4122/MaxTrait.php"  g"  Ypg      /   vendor/ramsey/uuid/src/Rfc4122/VersionTrait.php  g  ",      +   vendor/ramsey/uuid/src/Rfc4122/NilTrait.php  g  P      )   vendor/ramsey/uuid/src/Rfc4122/Fields.php  g  28      *   vendor/ramsey/uuid/src/Rfc4122/NilUuid.php[  g[  :      *   vendor/ramsey/uuid/src/Rfc4122/MaxUuid.phpZ  gZ  ;
T      0   vendor/ramsey/uuid/src/Rfc4122/UuidInterface.php  g  )B      ,   vendor/ramsey/uuid/src/Rfc4122/TimeTrait.phpY  gY  V      /   vendor/ramsey/uuid/src/Rfc4122/VariantTrait.phpb
  gb
  f6      .   vendor/ramsey/uuid/src/Rfc4122/UuidBuilder.php@  g@  ̤      )   vendor/ramsey/uuid/src/Rfc4122/UuidV1.php  g  _t      )   vendor/ramsey/uuid/src/Rfc4122/UuidV3.php  g  |O$      )   vendor/ramsey/uuid/src/Rfc4122/UuidV2.php  g  a /      )   vendor/ramsey/uuid/src/Rfc4122/UuidV6.php)  g)  |x{      )   vendor/ramsey/uuid/src/Rfc4122/UuidV7.phpP  gP  &Fo      )   vendor/ramsey/uuid/src/Rfc4122/UuidV5.php  g  s      )   vendor/ramsey/uuid/src/Rfc4122/UuidV4.php  g  %      (   vendor/ramsey/uuid/src/UuidInterface.php:  g:  ƌ      ,   vendor/ramsey/uuid/src/Math/RoundingMode.php  g        3   vendor/ramsey/uuid/src/Math/CalculatorInterface.php  g  ɤ      3   vendor/ramsey/uuid/src/Math/BrickMathCalculator.php  g  u#      /   vendor/ramsey/uuid/src/UuidFactoryInterface.php  g  Gg      9   vendor/ramsey/uuid/src/Generator/RandomBytesGenerator.phpX  gX  5*5      9   vendor/ramsey/uuid/src/Generator/NameGeneratorFactory.php  g  -Z5      6   vendor/ramsey/uuid/src/Generator/UnixTimeGenerator.phpD  gD  ׺Z      ;   vendor/ramsey/uuid/src/Generator/NameGeneratorInterface.phpG  gG  Lդ      ;   vendor/ramsey/uuid/src/Generator/RandomGeneratorFactory.php  g        9   vendor/ramsey/uuid/src/Generator/DceSecurityGenerator.php  g  +>      B   vendor/ramsey/uuid/src/Generator/DceSecurityGeneratorInterface.php  g        9   vendor/ramsey/uuid/src/Generator/TimeGeneratorFactory.php{  g{  k      9   vendor/ramsey/uuid/src/Generator/DefaultNameGenerator.php  g  g$5      9   vendor/ramsey/uuid/src/Generator/DefaultTimeGenerator.php  g  0      5   vendor/ramsey/uuid/src/Generator/RandomLibAdapter.php?  g?  hi^      ;   vendor/ramsey/uuid/src/Generator/TimeGeneratorInterface.php  g  >1      2   vendor/ramsey/uuid/src/Generator/CombGenerator.php  g  MO      =   vendor/ramsey/uuid/src/Generator/RandomGeneratorInterface.php  g  >59
      <   vendor/ramsey/uuid/src/Generator/PeclUuidRandomGenerator.php3  g3  r䍤      :   vendor/ramsey/uuid/src/Generator/PeclUuidNameGenerator.php  g  +qZ      :   vendor/ramsey/uuid/src/Generator/PeclUuidTimeGenerator.phpu  gu   H9      &   vendor/ramsey/uuid/src/BinaryUtils.php  g  /      &   vendor/ramsey/uuid/src/UuidFactory.php=  g=        '   vendor/ramsey/uuid/src/Type/Integer.php  g  ޤ      $   vendor/ramsey/uuid/src/Type/Time.php
  g
  mlU      +   vendor/ramsey/uuid/src/Type/Hexadecimal.php
  g
  q

      /   vendor/ramsey/uuid/src/Type/NumberInterface.php  g  L      -   vendor/ramsey/uuid/src/Type/TypeInterface.php  g  w*      '   vendor/ramsey/uuid/src/Type/Decimal.php  g  |Lf      $   vendor/ramsey/uuid/src/Guid/Guid.php&	  g&	  rR      &   vendor/ramsey/uuid/src/Guid/Fields.php'  g'  ُq      +   vendor/ramsey/uuid/src/Guid/GuidBuilder.php  g  '      2   vendor/ramsey/uuid/src/Lazy/LazyUuidFromString.phpB  gB  G      '   vendor/ramsey/uuid/src/DegradedUuid.phpD  gD        1   vendor/ramsey/uuid/src/Fields/FieldsInterface.php  g  m5h      9   vendor/ramsey/uuid/src/Fields/SerializableFieldsTrait.php  g  s"      2   vendor/ramsey/uuid/src/DeprecatedUuidInterface.phpJ  gJ  
¤      6   vendor/ramsey/uuid/src/Builder/DegradedUuidBuilder.phpu  gu  2      7   vendor/ramsey/uuid/src/Builder/UuidBuilderInterface.php;  g;  -3      4   vendor/ramsey/uuid/src/Builder/BuilderCollection.php
  g
  %;      2   vendor/ramsey/uuid/src/Builder/FallbackBuilder.php  g  S/Y      5   vendor/ramsey/uuid/src/Builder/DefaultUuidBuilder.phpT  gT  Vy      :   vendor/ramsey/uuid/src/Exception/RandomSourceException.php  g  ^E      2   vendor/ramsey/uuid/src/Exception/NodeException.php`  g`  ]      6   vendor/ramsey/uuid/src/Exception/DateTimeException.phpa  ga  \      8   vendor/ramsey/uuid/src/Exception/TimeSourceException.phpQ  gQ        B   vendor/ramsey/uuid/src/Exception/UnsupportedOperationException.phpV  gV  JN      :   vendor/ramsey/uuid/src/Exception/InvalidBytesException.php_  g_  /٤      9   vendor/ramsey/uuid/src/Exception/DceSecurityException.phpp  gp  
      2   vendor/ramsey/uuid/src/Exception/NameException.phpf  gf  v fY      =   vendor/ramsey/uuid/src/Exception/InvalidArgumentException.phpi  gi  v'ä      =   vendor/ramsey/uuid/src/Exception/BuilderNotFoundException.phpQ  gQ  @c      ?   vendor/ramsey/uuid/src/Exception/UnableToBuildUuidException.phpO  gO  Ro      ;   vendor/ramsey/uuid/src/Exception/UuidExceptionInterface.php  g  K;Ҥ      ?   vendor/ramsey/uuid/src/Exception/InvalidUuidStringException.php  g  KI      -   vendor/ramsey/uuid/src/Nonstandard/Fields.php
  g
  a      +   vendor/ramsey/uuid/src/Nonstandard/Uuid.php  g  s      2   vendor/ramsey/uuid/src/Nonstandard/UuidBuilder.php  g  N      -   vendor/ramsey/uuid/src/Nonstandard/UuidV6.phpT
  gT
  qѤ         vendor/webmozart/assert/LICENSE<  g<  t}      $   vendor/webmozart/assert/CHANGELOG.md  g        !   vendor/webmozart/assert/README.md>  g>  |Ϥ      %   vendor/webmozart/assert/composer.json  g  3p      %   vendor/webmozart/assert/src/Mixin.php5 g5 9(      8   vendor/webmozart/assert/src/InvalidArgumentException.phpi  gi  {Lä      &   vendor/webmozart/assert/src/Assert.php  g  =         vendor/react/promise/LICENSEg  gg  F      !   vendor/react/promise/CHANGELOG.md9  g9  OT:         vendor/react/promise/README.mdQY  gQY  1      "   vendor/react/promise/composer.json  g  NjB      -   vendor/react/promise/src/PromiseInterface.php  g  MFx8      &   vendor/react/promise/src/functions.php1-  g1-  t      .   vendor/react/promise/src/functions_include.php   g   dx\      $   vendor/react/promise/src/Promise.php(  g(  s;6      %   vendor/react/promise/src/Deferred.php0  g0        5   vendor/react/promise/src/Internal/RejectedPromise.php
  g
  |      6   vendor/react/promise/src/Internal/FulfilledPromise.php3	  g3	  *      7   vendor/react/promise/src/Internal/CancellationQueue.php  g  r2      6   vendor/react/promise/src/Exception/LengthException.php^   g^   ?q      9   vendor/react/promise/src/Exception/CompositeException.phpa  ga  '      <?php

namespace HumbugBox3150\KevinGH\RequirementChecker;

require __DIR__ . '/../vendor/autoload.php';
if (\false === \in_array(\PHP_SAPI, array('cli', 'phpdbg', 'embed'), \true)) {
    echo \PHP_EOL . 'The application may only be invoked from a command line, got "' . \PHP_SAPI . '"' . \PHP_EOL;
    exit(1);
}
if ((\false === isset($_SERVER['BOX_REQUIREMENT_CHECKER']) || \true === (bool) $_SERVER['BOX_REQUIREMENT_CHECKER']) && \false === Checker::checkRequirements()) {
    exit(1);
}
<?php

return array (
  0 => 
  array (
    'type' => 'php',
    'condition' => '^8.1',
    'message' => 'The application requires the version "^8.1" or greater.',
    'helpMessage' => 'The application requires the version "^8.1" or greater.',
  ),
  1 => 
  array (
    'type' => 'extension',
    'condition' => 'json',
    'message' => 'The application requires the extension "json". Enable it or install a polyfill.',
    'helpMessage' => 'The application requires the extension "json".',
  ),
  2 => 
  array (
    'type' => 'extension',
    'condition' => 'json',
    'message' => 'The package "ramsey/uuid" requires the extension "json". Enable it or install a polyfill.',
    'helpMessage' => 'The package "ramsey/uuid" requires the extension "json".',
  ),
  3 => 
  array (
    'type' => 'extension',
    'condition' => 'json',
    'message' => 'The package "web-auth/cose-lib" requires the extension "json". Enable it or install a polyfill.',
    'helpMessage' => 'The package "web-auth/cose-lib" requires the extension "json".',
  ),
  4 => 
  array (
    'type' => 'extension',
    'condition' => 'json',
    'message' => 'The package "web-auth/webauthn-lib" requires the extension "json". Enable it or install a polyfill.',
    'helpMessage' => 'The package "web-auth/webauthn-lib" requires the extension "json".',
  ),
  5 => 
  array (
    'type' => 'extension',
    'condition' => 'session',
    'message' => 'The application requires the extension "session". Enable it or install a polyfill.',
    'helpMessage' => 'The application requires the extension "session".',
  ),
  6 => 
  array (
    'type' => 'extension',
    'condition' => 'zip',
    'message' => 'The application requires the extension "zip". Enable it or install a polyfill.',
    'helpMessage' => 'The application requires the extension "zip".',
  ),
  7 => 
  array (
    'type' => 'extension',
    'condition' => 'openssl',
    'message' => 'The package "composer/ca-bundle" requires the extension "openssl". Enable it or install a polyfill.',
    'helpMessage' => 'The package "composer/ca-bundle" requires the extension "openssl".',
  ),
  8 => 
  array (
    'type' => 'extension',
    'condition' => 'openssl',
    'message' => 'The package "web-auth/cose-lib" requires the extension "openssl". Enable it or install a polyfill.',
    'helpMessage' => 'The package "web-auth/cose-lib" requires the extension "openssl".',
  ),
  9 => 
  array (
    'type' => 'extension',
    'condition' => 'openssl',
    'message' => 'The package "web-auth/webauthn-lib" requires the extension "openssl". Enable it or install a polyfill.',
    'helpMessage' => 'The package "web-auth/webauthn-lib" requires the extension "openssl".',
  ),
  10 => 
  array (
    'type' => 'extension',
    'condition' => 'pcre',
    'message' => 'The package "composer/ca-bundle" requires the extension "pcre". Enable it or install a polyfill.',
    'helpMessage' => 'The package "composer/ca-bundle" requires the extension "pcre".',
  ),
  11 => 
  array (
    'type' => 'extension',
    'condition' => 'filter',
    'message' => 'The package "phpdocumentor/reflection-docblock" requires the extension "filter". Enable it or install a polyfill.',
    'helpMessage' => 'The package "phpdocumentor/reflection-docblock" requires the extension "filter".',
  ),
  12 => 
  array (
    'type' => 'extension',
    'condition' => 'xml',
    'message' => 'The package "symfony/framework-bundle" requires the extension "xml". Enable it or install a polyfill.',
    'helpMessage' => 'The package "symfony/framework-bundle" requires the extension "xml".',
  ),
  13 => 
  array (
    'type' => 'extension',
    'condition' => 'xml',
    'message' => 'The package "symfony/security-bundle" requires the extension "xml". Enable it or install a polyfill.',
    'helpMessage' => 'The package "symfony/security-bundle" requires the extension "xml".',
  ),
);<?php

// autoload.php @generated by Composer

require_once __DIR__ . '/composer/autoload_real.php';

return ComposerAutoloaderInit7b1918d23e69dc64db20ca1f98396893::getLoader();
<?php

// autoload_namespaces.php @generated by Composer

$vendorDir = dirname(dirname(__FILE__));
$baseDir = dirname($vendorDir);

return array(
);

Copyright (c) Nils Adermann, Jordi Boggiano

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is furnished
to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all
copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.

<?php

/*
 * This file is part of Composer.
 *
 * (c) Nils Adermann <naderman@naderman.de>
 *     Jordi Boggiano <j.boggiano@seld.be>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace Composer\Autoload;

/**
 * ClassLoader implements a PSR-0, PSR-4 and classmap class loader.
 *
 *     $loader = new \Composer\Autoload\ClassLoader();
 *
 *     // register classes with namespaces
 *     $loader->add('Symfony\Component', __DIR__.'/component');
 *     $loader->add('Symfony',           __DIR__.'/framework');
 *
 *     // activate the autoloader
 *     $loader->register();
 *
 *     // to enable searching the include path (eg. for PEAR packages)
 *     $loader->setUseIncludePath(true);
 *
 * In this example, if you try to use a class in the Symfony\Component
 * namespace or one of its children (Symfony\Component\Console for instance),
 * the autoloader will first look for the class under the component/
 * directory, and it will then fallback to the framework/ directory if not
 * found before giving up.
 *
 * This class is loosely based on the Symfony UniversalClassLoader.
 *
 * @author Fabien Potencier <fabien@symfony.com>
 * @author Jordi Boggiano <j.boggiano@seld.be>
 * @see    https://www.php-fig.org/psr/psr-0/
 * @see    https://www.php-fig.org/psr/psr-4/
 */
class ClassLoader
{
    /** @var ?string */
    private $vendorDir;

    // PSR-4
    /**
     * @var array[]
     * @psalm-var array<string, array<string, int>>
     */
    private $prefixLengthsPsr4 = array();
    /**
     * @var array[]
     * @psalm-var array<string, array<int, string>>
     */
    private $prefixDirsPsr4 = array();
    /**
     * @var array[]
     * @psalm-var array<string, string>
     */
    private $fallbackDirsPsr4 = array();

    // PSR-0
    /**
     * @var array[]
     * @psalm-var array<string, array<string, string[]>>
     */
    private $prefixesPsr0 = array();
    /**
     * @var array[]
     * @psalm-var array<string, string>
     */
    private $fallbackDirsPsr0 = array();

    /** @var bool */
    private $useIncludePath = false;

    /**
     * @var string[]
     * @psalm-var array<string, string>
     */
    private $classMap = array();

    /** @var bool */
    private $classMapAuthoritative = false;

    /**
     * @var bool[]
     * @psalm-var array<string, bool>
     */
    private $missingClasses = array();

    /** @var ?string */
    private $apcuPrefix;

    /**
     * @var self[]
     */
    private static $registeredLoaders = array();

    /**
     * @param ?string $vendorDir
     */
    public function __construct($vendorDir = null)
    {
        $this->vendorDir = $vendorDir;
    }

    /**
     * @return string[]
     */
    public function getPrefixes()
    {
        if (!empty($this->prefixesPsr0)) {
            return call_user_func_array('array_merge', array_values($this->prefixesPsr0));
        }

        return array();
    }

    /**
     * @return array[]
     * @psalm-return array<string, array<int, string>>
     */
    public function getPrefixesPsr4()
    {
        return $this->prefixDirsPsr4;
    }

    /**
     * @return array[]
     * @psalm-return array<string, string>
     */
    public function getFallbackDirs()
    {
        return $this->fallbackDirsPsr0;
    }

    /**
     * @return array[]
     * @psalm-return array<string, string>
     */
    public function getFallbackDirsPsr4()
    {
        return $this->fallbackDirsPsr4;
    }

    /**
     * @return string[] Array of classname => path
     * @psalm-return array<string, string>
     */
    public function getClassMap()
    {
        return $this->classMap;
    }

    /**
     * @param string[] $classMap Class to filename map
     * @psalm-param array<string, string> $classMap
     *
     * @return void
     */
    public function addClassMap(array $classMap)
    {
        if ($this->classMap) {
            $this->classMap = array_merge($this->classMap, $classMap);
        } else {
            $this->classMap = $classMap;
        }
    }

    /**
     * Registers a set of PSR-0 directories for a given prefix, either
     * appending or prepending to the ones previously set for this prefix.
     *
     * @param string          $prefix  The prefix
     * @param string[]|string $paths   The PSR-0 root directories
     * @param bool            $prepend Whether to prepend the directories
     *
     * @return void
     */
    public function add($prefix, $paths, $prepend = false)
    {
        if (!$prefix) {
            if ($prepend) {
                $this->fallbackDirsPsr0 = array_merge(
                    (array) $paths,
                    $this->fallbackDirsPsr0
                );
            } else {
                $this->fallbackDirsPsr0 = array_merge(
                    $this->fallbackDirsPsr0,
                    (array) $paths
                );
            }

            return;
        }

        $first = $prefix[0];
        if (!isset($this->prefixesPsr0[$first][$prefix])) {
            $this->prefixesPsr0[$first][$prefix] = (array) $paths;

            return;
        }
        if ($prepend) {
            $this->prefixesPsr0[$first][$prefix] = array_merge(
                (array) $paths,
                $this->prefixesPsr0[$first][$prefix]
            );
        } else {
            $this->prefixesPsr0[$first][$prefix] = array_merge(
                $this->prefixesPsr0[$first][$prefix],
                (array) $paths
            );
        }
    }

    /**
     * Registers a set of PSR-4 directories for a given namespace, either
     * appending or prepending to the ones previously set for this namespace.
     *
     * @param string          $prefix  The prefix/namespace, with trailing '\\'
     * @param string[]|string $paths   The PSR-4 base directories
     * @param bool            $prepend Whether to prepend the directories
     *
     * @throws \InvalidArgumentException
     *
     * @return void
     */
    public function addPsr4($prefix, $paths, $prepend = false)
    {
        if (!$prefix) {
            // Register directories for the root namespace.
            if ($prepend) {
                $this->fallbackDirsPsr4 = array_merge(
                    (array) $paths,
                    $this->fallbackDirsPsr4
                );
            } else {
                $this->fallbackDirsPsr4 = array_merge(
                    $this->fallbackDirsPsr4,
                    (array) $paths
                );
            }
        } elseif (!isset($this->prefixDirsPsr4[$prefix])) {
            // Register directories for a new namespace.
            $length = strlen($prefix);
            if ('\\' !== $prefix[$length - 1]) {
                throw new \InvalidArgumentException("A non-empty PSR-4 prefix must end with a namespace separator.");
            }
            $this->prefixLengthsPsr4[$prefix[0]][$prefix] = $length;
            $this->prefixDirsPsr4[$prefix] = (array) $paths;
        } elseif ($prepend) {
            // Prepend directories for an already registered namespace.
            $this->prefixDirsPsr4[$prefix] = array_merge(
                (array) $paths,
                $this->prefixDirsPsr4[$prefix]
            );
        } else {
            // Append directories for an already registered namespace.
            $this->prefixDirsPsr4[$prefix] = array_merge(
                $this->prefixDirsPsr4[$prefix],
                (array) $paths
            );
        }
    }

    /**
     * Registers a set of PSR-0 directories for a given prefix,
     * replacing any others previously set for this prefix.
     *
     * @param string          $prefix The prefix
     * @param string[]|string $paths  The PSR-0 base directories
     *
     * @return void
     */
    public function set($prefix, $paths)
    {
        if (!$prefix) {
            $this->fallbackDirsPsr0 = (array) $paths;
        } else {
            $this->prefixesPsr0[$prefix[0]][$prefix] = (array) $paths;
        }
    }

    /**
     * Registers a set of PSR-4 directories for a given namespace,
     * replacing any others previously set for this namespace.
     *
     * @param string          $prefix The prefix/namespace, with trailing '\\'
     * @param string[]|string $paths  The PSR-4 base directories
     *
     * @throws \InvalidArgumentException
     *
     * @return void
     */
    public function setPsr4($prefix, $paths)
    {
        if (!$prefix) {
            $this->fallbackDirsPsr4 = (array) $paths;
        } else {
            $length = strlen($prefix);
            if ('\\' !== $prefix[$length - 1]) {
                throw new \InvalidArgumentException("A non-empty PSR-4 prefix must end with a namespace separator.");
            }
            $this->prefixLengthsPsr4[$prefix[0]][$prefix] = $length;
            $this->prefixDirsPsr4[$prefix] = (array) $paths;
        }
    }

    /**
     * Turns on searching the include path for class files.
     *
     * @param bool $useIncludePath
     *
     * @return void
     */
    public function setUseIncludePath($useIncludePath)
    {
        $this->useIncludePath = $useIncludePath;
    }

    /**
     * Can be used to check if the autoloader uses the include path to check
     * for classes.
     *
     * @return bool
     */
    public function getUseIncludePath()
    {
        return $this->useIncludePath;
    }

    /**
     * Turns off searching the prefix and fallback directories for classes
     * that have not been registered with the class map.
     *
     * @param bool $classMapAuthoritative
     *
     * @return void
     */
    public function setClassMapAuthoritative($classMapAuthoritative)
    {
        $this->classMapAuthoritative = $classMapAuthoritative;
    }

    /**
     * Should class lookup fail if not found in the current class map?
     *
     * @return bool
     */
    public function isClassMapAuthoritative()
    {
        return $this->classMapAuthoritative;
    }

    /**
     * APCu prefix to use to cache found/not-found classes, if the extension is enabled.
     *
     * @param string|null $apcuPrefix
     *
     * @return void
     */
    public function setApcuPrefix($apcuPrefix)
    {
        $this->apcuPrefix = function_exists('apcu_fetch') && filter_var(ini_get('apc.enabled'), FILTER_VALIDATE_BOOLEAN) ? $apcuPrefix : null;
    }

    /**
     * The APCu prefix in use, or null if APCu caching is not enabled.
     *
     * @return string|null
     */
    public function getApcuPrefix()
    {
        return $this->apcuPrefix;
    }

    /**
     * Registers this instance as an autoloader.
     *
     * @param bool $prepend Whether to prepend the autoloader or not
     *
     * @return void
     */
    public function register($prepend = false)
    {
        spl_autoload_register(array($this, 'loadClass'), true, $prepend);

        if (null === $this->vendorDir) {
            return;
        }

        if ($prepend) {
            self::$registeredLoaders = array($this->vendorDir => $this) + self::$registeredLoaders;
        } else {
            unset(self::$registeredLoaders[$this->vendorDir]);
            self::$registeredLoaders[$this->vendorDir] = $this;
        }
    }

    /**
     * Unregisters this instance as an autoloader.
     *
     * @return void
     */
    public function unregister()
    {
        spl_autoload_unregister(array($this, 'loadClass'));

        if (null !== $this->vendorDir) {
            unset(self::$registeredLoaders[$this->vendorDir]);
        }
    }

    /**
     * Loads the given class or interface.
     *
     * @param  string    $class The name of the class
     * @return true|null True if loaded, null otherwise
     */
    public function loadClass($class)
    {
        if ($file = $this->findFile($class)) {
            includeFile($file);

            return true;
        }

        return null;
    }

    /**
     * Finds the path to the file where the class is defined.
     *
     * @param string $class The name of the class
     *
     * @return string|false The path if found, false otherwise
     */
    public function findFile($class)
    {
        // class map lookup
        if (isset($this->classMap[$class])) {
            return $this->classMap[$class];
        }
        if ($this->classMapAuthoritative || isset($this->missingClasses[$class])) {
            return false;
        }
        if (null !== $this->apcuPrefix) {
            $file = apcu_fetch($this->apcuPrefix.$class, $hit);
            if ($hit) {
                return $file;
            }
        }

        $file = $this->findFileWithExtension($class, '.php');

        // Search for Hack files if we are running on HHVM
        if (false === $file && defined('HHVM_VERSION')) {
            $file = $this->findFileWithExtension($class, '.hh');
        }

        if (null !== $this->apcuPrefix) {
            apcu_add($this->apcuPrefix.$class, $file);
        }

        if (false === $file) {
            // Remember that this class does not exist.
            $this->missingClasses[$class] = true;
        }

        return $file;
    }

    /**
     * Returns the currently registered loaders indexed by their corresponding vendor directories.
     *
     * @return self[]
     */
    public static function getRegisteredLoaders()
    {
        return self::$registeredLoaders;
    }

    /**
     * @param  string       $class
     * @param  string       $ext
     * @return string|false
     */
    private function findFileWithExtension($class, $ext)
    {
        // PSR-4 lookup
        $logicalPathPsr4 = strtr($class, '\\', DIRECTORY_SEPARATOR) . $ext;

        $first = $class[0];
        if (isset($this->prefixLengthsPsr4[$first])) {
            $subPath = $class;
            while (false !== $lastPos = strrpos($subPath, '\\')) {
                $subPath = substr($subPath, 0, $lastPos);
                $search = $subPath . '\\';
                if (isset($this->prefixDirsPsr4[$search])) {
                    $pathEnd = DIRECTORY_SEPARATOR . substr($logicalPathPsr4, $lastPos + 1);
                    foreach ($this->prefixDirsPsr4[$search] as $dir) {
                        if (file_exists($file = $dir . $pathEnd)) {
                            return $file;
                        }
                    }
                }
            }
        }

        // PSR-4 fallback dirs
        foreach ($this->fallbackDirsPsr4 as $dir) {
            if (file_exists($file = $dir . DIRECTORY_SEPARATOR . $logicalPathPsr4)) {
                return $file;
            }
        }

        // PSR-0 lookup
        if (false !== $pos = strrpos($class, '\\')) {
            // namespaced class name
            $logicalPathPsr0 = substr($logicalPathPsr4, 0, $pos + 1)
                . strtr(substr($logicalPathPsr4, $pos + 1), '_', DIRECTORY_SEPARATOR);
        } else {
            // PEAR-like class name
            $logicalPathPsr0 = strtr($class, '_', DIRECTORY_SEPARATOR) . $ext;
        }

        if (isset($this->prefixesPsr0[$first])) {
            foreach ($this->prefixesPsr0[$first] as $prefix => $dirs) {
                if (0 === strpos($class, $prefix)) {
                    foreach ($dirs as $dir) {
                        if (file_exists($file = $dir . DIRECTORY_SEPARATOR . $logicalPathPsr0)) {
                            return $file;
                        }
                    }
                }
            }
        }

        // PSR-0 fallback dirs
        foreach ($this->fallbackDirsPsr0 as $dir) {
            if (file_exists($file = $dir . DIRECTORY_SEPARATOR . $logicalPathPsr0)) {
                return $file;
            }
        }

        // PSR-0 include paths.
        if ($this->useIncludePath && $file = stream_resolve_include_path($logicalPathPsr0)) {
            return $file;
        }

        return false;
    }
}

/**
 * Scope isolated include.
 *
 * Prevents access to $this/self from included files.
 *
 * @param  string $file
 * @return void
 * @private
 */
function includeFile($file)
{
    include $file;
}
<?php

// autoload_psr4.php @generated by Composer

$vendorDir = dirname(dirname(__FILE__));
$baseDir = dirname($vendorDir);

return array(
    'HumbugBox3150\\KevinGH\\RequirementChecker\\' => array($baseDir . '/src'),
    'HumbugBox3150\\Composer\\Semver\\' => array($vendorDir . '/composer/semver/src'),
);
<?php

// autoload_classmap.php @generated by Composer

$vendorDir = dirname(dirname(__FILE__));
$baseDir = dirname($vendorDir);

return array(
    'Composer\\InstalledVersions' => $vendorDir . '/composer/InstalledVersions.php',
    'HumbugBox3150\\Composer\\Semver\\Comparator' => $vendorDir . '/composer/semver/src/Comparator.php',
    'HumbugBox3150\\Composer\\Semver\\CompilingMatcher' => $vendorDir . '/composer/semver/src/CompilingMatcher.php',
    'HumbugBox3150\\Composer\\Semver\\Constraint\\Bound' => $vendorDir . '/composer/semver/src/Constraint/Bound.php',
    'HumbugBox3150\\Composer\\Semver\\Constraint\\Constraint' => $vendorDir . '/composer/semver/src/Constraint/Constraint.php',
    'HumbugBox3150\\Composer\\Semver\\Constraint\\ConstraintInterface' => $vendorDir . '/composer/semver/src/Constraint/ConstraintInterface.php',
    'HumbugBox3150\\Composer\\Semver\\Constraint\\MatchAllConstraint' => $vendorDir . '/composer/semver/src/Constraint/MatchAllConstraint.php',
    'HumbugBox3150\\Composer\\Semver\\Constraint\\MatchNoneConstraint' => $vendorDir . '/composer/semver/src/Constraint/MatchNoneConstraint.php',
    'HumbugBox3150\\Composer\\Semver\\Constraint\\MultiConstraint' => $vendorDir . '/composer/semver/src/Constraint/MultiConstraint.php',
    'HumbugBox3150\\Composer\\Semver\\Interval' => $vendorDir . '/composer/semver/src/Interval.php',
    'HumbugBox3150\\Composer\\Semver\\Intervals' => $vendorDir . '/composer/semver/src/Intervals.php',
    'HumbugBox3150\\Composer\\Semver\\Semver' => $vendorDir . '/composer/semver/src/Semver.php',
    'HumbugBox3150\\Composer\\Semver\\VersionParser' => $vendorDir . '/composer/semver/src/VersionParser.php',
    'HumbugBox3150\\KevinGH\\RequirementChecker\\Checker' => $baseDir . '/src/Checker.php',
    'HumbugBox3150\\KevinGH\\RequirementChecker\\IO' => $baseDir . '/src/IO.php',
    'HumbugBox3150\\KevinGH\\RequirementChecker\\IsExtensionFulfilled' => $baseDir . '/src/IsExtensionFulfilled.php',
    'HumbugBox3150\\KevinGH\\RequirementChecker\\IsFulfilled' => $baseDir . '/src/IsFulfilled.php',
    'HumbugBox3150\\KevinGH\\RequirementChecker\\IsPhpVersionFulfilled' => $baseDir . '/src/IsPhpVersionFulfilled.php',
    'HumbugBox3150\\KevinGH\\RequirementChecker\\Printer' => $baseDir . '/src/Printer.php',
    'HumbugBox3150\\KevinGH\\RequirementChecker\\Requirement' => $baseDir . '/src/Requirement.php',
    'HumbugBox3150\\KevinGH\\RequirementChecker\\RequirementCollection' => $baseDir . '/src/RequirementCollection.php',
    'HumbugBox3150\\KevinGH\\RequirementChecker\\Terminal' => $baseDir . '/src/Terminal.php',
);
<?php

// autoload_static.php @generated by Composer

namespace Composer\Autoload;

class ComposerStaticInit7b1918d23e69dc64db20ca1f98396893
{
    public static $prefixLengthsPsr4 = array (
        'H' => 
        array (
            'HumbugBox3150\\KevinGH\\RequirementChecker\\' => 41,
            'HumbugBox3150\\Composer\\Semver\\' => 30,
        ),
    );

    public static $prefixDirsPsr4 = array (
        'HumbugBox3150\\KevinGH\\RequirementChecker\\' => 
        array (
            0 => __DIR__ . '/../..' . '/src',
        ),
        'HumbugBox3150\\Composer\\Semver\\' => 
        array (
            0 => __DIR__ . '/..' . '/composer/semver/src',
        ),
    );

    public static $classMap = array (
        'Composer\\InstalledVersions' => __DIR__ . '/..' . '/composer/InstalledVersions.php',
        'HumbugBox3150\\Composer\\Semver\\Comparator' => __DIR__ . '/..' . '/composer/semver/src/Comparator.php',
        'HumbugBox3150\\Composer\\Semver\\CompilingMatcher' => __DIR__ . '/..' . '/composer/semver/src/CompilingMatcher.php',
        'HumbugBox3150\\Composer\\Semver\\Constraint\\Bound' => __DIR__ . '/..' . '/composer/semver/src/Constraint/Bound.php',
        'HumbugBox3150\\Composer\\Semver\\Constraint\\Constraint' => __DIR__ . '/..' . '/composer/semver/src/Constraint/Constraint.php',
        'HumbugBox3150\\Composer\\Semver\\Constraint\\ConstraintInterface' => __DIR__ . '/..' . '/composer/semver/src/Constraint/ConstraintInterface.php',
        'HumbugBox3150\\Composer\\Semver\\Constraint\\MatchAllConstraint' => __DIR__ . '/..' . '/composer/semver/src/Constraint/MatchAllConstraint.php',
        'HumbugBox3150\\Composer\\Semver\\Constraint\\MatchNoneConstraint' => __DIR__ . '/..' . '/composer/semver/src/Constraint/MatchNoneConstraint.php',
        'HumbugBox3150\\Composer\\Semver\\Constraint\\MultiConstraint' => __DIR__ . '/..' . '/composer/semver/src/Constraint/MultiConstraint.php',
        'HumbugBox3150\\Composer\\Semver\\Interval' => __DIR__ . '/..' . '/composer/semver/src/Interval.php',
        'HumbugBox3150\\Composer\\Semver\\Intervals' => __DIR__ . '/..' . '/composer/semver/src/Intervals.php',
        'HumbugBox3150\\Composer\\Semver\\Semver' => __DIR__ . '/..' . '/composer/semver/src/Semver.php',
        'HumbugBox3150\\Composer\\Semver\\VersionParser' => __DIR__ . '/..' . '/composer/semver/src/VersionParser.php',
        'HumbugBox3150\\KevinGH\\RequirementChecker\\Checker' => __DIR__ . '/../..' . '/src/Checker.php',
        'HumbugBox3150\\KevinGH\\RequirementChecker\\IO' => __DIR__ . '/../..' . '/src/IO.php',
        'HumbugBox3150\\KevinGH\\RequirementChecker\\IsExtensionFulfilled' => __DIR__ . '/../..' . '/src/IsExtensionFulfilled.php',
        'HumbugBox3150\\KevinGH\\RequirementChecker\\IsFulfilled' => __DIR__ . '/../..' . '/src/IsFulfilled.php',
        'HumbugBox3150\\KevinGH\\RequirementChecker\\IsPhpVersionFulfilled' => __DIR__ . '/../..' . '/src/IsPhpVersionFulfilled.php',
        'HumbugBox3150\\KevinGH\\RequirementChecker\\Printer' => __DIR__ . '/../..' . '/src/Printer.php',
        'HumbugBox3150\\KevinGH\\RequirementChecker\\Requirement' => __DIR__ . '/../..' . '/src/Requirement.php',
        'HumbugBox3150\\KevinGH\\RequirementChecker\\RequirementCollection' => __DIR__ . '/../..' . '/src/RequirementCollection.php',
        'HumbugBox3150\\KevinGH\\RequirementChecker\\Terminal' => __DIR__ . '/../..' . '/src/Terminal.php',
    );

    public static function getInitializer(ClassLoader $loader)
    {
        return \Closure::bind(function () use ($loader) {
            $loader->prefixLengthsPsr4 = ComposerStaticInit7b1918d23e69dc64db20ca1f98396893::$prefixLengthsPsr4;
            $loader->prefixDirsPsr4 = ComposerStaticInit7b1918d23e69dc64db20ca1f98396893::$prefixDirsPsr4;
            $loader->classMap = ComposerStaticInit7b1918d23e69dc64db20ca1f98396893::$classMap;

        }, null, ClassLoader::class);
    }
}
<?php

// autoload_real.php @generated by Composer

class ComposerAutoloaderInit7b1918d23e69dc64db20ca1f98396893
{
    private static $loader;

    public static function loadClassLoader($class)
    {
        if ('Composer\Autoload\ClassLoader' === $class) {
            require __DIR__ . '/ClassLoader.php';
        }
    }

    /**
     * @return \Composer\Autoload\ClassLoader
     */
    public static function getLoader()
    {
        if (null !== self::$loader) {
            return self::$loader;
        }

        spl_autoload_register(array('ComposerAutoloaderInit7b1918d23e69dc64db20ca1f98396893', 'loadClassLoader'), true, true);
        self::$loader = $loader = new \Composer\Autoload\ClassLoader(\dirname(\dirname(__FILE__)));
        spl_autoload_unregister(array('ComposerAutoloaderInit7b1918d23e69dc64db20ca1f98396893', 'loadClassLoader'));

        $useStaticLoader = PHP_VERSION_ID >= 50600 && !defined('HHVM_VERSION') && (!function_exists('zend_loader_file_encoded') || !zend_loader_file_encoded());
        if ($useStaticLoader) {
            require __DIR__ . '/autoload_static.php';

            call_user_func(\Composer\Autoload\ComposerStaticInit7b1918d23e69dc64db20ca1f98396893::getInitializer($loader));
        } else {
            $classMap = require __DIR__ . '/autoload_classmap.php';
            if ($classMap) {
                $loader->addClassMap($classMap);
            }
        }

        $loader->setClassMapAuthoritative(true);
        $loader->register(true);

        return $loader;
    }
}
<?php

namespace HumbugBox3150\Composer\Semver;

use HumbugBox3150\Composer\Semver\Constraint\Constraint;
class Comparator
{
    public static function greaterThan($version1, $version2)
    {
        return self::compare($version1, '>', $version2);
    }
    public static function greaterThanOrEqualTo($version1, $version2)
    {
        return self::compare($version1, '>=', $version2);
    }
    public static function lessThan($version1, $version2)
    {
        return self::compare($version1, '<', $version2);
    }
    public static function lessThanOrEqualTo($version1, $version2)
    {
        return self::compare($version1, '<=', $version2);
    }
    public static function equalTo($version1, $version2)
    {
        return self::compare($version1, '==', $version2);
    }
    public static function notEqualTo($version1, $version2)
    {
        return self::compare($version1, '!=', $version2);
    }
    public static function compare($version1, $operator, $version2)
    {
        $constraint = new Constraint($operator, $version2);
        return $constraint->matchSpecific(new Constraint('==', $version1), \true);
    }
}
<?php

namespace HumbugBox3150\Composer\Semver;

use HumbugBox3150\Composer\Semver\Constraint\Constraint;
class Semver
{
    const SORT_ASC = 1;
    const SORT_DESC = -1;
    private static $versionParser;
    public static function satisfies($version, $constraints)
    {
        if (null === self::$versionParser) {
            self::$versionParser = new VersionParser();
        }
        $versionParser = self::$versionParser;
        $provider = new Constraint('==', $versionParser->normalize($version));
        $parsedConstraints = $versionParser->parseConstraints($constraints);
        return $parsedConstraints->matches($provider);
    }
    public static function satisfiedBy(array $versions, $constraints)
    {
        $versions = \array_filter($versions, function ($version) use($constraints) {
            return Semver::satisfies($version, $constraints);
        });
        return \array_values($versions);
    }
    public static function sort(array $versions)
    {
        return self::usort($versions, self::SORT_ASC);
    }
    public static function rsort(array $versions)
    {
        return self::usort($versions, self::SORT_DESC);
    }
    private static function usort(array $versions, $direction)
    {
        if (null === self::$versionParser) {
            self::$versionParser = new VersionParser();
        }
        $versionParser = self::$versionParser;
        $normalized = array();
        foreach ($versions as $key => $version) {
            $normalizedVersion = $versionParser->normalize($version);
            $normalizedVersion = $versionParser->normalizeDefaultBranch($normalizedVersion);
            $normalized[] = array($normalizedVersion, $key);
        }
        \usort($normalized, function (array $left, array $right) use($direction) {
            if ($left[0] === $right[0]) {
                return 0;
            }
            if (Comparator::lessThan($left[0], $right[0])) {
                return -$direction;
            }
            return $direction;
        });
        $sorted = array();
        foreach ($normalized as $item) {
            $sorted[] = $versions[$item[1]];
        }
        return $sorted;
    }
}
<?php

namespace HumbugBox3150\Composer\Semver;

use HumbugBox3150\Composer\Semver\Constraint\ConstraintInterface;
use HumbugBox3150\Composer\Semver\Constraint\MatchAllConstraint;
use HumbugBox3150\Composer\Semver\Constraint\MultiConstraint;
use HumbugBox3150\Composer\Semver\Constraint\Constraint;
class VersionParser
{
    private static $modifierRegex = '[._-]?(?:(stable|beta|b|RC|alpha|a|patch|pl|p)((?:[.-]?\\d+)*+)?)?([.-]?dev)?';
    private static $stabilitiesRegex = 'stable|RC|beta|alpha|dev';
    public static function parseStability($version)
    {
        $version = \preg_replace('{#.+$}i', '', $version);
        if (\strpos($version, 'dev-') === 0 || '-dev' === \substr($version, -4)) {
            return 'dev';
        }
        \preg_match('{' . self::$modifierRegex . '(?:\\+.*)?$}i', \strtolower($version), $match);
        if (!empty($match[3])) {
            return 'dev';
        }
        if (!empty($match[1])) {
            if ('beta' === $match[1] || 'b' === $match[1]) {
                return 'beta';
            }
            if ('alpha' === $match[1] || 'a' === $match[1]) {
                return 'alpha';
            }
            if ('rc' === $match[1]) {
                return 'RC';
            }
        }
        return 'stable';
    }
    public static function normalizeStability($stability)
    {
        $stability = \strtolower($stability);
        return $stability === 'rc' ? 'RC' : $stability;
    }
    public function normalize($version, $fullVersion = null)
    {
        $version = \trim($version);
        $origVersion = $version;
        if (null === $fullVersion) {
            $fullVersion = $version;
        }
        if (\preg_match('{^([^,\\s]++) ++as ++([^,\\s]++)$}', $version, $match)) {
            $version = $match[1];
        }
        if (\preg_match('{@(?:' . self::$stabilitiesRegex . ')$}i', $version, $match)) {
            $version = \substr($version, 0, \strlen($version) - \strlen($match[0]));
        }
        if (\in_array($version, array('master', 'trunk', 'default'), \true)) {
            $version = 'dev-' . $version;
        }
        if (\stripos($version, 'dev-') === 0) {
            return 'dev-' . \substr($version, 4);
        }
        if (\preg_match('{^([^,\\s+]++)\\+[^\\s]++$}', $version, $match)) {
            $version = $match[1];
        }
        if (\preg_match('{^v?(\\d{1,5})(\\.\\d++)?(\\.\\d++)?(\\.\\d++)?' . self::$modifierRegex . '$}i', $version, $matches)) {
            $version = $matches[1] . (!empty($matches[2]) ? $matches[2] : '.0') . (!empty($matches[3]) ? $matches[3] : '.0') . (!empty($matches[4]) ? $matches[4] : '.0');
            $index = 5;
        } elseif (\preg_match('{^v?(\\d{4}(?:[.:-]?\\d{2}){1,6}(?:[.:-]?\\d{1,3})?)' . self::$modifierRegex . '$}i', $version, $matches)) {
            $version = \preg_replace('{\\D}', '.', $matches[1]);
            $index = 2;
        }
        if (isset($index)) {
            if (!empty($matches[$index])) {
                if ('stable' === $matches[$index]) {
                    return $version;
                }
                $version .= '-' . $this->expandStability($matches[$index]) . (!empty($matches[$index + 1]) ? \ltrim($matches[$index + 1], '.-') : '');
            }
            if (!empty($matches[$index + 2])) {
                $version .= '-dev';
            }
            return $version;
        }
        if (\preg_match('{(.*?)[.-]?dev$}i', $version, $match)) {
            try {
                $normalized = $this->normalizeBranch($match[1]);
                if (\strpos($normalized, 'dev-') === \false) {
                    return $normalized;
                }
            } catch (\Exception $e) {
            }
        }
        $extraMessage = '';
        if (\preg_match('{ +as +' . \preg_quote($version) . '(?:@(?:' . self::$stabilitiesRegex . '))?$}', $fullVersion)) {
            $extraMessage = ' in "' . $fullVersion . '", the alias must be an exact version';
        } elseif (\preg_match('{^' . \preg_quote($version) . '(?:@(?:' . self::$stabilitiesRegex . '))? +as +}', $fullVersion)) {
            $extraMessage = ' in "' . $fullVersion . '", the alias source must be an exact version, if it is a branch name you should prefix it with dev-';
        }
        throw new \UnexpectedValueException('Invalid version string "' . $origVersion . '"' . $extraMessage);
    }
    public function parseNumericAliasPrefix($branch)
    {
        if (\preg_match('{^(?P<version>(\\d++\\.)*\\d++)(?:\\.x)?-dev$}i', $branch, $matches)) {
            return $matches['version'] . '.';
        }
        return \false;
    }
    public function normalizeBranch($name)
    {
        $name = \trim($name);
        if (\preg_match('{^v?(\\d++)(\\.(?:\\d++|[xX*]))?(\\.(?:\\d++|[xX*]))?(\\.(?:\\d++|[xX*]))?$}i', $name, $matches)) {
            $version = '';
            for ($i = 1; $i < 5; ++$i) {
                $version .= isset($matches[$i]) ? \str_replace(array('*', 'X'), 'x', $matches[$i]) : '.x';
            }
            return \str_replace('x', '9999999', $version) . '-dev';
        }
        return 'dev-' . $name;
    }
    public function normalizeDefaultBranch($name)
    {
        if ($name === 'dev-master' || $name === 'dev-default' || $name === 'dev-trunk') {
            return '9999999-dev';
        }
        return $name;
    }
    public function parseConstraints($constraints)
    {
        $prettyConstraint = $constraints;
        $orConstraints = \preg_split('{\\s*\\|\\|?\\s*}', \trim($constraints));
        $orGroups = array();
        foreach ($orConstraints as $constraints) {
            $andConstraints = \preg_split('{(?<!^|as|[=>< ,]) *(?<!-)[, ](?!-) *(?!,|as|$)}', $constraints);
            if (\count($andConstraints) > 1) {
                $constraintObjects = array();
                foreach ($andConstraints as $constraint) {
                    foreach ($this->parseConstraint($constraint) as $parsedConstraint) {
                        $constraintObjects[] = $parsedConstraint;
                    }
                }
            } else {
                $constraintObjects = $this->parseConstraint($andConstraints[0]);
            }
            if (1 === \count($constraintObjects)) {
                $constraint = $constraintObjects[0];
            } else {
                $constraint = new MultiConstraint($constraintObjects);
            }
            $orGroups[] = $constraint;
        }
        $constraint = MultiConstraint::create($orGroups, \false);
        $constraint->setPrettyString($prettyConstraint);
        return $constraint;
    }
    private function parseConstraint($constraint)
    {
        if (\preg_match('{^([^,\\s]++) ++as ++([^,\\s]++)$}', $constraint, $match)) {
            $constraint = $match[1];
        }
        if (\preg_match('{^([^,\\s]*?)@(' . self::$stabilitiesRegex . ')$}i', $constraint, $match)) {
            $constraint = '' !== $match[1] ? $match[1] : '*';
            if ($match[2] !== 'stable') {
                $stabilityModifier = $match[2];
            }
        }
        if (\preg_match('{^(dev-[^,\\s@]+?|[^,\\s@]+?\\.x-dev)#.+$}i', $constraint, $match)) {
            $constraint = $match[1];
        }
        if (\preg_match('{^(v)?[xX*](\\.[xX*])*$}i', $constraint, $match)) {
            if (!empty($match[1]) || !empty($match[2])) {
                return array(new Constraint('>=', '0.0.0.0-dev'));
            }
            return array(new MatchAllConstraint());
        }
        $versionRegex = 'v?(\\d++)(?:\\.(\\d++|[xX*]))?(?:\\.(\\d++|[xX*]))?(?:\\.(\\d++|[xX*]))?' . self::$modifierRegex . '(?:\\+[^\\s]+)?';
        if (\preg_match('{^~>?' . $versionRegex . '$}i', $constraint, $matches)) {
            if (\strpos($constraint, '~>') === 0) {
                throw new \UnexpectedValueException('Could not parse version constraint ' . $constraint . ': ' . 'Invalid operator "~>", you probably meant to use the "~" operator');
            }
            if (isset($matches[4]) && '' !== $matches[4] && null !== $matches[4]) {
                $position = 4;
            } elseif (isset($matches[3]) && '' !== $matches[3] && null !== $matches[3]) {
                $position = 3;
            } elseif (isset($matches[2]) && '' !== $matches[2] && null !== $matches[2]) {
                $position = 2;
            } else {
                $position = 1;
            }
            for ($i = $position; $i >= 0; $i--) {
                if ($matches[$i] === 'x' || $matches[$i] === 'X' || $matches[$i] === '*') {
                    $matches[$i] = '9999999';
                }
            }
            $stabilitySuffix = '';
            if (empty($matches[5]) && empty($matches[7])) {
                $stabilitySuffix .= '-dev';
            }
            $lowVersion = $this->normalize(\substr($constraint . $stabilitySuffix, 1));
            $lowerBound = new Constraint('>=', $lowVersion);
            $highPosition = \max(1, $position - 1);
            $highVersion = $this->manipulateVersionString($matches, $highPosition, 1) . '-dev';
            $upperBound = new Constraint('<', $highVersion);
            return array($lowerBound, $upperBound);
        }
        if (\preg_match('{^\\^' . $versionRegex . '($)}i', $constraint, $matches)) {
            if ('0' !== $matches[1] || '' === $matches[2] || null === $matches[2]) {
                $position = 1;
            } elseif ('0' !== $matches[2] || '' === $matches[3] || null === $matches[3]) {
                $position = 2;
            } else {
                $position = 3;
            }
            if ($position === 2 && ($matches[2] === 'x' || $matches[2] === 'X' || $matches[2] === '*')) {
                $position = 1;
            }
            $stabilitySuffix = '';
            if (empty($matches[5]) && empty($matches[7])) {
                $stabilitySuffix .= '-dev';
            }
            $lowVersion = $this->normalize(\substr($constraint . $stabilitySuffix, 1));
            $lowerBound = new Constraint('>=', $lowVersion);
            $highVersion = $this->manipulateVersionString($matches, $position, 1) . '-dev';
            $upperBound = new Constraint('<', $highVersion);
            return array($lowerBound, $upperBound);
        }
        if (\preg_match('{^v?(\\d++)(?:\\.(\\d++))?(?:\\.(\\d++))?(?:\\.[xX*])++$}', $constraint, $matches)) {
            if (isset($matches[3]) && '' !== $matches[3] && null !== $matches[3]) {
                $position = 3;
            } elseif (isset($matches[2]) && '' !== $matches[2] && null !== $matches[2]) {
                $position = 2;
            } else {
                $position = 1;
            }
            $lowVersion = $this->manipulateVersionString($matches, $position) . '-dev';
            $highVersion = $this->manipulateVersionString($matches, $position, 1) . '-dev';
            if ($lowVersion === '0.0.0.0-dev') {
                return array(new Constraint('<', $highVersion));
            }
            return array(new Constraint('>=', $lowVersion), new Constraint('<', $highVersion));
        }
        if (\preg_match('{^(?P<from>' . $versionRegex . ') +- +(?P<to>' . $versionRegex . ')($)}i', $constraint, $matches)) {
            $lowStabilitySuffix = '';
            if (empty($matches[6]) && empty($matches[8])) {
                $lowStabilitySuffix = '-dev';
            }
            $lowVersion = $this->normalize($matches['from']);
            $lowerBound = new Constraint('>=', $lowVersion . $lowStabilitySuffix);
            $empty = function ($x) {
                return $x === 0 || $x === '0' ? \false : empty($x);
            };
            if (!$empty($matches[11]) && !$empty($matches[12]) || !empty($matches[14]) || !empty($matches[16])) {
                $highVersion = $this->normalize($matches['to']);
                $upperBound = new Constraint('<=', $highVersion);
            } else {
                $highMatch = array('', $matches[10], $matches[11], $matches[12], $matches[13]);
                $this->normalize($matches['to']);
                $highVersion = $this->manipulateVersionString($highMatch, $empty($matches[11]) ? 1 : 2, 1) . '-dev';
                $upperBound = new Constraint('<', $highVersion);
            }
            return array($lowerBound, $upperBound);
        }
        if (\preg_match('{^(<>|!=|>=?|<=?|==?)?\\s*(.*)}', $constraint, $matches)) {
            try {
                try {
                    $version = $this->normalize($matches[2]);
                } catch (\UnexpectedValueException $e) {
                    if (\substr($matches[2], -4) === '-dev') {
                        $version = $this->normalize('dev-' . \substr($matches[2], 0, -4));
                    } else {
                        throw $e;
                    }
                }
                $op = $matches[1] ?: '=';
                if ($op !== '==' && $op !== '=' && !empty($stabilityModifier) && self::parseStability($version) === 'stable') {
                    $version .= '-' . $stabilityModifier;
                } elseif ('<' === $op || '>=' === $op) {
                    if (!\preg_match('/-' . self::$modifierRegex . '$/', \strtolower($matches[2]))) {
                        if (\strpos($matches[2], 'dev-') !== 0) {
                            $version .= '-dev';
                        }
                    }
                }
                return array(new Constraint($matches[1] ?: '=', $version));
            } catch (\Exception $e) {
            }
        }
        $message = 'Could not parse version constraint ' . $constraint;
        if (isset($e)) {
            $message .= ': ' . $e->getMessage();
        }
        throw new \UnexpectedValueException($message);
    }
    private function manipulateVersionString($matches, $position, $increment = 0, $pad = '0')
    {
        for ($i = 4; $i > 0; --$i) {
            if ($i > $position) {
                $matches[$i] = $pad;
            } elseif ($i === $position && $increment) {
                $matches[$i] += $increment;
                if ($matches[$i] < 0) {
                    $matches[$i] = $pad;
                    --$position;
                    if ($i === 1) {
                        return null;
                    }
                }
            }
        }
        return $matches[1] . '.' . $matches[2] . '.' . $matches[3] . '.' . $matches[4];
    }
    private function expandStability($stability)
    {
        $stability = \strtolower($stability);
        switch ($stability) {
            case 'a':
                return 'alpha';
            case 'b':
                return 'beta';
            case 'p':
            case 'pl':
                return 'patch';
            case 'rc':
                return 'RC';
            default:
                return $stability;
        }
    }
}
<?php

namespace HumbugBox3150\Composer\Semver\Constraint;

interface ConstraintInterface
{
    public function matches(ConstraintInterface $provider);
    public function compile($operator);
    public function getUpperBound();
    public function getLowerBound();
    public function getPrettyString();
    public function setPrettyString($prettyString);
    public function __toString();
}
<?php

namespace HumbugBox3150\Composer\Semver\Constraint;

class MultiConstraint implements ConstraintInterface
{
    protected $constraints;
    protected $prettyString;
    protected $string;
    protected $conjunctive;
    protected $lowerBound;
    protected $upperBound;
    public function __construct(array $constraints, $conjunctive = \true)
    {
        if (\count($constraints) < 2) {
            throw new \InvalidArgumentException('Must provide at least two constraints for a MultiConstraint. Use ' . 'the regular Constraint class for one constraint only or MatchAllConstraint for none. You may use ' . 'MultiConstraint::create() which optimizes and handles those cases automatically.');
        }
        $this->constraints = $constraints;
        $this->conjunctive = $conjunctive;
    }
    public function getConstraints()
    {
        return $this->constraints;
    }
    public function isConjunctive()
    {
        return $this->conjunctive;
    }
    public function isDisjunctive()
    {
        return !$this->conjunctive;
    }
    public function compile($otherOperator)
    {
        $parts = array();
        foreach ($this->constraints as $constraint) {
            $code = $constraint->compile($otherOperator);
            if ($code === 'true') {
                if (!$this->conjunctive) {
                    return 'true';
                }
            } elseif ($code === 'false') {
                if ($this->conjunctive) {
                    return 'false';
                }
            } else {
                $parts[] = '(' . $code . ')';
            }
        }
        if (!$parts) {
            return $this->conjunctive ? 'true' : 'false';
        }
        return $this->conjunctive ? \implode('&&', $parts) : \implode('||', $parts);
    }
    public function matches(ConstraintInterface $provider)
    {
        if (\false === $this->conjunctive) {
            foreach ($this->constraints as $constraint) {
                if ($provider->matches($constraint)) {
                    return \true;
                }
            }
            return \false;
        }
        foreach ($this->constraints as $constraint) {
            if (!$provider->matches($constraint)) {
                return \false;
            }
        }
        return \true;
    }
    public function setPrettyString($prettyString)
    {
        $this->prettyString = $prettyString;
    }
    public function getPrettyString()
    {
        if ($this->prettyString) {
            return $this->prettyString;
        }
        return (string) $this;
    }
    public function __toString()
    {
        if ($this->string !== null) {
            return $this->string;
        }
        $constraints = array();
        foreach ($this->constraints as $constraint) {
            $constraints[] = (string) $constraint;
        }
        return $this->string = '[' . \implode($this->conjunctive ? ' ' : ' || ', $constraints) . ']';
    }
    public function getLowerBound()
    {
        $this->extractBounds();
        return $this->lowerBound;
    }
    public function getUpperBound()
    {
        $this->extractBounds();
        return $this->upperBound;
    }
    public static function create(array $constraints, $conjunctive = \true)
    {
        if (0 === \count($constraints)) {
            return new MatchAllConstraint();
        }
        if (1 === \count($constraints)) {
            return $constraints[0];
        }
        $optimized = self::optimizeConstraints($constraints, $conjunctive);
        if ($optimized !== null) {
            list($constraints, $conjunctive) = $optimized;
            if (\count($constraints) === 1) {
                return $constraints[0];
            }
        }
        return new self($constraints, $conjunctive);
    }
    private static function optimizeConstraints(array $constraints, $conjunctive)
    {
        if (!$conjunctive) {
            $left = $constraints[0];
            $mergedConstraints = array();
            $optimized = \false;
            for ($i = 1, $l = \count($constraints); $i < $l; $i++) {
                $right = $constraints[$i];
                if ($left instanceof MultiConstraint && $left->conjunctive && $right instanceof MultiConstraint && $right->conjunctive && ($left0 = (string) $left->constraints[0]) && $left0[0] === '>' && $left0[1] === '=' && ($left1 = (string) $left->constraints[1]) && $left1[0] === '<' && ($right0 = (string) $right->constraints[0]) && $right0[0] === '>' && $right0[1] === '=' && ($right1 = (string) $right->constraints[1]) && $right1[0] === '<' && \substr($left1, 2) === \substr($right0, 3)) {
                    $optimized = \true;
                    $left = new MultiConstraint(\array_merge(array($left->constraints[0], $right->constraints[1]), \array_slice($left->constraints, 2), \array_slice($right->constraints, 2)), \true);
                } else {
                    $mergedConstraints[] = $left;
                    $left = $right;
                }
            }
            if ($optimized) {
                $mergedConstraints[] = $left;
                return array($mergedConstraints, \false);
            }
        }
        return null;
    }
    private function extractBounds()
    {
        if (null !== $this->lowerBound) {
            return;
        }
        foreach ($this->constraints as $constraint) {
            if (null === $this->lowerBound && null === $this->upperBound) {
                $this->lowerBound = $constraint->getLowerBound();
                $this->upperBound = $constraint->getUpperBound();
                continue;
            }
            if ($constraint->getLowerBound()->compareTo($this->lowerBound, $this->isConjunctive() ? '>' : '<')) {
                $this->lowerBound = $constraint->getLowerBound();
            }
            if ($constraint->getUpperBound()->compareTo($this->upperBound, $this->isConjunctive() ? '<' : '>')) {
                $this->upperBound = $constraint->getUpperBound();
            }
        }
    }
}
<?php

namespace HumbugBox3150\Composer\Semver\Constraint;

class Constraint implements ConstraintInterface
{
    const OP_EQ = 0;
    const OP_LT = 1;
    const OP_LE = 2;
    const OP_GT = 3;
    const OP_GE = 4;
    const OP_NE = 5;
    /**
    @phpstan-var
    */
    private static $transOpStr = array('=' => self::OP_EQ, '==' => self::OP_EQ, '<' => self::OP_LT, '<=' => self::OP_LE, '>' => self::OP_GT, '>=' => self::OP_GE, '<>' => self::OP_NE, '!=' => self::OP_NE);
    /**
    @phpstan-var
    */
    private static $transOpInt = array(self::OP_EQ => '==', self::OP_LT => '<', self::OP_LE => '<=', self::OP_GT => '>', self::OP_GE => '>=', self::OP_NE => '!=');
    /**
    @phpstan-var
    */
    protected $operator;
    protected $version;
    protected $prettyString;
    protected $lowerBound;
    protected $upperBound;
    public function __construct($operator, $version)
    {
        if (!isset(self::$transOpStr[$operator])) {
            throw new \InvalidArgumentException(\sprintf('Invalid operator "%s" given, expected one of: %s', $operator, \implode(', ', self::getSupportedOperators())));
        }
        $this->operator = self::$transOpStr[$operator];
        $this->version = $version;
    }
    public function getVersion()
    {
        return $this->version;
    }
    public function getOperator()
    {
        return self::$transOpInt[$this->operator];
    }
    public function matches(ConstraintInterface $provider)
    {
        if ($provider instanceof self) {
            return $this->matchSpecific($provider);
        }
        return $provider->matches($this);
    }
    public function setPrettyString($prettyString)
    {
        $this->prettyString = $prettyString;
    }
    public function getPrettyString()
    {
        if ($this->prettyString) {
            return $this->prettyString;
        }
        return $this->__toString();
    }
    public static function getSupportedOperators()
    {
        return \array_keys(self::$transOpStr);
    }
    /**
    @phpstan-return
    */
    public static function getOperatorConstant($operator)
    {
        return self::$transOpStr[$operator];
    }
    public function versionCompare($a, $b, $operator, $compareBranches = \false)
    {
        if (!isset(self::$transOpStr[$operator])) {
            throw new \InvalidArgumentException(\sprintf('Invalid operator "%s" given, expected one of: %s', $operator, \implode(', ', self::getSupportedOperators())));
        }
        $aIsBranch = 'dev-' === \substr($a, 0, 4);
        $bIsBranch = 'dev-' === \substr($b, 0, 4);
        if ($operator === '!=' && ($aIsBranch || $bIsBranch)) {
            return $a !== $b;
        }
        if ($aIsBranch && $bIsBranch) {
            return $operator === '==' && $a === $b;
        }
        if (!$compareBranches && ($aIsBranch || $bIsBranch)) {
            return \false;
        }
        return \version_compare($a, $b, $operator);
    }
    public function compile($otherOperator)
    {
        if ($this->version[0] === 'd' && 'dev-' === \substr($this->version, 0, 4)) {
            if (self::OP_EQ === $this->operator) {
                if (self::OP_EQ === $otherOperator) {
                    return \sprintf('$b && $v === %s', \var_export($this->version, \true));
                }
                if (self::OP_NE === $otherOperator) {
                    return \sprintf('!$b || $v !== %s', \var_export($this->version, \true));
                }
                return 'false';
            }
            if (self::OP_NE === $this->operator) {
                if (self::OP_EQ === $otherOperator) {
                    return \sprintf('!$b || $v !== %s', \var_export($this->version, \true));
                }
                if (self::OP_NE === $otherOperator) {
                    return 'true';
                }
                return '!$b';
            }
            return 'false';
        }
        if (self::OP_EQ === $this->operator) {
            if (self::OP_EQ === $otherOperator) {
                return \sprintf('\\version_compare($v, %s, \'==\')', \var_export($this->version, \true));
            }
            if (self::OP_NE === $otherOperator) {
                return \sprintf('$b || \\version_compare($v, %s, \'!=\')', \var_export($this->version, \true));
            }
            return \sprintf('!$b && \\version_compare(%s, $v, \'%s\')', \var_export($this->version, \true), self::$transOpInt[$otherOperator]);
        }
        if (self::OP_NE === $this->operator) {
            if (self::OP_EQ === $otherOperator) {
                return \sprintf('$b || (!$b && \\version_compare($v, %s, \'!=\'))', \var_export($this->version, \true));
            }
            if (self::OP_NE === $otherOperator) {
                return 'true';
            }
            return '!$b';
        }
        if (self::OP_LT === $this->operator || self::OP_LE === $this->operator) {
            if (self::OP_LT === $otherOperator || self::OP_LE === $otherOperator) {
                return '!$b';
            }
        } elseif (self::OP_GT === $this->operator || self::OP_GE === $this->operator) {
            if (self::OP_GT === $otherOperator || self::OP_GE === $otherOperator) {
                return '!$b';
            }
        }
        if (self::OP_NE === $otherOperator) {
            return 'true';
        }
        $codeComparison = \sprintf('\\version_compare($v, %s, \'%s\')', \var_export($this->version, \true), self::$transOpInt[$this->operator]);
        if ($this->operator === self::OP_LE) {
            if ($otherOperator === self::OP_GT) {
                return \sprintf('!$b && \\version_compare($v, %s, \'!=\') && ', \var_export($this->version, \true)) . $codeComparison;
            }
        } elseif ($this->operator === self::OP_GE) {
            if ($otherOperator === self::OP_LT) {
                return \sprintf('!$b && \\version_compare($v, %s, \'!=\') && ', \var_export($this->version, \true)) . $codeComparison;
            }
        }
        return \sprintf('!$b && %s', $codeComparison);
    }
    public function matchSpecific(Constraint $provider, $compareBranches = \false)
    {
        $noEqualOp = \str_replace('=', '', self::$transOpInt[$this->operator]);
        $providerNoEqualOp = \str_replace('=', '', self::$transOpInt[$provider->operator]);
        $isEqualOp = self::OP_EQ === $this->operator;
        $isNonEqualOp = self::OP_NE === $this->operator;
        $isProviderEqualOp = self::OP_EQ === $provider->operator;
        $isProviderNonEqualOp = self::OP_NE === $provider->operator;
        if ($isNonEqualOp || $isProviderNonEqualOp) {
            if ($isNonEqualOp && !$isProviderNonEqualOp && !$isProviderEqualOp && 'dev-' === \substr($provider->version, 0, 4)) {
                return \false;
            }
            if ($isProviderNonEqualOp && !$isNonEqualOp && !$isEqualOp && 'dev-' === \substr($this->version, 0, 4)) {
                return \false;
            }
            if (!$isEqualOp && !$isProviderEqualOp) {
                return \true;
            }
            return $this->versionCompare($provider->version, $this->version, '!=', $compareBranches);
        }
        if ($this->operator !== self::OP_EQ && $noEqualOp === $providerNoEqualOp) {
            if ('dev-' === \substr($this->version, 0, 4) || 'dev-' === \substr($provider->version, 0, 4)) {
                return \false;
            }
            return \true;
        }
        $version1 = $isEqualOp ? $this->version : $provider->version;
        $version2 = $isEqualOp ? $provider->version : $this->version;
        $operator = $isEqualOp ? $provider->operator : $this->operator;
        if ($this->versionCompare($version1, $version2, self::$transOpInt[$operator], $compareBranches)) {
            return !(self::$transOpInt[$provider->operator] === $providerNoEqualOp && self::$transOpInt[$this->operator] !== $noEqualOp && \version_compare($provider->version, $this->version, '=='));
        }
        return \false;
    }
    public function __toString()
    {
        return self::$transOpInt[$this->operator] . ' ' . $this->version;
    }
    public function getLowerBound()
    {
        $this->extractBounds();
        return $this->lowerBound;
    }
    public function getUpperBound()
    {
        $this->extractBounds();
        return $this->upperBound;
    }
    private function extractBounds()
    {
        if (null !== $this->lowerBound) {
            return;
        }
        if (\strpos($this->version, 'dev-') === 0) {
            $this->lowerBound = Bound::zero();
            $this->upperBound = Bound::positiveInfinity();
            return;
        }
        switch ($this->operator) {
            case self::OP_EQ:
                $this->lowerBound = new Bound($this->version, \true);
                $this->upperBound = new Bound($this->version, \true);
                break;
            case self::OP_LT:
                $this->lowerBound = Bound::zero();
                $this->upperBound = new Bound($this->version, \false);
                break;
            case self::OP_LE:
                $this->lowerBound = Bound::zero();
                $this->upperBound = new Bound($this->version, \true);
                break;
            case self::OP_GT:
                $this->lowerBound = new Bound($this->version, \false);
                $this->upperBound = Bound::positiveInfinity();
                break;
            case self::OP_GE:
                $this->lowerBound = new Bound($this->version, \true);
                $this->upperBound = Bound::positiveInfinity();
                break;
            case self::OP_NE:
                $this->lowerBound = Bound::zero();
                $this->upperBound = Bound::positiveInfinity();
                break;
        }
    }
}
<?php

namespace HumbugBox3150\KevinGH\RequirementChecker;

class Terminal
{
    private static $width;
    private static $height;
    private static $stty;
    public function getWidth()
    {
        $width = \getenv('COLUMNS');
        if (\false !== $width) {
            return (int) \trim($width);
        }
        if (null === self::$width) {
            self::initDimensions();
        }
        return self::$width ?: 80;
    }
    public function getHeight()
    {
        $height = \getenv('LINES');
        if (\false !== $height) {
            return (int) \trim($height);
        }
        if (null === self::$height) {
            self::initDimensions();
        }
        return self::$height ?: 50;
    }
    public static function hasSttyAvailable()
    {
        if (null !== self::$stty) {
            return self::$stty;
        }
        if (!\function_exists('exec')) {
            return \false;
        }
        \exec('stty 2>&1', $output, $exitcode);
        return self::$stty = 0 === $exitcode;
    }
    private static function initDimensions()
    {
        if ('\\' === \DIRECTORY_SEPARATOR) {
            if (\preg_match('/^(\\d+)x(\\d+)(?: \\((\\d+)x(\\d+)\\))?$/', \trim(\getenv('ANSICON')), $matches)) {
                self::$width = (int) $matches[1];
                self::$height = isset($matches[4]) ? (int) $matches[4] : (int) $matches[2];
            } elseif (!self::hasVt100Support() && self::hasSttyAvailable()) {
                self::initDimensionsUsingStty();
            } elseif (null !== ($dimensions = self::getConsoleMode())) {
                self::$width = (int) $dimensions[0];
                self::$height = (int) $dimensions[1];
            }
        } else {
            self::initDimensionsUsingStty();
        }
    }
    private static function hasVt100Support()
    {
        return \function_exists('sapi_windows_vt100_support') && \sapi_windows_vt100_support(\fopen('php://stdout', 'wb'));
    }
    private static function initDimensionsUsingStty()
    {
        if ($sttyString = self::getSttyColumns()) {
            if (\preg_match('/rows.(\\d+);.columns.(\\d+);/i', $sttyString, $matches)) {
                self::$width = (int) $matches[2];
                self::$height = (int) $matches[1];
            } elseif (\preg_match('/;.(\\d+).rows;.(\\d+).columns/i', $sttyString, $matches)) {
                self::$width = (int) $matches[2];
                self::$height = (int) $matches[1];
            }
        }
    }
    private static function getConsoleMode()
    {
        $info = self::readFromProcess('mode CON');
        if (null === $info || !\preg_match('/--------+\\r?\\n.+?(\\d+)\\r?\\n.+?(\\d+)\\r?\\n/', $info, $matches)) {
            return null;
        }
        return array((int) $matches[2], (int) $matches[1]);
    }
    private static function getSttyColumns()
    {
        return self::readFromProcess('stty -a | grep columns');
    }
    private static function readFromProcess($command)
    {
        if (!\function_exists('proc_open')) {
            return null;
        }
        $descriptorspec = array(1 => array('pipe', 'w'), 2 => array('pipe', 'w'));
        $process = \proc_open($command, $descriptorspec, $pipes, null, null, array('suppress_errors' => \true));
        if (!\is_resource($process)) {
            return null;
        }
        $info = \stream_get_contents($pipes[1]);
        \fclose($pipes[1]);
        \fclose($pipes[2]);
        \proc_close($process);
        return $info;
    }
}
<?php

namespace HumbugBox3150\KevinGH\RequirementChecker;

final class IO
{
    const VERBOSITY_QUIET = 16;
    const VERBOSITY_NORMAL = 32;
    const VERBOSITY_VERBOSE = 64;
    const VERBOSITY_VERY_VERBOSE = 128;
    const VERBOSITY_DEBUG = 256;
    private $interactive;
    private $verbosity = self::VERBOSITY_NORMAL;
    private $colorSupport;
    private $options;
    public function __construct()
    {
        $this->options = \implode(' ', $_SERVER['argv']);
        $shellVerbosity = $this->configureVerbosity();
        $this->interactive = $this->checkInteractivity($shellVerbosity);
        $this->colorSupport = $this->checkColorSupport();
    }
    public function isInteractive()
    {
        return $this->interactive;
    }
    public function getVerbosity()
    {
        return $this->verbosity;
    }
    public function hasColorSupport()
    {
        return $this->colorSupport;
    }
    public function hasParameter($values)
    {
        $values = (array) $values;
        foreach ($values as $value) {
            $regexp = \sprintf('/\\s%s\\b/', \str_replace(' ', '\\s+', \preg_quote($value, '/')));
            if (1 === \preg_match($regexp, $this->options)) {
                return \true;
            }
        }
        return \false;
    }
    private function checkInteractivity($shellVerbosity)
    {
        if (-1 === $shellVerbosity) {
            return \false;
        }
        if (\true === $this->hasParameter(array('--no-interaction', '-n'))) {
            return \false;
        }
        if (\function_exists('posix_isatty') && !@\posix_isatty(\STDOUT) && \false === \getenv('SHELL_INTERACTIVE')) {
            return \false;
        }
        return \true;
    }
    private function configureVerbosity()
    {
        switch ($shellVerbosity = (int) \getenv('SHELL_VERBOSITY')) {
            case -1:
                $this->verbosity = self::VERBOSITY_QUIET;
                break;
            case 1:
                $this->verbosity = self::VERBOSITY_VERBOSE;
                break;
            case 2:
                $this->verbosity = self::VERBOSITY_VERY_VERBOSE;
                break;
            case 3:
                $this->verbosity = self::VERBOSITY_DEBUG;
                break;
            default:
                $shellVerbosity = 0;
                break;
        }
        if ($this->hasParameter(array('--quiet', '-q'))) {
            $this->verbosity = self::VERBOSITY_QUIET;
            $shellVerbosity = -1;
        } elseif ($this->hasParameter(array('-vvv', '--verbose=3', '--verbose 3'))) {
            $this->verbosity = self::VERBOSITY_DEBUG;
            $shellVerbosity = 3;
        } elseif ($this->hasParameter(array('-vv', '--verbose=2', '--verbose 2'))) {
            $this->verbosity = self::VERBOSITY_VERY_VERBOSE;
            $shellVerbosity = 2;
        } elseif ($this->hasParameter(array('-v', '--verbose=1', '--verbose 1', '--verbose'))) {
            $this->verbosity = self::VERBOSITY_VERBOSE;
            $shellVerbosity = 1;
        }
        return $shellVerbosity;
    }
    private function checkColorSupport()
    {
        if ($this->hasParameter(array('--ansi'))) {
            return \true;
        }
        if ($this->hasParameter(array('--no-ansi'))) {
            return \false;
        }
        if (\DIRECTORY_SEPARATOR === '\\') {
            return \function_exists('sapi_windows_vt100_support') && \sapi_windows_vt100_support(\STDOUT) || \false !== \getenv('ANSICON') || 'ON' === \getenv('ConEmuANSI') || 'xterm' === \getenv('TERM');
        }
        if (\function_exists('stream_isatty')) {
            return \stream_isatty(\STDOUT);
        }
        if (\function_exists('posix_isatty')) {
            return \posix_isatty(\STDOUT);
        }
        $stat = \fstat(\STDOUT);
        return $stat ? 020000 === ($stat['mode'] & 0170000) : \false;
    }
}
<?php

namespace HumbugBox3150\KevinGH\RequirementChecker;

final class IsExtensionFulfilled implements IsFulfilled
{
    private $requiredExtension;
    public function __construct($requiredExtension)
    {
        $this->requiredExtension = $requiredExtension;
    }
    public function __invoke()
    {
        return \extension_loaded($this->requiredExtension);
    }
}
<?php

namespace HumbugBox3150\KevinGH\RequirementChecker;

final class Checker
{
    private static $requirementsConfig;
    public static function checkRequirements()
    {
        $requirements = self::retrieveRequirements();
        $checkPassed = $requirements->evaluateRequirements();
        $io = new IO();
        self::printCheck($checkPassed, new Printer($io->getVerbosity(), $io->hasColorSupport()), $requirements);
        return $checkPassed;
    }
    public static function printCheck($checkPassed, Printer $printer, RequirementCollection $requirements)
    {
        if (\false === $checkPassed && IO::VERBOSITY_VERY_VERBOSE > $printer->getVerbosity()) {
            $printer->setVerbosity(IO::VERBOSITY_VERY_VERBOSE);
        }
        $verbosity = IO::VERBOSITY_VERY_VERBOSE;
        $iniPath = $requirements->getPhpIniPath();
        $printer->title('Box Requirements Checker', $verbosity);
        $printer->printv('> Using PHP ', $verbosity);
        $printer->printvln(\PHP_VERSION, $verbosity, 'green');
        $printer->printvln('> PHP is using the following php.ini file:', $verbosity);
        if ($iniPath) {
            $printer->printvln('  ' . $iniPath, $verbosity, 'green');
        } else {
            $printer->printvln('  WARNING: No configuration file (php.ini) used by PHP!', $verbosity, 'yellow');
        }
        $printer->printvln('', $verbosity);
        if (\count($requirements) > 0) {
            $printer->printvln('> Checking Box requirements:', $verbosity);
            $printer->printv('  ', $verbosity);
        } else {
            $printer->printvln('> No requirements found.', $verbosity);
        }
        $errorMessages = array();
        foreach ($requirements->getRequirements() as $requirement) {
            if ($errorMessage = $printer->getRequirementErrorMessage($requirement)) {
                if (IO::VERBOSITY_DEBUG === $printer->getVerbosity()) {
                    $printer->printvln('✘ ' . $requirement->getTestMessage(), IO::VERBOSITY_DEBUG, 'red');
                    $printer->printv('  ', IO::VERBOSITY_DEBUG);
                    $errorMessages[] = $errorMessage;
                } else {
                    $printer->printv('E', $verbosity, 'red');
                    $errorMessages[] = $errorMessage;
                }
                continue;
            }
            if (IO::VERBOSITY_DEBUG === $printer->getVerbosity()) {
                $printer->printvln('✔ ' . $requirement->getHelpText(), IO::VERBOSITY_DEBUG, 'green');
                $printer->printv('  ', IO::VERBOSITY_DEBUG);
            } else {
                $printer->printv('.', $verbosity, 'green');
            }
        }
        if (IO::VERBOSITY_DEBUG !== $printer->getVerbosity() && \count($requirements) > 0) {
            $printer->printvln('', $verbosity);
        }
        if ($requirements->evaluateRequirements()) {
            $printer->block('OK', 'Your system is ready to run the application.', $verbosity, 'success');
        } else {
            $printer->block('ERROR', 'Your system is not ready to run the application.', $verbosity, 'error');
            $printer->title('Fix the following mandatory requirements:', $verbosity, 'red');
            foreach ($errorMessages as $errorMessage) {
                $printer->printv(' * ' . $errorMessage, $verbosity);
            }
        }
        $printer->printvln('', $verbosity);
    }
    private static function retrieveRequirements()
    {
        if (null === self::$requirementsConfig) {
            self::$requirementsConfig = __DIR__ . '/../.requirements.php';
        }
        $config = (require self::$requirementsConfig);
        $requirements = new RequirementCollection();
        foreach ($config as $constraint) {
            $requirements->addRequirement('php' === $constraint['type'] ? new IsPhpVersionFulfilled($constraint['condition']) : new IsExtensionFulfilled($constraint['condition']), $constraint['message'], $constraint['helpMessage']);
        }
        return $requirements;
    }
}
<?php

namespace HumbugBox3150\KevinGH\RequirementChecker;

use HumbugBox3150\Composer\Semver\Semver;
final class IsPhpVersionFulfilled implements IsFulfilled
{
    private $requiredPhpVersion;
    public function __construct($requiredPhpVersion)
    {
        $this->requiredPhpVersion = $requiredPhpVersion;
    }
    public function __invoke()
    {
        return Semver::satisfies(\sprintf('%d.%d.%d', \PHP_MAJOR_VERSION, \PHP_MINOR_VERSION, \PHP_RELEASE_VERSION), $this->requiredPhpVersion);
    }
}
<?php

namespace HumbugBox3150\KevinGH\RequirementChecker;

use ArrayIterator;
use Countable;
use IteratorAggregate;
use ReturnTypeWillChange;
use Traversable;
final class RequirementCollection implements IteratorAggregate, Countable
{
    private $requirements = array();
    #[\ReturnTypeWillChange]
    public function getIterator()
    {
        return new ArrayIterator($this->requirements);
    }
    #[\ReturnTypeWillChange]
    public function count()
    {
        return \count($this->requirements);
    }
    public function add(Requirement $requirement)
    {
        $this->requirements[] = $requirement;
    }
    public function addRequirement($checkIsFulfilled, $testMessage, $helpText)
    {
        $this->add(new Requirement($checkIsFulfilled, $testMessage, $helpText));
    }
    public function getRequirements()
    {
        return $this->requirements;
    }
    public function getPhpIniPath()
    {
        return \get_cfg_var('cfg_file_path');
    }
    public function evaluateRequirements()
    {
        return \array_reduce($this->requirements, function ($checkPassed, Requirement $requirement) {
            return $checkPassed && $requirement->isFulfilled();
        }, \true);
    }
}
<?php

namespace HumbugBox3150\KevinGH\RequirementChecker;

final class Printer
{
    private $styles = array('reset' => "\x1b[0m", 'red' => "\x1b[31m", 'green' => "\x1b[32m", 'yellow' => "\x1b[33m", 'title' => "\x1b[33m", 'error' => "\x1b[37;41m", 'success' => "\x1b[30;42m");
    private $verbosity;
    private $supportColors;
    private $width;
    public function __construct($verbosity, $supportColors, $width = null)
    {
        if (null === $width) {
            $terminal = new Terminal();
            $width = $terminal->getWidth();
        }
        $this->verbosity = $verbosity;
        $this->supportColors = $supportColors;
        $this->width = $width ?: 80;
    }
    public function getVerbosity()
    {
        return $this->verbosity;
    }
    public function setVerbosity($verbosity)
    {
        $this->verbosity = $verbosity;
    }
    public function title($title, $verbosity, $style = null)
    {
        if (null === $style) {
            $style = 'title';
        }
        $this->printvln('', $verbosity, $style);
        $this->printvln($title, $verbosity, $style);
        $this->printvln(\str_repeat('=', \min(\strlen($title), $this->width)), $verbosity, $style);
        $this->printvln('', $verbosity, $style);
    }
    public function getRequirementErrorMessage(Requirement $requirement)
    {
        if ($requirement->isFulfilled()) {
            return null;
        }
        $errorMessage = \wordwrap($requirement->getTestMessage(), $this->width - 3, \PHP_EOL . '   ') . \PHP_EOL;
        return $errorMessage;
    }
    public function block($title, $message, $verbosity, $style = null)
    {
        $prefix = ' [' . $title . '] ';
        $lineLength = $this->width - \strlen($prefix) - 1;
        if ($lineLength < 0) {
            $lineLength = 0;
        }
        $message = $prefix . \trim($message);
        $lines = array();
        $remainingMessage = $message;
        $wrapped = \wordwrap($remainingMessage, $lineLength, '¬');
        $wrapped = \explode('¬', $wrapped);
        do {
            $line = \array_shift($wrapped);
            if ($lines && $lineLength > 0) {
                $line = \str_repeat(' ', \strlen($prefix)) . \ltrim($line);
            }
            $lines[] = \str_pad($line, $this->width, ' ', \STR_PAD_RIGHT);
        } while (\count($wrapped));
        $this->printvln('', $verbosity);
        $this->printvln(\str_repeat(' ', $this->width), $verbosity, $style);
        foreach ($lines as $line) {
            $this->printvln($line, $verbosity, $style);
        }
        $this->printv(\str_repeat(' ', $this->width), $verbosity, $style);
        $this->printvln('', $verbosity);
    }
    public function printvln($message, $verbosity, $style = null)
    {
        $this->printv($message, $verbosity, $style);
        $this->printv(\PHP_EOL, $verbosity, null);
    }
    public function printv($message, $verbosity, $style = null)
    {
        if ($verbosity > $this->verbosity) {
            return;
        }
        $message = \wordwrap($message, $this->width);
        $message = \sprintf('%s%s%s', $this->supportColors && isset($this->styles[$style]) ? $this->styles[$style] : '', $message, $this->supportColors ? $this->styles['reset'] : '');
        echo $message;
    }
}
<?php

namespace HumbugBox3150\KevinGH\RequirementChecker;

interface IsFulfilled
{
    public function __invoke();
}
<?php

namespace HumbugBox3150\KevinGH\RequirementChecker;

final class Requirement
{
    private $checkIsFulfilled;
    private $fulfilled;
    private $testMessage;
    private $helpText;
    public function __construct($checkIsFulfilled, $testMessage, $helpText)
    {
        $this->checkIsFulfilled = $checkIsFulfilled;
        $this->testMessage = $testMessage;
        $this->helpText = $helpText;
    }
    public function isFulfilled()
    {
        if (null === $this->fulfilled) {
            $this->fulfilled = $this->checkIsFulfilled->__invoke();
        }
        return (bool) $this->fulfilled;
    }
    public function getIsFullfilledChecker()
    {
        return $this->checkIsFulfilled;
    }
    public function getTestMessage()
    {
        return $this->testMessage;
    }
    public function getHelpText()
    {
        return $this->helpText;
    }
}
                   GNU LESSER GENERAL PUBLIC LICENSE
                       Version 3, 29 June 2007

 Copyright (C) 2007 Free Software Foundation, Inc. <http://fsf.org/>
 Everyone is permitted to copy and distribute verbatim copies
 of this license document, but changing it is not allowed.


  This version of the GNU Lesser General Public License incorporates
the terms and conditions of version 3 of the GNU General Public
License, supplemented by the additional permissions listed below.

  0. Additional Definitions.

  As used herein, "this License" refers to version 3 of the GNU Lesser
General Public License, and the "GNU GPL" refers to version 3 of the GNU
General Public License.

  "The Library" refers to a covered work governed by this License,
other than an Application or a Combined Work as defined below.

  An "Application" is any work that makes use of an interface provided
by the Library, but which is not otherwise based on the Library.
Defining a subclass of a class defined by the Library is deemed a mode
of using an interface provided by the Library.

  A "Combined Work" is a work produced by combining or linking an
Application with the Library.  The particular version of the Library
with which the Combined Work was made is also called the "Linked
Version".

  The "Minimal Corresponding Source" for a Combined Work means the
Corresponding Source for the Combined Work, excluding any source code
for portions of the Combined Work that, considered in isolation, are
based on the Application, and not on the Linked Version.

  The "Corresponding Application Code" for a Combined Work means the
object code and/or source code for the Application, including any data
and utility programs needed for reproducing the Combined Work from the
Application, but excluding the System Libraries of the Combined Work.

  1. Exception to Section 3 of the GNU GPL.

  You may convey a covered work under sections 3 and 4 of this License
without being bound by section 3 of the GNU GPL.

  2. Conveying Modified Versions.

  If you modify a copy of the Library, and, in your modifications, a
facility refers to a function or data to be supplied by an Application
that uses the facility (other than as an argument passed when the
facility is invoked), then you may convey a copy of the modified
version:

   a) under this License, provided that you make a good faith effort to
   ensure that, in the event an Application does not supply the
   function or data, the facility still operates, and performs
   whatever part of its purpose remains meaningful, or

   b) under the GNU GPL, with none of the additional permissions of
   this License applicable to that copy.

  3. Object Code Incorporating Material from Library Header Files.

  The object code form of an Application may incorporate material from
a header file that is part of the Library.  You may convey such object
code under terms of your choice, provided that, if the incorporated
material is not limited to numerical parameters, data structure
layouts and accessors, or small macros, inline functions and templates
(ten or fewer lines in length), you do both of the following:

   a) Give prominent notice with each copy of the object code that the
   Library is used in it and that the Library and its use are
   covered by this License.

   b) Accompany the object code with a copy of the GNU GPL and this license
   document.

  4. Combined Works.

  You may convey a Combined Work under terms of your choice that,
taken together, effectively do not restrict modification of the
portions of the Library contained in the Combined Work and reverse
engineering for debugging such modifications, if you also do each of
the following:

   a) Give prominent notice with each copy of the Combined Work that
   the Library is used in it and that the Library and its use are
   covered by this License.

   b) Accompany the Combined Work with a copy of the GNU GPL and this license
   document.

   c) For a Combined Work that displays copyright notices during
   execution, include the copyright notice for the Library among
   these notices, as well as a reference directing the user to the
   copies of the GNU GPL and this license document.

   d) Do one of the following:

       0) Convey the Minimal Corresponding Source under the terms of this
       License, and the Corresponding Application Code in a form
       suitable for, and under terms that permit, the user to
       recombine or relink the Application with a modified version of
       the Linked Version to produce a modified Combined Work, in the
       manner specified by section 6 of the GNU GPL for conveying
       Corresponding Source.

       1) Use a suitable shared library mechanism for linking with the
       Library.  A suitable mechanism is one that (a) uses at run time
       a copy of the Library already present on the user's computer
       system, and (b) will operate properly with a modified version
       of the Library that is interface-compatible with the Linked
       Version.

   e) Provide Installation Information, but only if you would otherwise
   be required to provide such information under section 6 of the
   GNU GPL, and only to the extent that such information is
   necessary to install and execute a modified version of the
   Combined Work produced by recombining or relinking the
   Application with a modified version of the Linked Version. (If
   you use option 4d0, the Installation Information must accompany
   the Minimal Corresponding Source and Corresponding Application
   Code. If you use option 4d1, you must provide the Installation
   Information in the manner specified by section 6 of the GNU GPL
   for conveying Corresponding Source.)

  5. Combined Libraries.

  You may place library facilities that are a work based on the
Library side by side in a single library together with other library
facilities that are not Applications and are not covered by this
License, and convey such a combined library under terms of your
choice, if you do both of the following:

   a) Accompany the combined library with a copy of the same work based
   on the Library, uncombined with any other library facilities,
   conveyed under the terms of this License.

   b) Give prominent notice with the combined library that part of it
   is a work based on the Library, and explaining where to find the
   accompanying uncombined form of the same work.

  6. Revised Versions of the GNU Lesser General Public License.

  The Free Software Foundation may publish revised and/or new versions
of the GNU Lesser General Public License from time to time. Such new
versions will be similar in spirit to the present version, but may
differ in detail to address new problems or concerns.

  Each version is given a distinguishing version number. If the
Library as you received it specifies that a certain numbered version
of the GNU Lesser General Public License "or any later version"
applies to it, you have the option of following the terms and
conditions either of that published version or of any later version
published by the Free Software Foundation. If the Library as you
received it does not specify a version number of the GNU Lesser
General Public License, you may choose any version of the GNU Lesser
General Public License ever published by the Free Software Foundation.

  If the Library as you received it specifies that a proxy can decide
whether future versions of the GNU Lesser General Public License shall
apply, that proxy's public statement of acceptance of any version is
permanent authorization for you to choose that version for the
Library.
<!doctype html><html lang="en"><head><meta charset="utf-8"><title>Contao Manager</title><meta http-equiv="X-UA-Compatible" content="IE=edge"><meta name="viewport" content="width=device-width,initial-scale=1,maximum-scale=1"/><meta name="description" content=""><meta name="robots" content="noindex,follow"><meta http-equiv="Content-Security-Policy" content="img-src 'self' data: blob: contao.github.io extensions.contao.org; object-src 'none'"/><link rel="icon" type="image/x-icon" href="assets/favicon.ico"><link rel="icon" type="image/png" sizes="16x16" href="assets/favicon-16x16.png"><link rel="icon" type="image/png" sizes="32x32" href="assets/favicon-32x32.png"><link rel="icon" type="image/png" sizes="48x48" href="assets/favicon-48x48.png"><link rel="manifest" href="assets/manifest.webmanifest"><meta name="mobile-web-app-capable" content="yes"><meta name="theme-color" content="#ffffff"><meta name="application-name" content="Contao Manager"><link rel="apple-touch-icon" sizes="57x57" href="assets/apple-touch-icon-57x57.png"><link rel="apple-touch-icon" sizes="60x60" href="assets/apple-touch-icon-60x60.png"><link rel="apple-touch-icon" sizes="72x72" href="assets/apple-touch-icon-72x72.png"><link rel="apple-touch-icon" sizes="76x76" href="assets/apple-touch-icon-76x76.png"><link rel="apple-touch-icon" sizes="114x114" href="assets/apple-touch-icon-114x114.png"><link rel="apple-touch-icon" sizes="120x120" href="assets/apple-touch-icon-120x120.png"><link rel="apple-touch-icon" sizes="144x144" href="assets/apple-touch-icon-144x144.png"><link rel="apple-touch-icon" sizes="152x152" href="assets/apple-touch-icon-152x152.png"><link rel="apple-touch-icon" sizes="167x167" href="assets/apple-touch-icon-167x167.png"><link rel="apple-touch-icon" sizes="180x180" href="assets/apple-touch-icon-180x180.png"><link rel="apple-touch-icon" sizes="1024x1024" href="assets/apple-touch-icon-1024x1024.png"><meta name="apple-mobile-web-app-capable" content="yes"><meta name="apple-mobile-web-app-status-bar-style" content="black-translucent"><meta name="apple-mobile-web-app-title" content="Contao Manager"><link rel="apple-touch-startup-image" media="(device-width: 320px) and (device-height: 568px) and (-webkit-device-pixel-ratio: 2) and (orientation: portrait)" href="assets/apple-touch-startup-image-640x1136.png"><link rel="apple-touch-startup-image" media="(device-width: 320px) and (device-height: 568px) and (-webkit-device-pixel-ratio: 2) and (orientation: landscape)" href="assets/apple-touch-startup-image-1136x640.png"><link rel="apple-touch-startup-image" media="(device-width: 375px) and (device-height: 667px) and (-webkit-device-pixel-ratio: 2) and (orientation: portrait)" href="assets/apple-touch-startup-image-750x1334.png"><link rel="apple-touch-startup-image" media="(device-width: 375px) and (device-height: 667px) and (-webkit-device-pixel-ratio: 2) and (orientation: landscape)" href="assets/apple-touch-startup-image-1334x750.png"><link rel="apple-touch-startup-image" media="(device-width: 375px) and (device-height: 812px) and (-webkit-device-pixel-ratio: 3) and (orientation: portrait)" href="assets/apple-touch-startup-image-1125x2436.png"><link rel="apple-touch-startup-image" media="(device-width: 375px) and (device-height: 812px) and (-webkit-device-pixel-ratio: 3) and (orientation: landscape)" href="assets/apple-touch-startup-image-2436x1125.png"><link rel="apple-touch-startup-image" media="(device-width: 390px) and (device-height: 844px) and (-webkit-device-pixel-ratio: 3) and (orientation: portrait)" href="assets/apple-touch-startup-image-1170x2532.png"><link rel="apple-touch-startup-image" media="(device-width: 390px) and (device-height: 844px) and (-webkit-device-pixel-ratio: 3) and (orientation: landscape)" href="assets/apple-touch-startup-image-2532x1170.png"><link rel="apple-touch-startup-image" media="(device-width: 393px) and (device-height: 852px) and (-webkit-device-pixel-ratio: 3) and (orientation: portrait)" href="assets/apple-touch-startup-image-1179x2556.png"><link rel="apple-touch-startup-image" media="(device-width: 393px) and (device-height: 852px) and (-webkit-device-pixel-ratio: 3) and (orientation: landscape)" href="assets/apple-touch-startup-image-2556x1179.png"><link rel="apple-touch-startup-image" media="(device-width: 414px) and (device-height: 896px) and (-webkit-device-pixel-ratio: 2) and (orientation: portrait)" href="assets/apple-touch-startup-image-828x1792.png"><link rel="apple-touch-startup-image" media="(device-width: 414px) and (device-height: 896px) and (-webkit-device-pixel-ratio: 2) and (orientation: landscape)" href="assets/apple-touch-startup-image-1792x828.png"><link rel="apple-touch-startup-image" media="(device-width: 414px) and (device-height: 896px) and (-webkit-device-pixel-ratio: 3) and (orientation: portrait)" href="assets/apple-touch-startup-image-1242x2688.png"><link rel="apple-touch-startup-image" media="(device-width: 414px) and (device-height: 896px) and (-webkit-device-pixel-ratio: 3) and (orientation: landscape)" href="assets/apple-touch-startup-image-2688x1242.png"><link rel="apple-touch-startup-image" media="(device-width: 414px) and (device-height: 736px) and (-webkit-device-pixel-ratio: 3) and (orientation: portrait)" href="assets/apple-touch-startup-image-1242x2208.png"><link rel="apple-touch-startup-image" media="(device-width: 414px) and (device-height: 736px) and (-webkit-device-pixel-ratio: 3) and (orientation: landscape)" href="assets/apple-touch-startup-image-2208x1242.png"><link rel="apple-touch-startup-image" media="(device-width: 428px) and (device-height: 926px) and (-webkit-device-pixel-ratio: 3) and (orientation: portrait)" href="assets/apple-touch-startup-image-1284x2778.png"><link rel="apple-touch-startup-image" media="(device-width: 428px) and (device-height: 926px) and (-webkit-device-pixel-ratio: 3) and (orientation: landscape)" href="assets/apple-touch-startup-image-2778x1284.png"><link rel="apple-touch-startup-image" media="(device-width: 430px) and (device-height: 932px) and (-webkit-device-pixel-ratio: 3) and (orientation: portrait)" href="assets/apple-touch-startup-image-1290x2796.png"><link rel="apple-touch-startup-image" media="(device-width: 430px) and (device-height: 932px) and (-webkit-device-pixel-ratio: 3) and (orientation: landscape)" href="assets/apple-touch-startup-image-2796x1290.png"><link rel="apple-touch-startup-image" media="(device-width: 744px) and (device-height: 1133px) and (-webkit-device-pixel-ratio: 2) and (orientation: portrait)" href="assets/apple-touch-startup-image-1488x2266.png"><link rel="apple-touch-startup-image" media="(device-width: 744px) and (device-height: 1133px) and (-webkit-device-pixel-ratio: 2) and (orientation: landscape)" href="assets/apple-touch-startup-image-2266x1488.png"><link rel="apple-touch-startup-image" media="(device-width: 768px) and (device-height: 1024px) and (-webkit-device-pixel-ratio: 2) and (orientation: portrait)" href="assets/apple-touch-startup-image-1536x2048.png"><link rel="apple-touch-startup-image" media="(device-width: 768px) and (device-height: 1024px) and (-webkit-device-pixel-ratio: 2) and (orientation: landscape)" href="assets/apple-touch-startup-image-2048x1536.png"><link rel="apple-touch-startup-image" media="(device-width: 810px) and (device-height: 1080px) and (-webkit-device-pixel-ratio: 2) and (orientation: portrait)" href="assets/apple-touch-startup-image-1620x2160.png"><link rel="apple-touch-startup-image" media="(device-width: 810px) and (device-height: 1080px) and (-webkit-device-pixel-ratio: 2) and (orientation: landscape)" href="assets/apple-touch-startup-image-2160x1620.png"><link rel="apple-touch-startup-image" media="(device-width: 820px) and (device-height: 1080px) and (-webkit-device-pixel-ratio: 2) and (orientation: portrait)" href="assets/apple-touch-startup-image-1640x2160.png"><link rel="apple-touch-startup-image" media="(device-width: 820px) and (device-height: 1080px) and (-webkit-device-pixel-ratio: 2) and (orientation: landscape)" href="assets/apple-touch-startup-image-2160x1640.png"><link rel="apple-touch-startup-image" media="(device-width: 834px) and (device-height: 1194px) and (-webkit-device-pixel-ratio: 2) and (orientation: portrait)" href="assets/apple-touch-startup-image-1668x2388.png"><link rel="apple-touch-startup-image" media="(device-width: 834px) and (device-height: 1194px) and (-webkit-device-pixel-ratio: 2) and (orientation: landscape)" href="assets/apple-touch-startup-image-2388x1668.png"><link rel="apple-touch-startup-image" media="(device-width: 834px) and (device-height: 1112px) and (-webkit-device-pixel-ratio: 2) and (orientation: portrait)" href="assets/apple-touch-startup-image-1668x2224.png"><link rel="apple-touch-startup-image" media="(device-width: 834px) and (device-height: 1112px) and (-webkit-device-pixel-ratio: 2) and (orientation: landscape)" href="assets/apple-touch-startup-image-2224x1668.png"><link rel="apple-touch-startup-image" media="(device-width: 1024px) and (device-height: 1366px) and (-webkit-device-pixel-ratio: 2) and (orientation: portrait)" href="assets/apple-touch-startup-image-2048x2732.png"><link rel="apple-touch-startup-image" media="(device-width: 1024px) and (device-height: 1366px) and (-webkit-device-pixel-ratio: 2) and (orientation: landscape)" href="assets/apple-touch-startup-image-2732x2048.png"><meta name="msapplication-TileColor" content="#ffffff"><meta name="msapplication-TileImage" content="assets/mstile-144x144.png"><meta name="msapplication-config" content="assets/browserconfig.xml"><link rel="yandex-tableau-widget" href="assets/yandex-browser-manifest.json"><script defer="defer" src="js/chunk-vendors.f2ea533d.js"></script><script defer="defer" src="js/app.298b3095.js"></script><link href="css/chunk-vendors.f450b373.css" rel="stylesheet"><link href="css/app.36128924.css" rel="stylesheet"></head><body><noscript><strong>We're sorry but the Contao Manager does not work without JavaScript enabled. Please enable it to continue.</strong></noscript></body></html><?php

declare(strict_types=1);

/*
 * This file is part of Contao Manager.
 *
 * (c) Contao Association
 *
 * @license LGPL-3.0-or-later
 */

use Contao\ManagerApi\ApiKernel;
use Contao\ManagerApi\HttpKernel\ApiProblemResponse;
use Symfony\Component\HttpFoundation\Request;

require __DIR__.'/../vendor/autoload.php';

try {
    // @phpstan-ignore identical.alwaysFalse
    $kernel = new ApiKernel('@symfony_env@' === 'prod' ? 'prod' : 'dev');

    $request = Request::createFromGlobals();
    $response = $kernel->handle($request);
    $response->send();
    $kernel->terminate($request, $response);
} catch (Throwable $throwable) {
    ApiProblemResponse::createFromException($throwable, '@symfony_env@' !== 'prod')->send();
}
.boot-check{padding:10px}.boot-check:after{display:table;clear:both;content:""}.boot-check__icon{float:left}.boot-check__icon .sk-circle{width:34px;height:34px;margin:3px}.boot-check__icon svg{display:block;width:40px;height:40px}.boot-check__icon--success svg{fill:var(--btn-primary)}.boot-check__icon--info svg,.boot-check__icon--warning svg{fill:var(--btn-warning)}.boot-check__icon--error svg{fill:var(--btn-alert)}.boot-check__label{margin-left:50px}.boot-check__description,.boot-check__detail,.boot-check__title{margin:0;line-height:inherit;overflow:hidden;text-overflow:ellipsis}.boot-check__detail{margin-top:5px;font-size:12px}.boot-check__action{margin-left:50px}.boot-check__action button{margin:15px 0 10px;height:33px;line-height:33px}@media(min-width:960px){.boot-check__label{float:left;width:540px;margin-left:10px}.boot-check__action{float:right;margin:0 0 0 10px;width:140px;text-align:center}.boot-check__action button{margin:3px 0}.boot-check__action a[target=_blank]{display:inline-block;margin:10px 0;padding-left:20px;background:var(--svg--link-blank) left center no-repeat;background-size:16px 16px}}.view-boot__header{margin-left:auto;margin-right:auto;padding:40px 0;text-align:center}.view-boot__icon{background:var(--contao);border-radius:10px;padding:10px}.view-boot__headline{margin-top:15px;font-size:36px;font-weight:100;line-height:1}.view-boot__description{margin:0;font-weight:600}.view-boot__loading{width:30px;margin:0 auto 40px}.view-boot__loading .sk-circle{width:30px;height:30px}.view-boot__checks{margin:0 16px 50px}.view-boot__checks .boot-check:nth-child(odd){border-radius:var(--border-radius);background:var(--table-odd-bg)}.view-boot__summary{margin:50px 0 0}.view-boot__summary--error svg{width:100%;height:40px;fill:var(--btn-alert)}.view-boot__issue{max-width:60%;margin:10px auto;text-align:center;color:var(--btn-alert);line-height:1.2em}.view-boot__safeMode{margin:2em auto 0}.view-boot__continue,.view-boot__safeMode{clear:both;display:block!important;width:220px!important}.view-boot__continue{margin:0 auto}@media(min-width:960px){.view-boot__checks{margin:0 80px 50px}}.view-account__header{max-width:280px;margin-left:auto;margin-right:auto;padding:40px 0;text-align:center}.view-account__product{margin-top:15px;margin-bottom:40px;font-weight:600}.view-account__product strong{display:block;margin-bottom:10px;font-size:54px;font-weight:100;line-height:1}.view-account__headline{margin-bottom:.5em;font-size:18px;font-weight:600;line-height:30px}.view-account__description{margin-bottom:1em;text-align:justify}.view-account__form,.view-account__totp{position:relative;max-width:280px;margin:0 auto}.view-account__form .widget-button,.view-account__totp .widget-button{margin-top:1.5em}.view-account__form .widget-text{margin-top:10px}.view-account__form .widget-text label{display:block;padding-bottom:5px}.view-account__contribute{max-width:280px;margin:60px auto 0;font-size:12px;text-align:center}.view-account__contribute br{display:none}@media(min-width:960px){.view-account{display:flex;flex-flow:row wrap;align-items:center;padding-top:50px}.view-account__form,.view-account__header,.view-account__totp{padding:50px;width:50%;max-width:none}.view-account__form .widget-text label{float:left;width:120px;padding-top:10px;font-weight:400}.view-account__form input[type=password],.view-account__form input[type=text],.view-account__form select{width:250px!important}.view-account__form .button-group,.view-account__form .widget-button--anchor{width:250px;margin-left:120px}.view-account__contribute{max-width:840px}.view-account__contribute br{display:block}}.widget-radio-button legend{margin-bottom:2px}.widget-radio-button>div{position:relative;margin:.25em 0}.widget-radio-button input{border:0;clip:rect(0 0 0 0);height:1px;margin:-1px;overflow:hidden;padding:0;position:absolute;width:1px}.widget-radio-button label{display:block;padding-left:25px;background:url(../img/widget-radio--off.4e93f443.svg) 0 -1px no-repeat;background-size:20px 20px}.widget-radio-button input:checked+label{background-image:url(../img/widget-radio--on.181461b6.svg)}.widget-radio-button input:focus-visible+label{outline:5px auto Highlight;outline:5px auto -webkit-focus-ring-color}.widget-radio-button input:disabled+label{opacity:.5}.setup__directories{margin-top:2em}.setup__directories>dt{margin-top:1em;font-weight:600}.setup__directories>dd{margin:0;word-break:break-all}.setup__directories>dd span{background-color:var(--highlight-bg);color:var(--highlight-color);font-weight:400}.link-more{position:relative;display:inline-block}p:empty+.link-more{margin-left:0}.link-more button{width:auto;height:auto;padding:0 0 5px;background:transparent;color:var(--link);font-size:13px;font-weight:300;line-height:inherit;border:none;cursor:pointer}.link-more button:hover{text-decoration:underline}.link-more__menu{outline:none}.link-more ul{transform:translateX(-50%)}.package-link{display:flex;-moz-column-gap:8px;column-gap:8px;justify-content:space-between;width:100%;padding-bottom:4px;margin-bottom:4px;border-bottom:1px solid var(--border--light)}.package-link:last-child{padding-bottom:0;margin-bottom:0;border-bottom:none}.package-link__details{padding:5px 0;line-height:18px}.package-link__name{display:inline;font-weight:600}.package-link__name:after{content:": "}.package-link__text{display:inline}.package-link__actions{display:flex;margin-left:20px;margin:0 -4px}.package-link__actions>*{margin:0 4px}.package-link--limit .package-link__details{display:flex}.package-link--limit .package-link__name{white-space:nowrap}.package-link--limit .package-link__text{display:-webkit-box;overflow:hidden;line-clamp:1;-webkit-line-clamp:1;-webkit-box-orient:vertical;padding:0 10px 0 5px}.package-funding[data-v-5a8fd14b]{padding:10px 20px 10px 50px;font-weight:400;font-size:12px;line-height:1.8;background:rgba(var(--funding-rgb),.025) url(../img/funding.cf78a0a0.svg) 15px 50% no-repeat;background-size:23px 23px;border:1px solid rgba(var(--funding-rgb),.5);border-radius:6px}.package-funding>div[data-v-5a8fd14b]{overflow:hidden}.package-funding span[data-v-5a8fd14b]{margin-right:15px}.package-funding a[data-v-5a8fd14b]{position:relative;display:inline-block;margin:0 20px 0 0;padding-left:16px;color:var(--funding);background:url(../img/link-funding.b25cd92d.svg) 0 50% no-repeat;background-size:13px 13px}.package-funding a[data-v-5a8fd14b]:before{content:"|";position:absolute;left:-12px}.package-funding a[data-v-5a8fd14b]:nth-child(2):before{content:none}.package-popup{position:fixed;display:flex;flex-direction:column;justify-content:flex-start;width:100%;max-width:none;height:100%;background:var(--popup-bg);z-index:10;opacity:1}.package-popup>*{flex-basis:auto;flex-grow:1}.package-popup__loader{display:flex;flex-direction:column;align-items:center;justify-content:center;padding:50px 0}.package-popup__loader p{margin:1em}.package-popup__headline{position:relative;flex-grow:0;flex-shrink:1;padding:7px 30px 6px;background:var(--popup-hl-bg);color:#fff;font-size:18px;font-weight:300;line-height:1.5;text-align:center}.package-popup__button{display:block;float:right;position:absolute;top:0;margin:4px 0;padding:4px;background:none;border:1px solid transparent;border-radius:5px;cursor:pointer}.package-popup__button--previous{left:4px}.package-popup__button--close{right:4px}.package-popup__button svg{display:block;width:22px;height:22px}.package-popup__button:hover{background-color:#db6f00}.package-popup__summary{flex-grow:0;padding:25px 35px}@media(min-width:600px){.package-popup__summary{display:flex}}.package-popup__logo{border-radius:6px;float:right;height:60px;width:60px;margin-left:1em;background:#f7f7f7}@media(min-width:600px){.package-popup__logo{display:block;float:left;width:110px;height:110px;margin:-10px 16px 0 -10px}}.package-popup__icon{display:flex;align-items:center;justify-content:center;height:100%}.package-popup__icon--fallback{display:none}.package-popup__icon img{width:50px;height:50px;max-height:100%;-o-object-fit:contain;object-fit:contain}@media(min-width:600px){.package-popup__icon img{width:90px;height:90px}}.package-popup__text{display:flex;flex-direction:column;flex-grow:1}@media(min-width:600px){.package-popup__text{width:200px}}.package-popup__title{margin:0;line-height:1.4;overflow-wrap:break-word}.package-popup__authors{flex-grow:1;font-size:13px;margin-bottom:.5em}.package-popup__author{display:inline-block;margin-right:2px}.package-popup__author:after{color:var(--text);content:", "}.package-popup__author:last-child:after{content:none}.package-popup__stats{display:inline-block;margin-right:15px;margin-top:.5em;padding-left:18px;font-size:13px;background-position:0 50%;background-repeat:no-repeat;background-size:13px 13px}.package-popup__stats--private{padding-left:20px;background-image:var(--svg--private);background-size:15px 15px}.package-popup__stats--updated{background-image:var(--svg--updated)}.package-popup__stats--downloads{background-image:var(--svg--downloads)}.package-popup__stats--favers{background-image:var(--svg--favers)}.package-popup__actions{display:flex;flex-direction:column;gap:10px;margin-top:1em}@media(min-width:600px){.package-popup__actions{justify-content:space-between;margin:0 0 0 25px;width:200px}}.package-popup__installed{margin-top:1em}.package-popup__abandoned{margin:0 0 20px;padding:10px 20px 10px 50px;font-weight:400;font-size:12px;line-height:1.8;background:rgba(var(--hint-rgb),.3) url(../img/hint.ba2ac97e.svg) 15px 50% no-repeat;background-size:23px 23px;border:1px solid var(--hint-link);border-radius:6px}.package-popup__funding{margin:0 0 20px}.package-popup__tabs{position:relative;flex-grow:revert}.package-popup__tabs:after,.package-popup__tabs:before{content:"";display:block;position:absolute;top:0;bottom:1px;width:7px;background:linear-gradient(-90deg,transparent 0,var(--popup-bg) 50%);z-index:1;pointer-events:none}.package-popup__tabs:after{background:linear-gradient(90deg,transparent 0,var(--popup-bg) 50%);right:0}.package-popup__tabs-list{flex-shrink:0;flex-grow:0;display:flex;-moz-column-gap:4px;column-gap:4px;height:40px;min-width:100%;overflow-x:auto;scrollbar-width:none;overflow-y:hidden;margin:0;padding:0 7px;list-style-type:none}.package-popup__tabs-list:after{content:"";position:absolute;inset:auto 0 0;height:1px;background:var(--border--light);z-index:-1}.package-popup__tab{position:relative;top:1px;flex-grow:1;padding:0;height:39px;line-height:39px;text-align:center;border:1px solid var(--border--light);border-top-left-radius:6px;border-top-right-radius:6px}.package-popup__tab--active{background:var(--tab-content);border-bottom:1px solid var(--tab-content)}.package-popup__tab button{display:flex;justify-content:center;align-items:center;width:100%;height:100%;margin:0;padding:0 10px;border:none;background:transparent;cursor:pointer}.package-popup__tab button:disabled{color:var(--border)!important;cursor:not-allowed}.package-popup__pill{position:relative;top:-2px;display:inline-block;margin-left:5px;padding:2px 5px;font-size:10px;font-weight:400;background:var(--border--light);border-radius:40%}.package-popup__pill--highlight{color:var(--clr-btn);background:var(--btn-primary)}.package-popup__tabcontent{position:relative;padding:25px 35px;overflow-y:auto;background:var(--tab-content);outline:0}@media(min-width:960px)and (min-height:700px){.package-popup__tabcontent{height:450px}}.package-popup__description{margin:1em 0;white-space:pre-wrap}@media(min-width:960px){.package-popup{position:relative;display:block;top:0;left:50%;width:750px;margin-left:-375px;height:auto;border-radius:8px;transform:none}.package-popup__headline{border-radius:8px 8px 0 0}.package-popup__tabcontent{border-radius:0 0 8px 8px}}@media(min-width:960px)and (min-height:700px){.package-popup{position:absolute;top:50%;transform:translateY(-50%)}}.package-popup__installed strong{margin-right:5px}@media(min-width:600px){.package-popup__installed{display:flex;flex-direction:column;justify-content:flex-end;text-align:center}.package-popup__installed strong{display:block;margin:0}}.package-popup__update{background:var(--btn-primary) url(../img/button-update.ad79c617.svg) 15px 50% no-repeat;background-size:23px 23px}.package-popup__incompatible,.package-popup__update{margin:0 0 20px;padding:10px 20px 10px 50px;color:var(--clr-btn);border-radius:var(--border-radius)}.package-popup__incompatible{background:var(--contao) url(../img/button-incompatible.3eb2b686.svg) 15px 50% no-repeat;background-size:23px 23px}.package-popup__funding+.package-popup__update{margin-top:-10px}.theme-details__constraint{flex-grow:1}.file-tree{margin:0;padding:0;list-style:none}.file-tree__folder{position:relative;padding-left:20px}.file-tree__folder:before{content:"";position:absolute;left:10px;top:6px;width:0;height:0;border-top:5px solid transparent;border-bottom:5px solid transparent;border-left:5px solid var(--text);transition:transform .1s ease-in-out}.file-tree__folder--open:before{transform:rotate(90deg)}.file-tree__file{padding-left:20px}.file-tree button{background:none;border:none;font-weight:400;cursor:pointer}.setup__versions{margin:0;padding:0 0 0 15px}.setup__version{margin:.5em 0;text-align:left}.setup__version--warning{color:var(--btn-alert)}.setup__releaseplan{margin-top:1.5em}.setup__fielddesc--version{margin-bottom:-1em!important}.setup__core-features{margin:5px 0 0 5px;font-size:12px}.setup__theme-image{max-width:100%;height:auto;border:1px solid var(--border)}.setup__theme p{margin:1em 0}.setup__theme-upload{position:absolute!important;visibility:hidden}.setup__themes{padding:0 14px}.setup__themes-results{display:grid;gap:14px}@media(min-width:1024px){.setup__themes-results{grid-template-columns:repeat(2,1fr)}.setup__themes-results-item{flex-basis:calc(50% - 16px);margin-left:8px;margin-right:8px}}.setup__themes-item{border:1px solid var(--tiles-bdr)}.setup__themes-more{margin-top:20px;text-align:center}.setup__theme-search{margin:20px 0 0;text-align:center}.setup__theme-search--empty{padding-top:60px;background:url(../img/sad.c7de6e95.svg) top no-repeat;background-size:50px 50px}.setup__theme-search--offline{padding-top:60px;background:url(../img/offline.0c23d1ce.svg) top no-repeat;background-size:50px 50px}.setup__theme-search--loader .sk-circle{width:50px;height:50px;margin:0 auto 20px}.setup__theme-search button{margin-top:2em}.setup__fielddesc--warning{padding:10px 10px 10px 40px;background:var(--hint-bg) url(../img/hint.ba2ac97e.svg) 10px 10px no-repeat}.setup__tabs{margin:1em 0}.setup__tab-controls{display:flex}.setup__tab-control{flex-grow:1;padding:4px 10px;border:none;border-top:1px solid var(--border);border-left:1px solid var(--border);background:none;cursor:pointer}.setup__tab-control:last-child{border-right:1px solid var(--border)}.setup__tab-control--active{border-color:var(--btn);background:var(--btn);color:#fff}.setup__tab{border:1px solid var(--border)}.setup__tab--files{white-space:pre;overflow:scroll;height:200px}.setup__requires{width:100%;border-collapse:collapse}.setup__requires td,.setup__requires th{margin:0;padding:3px 10px;text-align:start;vertical-align:top}.setup__requires th{background:var(--btn);color:#fff}.setup__requires td{border-bottom:1px solid var(--border)}.setup__requires tr:last-child td{border-bottom:none}.setup__requires tr:nth-child(odd) td{background:var(--table-odd-bg)}.setup__or{position:relative;overflow:hidden;margin:1em 0;text-align:center}.setup__or:before{content:"";position:absolute;top:.8em;left:0;right:0;display:block;height:1px;background:var(--border);z-index:1}.setup__or span{position:relative;padding:0 10px;background:var(--popup-bg);z-index:2}.view-setup{padding-top:40px}.view-setup footer{margin-top:40px}.view-setup__steps{padding:0 0 50px 0}.view-setup__steps ul{display:flex;margin:0;padding:0;list-style-type:none}.view-setup__steps li{display:flex;justify-content:center;align-items:center;flex-grow:1;position:relative;height:6px;margin:0;padding:0}.view-setup__steps li:before{content:"";position:absolute;left:-50%;right:50%;background:var(--border);height:5px}.view-setup__steps li:after{content:"";position:absolute;top:-18px;left:50%;margin-left:-21px;width:42px;height:42px;color:#fff;text-indent:0;text-align:center;line-height:35px;background:var(--border);border-radius:50%;z-index:1}.view-setup__steps li:first-child:before{content:none}.view-setup__steps li.active:after,.view-setup__steps li.active:before{background:var(--contao)}.view-setup__steps button{display:flex;justify-content:center;align-items:center;background:transparent;border:none;z-index:10;cursor:pointer}.view-setup__steps button:disabled{cursor:default}.view-setup__steps svg{fill:#fff}.view-setup__main{text-align:center}.view-setup__party{font-size:64px}.view-setup__headline{margin:10px 0 20px;padding:15px 0;font-size:42px;font-weight:100}.view-setup__description{max-width:500px;margin:1em 25px}.view-setup__start.widget-button{height:50px;margin:30px 10px 0;padding:0 50px;font-size:1.2em;line-height:50px}.view-setup__continue.widget-button{width:80%!important;margin:10px 0 0}.view-setup__funding{width:80%;margin:50px auto 0;padding:20px 25px;border:2px solid var(--funding);border-radius:var(--border-radius);background:rgba(var(--funding-rgb),.025);font-weight:400}.view-setup__funding figure{margin-bottom:1em}.view-setup__funding p{margin:0 0 .5em 0}.view-setup__funding-link{margin:1em 0 0}@media(min-width:960px){.view-setup{padding-top:80px}.view-setup footer{margin-top:80px}.view-setup__steps{padding-bottom:80px}.view-setup__headline{margin:20px 0 40px;font-size:64px}.view-setup__continue.widget-button{width:auto!important;margin:25px 10px 0;padding:0 20px}.view-setup__description{max-width:550px;margin:1em auto;font-size:1.2em}.view-setup__funding{display:flex;margin:60px auto -20px;text-align:left}.view-setup__funding figure{margin-right:25px}}.setup__header{max-width:280px;margin-left:auto;margin-right:auto;padding:40px 0;text-align:center}.setup__header .widget-button{margin-top:1em}.setup__icon{background:var(--contao);border-radius:10px;padding:10px}.setup__headline{margin-top:20px;margin-bottom:25px;font-size:36px;font-weight:100;line-height:1}.setup__description,.setup__warning{margin:1em 0;text-align:justify}.setup__warning{color:var(--btn-alert);font-weight:600}.setup__form{position:relative;max-width:280px;margin:0 auto 50px;opacity:1}.setup__form svg.setup__check{display:block;width:80px;height:80px;margin:0 auto 2em;fill:var(--btn-primary)}.setup__form .widget-select,.setup__form .widget-text{margin-top:10px}.setup__form .widget-select label,.setup__form .widget-text label{display:block;margin-bottom:5px;font-weight:400}.setup__form .widget-checkbox{margin-top:20px;font-weight:400}.setup__form .widget-radio-button{margin-top:20px}.setup__fields{margin-bottom:2em}.setup__fields--center{text-align:center}.setup__fields .button-group .widget-button{margin-bottom:1px}.setup__fieldtitle{margin-bottom:.5em;font-size:18px;font-weight:600;line-height:30px}.setup__fielddesc{margin-bottom:1em;text-align:left}.setup__fielddesc code{word-break:break-word}.setup__actions{display:flex;flex-wrap:wrap;gap:10px}.setup__actions--center{justify-content:center}.setup__actions .button-group,.setup__actions .widget-button{flex-grow:1}.setup__actions .button-group--inline,.setup__actions .widget-button--inline{flex-grow:0}@media(min-width:960px){.setup{padding-top:100px}.setup__header{float:left;width:470px;max-width:none;padding:0 60px 50px}.setup__form{float:left;width:370px;max-width:none;margin:0 50px 50px}.setup__form .widget-select label,.setup__form .widget-text label{display:block;float:left;width:120px;padding-top:10px;font-weight:400}.setup__form .widget-select input,.setup__form .widget-select select,.setup__form .widget-text input,.setup__form .widget-text select{width:250px!important}}.view-login__header{max-width:280px;margin:0 auto 60px;padding-top:40px;text-align:center}.view-login__product{margin-top:15px;font-size:38px;font-weight:100;line-height:1}.view-login__form{position:relative;max-width:280px;margin:0 auto 60px}.view-login__form input{padding-right:30px;margin:5px 0 10px}.view-login__locked{max-width:290px;margin:-20px auto 60px;padding:20px;background:var(--btn-alert);color:#fff;text-align:center}.view-login__locked strong{white-space:pre}.view-login__headline{margin-bottom:0}.view-login__description{margin-top:.5em;margin-bottom:20px}.view-login label{position:absolute;text-indent:-999em;pointer-events:none}.view-login label[for=ctrl_username]{top:0;bottom:0;margin:auto;right:13px;width:16px;height:16px;background:url(../img/person.00d78897.svg) 0 0 no-repeat;background-size:16px 16px;z-index:10}.view-login label[for=ctrl_password]{top:0;bottom:0;margin:auto;right:12px;width:16px;height:16px;background:url(../img/lock.3c42a55f.svg) 0 0 no-repeat;background-size:14px 14px;z-index:10}.view-login__password input,.view-login__user input{margin:0}.view-login__user input{border-radius:var(--border-radius) var(--border-radius) 0 0!important}.view-login__password{margin-top:-1px;margin-bottom:10px}.view-login__password input{border-radius:0 0 var(--border-radius) var(--border-radius)!important}.view-login .widget-text--password button{opacity:0}.view-login__link{display:block;margin-top:2em;font-size:12px;text-align:center}.view-login__button{margin:3px 0}.view-login__button .sk-circle{color:#fff;text-align:center}.view-login__or{display:grid;gap:15px;grid-template-columns:1fr auto 1fr;padding:12px}.view-login__or:after,.view-login__or:before{align-self:center;border-top:1px solid var(--border);content:""}.view-login .fragment-footer{display:block}body.nav-active{overflow:hidden!important}#app{transition:transform .4s cubic-bezier(.55,0,.1,1)}.nav-active #app{overflow-y:visible;transform:translateX(-280px)}.nav-active #app .navigation__group--main{visibility:visible}@media(min-width:1024px){.nav-active #app{transform:none}}.navigation__toggle{display:block;float:right;position:relative;margin:5px 15px;padding:0;width:30px;height:30px;background:none;border:none;cursor:pointer;z-index:20}.navigation__toggle span,.navigation__toggle span:after,.navigation__toggle span:before{content:"";display:block;width:100%;height:4px;background:var(--text);border-radius:4px;position:absolute}.navigation__toggle span{transition-duration:75ms;transition-timing-function:cubic-bezier(.215,.61,.355,1);top:50%;margin-top:-2px}.navigation__toggle span:before{top:-10px;transition:top 75ms ease .12s,opacity 75ms ease}.navigation__toggle span:after{bottom:-10px;transition:bottom 75ms ease .12s,transform 75ms cubic-bezier(.55,.055,.675,.19)}.nav-active .navigation__toggle span{transform:rotate(45deg);transition-delay:.12s;transition-timing-function:cubic-bezier(.215,.61,.355,1)}.nav-active .navigation__toggle span:before{top:0;opacity:0;transition:top 75ms ease,opacity 75ms ease .12s}.nav-active .navigation__toggle span:after{transition:bottom 75ms ease,transform 75ms cubic-bezier(.215,.61,.355,1) .12s;bottom:0;transform:rotate(-90deg)}.navigation__group,.navigation__item{list-style-type:none;margin:0;padding:0}.navigation__group--main{position:fixed;top:0;bottom:0;right:-280px;width:280px;visibility:hidden;padding:20px;overflow-y:auto;overflow-scrolling:touch;background:var(--header-main-bg);border-left:1px solid var(--header-bdr);z-index:10}.navigation__item a,.navigation__item button{display:block;margin:0;padding:12px 10px;font-size:16px;color:var(--text);white-space:pre;background:none;border:none}.navigation__item a:hover,.navigation__item button:hover{text-decoration:none}.navigation__item a[href]:hover,.navigation__item button[href]:hover{color:var(--link)}.navigation__item--main>a,.navigation__item--main>button{text-transform:uppercase}.navigation__item--sub>a{margin-left:15px}.navigation__item--icon svg{display:none}.navigation__item-badge{position:relative;top:-2px;margin-left:8px;padding:2px 5px;font-size:10px;color:var(--clr-btn);font-weight:600;background:var(--contao);border-radius:40%}@media(min-width:1024px){.navigation__toggle{display:none}.navigation__group--main{display:flex;visibility:visible;position:inherit;inset:auto;width:auto;padding:0;overflow:visible;background:none;border:none;box-shadow:none;transform:none;transition:none}.navigation__group--sub{position:absolute;left:50%;min-width:180px;margin-top:-3px;text-align:center;background:var(--form-bg);border-top:3px solid var(--link);border-radius:5px;transform:translateX(-50%);z-index:100;box-shadow:0 0 2px var(--shadow);transition:opacity var(--am-close-transition-duration) ease}.navigation__group--sub:before{position:absolute;left:50%;top:-7px;width:0;height:0;margin-left:-4px;border-style:solid;border-width:0 3.5px 4px 3.5px;border-color:transparent transparent var(--link) transparent;content:""}.navigation__group--sub.hide{display:none!important}.navigation__group--sub.transitioning{display:block!important;opacity:0}.navigation__group--sub.show{display:block!important;opacity:1;transition:opacity var(--am-open-transition-duration) ease}.navigation__group--right{left:auto;right:7px;transform:translateX(0)}.navigation__group--right:before{left:auto;right:18px}.navigation__item{position:relative;padding:0 8px}.navigation__item.router-link-active>a,.navigation__item:hover>a{color:var(--link)!important;border-bottom:3px solid var(--link)}.navigation__item:hover>.navigation__group--sub{display:block}.navigation__item--sub{display:block;margin:calc(var(--border-radius)/2) 0;padding:0 2px;border-radius:var(--border-radius)}.navigation__item--sub a{margin:0;border:none!important}.navigation__item--sub.router-link-active,.navigation__item--sub:hover{background:var(--focus)}.navigation__item--sub.router-link-active a,.navigation__item--sub:hover a{color:var(--text)!important}.navigation__item--icon>button{padding-top:7px}.navigation__item--icon>button svg{display:inline;position:relative;top:4px;width:22px;height:22px;fill:var(--text)}.navigation__item--icon>button:hover svg{fill:var(--link)}.navigation__item--icon>button span{display:none}.navigation:hover li>a{border:none}.navigation:hover li:hover>a{border-bottom:3px solid var(--link)}.navigation:hover li:hover>a svg{fill:var(--link)}}.logout-warning{text-align:center}.logout-warning__countdown{margin:20px 0;font:600 4em/1.6 SFMono-Regular,Menlo,Monaco,Consolas,Liberation Mono,Courier New,monospace;color:var(--btn-warning)}.fragment-footer{width:280px;margin:10px auto 0;padding:15px 0 25px;font-size:12px;text-align:center;border-top:1px solid var(--footer-bdr)}.fragment-footer--main{width:auto;margin-top:52px!important;padding:20px 0}.fragment-footer--boxed{border-color:var(--footer-fragment-bdr)}.fragment-footer__product{font-weight:300}.fragment-footer__links{margin:5px 0 0;padding:0;list-style-type:none}.fragment-footer__links li{display:inline-block}.fragment-footer__links li:not(:first-child):before{content:"|";padding:0 10px 0 8px}.fragment-footer__links a{display:inline!important;color:var(--link-footer)}.fragment-footer__settings{margin-top:10px;display:flex;flex-flow:column;justify-content:center;gap:10px}@media(min-width:960px){.fragment-footer{display:grid;grid-auto-flow:column;grid-auto-columns:minmax(0,1fr);gap:16px;align-content:center}.fragment-footer--boxed .fragment-footer__product,.fragment-footer--main .fragment-footer__product{margin-right:auto}.fragment-footer--boxed .fragment-footer__links,.fragment-footer--main .fragment-footer__links{order:15;margin:0 0 0 auto}.fragment-footer--boxed .fragment-footer__settings,.fragment-footer--main .fragment-footer__settings{flex-flow:row;margin-top:0}.fragment-footer--boxed{width:840px}}.layout-main{overflow:hidden;min-height:100vh}.layout-main__header{display:flex;justify-content:space-between;height:56px;padding:8px;background:var(--header-main-bg)}.layout-main__header--margin{margin-bottom:30px}.layout-main__badge-title{background:var(--border);color:var(--text);padding:2px 5px;position:relative;top:-5px;border-radius:8px;font-size:.75rem;font-weight:600;line-height:1;display:-webkit-box;-webkit-line-clamp:1;line-clamp:1;-webkit-box-orient:vertical;word-break:break-word;overflow:hidden;text-overflow:ellipsis}.layout-main__subheader{margin:0 0 45px;padding:20px 0;background:var(--header-bg);border-bottom:1px solid var(--header-bdr)}.layout-main__subheader-inside{display:flex;justify-content:center;align-items:center;flex-direction:column}.layout-main__news{width:320px;height:50px;margin-bottom:20px}.layout-main__news a,.layout-main__news img{display:block}.layout-main .search-bar{width:100%;margin:0}.layout-main__logo{display:inline;color:var(--text);text-decoration:none;font-weight:100;font-size:27px;line-height:40px}.layout-main__logo img{float:left;margin:0 10px 0 12px}@media(min-width:1024px){.layout-main__logo img{margin-left:0}}.layout-main footer,.layout-main__content,.layout-main__subheader-inside{position:relative;margin:0 20px}.layout-main__has-badge-title{display:flex;justify-content:space-between}.layout-main__has-badge-title .layout-main__logo{display:flex}.layout-main__has-badge-title .layout-main__title{display:flex;flex-wrap:wrap;align-items:center;line-height:1;-moz-column-gap:10px;column-gap:10px;row-gap:5px}@media(max-width:600px){.layout-main__badge-title{max-width:220px}}@media(min-width:700px){.layout-main__subheader-inside{flex-direction:row}.layout-main__news{margin:0 20px 0 0}}@media(min-width:1024px){.layout-main__has-badge-title .navigation__group--main{display:flex}.layout-main footer,.layout-main__content,.layout-main__subheader-inside{max-width:960px;margin:0 auto}}@media(min-width:1200px){.layout-main footer,.layout-main__content,.layout-main__subheader-inside{max-width:1180px}}.confirm-button{position:relative}.confirm-button__icon{display:none;position:absolute;opacity:0;z-index:100}.confirm-button__icon--confirm{display:block;animation:confirm_button .5s ease-out 0s}.confirm-button__icon svg{fill:var(--btn-primary);width:100%;height:100%}@keyframes confirm_button{0%{opacity:1;height:10px;width:10px;left:calc(50% - 5px);top:calc(50% - 5px)}to{opacity:0;height:150px;width:150px;left:calc(50% - 75px);top:calc(50% - 75px)}}.package-tools{position:relative;clear:both;text-align:center}@media(min-width:800px){.package-tools{margin-bottom:40px}}.package-tools__button.widget-button{margin-bottom:10px}@media(min-width:800px){.package-tools{display:flex;justify-content:center;align-items:center}.package-tools__button.widget-button{width:auto;margin:0 15px;padding:0 15px}}.package-actions{position:fixed;left:0;right:0;bottom:0;max-height:0;background:#000;background:rgba(0,0,0,.8);color:#fff;transition:max-height .4s ease;z-index:100}.package-actions--active{max-height:200px}.package-actions__inner{display:flex;flex-wrap:wrap;justify-content:flex-end;align-items:center;margin:0;padding:12px;text-align:right}@media(min-width:1024px){.package-actions__inner{max-width:976px;margin:0 auto;padding-left:0;padding-right:0}}@media(min-width:1200px){.package-actions__inner{max-width:1196px}}.package-actions__text{flex-grow:1;display:initial;margin:0 8px;font-weight:600}.package-actions__button{display:block;padding:0 15px!important;margin:8px}.package-actions__button--dryRun{width:auto!important;flex-grow:1}@media(min-width:600px){.package-actions__button{width:auto!important}.package-actions__button--dryRun{flex-grow:0}}.package-actions__button-group{display:block;width:100%;margin:8px}.package-actions__button-group>.button-group__primary{padding:0 15px!important}@media(min-width:600px){.package-actions__button-group{width:auto!important}}.package{position:relative;margin-bottom:20px;background:var(--tiles-bg);border:1px solid var(--tiles-bdr);border-radius:14px}.package.is--hint{border-color:var(--btn-alert)}.package--contao:not(:last-child){margin-bottom:5em}.package__hint{position:relative;background:var(--hint-bg);padding:8px 16px;font-weight:400;font-size:12px;line-height:1.8;border-radius:14px 14px 0 0;z-index:1}.package__hint p a{display:inline-block;padding-right:10px}.package__hint p a:first-child{margin-left:10px}.package__hint p a:not(:first-child):before{padding-right:10px;content:"|"}.package__hint-close{float:right;padding-left:18px;color:var(--hint-link);background:url(../img/close.8b27dbcb.svg) 0 no-repeat;background-size:14px 14px}.package__inside{position:relative;padding:16px}.package__inside:after{display:table;clear:both;content:""}.package__badge{display:inline-block;margin-bottom:.5em;padding:2px 5px;color:#fff;font-size:12px;font-weight:600;background:var(--btn-alert);border-radius:var(--border-radius);cursor:help}.package__icon{border-radius:6px;height:60px;width:60px;background:#f7f7f7;margin:0 auto 10px;position:absolute;right:16px}.package__icon>figure{display:flex;align-items:center;justify-content:center;height:100%}.package__icon img,.package__icon svg{border-radius:4px;width:50px;height:50px;max-height:100%;-o-object-fit:contain;object-fit:contain}.package__details{min-height:96px}.package__about{margin-bottom:20px}.package__headline{position:relative;margin-bottom:.2em;line-height:1;overflow-wrap:break-word;margin-right:70px}.package__headline em{background-color:var(--highlight-bg);color:var(--highlight-color);font-style:normal}.package__title{display:block;margin-right:10px}.package__description{display:-webkit-box;overflow:hidden;-webkit-line-clamp:2;-webkit-box-orient:vertical;margin-bottom:1em;margin-right:70px}.package__description em{background-color:var(--highlight-bg);color:var(--highlight-color);font-style:normal}.package__additional{margin-top:-5px}.package .package__release{text-align:right;margin-bottom:5px}.package__version--additional{margin-bottom:5px}.package__version--additional strong{margin-right:10px}.package__version--release{display:none}.package__version--release time{display:block}.package__version--missing{padding:4px 8px;background:var(--btn-alert);border-radius:var(--border-radius);color:#fff;font-weight:700}.package__version-update{display:inline-block;margin:0 0 2px;padding:1px 8px;color:#fff;border-radius:var(--border-radius)}.package__version-update--available{background:var(--btn-primary)}.package__version-update--error{background:var(--btn-alert)}.package__version-update--none{background:var(--border)}.package__version-latest{float:right;position:relative;right:-7px;width:24px;height:20px;background:var(--btn-primary) url(../img/button-update.ad79c617.svg) center center/20px 20px no-repeat}.package__actions{display:flex;flex-flow:column;gap:5px}.package__actions .button-group button{margin-bottom:0!important}@media(min-width:600px){.package__description,.package__title{margin-right:0}.package__hint{padding-left:52px;background:rgba(var(--hint-rgb),.9) url(../img/hint.ba2ac97e.svg) 12px 5px no-repeat;background-size:28px 28px}.package__inside{display:flex;align-items:stretch;padding:0}.package__headline--badge{display:flex;gap:6px;align-items:flex-start}.package__headline{margin:0 0 8px}.package__badge{order:1;margin:0 0 0 2px}.package__icon{width:130px;height:auto;min-height:130px;margin:0;border-radius:12px 0 0 12px;position:revert;right:revert}.package__icon img,.package__icon svg{width:110px;height:110px}.is--hint .package__icon{border-top-left-radius:0}.package--contao{overflow:hidden}.package--contao .package__icon{border-radius:0}.package__details{padding:16px;height:100%;min-height:90px;max-width:calc(100% - 130px);flex:1}.package.is--hint .package__icon{border-top-left-radius:0}}@media(min-width:680px){.package .package__release{display:block;float:left;width:33%}.package__actions{float:right;width:64%;flex-flow:row;gap:4%;text-align:right}.package__actions>*{flex:1}}@media(min-width:1024px){.package__version--additional{display:none}.package__version--release{display:block;margin-top:15px;text-align:center}.package__version-update{display:block;margin:2px 0 0}.package__about{float:left;width:396px;margin-bottom:0}.package .package__release{width:180px;margin-left:20px;margin-bottom:0}.package__actions{flex-flow:column;gap:10px;width:180px;margin-left:20px}.package__details{display:flex;align-self:center;align-items:flex-start}}@media(min-width:1200px){.package__about{width:616px}}.progress-bar{position:relative;width:100%;height:30px;background:var(--clr-btn);border:2px solid var(--btn-warning);color:#000;font-weight:600;text-align:center;line-height:26px}.progress-bar__bar{position:absolute;overflow:hidden;left:0;right:0;top:0;bottom:0;background:var(--btn-warning)}.progress-bar__bar span{display:block;color:var(--clr-btn);text-align:center}.feature-package{display:flex;flex-wrap:wrap;padding:6px 16px;border-top:1px solid var(--border--light)}.feature-package__name{font-weight:600;white-space:nowrap}.feature-package__name:after{content:": "}.feature-package__text{flex-grow:1;display:-webkit-box;overflow:hidden;-webkit-line-clamp:1;line-clamp:1;-webkit-box-orient:vertical;margin-right:.5em;padding:4px 0;line-height:20px}.feature-package__text--hint{display:inline;-webkit-line-clamp:none;line-clamp:none}.feature-package__badge{margin-left:5px;padding:2px 8px;background:var(--btn-alert);border-radius:var(--border-radius);font-size:12px;font-weight:600;line-height:19px;color:#fff;cursor:help}.feature-package__hint{line-height:1.2;padding:2px 5px;background:var(--hint-bg);font-size:12px}.feature-package__actions{flex-grow:1;display:flex;justify-content:flex-end;margin:0 -4px 0 0}.feature-package__actions>*{margin:0 4px}.feature-package__restore{padding-left:18px;font-size:12px;color:var(--hint-link);background:url(../img/close.8b27dbcb.svg) 0 no-repeat;background-size:14px 14px;border:none;cursor:pointer}.feature-package__restore:hover{text-decoration:underline}@media(min-width:800px){.feature-package{flex-wrap:nowrap}}@media(min-width:1024px){.feature-package__hint{padding:8px 10px 8px 36px;background:var(--hint-bg) url(../img/hint.ba2ac97e.svg) 10px 5px no-repeat;background-size:20px 20px}.feature-package__actions{margin:0 -4px 0 0}}.package-constraint input[type=text][data-v-1e421d04]{margin-right:2px;background:#fff;border:2px solid var(--btn-warning);color:var(--black);font-weight:600;text-align:center;border-top-right-radius:0;border-bottom-right-radius:0}.package-constraint input[type=text][data-v-1e421d04]::-moz-placeholder{color:#fff;opacity:1}.package-constraint input[type=text][data-v-1e421d04]::placeholder{color:#fff;opacity:1}.package-constraint input[type=text][data-v-1e421d04]:disabled{color:var(--clr-btn);opacity:1;background:var(--btn-warning);-webkit-text-fill-color:var(--clr-btn)}.package-constraint input[type=text].disabled[data-v-1e421d04]{background:var(--border);border-color:var(--border)}.package-constraint input[type=text].error[data-v-1e421d04]{animation:input-error .15s linear 3}.package-constraint>input[type=text][data-v-1e421d04],.package-constraint>input[type=text][data-v-1e421d04]:disabled{float:left;width:calc(100% - 32px)}.package-constraint button[data-v-1e421d04]{position:relative;width:30px;background:var(--btn-warning);line-height:20px;text-indent:-999em;border-top-left-radius:0;border-bottom-left-radius:0}.package-constraint button[data-v-1e421d04]:hover{background:var(--btn-warning-active);border-color:var(--btn-warning-active)}.package-constraint button[data-v-1e421d04]:before{position:absolute;left:50%;top:50%;margin:-10px 0 0 -10px}.package-constraint button.rotate[data-v-1e421d04]:before{animation:release-validating-1e421d04 2s linear infinite}@keyframes release-validating-1e421d04{to{transform:rotate(1turn)}}@media(min-width:1024px){.package-constraint button[data-v-1e421d04],.package-constraint input[type=text][data-v-1e421d04]{height:30px}}.button-group{display:flex;gap:1px;position:relative}.button-group__primary.widget-button{flex-grow:1;border-top-right-radius:0;border-bottom-right-radius:0}.button-group__more.widget-button{flex-shrink:0;width:38px;padding:7px;border-top-left-radius:0;border-bottom-left-radius:0}.button-group__more.widget-button svg{width:24px;height:24px}.button-group__group{position:absolute;top:39px;width:100%;padding-top:3px;z-index:100}.button-group__group:focus{outline:none}.button-group__group .widget-button{margin-top:1px}.button-group__group .link-menu{margin-top:3px}.button-group__group--top{top:auto;bottom:39px}.button-group__group--top .link-menu{margin-top:0;margin-bottom:3px}.composer-package__stats{display:inline-block;margin-right:15px;padding-left:18px;font-size:13px;background-position:0 50%;background-repeat:no-repeat;background-size:13px 13px}.composer-package__stats--license{padding-left:0}.composer-package__stats--versions{display:inline-flex;flex-wrap:wrap;gap:5px;list-style:none;margin:0 15px 0 0;padding:0}.composer-package__stats--version{padding:3px 5px;line-height:1;border:1px solid var(--border);border-radius:4px}.composer-package__stats--funding{width:16px;background-image:url(../img/funding.cf78a0a0.svg);background-size:16px 16px;background-repeat:no-repeat;text-decoration:none!important}.package-uploads__overlay{top:0;bottom:0;right:0;left:0;position:fixed;z-index:9999;opacity:.6;text-align:center;background:#000}.package-uploads__overlay div{margin:-.5em 0 0;position:absolute;top:50%;left:0;right:0;transform:translateY(-50%);font-size:40px;color:#fff;padding:0}.cloud-status{margin-left:8px;position:relative}.cloud-status__button{margin-left:0;margin-right:0;padding-left:8px;cursor:help!important}.cloud-status__popup{position:absolute;text-align:center;left:0;bottom:54px;margin:0;padding:0 0 15px;outline:none;background:var(--form-bg);color:var(--text);border-bottom:3px solid var(--contao);border-radius:5px;box-shadow:0 0 2px var(--shadow);z-index:100}.cloud-status__popup:after{position:absolute;left:38px;bottom:-6px;width:0;height:0;margin-left:-4px;border-style:solid;border-width:4px 3.5px 0 3.5px;border-color:var(--contao) transparent transparent transparent;content:""}.cloud-status__popup--error{color:var(--clr-btn);background-color:var(--btn-alert);border-color:var(--btn-alert)}.cloud-status__popup--error:after{left:27px;border-color:var(--btn-alert) transparent transparent transparent}.cloud-status__headline{padding:15px 20px 0;font-size:16px;white-space:pre}.cloud-status__version{margin:0 0 8px;font-size:12px}.cloud-status__link{display:inline-block;margin:15px 10px 0}.cloud-status__error{padding:8px 20px 8px;-webkit-hyphens:auto;hyphens:auto}.cloud-status table{width:100%;margin-top:12px;text-align:left;border-spacing:0;border-collapse:collapse}.cloud-status th{padding:3px 5px 3px 20px}.cloud-status td{padding:3px 20px 3px 0}.cloud-status tr:nth-child(odd){background:var(--table-odd-bg)}.package-list{position:relative}.package-list__status{margin:100px 0;text-align:center;font-size:20px;line-height:1.5em}.package-list__status .sk-circle{width:100px;height:100px;margin:0 auto 40px}.package-list__headline{font-size:18px;font-weight:300;margin:30px 0 10px}.animate-blur-in,.animate-blur-out,.layout-boxed{display:table;width:100%;height:100%}.layout-boxed__cell{display:table-cell;overflow:hidden;vertical-align:middle;padding:10px}.layout-boxed__container{position:relative;max-width:380px;margin:0 auto;background:var(--popup-bg);border-radius:8px}@media(min-width:960px){.layout-boxed__container{margin-top:20px;margin-bottom:20px}.layout-boxed__container--wide{max-width:940px}}.widget-checkbox input{border:0;clip:rect(0 0 0 0);height:1px;margin:-1px;overflow:hidden;padding:0;position:absolute;width:1px}.widget-checkbox label{position:relative;display:block;padding-left:25px;text-align:left}.widget-checkbox label:before{content:"";position:absolute;left:0;width:20px;height:20px;background:url(../img/widget-checkbox--off.73856538.svg) 0 0 no-repeat;background-size:20px 20px}.widget-checkbox input:checked+label:before{background-image:url(../img/widget-checkbox--on.8b830157.svg)}.widget-checkbox input:focus-visible+label{outline:5px auto Highlight;outline:5px auto -webkit-focus-ring-color}.widget-checkbox input:disabled+label{opacity:.5}.widget-checkbox .widget__description{padding-left:25px}.widget-checkbox .widget__description--disabled{opacity:.5}.user-scope__label{margin:0;padding:0}.user-scope__item{padding:5px 0 0}.user-scope__item--required label{opacity:1!important}.user-scope__item--required label:before{opacity:.5}.view-oauth__header{max-width:280px;margin:0 auto 40px;padding-top:40px;text-align:center}.view-oauth__icon{background:var(--contao);border-radius:10px;padding:10px}.view-oauth__product{margin-top:15px;font-size:36px;font-weight:100;line-height:1}.view-oauth__form{position:relative;max-width:280px;margin:0 auto 60px;text-align:center}.view-oauth__form input,.view-oauth__form select{margin:5px 0 10px}.view-oauth__description{margin-top:.5em;margin-bottom:.5em}.view-oauth__client{margin:1em 0;font-size:32px}.view-oauth__scopes{text-align:left}.view-oauth__warning{color:var(--btn-alert);margin-top:2em;margin-bottom:2em}.view-oauth__button{margin-top:1em}.view-oauth__button .sk-circle{color:#fff;text-align:center}.message-overlay{position:relative}.message-overlay__blur{opacity:.75;filter:blur(2px);transition:opacity .5s,filter .5s}.message-overlay__overlay{position:absolute;display:flex;justify-content:center;align-items:center;left:0;right:0;top:0;bottom:0}.message-overlay__message{padding:10px;font-size:2em;font-weight:400;text-align:center}.maintenance{margin-bottom:14px;background:var(--tiles-bg);border-radius:var(--border-radius)}.maintenance__inside{padding:10px 20px 20px}@media(min-width:1024px){.maintenance__inside{display:grid;grid-template:auto/90px auto 300px;-moz-column-gap:20px;column-gap:20px;padding:25px 20px}}.maintenance__image{display:none}.maintenance__image img{width:100%;height:100%;border-radius:var(--border-radius);overflow:hidden}@media(min-width:1024px){.maintenance__image{display:block}}.maintenance__about{margin-bottom:20px}@media(min-width:1024px){.maintenance__about{margin-bottom:0}}.maintenance__about h1{position:relative;margin-bottom:5px;display:flex;flex-wrap:wrap;-moz-column-gap:.5em;column-gap:.5em;align-items:baseline}.maintenance__about p{margin:0 0 1em;display:inline}.maintenance__error,.maintenance__warning{position:relative;top:-2px;padding:4px 8px;font-size:14px;line-height:1em;font-weight:300;background:var(--btn-warning);color:var(--clr-btn);border-radius:var(--border-radius)}.maintenance__error{background:var(--btn-alert)}.maintenance__actions{display:flex;flex-direction:column;row-gap:10px;-moz-column-gap:20px;column-gap:20px}@media(min-width:600px){.maintenance__actions{flex-direction:row-reverse}}@media(min-width:1024px){.maintenance__actions{flex-direction:column;margin-left:20px}}.maintenance__actions>.button-group,.maintenance__actions>button{width:100%}@media(min-width:600px){.maintenance__actions>.button-group,.maintenance__actions>button{width:calc(50% - 10px)}}@media(min-width:1024px){.maintenance__actions>.button-group,.maintenance__actions>button{width:100%}}.maintenance__loader{width:50px;margin:0 auto}.maintenance__loader .sk-circle{width:50px;height:50px}.log-viewer__status{margin:100px 0;text-align:center;font-size:20px;line-height:1.5em}.log-viewer__status--empty{padding-top:140px;background:url(../img/warning.9a7cd776.svg) top no-repeat;background-size:100px 100px}.log-viewer__status--loader .sk-circle{width:100px;height:100px;margin:0 auto 40px}.log-viewer__status button{margin-top:2em}.log-viewer__loading{width:30px;margin:40px auto}.log-viewer__loading .sk-circle{width:30px;height:30px}.log-viewer__filters{display:flex;justify-content:space-between;flex-wrap:wrap;gap:20px}.log-viewer__filters>div{display:flex;align-items:flex-end;gap:20px}.log-viewer__filters a{flex-shrink:0}.log-viewer__file{flex-shrink:1;display:flex;align-items:flex-end}.log-viewer__file select{border-right:none;border-top-right-radius:0;border-bottom-right-radius:0}.log-viewer__file button{border-top-left-radius:0;border-bottom-left-radius:0}.log-viewer__list{margin-top:2em;padding-bottom:1px;background:var(--form-bg);border-radius:var(--border-radius)}@media(min-width:600px){.log-viewer__list{overflow-y:scroll;max-height:calc(100vh - 300px)}}.log-viewer__line{position:relative;padding:10px 0;border-bottom:1px solid var(--border--light)}@media(min-width:600px){.log-viewer__line{display:flex}}.log-viewer__line:hover{background:var(--focus)}.log-viewer__line:last-child{border-bottom:none}.log-viewer__line--header{display:none}@media(min-width:600px){.log-viewer__line--header{display:flex;position:sticky;top:0;z-index:1;font-weight:600;background:var(--log-header-bg)!important;color:#fff;border-top-left-radius:2px;border-top-right-radius:2px;border-bottom-color:var(--border)}}.log-viewer__line--alert:before,.log-viewer__line--critical:before,.log-viewer__line--emergency:before,.log-viewer__line--error:before,.log-viewer__line--warning:before{content:"";position:absolute;left:0;top:-1px;bottom:-1px;width:4px;background:var(--btn-alert)}.log-viewer__line--warning:before{background:var(--btn-warning)}.log-viewer__line--raw{padding:5px 10px;background:#24292e;border-bottom:none;font-family:SFMono-Regular,Menlo,Monaco,Consolas,Liberation Mono,Courier New,monospace;color:#f6f8fa;font-size:.8em;line-height:1.5;white-space:pre-wrap}.log-viewer__line--raw:hover{background:#2f363d}.log-viewer__more{display:flex;justify-content:center;padding:20px}.log-viewer__content,.log-viewer__meta{padding:10px 20px}.log-viewer__content--header,.log-viewer__meta--header{padding:0 20px!important}.log-viewer__meta{padding-bottom:0;flex-shrink:0;font-style:italic}.log-viewer__meta--header{font-style:normal}@media(min-width:600px){.log-viewer__meta{width:220px;padding-bottom:10px}}.log-viewer__content{flex-grow:1}.log-viewer__datetime{display:block}@media(min-width:600px){.log-viewer__datetime{margin-bottom:1em}}.log-viewer__badge{display:inline-block;margin-right:10px;padding:1px 4px;background:var(--border);border-radius:var(--border-radius);font-size:.9em;font-weight:400;text-transform:lowercase}.log-viewer__badge--desktop{display:none}@media(min-width:600px){.log-viewer__badge--desktop{display:inline-block}.log-viewer__badge--mobile{display:none}}.log-viewer__badge--channel{padding-top:0;padding-bottom:0;border:1px solid var(--border);background:var(--white)}.log-viewer__badge--level-warning{background:var(--btn-warning);color:#fff}.log-viewer__badge--level-alert,.log-viewer__badge--level-critical,.log-viewer__badge--level-emergency,.log-viewer__badge--level-error{background:var(--btn-alert);color:#fff}.log-viewer__message span:nth-child(2n){font-weight:600;color:var(--black)}.log-viewer__details{display:flex;align-items:center;margin-top:1em}.log-viewer__toggle{margin-right:10px;padding:0;border:none;background:none;color:var(--link);text-decoration:none;cursor:pointer}.log-viewer__toggle:hover{text-decoration:underline}.log-viewer__json{margin:10px 0 0}.invite-user__check{text-align:center}.invite-user__check svg{width:60px;height:60px;fill:var(--btn-primary)}.invite-user__check,.invite-user__text{margin-bottom:1em}.invite-user__url{display:block;margin-top:2em}.invite-user__help{display:block;margin-top:1em;font-size:12px}.invite-user__clipboard{margin:1em 0}.widget-text input::-webkit-inner-spin-button,.widget-text input::-webkit-outer-spin-button{display:none}.widget-text input[type=number]{-webkit-appearance:textfield!important;-moz-appearance:textfield!important;appearance:textfield!important}.widget-text--password input{padding-right:40px!important}.widget__password-toggle{position:absolute;right:8px;bottom:2px;padding:0;margin:0;background:none;border:none;cursor:pointer}.widget__password-toggle--hidden svg{fill:var(--btn-primary)}.widget__password-toggle--visible svg{fill:var(--btn)}.setup-totp__qr{margin:2em;text-align:center}.setup-totp__qr svg{width:200px;height:200px}.setup-totp__uri{display:block;margin:1em 0;word-break:break-all}.setup-totp .sk-circle{margin:20px auto}.disable-totp__text{margin-bottom:1em}.change-password .widget{margin:1em 0 0}.user-manager__loading{margin:100px 0;text-align:center;font-size:20px;line-height:1.5em}.user-manager__loading .sk-circle{width:100px;height:100px;margin:0 auto 40px}.user-manager__list{display:grid;grid-template:1fr/1fr;gap:20px}@media(min-width:600px){.user-manager__list{grid-template:1fr/repeat(2,1fr)}}@media(min-width:800px){.user-manager__list{grid-template:1fr/repeat(3,1fr)}}@media(min-width:1200px){.user-manager__list{grid-template:1fr/repeat(4,1fr)}}.user-manager__item{position:relative;overflow:hidden;display:flex;flex-direction:column;padding:16px;background:var(--tiles-bg);border:1px solid 1px solid var(--tiles-bdr);border-radius:14px}.user-manager__ribbon{position:absolute;top:18px;right:-22px;width:100px;font-size:12px;color:#fff;font-weight:600;line-height:1.5;text-align:center;background:var(--btn-info);transform-origin:center center;transform:rotate(45deg)}.user-manager__ribbon--hint{cursor:help}.user-manager__ribbon--primary{background:var(--btn-primary)}.user-manager__ribbon--warning{background:var(--btn-warning)}.user-manager__ribbon--alert{background:var(--btn-alert)}.user-manager__new{margin-top:60px;text-align:center}.user-manager__spacer{flex-grow:1;min-height:1em}.user-manager__username{font-size:18px;font-weight:600}.user-manager__scope{margin-top:1em}.user-manager .widget-button{margin-top:5px}.view-error{position:fixed;left:0;right:0;top:0;bottom:0;padding:10px;color:#e8e8e8;font-family:SFMono-Regular,Menlo,Monaco,Consolas,Liberation Mono,Courier New,monospace;font-size:13px;line-height:1.2;background-color:rgba(0,0,0,.851);background-position:0 0;background-repeat:repeat;z-index:9998}.view-error,.view-error__close{display:flex;justify-content:center;align-items:center}.view-error__close{position:absolute;top:15px;right:10px;width:35px;height:35px;background:none;border:none;cursor:pointer;z-index:10}.view-error__close:hover{border:1px solid #fff}.view-error__content{display:flex;flex-direction:column;align-items:center;max-width:800px;max-height:100vh;line-height:1.5;text-align:center}.view-error__icon{display:block;height:100px;margin:2em 0;fill:#fff}.view-error__status{margin-bottom:1em;padding:2px 4px;background-color:#e36049;border-radius:var(--border-radius)}.view-error__headline{margin:0;font-size:1em;line-height:1.5}.view-error__status a{color:#e8e8e8;text-decoration:underline}.view-error__details{display:block;margin-top:2em;white-space:pre-line}.view-error__debug{align-self:flex-start;max-height:60vh;overflow-y:auto;margin-top:2em;text-align:left;white-space:pre-line}.view-error__actions{margin:4em 0;text-align:center}.view-error__link{margin:10px;padding:10px 20px;border:1px solid #fff;border-radius:4px;color:#fff}.button-menu{position:relative}.button-menu__primary.widget-button{float:left;width:calc(100% - 39px);border-top-right-radius:0;border-bottom-right-radius:0}.button-menu__more.widget-button{float:right;width:38px;padding:7px;border-top-left-radius:0;border-bottom-left-radius:0}.button-menu__more.widget-button svg{width:24px;height:24px}.button-menu__menu{display:flex;flex-direction:column;position:absolute;top:38px;right:0;width:auto;z-index:100;background:var(--form-bg);border-radius:var(--border-radius)}.button-menu__menu:before{content:"";position:absolute;top:-5px;right:15px;width:0;height:0;border-right:none;border-bottom:none;border-left:5px solid transparent;border-right:5px solid transparent;border-bottom:5px solid var(--form-bg)}.button-menu__menu:focus{outline:none}.button-menu__menu button{padding:8px 16px;background:none;border:none;text-align:left;white-space:nowrap;border-bottom:1px solid var(--border);cursor:pointer}.button-menu__menu button:hover{color:var(--text);background:var(--focus)}.button-menu__menu button:first-child{border-top-left-radius:2px;border-top-right-radius:2px}.button-menu__menu button:last-child{border-bottom:none;border-bottom-left-radius:2px;border-bottom-right-radius:2px}.button-menu__menu .link-menu{margin-top:3px}.console-operation{position:relative;padding:0 16px;text-align:left;font-size:12px;color:#959da5}.console-operation__summary{margin-left:13px;padding:8px;box-sizing:border-box}.console-operation__summary--console{margin-left:0}.console-operation summary{cursor:pointer}.console-operation__status{display:inline-block;position:relative;box-sizing:border-box;padding-right:8px;width:24px;height:18px;text-align:center;vertical-align:middle}.console-operation__icon{position:absolute;left:0;top:0}.console-operation__icon--skipped{fill:#666b71}.console-operation__icon--pending{fill:#dbab0a}.console-operation__icon--active{fill:#dbab0a;animation:console-active 1s linear infinite}@keyframes console-active{0%{transform:rotate(0deg)}50%{transform:rotate(180deg)}to{transform:rotate(359deg)}}.console-operation__icon--success{fill:var(--btn-primary)}.console-operation__icon--error{fill:var(--btn-alert)}.console-operation__label{display:inline-block;overflow:hidden;max-width:750px;vertical-align:top}.console-operation__title{display:inline;margin:0;color:#fff}.console-operation__title--disabled{text-decoration:line-through}.console-operation__description{display:inline;margin:0 0 0 10px}.console-operation__console{position:relative;overflow-y:auto;max-height:280px}.console-operation__lines{padding:8px 0 16px;font-family:SFMono-Regular,Menlo,Monaco,Consolas,Liberation Mono,Courier New,monospace;color:#f6f8fa;line-height:1.5;white-space:pre-wrap;word-break:break-word;overflow-wrap:break-word}.console-operation__line{display:flex}.console-operation__line:hover{background-color:#2f363d}.console-operation__line-number{display:inline-block;overflow:hidden;width:48px;min-width:48px;color:#959da5;text-align:right;text-overflow:ellipsis;white-space:nowrap;vertical-align:middle;-webkit-user-select:none;-moz-user-select:none;user-select:none}.console-operation__line-content{display:inline-block;margin-left:16px;vertical-align:middle}.console-operation__scroll{position:sticky;left:0;right:0;display:flex;justify-content:center;align-items:flex-end;width:100%;height:30px;padding:0;border:none;cursor:pointer}.console-operation__scroll svg{fill:#fff;width:16px;height:16px}.console-operation__scroll--top{top:0;background:linear-gradient(#24292e,rgba(36,41,46,.502) 50%)}.console-operation__scroll--top svg{transform:rotate(180deg)}.console-operation__scroll--bottom{bottom:0;background:linear-gradient(rgba(36,41,46,.502),#24292e 50%)}.console-operation__scroll--bottom svg{transform:rotate(0deg)}.console{background:#24292e;border-radius:8px}.console__header{display:flex;flex-wrap:nowrap;justify-content:space-between;align-items:center;padding:12px 12px 12px 24px;border-bottom:1px solid #444d56}.console__headline{margin:0;font-size:inherit;line-height:1.5;color:#fff}.console__description{color:#959da5;font-size:12px}.console__actions{display:flex;flex-wrap:nowrap;align-items:center}.console__action,.console__action>button{height:30px!important;line-height:30px!important;width:auto!important;min-width:0;margin:0 2px;padding:0 5px!important;border:none!important}.console__action:hover,.console__action>button:hover{background-color:#2f363d!important}.console__action--active,.console__action>button--active{background-color:#586069!important}.console__operations{padding:20px 0}.view-task__header{margin-left:auto;margin-right:auto;padding:40px 0;text-align:center}.view-task__icon{background:var(--contao);border-radius:10px;padding:10px}.view-task__headline{margin-top:15px;font-size:36px;font-weight:100;line-height:1}.view-task__description{margin:0;font-weight:600}.view-task__actions{display:flex;flex-direction:column;justify-content:center;align-items:center;margin-top:2em}@media(min-width:960px){.view-task__actions{flex-direction:row}}.view-task .widget-button{width:280px;height:35px;margin:5px;padding:0 30px;line-height:35px}@media(min-width:960px){.view-task .widget-button{width:auto}}.view-task__main{margin:0 50px 50px}.view-task__loading{width:30px;margin:40px auto}.view-task__loading .sk-circle{width:30px;height:30px}.view-task__sponsor{margin:-30px 50px 50px;text-align:center}@media(min-width:960px){.view-task__sponsor br{display:none}}.view-task__donate{position:relative;top:5px;margin-left:.5em;line-height:0}:root{--text:#535353;--link:#f47c00;--placeholder:#a9a9a9;--body-bg:#ebe6db;--link-footer:#2a7887;--tiles-bg:#fff;--tiles-bdr:#ddd3bc;--popup-hl-bg:#f47c00;--popup-bg:#fff;--popup-header:#fff;--popup-overlay-bg:hsla(41,29%,89%,.35);--tab-content:#f8f9fb;--highlight-bg:#ff0;--highlight-color:#535353;--shadow:#ccbfa2;--contao:#f47c00;--badge-bg:var(--contao);--ad-shadow:0 1px 5px 1px rgba(0,0,0,.2);--black:#000;--funding:#ea4aaa;--funding-rgb:234,74,170;--form-bg:#fff;--border:#ccc;--border--light:#e9eef1;--focus:#f9f9f9;--clr-btn:#fff;--btn:#737373;--btn-active:#666;--btn-primary:#31a64b;--btn-primary-active:#2b9242;--btn-warning:#db8c41;--btn-warning-active:#d77f2c;--btn-alert:#db5041;--btn-alert-active:#d73c2c;--btn-info:#6a8ca6;--btn-info-active:#5c7f9a;--btn-funding:#ea4aaa;--btn-funding-active:#e7339f;--btn-disabled:#ccc;--hint-bg:#e8c8bc;--hint-rgb:232,200,188;--hint-link:#bd2e20;--header-bg:#e5dfcf;--header-bdr:#dcd8cc;--footer-bdr:#bbb;--svg--link-blank:url(../img/link-blank.eb57b3fa.svg);--svg--private:url(../img/private.a1c65662.svg);--svg--updated:url(../img/updated.3b47bebb.svg);--svg--downloads:url(../img/downloads.c1db2a9e.svg);--svg--favers:url(../img/favers.056e2836.svg);--svg--language:url(../img/language.582b2920.svg);--svg--color-scheme:url(../img/color_scheme.d527d153.svg)}html[data-color-scheme=dark]{color-scheme:dark;--text:#ddd;--link:#f47c00;--body-bg:#0f0f11;--tiles-bg:#212227;--tiles-bdr:#303236;--popup-hl-bg:#292c32;--popup-bg:#1b1d21;--popup-overlay-bg:rgba(0,0,0,.35);--tab-content:#212227;--highlight-bg:#f47c00;--highlight-color:#fff;--shadow:transparent;--badge-bg:var(--border--light);--ad-shadow:none;--btn:#3c3f4c;--btn-active:#25272f;--black:#fff;--form-bg:#151619;--border:#44464b;--border--light:#2e2e34;--focus:#1e2024;--btn-info:#25455f;--btn-info-active:#253846;--btn-disabled:#151517;--opacity-disabled:0.5;--hint-rgb:57,9,20;--header-bg:#1b1d21;--header-bdr:#1b1d21;--footer-bdr:#414448;--svg--link-blank:url(../img/link-blank--dark.07eeaee6.svg);--svg--private:url(../img/private--dark.41b90022.svg);--svg--updated:url(../img/updated--dark.c21fdd5b.svg);--svg--downloads:url(../img/downloads--dark.034bf7a3.svg);--svg--favers:url(../img/favers--dark.4765f7d4.svg);--svg--language:url(../img/language--dark.a24e849e.svg);--svg--color-scheme:url(../img/color_scheme--dark.ef0f0aed.svg)}html[data-color-scheme=dark] #contao-network{background:#292c32!important;color:#ddd!important}html{box-sizing:border-box}*,:after,:before{box-sizing:inherit}#app,body,html{height:100%}blockquote,body,figure,form,p{margin:0;padding:0}article,aside,figcaption,figure,footer,header,main,nav,section{display:block}body,div,fieldset,form,h1,h2,h3,h4,h5,h6,html,p{-webkit-text-size-adjust:none;-moz-text-size-adjust:none;text-size-adjust:none}body{background:var(--body-bg);overflow-y:hidden}#app{overflow-y:scroll}fieldset{border:none;margin:0;padding:0}legend{-webkit-padding-start:0;-webkit-padding-end:0}figure{line-height:0}body,button,input,textarea{font:300 14px/1.4 -apple-system,system-ui,Segoe UI,Roboto,Oxygen-Sans,Ubuntu,Cantarell,Helvetica Neue,sans-serif;color:var(--text)}strong{font-weight:600}code{font-family:SFMono-Regular,Menlo,Monaco,Consolas,Liberation Mono,Courier New,monospace}input,select,textarea{font-size:99%}input:disabled,select:disabled,textarea:disabled{color:var(--text);-webkit-text-fill-color:var(--text);cursor:text}input::-ms-clear,input::-ms-reveal,select::-ms-clear,select::-ms-reveal,textarea::-ms-clear,textarea::-ms-reveal{display:none}input::-moz-placeholder,select::-moz-placeholder,textarea::-moz-placeholder{color:var(--placeholder);-webkit-text-fill-color:var(--placeholder)}input::placeholder,select::placeholder,textarea::placeholder{color:var(--placeholder);-webkit-text-fill-color:var(--placeholder)}.invisible{border:0;clip:rect(0 0 0 0);height:1px;margin:-1px;overflow:hidden;padding:0;position:absolute;width:1px}.clearfix{*zoom:1}.clearfix:after,.clearfix:before{display:table;content:"";line-height:0}.clearfix:after{clear:both}h1,h2,h3,h4,h5,h6{font-size:inherit;line-height:inherit;font-weight:600;margin:0}a{color:var(--link);text-decoration:none}a:hover{text-decoration:underline}h1{font-size:18px;line-height:30px;margin-bottom:10px}@keyframes input-error{0%{left:0}25%{left:-5px}75%{left:5px}to{left:0}}.widget{position:relative}.widget__error{display:none;position:absolute;left:0;right:0;margin:0;padding:4px 10px;color:var(--clr-btn);background:var(--btn-alert);border-radius:2px;transform:translateY(6px);z-index:10;white-space:pre-line}.widget__error:after,.widget__error:before{bottom:100%;left:30px;border:solid transparent;content:" ";height:0;width:0;position:absolute;pointer-events:none}.widget__error:after{border-bottom-color:var(--btn-alert);border-width:3px;margin-left:-3px}.widget__error:before{border-bottom-color:var(--btn-alert);border-width:5px;margin-left:-5px}input:focus+*+.widget__error,input:focus+.widget__error,input:hover+*+.widget__error,input:hover+.widget__error,select:hover+.widget__error{display:block}.widget__description{margin-top:2px;font-size:12px}input:not([type=checkbox]):not([type=radio]),select{position:relative;width:100%;height:38px;padding:0 20px;background:var(--form-bg);border:1px solid var(--border);border-radius:6px;color:var(--text);-webkit-appearance:none;-moz-appearance:none;appearance:none}input:not([type=checkbox]):not([type=radio]):focus,select:focus{outline:none;background-color:var(--focus)}.widget--validate input:not([type=checkbox]):not([type=radio]):not(:-moz-placeholder):valid,.widget--validate select:not(:-moz-placeholder):valid{border-color:var(--btn-primary)}.widget--validate input:not([type=checkbox]):not([type=radio]):not(:placeholder-shown):valid,.widget--validate select:not(:placeholder-shown):valid{border-color:var(--btn-primary)}.widget--validate input:not([type=checkbox]):not([type=radio]):not(:-moz-placeholder):invalid,.widget--validate select:not(:-moz-placeholder):invalid{border-color:var(--btn-alert)}.widget--validate input:not([type=checkbox]):not([type=radio]):not(:placeholder-shown):invalid,.widget--validate select:not(:placeholder-shown):invalid{border-color:var(--btn-alert)}.widget--error input:not([type=checkbox]):not([type=radio]),.widget--error select{border-color:var(--btn-alert);animation:input-error .15s linear 3}select{padding-right:30px}.widget-select:after{position:absolute;right:12px;bottom:16px;width:0;height:0;border-left:6px solid transparent;border-right:6px solid transparent;border-top:6px solid var(--border);content:"";pointer-events:none}.widget-button{display:inline-block;width:100%;height:38px;padding:0;border:none;background-color:var(--btn);color:var(--clr-btn);font-weight:600;line-height:38px;text-decoration:none;text-align:center;white-space:nowrap;cursor:pointer;border-radius:5px}.widget-button:active,.widget-button:hover{background-color:var(--btn-active)}.widget-button--inline{width:auto!important;min-width:100px;padding:0 20px}.widget-button--transparent{background:transparent}.widget-button--small{height:28px;width:auto!important;min-width:0;padding:0 15px;font-size:13px;line-height:28px;font-weight:300}.widget-button--small:before,.widget-button--small>:before{top:3px!important;width:15px!important;height:15px!important;margin-right:6px!important;background-size:15px 15px!important}.widget-button--primary{--btn:var(--btn-primary);--btn-active:var(--btn-primary-active)}.widget-button--warning{--btn:var(--btn-warning);--btn-active:var(--btn-warning-active)}.widget-button--alert{--btn:var(--btn-alert);--btn-active:var(--btn-alert-active)}.widget-button--info{--btn:var(--btn-info);--btn-active:var(--btn-info-active)}.widget-button--funding{--btn:var(--btn-funding);--btn-active:var(--btn-funding-active)}.widget-button--add:before{background-image:url(../img/button-add.759df12e.svg)}.widget-button--check:before{background-image:url(../img/button-check.7a3b5ada.svg)}.widget-button--clipboard:before{background-image:url(../img/button-clipboard.9ef63d39.svg)}.widget-button--cloud:before{background-image:url(../img/button-cloud.bc42f267.svg)}.widget-button--cloud-off:before{background-image:url(../img/button-cloud-off.dd8ba18e.svg)}.widget-button--console:before{background-image:url(../img/button-console.05dcdfc4.svg)}.widget-button--database:before{background-image:url(../img/button-database.5282fc7e.svg)}.widget-button--download:before{background-image:url(../img/button-download.e1ba6f25.svg)}.widget-button--edit:before{background-image:url(../img/button-edit.40a4be06.svg)}.widget-button--gear:before{background-image:url(../img/button-gear.a2dc1f09.svg)}.widget-button--hide:before{background-image:url(../img/button-hide.d23f6533.svg)}.widget-button--details:before{background-image:url(../img/button-details.161475b3.svg)}.widget-button--link:before{background-image:url(../img/button-link.dd42e161.svg)}.widget-button--lock:before{background-image:url(../img/button-lock.98988f08.svg)}.widget-button--maintenance:before{background-image:url(../img/button-maintenance.93830369.svg)}.widget-button--more:before{background-image:url(../img/button-more.e3eb2622.svg)}.widget-button--power:before{background-image:url(../img/button-power.298a8072.svg)}.widget-button--run:before{background-image:url(../img/button-run.b6310c5a.svg)}.widget-button--save:before{background-image:url(../img/button-save.3b5224de.svg)}.widget-button--search:before{background-image:url(../img/button-search.44ce1d4b.svg)}.widget-button--show:before{background-image:url(../img/button-show.2336e1d9.svg)}.widget-button--trash:before{background-image:url(../img/button-trash.855f57fa.svg)}.widget-button--unlock:before{background-image:url(../img/button-unlock.51b76e07.svg)}.widget-button--update:before{background-image:url(../img/button-update.ad79c617.svg)}.widget-button--upload:before{background-image:url(../img/button-upload.ca8e9cfc.svg)}.widget-button .icon-selector:before,.widget-button--add:before,.widget-button--check:before,.widget-button--clipboard:before,.widget-button--cloud-off:before,.widget-button--cloud:before,.widget-button--console:before,.widget-button--database:before,.widget-button--details:before,.widget-button--download:before,.widget-button--edit:before,.widget-button--gear:before,.widget-button--hide:before,.widget-button--link:before,.widget-button--lock:before,.widget-button--maintenance:before,.widget-button--more:before,.widget-button--power:before,.widget-button--run:before,.widget-button--save:before,.widget-button--search:before,.widget-button--show:before,.widget-button--trash:before,.widget-button--unlock:before,.widget-button--update:before,.widget-button--upload:before{position:relative;display:inline-block;top:5px;width:20px;height:20px;margin-right:8px;background-position:50%;background-repeat:no-repeat;background-size:20px 20px;content:""}.widget-button .icon-selector:empty:before,.widget-button--add:empty:before,.widget-button--check:empty:before,.widget-button--clipboard:empty:before,.widget-button--cloud-off:empty:before,.widget-button--cloud:empty:before,.widget-button--console:empty:before,.widget-button--database:empty:before,.widget-button--details:empty:before,.widget-button--download:empty:before,.widget-button--edit:empty:before,.widget-button--gear:empty:before,.widget-button--hide:empty:before,.widget-button--link:empty:before,.widget-button--lock:empty:before,.widget-button--maintenance:empty:before,.widget-button--more:empty:before,.widget-button--power:empty:before,.widget-button--run:empty:before,.widget-button--save:empty:before,.widget-button--search:empty:before,.widget-button--show:empty:before,.widget-button--trash:empty:before,.widget-button--unlock:empty:before,.widget-button--update:empty:before,.widget-button--upload:empty:before{margin-right:0!important}.widget-button:empty{min-width:auto;padding:0 10px}.widget-button:empty:before{margin-right:0!important}.widget-button:hover{text-decoration:none}.widget-button.disabled,.widget-button:disabled{background-color:var(--btn-disabled)!important;border-color:var(--btn-disabled)!important;cursor:not-allowed;opacity:var(--opacity-disabled,1)}.widget-button.disabled{pointer-events:none}.widget-button--anchor{height:auto;background:none!important;line-height:inherit;font-weight:inherit;color:var(--link);text-decoration:none;cursor:pointer}.widget-button--anchor:hover{text-decoration:underline!important}.widget-button--anchor.disabled,.widget-button--anchor:disabled{background:none!important}label{padding:0}.widget--required label:after{margin-left:2px;content:"*";color:var(--btn-alert)}input:-webkit-autofill,select:-webkit-autofill{-webkit-text-fill-color:var(--text);-webkit-box-shadow:inset 0 0 0 1000px hsla(0,0%,100%,0);-webkit-transition:background-color 5000s ease-in-out 0s;transition:background-color 5000s ease-in-out 0s}.animate-initializing{animation:initializing 1s linear infinite}@keyframes initializing{0%{opacity:.5}50%{opacity:1}to{opacity:.5}}.animate-blur-in{z-index:-1;opacity:.5;filter:blur(4px);transition:opacity .35s,filter .5s}.animate-blur-out{opacity:1;transition:opacity .35s}.animate-fade-enter-active,.animate-fade-leave-active{transition-duration:.2s;transition-property:opacity;transition-timing-function:ease}.animate-fade-enter,.animate-fade-leave-active{opacity:0}.animate-flip-enter-active,.animate-flip-leave-active{transform-style:preserve-3d;backface-visibility:hidden;transition-duration:.5s;transition-property:transform,opacity}.animate-flip-leave-active{transform:perspective(600px) rotateY(0deg);opacity:1}.animate-flip-leave-to{transform:perspective(600px) rotateY(90deg);transition-timing-function:ease-in;opacity:0}.animate-flip-enter-active{transform:perspective(400px) rotateY(270deg);opacity:0}.animate-flip-enter-to{transform:perspective(400px) rotateY(1turn);transition-timing-function:ease-out;opacity:1}:root{--header-main-bg:#fff;--footer-fragment-bdr:#eee;--table-odd-bg:#f5f9fa;--border-radius:6px;--log-header-bg:var(--shadow)}html[data-color-scheme=dark]{--header-main-bg:#292c32;--footer-fragment-bdr:var(--footer-bdr);--table-odd-bg:var(--tiles-bg);--link-footer:#fff;--hint-bg:#151619;--hint-rgb:21,22,25;--log-header-bg:var(--btn)}html[data-color-scheme=dark] .vjs-tree-node:hover{background-color:#2b3439}.color-scheme--light,html[data-color-scheme=dark] .color-scheme--dark{display:initial}.color-scheme--dark,html[data-color-scheme=dark] .color-scheme--light{display:none}.app-hint{position:absolute;top:0;left:0;right:0;height:27px;padding:4px 8px;background:var(--btn-info);color:#fff;text-align:center;z-index:100}.app-hint--warning{background:var(--btn-warning)}.app-hint--alert{background:var(--btn-alert)}.app-hint__description{display:none}@media(min-width:600px){.app-hint__description{display:inline}}.app-hint__link{margin:0;padding:0;background:none;border:none;color:#fff;text-decoration:underline;cursor:pointer}.app-hint+div{padding-top:25px}.view-init{display:table;width:100%;height:100%}.view-init__cell{display:table-cell;font-size:1.5em;text-align:center;vertical-align:middle}.config-check__header{max-width:280px;margin-left:auto;margin-right:auto;padding:40px 0;text-align:center}.config-check__icon{background:var(--contao);border-radius:10px;padding:10px}.config-check__headline{margin-top:20px;margin-bottom:25px;font-size:36px;font-weight:100;line-height:1}.config-check__description{text-align:justify}.config-check__form{position:relative;max-width:280px;margin:0 auto 50px}.config-check__form .widget-select,.config-check__form .widget-text{margin-top:20px}.config-check__form .widget-select label,.config-check__form .widget-text label{display:block;margin-bottom:5px;font-weight:400}.config-check__fields{margin-bottom:2em}.config-check__fieldtitle{margin-bottom:.5em;font-size:18px;font-weight:600;line-height:30px}.config-check__fielddesc{margin-bottom:1em}.config-check__issues{margin-bottom:1em;color:var(--btn-alert)}.config-check__issues p{font-weight:600}.config-check__issues ul{margin:0;padding:0}.config-check__issues li{margin:.5em 0 0 25px;padding:0}.config-check .widget-button{margin-bottom:.5em}@media(min-width:960px){.config-check{padding-top:100px}.config-check__header{float:left;width:470px;max-width:none;padding:0 60px 100px}.config-check__form{float:left;width:370px;max-width:none;margin:20px 50px 0;padding-bottom:100px}.config-check__form .widget-select label,.config-check__form .widget-text label{display:block;float:left;width:120px;padding-top:10px;font-weight:400}}.popup-overlay{position:fixed;inset:0;z-index:1000;background:var(--popup-overlay-bg)}@media(min-width:960px){.popup-overlay{padding:20px 0;overflow-y:auto}}.popup-overlay__popup{position:fixed;display:block;top:50%;left:50%;width:500px;max-width:90%;background:var(--popup-bg);z-index:10;opacity:1;transform:translate(-50%,-50%);border-radius:var(--border-radius);overflow:hidden}.popup-overlay__headline{position:relative;margin-bottom:0;padding:7px 30px 6px;background:var(--popup-hl-bg);font-size:18px;color:#fff;font-weight:300;line-height:1.5em;text-align:center}.popup-overlay__headline--primary{background-color:var(--btn-primary)}.popup-overlay__headline--alert{background-color:var(--btn-alert)}.popup-overlay__content{padding:2em 20px}.popup-overlay__actions{display:flex;justify-content:center;gap:10px;flex-wrap:wrap;padding:0 20px 2em}.popup-overlay__actions .widget-button{width:auto;height:35px;padding:0 30px;line-height:35px}@media(min-width:550px){.popup-overlay__actions,.popup-overlay__content{padding-left:40px;padding-right:40px}}.loader__item{float:left;width:16px;height:16px;margin-right:1px;background-color:var(--contao);animation:loading 1.4s ease-in-out infinite both}.loader__item--20{animation-delay:-.64s}.loader__item--40{animation-delay:-.48s}.loader__item--60{animation-delay:-.32s}.loader__item--80{animation-delay:-.16s}@keyframes loading{0%,90%,to{opacity:0}20%{opacity:1}}.loader__text{float:left;width:40px}.sk-circle{width:25px;height:25px;position:relative}.sk-circle .sk-child{width:100%;height:100%;position:absolute;left:0;top:0}.sk-circle .sk-child:before{content:"";display:block;margin:0 auto;width:15%;height:15%;background-color:var(--text);border-radius:100%;animation:sk-circleBounceDelay 1.2s ease-in-out infinite both}.sk-circle .sk-circle2{transform:rotate(30deg)}.sk-circle .sk-circle3{transform:rotate(60deg)}.sk-circle .sk-circle4{transform:rotate(90deg)}.sk-circle .sk-circle5{transform:rotate(120deg)}.sk-circle .sk-circle6{transform:rotate(150deg)}.sk-circle .sk-circle7{transform:rotate(180deg)}.sk-circle .sk-circle8{transform:rotate(210deg)}.sk-circle .sk-circle9{transform:rotate(240deg)}.sk-circle .sk-circle10{transform:rotate(270deg)}.sk-circle .sk-circle11{transform:rotate(300deg)}.sk-circle .sk-circle12{transform:rotate(330deg)}.sk-circle .sk-circle2:before{animation-delay:-1.1s}.sk-circle .sk-circle3:before{animation-delay:-1s}.sk-circle .sk-circle4:before{animation-delay:-.9s}.sk-circle .sk-circle5:before{animation-delay:-.8s}.sk-circle .sk-circle6:before{animation-delay:-.7s}.sk-circle .sk-circle7:before{animation-delay:-.6s}.sk-circle .sk-circle8:before{animation-delay:-.5s}.sk-circle .sk-circle9:before{animation-delay:-.4s}.sk-circle .sk-circle10:before{animation-delay:-.3s}.sk-circle .sk-circle11:before{animation-delay:-.2s}.sk-circle .sk-circle12:before{animation-delay:-.1s}@keyframes sk-circleBounceDelay{0%,80%,to{transform:scale(0)}40%{transform:scale(1)}}.widget-button .loader{width:25px;margin:0 auto}.widget-button .sk-circle .sk-child:before{background-color:#fff}.loading-button{position:relative}.loading-button>.loader{position:absolute;left:calc(50% - 12.5px);top:calc(50% - 12.5px)}.loading-button>.loading{visibility:hidden}.link-menu{position:absolute;display:grid;grid-template:1fr/1fr;left:50%;gap:2px;margin:0;padding:2px;text-align:center;list-style-type:none;white-space:nowrap;background:var(--form-bg);border-top:3px solid var(--text);border-radius:5px;z-index:100;box-shadow:0 0 1px var(--shadow);outline:none}.link-menu:before{position:absolute;left:50%;top:-7px;width:0;height:0;margin-left:-4px;border-style:solid;border-width:0 3.5px 4px 3.5px;border-color:transparent transparent var(--text) transparent;content:""}.link-menu--align-left{left:0;right:auto}.link-menu--align-left:before{left:17px;right:auto}.link-menu--align-right{left:auto;right:0}.link-menu--align-right:before{left:auto;right:17px}.link-menu--valign-top{bottom:0;border-top:none;border-bottom:3px solid var(--text);box-shadow:0 0 2px var(--shadow)}.link-menu--valign-top:before{top:auto;bottom:-7px;border-width:4px 3.5px 0 3.5px;border-color:var(--text) transparent transparent transparent}.link-menu--contao{border-color:var(--contao)}.link-menu--contao:before{border-bottom-color:var(--contao)}.link-menu--contao.link-menu--valign-top:before{border-bottom-color:transparent;border-top-color:var(--contao)}.link-menu--primary{border-color:var(--btn-primary)}.link-menu--primary:before{border-bottom-color:var(--btn-primary)}.link-menu--primary.link-menu--valign-top:before{border-bottom-color:transparent;border-top-color:var(--btn-primary)}.link-menu--warning{border-color:var(--btn-warning)}.link-menu--warning:before{border-bottom-color:var(--btn-warning)}.link-menu--warning.link-menu--valign-top:before{border-bottom-color:transparent;border-top-color:var(--btn-warning)}.link-menu--alert{border-color:var(--btn-alert)}.link-menu--alert:before{border-bottom-color:var(--btn-alert)}.link-menu--alert.link-menu--valign-top:before{border-bottom-color:transparent;border-top-color:var(--btn-alert)}.link-menu__item{margin:0;padding:0;display:block}.link-menu__action{display:block;width:100%;border-radius:5px;padding:8px 16px;color:var(--text);font-size:inherit;text-align:center;background:none;border:none;cursor:pointer}.link-menu__action:hover{color:var(--text);background:var(--focus);text-decoration:none}.link-menu__action--active{font-weight:600;background:var(--focus)}.footer-languages{position:relative;display:inline-block}.footer-languages__toggle{width:auto;height:auto;padding:0 0 0 25px;background:transparent;color:var(--text);font-size:12px;font-weight:300;line-height:20px;background:var(--svg--language) left center no-repeat;background-size:20px 20px;border:none;cursor:pointer}.footer-languages__toggle:hover{color:var(--black)}.footer-languages__menu{display:grid;grid-template:auto/1fr 1fr;bottom:25px;white-space:nowrap;transform:translateX(-50%)}.footer-languages__menu button{margin:0;padding:6px;text-align:left;font-size:inherit}.theme-switch{position:relative;display:inline-block}.theme-switch button{width:auto;height:auto;padding:0 0 0 24px;background:transparent;color:var(--text);font-size:12px;font-weight:300;line-height:20px;background:var(--svg--color-scheme) left center no-repeat;background-size:20px 20px;border:none;cursor:pointer}.theme-switch button:hover{color:var(--black)}.package-logo--fallback[data-v-9c1c5f6c]{display:flex;justify-content:center;align-items:center}svg[data-v-9c1c5f6c]{width:80px;height:80px;fill:#ccc}.discover-package{display:flex;flex-direction:column;position:relative;overflow:hidden;background:var(--tiles-bg);border:1px solid var(--tiles-bdr);border-radius:14px}.discover-package.is--hint{border-color:var(--border--light)}.discover-package.is--hint .discover-package__inside>*{opacity:.65}.discover-package__hint{position:relative;background:var(--border--light);padding:8px 16px;font-weight:400;font-size:12px;line-height:1.2;z-index:1}.discover-package__hint p a{display:inline-block;padding-right:10px}.discover-package__hint p a:first-child{margin-left:10px}.discover-package__hint p a:not(:first-child):before{padding-right:10px;content:"|"}.discover-package__inside{flex-grow:1;padding:16px}.discover-package__abandoned{display:inline-block;margin-bottom:1em;padding:2px 5px;color:#fff;font-size:12px;font-weight:600;background:var(--btn-alert);cursor:help;z-index:10}@media(min-width:600px){.discover-package__abandoned{position:absolute;top:20px;left:-25px;padding:2px 30px;border-top:1px solid var(--btn-alert-active);transform:rotate(-45deg)}}.discover-package__icon{border-radius:6px;height:60px;width:60px;background:#f7f7f7;margin:0 auto 10px;position:absolute;right:16px}.discover-package__icon>figure{display:flex;align-items:center;justify-content:center;height:100%;max-height:140px}.discover-package__icon img,.discover-package__icon svg{border-radius:4px;width:50px;height:50px;max-height:100%;-o-object-fit:contain;object-fit:contain}.discover-package__details{display:flex;flex-direction:column;justify-content:space-between;min-height:96px}.discover-package__headline{margin-bottom:.2em;line-height:1;overflow-wrap:break-word;margin-right:70px}.discover-package__headline em{background-color:var(--highlight-bg);color:var(--highlight-color);font-style:normal}.discover-package__versions{display:flex;flex-wrap:wrap;gap:5px;list-style:none;margin:5px 0;padding:0}.discover-package__version{display:inline-flex;justify-content:center;padding:3px 5px;border-radius:4px;line-height:1;min-width:40px;font-size:13px;color:#fff;background:var(--badge-bg);pointer-events:none}.discover-package__description{display:-webkit-box;overflow:hidden;-webkit-line-clamp:2;-webkit-box-orient:vertical;margin-bottom:1em;margin-right:70px}.discover-package__description em{background-color:var(--highlight-bg);color:var(--highlight-color);font-style:normal}.discover-package__more{display:flex;flex-flow:row wrap;align-items:flex-end;flex-grow:1;gap:4px;line-height:28px}.discover-package__counts{flex-grow:1;justify-content:flex-start}.discover-package__count{display:inline-block;margin-right:15px;padding-left:18px;font-size:13px;background-position:0 50%;background-repeat:no-repeat;background-size:13px 13px}.discover-package__count--private{background-image:var(--svg--private)}.discover-package__count--updated{background-image:var(--svg--updated)}.discover-package__count--downloads{background-image:var(--svg--downloads)}.discover-package__count--favers{background-image:var(--svg--favers)}.discover-package__actions{flex-grow:1;display:flex;justify-content:flex-end;gap:8px}@media(max-width:599.98px){.discover-package__headline-container{display:flex;flex-direction:column-reverse}}@media(min-width:600px){.discover-package__inside{text-align:initial;display:flex;padding:0}.discover-package__icon{width:130px;height:100%;min-height:130px;margin:0;border-radius:0;position:revert;right:revert}.discover-package__icon img{width:100px;height:100px}.discover-package__icon svg{width:90px;height:90px}.discover-package__details{padding:16px;height:100%;min-height:90px;max-width:calc(100% - 130px);flex:1}.discover-package__versions{float:right;margin:-3px 0 0 16px}.discover-package__description,.discover-package__headline{margin-right:0}.discover-package__more{flex-direction:row}.discover-package__actions{justify-content:end}}.vueperslide{white-space:normal;background-size:cover;flex-shrink:0;display:block;width:100%;position:relative}.vueperslide--clone-1{position:absolute;top:0;bottom:0;right:100%}.vueperslides--rtl .vueperslide--clone-1{right:auto;left:100%}.vueperslide[href]{-webkit-user-drag:none}.vueperslide__image{background-size:cover}.vueperslide__image,.vueperslide__loader{position:absolute;top:0;left:0;right:0;bottom:0}.vueperslide__loader{display:flex;flex-direction:column;align-items:center;justify-content:center}.vueperslide__content-wrapper:not(.vueperslide__content-wrapper--outside-top):not(.vueperslide__content-wrapper--outside-bottom){height:100%;margin:auto}.vueperslides--fade .vueperslide{position:absolute;top:0;left:0;right:0;bottom:0;opacity:0;transition:opacity ease-in-out;transition-duration:inherit}.vueperslides--fade .vueperslide--active,.vueperslides--fade .vueperslide--visible{z-index:1;opacity:1}.vueperslides--slide-image-inside .vueperslide{overflow:hidden}.vueperslides--3d .vueperslide{position:absolute;z-index:-1;height:100%}.vueperslides--3d .vueperslide--active,.vueperslides--3d .vueperslide--next-slide,.vueperslides--3d .vueperslide--previous-slide{z-index:0}.vueperslides--3d .vueperslide--active{z-index:1}.vueperslides--3d .vueperslide[face=front]{transform:rotateY(90deg) translate(-50%) rotateY(-90deg)}.vueperslides--3d .vueperslide[face=right]{transform:rotateY(90deg) translate(50%);transform-origin:100% 0}.vueperslides--3d .vueperslide[face=back]{transform:rotateY(270deg) translate(-50%) rotateY(-90deg)}.vueperslides--3d .vueperslide[face=left]{transform:rotateY(270deg) translate(-50%);transform-origin:0 0}.vueperslides:not(.no-shadow):not(.vueperslides--3d) .vueperslides__parallax-wrapper:after,.vueperslides:not(.no-shadow):not(.vueperslides--3d) .vueperslides__parallax-wrapper:before{content:"";position:absolute;bottom:100%;left:-1em;right:-1em;height:2em;box-shadow:0 0 20px #00000040;z-index:2}.vueperslides:not(.no-shadow):not(.vueperslides--3d) .vueperslides__parallax-wrapper:after{top:100%;bottom:auto}.vueperslides__arrows{color:#fff}.vueperslides__arrows--outside{color:currentColor}.vueperslides__arrow{top:50%;background-color:transparent;border:none;opacity:.7}.vueperslides--rtl .vueperslides__arrow--next,.vueperslides__arrow--prev{right:auto;left:.5em}.vueperslides--rtl .vueperslides__arrow--prev,.vueperslides__arrow--next{left:auto;right:.5em}.vueperslides__arrow:hover{opacity:1}.vueperslides--rtl .vueperslides__arrows--outside .vueperslides__arrow--next,.vueperslides__arrows--outside .vueperslides__arrow--prev{right:auto;left:-3.5em}.vueperslides--rtl .vueperslides__arrows--outside .vueperslides__arrow--prev,.vueperslides__arrows--outside .vueperslides__arrow--next{left:auto;right:-3.5em}.vueperslides__paused{top:.7em;right:.7em;opacity:0;text-shadow:0 0 3px rgba(0,0,0,.4);z-index:1}.vueperslides:hover .vueperslides__paused{opacity:1}.vueperslides__bullets:not(.vueperslides__bullets--outside){color:#fff}.vueperslides__bullet{margin:1.5em .6em;padding:0;border:none;background:none}.vueperslides__bullet .default{width:12px;height:12px;border-radius:12px;border:1px solid currentColor;background-color:transparent;box-shadow:0 0 1px #00000080,0 0 3px #0000004d;transition:.4s ease-in-out;box-sizing:border-box}.vueperslides__bullet .default span{display:none}.vueperslides__bullet--active .default{border-width:6px}.vueperslide,.vueperslide__image{background-position:50%}.vueperslide__video{outline:none}.vueperslide--no-pointer-events:before{content:"";position:absolute;top:0;bottom:0;left:0;right:0}.vueperslide__content-wrapper:not(.vueperslide__content-wrapper--outside-top):not(.vueperslide__content-wrapper--outside-bottom){display:flex;flex:1 1 auto;flex-direction:column;align-items:center;justify-content:center;text-align:center}.vueperslide--has-image-inside .vueperslide__content-wrapper,.vueperslide--has-video .vueperslide__content-wrapper,.vueperslide__content-wrapper.parallax-fixed-content{position:absolute;z-index:2;top:0;bottom:0;left:0;right:0;display:flex;flex-direction:column;justify-content:center;align-items:center;pointer-events:none}.vueperslides{position:relative}.vueperslides--fixed-height .vueperslide,.vueperslides--fixed-height .vueperslides__inner,.vueperslides--fixed-height .vueperslides__parallax-wrapper{height:inherit}.vueperslides--fixed-height .vueperslides__parallax-wrapper{padding-bottom:0!important}.vueperslides--fixed-height.vueperslides--bullets-outside{margin-bottom:4em}.vueperslides__inner{position:relative;-webkit-user-select:none;-moz-user-select:none;user-select:none}.vueperslides__parallax-wrapper{position:relative;overflow:hidden}.vueperslides--3d .vueperslides__parallax-wrapper{overflow:visible}.vueperslides__track{position:absolute;top:0;height:100%;left:0;right:0;overflow:hidden;z-index:1}.vueperslides--parallax .vueperslides__track{height:200%;transform:translateY(0)}.vueperslides--touchable .vueperslides__track{cursor:ew-resize;cursor:grab}.vueperslides--touchable .vueperslides__track--dragging,.vueperslides--touchable .vueperslides__track--mousedown{cursor:grabbing}.vueperslides--3d .vueperslides__track{overflow:visible;perspective:100em}.vueperslides__track-inner{white-space:nowrap;transition:transform .5s ease-in-out;height:100%;display:flex}.vueperslides--no-animation .vueperslides__track-inner{transition-duration:0s!important}.vueperslides--fade .vueperslides__track-inner{white-space:normal;transition:none}.vueperslides--3d .vueperslides__track-inner{transform-style:preserve-3d}.vueperslides__track--mousedown .vueperslides__track-inner{transition:transform .25s ease-in-out!important}.vueperslides__track--dragging .vueperslides__track-inner{transition:none}.vueperslides__arrow{position:absolute;font-size:inherit;color:inherit;text-align:center;transform:translateY(-50%);transition:.3s ease-in-out;cursor:pointer;-webkit-user-select:none;-moz-user-select:none;user-select:none;outline:none;z-index:2;line-height:1}.vueperslides__arrow svg{vertical-align:middle;stroke:currentColor;fill:none;width:3.5em;padding:1em;stroke-width:1;transition:.3s ease-in-out;box-sizing:border-box}.vueperslides__arrow svg:hover{stroke-width:1.3}.vueperslides__paused{position:absolute;transition:.3s ease-in-out}.vueperslides__bullets{display:flex;justify-content:center;position:absolute;bottom:0;left:0;right:0}.vueperslides__bullets--outside{position:relative}.vueperslides__bullet,.vueperslides__bullets button{cursor:pointer;-webkit-user-select:none;-moz-user-select:none;user-select:none;outline:none;z-index:2;display:flex;justify-content:center;align-items:center;color:inherit}.vueperslides__bullet::-moz-focus-inner,.vueperslides__bullets button::-moz-focus-inner{border:0}.vueperslides__fractions{position:absolute;top:.8em;left:.5em;z-index:2;padding:.2em 1em;border:1px solid hsla(0,0%,100%,.5);border-radius:2em;background:#fff3;color:#fff}.vueperslides__progress{position:absolute;top:0;left:0;right:0;z-index:2;height:6px;color:#000000b3}.vueperslides__progress>*{position:absolute;top:0;bottom:0;left:0;background:currentColor;transition:.3s ease-in-out}@media(min-width:1200px){.ads{margin:59px 0 69px}}.ads .link{padding-top:5px;text-align:right}.ads .link a{padding-left:16px;font-size:.8em;color:inherit;background:var(--svg--link-blank) left center no-repeat;background-size:13px 13px}.ads .container{position:relative;background:var(--popup-bg);box-shadow:var(--ad-shadow);border-radius:14px;overflow:hidden}.ads .container a,.ads .container img{display:block}.ads .container img{width:100%;aspect-ratio:2}.vueperslides__arrow:focus-visible{outline:5px auto Highlight!important;outline:5px auto -webkit-focus-ring-color!important}.package-sorting{margin:20px 0 15px;text-align:right}.package-sorting__label{display:inline-block;text-transform:uppercase}.package-sorting__label:after{content:":"}.package-sorting__group{position:relative;display:inline-flex;flex-direction:column;margin:0;padding:0 15px 0 0;list-style-type:none;text-align:left}.package-sorting__group:after{content:"";position:absolute;top:.8em;right:0;width:0;height:0;border-left:5px solid transparent;border-right:5px solid transparent;border-top:5px solid #777}.package-sorting__item{display:none;margin:0 0 0 10px;padding:3px 0;border-bottom:2px solid transparent}.package-sorting__item:hover{color:var(--link)}.package-sorting__item--open{display:inline}.package-sorting__item--active{display:inline;color:var(--link);border-bottom:2px solid var(--link)}.package-sorting__item button{margin:0;padding:0;background:none;border:none;text-transform:uppercase;cursor:pointer}@media(min-width:600px){.package-sorting__group{flex-direction:row;justify-content:flex-end;padding:0}.package-sorting__group:after{content:none}.package-sorting__item{display:inline}}.search-bar{position:relative}.search-bar__input{height:50px!important;padding-right:45px!important;border-radius:50px!important}.search-bar__button{position:absolute;top:5px;right:5px;display:flex;align-items:center;width:38px;height:40px;margin:0;padding:7px;line-height:36px;border:none;border-radius:0 50px 50px 0;background:none}.package-search{position:relative}.package-search__input{max-width:400px;margin:0 20px}@media(min-width:1024px){.package-search__input{margin-right:0}}.package-search__headline{font-size:18px;font-weight:300;margin:30px 0 10px}.package-search__results{display:grid;gap:20px;margin-bottom:20px}@media(min-width:1024px){.package-search__results{grid-template-columns:repeat(2,1fr)}}.package-search__status{margin:100px 0;text-align:center;font-size:20px;line-height:1.5em}.package-search__status--empty{padding-top:140px;background:url(../img/sad.c7de6e95.svg) top no-repeat;background-size:100px 100px}.package-search__status--offline{padding-top:140px;background:url(../img/offline.0c23d1ce.svg) top no-repeat;background-size:100px 100px}.package-search__status--loader .sk-circle{width:100px;height:100px;margin:0 auto 40px}.package-search__status button{margin-top:2em}.package-search__explain{font-size:16px}.package-search__more{margin:10px 0 30px;text-align:center}.package-search__more-button{display:inline-block;margin:0 auto;padding:0;text-transform:uppercase;background:none;border:none;cursor:pointer}.package-search__more-button:hover{text-decoration:underline}.package-search__algolia{display:block;width:200px;margin:50px auto 0}.vjs-tree-brackets{cursor:pointer}.vjs-tree-brackets:hover{color:#1890ff}.vjs-check-controller{position:absolute;left:0}.vjs-check-controller.is-checked .vjs-check-controller-inner{background-color:#1890ff;border-color:#0076e4}.vjs-check-controller.is-checked .vjs-check-controller-inner.is-checkbox:after{-webkit-transform:rotate(45deg) scaleY(1);transform:rotate(45deg) scaleY(1)}.vjs-check-controller.is-checked .vjs-check-controller-inner.is-radio:after{-webkit-transform:translate(-50%,-50%) scale(1);transform:translate(-50%,-50%) scale(1)}.vjs-check-controller .vjs-check-controller-inner{display:inline-block;position:relative;border:1px solid #bfcbd9;border-radius:2px;vertical-align:middle;-webkit-box-sizing:border-box;box-sizing:border-box;width:16px;height:16px;background-color:#fff;z-index:1;cursor:pointer;-webkit-transition:border-color .25s cubic-bezier(.71,-.46,.29,1.46),background-color .25s cubic-bezier(.71,-.46,.29,1.46);transition:border-color .25s cubic-bezier(.71,-.46,.29,1.46),background-color .25s cubic-bezier(.71,-.46,.29,1.46)}.vjs-check-controller .vjs-check-controller-inner:after{-webkit-box-sizing:content-box;box-sizing:content-box;content:"";border:2px solid #fff;border-left:0;border-top:0;height:8px;left:4px;position:absolute;top:1px;-webkit-transform:rotate(45deg) scaleY(0);transform:rotate(45deg) scaleY(0);width:4px;-webkit-transition:-webkit-transform .15s cubic-bezier(.71,-.46,.88,.6) .05s;transition:-webkit-transform .15s cubic-bezier(.71,-.46,.88,.6) .05s;transition:transform .15s cubic-bezier(.71,-.46,.88,.6) .05s;transition:transform .15s cubic-bezier(.71,-.46,.88,.6) .05s,-webkit-transform .15s cubic-bezier(.71,-.46,.88,.6) .05s;-webkit-transform-origin:center;transform-origin:center}.vjs-check-controller .vjs-check-controller-inner.is-radio{border-radius:100%}.vjs-check-controller .vjs-check-controller-inner.is-radio:after{border-radius:100%;height:4px;background-color:#fff;left:50%;top:50%}.vjs-check-controller .vjs-check-controller-original{opacity:0;outline:none;position:absolute;z-index:-1;top:0;left:0;right:0;bottom:0;margin:0}.vjs-carets{position:absolute;right:0;cursor:pointer}.vjs-carets svg{-webkit-transition:-webkit-transform .3s;transition:-webkit-transform .3s;transition:transform .3s;transition:transform .3s,-webkit-transform .3s}.vjs-carets:hover{color:#1890ff}.vjs-carets-close{-webkit-transform:rotate(-90deg);transform:rotate(-90deg)}.vjs-tree-node{display:-webkit-box;display:-ms-flexbox;display:flex;position:relative;line-height:20px}.vjs-tree-node.has-carets{padding-left:15px}.vjs-tree-node.has-carets.has-selector,.vjs-tree-node.has-selector{padding-left:30px}.vjs-tree-node.is-highlight,.vjs-tree-node:hover{background-color:#e6f7ff}.vjs-tree-node .vjs-indent{display:-webkit-box;display:-ms-flexbox;display:flex;position:relative}.vjs-tree-node .vjs-indent-unit{width:1em}.vjs-tree-node .vjs-indent-unit.has-line{border-left:1px dashed #bfcbd9}.vjs-tree-node.dark.is-highlight,.vjs-tree-node.dark:hover{background-color:#2e4558}.vjs-node-index{position:absolute;right:100%;margin-right:4px;-webkit-user-select:none;-moz-user-select:none;-ms-user-select:none;user-select:none}.vjs-colon{white-space:pre}.vjs-comment{color:#bfcbd9}.vjs-value{word-break:break-word}.vjs-value-null,.vjs-value-undefined{color:#d55fde}.vjs-value-boolean,.vjs-value-number{color:#1d8ce0}.vjs-value-string{color:#13ce66}.vjs-tree{font-family:Monaco,Menlo,Consolas,Bitstream Vera Sans Mono,monospace;font-size:14px;text-align:left}.vjs-tree.is-virtual{overflow:auto}.vjs-tree.is-virtual .vjs-tree-node{white-space:nowrap}[data-notivue=promise-resolve],[data-notivue=success]{--nv-bg:var(--nv-success-bg);--nv-fg:var(--nv-success-fg);--nv-accent:var(--nv-success-accent,var(--nv-global-accent));--nv-border:var(--nv-success-border)}[data-notivue=error],[data-notivue=promise-reject]{--nv-bg:var(--nv-error-bg);--nv-fg:var(--nv-error-fg);--nv-accent:var(--nv-error-accent,var(--nv-global-accent));--nv-border:var(--nv-error-border)}[data-notivue=warning]{--nv-bg:var(--nv-warning-bg);--nv-fg:var(--nv-warning-fg);--nv-accent:var(--nv-warning-accent,var(--nv-global-accent));--nv-border:var(--nv-warning-border)}[data-notivue=info]{--nv-bg:var(--nv-info-bg);--nv-fg:var(--nv-info-fg);--nv-accent:var(--nv-info-accent,var(--nv-global-accent));--nv-border:var(--nv-info-border)}[data-notivue=promise]{--nv-bg:var(--nv-promise-bg);--nv-fg:var(--nv-promise-fg);--nv-accent:var(--nv-promise-accent,var(--nv-global-accent));--nv-border:var(--nv-promise-border)}.Notivue__notification{--tip-width:calc(var(--tip-width-fx, 1)*var(--nv-tip-width, 0px));box-sizing:border-box;position:relative;width:var(--nv-min-width,auto);max-width:var(--nv-width,100%);background-color:var(--nv-bg,var(--nv-global-bg));display:flex;align-items:var(--nv-y-align);border-radius:var(--nv-radius,0);border:var(--nv-border-width,0) solid var(--nv-border,var(--nv-global-border));box-shadow:var(--nv-shadow,0 0 transparent),inset var(--tip-width) 0 0 var(--nv-accent)}.Notivue__notification *{box-sizing:border-box;touch-action:manipulation}.Notivue__notification[data-notivue-has-title=true]{align-items:var(--nv-y-align-has-title,var(--nv-y-align))}.Notivue__icon{display:flex;justify-content:center;align-items:center;overflow:visible;min-width:var(--nv-icon-size);width:var(--nv-icon-size);height:var(--nv-icon-size);margin:var(--nv-spacing) 0 var(--nv-spacing) var(--nv-spacing);color:var(--nv-accent)}.Notivue__content{--nv-content-space:calc(var(--nv-spacing) + var(--nv-spacing)*0.15);display:flex;flex-direction:column;flex-grow:1;text-align:inherit;padding:var(--nv-content-space)}.Notivue__content-title{line-height:1.15;font-weight:700;color:var(--nv-fg,var(--nv-global-fg));font-size:var(--nv-title-size);margin:0 0 .33em;padding:0}.Notivue__transition-enter-active{--dur-easing:.5s cubic-bezier(.16,1,.3,1);transition:opacity var(--dur-easing),transform var(--dur-easing)}@media (prefers-reduced-motion:reduce){.Notivue__transition-enter-active{transition:none}}.Notivue__transition-enter-from{opacity:0;transform:scale(.8)}.Notivue__transition-enter-to{opacity:1;transform:scale(1)}.Notivue__transition-leave-active{transition:opacity 0ms ease}.Notivue__transition-leave-from,.Notivue__transition-leave-to{opacity:0}.Notivue__content-message{max-height:250px;overflow:auto;line-height:1.375;margin:0;padding:0;white-space:pre-line}.Notivue__close,.Notivue__content-message{color:var(--nv-fg,var(--nv-global-fg));font-size:var(--nv-message-size)}.Notivue__close{position:relative;cursor:pointer;padding:calc(var(--nv-spacing)/2);margin:var(--nv-spacing) var(--nv-spacing) var(--nv-spacing) 0;font-weight:700;border:none;background:none;line-height:1;-webkit-tap-highlight-color:rgba(0,0,0,0)}.Notivue__close:after{content:"";position:absolute;top:0;right:0;bottom:0;left:0;width:100%;height:100%;background-color:var(--nv-fg,var(--nv-global-fg));opacity:0;border-radius:calc(var(--nv-radius)/2);transition:opacity .1s ease-out}@media (hover:hover){.Notivue__close:hover{opacity:1}.Notivue__close:hover:after{opacity:.1}.Notivue__close:hover .Notivue__close-icon{opacity:1}}.Notivue__close-icon{width:var(--nv-icon-size);height:var(--nv-icon-size);display:flex;color:var(--nv-fg,var(--nv-global-fg));pointer-events:none;opacity:.65}.Notivue__spinner{transform-origin:center;animation:Notivue__spinner-kf .75s linear infinite}@keyframes Notivue__spinner-kf{to{transform:rotate(1turn)}}@media (prefers-reduced-motion:reduce){.Notivue__duplicate,.Notivue__spinner{animation:none}}[dir=rtl] .Notivue__notification{--tip-width-fx:-1}[dir=rtl] .Notivue__icon{margin:var(--nv-spacing) var(--nv-spacing) var(--nv-spacing) 0}[dir=rtl] .Notivue__content-message{font-size:calc(var(--nv-message-size) + .1em)}[dir=rtl] .Notivue__content-title{font-size:calc(var(--nv-title-size) + .1em)}[dir=rtl] .Notivue__close{margin:var(--nv-spacing) 0 var(--nv-spacing) var(--nv-spacing)}.Notivue__duplicate{animation:Notivue__duplicate-kf .3s cubic-bezier(.16,1,.3,1) forwards}@keyframes Notivue__duplicate-kf{0%{transform:scale(1);opacity:1}50%{transform:scale(1.035);opacity:.8}to{transform:scale(1);opacity:1}}[data-notivue-align=top] .Notivue__enter,[data-notivue-align=top] .Notivue__leave{--notivue-ty:-200%}[data-notivue-align=bottom] .Notivue__enter,[data-notivue-align=bottom] .Notivue__leave{--notivue-ty:200%}.Notivue__enter{animation:Notivue__enter-kf .35s cubic-bezier(.5,1,.25,1)}.Notivue__leave{animation:Notivue__leave-kf .35s ease}.Notivue__clearAll{animation:Notivue__clearAll-kf .5s cubic-bezier(.22,1,.36,1)}@keyframes Notivue__enter-kf{0%{transform:translate3d(0,var(--notivue-ty),0) scale(.25);opacity:0}to{transform:translateZ(0) scale(1);opacity:1}}@keyframes Notivue__leave-kf{0%{transform:translateZ(0) scale(1);opacity:.7}to{transform:translate3d(0,var(--notivue-ty),0) scale(0);opacity:0}}@keyframes Notivue__clearAll-kf{0%{opacity:1}to{opacity:0}}.link-more{position:relative;display:inline-block}p:empty+.link-more{margin-left:0}.link-more button{width:auto;height:auto;padding:0 0 5px;background:transparent;color:var(--link);font-size:13px;font-weight:300;line-height:inherit;border:none;cursor:pointer}.link-more button:hover{text-decoration:underline}.link-more__menu{outline:none}.link-more ul{transform:translateX(-50%)}.package-link{display:flex;-moz-column-gap:8px;column-gap:8px;justify-content:space-between;width:100%;padding-bottom:4px;margin-bottom:4px;border-bottom:1px solid var(--border--light)}.package-link:last-child{padding-bottom:0;margin-bottom:0;border-bottom:none}.package-link__details{padding:5px 0;line-height:18px}.package-link__name{display:inline;font-weight:600}.package-link__name:after{content:": "}.package-link__text{display:inline}.package-link__actions{display:flex;margin-left:20px;margin:0 -4px}.package-link__actions>*{margin:0 4px}.package-link--limit .package-link__details{display:flex}.package-link--limit .package-link__name{white-space:nowrap}.package-link--limit .package-link__text{display:-webkit-box;overflow:hidden;line-clamp:1;-webkit-line-clamp:1;-webkit-box-orient:vertical;padding:0 10px 0 5px}.package-funding[data-v-5a8fd14b]{padding:10px 20px 10px 50px;font-weight:400;font-size:12px;line-height:1.8;background:rgba(var(--funding-rgb),.025) url(../img/funding.cf78a0a0.svg) 15px 50% no-repeat;background-size:23px 23px;border:1px solid rgba(var(--funding-rgb),.5);border-radius:6px}.package-funding>div[data-v-5a8fd14b]{overflow:hidden}.package-funding span[data-v-5a8fd14b]{margin-right:15px}.package-funding a[data-v-5a8fd14b]{position:relative;display:inline-block;margin:0 20px 0 0;padding-left:16px;color:var(--funding);background:url(../img/link-funding.b25cd92d.svg) 0 50% no-repeat;background-size:13px 13px}.package-funding a[data-v-5a8fd14b]:before{content:"|";position:absolute;left:-12px}.package-funding a[data-v-5a8fd14b]:nth-child(2):before{content:none}.package-popup{position:fixed;display:flex;flex-direction:column;justify-content:flex-start;width:100%;max-width:none;height:100%;background:var(--popup-bg);z-index:10;opacity:1}.package-popup>*{flex-basis:auto;flex-grow:1}.package-popup__loader{display:flex;flex-direction:column;align-items:center;justify-content:center;padding:50px 0}.package-popup__loader p{margin:1em}.package-popup__headline{position:relative;flex-grow:0;flex-shrink:1;padding:7px 30px 6px;background:var(--popup-hl-bg);color:#fff;font-size:18px;font-weight:300;line-height:1.5;text-align:center}.package-popup__button{display:block;float:right;position:absolute;top:0;margin:4px 0;padding:4px;background:none;border:1px solid transparent;border-radius:5px;cursor:pointer}.package-popup__button--previous{left:4px}.package-popup__button--close{right:4px}.package-popup__button svg{display:block;width:22px;height:22px}.package-popup__button:hover{background-color:#db6f00}.package-popup__summary{flex-grow:0;padding:25px 35px}@media(min-width:600px){.package-popup__summary{display:flex}}.package-popup__logo{border-radius:6px;float:right;height:60px;width:60px;margin-left:1em;background:#f7f7f7}@media(min-width:600px){.package-popup__logo{display:block;float:left;width:110px;height:110px;margin:-10px 16px 0 -10px}}.package-popup__icon{display:flex;align-items:center;justify-content:center;height:100%}.package-popup__icon--fallback{display:none}.package-popup__icon img{width:50px;height:50px;max-height:100%;-o-object-fit:contain;object-fit:contain}@media(min-width:600px){.package-popup__icon img{width:90px;height:90px}}.package-popup__text{display:flex;flex-direction:column;flex-grow:1}@media(min-width:600px){.package-popup__text{width:200px}}.package-popup__title{margin:0;line-height:1.4;overflow-wrap:break-word}.package-popup__authors{flex-grow:1;font-size:13px;margin-bottom:.5em}.package-popup__author{display:inline-block;margin-right:2px}.package-popup__author:after{color:var(--text);content:", "}.package-popup__author:last-child:after{content:none}.package-popup__stats{display:inline-block;margin-right:15px;margin-top:.5em;padding-left:18px;font-size:13px;background-position:0 50%;background-repeat:no-repeat;background-size:13px 13px}.package-popup__stats--private{padding-left:20px;background-image:var(--svg--private);background-size:15px 15px}.package-popup__stats--updated{background-image:var(--svg--updated)}.package-popup__stats--downloads{background-image:var(--svg--downloads)}.package-popup__stats--favers{background-image:var(--svg--favers)}.package-popup__actions{display:flex;flex-direction:column;gap:10px;margin-top:1em}@media(min-width:600px){.package-popup__actions{justify-content:space-between;margin:0 0 0 25px;width:200px}}.package-popup__installed{margin-top:1em}.package-popup__abandoned{margin:0 0 20px;padding:10px 20px 10px 50px;font-weight:400;font-size:12px;line-height:1.8;background:rgba(var(--hint-rgb),.3) url(../img/hint.ba2ac97e.svg) 15px 50% no-repeat;background-size:23px 23px;border:1px solid var(--hint-link);border-radius:6px}.package-popup__funding{margin:0 0 20px}.package-popup__tabs{position:relative;flex-grow:revert}.package-popup__tabs:after,.package-popup__tabs:before{content:"";display:block;position:absolute;top:0;bottom:1px;width:7px;background:linear-gradient(-90deg,transparent 0,var(--popup-bg) 50%);z-index:1;pointer-events:none}.package-popup__tabs:after{background:linear-gradient(90deg,transparent 0,var(--popup-bg) 50%);right:0}.package-popup__tabs-list{flex-shrink:0;flex-grow:0;display:flex;-moz-column-gap:4px;column-gap:4px;height:40px;min-width:100%;overflow-x:auto;scrollbar-width:none;overflow-y:hidden;margin:0;padding:0 7px;list-style-type:none}.package-popup__tabs-list:after{content:"";position:absolute;inset:auto 0 0;height:1px;background:var(--border--light);z-index:-1}.package-popup__tab{position:relative;top:1px;flex-grow:1;padding:0;height:39px;line-height:39px;text-align:center;border:1px solid var(--border--light);border-top-left-radius:6px;border-top-right-radius:6px}.package-popup__tab--active{background:var(--tab-content);border-bottom:1px solid var(--tab-content)}.package-popup__tab button{display:flex;justify-content:center;align-items:center;width:100%;height:100%;margin:0;padding:0 10px;border:none;background:transparent;cursor:pointer}.package-popup__tab button:disabled{color:var(--border)!important;cursor:not-allowed}.package-popup__pill{position:relative;top:-2px;display:inline-block;margin-left:5px;padding:2px 5px;font-size:10px;font-weight:400;background:var(--border--light);border-radius:40%}.package-popup__pill--highlight{color:var(--clr-btn);background:var(--btn-primary)}.package-popup__tabcontent{position:relative;padding:25px 35px;overflow-y:auto;background:var(--tab-content);outline:0}@media(min-width:960px)and (min-height:700px){.package-popup__tabcontent{height:450px}}.package-popup__description{margin:1em 0;white-space:pre-wrap}@media(min-width:960px){.package-popup{position:relative;display:block;top:0;left:50%;width:750px;margin-left:-375px;height:auto;border-radius:8px;transform:none}.package-popup__headline{border-radius:8px 8px 0 0}.package-popup__tabcontent{border-radius:0 0 8px 8px}}@media(min-width:960px)and (min-height:700px){.package-popup{position:absolute;top:50%;transform:translateY(-50%)}}.package-popup__installed strong{margin-right:5px}@media(min-width:600px){.package-popup__installed{display:flex;flex-direction:column;justify-content:flex-end;text-align:center}.package-popup__installed strong{display:block;margin:0}}.package-popup__update{background:var(--btn-primary) url(../img/button-update.ad79c617.svg) 15px 50% no-repeat;background-size:23px 23px}.package-popup__incompatible,.package-popup__update{margin:0 0 20px;padding:10px 20px 10px 50px;color:var(--clr-btn);border-radius:var(--border-radius)}.package-popup__incompatible{background:var(--contao) url(../img/button-incompatible.3eb2b686.svg) 15px 50% no-repeat;background-size:23px 23px}.package-popup__funding+.package-popup__update{margin-top:-10px}.database-migration__header{margin-left:auto;margin-right:auto;padding:40px 0;text-align:center}.database-migration__icon{background:var(--contao);border-radius:10px;padding:10px}.database-migration__headline{margin-top:.5em;margin-bottom:.5em;font-size:36px;font-weight:100;line-height:1}.database-migration__description{margin:0 50px;font-weight:600}.database-migration__actions{display:flex;flex-direction:column;justify-content:center;align-items:center;margin-top:2em;padding:0 50px}@media(min-width:960px){.database-migration__actions{flex-direction:row}}.database-migration .widget-button{width:280px;height:35px;margin:5px;padding:0 30px;line-height:35px}@media(min-width:960px){.database-migration .widget-button{width:auto}}.database-migration__main{margin:0 50px 50px;background:#24292e}.database-migration__loading{width:30px;margin:40px auto}.database-migration__loading .sk-circle{width:30px;height:30px}.view-recovery__header{max-width:280px;margin-left:auto;margin-right:auto;padding:40px 0 10px;text-align:center}.view-recovery__icon{background:var(--contao);border-radius:10px;padding:10px}.view-recovery__headline{margin-top:15px;font-size:36px;font-weight:100;line-height:1}.view-recovery__content{margin:0 30px 50px}@media(min-width:960px){.view-recovery__content{margin-left:50px;margin-right:50px}}.view-recovery__description{font-weight:600;max-width:600px;margin:0 auto;text-align:center}.view-recovery__console{margin:30px 0 60px}.view-recovery__option{margin:50px 0 0;padding:20px 20px 30px;background:var(--table-odd-bg);text-align:center}.view-recovery__option h3{position:relative;top:-40px;margin-bottom:-25px;font-size:2em;font-weight:300}.view-recovery__option button{margin-top:1.5em}.view-recovery__failed{margin:10px 0;color:var(--btn-alert);font-weight:600}"use strict";(self["webpackChunkcontao_manager"]=self["webpackChunkcontao_manager"]||[]).push([[120],{8120:function(e){e.exports=JSON.parse('{"ui.app.title":"Extensions Contao","ui.app.loading":"Chargement de la liste des extensions…","ui.app.language":"Switch language for the Contao Manager","ui.app.colorDark":"Dark Mode","ui.app.colorDarkTitle":"Switch color scheme to dark","ui.app.colorLight":"Light Mode","ui.app.colorLightTitle":"Switch color scheme to light","ui.discover.advertisement":"Publicité dans la liste des extensions","ui.discover.loading":"Chargement…","ui.discover.offline":"Impossible de récupérer des résultats.","ui.discover.offlineExplain":"Vérifiez votre connexion Internet et désactivez les bloqueurs JavaScript dans votre navigateur.","ui.discover.offlineButton":"Réessayer","ui.discover.searchPlaceholder":"Search in {count} extensions …","ui.discover.empty":"Pas de résultats pour {query}","ui.discover.more":"Plus de résulats","ui.discover.sortBy":"Trier par","ui.discover.sortReleased":"Released","ui.discover.sortReleasedTitle":"Sort results by release date","ui.discover.sortLatest":"Mis à jour","ui.discover.sortLatestTitle":"Sort results by last updated","ui.discover.sortDownloads":"Téléchargements","ui.discover.sortDownloadsTitle":"Sort results by number of downloads","ui.discover.sortFavers":"Note","ui.discover.sortFaversTitle":"Sort results by rating","ui.discover.detailsButton":"Détails","ui.discover.latestPackages":"Extensions les plus récentes et mises à jour","ui.discover.faversPackages":"Extensions les mieux notées","ui.discover.downloadsPackages":"Extensions les plus téléchargées","ui.package.homepage":"Site web du projet","ui.package.private":"Package privé","ui.package.privateTitle":"Les packages privés ne sont disponibles que chez le fournisseur (par exemple sous forme de téléchargement ZIP). Veuillez visiter le site Web pour plus d\'informations","ui.package.abandoned":"abandonné","ui.package.abandonedText":"Ce package est abandonné et n\'est plus maintenu.","ui.package.abandonedReplace":"Ce package est abandonné et n\'est plus maintenu. L\'auteur suggère d\'utiliser le package {replacement} à la place.","ui.package.contaoVersion":"Available for Contao","ui.package-details.previous":"Extension précédente","ui.package-details.close":"Fermer les détails","ui.package-details.loading":"Chargement…","ui.package-details.tabDescription":"Description","ui.package-details.tabRequire":"Prérequis","ui.package-details.tabFeatures":"Fonctionnalités","ui.package-details.tabSuggest":"Suggestions","ui.package-details.tabConflict":"Conflits","ui.package-details.tabDependents":"Dépendants","ui.package-details.linkRequires":"nécessite","ui.package-details.linkReplaces":"remplaces","ui.package-details.linkProvides":"fournis","ui.package-details.linkConflicts":"conflits","ui.package-details.funding":"Fund package maintenance!","ui.package-details.contaoVersions":"Supported Contao version(s)","ui.package-details.latest":"Dernière version","ui.package-details.released":"Publié le","ui.package-details.license":"License(s)","ui.package-details.authors":"de","ui.package-details.more":"Plus","ui.package-details.packagist":"Détails du Package","ui.package-details.metadata":"Editer les Metadata","ui.package-details.support_docs":"Documentation","ui.package-details.support_wiki":"Wiki","ui.package-details.support_forum":"Support","ui.package-details.support_issues":"Issues / Bug Report","ui.package-details.support_source":"Code source","ui.package-details.support_irc":"IRC / Chat","ui.package-details.support_email":"Support E-Mail","ui.package-details.support_rss":"RSS Feed"}')}}]);"use strict";(self["webpackChunkcontao_manager"]=self["webpackChunkcontao_manager"]||[]).push([[540],{4540:function(e){e.exports=JSON.parse('{"ui.app.httpsHeadline":"!!  Nezabezpečené připojení !!","ui.app.httpsDescription":"Bez HTTPS budou citlivá data přenášena nezabezpečeně.","ui.app.httpsLink":"Více informací","ui.app.httpsHref":"https://https.cio.gov/everything/","ui.app.safeModeHeadline":"!! Je zapnutý bezpečnostní režim !!","ui.app.safeModeDescription":"Některé funkce nejsou k dispozici ve Správci Contaa.","ui.app.safeModeExit":"Ukončit bezpečnostní režim","ui.app.limitedHeadline":"Smazat autorizaci","ui.app.limitedDescription":"Máte omezená přístupová práva kvůli přihlášení bez hesla.","ui.app.limitedLogout":"Opětovné ověření","ui.app.totpHeadline":"Bezpečnostní poznámka","ui.app.totpDescription":"Nastavte si dvoufaktorové ověření pro vyšší zabezpečení vašeho účtu. ","ui.app.totpSetup":"Nastavení","ui.app.loading":"Nahrávání Správce Contaa","ui.app.apiError":"Nečekaný status API","ui.app.configSecurity1":"BEZPEČNOSTNÍ UPOZORNĚNÍ!!! Byla objevená nechráněná konfigurační složka ","ui.app.configSecurity2":"Správce Contaa zjistil, že jsou veřejně dostupné jeho konfigurační soubory. Všechny operace byly pozastavené, dokud nebude daná složka chráněná, jinak může dojít k útoku na choulostivá data Vaší instalace.\\n\\nPro opravení této potíže zajistěte omezený přístup ke složce \\"contao-manager\\" na Vašem serveru. Jak to lze provést, se dozvíte od Vašeho hostingového poskytovatele nebo v příručce ke správě serveru.","ui.account.welcome":"Vítejte","ui.account.intro1":"Vítejte ve Správci Contaa, univerzálním nástroji k instalaci a správě Contaa Open Source CMS. Pokud jste tu poprvé, přečtěte si prosím návod {readTheManualToGetStarted}.","ui.account.introGetStarted":"Začínáme {readTheManual}.","ui.account.introManual":"přečíst návod","ui.account.intro2":"Pokud si všimnete jakýchkoli nesrovnalostí, podívejte se na seznam nahlášených chyb  {ourGithubIssues}  a případně nahlaste novou, kterou ještě nikdo nenahlásil. ","ui.account.introIssues":"Chyby na GitHubu","ui.account.headline":"Uživatelský účet","ui.account.description":"Abyste mohli spravovat instalaci, vytvořte prosím uživatelský účet. Uvědomte si prosím, že tento účet není stejný pro přihlášení do Contaa. ","ui.account.username":"Uživatelské jméno","ui.account.password":"Heslo","ui.account.passwordPlaceholder":"min. 8 znaků","ui.account.passwordLength":"Zadejte prosím nejméně 8 znaků.","ui.account.loginInvalid":"Došlo k chybě při vytváření účtu. Zkuste jiné úživatelské jméno. ","ui.account.submit":"Vytvořit účet","ui.account.usePassword":"Použít heslo pro příhlášení","ui.account.usePasskey":"Použít passkey pro přihlášení","ui.account.totpHeadline":"Dvoufaktorové ověření","ui.account.totpDescription":"Aktivujte prosím dvoufaktorové ověření, které přidá vašemu uživatelskému účtu další bezpečnostní úroveň. To znamená, že budete muset navíc zadat ověřovací kód generovaný dvoufaktorovými aplikacemi jako 1Password, Authy, Google Authenticator, Microsoft Authenticator, LastPass Authenticator nebo jakoukoli jinou  TOTP aplilkací.","ui.account.totpSetup":"Nastavit nyní","ui.account.totpSkip":"Nastavit později","ui.account.login":"Odmítnout pozvání","ui.account.contribute1":"Contao a Správce Contaa je podporovaný neziskovou Contao Association.","ui.account.contribute2":"Prosím zvažte, zda se chcete stát členem a spolupracovníkem tohoto open source projektu {becomingAMember}.","ui.account.contributeDonate":"Staňte se dárcem","ui.login.headline":"Přihlásit se","ui.login.description":"Přihlaste se, abyste mohli spravovat Vaši instalaci.","ui.login.username":"Uživatelské jméno","ui.login.password":"Heslo","ui.login.totpHeadline":"Dvoufaktorové ověření","ui.login.totpDescription":"Zadejte prosím doufaktorový kód, abyste dokončili přihlášení.","ui.login.totp":"Ověřovací kód","ui.login.forgotPassword":"Zapomněli jste heslo?","ui.login.button":"Přihlásit se","ui.login.passkey":"Přihlásit se pomocí passkey","ui.login.cancel":"Zrušit","ui.login.or":"nebo","ui.login.locked":"Přístup byl zamítnut, protože je Správce Contaa uzamčen. Pro odemknutí smažte soubor {lockFile} na Vašem serveru v kořenové složce Contaa.","ui.logout.headline":"Vypršení sezení","ui.logout.warning":"Byli jste neaktivní po dobu 25 minut. Z bezpečnostních důvodů bude Vaše sezení zakrátko ukončené. ","ui.logout.expired":"Vaše sezení bylo automaticky ukončeno, protože jste byli neaktivní více než 30 minut.","ui.logout.renew":"Zůstat přihlášený/á","ui.logout.logout":"Odhlásit","ui.logout.login":"Zpátky k přihlášení","ui.oauth.error":"Neplatný pokus o ověření totožnosti. Zkontrolujte požadované parametry.","ui.oauth.https":"Přeposílací URL musí používat zabezpečený protokol (https), aby nedošlo k přenosu autorizačního kódu v čirém textu.","ui.oauth.headline":"Smazat autorizaci","ui.oauth.description":"Následující aplikace nebo servis požadují vzdálený přístup k Vašemu Správci Contaa. ","ui.oauth.domain":"Ještě než povolíte přístup, ujistěte se, že znáte tuto URL a důvěřujete jejímu majiteli!","ui.oauth.outOfScope":"Bohužel nemáte potřebné přihlašovací práva, abyste se mohl(a) přihlásit.","ui.oauth.allow":"Povolit přístup","ui.oauth.deny":"Odmítnout přístup","ui.oauth.switchUser":"Přejít na jiného uživatele","ui.scope.admin":"Přístup správce včetně správy uživatelů","ui.scope.install":"Nainstalovat nové balíčky a změnit konfiguraci Contaa","ui.scope.update":"Aktualizovat balíčky a provést úkoly údržby","ui.scope.read":"Načíst balíčky a nastavení","ui.boot.headline":"Kontrola systému","ui.boot.description":"Prosím počkejte, analyzujeme Váš server...","ui.boot.issue1":"Byly zjištěny chyby","ui.boot.issue2":"Vaše instalace obsahuje několik chyb a je ji třeba opravit, než se bude moct použít Správce Contaa.","ui.boot.run":"Spustit Správce Contaa","ui.boot.safeMode":"Spustit v Bezpečnostním módu","ui.recovery.headline":"Záchrana systému","ui.recovery.description":"Správce Contaa našel soubory, které vypadají jako soubory Contaa, ale Příkazový řádek nepracuje tak, jak by měl.","ui.recovery.console":"Výstup konzoly","ui.recovery.repairOptions":"Vyberte prosím jednu z možností pro zotavení Vaší instalace.","ui.recovery.repairHeadline":"Automatická oprava","ui.recovery.repairDescription":"Bude provedené automatické opravení instalace tím, že se přestaví meziúložiště a přeinstalují se balíčky závislé na Composeru.","ui.recovery.repairWarning":"Veškeré úpravy provedené na souborech ve složce vendor budou ztraceny!","ui.recovery.repairFailed":"Automatická oprava neproběhla úspěšně. Pro opravení instalace se pokuste se použít Bezpečnostní mód.","ui.recovery.repairButton":"Spustit opravu systému","ui.recovery.safeModeHeadline":"Bezpečnostní mód","ui.recovery.safeModeDescription":"Spuštěním Správce Contaa v Bezpečnostním módu lze spravovat balíčky a spouštět základní příkazy/úlohy, nejsou ovšem dostupné funkce závislé na instalaci Contaa.","ui.recovery.safeModeButton":"Spustit v Bezpečnostním módu","ui.server.pending":"Čekám…","ui.server.running":"Analyzování…","ui.server.error":"Kontrola selhala kvůli neočekávané odezvě ze strany serveru.","ui.server.details":"Podrobnosti","ui.server.prerequisite":"Kontrola zrušena kvůli chybějící podmínce.","ui.server.selfUpdate.title":"Aktualizace Správce Contaa","ui.server.selfUpdate.update":"Je k dispozici nová verze Správce Contaa {latest}.","ui.server.selfUpdate.manualUpdate":"Je dostupná nová verze Správce Contaa {latest}. Váš server nepodporuje automatické instalace. Stáhněte si proto prosím novou verzi {download}.","ui.server.selfUpdate.latest":"Používáte poslední verzi {current}.","ui.server.selfUpdate.dev":"Vývojové verze nepodporují automatické aktualizace.","ui.server.selfUpdate.unsupported":"Je dostupná novější verze, ale ta nepodporuje Vaši verzi PHP.","ui.server.selfUpdate.button":"Spustit automatické aktualizace","ui.server.selfUpdate.continue":"Pokračovat","ui.server.config.title":"Nastavení serveru","ui.server.config.setup":"Nastavit","ui.server.config.change":"Změnit","ui.server.config.save":"Uložit","ui.server.config.cancel":"Zrušit","ui.server.config.customOption":"Jíné…","ui.server.config.description":"Pro správný běh úloh na pozadí potřebuje Správce Contaa vědět, kde může najít binární příkazový řádek PHP a jak spouštět příkazy odděleně od webové stránky. ","ui.server.config.formTitle":"Nastavení serveru","ui.server.config.formText":"Zadejte prosím cestu k binární PHP. Ujistěte se, že je binární soubor stejný jako Vámi používaná verze PHP. ","ui.server.config.cloudTitle":"Composer Resolver Cloud","ui.server.config.cloudText":"Composer Resolver Cloud umožňuje nainstalovat na Composeru závislých rozšířeních, i když Váš server nemá dostatek paměti. Mějte na paměti, že informaci o Vaši balíčcích budou odeslané na cloudový server vlastněný Asociací Contaa.","ui.server.config.cloud":"Použít Composer Resolver Cloud","ui.server.config.cli":"Binární PHP","ui.server.config.stateErrorCli":"Na Vašem serveru nebyla nalezena žádná platná binární PHP.","ui.server.config.stateErrorCloud":"Composer Resolver Cloud není podporován.","ui.server.config.stateSuccess":"Binární PHP na {php_cli}.","ui.server.php_web.title":"Webový proces PHP","ui.server.php_web.below7":"Byla nalezena následující verze PHP {version}. Prosím přejděte co nejdříve na PHP 7. ","ui.server.php_web.success":"Byla nalezena následující verze PHP {version}, nejsou známé žádné chyby.","ui.server.php_cli.title":"Rozhraní příkazového řádku PHP","ui.server.php_cli.success":"Byla nalezena následující verze PHP {version}, nejsou známé žádné chyby.","ui.server.composer.title":"Prostředí Composeru","ui.server.composer.success":"Nebyly nalezeny žádné chyby.","ui.server.composer.install":"Věci závislé na Composorovi nejsou nainstalované.","ui.server.composer.button":"Nainstalovat","ui.server.contao.title":"Instalace Contaa","ui.server.contao.setup":"Nastavení","ui.server.contao.check":"Zkontrolovat databázi","ui.server.contao.empty":"Nebyla nalezena žádná instalace Contaa.","ui.server.contao.old":"Verze Contaa {version} není kompatabilní se Správcem Contaa. Zaktualizujte prosím Vaši instalaci manuálně.","ui.server.contao.found":"Nalezeno Contao {version} (verze API {api})","ui.server.contao.connectionError":"Nepodařilo se připojit k serveru databáze.","ui.server.contao.connectionProblem":"Nalezen problém s databází.","ui.server.contao.missingUser":"Nebyl nalezen žádný administrační účet.","ui.setup.continue":"Pokračovat","ui.setup.manager":"Spustit Správce Contaa","ui.setup.cancel":"Zrušit","ui.setup.welcome":"Vítejte","ui.setup.welcome1":"Tento průvodce Vás provede důležitými kroky pro nastavení instalace CMS Contao.","ui.setup.welcome2":"Pokud máte jakýkoli dotaz, prohlédněte si prosím dokumentaci, fóra, kanál Slacku nebo se obraťte na stránku {podpory}.  ","ui.setup.support":"podpora komunity","ui.setup.start":"Začít","ui.setup.complete":"Blahopřejeme!","ui.setup.complete1":"Úspěšně byla nainstalována {version} Contaa.","ui.setup.complete2":"Pro ukončení tohoto procesu otevřete prosím instalační nástroj, abyste nastavili připojení k databázi a vytvořili účet administrátora.","ui.setup.complete3":"Nyní můžete začít vytvářet Vaši webovou stránku v backendu Contaa. Potřebujete-li dodatečná rozšíření, vraťte se do Správce Contaa.","ui.setup.installTool":"Otevřít instalační nástroj","ui.setup.login":"Přihlásit se do Contaa","ui.setup.funding":"Volný software je \\"volný\\" jako \\"volný projev\\", ale ne jako \\"pivo zdarma\\". Open source projekt jako Contaa vyžaduje řadu peněz a nedá se ho uskutečnit bez jediné osoby nebo firmy. \\nPokud máte vytvořenou webovou stránku pomocí Contaa nebo je prodáváte, potěšilo by nás, kdybyste nás finančně podpořili poměrně k Vašemu obchodu.","ui.setup.fundingLink":"Dozvědět se víc","ui.setup.document-root.headline":"Nastavení webového serveru","ui.setup.document-root.warning":"Abyste mohli nainstalovat Contao prostřednictvím Správce Contaa, musíte opravit kořenový dokument na webovém serveru.","ui.setup.document-root.description1":"Contao používá zvláštní složku pro veřejné soubory. Aplikační soubory jsou nainstalované v rodičovské složce. Contao právě nelze nainstalovat, protože Vaše složková struktura není správná nebo složky nejsou prázdné.","ui.setup.document-root.description2":"Pokud nevíte, jak nastavit kořenový dokument, přečtěte si prosím dokumentaci Contaa nebo se obraťte na svého poskytovatele webových služeb.","ui.setup.document-root.documentation":"Přečíst si dokumentaci","ui.setup.document-root.conflictsTitle":"Instalační složka není prázdná","ui.setup.document-root.conflictsDirectory":"Kořenová složka Vaší budoucí instalace Contaa není prázdná. Našli jsem následující počet souborů {count}, které se musí přepsat během instalace. Doporučujeme vytvořit prázdnou složku pro instalaci Contaa, nebo můžete také smazat veškeré věci, které se právě nachází ve vybrané složce, pokud jste si jistí, že je již nepotřebujete. ","ui.setup.document-root.ignoreConflicts":"Chci nainstalova Contao do nevyprázděné složky. Souhlasím s tím, že budou dané soubory přepsány. ","ui.setup.document-root.check":"Znovu zkontrolovat","ui.setup.document-root.create":"Vytvořit složky","ui.setup.document-root.change":"Změnit složky","ui.setup.document-root.formTitle":"Nastavení adresáře","ui.setup.document-root.formText1":"Správce Contaa může automaticky vytvořit novou adresářovou strukturu na tomto webovém serveru.","ui.setup.document-root.formText2":"Budete muset nastavit nový kořenový dokument (např. pomocí správního panelu ve Vašem účtu webových služeb).","ui.setup.document-root.autoconfig":"Rozumím tomu, že musím změnit nastavení serveru. Pokud se tak nestane, může dojít k poruše Správce Contaa a poničení souborů nastavení (včetně podrobností k účtu a heslu)!","ui.setup.document-root.directory":"Nový adresář","ui.setup.document-root.currentRoot":"Současný kořenový dokument","ui.setup.document-root.newRoot":"Nový kořenový dokument","ui.setup.document-root.finish":"Nastavení adresářů","ui.setup.document-root.publicDir":"Použijte {dir} pro veřejné soubory (pro Contao {version})","ui.setup.document-root.directoryInvalid":"Zadejte prosím platný název adresáře","ui.setup.document-root.directoryExists":"Cílový adresář již existuje. Zadejte prosím jiný název.","ui.setup.document-root.confirmation":"Správce Contaa úspěšně vytvořil potřebný adresář pro instalaci Contaa. Nyní musíte nastavit kořenový dokument na svém webovém serveru. Nenačítejte tuto stránku do té doby.","ui.setup.document-root.reload":"Načíst stránku znovu","ui.setup.document-root.success":"Struktura složek je nastavená na Vašem serveru správně!","ui.setup.document-root.installingProjectDir":"Aplikační soubory se nainstalují do {dir}.","ui.setup.document-root.installingPublicDir":"Veřejné soubory se nainstalují do {dir}.","ui.setup.document-root.installedProjectDir":"Aplikační soubory jsou nainstalované v {dir}.","ui.setup.document-root.installedPublicDir":"Veřejné soubory jsou nainstalované v {dir}.","ui.setup.create-project.headline":"Instalace Contaa","ui.setup.create-project.description":"Vývoj Contaa se drží principů {semver}, nová menší verze vychází každých šest měsíců. Současná verze, která se udržuje, je:","ui.setup.create-project.semver":"Sémantické číslování verzí","ui.setup.create-project.latestTitle":"Poslední","ui.setup.create-project.ltsTitle":"Několikaletá podpora - Long Term Support","ui.setup.create-project.latestQ1":"Naše poslední verze nabízí nejnovější funkce s podporou do února {year}.","ui.setup.create-project.latestQ3":"Naše poslední verze nabízí nejnovější funkce s podporou do srpna {year}.","ui.setup.create-project.ltsText":"Naše současná verze LTS, chcete-li se zaměřit na stabilitu. Nabízí dlouhodobou podporu do února {year}.","ui.setup.create-project.pltsText":"Naše předešlá verze LTS má podporu do února {year}.","ui.setup.create-project.requiresPHP":"Vyžaduje přinejmenším PHP {version}, používáte PHP {current}.","ui.setup.create-project.releaseplan":"Více informací: {contaoReleasePlan} ","ui.setup.create-project.releaseplanLink":"Plán vydávání nových verzí Contaa","ui.setup.create-project.installed":"Contao {version} je úspěšně nainstalována na vašem serveru. Pokračujte, abyste nastavili vaši databázi nebo spustili Správce Contaa pro nainstalování jiné verze.","ui.setup.create-project.formTitle":"Vyberte distribuci","ui.setup.create-project.formText":"Vyberte prosím verzi, kterou chcete nainstalovat.","ui.setup.create-project.version":"Verze","ui.setup.create-project.demo":"Nainstalovat demoverzi Contaa","ui.setup.create-project.demoDescription":"Demoverze vám pomůže se seznámit s Contaa a pochopit jeho základní fukce. Více předloh můžete najít v {store}.","ui.setup.create-project.coreOnly":"Minimální instalace (pouze jádro)","ui.setup.create-project.noUpdate":"Přeskočit instalaci (pouze pro pokročilé!)","ui.setup.create-project.theme":"Předloha Contaa","ui.setup.create-project.themeInstall":"Abyste nainstalovali předlohu Contaa, použijte vyhledávací políčko nebo načtete soubor (.cto/.zip), který podporuje instalace pomocí Správce Contaa.","ui.setup.create-project.themeBuy":"Podívejte se na další předlohy v obchodě {store}.","ui.setup.create-project.themeStore":"Obchod předloh Contaa","ui.setup.create-project.themeUpload":"Načíst soubor předlohy (.cto/.zip)","ui.setup.create-project.themeInvalid":"Načtený soubor není předloha Contaa nebo ho Správce Contaa nepodporuje.","ui.setup.create-project.themeWarning":"Správce Contaa nemůže říct, jestli je tato předloha kompatibilní s vaším serverem. Podívejte se prosím na informace předlohy pro získání dalších informací.","ui.setup.create-project.themeTitle":"Podívat se na hodnocení předlohy","ui.setup.create-project.themeDetails":"Následující závislosti a soubory se nainstalují spolu s vybranou předlohou.","ui.setup.create-project.themeRequire":"{count} závilostí | {count} závislostí","ui.setup.create-project.themeFiles":"{count} soubor | {count} souborů","ui.setup.create-project.theme.or":"nebo prohledejte veřejně dostupné předlohy","ui.setup.create-project.theme.search":"Prohledat předlohy","ui.setup.create-project.theme.more":"Více předloh","ui.setup.create-project.theme.empty":"Nenalezeny žádné předlohy pro {query}","ui.setup.create-project.theme.uploaded":"Soubory předlohy byly úspěšně nahrány.","ui.setup.create-project.theme.packageName":"Název balíčku","ui.setup.create-project.theme.version":"Verze","ui.setup.create-project.theme.authors":"Autor/Autoři","ui.setup.create-project.install":"Nainstalovat","ui.setup.create-project.cancel":"Zrušit","ui.setup.database-connection.headline":"Připojení k databázi","ui.setup.database-connection.description":"Contao vyžaduje přinejmenším jednu databázi MySQL (nebo kompatibilní druh jako MariaDB) pro ukládání stránek, obsahu, uživatelů a příslušných dat. Přihlašovací údaje jsou uložené v souboru {env} v kořenové složce instalace Contaa.","ui.setup.database-connection.formTitle":"Připojovací údaje","ui.setup.database-connection.formText":"Zadejte prosím cestu k databázi nebo vyplňte zvlášť uživatelské jméno, heslo, server a pole databáze.","ui.setup.database-connection.url":"Cesta k databázi","ui.setup.database-connection.validUrl":"Cesta k databázi je neplatná nebo selhalo spojit se se serverem.","ui.setup.database-connection.or":"nebo","ui.setup.database-connection.user":"Uživatelské jméno","ui.setup.database-connection.password":"Heslo","ui.setup.database-connection.server":"Server (:Port)","ui.setup.database-connection.database":"Jméno databáze","ui.setup.database-connection.connected":"Došlo k úspěšnému připojení k {database} na {server}.","ui.setup.database-connection.error":"Při připojení k databázi došlo k chybě.","ui.setup.database-connection.problem":"Contao zjistil problém s Vaší serverovou databází.","ui.setup.database-connection.schemaTitle":"Databázové schéma","ui.setup.database-connection.migration":"Existuje jedna nedokončená migrace. | Existují následující nedokončené migrace: {count}.","ui.setup.database-connection.schema":"Existuje jedna nedokončená schematická aktualizace. | Existují následující nedokončené schematické aktualizace: {count}.","ui.setup.database-connection.noChanges":"Vaše databáze je aktuální. ","ui.setup.database-connection.check":"Zkontrolovat databázi","ui.setup.database-connection.skip":"Přeskočit","ui.setup.database-connection.save":"Uložit","ui.setup.database-connection.change":"Změnit pověření","ui.setup.database-connection.restoreTitle":"Import databáze","ui.setup.database-connection.restoreText":"Předlohu, kterou jste právě nainstalovali, obsahuje již připravenou databázi s definovaným obsahem. Pokud ji chcete nahrát a začít tak používat Contao s již definovaným obsahem, nahrajte danou databázi, nebo přeskočte tento krok. |  Předlohu, kterou jste právě nainstalovali, obsahuje několik připravených databází s již definovaným obsahem. Pokud je chcete nahrát a začít tak používat Contao s již definovaným obsahem, nahrajte dané databázi, nebo přeskočte tento krok","ui.setup.database-connection.backup":"Uložit současnou databázi před importem.","ui.setup.database-connection.backupWarning":"Veškerá data budou v databázi přepsána! Ponejprv si uložte současnou databázi, pokud již není prázdná.","ui.setup.database-connection.restore":"Importovat předlohu databáze","ui.setup.database-connection.restoreOption":"Uložená databáze {date} ({size})","ui.setup.database-connection.restored":"Vaše databáze byla úspěšně importovaná. Pokračujte prosím, abyste provedli aktualizaci schématu databáze.","ui.setup.backend-user.success":"Ve vaší databázi byl nalezen jeden administrátorský účet pro backend Contaa. Pokud si přejete přidat další účty, přihlašte se do backendu Contaa a vytvořte je v sekci Uživatelé.","ui.setup.backend-user.error":"Nebylo možné najít jakýkoli seznam uživatelů. Zkontrolujete prosím výstup příkazového řádku.","ui.setup.backend-user.headline":"Účet backendu","ui.setup.backend-user.description":"Abyste mohli spravovat Vaši webovou stránku, musíte vytvořit alespoň jeden administrativní účet. Uvědomte si prosím, že tento účet není stejný pro přihlášení do Správce Contaa. ","ui.setup.backend-user.formTitle":"Vytvořit účet","ui.setup.backend-user.formText":"Zadejte prosím údaje pro nový účet backendu.","ui.setup.backend-user.username":"Uživatelské jméno","ui.setup.backend-user.name":"Jméno","ui.setup.backend-user.email":"Mailová adresa","ui.setup.backend-user.emailInvalid":"Zadejte prosím platnou mailovou adresu","ui.setup.backend-user.password":"Heslo","ui.setup.backend-user.passwordPlaceholder":"min. 8 znaků","ui.setup.backend-user.passwordLength":"Zadejte prosím nejméně 8 znaků.","ui.setup.backend-user.create":"Přidat účet","ui.task.headline":"Úloha na pozadí","ui.task.loading":"Načítání podrobností...","ui.task.created":"Načítání podrobností...","ui.task.active":"Počkejte prosím, zatímco Spráce Contaa na pozadí vyřizuje operační úlohy.","ui.task.complete":"Všechny operace byly úspěšně provedené. Další podrobnosti získáte v protokolu konzoly.","ui.task.aborting":"Počkejte prosím, zatímco se na pozadí zastavují operace.","ui.task.stopped":"Některé z operačních úloh byly zrušené. Zkontrolujte prosím protokol konzoly.","ui.task.error":"Příkaz na pozadí byl znenadání zastaven. Zkontrolujte prosím protokol konzoly.","ui.task.failed":"Správci Contaa se nepodařilo spustit úlohu!","ui.task.failedDescription1":"Něco se pokazilo, zatímco probíhaly úlohy na pozadí.","ui.task.failedDescription2":"Pokud se to bude opakovat, nejspíš není Váš server podporovaný.","ui.task.reportProblem":"Oznámit problém","ui.task.sponsor":"Cloud Composeru spozorován: {sponsor}","ui.task.buttonAudit":"Zaktualizovat dabázi","ui.task.buttonClose":"Zavřít","ui.task.buttonConfirm":"Potvrdit a zavřít","ui.task.buttonCancel":"Zrušit","ui.task.confirmCancel":"Jste si jistí, že chcete zrušit tuto úlohu? To může zanechat instalaci Contaa v špatném stavu!","ui.task.autoclose":"Zavřít podrobnosti o úloze po úspěšném dokončení","ui.console.toggle":"Zobrazit/skrýt výstup příkazového řádku","ui.console.showLog":"Zobrazit celý protokol konzoly","ui.console.copyLog":"Zkopírovat protokol do schránky.","ui.migrate.headline":"Aktualizace databáze","ui.migrate.migrationsOnly":"(pouze migrace)","ui.migrate.schemaOnly":"(pouze schémata)","ui.migrate.loading":"Prosím počkejte, analyzujeme Vaši databázi...","ui.migrate.empty":"Nebyl nalezené žádné aktualizace pro migraci nebo schémata. Vaši databáze je aktuální.","ui.migrate.emptyMigrations":"Nebyla nalezené žádné nedokončené migrace. Ujistěte se prosím, zda není potřeba také zaktualizovat schémata.","ui.migrate.emptySchema":"Nebyla nalezené žádné nedokončené schémata. Ujistěte se prosím, zda není potřeba také zaktualizovat migrace.","ui.migrate.pending":"Vaše databáze není aktuální. Prohlídněte si prosím níže konzolu a zaktualizujte Vaši databázi.","ui.migrate.previousChanges":"Předešlá migrace nebyla potvrzená.\\nProhlédněte si prosím níže výsledky v konzole a pak proveďte potřebné změny.","ui.migrate.previousComplete":"Předešlá migrace nebyla potvrzená. Prohlédněte si prosím níže výsledky v konzole.\\nExistuje několik nedokončených změn.","ui.migrate.appliedChanges":"Databáze byla zaktualizovaná. \\nProhlédněte si prosím níže výsledky v konzole, pak pokračujte dalšími kroky, abyste provedli další změny. ","ui.migrate.appliedComplete":"Databáze byla zaktualizovaná. \\nNeexistují žádné další nedokončené migrace nebo schémata. Vaše databáze je aktuální. ","ui.migrate.problem":"Contao zjistil problém s Vaším databázovým serverem. \\nProhlédněte si prosím níže výsledky v konzole, abyste se dozvěděli více o tom, co je potřeba opravit.  | Contao zjistil problém s Vaším databázovým serverem. \\nProhlédněte si prosím níže výsledky v konzole, abyste se dozvěděli více o tom, co je potřeba opravit. ","ui.migrate.warning":"Contao zjistil nesprávné nastavení Vašeho databázového serveru. \\nVarování lze dočasně přeskočit, měly by se ale opravit, aby docházelo k dobrému výkonu a zacházení s daty. ","ui.migrate.error":"Změny nelze provést. Vaše databáze se možná změnila. Zkontrolujte to prosím ještě jednou a proveďte daný krok ještě jednou.","ui.migrate.execute":"Provést","ui.migrate.close":"Zavřít","ui.migrate.confirm":"Potvrdit a zavřít","ui.migrate.cancel":"Zrušit","ui.migrate.continue":"Pokračovat","ui.migrate.setup":"Nastavení","ui.migrate.skip":"Přeskočit","ui.migrate.retry":"Znovu zkontrolovat","ui.migrate.retryAll":"Vybrat vše","ui.migrate.withDeletes":"Provést všechny změny databáze včetně příkazu ke smazání. ","ui.migrate.migrationTitle":"Migrace databáze","ui.migrate.schemaTitle":"Schématická aktualizace","ui.migrate.problemTitle":"Problémy databáze","ui.migrate.warningTitle":"Varování databáze","ui.migrate.addTable":"Přidat tabulku {table}","ui.migrate.dropTable":"Odstranit tabulku {table}","ui.migrate.addField":"Přidat pole {table}. {field}","ui.migrate.changeField":"Změnit pole {table}.{field}","ui.migrate.dropField":"Odstranit pole {table}.{field}","ui.migrate.createIndex":"Vytvořit index \\"{name}\\" v {table}","ui.migrate.dropIndex":"Odstranit index \\"{name}\\" v {table}","ui.widget.mandatory":"Toto pole nesmí být prázdné.","ui.widget.blankOption":"Vyberte prosím…","ui.widget.showPassword":"Zobrazit heslo","ui.widget.hidePassword":"Skrýt heslo","ui.error.title":"Požadavek HTTP pro \\"{method} {url}\\" selhal.","ui.error.server500":"Vypadá to, že došlo k nečekané chybě na Vašem webovém serveru. Zkontrolujte prosím protokolové soubory na serveru (Apache/Nginx) a protokol Správce Contaa v \\"contao-manager/logs\\".","ui.error.response":"Server odpověděl statusovým kódem {status}.","ui.error.moreLink":"Více informací","ui.error.support":"Podpora Contaa","ui.error.permission":"Nemáte povolení pro použití této funkce.","ui.footer.help":"Nápověda","ui.footer.reportProblem":"Oznámit problém","ui.navigation.discover":"Prohlédnout","ui.navigation.packages":"Balíčky","ui.navigation.tools":"Nástroje","ui.navigation.installTool":"Instalační nástroj","ui.navigation.backend":"Backend Contaa","ui.navigation.debug":"Debugový mód Contaa","ui.navigation.logViewer":"Prohlížeč protokolu","ui.navigation.phpinfo":"Informace o PHP","ui.navigation.phpinfoLoading":"Načítání informací o PHP…","ui.navigation.maintenance":"Údržba","ui.navigation.rebuildCache":"Přetvoření meziúložiště","ui.navigation.users":"Účty","ui.navigation.systemCheck":"Kontrola systému","ui.navigation.advanced":"Rozšířené","ui.navigation.logout":"Odhlásit","ui.maintenance.database.title":"Migrace databáze","ui.maintenance.database.description":"Migrace databáze zajišťuje konzistentní data a tabulková schémata.","ui.maintenance.database.migrations":"Jedna nedokončená migrace databáze | Počet nedokončených migrací databáze {count} ","ui.maintenance.database.schemaUpdates":"Jedna nedokončená schématická aktualizace | Počet nedokončených schematických aktualizací {count} ","ui.maintenance.database.error":"Nalezen problém s databází.","ui.maintenance.database.warning":"Byly nalezená varování databáze.","ui.maintenance.database.button":"Zkontrolovat databázi","ui.maintenance.database.migrationOnly":"Vybrat pouze migrace","ui.maintenance.database.schemaOnly":"Vybrat pouze schémata","ui.maintenance.database.installTool":"Otevřít instalační nástroj","ui.maintenance.database.createBackup":"Vytvořit uložení databáze","ui.maintenance.database.backupUnsupported":"Ukládání databází není vaší verzí Contaa podporováno.","ui.maintenance.database.backupList":"Máte pouze jednou uloženou vaší databázi, a sice {date}. | Počet uložených databází {count}. Naposledy byla uložená {date}.","ui.maintenance.database.backupEmpty":"Momentálně nemáte žádné uložené databáze.","ui.maintenance.rebuildCache.title":"Meziúložiště aplikace","ui.maintenance.rebuildCache.description":"Přetvoření meziúložiště aplikace je nutné provést po každé změně konfiguračních souborů. ","ui.maintenance.rebuildCache.rebuildProd":"Přetvořit produktivní meziúložiště ","ui.maintenance.rebuildCache.rebuildDev":"Přetvořit vývojářské meziúložiště ","ui.maintenance.rebuildCache.clearProd":"Vyprázdnit produktivní meziúložiště ","ui.maintenance.rebuildCache.clearDev":"Vyprázdnit vývojářské meziúložiště ","ui.maintenance.installTool.title":"Instalační nástroj Contaa","ui.maintenance.installTool.description":"Instalační nástroj Contaa se automaticky uzamkne, pokud nesprávně zadáte heslo třikrát po sobě. ","ui.maintenance.installTool.unlock":"Odemknout Instalační nástroj","ui.maintenance.installTool.lock":"Uzamknout Instalační nástroj","ui.maintenance.dumpAutoload.title":"Composer Class Loader","ui.maintenance.dumpAutoload.description":"Composer autoloader je zodpovědný za načítání tříd PHP. Autoloader musí být spuštěný po přidání vlastních namespace do kořenové composer.json.","ui.maintenance.dumpAutoload.button":"Spustit Autoloadera","ui.maintenance.composerInstall.title":"Na Compseru závislá rozšíření","ui.maintenance.composerInstall.description":"Na Composeru závislá rozšíření se nachází ve složce {vendor} Vaší instalace. Přeinstalování těchto závislostí může být důležité po manipulaci nebo manuálnímu přenosu souboru {composerLock}.","ui.maintenance.composerInstall.button":"Spustit instalátor","ui.maintenance.composerInstall.update":"Spustit aktualizaci Composeru","ui.maintenance.composerCache.title":"Meziúložiště Composeru","ui.maintenance.composerCache.description":"Meziúložiště Composeru stáhla balíčky, aby zlepšily výkonost. Pokud máte potíže jako poničené soubory, pokuste se smazat meziúložiště Composeru, abyste vyvolali nové stáhnutí. ","ui.maintenance.composerCache.button":"Smazat meziúložiště","ui.maintenance.maintenanceMode.title":"Mód údržby","ui.maintenance.maintenanceMode.description":"Když se spustí mód údržby, zobrazí se předloha pro \\"503 service Unavailable\\".","ui.maintenance.maintenanceMode.enable":"Aktivovat","ui.maintenance.maintenanceMode.disable":"Deaktivovat","ui.maintenance.debugMode.title":"Vývojářský mód","ui.maintenance.debugMode.description":"Aktivujte vývojářský mód zadáním uživatele a hesla pro {appDevPhp}.","ui.maintenance.debugMode.descriptionJwt":"Aktivujte vývojářský mód nastavením vývojářské cookie pro danou doménu.","ui.maintenance.debugMode.activate":"Aktivovat","ui.maintenance.debugMode.deactivate":"Deaktivovat","ui.maintenance.debugMode.credentials":"Uživatelské informace","ui.maintenance.debugMode.user":"Zadejte prosím uživatelské jméno pro vývojářský mód.","ui.maintenance.debugMode.password":"Zadejte prosím heslo pro uživatele vývojářského módu.","ui.maintenance.opcodeCache.title":"Operační kód mezinúložiště","ui.maintenance.opcodeCache.description":"Operační kód meziúložiště souborů PHP dokáže rychleji zpracovat data. Musí být smazán za určitých podmínek, pokud se nepodařilo rozpoznat soubory po jejich změně.","ui.maintenance.opcodeCache.button":"Zkrátit meziúložiště","ui.maintenance.safeMode":"Není to dostupné v Bezpečnostním módu","ui.maintenance.unsupported":"Nepodporované Vaší verzí Contaa. ","ui.packages.updateButton":"Zaktualizovat balíčky","ui.packages.searchButton":"Vyhledat balíčky","ui.packages.searchPlaceholder":"Hledají se balíčky…","ui.packages.uploadOverlay":"Přetáhněte a pusťte soubory, které chcete nahrát","ui.packages.uploadButton":"Nahrát balíčky","ui.packages.uploadMessage":"Máte jeden nepotvrzený přenos. | Máte celkem {count} nepotvrzených přenosů.","ui.packages.uploadApply":"Potvrdit nahrání","ui.packages.uploadReset":"Smazat nahráné soubory","ui.packages.uploadIncomplete":"Tyto soubory nebyly zcela nahrány. Smažte je prosím a zkuste to znovu.","ui.packages.uploadDuplicate":"Zdá se, že byly tyto soubory nahrány několikrát. Smažte prosím dané duplikáty.","ui.packages.uploadInstalled":"Tento soubor je již nainstalovaný. Smažte prosím daný duplikát.","ui.packages.uploadUnsupported":"Nahrávání souborů není ve Vaší instalaci podporováno. Ujistěte se prosím, zda je funkce PHP ZIP nainstalovaná a zaktualizujte veškeré závislosti.","ui.packages.changesMessage":"Máte jednu nepotvrzenou změnu. | Máte celkem {count} nepotvrzených změn.","ui.packages.changesDryrun":"Zkouška nanečisto","ui.packages.changesApply":"Provést změny","ui.packages.changesApplyAll":"Zaktualizovat všechny balíčky","ui.packages.changesDryrunAll":"Vyzkoušet všechny balíčky nanečisto","ui.packages.changesReset":"Vrátit změny","ui.packages.changesReview":"Ukázat změny","ui.packagelist.loading":"Spouštění…","ui.packagelist.uploads":"Nahrání/přenos souborů","ui.packagelist.added":"Nové balíčky","ui.packagelist.installed":"Nainstalované balíčky","ui.package.hintRevert":"Vrátit změny","ui.package.hintNoupdate":"Neaktualizovat","ui.package.hintConstraint":"Tento balíček bude nainstalovaný s omezením {constraint}, pokud provedete změny.","ui.package.hintConstraintBest":"Tento balíček bude nainstalovaný v nejnověji dostupné verzi, pokud provedete změny.","ui.package.hintConstraintChange":"Toto omezení pro tento balíček bude změněno z \\"{from}\\" na \\"{to}\\", pokud provedete změny.","ui.package.hintConstraintUpdate":"Tento balíček bude zaktualizovaný, pokud aplikujete tyto změny.","ui.package.hintAdded":"Tento balíček bude nainstalovaný, když aplikujete tyto změny.","ui.package.hintRemoved":"Tento balíček bude smazaný, pokud provedete změny.","ui.package.requiredTitle":"přidáno manuálně","ui.package.requiredText":"Tento balíček je už sice uvedený ve Vašem souboru composer.json, ale ještě není nainstalovaný.","ui.package.removedTitle":"odstaněno manuálně","ui.package.removedText":"Tento balíček byl odstraněn z Vašeho souboru composer.json.","ui.package.installed":"Momentálně nainstalováno:","ui.package.version":"Verze {version}","ui.package.additionalDownloads":"{count} Stažení | {count} Stažení","ui.package.additionalStars":"{count} Hvězda | {count} hvězd","ui.package.editConstraint":"Upravit","ui.package.uploadConstraint":"Toto omezení je nadefinováno nahraným balíčkem.","ui.package.updateButton":"Zaktualizovat","ui.package.removeButton":"Smazat","ui.package.installButton":"Přidat balíček","ui.package.installButtonShort":"Přidat","ui.package.detailsButton":"Podrobnosti","ui.package.latestConstraint":"poslední verze","ui.package.update":"Existuje nová aktualizace","ui.package.updateLatest":"poslední verze","ui.package.updateAvailable":"{version}","ui.package.updateUnknown":"neznámá verze","ui.package.updateConstraint":"Je k dispozici nová verze než ta, kterou právě používáte.","ui.package.incompatible":"{package} nefunguje s Contao {constraint}.","ui.cloudStatus.headline":"Composer Resolver Cloud","ui.cloudStatus.version":"Verze {version}","ui.cloudStatus.waitingTime":"Doba čekání","ui.cloudStatus.jobs":"Současné úlohy","ui.cloudStatus.workers":"Účastníků","ui.cloudStatus.approx":"{minutes} min.","ui.cloudStatus.none":"ne","ui.cloudStatus.short":"ca. {minutes} min.","ui.cloudStatus.long":"ca. {minutes} min. {seconds} sek.","ui.cloudStatus.error":"Nebylo možné získat status Composer Resolver Cloud. Může být zrovna neaktivní nebo má nějaké problémy.","ui.cloudStatus.button":"Status Cloudu","ui.cloudStatus.refresh":"Znovu načíst status Cloudu","ui.log-viewer.loading":"Spouštění…","ui.log-viewer.empty":"Na Vašem serveru se nenacházejí žádné protokolové soubory.","ui.log-viewer.reload":"Načíst znovu","ui.log-viewer.file":"Protokolový soubor","ui.log-viewer.channel":"Kanál","ui.log-viewer.channelTitle":"Kanál zpráv byl přihlášen.","ui.log-viewer.level":"Úroveň","ui.log-viewer.levelTitle":"Vážnost protokolované zprávy.","ui.log-viewer.timeHeader":"Čas","ui.log-viewer.messageHeader":"Zpráva","ui.log-viewer.showContext":"Zobrazit kontext","ui.log-viewer.hideContext":"Skrýt kontext","ui.log-viewer.showExtra":"Zobrazit extra","ui.log-viewer.hideExtra":"Smazat extra","ui.log-viewer.more":"Dozvědět se víc...","ui.log-viewer.download":"Stáhnout","ui.log-viewer.downloadTitle":"Stáhnout soubor \\"{file}\\"","ui.log-viewer.prodEnvironment":"Produktivní prostředí","ui.log-viewer.devEnvironment":"Vývojářské prostředí (vychytávací mód)","ui.user-manager.loading":"Načítám uživatele...","ui.user-manager.changePassword":"Změnit heslo","ui.user-manager.setupTotp":"Nastavení dvoufaktorového ověření","ui.user-manager.disableTotp":"Deaktivovat dvoufaktorové ověření","ui.user-manager.invite":"Pozvat uživatele","ui.user-manager.delete":"Smazat","ui.user-manager.deleteConfirm":"Opravdu chcete smazat \\"{username}\\"?","ui.user-manager.deleted":"Úspěšně došlo ke smazání {username}","ui.user-manager.passwordHeadline":"Změnit heslo","ui.user-manager.passwordText":"Abyste mohli změnit heslo, zadajte nejdřív vaše stávající a pak vaše nové v odpovídajících polích. ","ui.user-manager.currentPassword":"Současné heslo","ui.user-manager.newPassword":"Nové heslo","ui.user-manager.passwordPlaceholder":"min. 8 znaků","ui.user-manager.submitPassword":"Odeslat","ui.user-manager.passwordChanged":"Vaše heslo bylo úspěšně změněno.","ui.user-manager.passwordError":"Heslo není správné.","ui.user-manager.inviteHeadline":"Pozvat uživatele","ui.user-manager.inviteText":"Pokud potřebujete více přihlášení pro Správce Contaa, můžete zde vytvořit odkaz na pozvání. Sdílejte tento odkaz s někým nebo jej použijte na jiném zařízení k vytvoření nového účtu s danými oprávněními.","ui.user-manager.inviteSuccess1":"Byl vytvořen nový odkaz na pozvání. Níže uvedenou adresu lze použít k vytvoření nového uživatelského účtu pro Správce Contaa. Pozvánka vyprší na {expires} (za týden od nynějška).","ui.user-manager.inviteSuccess2":"Zkopírujte prosím tento odkaz do vaší schránky. Platí jen jednou a již se nezobrazí po zavření tohoto dialogu.","ui.user-manager.createInvitation":"Vytvořit odkaz na pozvání","ui.user-manager.clipboard":"Zkopírovat do schránky","ui.user-manager.permissions":"Dozvědět se víc o povolení","ui.user-manager.cancel":"Zrušit","ui.user-manager.close":"Zavřít","ui.user-manager.you":"Vy","ui.user-manager.2fa":"2FA","ui.user-manager.2faEnabled":"This account is secured by two-factor authentication.","ui.user-manager.2faDisabled":"This account is insecure due to missing two-factor authentication.","ui.user-manager.passkey":"Passkey","ui.user-manager.passkeyTitle":"This account is secured by a Passkey.","ui.totp.headline":"Dvoufaktorové ověření","ui.totp.setupQr":"Naskenujte prosím QR kód pomocí vaší 2FA/TOTP aplikace.","ui.totp.setupCode":"Nemůžete-li naskenovat QR kód, zadejte místo toho následující klíč:","ui.totp.codeLabel":"Ověřovací kód","ui.totp.codeDescription":"Zadejte prosím ověřovací kód vygenerovaný vaší 2FA/TOTP aplikací.","ui.totp.disableText":"Zadejte prosím ověřovací kód, abyste deaktivovali dvoufaktorové ověření. ","ui.totp.invalid":"Ověřovací kód není platný.","ui.totp.enable":"Aktivovat","ui.totp.disable":"Deaktivovat","ui.totp.cancel":"Zrušit","ui.totp.enabled":"Dvoufaktorové ověření bylo úspěšně aktivováno.","ui.totp.disabled":"Dvoufaktorové ověření bylo úspěšně deaktivováno.","ui.totp.setup":"Nastavení dvoufaktorového ověření","ui.totp.skip":"Skip Two-Factor Authentication"}')}}]);"use strict";(self["webpackChunkcontao_manager"]=self["webpackChunkcontao_manager"]||[]).push([[715],{3715:function(e){e.exports=JSON.parse('{"ui.app.httpsHeadline":"!! Небезопасное соединение !!","ui.app.httpsDescription":"Без использования HTTPS ваши конфиденциальные данные будут переданы не зашифрованными.","ui.app.httpsLink":"Больше информации","ui.app.httpsHref":"https://https.cio.gov/everything/","ui.app.safeModeHeadline":"!! Включен безопасный режим !!","ui.app.safeModeDescription":"Некоторые функции Contao Manager недоступны.","ui.app.safeModeExit":"Выйти из безопасного режима","ui.app.limitedHeadline":"Удаленная авторизация ","ui.app.limitedDescription":"У вас ограничены разрешения, поскольку вы вошли без ввода пароля.","ui.app.limitedLogout":"Повторная авторизация","ui.app.totpHeadline":"Примечание о безопасности","ui.app.totpDescription":"Настройте двухфакторную авторизацию сейчас, чтобы защитить ваш аккаунт.","ui.app.totpSetup":"Настроить","ui.app.loading":"Загрузка Contao Manager...","ui.app.apiError":"Неожиданный статус API","ui.app.configSecurity1":"ПРЕДУПРЕЖДЕНИЕ СИСТЕМЫ БЕЗОПАСНОСТИ !!! Обнаружен незащищенный каталог конфигурации","ui.app.configSecurity2":"Contao Manager обнаружил, что файлы его конфигурации общедоступны. Все операции отключены до тех пор, пока каталог не будет защищен, в противном случае злоумышленник сможет получить доступ к конфиденциальным данным установки.\\n\\nЧтобы устранить эту проблему, обязательно запретите доступ к каталогу \\"contao-manager\\" на вашем сервере. Чтобы узнать, как это сделать, обратитесь к руководству пользователя веб-сервера или свяжитесь с вашим хостинг-провайдером.","ui.account.welcome":"Приветствие","ui.account.intro1":"Добро пожаловать в Contao Manager, универсальный набор инструментов для установки и управления Contao Open Source CMS. Если вы новичок в этом, {readTheManualToGetStarted}.","ui.account.introGetStarted":"{readTheManual} чтобы начать работу","ui.account.introManual":"прочтите руководство","ui.account.intro2":"Если у вас возникли какие-либо проблемы, см. {ourGithubIssues}, а так-же не стесняйтесь создавать новые вопросы для всего, о чем еще не сообщалось.","ui.account.introIssues":"наши GitHub вопросы","ui.account.headline":"Учетная запись","ui.account.description":"Для управления установкой, создайте учетную запись для Contao Manager. Имейте в виду, что эта учетная запись не связана с панелью управления Contao, либо внешним интерфейсом.","ui.account.username":"Имя пользователя","ui.account.password":"Пароль","ui.account.passwordPlaceholder":"мин. 8 символов","ui.account.passwordLength":"Введите не менее 8 символов.","ui.account.loginInvalid":"Произошла ошибка при создании аккаунта. Попробуйте другое имя пользователя.","ui.account.submit":"Создать учетную запись","ui.account.usePassword":"Использовать пароль для входа","ui.account.usePasskey":"Использовать Passkey для входа","ui.account.totpHeadline":"Двухфакторная авторизация","ui.account.totpDescription":"Включите двухфакторную авторизацию, которая добавит дополнительный уровень безопасности к вашей учетной записи. В дополнение к вашему имени пользователя и паролю вам нужно будет ввести код подтверждения, сгенерированный двухфакторным приложением, таким как 1Password, Authy, Google Authenticator, Microsoft Authenticator, LastPass Authenticator или любым другим приложением TOTP.","ui.account.totpSetup":"Настроить сейчас","ui.account.totpSkip":"Настроить потом","ui.account.login":"Отклонить приглашение","ui.account.contribute1":"Contao и Contao Manager спонсируются некоммерческой ассоциацией Contao.","ui.account.contribute2":"Пожалуйста, подумайте о внесении вклада в открытый исходный код {donate}.","ui.account.contributeDonate":"сделать пожертвование","ui.login.headline":"Вход в систему","ui.login.description":"Войдите в систему для управления установкой.","ui.login.username":"Имя пользователя","ui.login.password":"Пароль","ui.login.totpHeadline":"Двухфакторная авторизация","ui.login.totpDescription":"Введите проверочный код для завершения процесса входа.","ui.login.totp":"Проверочный код","ui.login.forgotPassword":"Забыли пароль?","ui.login.button":"Вход в систему","ui.login.passkey":"Войти с помощью Passkey","ui.login.cancel":"Отмена","ui.login.or":"или","ui.login.locked":"Доступ запрещен, потому, что Contao Manager заблокирован. Чтобы разблокировать, удалите файл {lockFile} в корневом каталоге Contao.","ui.logout.headline":"Тайм-аут сеанса","ui.logout.warning":"Вы были неактивны более 25 минут. Из соображений безопасности ваша сессия будет прервана в ближайшее время.","ui.logout.expired":"Ваш сеанс был автоматически прерван, потому, что вы были неактивны более 30 минут.","ui.logout.renew":"Оставаться в системе","ui.logout.logout":"Выход","ui.logout.login":"Вернуться на страницу входа","ui.oauth.error":"Неверная попытка OAuth. Проверьте параметры запроса.","ui.oauth.https":"URI перенаправления ДОЛЖЕН использовать защищенный протокол (https:), чтобы предотвратить передачу токена авторизации в виде открытого текста.","ui.oauth.headline":"Удаленная авторизация ","ui.oauth.description":"Следующее приложение или служба запрашивает удаленный доступ к экземпляру Contao Manager.","ui.oauth.domain":"Прежде чем разрешить доступ, убедитесь, что этот URL вам известен и вы доверяете его владельцу!","ui.oauth.outOfScope":"К сожалению, у вас нет необходимых разрешений для предоставления такого доступа.","ui.oauth.allow":"Разрешить доступ","ui.oauth.deny":"Запретить доступ","ui.oauth.switchUser":"Сменить пользователя","ui.scope.admin":"Административный доступ, включая управление пользователями","ui.scope.install":"Установка новых пакетов и изменение конфигурации Contao","ui.scope.update":"Обновление пакетов и выполнение задач по техническому обслуживанию","ui.scope.read":"Чтение пакетов и конфигурации","ui.boot.headline":"Проверка системы","ui.boot.description":"Подождите, мы анализируем ваш сервер...","ui.boot.issue1":"Обнаруженные проблемы установки","ui.boot.issue2":"Ваша установка имеет проблемы, которые должны быть исправлены, перед использованием Contao Manager.","ui.boot.run":"Запуск Contao Manager","ui.boot.safeMode":"Запуск в безопасном режиме","ui.recovery.headline":"Восстановление системы","ui.recovery.description":"Contao Manager обнаружил файлы, которые выглядят как файлы Contao, но интерфейс командной строки не работает как положено.","ui.recovery.console":"Вывод консоли","ui.recovery.repairOptions":"Выберите вариант восстановления вашей установки.","ui.recovery.repairHeadline":"Автоматическое восстановление","ui.recovery.repairDescription":"Пытаться автоматически восстановить установку путем перестроения кеша приложения и повторной установки пакетов Composer.","ui.recovery.repairWarning":"Любые изменения в файлах каталога vendor могут быть удалены в процессе!","ui.recovery.repairFailed":"Автоматическое восстановление не удалось. Используйте безопасный режим, чтобы восстановить установку вручную.","ui.recovery.repairButton":"Запустить системное восстановление","ui.recovery.safeModeHeadline":"Безопасный режим","ui.recovery.safeModeDescription":"Запуск Contao Manager в безопасном режиме позволяет управлять пакетами и запускать определенные задачи обслуживания, но функции, которые опираются на рабочую установку Contao, будут недоступны.","ui.recovery.safeModeButton":"Запуск в безопасном режиме","ui.server.pending":"Ожидание...","ui.server.running":"Анализ...","ui.server.error":"Проверка завершилась неудачно из-за неожиданного ответа с сервера.","ui.server.details":"Сведения","ui.server.prerequisite":"Проверка отменена из-за отсутствия необходимых условий.","ui.server.selfUpdate.title":"Обновления Contao Manager","ui.server.selfUpdate.update":"Доступна новая версия Contao Manager {latest}.","ui.server.selfUpdate.manualUpdate":"Доступна новая версия Contao Manager {latest}. Ваш сервер не поддерживает автоматическое обновление, загрузите новую версию из {download}.","ui.server.selfUpdate.latest":"Вы используете последнюю версию {current}.","ui.server.selfUpdate.dev":"Тестовые сборки не поддерживает автоматическое обновление.","ui.server.selfUpdate.unsupported":"Доступна новая версия, но она не поддерживает вашу версию PHP.","ui.server.selfUpdate.button":"Запустить самообновление","ui.server.selfUpdate.continue":"Продолжить","ui.server.config.title":"Конфигурация сервера","ui.server.config.setup":"Настроить","ui.server.config.change":"Изменить","ui.server.config.save":"Сохранить","ui.server.config.cancel":"Отмена","ui.server.config.customOption":"Другие…","ui.server.config.description":"Для правильного выполнения фоновых задач, Contao Manager необходимо знать, где найти двоичный файл командной строки PHP и как выполнять команды, отделенные от веб-процесса.","ui.server.config.formTitle":"Конфигурация сервера","ui.server.config.formText":"Введите путь к вашему бинарному файлу PHP. Убедитесь, что бинарный файл той же версии PHP, что и ваш веб-процесс.","ui.server.config.cloudTitle":"Composer Resolver Cloud","ui.server.config.cloudText":"Composer Resolver Cloud позволяет устанавливать зависимости Composer даже если сервер не предоставляет достаточно локальной памяти. Имейте в виду, что информация о пакетах будет передана на облачный сервер, управляемый Contao Association.","ui.server.config.cloud":"Использовать Composer Resolver Cloud","ui.server.config.cli":"Бинарный файл PHP","ui.server.config.stateErrorCli":"На сервере не найден верный бинарный файл PHP.","ui.server.config.stateErrorCloud":"Composer Resolver Cloud не поддерживается.","ui.server.config.stateSuccess":"Бинарный файл PHP {php_cli}.","ui.server.php_web.title":"Веб-процесс PHP","ui.server.php_web.below7":"Найдена версия PHP {version}. Перейдите на PHP 7 как можно скорее!","ui.server.php_web.success":"Найдена версия PHP {version}, известные проблемы не найдены.","ui.server.php_cli.title":"Интерфейс командной строки PHP","ui.server.php_cli.success":"Найдена версия PHP {version}, известные проблемы не найдены.","ui.server.composer.title":"Окружающая среда Composer","ui.server.composer.success":"Известных проблем не обнаружено.","ui.server.composer.install":"Зависимости Composer не установлены.","ui.server.composer.button":"Установить","ui.server.contao.title":"Установка Contao","ui.server.contao.setup":"Настроить","ui.server.contao.check":"Проверить базу данных","ui.server.contao.empty":"Установка Contao не найдена.","ui.server.contao.old":"Contao версии {version} не совместима с Contao Manager, пожалуйста, обновите установку Contao вручную.","ui.server.contao.found":"Найдена Contao {version} (версия API {api}).","ui.server.contao.connectionError":"Не удается подключиться к серверу базы данных.","ui.server.contao.connectionProblem":"Обнаружена проблема с базой данных.","ui.server.contao.missingUser":"Учетная запись администратора не найдена.","ui.setup.continue":"Продолжить","ui.setup.manager":"Запуск Contao Manager","ui.setup.cancel":"Отмена","ui.setup.welcome":"Приветствие","ui.setup.welcome1":"Этот мастер проведет вас через необходимые шаги для настройки и установки системы с открытым исходным кодом Contao CMS.","ui.setup.welcome2":"Если у вас есть какие-либо вопросы, найдите документацию, форумы, канал Slack и многое другое на странице {support}.","ui.setup.support":"поддержка сообщества","ui.setup.start":"Начать","ui.setup.complete":"Поздравляем!","ui.setup.complete1":"Contao {version} успешно установлена.","ui.setup.complete2":"Для завершения установки, откройте мастер установки, настройте подключение к базе данных и создайте учетную запись панели управления.","ui.setup.complete3":"Теперь можно приступить к созданию своего веб-сайта, с помощью панели управления Contao. Если нужны дополнительные расширения, перейдите в Contao Manager.","ui.setup.installTool":"Открыть мастер установки","ui.setup.login":"Войти в Contao","ui.setup.funding":"Свободное программное обеспечение означает \\"бесплатно\\" как \\"свобода слова\\", а не как \\"бесплатное пиво\\". Для такого проекта с открытым исходным кодом, как Contao, требуются суммы денег, которые не могут быть собраны одним человеком или компанией.\\nЕсли у Вас есть веб-сайт или Вы продаете веб-сайты, созданные с помощью Contao, мы были бы рады, если бы Вы внесли посильный финансовый вклад в продукт, на который опирается Ваш бизнес.","ui.setup.fundingLink":"Узнать больше","ui.setup.document-root.headline":"Настройка веб-сервера","ui.setup.document-root.warning":"Чтобы установить Contao с помощью Contao Manager, необходимо исправить корень документа на веб-сервере.","ui.setup.document-root.description1":"Contao использует отдельный каталог для общедоступных файлов, файлы приложений устанавливаются в родительский каталог. Contao не может быть установлен, если структура каталогов неверна или каталоги не пусты.","ui.setup.document-root.description2":"Если вы не знаете, как настроить корень документа, ознакомьтесь с документацией Contao или обратитесь к хостинг-провайдеру.","ui.setup.document-root.documentation":"Читать документацию","ui.setup.document-root.conflictsTitle":"Каталог установки не пустой","ui.setup.document-root.conflictsDirectory":"Корневой каталог будущей установки Contao не пустой, найдено {count} файла(ов), которые могут быть перезаписаны в процессе установки. Рекомендуется создать пустую структуру каталогов для установки Contao. Также вы можете удалить следующие файлы и проверить еще раз, уверены ли вы, что они не используются.","ui.setup.document-root.ignoreConflicts":"Я хочу установить Contao в непустой каталог. Я понимаю, что это может перезаписать любые существующие файлы в моем веб-пространстве.","ui.setup.document-root.check":"Проверить еще раз","ui.setup.document-root.create":"Создать каталоги","ui.setup.document-root.change":"Изменить каталоги","ui.setup.document-root.formTitle":"Настройка каталога","ui.setup.document-root.formText1":"Contao Manager может автоматически создать новую структуру каталогов на сервере.","ui.setup.document-root.formText2":"Необходимо вручную настроить новый корень документа (например, через панель администратора хостинга).","ui.setup.document-root.autoconfig":"Я понимаю, что мне нужно изменить конфигурацию сервера. Если не настроить корневой каталог документа, это сломает Contao Manager и откроет файлы конфигурации (включая данные учетной записи и пароли)!","ui.setup.document-root.directory":"Новый каталог","ui.setup.document-root.currentRoot":"Текущий корень документа","ui.setup.document-root.newRoot":"Новый корень документа","ui.setup.document-root.finish":"Каталоги установки","ui.setup.document-root.publicDir":"Использовать {dir} для общедоступных файлов (Contao {version})","ui.setup.document-root.directoryInvalid":"Введите допустимое имя каталога.","ui.setup.document-root.directoryExists":"Целевой каталог уже существует. Введите другое имя.","ui.setup.document-root.confirmation":"Contao Manager успешно создал каталог, необходимый для установки Contao. Теперь необходимо настроить корневой каталог документа на веб-сервере. Не перезагружайте эту страницу до тех пор.","ui.setup.document-root.reload":"Перезагрузить страницу","ui.setup.document-root.success":"Структура каталогов на веб-сервере настроена правильно!","ui.setup.document-root.installingProjectDir":"Файлы приложения будут установлены в {dir}.","ui.setup.document-root.installingPublicDir":"Общедоступные файлы будут установлены в {dir}.","ui.setup.document-root.installedProjectDir":"Файлы приложения устанавливаются в {dir}.","ui.setup.document-root.installedPublicDir":"Общедоступные файлы устанавливаются в {dir}.","ui.setup.create-project.headline":"Установка Contao","ui.setup.create-project.description":"Разработка Contao следует принципу {semver}, новая минорная версия выпускается каждые шесть месяцев. В настоящее время поддерживаются следующие релизы:","ui.setup.create-project.semver":"Семантическое управление версиями","ui.setup.create-project.latestTitle":"Последняя версия","ui.setup.create-project.ltsTitle":"Версия с долгосрочной поддержкой","ui.setup.create-project.latestQ1":"Последняя версия предлагает большинство функций с поддержкой до февраля {year}.","ui.setup.create-project.latestQ3":"Последняя версия предлагает большинство функций с поддержкой до августа {year}.","ui.setup.create-project.ltsText":"Текущая LTS-версия, если вы предпочитаете стабильность, предлагает долгосрочную поддержку до февраля {year}.","ui.setup.create-project.pltsText":"Предыдущая LTS-версия, по-прежнему имеет долгосрочную поддержку до февраля {year}.","ui.setup.create-project.requiresPHP":"Требуется PHP версии минимум {version}, у вас PHP {current}.","ui.setup.create-project.releaseplan":"Для получения дополнительной информации см. {contaoReleasePlan}.","ui.setup.create-project.releaseplanLink":"План выпуска Contao","ui.setup.create-project.installed":"Contao {version} успешно установлена на сервере. Продолжайте настройку базы данных или запустите Contao Manager для установки другой версии.","ui.setup.create-project.formTitle":"Выберите дистрибутив","ui.setup.create-project.formText":"Выберите, какую версию следует установить.","ui.setup.create-project.version":"Версия","ui.setup.create-project.demo":"Установить демонстрационный веб-сайт Contao.","ui.setup.create-project.demoDescription":"Демонстрационный веб-сайт поможет вам познакомиться с Contao и всеми его основными функциями. Дополнительные темы можно найти в {store}.","ui.setup.create-project.coreOnly":"Минимальная установка (Только ядро)","ui.setup.create-project.noUpdate":"Пропустить установку (Только для экспертов!)","ui.setup.create-project.theme":"Contao тема","ui.setup.create-project.themeInstall":"Для установки темы Contao, используйте поиск или загрузите файл темы (.cto/.zip), который поддерживает установку через Contao Manager.","ui.setup.create-project.themeBuy":"Обязательно посетите официальный {store}.","ui.setup.create-project.themeStore":"Магазин тем Contao","ui.setup.create-project.themeUpload":"Загрузить файл темы (.cto/.zip)","ui.setup.create-project.themeInvalid":"Загруженный файл не является темой Contao или не поддерживает Contao Manager.","ui.setup.create-project.themeWarning":"Contao Manager не может определить, совместима ли эта тема с вашим сервером. Если у вас возникают вопросы, обратитесь к поставщику темы.","ui.setup.create-project.themeTitle":"Просмотр сведений о теме","ui.setup.create-project.themeDetails":"С этой темой будут установлены следующие зависимости и файлы.","ui.setup.create-project.themeRequire":"{count} зависимость | {count} зависимостей","ui.setup.create-project.themeFiles":"{count} файл | {count} файлов","ui.setup.create-project.theme.or":"или выполните поиск в общедоступных темах","ui.setup.create-project.theme.search":"Поиск тем","ui.setup.create-project.theme.more":"Больше тем","ui.setup.create-project.theme.empty":"Нет соответствующих тем {query}","ui.setup.create-project.theme.uploaded":"Файл темы загружен успешно.","ui.setup.create-project.theme.packageName":"Имя пакета","ui.setup.create-project.theme.version":"Версия","ui.setup.create-project.theme.authors":"Автор(ы)","ui.setup.create-project.install":"Установить","ui.setup.create-project.cancel":"Отмена","ui.setup.database-connection.headline":"Подключение к базе данных","ui.setup.database-connection.description":"Contao требуется базы данных MySQL (или совместимого форка, такого как MariaDB) для хранения страниц, контента, пользователей и других реляционных данных. Параметры подключения хранятся в файле {env} в корне проекта вашей установки Contao.","ui.setup.database-connection.formTitle":"Параметры подключения","ui.setup.database-connection.formText":"Введите URL-адрес базы данных или заполните поля имени пользователя, пароля, сервера и базы данных отдельно.","ui.setup.database-connection.url":"URL базы данных","ui.setup.database-connection.validUrl":"URL-адрес базы данных недействителен или соединение с сервером не выполнено.","ui.setup.database-connection.or":"или","ui.setup.database-connection.user":"Имя пользователя","ui.setup.database-connection.password":"Пароль","ui.setup.database-connection.server":"Сервер (:Порт)","ui.setup.database-connection.database":"Имя базы данных","ui.setup.database-connection.connected":"Соединение с базой данных {database} на {server} успешно установлено.","ui.setup.database-connection.error":"Ошибка подключения к базе данных.","ui.setup.database-connection.problem":"Contao обнаружила проблему с сервером базы данных.","ui.setup.database-connection.schemaTitle":"Схема базы данных","ui.setup.database-connection.migration":"Существует одна незавершенная миграция. | Есть {count} ожидающие миграции.","ui.setup.database-connection.schema":"Существует одна ожидающая обновления схема. | Есть {count} ожидающих обновления схем.","ui.setup.database-connection.noChanges":"Схема базы данных обновлена.","ui.setup.database-connection.check":"Проверить базу данных","ui.setup.database-connection.skip":"Пропустить","ui.setup.database-connection.save":"Сохранить","ui.setup.database-connection.change":"Изменить учетные данные","ui.setup.database-connection.restoreTitle":"Импорт базы данных","ui.setup.database-connection.restoreText":"Только что установленная тема содержит резервную копию базы данных. Восстановите базу данных, чтобы импортировать данные темы или пропустите этот шаг, чтобы начать с чистой установки Contao. | Только что установленная тема содержит несколько резервных копий базы данных. Выберите файл резервной копии для импорта данных темы или пропустите этот шаг, чтобы начать с чистой установки Contao.","ui.setup.database-connection.backup":"Резервное копирование текущей базы данных перед импортом","ui.setup.database-connection.backupWarning":"При импорте все данные в базе данных будут перезаписаны! Если база данных не пуста, сначала создайте резервную копию.","ui.setup.database-connection.restore":"Импорт базы данных темы","ui.setup.database-connection.restoreOption":"Резервная копия из {date} ({size})","ui.setup.database-connection.restored":"База данных темы была успешно импортирована. Продолжайте проверять схему базы данных.","ui.setup.backend-user.success":"В базе данных обнаружена учетная запись администратора для панели управления Contao. Используйте панель управления Contao, чтобы добавить больше пользователей.","ui.setup.backend-user.error":"Не удалось получить список пользователей. Для получения подробной информации см. вывод консоли.","ui.setup.backend-user.headline":"Учетная запись панели управления","ui.setup.backend-user.description":"Для управления своим веб-сайтом, вам необходимо иметь хотя бы одну учетную запись администратора в панели управления Contao. Имейте в виду, что эта учетная запись не связана с Contao Manager.","ui.setup.backend-user.formTitle":"Создать учетную запись","ui.setup.backend-user.formText":"Введите данные для новой учетной записи панели управления.","ui.setup.backend-user.username":"Имя пользователя","ui.setup.backend-user.name":"Имя","ui.setup.backend-user.email":"E-mail адрес","ui.setup.backend-user.emailInvalid":"Введите допустимый e-mail","ui.setup.backend-user.password":"Пароль","ui.setup.backend-user.passwordPlaceholder":"мин. 8 символов","ui.setup.backend-user.passwordLength":"Введите не менее 8 символов.","ui.setup.backend-user.create":"Добавить учетную запись","ui.task.headline":"Фоновая задача","ui.task.loading":"Загрузка сведений...","ui.task.created":"Загрузка сведений...","ui.task.active":"Подождите, пока Contao Manager выполняет задачи в фоновом режиме.","ui.task.complete":"Все операции успешно завершены. Дополнительные сведения см. в протоколе консоли.","ui.task.aborting":"Подождите, пока отменяются фоновые операции.","ui.task.stopped":"Некоторые фоновые операции были отменены. Проверьте протокол консоли.","ui.task.error":"Непредвиденная остановка фоновой операции. Проверьте протокол консоли.","ui.task.failed":"Contao Manager не удалось запустить фоновую задачу!","ui.task.failedDescription1":"Что-то пошло не так при попытке выполнения операций в фоновом режиме.","ui.task.failedDescription2":"Если это событие произойдет снова, ваш сервер может не поддерживаться.","ui.task.reportProblem":"Сообщить о проблеме","ui.task.sponsor":"Composer Cloud спонсируется {sponsor}","ui.task.buttonAudit":"Обновить базу данных","ui.task.buttonClose":"Закрыть","ui.task.buttonConfirm":"Подтвердить и закрыть","ui.task.buttonCancel":"Отмена","ui.task.confirmCancel":"Вы действительно хотите отменить задачу? Это может оставить вашу установку Contao в не работающем состоянии!","ui.task.autoclose":"Закрыть сведения об успешном выполнении задачи","ui.console.toggle":"Показать/Скрыть вывод консоли","ui.console.showLog":"Показать полный журнал консоли","ui.console.copyLog":"Скопировать журнал в буфер обмена","ui.migrate.headline":"Обновления базы данных","ui.migrate.migrationsOnly":"(только миграции)","ui.migrate.schemaOnly":"(только схема)","ui.migrate.loading":"Подождите, идет проверка базы данных...","ui.migrate.empty":"Отложенных миграций или обновлений схемы не обнаружено. Ваша база данных актуальна.","ui.migrate.emptyMigrations":"Отложенных миграций не найдено. Не забудьте проверить наличие обновлений схемы.","ui.migrate.emptySchema":"Отложенных обновлений схемы не найдено. Не забудьте проверить миграции.","ui.migrate.pending":"Ваша база данных не обновлена. Просмотрите приведенный ниже вывод консоли и внесите изменения.","ui.migrate.previousChanges":"Предыдущая миграция базы данных не была подтверждена.\\nПросмотрите приведенный ниже вывод консоли, а затем продолжите просмотр следующих изменений.","ui.migrate.previousComplete":"Предыдущая миграция базы данных не была подтверждена, просмотрите вывод консоли ниже.\\nОжидаемых изменений больше нет.","ui.migrate.appliedChanges":"Были применены обновления базы данных.\\nПросмотрите приведенный ниже вывод консоли, а затем продолжите просмотр следующих изменений.","ui.migrate.appliedComplete":"Были применены обновления базы данных.\\nБольше нет ожидающих миграций или обновлений схемы. База данных обновлена.","ui.migrate.problem":"Contao обнаружила проблему с сервером базы данных.\\nПросмотрите вывод консоли ниже, чтобы узнать, что необходимо исправить. | Contao обнаружила проблемы с сервером базы данных.\\nПросмотрите вывод консоли ниже, чтобы узнать, что необходимо исправить.","ui.migrate.warning":"Contao обнаружила неправильную конфигурацию сервера базы данных.\\nПредупреждения могут быть временно пропущены, но должны быть исправлены для обеспечения оптимальной производительности и целостности данных.","ui.migrate.error":"Изменения не могут быть применены. Возможно, ваша база данных была изменена, проверьте еще раз, чтобы повторить попытку.","ui.migrate.execute":"Выполнить","ui.migrate.close":"Закрыть","ui.migrate.confirm":"Подтвердить и закрыть","ui.migrate.cancel":"Отмена","ui.migrate.continue":"Продолжить","ui.migrate.setup":"Настроить","ui.migrate.skip":"Пропустить","ui.migrate.retry":"Проверить еще раз","ui.migrate.retryAll":"Проверить все","ui.migrate.withDeletes":"Выполнить все изменения базы данных, включая запросы DROP.","ui.migrate.migrationTitle":"Миграции базы данных","ui.migrate.schemaTitle":"Обновления схемы","ui.migrate.problemTitle":"Проблемы с базой данных","ui.migrate.warningTitle":"Предупреждения базы данных","ui.migrate.addTable":"Добавить таблицу {table}","ui.migrate.dropTable":"Удалить таблицу {table}","ui.migrate.addField":"Добавить поле {table}.{field}","ui.migrate.changeField":"Изменить поле {table}.{field}","ui.migrate.dropField":"Удалить поле {table}.{field}","ui.migrate.createIndex":"Создать индекс \\"{name}\\" в {table}","ui.migrate.dropIndex":"Удалить индекс \\"{name}\\" в {table}","ui.widget.mandatory":"Поле не должно быть пустым.","ui.widget.blankOption":"Пожалуйста, выберите…","ui.widget.showPassword":"Показать пароль","ui.widget.hidePassword":"Скрыть пароль","ui.error.title":"HTTP запрос для \\"{method} {url}\\" не выполнен.","ui.error.server500":"Вероятно, на сервере произошла непредвиденная ошибка. Проверьте файлы журнала вашего веб-сервера (Apache/Nginx) и журналы Contao Manager по адресу \\"contao-manager/logs\\".","ui.error.response":"Сервер вернул ответ с кодом состояния {status}.","ui.error.moreLink":"Больше информации","ui.error.support":"Поддержка Contao","ui.error.permission":"У вас нет разрешения на использование этой функции.","ui.footer.help":"Справка","ui.footer.reportProblem":"Сообщить о проблеме","ui.navigation.discover":"Обзор","ui.navigation.packages":"Пакеты","ui.navigation.tools":"Инструменты","ui.navigation.installTool":"Мастер установки","ui.navigation.backend":"Панель управления Contao","ui.navigation.debug":"Режим отладки Contao","ui.navigation.logViewer":"Просмотр журнала","ui.navigation.phpinfo":"Информация о PHP","ui.navigation.phpinfoLoading":"Загрузка информации о PHP...","ui.navigation.maintenance":"Обслуживание","ui.navigation.rebuildCache":"Восстановить кеш","ui.navigation.users":"Учетные записи","ui.navigation.systemCheck":"Проверка системы","ui.navigation.advanced":"Расширенный","ui.navigation.logout":"Выход","ui.maintenance.database.title":"Миграция баз данных и резервное копирование","ui.maintenance.database.description":"Миграция базы данных обеспечивает согласованность данных и схем таблиц.","ui.maintenance.database.migrations":"Одна отложенная миграция базы данных | {count} незавершенных миграций базы данных.","ui.maintenance.database.schemaUpdates":"Одно ожидающее обновление схемы | {count} ожидающих обновлений схемы","ui.maintenance.database.error":"Обнаружена проблема с базой данных.","ui.maintenance.database.warning":"Обнаружены предупреждения базы данных.","ui.maintenance.database.button":"Проверить базу данных","ui.maintenance.database.migrationOnly":"Проверить только миграции","ui.maintenance.database.schemaOnly":"Проверить только схему","ui.maintenance.database.installTool":"Открыть мастер установки","ui.maintenance.database.createBackup":"Создать резервную копию","ui.maintenance.database.backupUnsupported":"Резервное копирование баз данных не поддерживается вашей версией Contao.","ui.maintenance.database.backupList":"У вас есть одна резервная копия базы данных, созданная {date}. | У вас есть {count} резервных копий базы данных, последняя из которых была создана {date}.","ui.maintenance.database.backupEmpty":"На данный момент у вас нет резервных копий базы данных.","ui.maintenance.rebuildCache.title":"Кеш приложения","ui.maintenance.rebuildCache.description":"После изменения любого из файлов конфигурации требуется восстановление кеша приложений.","ui.maintenance.rebuildCache.rebuildProd":"Перестроить производственный кеш","ui.maintenance.rebuildCache.rebuildDev":"Перестроить кеш разработки","ui.maintenance.rebuildCache.clearProd":"Очистить производственный кеш","ui.maintenance.rebuildCache.clearDev":"Очистить кеш разработки","ui.maintenance.installTool.title":"Мастер установки Contao","ui.maintenance.installTool.description":"Мастер установки Contao автоматически блокируется, если вы введете неправильный пароль три раза подряд.","ui.maintenance.installTool.unlock":"Разблокировать мастер установки","ui.maintenance.installTool.lock":"Заблокировать мастер установки","ui.maintenance.dumpAutoload.title":"Загрузчик класса Composer","ui.maintenance.dumpAutoload.description":"Автозагрузчик Composer отвечает за загрузку классов PHP. Автозагрузчик должен быть сброшен после добавления пользовательских пространств имен в корневой файл composer.json.","ui.maintenance.dumpAutoload.button":"Дамп автозапуска","ui.maintenance.composerInstall.title":"Зависимости Composer","ui.maintenance.composerInstall.description":"Зависимости Composer находятся в каталоге {vendor}, в корне приложения. Повторная установка зависимостей может потребоваться после различных манипуляций или ручной загрузки файла {composerLock}.","ui.maintenance.composerInstall.button":"Запустить установщик","ui.maintenance.composerInstall.update":"Запустить обновление Composer","ui.maintenance.composerCache.title":"Кеш Composer","ui.maintenance.composerCache.description":"Composer кеширует загруженные пакеты для улучшения производительности. Если у вас есть проблемы, например, испорченные файлы, попробуйте очистить кеш Composer, чтобы запустить новую загрузку.","ui.maintenance.composerCache.button":"Очистить кеш","ui.maintenance.maintenanceMode.title":"Режим обслуживания","ui.maintenance.maintenanceMode.description":"Перевод Contao в режим обслуживания отобразит шаблон \\"503 Service Unavailable\\" для веб-сайта.","ui.maintenance.maintenanceMode.enable":"Включить","ui.maintenance.maintenanceMode.disable":"Выключить","ui.maintenance.debugMode.title":"Режим отладки","ui.maintenance.debugMode.description":"Активируйте режим отладки, задав имя пользователя и пароль для точки входа {appDevPhp}.","ui.maintenance.debugMode.descriptionJwt":"Активируйте режим отладки, установив файл отладки cookie для текущего домена.","ui.maintenance.debugMode.activate":"Активировать","ui.maintenance.debugMode.deactivate":"Деактивировать","ui.maintenance.debugMode.credentials":"Полномочия","ui.maintenance.debugMode.user":"Введите имя пользователя для режима отладки.","ui.maintenance.debugMode.password":"Введите пароль для режима отладки.","ui.maintenance.opcodeCache.title":"Кеш Opcode","ui.maintenance.opcodeCache.description":"Opcode кеширует PHP-файлы в веб-процессе для более быстрого выполнения. Он должен быть удален при определенных обстоятельствах, если файлы не распознаются после изменения.","ui.maintenance.opcodeCache.button":"Усечение кеша","ui.maintenance.safeMode":"Недоступно в безопасном режиме","ui.maintenance.unsupported":"Не поддерживается этой версией Contao","ui.packages.updateButton":"Обновить пакеты","ui.packages.searchButton":"Поиск пакетов","ui.packages.searchPlaceholder":"Поиск пакетов...","ui.packages.uploadOverlay":"Перетащите файлы для загрузки","ui.packages.uploadButton":"Загрузить пакеты","ui.packages.uploadMessage":"У вас одна неподтвержденная загрузка. | У вас неподтвержденных загрузок {count}.","ui.packages.uploadApply":"Подтвердить загрузки","ui.packages.uploadReset":"Удалить загрузки","ui.packages.uploadIncomplete":"Этот файл не был загружен полностью. Удалите его и попробуйте еще раз.","ui.packages.uploadDuplicate":"Этот файл загружен несколько раз. Удалите дубликаты.","ui.packages.uploadInstalled":"Этот файл уже установлен. Удалите дубликаты.","ui.packages.uploadUnsupported":"Загрузка не поддерживается текущей установкой. Убедитесь, что установлено расширение PHP ZIP и не забудьте обновить зависимости.","ui.packages.changesMessage":"У вас одно неподтвержденное изменение. | У вас неподтвержденных изменений {count}.","ui.packages.changesDryrun":"Пробный прогон","ui.packages.changesApply":"Применить изменения","ui.packages.changesApplyAll":"Обновить все пакеты","ui.packages.changesDryrunAll":"Пробный прогон всех пакетов","ui.packages.changesReset":"Сброс изменений","ui.packages.changesReview":"Обзор изменений","ui.packagelist.loading":"Загрузка...","ui.packagelist.uploads":"Загрузки","ui.packagelist.added":"Новые пакеты","ui.packagelist.installed":"Установленные пакеты","ui.package.hintRevert":"Отменить изменения","ui.package.hintNoupdate":"Не обновлять","ui.package.hintConstraint":"Этот пакет будет установлен с ограничением {constraint} при применении изменений.","ui.package.hintConstraintBest":"Этот пакет будет установлен в наилучшей доступной версии при применении изменений.","ui.package.hintConstraintChange":"Ограничение этого пакета будет изменено с \\"{from}\\" на \\"{to}\\" при применении изменений.","ui.package.hintConstraintUpdate":"Этот пакет будет обновлен при применении изменений.","ui.package.hintAdded":"Этот пакет будет установлен при применении изменений.","ui.package.hintRemoved":"Этот пакет будет удален при применении изменений.","ui.package.requiredTitle":"добавлено вручную","ui.package.requiredText":"Этот пакет необходим в composer.json, но он не установлен.","ui.package.removedTitle":"удалено вручную","ui.package.removedText":"Этот пакет удален из вашего composer.json.","ui.package.installed":"Установлена:","ui.package.version":"Версия {version}","ui.package.additionalDownloads":"Загрузок {count} | Загрузок {count}","ui.package.additionalStars":"Звёзд {count} | Звёзд {count}","ui.package.editConstraint":"Редактировать","ui.package.uploadConstraint":"Это ограничение определяется загруженным пакетом.","ui.package.updateButton":"Обновить","ui.package.removeButton":"Удалить","ui.package.installButton":"Добавить пакет","ui.package.installButtonShort":"Добавить","ui.package.detailsButton":"Сведения","ui.package.latestConstraint":"последняя версия","ui.package.update":"Доступно обновление","ui.package.updateLatest":"последняя версия","ui.package.updateAvailable":"{version} доступна","ui.package.updateUnknown":"неизвестная версия","ui.package.updateConstraint":"Доступна более новая версия, выходящая за рамки вашего ограничения версии.","ui.package.incompatible":"{package} не работает с Contao {constraint}.","ui.cloudStatus.headline":"Composer Resolver Cloud","ui.cloudStatus.version":"Версия {version}","ui.cloudStatus.waitingTime":"Время ожидания","ui.cloudStatus.jobs":"Текущие задания","ui.cloudStatus.workers":"Рабочие","ui.cloudStatus.approx":"{minutes} мин","ui.cloudStatus.none":"ни один","ui.cloudStatus.short":"прим. {minutes} мин","ui.cloudStatus.long":"прим. {minutes} мин {seconds} сек","ui.cloudStatus.error":"Не удалось получить статус облака Resolver Composer. Вероятно, он не работает из-за проблем с обслуживанием или неполадок.","ui.cloudStatus.button":"Статус облака","ui.cloudStatus.refresh":"Обновить статус облака","ui.log-viewer.loading":"Загрузка...","ui.log-viewer.empty":"На вашем сервере нет файлов журнала.","ui.log-viewer.reload":"Перезагрузить","ui.log-viewer.file":"Файл журнала","ui.log-viewer.channel":"Канал","ui.log-viewer.channelTitle":"Канал, на который было зарегистрировано это сообщение.","ui.log-viewer.level":"Уровень","ui.log-viewer.levelTitle":"Уровень журнала или серьезность сообщения журнала.","ui.log-viewer.timeHeader":"Время","ui.log-viewer.messageHeader":"Сообщение","ui.log-viewer.showContext":"Показать контекст","ui.log-viewer.hideContext":"Скрыть контекст","ui.log-viewer.showExtra":"Показать дополнительное","ui.log-viewer.hideExtra":"Скрыть дополнительное","ui.log-viewer.more":"Загрузить больше...","ui.log-viewer.download":"Загрузка","ui.log-viewer.downloadTitle":"Загрузка файла \\"{file}\\"","ui.log-viewer.prodEnvironment":"Рабочая среда","ui.log-viewer.devEnvironment":"Среда разработки (режим отладки)","ui.user-manager.loading":"Загрузка пользователей…","ui.user-manager.changePassword":"Изменить пароль","ui.user-manager.setupTotp":"Настройка двухфакторной авторизации","ui.user-manager.disableTotp":"Отключить двухфакторную авторизацию","ui.user-manager.invite":"Пригласить пользователя","ui.user-manager.delete":"Удалить","ui.user-manager.deleteConfirm":"Вы действительно хотите удалить пользователя \\"{username}\\"?","ui.user-manager.deleted":"Пользователь {username} успешно удален","ui.user-manager.passwordHeadline":"Изменить пароль","ui.user-manager.passwordText":"Чтобы изменить пароль, введите текущий и новый пароль в соответствующие поля.","ui.user-manager.currentPassword":"Текущий пароль","ui.user-manager.newPassword":"Новый пароль","ui.user-manager.passwordPlaceholder":"мин. 8 символов","ui.user-manager.submitPassword":"Отправить","ui.user-manager.passwordChanged":"Ваш пароль был успешно изменён.","ui.user-manager.passwordError":"Этот пароль неверный.","ui.user-manager.inviteHeadline":"Пригласить пользователя","ui.user-manager.inviteText":"Если вам нужно несколько учётных записей для Contao Manager, вы можете создать здесь ссылку-приглашение. Поделитесь этой ссылкой или используйте её на другом устройстве, чтобы создать новую учётную запись с заданными правами доступа.","ui.user-manager.inviteSuccess1":"Создана новая ссылка-приглашение. URL-адрес ниже можно использовать для создания новой учетной записи пользователя для Contao Manager. Приглашение истекает {expires} (через неделю).","ui.user-manager.inviteSuccess2":"Скопируйте ссылку в буфер обмена. Эта ссылка сработает только один раз, и вы больше не сможете её увидеть после закрытия этого диалогового окна.","ui.user-manager.createInvitation":"Создать ссылку-приглашение","ui.user-manager.clipboard":"Копировать в буфер обмена","ui.user-manager.permissions":"Узнать о разрешениях","ui.user-manager.cancel":"Отмена","ui.user-manager.close":"Закрыть","ui.user-manager.you":"Вы","ui.user-manager.2fa":"2FA","ui.user-manager.2faEnabled":"Эта учетная запись защищена двухфакторной авторизацией.","ui.user-manager.2faDisabled":"Эта учетная запись небезопасна из-за отсутствия двухфакторной авторизации.","ui.user-manager.passkey":"Passkey","ui.user-manager.passkeyTitle":"Эта учетная запись защищена с помощью Passkey.","ui.totp.headline":"Двухфакторная авторизация","ui.totp.setupQr":"Пожалуйста, отсканируйте QR-код с помощью вашего приложения для 2FA/TOTP.","ui.totp.setupCode":"Если вы не можете отсканировать QR-код, введите этот ключ вместо него:","ui.totp.codeLabel":"Проверочный код","ui.totp.codeDescription":"Пожалуйста, введите проверочный код, сгенерированный с помощью вашего приложения для 2FA/TOTP.","ui.totp.disableText":"Пожалуйста, введите проверочный код для отключения двухфакторной авторизации.","ui.totp.invalid":"Проверочный код неверный.","ui.totp.enable":"Включить","ui.totp.disable":"Выключить","ui.totp.cancel":"Отмена","ui.totp.enabled":"Двухфакторная авторизация успешно включена.","ui.totp.disabled":"Двухфакторная авторизация успешно отключена.","ui.totp.setup":"Настройка двухфакторной авторизации","ui.totp.skip":"Пропустить двухфакторную авторизацию"}')}}]);"use strict";(self["webpackChunkcontao_manager"]=self["webpackChunkcontao_manager"]||[]).push([[523],{523:function(e){e.exports=JSON.parse('{"ui.app.title":"Contao Erweiterungen","ui.app.loading":"Lade Erweiterungsliste …","ui.app.language":"Sprache für den Contao Manager wechseln","ui.app.colorDark":"Dunkles Design","ui.app.colorDarkTitle":"Farbschema auf dunkel umstellen","ui.app.colorLight":"Helles Design","ui.app.colorLightTitle":"Farbschema auf hell umstellen","ui.discover.advertisement":"Anzeigen in der Erweiterungsliste","ui.discover.loading":"Laden …","ui.discover.offline":"Konnte keine Ergebnisse laden.","ui.discover.offlineExplain":"Prüfe deine Internet-Verbindung und deaktiviere alle JavaScript-Blocker.","ui.discover.offlineButton":"Erneut versuchen","ui.discover.searchPlaceholder":"{count} Erweiterungen durchsuchen …","ui.discover.empty":"Keine Ergebnisse für {query}","ui.discover.more":"Mehr Resultate","ui.discover.sortBy":"Sortieren nach","ui.discover.sortReleased":"Veröffentlicht","ui.discover.sortReleasedTitle":"Ergebnisse nach der Veröffentlichung sortieren","ui.discover.sortLatest":"Aktualisiert","ui.discover.sortLatestTitle":"Ergebnisse nach der letzten Aktualisierung sortieren","ui.discover.sortDownloads":"Downloads","ui.discover.sortDownloadsTitle":"Ergebnisse nach Anzahl Downloads sortieren","ui.discover.sortFavers":"Bewertung","ui.discover.sortFaversTitle":"Ergebnisse nach Bewertung sortieren","ui.discover.detailsButton":"Details","ui.discover.latestPackages":"Neuste und aktualisierte Erweiterungen","ui.discover.faversPackages":"Bestbewertete Erweiterungen","ui.discover.downloadsPackages":"Meistgeladene Erweiterungen","ui.package.homepage":"Projektwebseite","ui.package.private":"Privates Paket","ui.package.privateTitle":"Private Pakete sind nur vom jeweiligen Hersteller verfügbar (z.B. als ZIP-Download). Besuche die Webseite für weitere Informationen.","ui.package.abandoned":"verwaist","ui.package.abandonedText":"Diese Erweiterung ist verwaist und wird nicht mehr gepflegt.","ui.package.abandonedReplace":"Diese Erweiterung ist verwaist und wird nicht mehr gepflegt. Der Autor empfiehlt stattdessen das Paket {replacement} zu verwenden.","ui.package.contaoVersion":"Verfügbar für Contao","ui.package-details.previous":"Details der vorherigen Erweiterung","ui.package-details.close":"Details der Erweiterung schließen","ui.package-details.loading":"Laden …","ui.package-details.tabDescription":"Beschreibung","ui.package-details.tabRequire":"Abhängigkeiten","ui.package-details.tabFeatures":"Funktionen","ui.package-details.tabSuggest":"Empfehlungen","ui.package-details.tabConflict":"Konflikte","ui.package-details.tabDependents":"Abhängige","ui.package-details.linkRequires":"benötigt","ui.package-details.linkReplaces":"ersetzt","ui.package-details.linkProvides":"liefert","ui.package-details.linkConflicts":"inkompatibel mit","ui.package-details.funding":"Weiterentwicklung finanzieren!","ui.package-details.contaoVersions":"Unterstützte Contao-Version(en)","ui.package-details.latest":"Neuste Version","ui.package-details.released":"veröffentlicht am","ui.package-details.license":"Lizenz(en)","ui.package-details.authors":"von","ui.package-details.more":"Mehr","ui.package-details.packagist":"Paketdetails","ui.package-details.metadata":"Metadaten bearbeiten","ui.package-details.support_docs":"Dokumentation","ui.package-details.support_wiki":"Wiki","ui.package-details.support_forum":"Support-Forum","ui.package-details.support_issues":"Fehler melden","ui.package-details.support_source":"Quellcode","ui.package-details.support_irc":"IRC / Chat","ui.package-details.support_email":"Support E-Mail","ui.package-details.support_rss":"RSS-Feed"}')}}]);"use strict";(self["webpackChunkcontao_manager"]=self["webpackChunkcontao_manager"]||[]).push([[554],{4554:function(e){e.exports=JSON.parse('{"ui.app.httpsHeadline":"!! Connexion non sécurisée !!","ui.app.httpsDescription":"Sans HTTPS, vos données confidentielles seront transférées non chiffrées.","ui.app.httpsLink":"Plus d\'information","ui.app.httpsHref":"https://https.cio.gov/everything/","ui.app.safeModeHeadline":"!! Safe Mode enabled !!","ui.app.safeModeDescription":"Some features of the Contao Manager are not available.","ui.app.safeModeExit":"Exit Safe Mode","ui.app.limitedHeadline":"Remote Authentication","ui.app.limitedDescription":"You have limited permissions due to passwordless login.","ui.app.limitedLogout":"Re-authenticate","ui.app.totpHeadline":"Security Notice","ui.app.totpDescription":"Configure two-factor authentication now to secure your account.","ui.app.totpSetup":"Configuration","ui.app.loading":"Chargement de Contao Manager …","ui.app.apiError":"Statut de l\'API inattendu","ui.app.configSecurity1":"ALERTE DE SÉCURITÉ !!! Répertoire de configuration non protégé détecté","ui.app.configSecurity2":"Contao Manager a détecté que ses fichiers de configuration sont accessibles au public. Toutes les opérations sont désactivées jusqu\'à ce que le répertoire soit sécurisé, sinon une personne malintentionnée pourrait accéder aux données sensibles de votre installation.\\n\\nPour résoudre ce problème, assurez-vous d\'empêcher l\'accès au répertoire \\"contao-manager\\" sur votre serveur. Pour savoir comment faire cela, référez-vous au manuel de votre serveur Web ou contactez votre fournisseur d\'hébergement.","ui.account.welcome":"Bienvenue","ui.account.intro1":"Bienvenue dans Contao Manager, un outil universel pour installer et gérer Contao Open Source CMS. Si vous êtes nouveau dans ce domaine, veuillez {readTheManualToGetStarted}.","ui.account.introGetStarted":"{readTheManual} pour commencer","ui.account.introManual":"lire le manuel","ui.account.intro2":"Si vous rencontrez des problèmes, vérifiez {ourGithubIssues} et n\'hésitez pas à créer un nouveau rapport de bug pour tout ce qui n\'a pas encore été signalé.","ui.account.introIssues":"nos problèmes GitHub","ui.account.headline":"Compte d\'utilisateur","ui.account.description":"Pour gérer votre installation, veuillez créer un compte Contao Manager. Sachez que ce compte n\'est pas lié au back office ou front office de Contao.","ui.account.username":"Nom d\'utilisateur","ui.account.password":"Mot de passe","ui.account.passwordPlaceholder":"Min. 8 caractères","ui.account.passwordLength":"Veuillez insérer au moins 8 caractères.","ui.account.loginInvalid":"There was an error when creating the account. Please try a different username.","ui.account.submit":"Créer un compte","ui.account.usePassword":"Use password for login","ui.account.usePasskey":"Use Passkey for login","ui.account.totpHeadline":"Two-factor authentication","ui.account.totpDescription":"Please enable two-factor authentication, which adds an extra layer of security to your account. In addition to your username and password, you will need to enter a verification code generated by a two-factor app such as 1Password, Authy, Google Authenticator, Microsoft Authenticator, LastPass Authenticator or any other TOTP app.","ui.account.totpSetup":"Configure now","ui.account.totpSkip":"Configure later","ui.account.login":"Decline Invitation","ui.account.contribute1":"Contao et le Contao Manager sont parrainés par l\'association à but non lucratif Contao.","ui.account.contribute2":"Please consider contributing to open source by {donate}.","ui.account.contributeDonate":"making a donation","ui.login.headline":"Se connecter","ui.login.description":"Connectez-vous afin de gérer votre installation.","ui.login.username":"Nom d\'utilisateur","ui.login.password":"Mot de passe","ui.login.totpHeadline":"Two-factor authentication","ui.login.totpDescription":"Please enter your verification code to complete the login process.","ui.login.totp":"Verification code","ui.login.forgotPassword":"Mot de passe oublié ?","ui.login.button":"Se connecter","ui.login.passkey":"Sign In with Passkey","ui.login.cancel":"Annuler","ui.login.or":"or","ui.login.locked":"Access has been denied because the Contao Manager is locked. To unlock, delete the {lockFile} file in your Contao root directory.","ui.logout.headline":"Timeout session","ui.logout.warning":"Vous êtes inactif depuis plus de 25 minutes. Pour des raisons de sécurité, votre session va se terminera sous peu.","ui.logout.expired":"votre session a été automatiquement interrompue car vous êtes resté inactif pendant plus de 30 minutes.","ui.logout.renew":"Restez connecté","ui.logout.logout":"Se déconnecter","ui.logout.login":"Retour à la page de connexion","ui.oauth.error":"Tentative de connexion OAuth invalide. Contrôlez le paramètre de la requête.","ui.oauth.https":"The redirect URI MUST use a secure protocol (https:) to prevent the authentication token from being transmitted in clear-text.","ui.oauth.headline":"Remote Authentication","ui.oauth.description":"L\'application ou le service suivant demande un accès à distance de votre instance Contao Manager.","ui.oauth.domain":"Before allowing access, make sure you know this URL and trust its owner!","ui.oauth.outOfScope":"Unfortunately, you do not have the necessary permissions to grant this access.","ui.oauth.allow":"Permettre l\'accès","ui.oauth.deny":"Refuser l\'accès","ui.oauth.switchUser":"Switch User","ui.scope.admin":"Admin access including user management","ui.scope.install":"Install new packages and change Contao configuration","ui.scope.update":"Update packages and execute maintenance tasks","ui.scope.read":"Read packages and configuration","ui.boot.headline":"Vérification du système","ui.boot.description":"Veuillez patienter, nous analysons votre serveur…","ui.boot.issue1":"Problèmes d\'installation détectés","ui.boot.issue2":"Votre installation présente des problèmes qui doivent être résolus avant que Contao Manager puisse être utilisé.","ui.boot.run":"Lancez Contao Manager","ui.boot.safeMode":"Lancer en mode sans échec","ui.recovery.headline":"Récupération du système","ui.recovery.description":"Le Contao Manager a détecté des fichiers qui ressemblent à Contao, mais l\'interface de ligne de commande ne fonctionne pas comme prévu.","ui.recovery.console":"Console Output","ui.recovery.repairOptions":"Veuillez choisir une option pour réparer votre installation.","ui.recovery.repairHeadline":"Réparation automatique","ui.recovery.repairDescription":"Essaye de réparer automatiquement l\'installation en reconstruisant le cache de l\'application et en réinstallant les packages Composer.","ui.recovery.repairWarning":"Toutes les modifications apportées aux fichiers présents dans le dossier Vendor peuvent être supprimées au cours du processus!","ui.recovery.repairFailed":"La réparation automatique a échoué. Essayez le mode sans échec pour réparer manuellement l\'installation.","ui.recovery.repairButton":"Lancer la réparation","ui.recovery.safeModeHeadline":"Mode sans échec","ui.recovery.safeModeDescription":"Lancer le Contao Manager en mode sans échec permet de gérer les packages et d\'exécuter certaines tâches de maintenance, mais les fonctionnalités qui reposent sur une installation fonctionnelle de Contao ne seront pas disponibles.","ui.recovery.safeModeButton":"Lancer en mode sans échec","ui.server.pending":"En attente…","ui.server.running":"En cours d\'analyse…","ui.server.error":"La vérification a échoué en raison d\'une réponse inattendue du serveur.","ui.server.details":"Détails","ui.server.prerequisite":"Vérification annulée en raison d\'un prérequis manquant","ui.server.selfUpdate.title":"Mises à jour de Contao Manager","ui.server.selfUpdate.update":"Une nouvelle version de Contao Manager ({latest}) est disponible.","ui.server.selfUpdate.manualUpdate":"Une nouvelle version {latest} de Contao Manager est disponible. Votre serveur ne prend pas en charge les mises à jour automatiques, veuillez télécharger la nouvelle version à partir de {download}.","ui.server.selfUpdate.latest":"Vous utilisez la dernière version {current}.","ui.server.selfUpdate.dev":"Les versions de développement ne supportent pas les mises à jour automatiques.","ui.server.selfUpdate.unsupported":"Une nouvelle version est disponible mais elle ne supporte pas votre version de PHP.","ui.server.selfUpdate.button":"Lancer la mise à jour","ui.server.selfUpdate.continue":"Continuer","ui.server.config.title":"Configuration du serveur","ui.server.config.setup":"Configurer","ui.server.config.change":"Modifier","ui.server.config.save":"Sauvegarder","ui.server.config.cancel":"Annuler","ui.server.config.customOption":"Autre… ","ui.server.config.description":"Pour exécuter correctement les opérations en tâche de fond, Contao Manager doit savoir où trouver le binaire de PHP en ligne de commande (CLI) et comment exécuter des commandes séparées du processus Web.","ui.server.config.formTitle":"Configuration du serveur","ui.server.config.formText":"Merci de saisir le chemin vers le binaire PHP. La version du binaire PHP doit être la même que pour le processus web.","ui.server.config.cloudTitle":"Composer Resolver Cloud","ui.server.config.cloudText":"Composer Resolver Cloud permet d\'installer des dépendances Composer même si votre serveur ne fournit pas suffisamment de mémoire. Veuillez noter que les informations relatives à votre package seront transmises à un serveur cloud géré par l\'Association Contao.","ui.server.config.cloud":"Utilisé le Composer Resolver Cloud","ui.server.config.cli":"Binaire PHP","ui.server.config.stateErrorCli":"Aucun binaire PHP valide n\'a été trouvé sur le serveur.","ui.server.config.stateErrorCloud":"Le Composer Resolver Cloud n\'est pas pris en charge.","ui.server.config.stateSuccess":"Binaire PHP à {php_cli}.","ui.server.php_web.title":"Processus web de PHP","ui.server.php_web.below7":"La version {version} de PHP a été trouvée. Passez s\'il vous plaît à PHP 7 dès que possible.","ui.server.php_web.success":"Version PHP {version} trouvée, aucun problème connu trouvé.","ui.server.php_cli.title":"PHP en ligne de commande (CLI)","ui.server.php_cli.success":"Version PHP {version} trouvée, aucun problème connu trouvé.","ui.server.composer.title":"Environnement Composer","ui.server.composer.success":"Aucun problème connu trouvé.","ui.server.composer.install":"Les dépendances de Composer ne sont pas installées.","ui.server.composer.button":"Install","ui.server.contao.title":"Installation de Contao","ui.server.contao.setup":"Configuration","ui.server.contao.check":"Vérifier la base de données.","ui.server.contao.empty":"Aucune installation de Contao n\'a été trouvée.","ui.server.contao.old":"La version {version} de Contao n\'est pas compatible avec Contao Manager, veuillez mettre à jour manuellement votre installation.","ui.server.contao.found":"Contao {version} a été détecté (version API {api}).","ui.server.contao.connectionError":"Impossible de se connecter au serveur de base de données","ui.server.contao.connectionProblem":"La base de données a un problème.","ui.server.contao.missingUser":"Admin account not found.","ui.setup.continue":"Continuer","ui.setup.manager":"Lancez Contao Manager","ui.setup.cancel":"Annuler","ui.setup.welcome":"Bienvenue","ui.setup.welcome1":"This wizard will take you through the necessary steps to set up your Contao Open Source CMS installation.","ui.setup.welcome2":"If you have any questions, please find documentation, forums, a Slack channel and more on the {support} page.","ui.setup.support":"community support","ui.setup.start":"Get started","ui.setup.complete":"Congratulations!","ui.setup.complete1":"Contao {version} has been installed successfully.","ui.setup.complete2":"Pour terminer l\'installation, vous devez ouvrir  l\'Outil d\'installation pour configurer la connexion à la base de données et créer un utilisateur back end.","ui.setup.complete3":"You can now start to create your website in the Contao back end. If you need additional extensions, continue to the Contao Manager.","ui.setup.installTool":"Open the Install Tool","ui.setup.login":"Login to Contao","ui.setup.funding":"Free software is \\"free\\" as in \\"free speech\\", not as in \\"free beer\\". An Open Source project like Contao requires amounts of money that can\'t be raised by a single person or company.\\nIf you have a website or sell websites built with Contao, we would love to see you contribute back financially to the product your business relies upon.","ui.setup.fundingLink":"Learn more","ui.setup.document-root.headline":"Configuration du serveur web","ui.setup.document-root.warning":"Pour installer Contao via Contao Manager, vous devez définir la racine du site sur le serveur web.","ui.setup.document-root.description1":"Contao uses a separate folder for public files, application files are installed in its parent folder. Contao cannot be installed if the folder structure is not correct or the folders are not empty.","ui.setup.document-root.description2":"Si vous ne savez pas comment configurer la racine de votre site, veuillez lire la documentation Contao ou contacter votre hébergeur.","ui.setup.document-root.documentation":"Lire la Documentation","ui.setup.document-root.conflictsTitle":"Installation directory not empty","ui.setup.document-root.conflictsDirectory":"The root directory of your future Contao installation is not empty, we have found {count} file(s) that might be overwritten by the installation process. It is recommended to create an empty directory structure for Contao, but you can also remove the following files and check again if you are sure they are unused.","ui.setup.document-root.ignoreConflicts":"I want to install Contao into the non-empty directory. I understand that this might overwrite any existing files on my webspace.","ui.setup.document-root.check":"Check again","ui.setup.document-root.create":"Create directories","ui.setup.document-root.change":"Change directories","ui.setup.document-root.formTitle":"Configuration des répertoires","ui.setup.document-root.formText1":"Le Contao-manager peut créer automatiquement une nouvelle structure de répertoires sur le serveur.","ui.setup.document-root.formText2":"Vous devrez configurer manuellement la nouvelle racine du site (par exemple via un panneau d\'administration d\'hébergement).","ui.setup.document-root.autoconfig":"Je comprends que je dois modifier la configuration de mon serveur. Ne pas configurer la racine du site bloquera le Contao Manager et exposera les fichiers de configuration (y compris les détails du compte et les mots de passe)!","ui.setup.document-root.directory":"Nouveau répertoire","ui.setup.document-root.currentRoot":"Racine du site actuel","ui.setup.document-root.newRoot":"Nouvelle racine du site","ui.setup.document-root.finish":"Répertoires créés","ui.setup.document-root.publicDir":"Use {dir} for public files (for Contao {version})","ui.setup.document-root.directoryInvalid":"Veuillez saisir un nom de répertoire valide.","ui.setup.document-root.directoryExists":"Le répertoire cible existe déjà. Veuillez saisir un autre nom.","ui.setup.document-root.confirmation":"Le Contao Manager a créé avec succès les répertoires nécessaires pour votre installation Contao. Vous devez maintenant configurer la racine du site sur votre serveur web. Ne rechargez pas cette page jusque-là.","ui.setup.document-root.reload":"Recharger la page","ui.setup.document-root.success":"The directory structure on your web server is set up correctly!","ui.setup.document-root.installingProjectDir":"Application files will be installed to {dir}.","ui.setup.document-root.installingPublicDir":"Public files will be installed to {dir}.","ui.setup.document-root.installedProjectDir":"Application files are installed in {dir}.","ui.setup.document-root.installedPublicDir":"Public files are installed in {dir}.","ui.setup.create-project.headline":"Installation de Contao","ui.setup.create-project.description":"Contao development follows the principle of {semver}, a new minor version is released every six months. The currently supported releases are:","ui.setup.create-project.semver":"Semantic Versioning","ui.setup.create-project.latestTitle":"Dernière version","ui.setup.create-project.ltsTitle":"Long Term Support (LTS)","ui.setup.create-project.latestQ1":"Our latest version, offers the most features with support until February {year}.","ui.setup.create-project.latestQ3":"Our latest version, offers the most features with support until August {year}.","ui.setup.create-project.ltsText":"Our current LTS version, if you focus on stability. Offers long term support until February {year}.","ui.setup.create-project.pltsText":"The previous LTS version, still has long term support until February {year}.","ui.setup.create-project.requiresPHP":"Requires at least PHP {version}, you have PHP {current}.","ui.setup.create-project.releaseplan":"Consultez le {contaoReleasePlan} pour obtenir des informations détaillées","ui.setup.create-project.releaseplanLink":"Plan de publication","ui.setup.create-project.installed":"Contao {version} is successfully installed on the server. Continue to set up your database or launch the Contao Manager to install a different version.","ui.setup.create-project.formTitle":"Select a distribution","ui.setup.create-project.formText":"Please choose which version should be installed.","ui.setup.create-project.version":"Version","ui.setup.create-project.demo":"Install the Contao demo website","ui.setup.create-project.demoDescription":"The demo website helps you to get familiar with Contao and all of its core features. More themes can be found in the {store}.","ui.setup.create-project.coreOnly":"Installation de base (Core seulement)","ui.setup.create-project.noUpdate":"Ignorer l\'installation (réservé aux experts !)","ui.setup.create-project.theme":"Contao Theme","ui.setup.create-project.themeInstall":"To install a Contao theme, use the search input or upload a theme file (.cto/.zip) that supports installation through the Contao Manager.","ui.setup.create-project.themeBuy":"Make sure to visit the official {store}.","ui.setup.create-project.themeStore":"Contao Themes Store","ui.setup.create-project.themeUpload":"Upload theme file (.cto/.zip)","ui.setup.create-project.themeInvalid":"The uploaded file is not a Contao theme or does not support the Contao Manager.","ui.setup.create-project.themeWarning":"The Contao Manager cannot tell whether this theme is compatible with your server. Please check with the theme vendor if you have any questions.","ui.setup.create-project.themeTitle":"Review theme details","ui.setup.create-project.themeDetails":"The following dependencies and files will be installed with this theme.","ui.setup.create-project.themeRequire":"{count} Dependencies | {count} Dependencies","ui.setup.create-project.themeFiles":"{count} File | {count} Files","ui.setup.create-project.theme.or":"or search public themes","ui.setup.create-project.theme.search":"Search themes","ui.setup.create-project.theme.more":"More themes","ui.setup.create-project.theme.empty":"No themes matching {query}","ui.setup.create-project.theme.uploaded":"The theme file was uploaded successfully.","ui.setup.create-project.theme.packageName":"Package name","ui.setup.create-project.theme.version":"Version","ui.setup.create-project.theme.authors":"Author(s)","ui.setup.create-project.install":"Install","ui.setup.create-project.cancel":"Annuler","ui.setup.database-connection.headline":"Connexion à la base de données;","ui.setup.database-connection.description":"Contao nécessite une base de données MySQL (ou un équivalent comme MariaDB) pour stocker les pages, les contenus, les utilisateurs et les données relationnelles. Les paramètres de connexion sont stockés le fichier (env) à la racine de votre installation Contao. ","ui.setup.database-connection.formTitle":"Connection Parameters","ui.setup.database-connection.formText":"Entrez l\'URL d\'une base de données ou saisissez séparément utilisateur, mot de passe, serveur et autres champs de base de donnée.","ui.setup.database-connection.url":"URL de la base de données","ui.setup.database-connection.validUrl":"L\'URL de la base de données est invalide ou la connexion au serveur a échoué.","ui.setup.database-connection.or":"or","ui.setup.database-connection.user":"Nom d\'utilisateur","ui.setup.database-connection.password":"Mot de passe","ui.setup.database-connection.server":"Server (:Port)","ui.setup.database-connection.database":"Nom de la base de données","ui.setup.database-connection.connected":"Successfully connected to database {database} on {server}.","ui.setup.database-connection.error":"Erreur de connexion à la base de données","ui.setup.database-connection.problem":"Contao a détecté un problème avec votre serveur de bases de données.\\n","ui.setup.database-connection.schemaTitle":"Database Schema","ui.setup.database-connection.migration":"There is one pending migration. | There are {count} pending migrations.","ui.setup.database-connection.schema":"There is one pending schema update. | There are {count} pending schema updates.","ui.setup.database-connection.noChanges":"Le schéma de votre base de données est à jour.","ui.setup.database-connection.check":"Vérifier la base de données.","ui.setup.database-connection.skip":"Skip","ui.setup.database-connection.save":"Sauvegarder","ui.setup.database-connection.change":"Change credentials","ui.setup.database-connection.restoreTitle":"Database Import","ui.setup.database-connection.restoreText":"The theme you just installed contains a database backup. Restore the database to import theme data or skip this step to start with a blank Contao installation. | The theme you just installed contains multiple database backups. Select a backup file to import theme data or skip this step to start with a blank Contao installation.","ui.setup.database-connection.backup":"Backup current database before import","ui.setup.database-connection.backupWarning":"All data in database will be overwritten on import! Create a backup first if the database is not empty.","ui.setup.database-connection.restore":"Import theme database","ui.setup.database-connection.restoreOption":"Backup from {date} ({size})","ui.setup.database-connection.restored":"Your theme database was successfully imported. Continue to validate your database schema.","ui.setup.backend-user.success":"Un compte administrateur pour le back end de Contao a été trouvé dans votre base de données. veuillez utiliser le back end pour ajouter d\'autres utilisateurs.","ui.setup.backend-user.error":"Unable to retrieve user list. Check the console output for details.","ui.setup.backend-user.headline":"Backend Account","ui.setup.backend-user.description":"To manage your website, you need to have at least one admin account for the Contao back end. Be aware that this account is not related to the Contao Manager.","ui.setup.backend-user.formTitle":"Créer un compte","ui.setup.backend-user.formText":"Please enter the details for the new back end account.","ui.setup.backend-user.username":"Nom d\'utilisateur","ui.setup.backend-user.name":"Name","ui.setup.backend-user.email":"E-mail address","ui.setup.backend-user.emailInvalid":"Please enter a valid e-mail address","ui.setup.backend-user.password":"Mot de passe","ui.setup.backend-user.passwordPlaceholder":"Min. 8 caractères","ui.setup.backend-user.passwordLength":"Veuillez insérer au moins 8 caractères.","ui.setup.backend-user.create":"Add account","ui.task.headline":"Tâche de fond","ui.task.loading":"Chargement des détails…","ui.task.created":"Chargement des détails…","ui.task.active":"Veuillez patienter pendant que Contao Manager exécute des opérations en tâche de fond.","ui.task.complete":"Toutes les opérations sont terminées avec succès. Vérifiez les détails dans la console.","ui.task.aborting":"Veuillez patienter le temps que les opérations en tâche de fond se terminent.","ui.task.stopped":"Certaines opérations en tâche de fond ont été annulées. Veuillez vérifier les détails dans la console","ui.task.error":"Une opération en tâche de fond s\'est arrêtée de manière inattendue. Veuillez vérifier les détails dans la console.","ui.task.failed":"Le Contao Manager n\'a pas pu démarrer!","ui.task.failedDescription1":"Une erreur s\'est produite lors de la tentative d\'exécution des opérations en arrière plan","ui.task.failedDescription2":"Si cela se reproduit, votre serveur peut ne pas être pris en charge","ui.task.reportProblem":"Signaler un problème","ui.task.sponsor":"Composer Cloud sponsored by {sponsor}","ui.task.buttonAudit":"Mettre à jour la base de données","ui.task.buttonClose":"Fermer","ui.task.buttonConfirm":"Confirmer & fermer","ui.task.buttonCancel":"Annuler","ui.task.confirmCancel":"Êtes-vous sûr de vouloir annuler cette tâche? Cela pourrait laisser votre installation Contao inutilisable!","ui.task.autoclose":"Fermer les détails de la tâche en cas de succès","ui.console.toggle":"Afficher / masquer la console","ui.console.showLog":"Show full console log","ui.console.copyLog":"Copier le journal dans le presse-papiers","ui.migrate.headline":"Database Updates","ui.migrate.migrationsOnly":"(migrations only)","ui.migrate.schemaOnly":"(schema only)","ui.migrate.loading":"Please wait, we are checking your database …","ui.migrate.empty":"No pending migrations or schema updates found. Your database is up to date.","ui.migrate.emptyMigrations":"No pending migrations found. Make sure to also check for schema updates.","ui.migrate.emptySchema":"No pending schema updates found. Make sure to also check for migrations.","ui.migrate.pending":"Your database is not up to date. Please review the console output below and execute the changes.","ui.migrate.previousChanges":"A previous database migration was not confirmed.\\nPlease review the console output below, then continue to see the next changes.","ui.migrate.previousComplete":"A previous database migration was not confirmed, please review the console output below.\\nThere are no more pending changes.","ui.migrate.appliedChanges":"Database updates have been applied.\\nPlease review the console output below, then continue to see the next changes.","ui.migrate.appliedComplete":"Database updates have been applied.\\nThere are no more pending migrations or schema updates. Your database is up to date.","ui.migrate.problem":"Contao has detected a problem with your database server.\\nPlease review the console output below to find out what needs to be fixed. | Contao has detected problems with your database server.\\nPlease review the console output below to find out what needs to be fixed.","ui.migrate.warning":"Contao has detected a misconfiguration of your database server.\\nWarnings can be skipped temporarily, but should be fixed for optimal performance and data integrity.","ui.migrate.error":"The changes could not be applied. Your database might have been changed, please check again to retry.","ui.migrate.execute":"Execute","ui.migrate.close":"Fermer","ui.migrate.confirm":"Confirmer & fermer","ui.migrate.cancel":"Annuler","ui.migrate.continue":"Continuer","ui.migrate.setup":"Configuration","ui.migrate.skip":"Skip","ui.migrate.retry":"Check again","ui.migrate.retryAll":"Check all","ui.migrate.withDeletes":"Execute all database changes including DROP queries.","ui.migrate.migrationTitle":"Database Migrations","ui.migrate.schemaTitle":"Schema Updates","ui.migrate.problemTitle":"Database Problems","ui.migrate.warningTitle":"Database Warnings","ui.migrate.addTable":"Add table {table}","ui.migrate.dropTable":"Drop table {table}","ui.migrate.addField":"Add field {table}.{field}","ui.migrate.changeField":"Change field {table}.{field}","ui.migrate.dropField":"Drop field {table}.{field}","ui.migrate.createIndex":"Create index \\"{name}\\" on {table}","ui.migrate.dropIndex":"Drop index \\"{name}\\" on {table}","ui.widget.mandatory":"Ce champ ne doit pas être vide.","ui.widget.blankOption":"Veuillez sélectionner","ui.widget.showPassword":"Show password","ui.widget.hidePassword":"Hide password","ui.error.title":"La requête HTTP pour \\"{method} {url}\\" a échoué.","ui.error.server500":"Il semble qu\'une erreur inattendue s\'est produite sur votre serveur. Veuillez vérifier les fichiers journaux de votre serveur Web (Apache / Nginx) et les journaux de Contao Manager à \\"contao-manager/logs\\".","ui.error.response":"Le serveur a renvoyé une réponse avec le status {status}.","ui.error.moreLink":"Plus d\'informations","ui.error.support":"Contao Support","ui.error.permission":"You do not have permission to use this feature.","ui.footer.help":"Aide","ui.footer.reportProblem":"Signaler un problème","ui.navigation.discover":"Découvrir","ui.navigation.packages":"Packages","ui.navigation.tools":"Outils","ui.navigation.installTool":"Outil d\'installation","ui.navigation.backend":"Back office de Contao","ui.navigation.debug":"Mode de débogage","ui.navigation.logViewer":"Log Viewer","ui.navigation.phpinfo":"Informations PHP","ui.navigation.phpinfoLoading":"Loading PHP Information…","ui.navigation.maintenance":"Maintenance","ui.navigation.rebuildCache":"Reconstruire le cache","ui.navigation.users":"Accounts","ui.navigation.systemCheck":"Vérification du système","ui.navigation.advanced":"Avancé","ui.navigation.logout":"Se déconnecter","ui.maintenance.database.title":"Database Migrations and Backups","ui.maintenance.database.description":"Database migrations ensure consistent data and table schemas.","ui.maintenance.database.migrations":"One pending database migration | {count} pending database migrations","ui.maintenance.database.schemaUpdates":"One pending schema update | {count} pending schema updates","ui.maintenance.database.error":"La base de données a un problème.","ui.maintenance.database.warning":"Database warnings found.","ui.maintenance.database.button":"Vérifier la base de données.","ui.maintenance.database.migrationOnly":"Check migrations only","ui.maintenance.database.schemaOnly":"Check schema only","ui.maintenance.database.installTool":"Open Install Tool","ui.maintenance.database.createBackup":"Create Backup","ui.maintenance.database.backupUnsupported":"Database backups are not supported by your Contao version.","ui.maintenance.database.backupList":"You have one database backup, created on {date}. | You have {count} database backups, the latest one was created on {date}.","ui.maintenance.database.backupEmpty":"You currently have no database backups.","ui.maintenance.rebuildCache.title":"Cache de l\'application","ui.maintenance.rebuildCache.description":"La reconstruction du cache de l\'application est requise après toute modification des fichiers de configuration.","ui.maintenance.rebuildCache.rebuildProd":"Reconstruire le cache de production","ui.maintenance.rebuildCache.rebuildDev":"Reconstruire le cache de développement","ui.maintenance.rebuildCache.clearProd":"Vider le cache de production","ui.maintenance.rebuildCache.clearDev":"Vider le cache de développement","ui.maintenance.installTool.title":"Outil d\'installation Contao","ui.maintenance.installTool.description":"L\'outil d\'installation Contao est automatiquement verrouillé si vous entrez un mauvais mot de passe trois fois de suite.","ui.maintenance.installTool.unlock":"Dévérouillage de l\'outil d\'installation Contao","ui.maintenance.installTool.lock":"Vérouillage de l\'outil d\'installation Contao","ui.maintenance.dumpAutoload.title":"Composer Class Loader","ui.maintenance.dumpAutoload.description":"L\'autoloader de Composer est responsable du chargement des classes PHP. L\'autoloader doit être vidé après l\'ajout de namespaces à la racine composer.json.","ui.maintenance.dumpAutoload.button":"Purger l\'Autoloader","ui.maintenance.composerInstall.title":"Composer Dependencies","ui.maintenance.composerInstall.description":"Les dépendances de Composer se trouvent dans le dossier {vendor} à la racine de votre application. La réinstallation des dépendances peut être nécessaire après manipulation ou téléchargement manuel du fichier {composerLock}","ui.maintenance.composerInstall.button":"Lancer Composer Install","ui.maintenance.composerInstall.update":"Lancer Composer Update","ui.maintenance.composerCache.title":"Composer Cache","ui.maintenance.composerCache.description":"Pour améliorer ses performences, Composer met en cache les packages téléchargés. Si vous rencontrez des problèmes comme par exemple des fichiers corrompdus, vous pouvez essayer de d\'effacer le cache de Composer pour forcer un nouveau téléchargement des packages.","ui.maintenance.composerCache.button":"Vider le cache","ui.maintenance.maintenanceMode.title":"Maintenance Mode","ui.maintenance.maintenanceMode.description":"Putting Contao in maintenance mode will display a \\"503 Service Unavailable\\" template for the website.","ui.maintenance.maintenanceMode.enable":"Enable","ui.maintenance.maintenanceMode.disable":"Disable","ui.maintenance.debugMode.title":"Mode de débogage","ui.maintenance.debugMode.description":"Activez le mode débogage en définissant un utilisateur et un mot de passe pour le point d\'entrée {appDevPhp}","ui.maintenance.debugMode.descriptionJwt":"Activez le mode débogage en définissant le cookie de débogage pour le domaine actuel.","ui.maintenance.debugMode.activate":"Activer","ui.maintenance.debugMode.deactivate":"Désactiver","ui.maintenance.debugMode.credentials":"Données de connexion","ui.maintenance.debugMode.user":"Veuillez saisir un nom d\'utilisateur pour le mode de débogage.","ui.maintenance.debugMode.password":"Veuillez saisir un mot de passe pour le mode de débogage.","ui.maintenance.opcodeCache.title":"Opcode Cache","ui.maintenance.opcodeCache.description":"Opcode met en cache les fichiers PHP pour améliorer la vitesse d\'exécution du processus web. Cette fonctionnalité doit être supprimée dans certaines circontances et notammment si certanis fichiers ne sont pas reconnus après des modifications.","ui.maintenance.opcodeCache.button":"Vider le cache","ui.maintenance.safeMode":"Non disponible en mode sans échec","ui.maintenance.unsupported":"Non pris en charge par votre version Contao","ui.packages.updateButton":"Mise à jour des packages","ui.packages.searchButton":"Rechercher des packages","ui.packages.searchPlaceholder":"Rechercher des packages…","ui.packages.uploadOverlay":"Glisser-déposez les fichiers à uploader","ui.packages.uploadButton":"Uploader des packages","ui.packages.uploadMessage":"Vous avez un upload non confirmé. | Vous avez {count} uploads non confirmés.","ui.packages.uploadApply":"Confirmer les uploads","ui.packages.uploadReset":"Supprimer les uploads","ui.packages.uploadIncomplete":"Ce fichier n\'a pas été entièrement uploadé. Veuillez le supprimer et réessayer.","ui.packages.uploadDuplicate":"Ce fichier semble avoir été uploadé plusieurs fois. Veuillez supprimer les doublons.","ui.packages.uploadInstalled":"Ce fichier est déjà installé. Veuillez supprimer les doublons.","ui.packages.uploadUnsupported":"Uploads are not supported in your installation. Please make sure that the PHP ZIP extension is installed and update your dependencies.","ui.packages.changesMessage":"Vous avez un changement non confirmé. | Vous avez {count} changements non confirmés.","ui.packages.changesDryrun":"Tester (Dry run)","ui.packages.changesApply":"Appliquer les changements","ui.packages.changesApplyAll":"Update all packages","ui.packages.changesDryrunAll":"Dry run all packages","ui.packages.changesReset":"Annuler les changements","ui.packages.changesReview":"Revoir les changements","ui.packagelist.loading":"Chargement…","ui.packagelist.uploads":"Uploads","ui.packagelist.added":"Nouveaux packages","ui.packagelist.installed":"Packages installés","ui.package.hintRevert":"Rétablir les modifications","ui.package.hintNoupdate":"Ne pas mettre à jour","ui.package.hintConstraint":"Ce package va être installé avec la contrainte {constraint} quand vous appliquerez les modifications.","ui.package.hintConstraintBest":"Ce package sera installé avec la meilleure version disponible lorsque vous appliquerez les modifications.","ui.package.hintConstraintChange":"La contrainte pour ce package sera changée de \\"{from}\\" à \\"{to}\\" lorsque vous appliquerez les modifications.","ui.package.hintConstraintUpdate":"Ce package sera mis à jour lorsque vous appliquez les modifications.","ui.package.hintAdded":"Ce package sera installé lorsque vous appliquerez les modifications.","ui.package.hintRemoved":"Ce package sera supprimé lorsque vous appliquerez les modifications.","ui.package.requiredTitle":"ajouté manuellement","ui.package.requiredText":"Ce package est requis dans votre composer.json mais n\'est pas installé.","ui.package.removedTitle":"supprimé manuellement","ui.package.removedText":"Ce package a été supprimé de votre composer.json.","ui.package.installed":"Actuellement installé:","ui.package.version":"Version {version}","ui.package.additionalDownloads":"{count} Téléchargement | {count} Téléchargements","ui.package.additionalStars":"{count} Star | {count} Stars","ui.package.editConstraint":"Éditer","ui.package.uploadConstraint":"Cette contrainte est définie par le package téléchargé.","ui.package.updateButton":"Mettre à jour","ui.package.removeButton":"Supprimer","ui.package.installButton":"Ajouter un package","ui.package.installButtonShort":"Ajouter","ui.package.detailsButton":"Détails","ui.package.latestConstraint":"dernière version","ui.package.update":"Update available","ui.package.updateLatest":"dernière version","ui.package.updateAvailable":"{version} available","ui.package.updateUnknown":"unknown version","ui.package.updateConstraint":"A newer version outside your version constraint is available.","ui.package.incompatible":"{package} does not work with Contao {constraint}.","ui.cloudStatus.headline":"Composer Resolver Cloud","ui.cloudStatus.version":"Version {version}","ui.cloudStatus.waitingTime":"Temps d\'attente","ui.cloudStatus.jobs":"Jobs en cours","ui.cloudStatus.workers":"Workers","ui.cloudStatus.approx":"{minutes} min","ui.cloudStatus.none":"sans","ui.cloudStatus.short":"ca. {minutes} min","ui.cloudStatus.long":"ca. {minutes} min {seconds} sec","ui.cloudStatus.error":"Unable to fetch the status of the Composer Resolver Cloud. It might be down for maintenance or experience issues.","ui.cloudStatus.button":"Cloud Status","ui.cloudStatus.refresh":"Refresh Cloud Status","ui.log-viewer.loading":"Chargement…","ui.log-viewer.empty":"There are no log files on your server.","ui.log-viewer.reload":"Reload","ui.log-viewer.file":"Log file","ui.log-viewer.channel":"Channel","ui.log-viewer.channelTitle":"The channel this message was logged to.","ui.log-viewer.level":"Level","ui.log-viewer.levelTitle":"Severity of the log message.","ui.log-viewer.timeHeader":"Time","ui.log-viewer.messageHeader":"Message","ui.log-viewer.showContext":"Show Context","ui.log-viewer.hideContext":"Hide Context","ui.log-viewer.showExtra":"Show Extra","ui.log-viewer.hideExtra":"Hide Extra","ui.log-viewer.more":"Load more …","ui.log-viewer.download":"Download","ui.log-viewer.downloadTitle":"Download file \\"{file}\\"","ui.log-viewer.prodEnvironment":"Production Environment","ui.log-viewer.devEnvironment":"Development Environment (Debug Mode)","ui.user-manager.loading":"Loading users …","ui.user-manager.changePassword":"Change Password","ui.user-manager.setupTotp":"Setup Two-Factor Authentication","ui.user-manager.disableTotp":"Disable Two-Factor Authentication","ui.user-manager.invite":"Invite User","ui.user-manager.delete":"Delete","ui.user-manager.deleteConfirm":"Do you really want to delete user \\"{username}\\"?","ui.user-manager.deleted":"User {username} deleted successfully","ui.user-manager.passwordHeadline":"Change Password","ui.user-manager.passwordText":"To change your password, please enter the current and a new password in the respective fields.","ui.user-manager.currentPassword":"Current password","ui.user-manager.newPassword":"New password","ui.user-manager.passwordPlaceholder":"Min. 8 caractères","ui.user-manager.submitPassword":"Submit","ui.user-manager.passwordChanged":"Your password has been changed successfully.","ui.user-manager.passwordError":"This password is incorrect.","ui.user-manager.inviteHeadline":"Invite User","ui.user-manager.inviteText":"If you need multiple logins for the Contao Manager, you can create an invitation link here. Share this link with someone or use it on another device to create a new account with the given permissions.","ui.user-manager.inviteSuccess1":"A new invitation link was created. The URL below can be used to create a new user account for this Contao Manager. The invitation expires on {expires} (one week from now).","ui.user-manager.inviteSuccess2":"Please copy the link to your clipboard. It will only work once and you will not be able to see it again after closing this dialog.","ui.user-manager.createInvitation":"Create Invitation Link","ui.user-manager.clipboard":"Copy to clipboard","ui.user-manager.permissions":"Learn about permissions","ui.user-manager.cancel":"Annuler","ui.user-manager.close":"Fermer","ui.user-manager.you":"You","ui.user-manager.2fa":"2FA","ui.user-manager.2faEnabled":"This account is secured by two-factor authentication.","ui.user-manager.2faDisabled":"This account is insecure due to missing two-factor authentication.","ui.user-manager.passkey":"Passkey","ui.user-manager.passkeyTitle":"This account is secured by a Passkey.","ui.totp.headline":"Two-Factor Authentication","ui.totp.setupQr":"Please scan the QR code with your 2FA/TOTP app.","ui.totp.setupCode":"If you cannot scan the QR code, enter this key instead:","ui.totp.codeLabel":"Verification code","ui.totp.codeDescription":"Please enter the verification code generated by your 2FA/TOTP app.","ui.totp.disableText":"Please enter the verification code to disable two-factor authentication.","ui.totp.invalid":"The verification code is invalid.","ui.totp.enable":"Enable","ui.totp.disable":"Disable","ui.totp.cancel":"Annuler","ui.totp.enabled":"Two-factor authentication was enabled successfully.","ui.totp.disabled":"Two-factor authentication was disabled successfully.","ui.totp.setup":"Setup Two-Factor Authentication","ui.totp.skip":"Skip Two-Factor Authentication"}')}}]);"use strict";(self["webpackChunkcontao_manager"]=self["webpackChunkcontao_manager"]||[]).push([[477],{6477:function(e){e.exports=JSON.parse('{"ui.app.httpsHeadline":"!! Unsichere Verbindung !!","ui.app.httpsDescription":"Ohne HTTPS werden deine vertraulichen Daten unverschlüsselt übertragen.","ui.app.httpsLink":"Weitere Informationen","ui.app.httpsHref":"https://https.cio.gov/everything/","ui.app.safeModeHeadline":"!! Abgesicherter Modus !!","ui.app.safeModeDescription":"Einige Funktionen des Contao Managers sind nicht verfügbar.","ui.app.safeModeExit":"Beenden","ui.app.limitedHeadline":"Remote-Anmeldung","ui.app.limitedDescription":"Du hast eingeschränkte Berechtigungen wegen automatischer Anmeldung.","ui.app.limitedLogout":"Neu anmelden","ui.app.totpHeadline":"Sicherheitshinweis","ui.app.totpDescription":"Konfiguriere jetzt die Zwei-Faktor-Anmeldung, um dein Konto sicherer zu machen.","ui.app.totpSetup":"Einrichtung","ui.app.loading":"Contao Manager wird geladen …","ui.app.apiError":"Unerwarteter API-Status","ui.app.configSecurity1":"SICHERHEITSWARNUNG !!! Das Konfigurationsverzeichnis ist ungeschützt","ui.app.configSecurity2":"Der Contao Manager hat erkannt, dass seine Konfigurationsdateien öffentlich erreichbar sind. Du musst diese Dateien schützen, bevor der Manager verwendet werden kann, da ein Angreifer sonst auf sensible Daten zugreifen könnte.\\n\\nUm dieses Problem zu beheben, schütze das Verzeichnis \\"contao-manager\\" auf deinem Server. Bei Fragen lies das Handbuch deines Webservers oder wende dich an deinen Hosting-Anbieter.","ui.account.welcome":"Willkommen","ui.account.intro1":"Willkommen zum Contao Manager, einem universellen Werkzeug, um das Contao Open Source CMS zu installieren, zu konfigurieren und zu warten. Wenn du den Manager zum ersten Mal einsetzt, {readTheManualToGetStarted}.","ui.account.introGetStarted":"{readTheManual} bevor du beginnst","ui.account.introManual":"lies die Dokumentation","ui.account.intro2":"Sollten Probleme auftreten, dann prüfe {ourGithubIssues}. Falls für dein Anliegen noch kein Ticket existiert, kannst du gern ein Neues erstellen.","ui.account.introIssues":"die Tickets auf GitHub","ui.account.headline":"Benutzerkonto","ui.account.description":"Erstelle ein Benutzerkonto, um deine Installation zu verwalten. Beachte, dass dieses Konto in keinem Zusammenhang mit dem Contao Backend oder Frontend steht.","ui.account.username":"Benutzername","ui.account.password":"Passwort","ui.account.passwordPlaceholder":"min. 8 Zeichen","ui.account.passwordLength":"Bitte gib mindestens 8 Zeichen ein.","ui.account.loginInvalid":"Beim erstellen des Konto ist ein Fehler aufgetreten. Bitte versuche einen anderen Benutzernamen.","ui.account.submit":"Benutzerkonto erstellen","ui.account.usePassword":"Mit Passwort anmelden","ui.account.usePasskey":"Mit Passkey anmelden","ui.account.totpHeadline":"Zwei-Faktor Anmeldung","ui.account.totpDescription":"Bitte aktivieren die Zwei-Faktor-Anmeldung, welche dein Konto sicherer macht. Zusätzlich zu deinem Benutzernamen und Passwort musst du einen Sicherheitscode eingeben, welcher von einer Zwei-Faktor-App wie 1Password, Authy, Google Authenticator, Microsoft Authenticator, LassPass Authenticator oder einer beliebigen anderen TOTP-App erzeugt wird.","ui.account.totpSetup":"Jetzt einrichten","ui.account.totpSkip":"Später einrichten","ui.account.login":"Einladung ablehnen","ui.account.contribute1":"Contao und der Contao Manager werden durch die Contao Association gefördert.","ui.account.contribute2":"{donate} und leiste deinen Beitrag zu Open Source!","ui.account.contributeDonate":"Mach eine Spende","ui.login.headline":"Anmeldung","ui.login.description":"Melde dich an, um deine Installation zu verwalten.","ui.login.username":"Benutzername","ui.login.password":"Passwort","ui.login.totpHeadline":"Zwei-Faktor Anmeldung","ui.login.totpDescription":"Bitte gibt den Sicherheitscode ein, um die Anmeldung abzuschliessen.","ui.login.totp":"Sicherheitscode","ui.login.forgotPassword":"Passwort vergessen?","ui.login.button":"Anmelden","ui.login.passkey":"Mit Passkey anmelden","ui.login.cancel":"Abbrechen","ui.login.or":"oder","ui.login.locked":"Der Zugriff wurde verweigert, da der Contao Manager gesperrt ist. Zum Entsperren lösche die Datei {lockFile} in deinem Contao Hauptverzeichnis.","ui.logout.headline":"Session-Timeout","ui.logout.warning":"Du warst mehr als 25 Minuten inaktiv. Aus Sicherheitsgründen wird deine Sitzung in Kürze beendet.","ui.logout.expired":"Deine Sitzung wurde automatisch beendet, da du mehr als 30 Minuten inaktiv warst.","ui.logout.renew":"Angemeldet bleiben","ui.logout.logout":"Abmelden","ui.logout.login":"Zurück zum Login","ui.oauth.error":"Ungültiger OAuth-Versuch. Bitte überprüfe die Request-Parameter.","ui.oauth.https":"Die Rückleitungs-URL MUSS eine sichere Verbindung (https:) nutzen, um die Übertragung der Anmeldedaten im Klartext zu verhindern.","ui.oauth.headline":"Remote-Anmeldung","ui.oauth.description":"Die folgende Anwendung oder der folgende Dienst fordert den Fernzugriff auf deine Contao Manager-Instanz an.","ui.oauth.domain":"Bevor du diesen Zugriff erlaubst, stelle sicher, dass du die URL kennst und ihr vertraust!","ui.oauth.outOfScope":"Du hast leider nicht genügend Berechtigungen um diesen Zugriff zu gewähren.","ui.oauth.allow":"Zugriff erlauben","ui.oauth.deny":"Zugriff verweigern","ui.oauth.switchUser":"Benutzer wechseln","ui.scope.admin":"Admin-Zugriff inkl. Benutzerverwaltung","ui.scope.install":"Pakete installieren und Contao-Konfiguration ändern","ui.scope.update":"Pakete aktualisieren und Wartungsaufgaben ausführen","ui.scope.read":"Pakete und Konfiguration sehen","ui.boot.headline":"Systemprüfung","ui.boot.description":"Bitte warten, dein Server wird überprüft …","ui.boot.issue1":"Installationsprobleme erkannt","ui.boot.issue2":"Du musst die Installationsprobleme beheben, bevor der Contao Manager verwendet werden kann.","ui.boot.run":"Contao Manager starten","ui.boot.safeMode":"Abgesicherten Modus starten","ui.recovery.headline":"Systemwiederherstellung","ui.recovery.description":"Es wurden Dateien erkannt, die nach einer Contao-Installation aussehen, aber die Kommandozeile scheint nicht korrekt zu funktionieren.","ui.recovery.console":"Konsolenausgabe","ui.recovery.repairOptions":"Wähle eine Option, um das System zu reparieren.","ui.recovery.repairHeadline":"Automatische Reparatur","ui.recovery.repairDescription":"Versucht eine automatische Systemreparatur, indem der Cache neu aufgebaut und die Composer-Pakete neu installiert werden.","ui.recovery.repairWarning":"Manuelle Änderungen an den vendor-Dateien können dabei verloren gehen!","ui.recovery.repairFailed":"Die automatische Reparatur ist fehlgeschlagen. Versuche den abgesicherten Modus, um die Installation von Hand zu reparieren.","ui.recovery.repairButton":"Reparatur ausführen","ui.recovery.safeModeHeadline":"Abgesicherter Modus","ui.recovery.safeModeDescription":"Der abgesicherte Modus erlaubt die Paketverwaltung und gewisse Wartungsaufgaben, aber Funktionen, welche ein funktionierendes Contao benötigen, sind nicht verfügbar.","ui.recovery.safeModeButton":"Abgesicherten Modus starten","ui.server.pending":"Warten …","ui.server.running":"Analysiere …","ui.server.error":"Die Prüfung ist aufgrund einer unerwarteten Server-Antwort fehlgeschlagen.","ui.server.details":"Details","ui.server.prerequisite":"Prüfung aufgrund fehlender Abhängigkeiten abgebrochen.","ui.server.selfUpdate.title":"Updates für den Contao Manager","ui.server.selfUpdate.update":"Die neue Version {latest} des Contao Managers ist verfügbar.","ui.server.selfUpdate.manualUpdate":"Eine neue Version {latest} des Contao Manager ist verfügbar. Dein Server unterstützt keine automatischen Updates, bitte lade die neue Version von {download} herunter.","ui.server.selfUpdate.latest":"Du verwendest die aktuelle Version {current}.","ui.server.selfUpdate.dev":"Entwicklungs-Versionen können nicht automatisch aktualisiert werden.","ui.server.selfUpdate.unsupported":"Eine neue Version ist verfügbar, aber diese funktioniert nicht mit deiner PHP-Version.","ui.server.selfUpdate.button":"Aktualisieren","ui.server.selfUpdate.continue":"Weiter","ui.server.config.title":"Serverkonfiguration","ui.server.config.setup":"Konfigurieren","ui.server.config.change":"Ändern","ui.server.config.save":"Speichern","ui.server.config.cancel":"Abbrechen","ui.server.config.customOption":"Andere …","ui.server.config.description":"Der Contao Manager benötigt den Pfad zum PHP-Binary und weitere Server-Informationen, um Hintergrund-Prozesse korrekt auszuführen.","ui.server.config.formTitle":"Serverkonfiguration","ui.server.config.formText":"Bitte gib den Pfad zu deinem PHP-Binary ein. Das Binary muss dieselbe PHP-Version sein wie der Webprozess.","ui.server.config.cloudTitle":"Composer Resolver Cloud","ui.server.config.cloudText":"Die Composer Resolver Cloud erlaubt die Installation von Composer-Abhängigkeiten, selbst wenn der lokale Server nicht über genug Arbeitsspeicher verfügt. Beachte, dass deine Paketinformationen an einen Cloud-Dienst der Contao Association übermittelt werden.","ui.server.config.cloud":"Die Composer Resolver Cloud verwenden","ui.server.config.cli":"PHP-Binary","ui.server.config.stateErrorCli":"Es wurde kein valides PHP-Programm auf dem Server gefunden.","ui.server.config.stateErrorCloud":"Die Composer Resolver Cloud wird nicht unterstützt.","ui.server.config.stateSuccess":"PHP-Binary in {php_cli}.","ui.server.php_web.title":"PHP-Webprozess","ui.server.php_web.below7":"PHP Version {version} gefunden. Bitte wechsle baldmöglichst auf PHP 7!","ui.server.php_web.success":"PHP Version {version}, keine bekannten Probleme gefunden.","ui.server.php_cli.title":"PHP Kommandozeilen-Programm","ui.server.php_cli.success":"PHP Version {version}, keine bekannten Probleme gefunden.","ui.server.composer.title":"Composer-Umgebung","ui.server.composer.success":"Keine bekannten Probleme gefunden.","ui.server.composer.install":"Composer-Abhängigkeiten sind nicht installiert.","ui.server.composer.button":"Installieren","ui.server.contao.title":"Contao-Installation","ui.server.contao.setup":"Einrichtung","ui.server.contao.check":"Datenbank prüfen","ui.server.contao.empty":"Es wurde keine Contao-Installation gefunden.","ui.server.contao.old":"Contao {version} ist nicht kompatibel mit dem Contao Manager; bitte aktualisiere deine Installation manuell.","ui.server.contao.found":"Contao {version} (API-Version {api}) gefunden.","ui.server.contao.connectionError":"Verbindung zum Datenbank-Server fehlgeschlagen.","ui.server.contao.connectionProblem":"Datenbank-Problem gefunden.","ui.server.contao.missingUser":"Administratorkonto nicht gefunden.","ui.setup.continue":"Weiter","ui.setup.manager":"Contao Manager starten","ui.setup.cancel":"Abbrechen","ui.setup.welcome":"Willkommen","ui.setup.welcome1":"Dieser Assistent führt dich durch die Installation und Einrichtung deines Contao Open Source CMS.","ui.setup.welcome2":"Solltest du Fragen haben, findest du die Dokumentation, das Forum, den Slack Kanal und weiteres auf der {support}-Seite.","ui.setup.support":"Contao-Support","ui.setup.start":"Los geht\'s","ui.setup.complete":"Geschafft!","ui.setup.complete1":"Contao {version} wurde erfolgreich installiert.","ui.setup.complete2":"Um die Installation fertig zu stellen, öffne bitte das Install-Tool um die Datenbank zu verbinden und ein Backend-Konto hinzuzufügen.","ui.setup.complete3":"Du kannst nun deine Webseite im Contao Backend einrichten. Willst du Erweiterungen installieren, fahre mit dem Contao Manager fort.","ui.setup.installTool":"Install-Tool öffnen","ui.setup.login":"Contao Login","ui.setup.funding":"Ohne seine Community wäre Contao nicht das, was es heute ist. Wenn du professionell Webseiten mit Contao erstellst, sind wir auf deine Unterstützung angewiesen. Mit einer Investition in das Projekt sicherst du die Entwicklung für die Zukunft, damit dein Unternehmen weiterhin von Contao profitieren kann.","ui.setup.fundingLink":"Weitere Informationen","ui.setup.document-root.headline":"Webserver-Einrichtung","ui.setup.document-root.warning":"Um Contao über den Contao Manager zu installieren, muss das Wurzelverzeichnis des Webservers angepasst werden.","ui.setup.document-root.description1":"Contao verwendet einen Unterordner für öffentliche Dateien, die Systemdaten werden im übergeordneten Ordner installiert. Contao kann nicht installiert werden, wenn die Struktur nicht stimmt oder die Ordner nicht leer sind.","ui.setup.document-root.description2":"Falls du nicht weisst, wie dein Wurzelverzeichnis konfiguriert werden kann, lies die Contao Dokumentation oder kontaktiere deinen Hosting-Anbieter.","ui.setup.document-root.documentation":"Dokumentation lesen","ui.setup.document-root.conflictsTitle":"Installationsverzeichnis nicht leer","ui.setup.document-root.conflictsDirectory":"Das Wurzelverzeichnis deiner zukünftigen Contao-Installation ist nicht leer, es wurden {count} Datei(en) gefunden, die bei der Installation überschrieben werden könnten. Es wird empfohlen Contao in ein leeres Verzeichnis zu installieren, aber du kannst auch die Dateien löschen und erneut prüfen lassen, wenn du sicher bist, dass diese nicht benötigt werden.","ui.setup.document-root.ignoreConflicts":"Ich will Contao in ein nicht-leeres Verzeichnis installieren. Ich verstehe, dass dadurch bestehende Dateien auf meinem Server möglicherweise überschrieben werden.","ui.setup.document-root.check":"Erneut prüfen","ui.setup.document-root.create":"Verzeichnisse erstellen","ui.setup.document-root.change":"Verzeichnisse ändern","ui.setup.document-root.formTitle":"Verzeichnisstruktur einrichten","ui.setup.document-root.formText1":"Der Contao Manager kann automatisch eine neue Verzeichnisstruktur auf dem Server einrichten.","ui.setup.document-root.formText2":"Du musst das Wurzelverzeichnis danach manuell umkonfigurieren (z. B. über die Hosting-Administration).","ui.setup.document-root.autoconfig":"Ich habe verstanden, dass meine Server-Konfiguration geändert werden muss. Wenn ich dies nicht tue, funktioniert der Contao Manager nicht mehr und meine Konfigurationsdateien (inklusive Benutzer & Passwörter) werden öffentlich erreichbar!","ui.setup.document-root.directory":"Neuer Ordner","ui.setup.document-root.currentRoot":"Aktuelles Wurzelverzeichnis","ui.setup.document-root.newRoot":"Neues Wurzelverzeichnis","ui.setup.document-root.finish":"Ordner erstellen","ui.setup.document-root.publicDir":"{dir} für öffentliche Dateien nutzen (Contao {version})","ui.setup.document-root.directoryInvalid":"Bitte gib einen gültigen Ordnernamen ein.","ui.setup.document-root.directoryExists":"Das Zielverzeichnis ist bereits vorhanden. Bitte gibt einen anderen Namen ein.","ui.setup.document-root.confirmation":"Der Contao Manager hat die benötigten Verzeichnisse erfolgreich angelegt. Nun musst du dein Wurzelverzeichnis anpassen. Lade die Seite nicht neu, bis dies erledigt ist.","ui.setup.document-root.reload":"Neu laden","ui.setup.document-root.success":"Die Verzeichnisstruktur auf deinem Server ist korrekt eingerichtet!","ui.setup.document-root.installingProjectDir":"Systemdateien werden nach {dir} installiert.","ui.setup.document-root.installingPublicDir":"Öffentliche Dateien werden nach {dir} installiert.","ui.setup.document-root.installedProjectDir":"Systemdateien sind in {dir} installiert.","ui.setup.document-root.installedPublicDir":"Öffentliche Dateien sind in {dir} installiert.","ui.setup.create-project.headline":"Contao-Installation","ui.setup.create-project.description":"Die Contao-Entwicklung folgt dem Prinzip von {semver}, eine neue Minor-Version wird alle sechs Monate veröffentlicht. Die aktuell unterstützten Versionen sind:","ui.setup.create-project.semver":"Semantic Versioning","ui.setup.create-project.latestTitle":"Neuste","ui.setup.create-project.ltsTitle":"Langzeit-Support","ui.setup.create-project.latestQ1":"Unsere neuste Version mit den meisten Funktionen, wird bis Februar {year} unterstützt.","ui.setup.create-project.latestQ3":"Unsere neuste Version mit den meisten Funktionen, wird bis August {year} unterstützt.","ui.setup.create-project.ltsText":"Unsere aktuelle LTS-Version mit Fokus auf Stabilität. Bietet einen verlängerten Supportzeitraum bis Februar {year}.","ui.setup.create-project.pltsText":"Die vorherige LTS-Version, hat einen verlängerten Supportzeitraum bis Februar {year}","ui.setup.create-project.requiresPHP":"Benötigt mindestens PHP {version}, du hast PHP {current}.","ui.setup.create-project.releaseplan":"Weitere Details findest du im {contaoReleasePlan}.","ui.setup.create-project.releaseplanLink":"Contao Release-Plan","ui.setup.create-project.installed":"Contao {version} wurde erfolgreich auf dem Server installiert. Fahre weiter, um die Datenbank einzurichten, oder gehe zum Contao Manager um eine andere Version zu installieren.","ui.setup.create-project.formTitle":"Wähle eine Distribution","ui.setup.create-project.formText":"Bitte wähle die zu installierende Version.","ui.setup.create-project.version":"Version","ui.setup.create-project.demo":"Beispiel-Webseite installieren","ui.setup.create-project.demoDescription":"Die Beispiel-Webseite von Contao hilft dir dabei, dich mit dem System und seinen Hauptfunktionen vertraut zu machen. Weitere Themes findest du im {store}.","ui.setup.create-project.coreOnly":"Minimale Installation (nur Core)","ui.setup.create-project.noUpdate":"Installation überspringen (Expertenmodus!)","ui.setup.create-project.theme":"Theme für Contao","ui.setup.create-project.themeInstall":"Um ein Theme für Contao zu installieren, benutze die Sucheingabe oder lade eine Theme-Datei (.cto/.zip) hoch, die den Contao Manager unterstützt.","ui.setup.create-project.themeBuy":"Besuche auch den {store}.","ui.setup.create-project.themeStore":"Contao Themes-Store","ui.setup.create-project.themeUpload":"Theme-Datei (.cto/.zip) hochladen","ui.setup.create-project.themeInvalid":"Die hochgeladene Datei ist kein Theme für Contao oder unterstützt die Installation im Contao Manager nicht.","ui.setup.create-project.themeWarning":"Der Contao Manager kann nicht beurteilen, ob dieses Theme mit deinem Server kompatibel ist. Wende dich bei Fragen bitte direkt an den Theme-Hersteller.","ui.setup.create-project.themeTitle":"Theme-Details überprüfen","ui.setup.create-project.themeDetails":"Die nachfolgenden Abhängigkeiten und Dateien werden mit diesem Theme installiert.","ui.setup.create-project.themeRequire":"{count} Abhängigkeit | {count} Abhängigkeiten","ui.setup.create-project.themeFiles":"{count} Datei | {count} Dateien","ui.setup.create-project.theme.or":"oder suche öffentliche Themes","ui.setup.create-project.theme.search":"Themes durchsuchen","ui.setup.create-project.theme.more":"Weitere Themes","ui.setup.create-project.theme.empty":"Keine Theme für {query} gefunden","ui.setup.create-project.theme.uploaded":"Die Theme-Datei wurde erfolgreich hochgeladen.","ui.setup.create-project.theme.packageName":"Paketname","ui.setup.create-project.theme.version":"Version","ui.setup.create-project.theme.authors":"Autor(en)","ui.setup.create-project.install":"Installieren","ui.setup.create-project.cancel":"Abbrechen","ui.setup.database-connection.headline":"Datenbank-Verbindung","ui.setup.database-connection.description":"Contao benötigt eine MySQL Datenbank (oder ein kompatibler Fork wie MariaDB), um Seiten, Inhalte und andere Daten zu speichern. Die Verbindungsdaten werden in der Datei {env} im Systemverzeichnis von Contao gespeichert werden.","ui.setup.database-connection.formTitle":"Verbindungs-Parameter","ui.setup.database-connection.formText":"Gib eine Datenbank-URL ein, oder fülle die Felder für Benutzername, Passwort, Server und Datenbank separat aus.","ui.setup.database-connection.url":"Datenbank-URL","ui.setup.database-connection.validUrl":"Datenbank-URL ungültig oder Verbindung zum Server fehlgeschlagen.","ui.setup.database-connection.or":"oder","ui.setup.database-connection.user":"Benutzername","ui.setup.database-connection.password":"Passwort","ui.setup.database-connection.server":"Server (:Port)","ui.setup.database-connection.database":"Datenbankname","ui.setup.database-connection.connected":"Erfolgreich verbunden mit Datenbank {database} auf {server}.","ui.setup.database-connection.error":"Fehler beim Verbinden mit der Datenbank.","ui.setup.database-connection.problem":"Contao hat ein Problem mit dem Datenbank-Server gefunden.","ui.setup.database-connection.schemaTitle":"Datenbank-Schema","ui.setup.database-connection.migration":"Es gibt eine ausstehende Migration. | Es gibt {count} ausstehende Migrationen.","ui.setup.database-connection.schema":"Es gibt eine ausstehende Schema-Änderung. | Es gibt {count} ausstehende Schema-Änderungen.","ui.setup.database-connection.noChanges":"Dein Datenbank-Schema ist aktuell.","ui.setup.database-connection.check":"Datenbank prüfen","ui.setup.database-connection.skip":"Überspringen","ui.setup.database-connection.save":"Speichern","ui.setup.database-connection.change":"Zugangsdaten ändern","ui.setup.database-connection.restoreTitle":"Datenbank-Import","ui.setup.database-connection.restoreText":"Das soeben installierte Theme enthält ein Datenbank-Backup. Du kannst diese Theme-Daten in die Datenbank importieren oder diesen Schritt überspringen und mit einem leeren Contao beginnen. | Das soeben installierte Theme enthält mehrere Datenbank-Backups. Wähle eine Backup-Datei für den Import oder überspringe diesen Schritt, um mit einem leeren Contao zu beginnen.","ui.setup.database-connection.backup":"Datenbank vor dem Import sichern","ui.setup.database-connection.backupWarning":"Alle Daten in der Datenbank werden beim Import überschrieben! Erstelle zuerst ein Backup, falls die Datenbank nicht leer ist.","ui.setup.database-connection.restore":"Theme importieren","ui.setup.database-connection.restoreOption":"Backup vom {date} ({size})","ui.setup.database-connection.restored":"Die Theme-Datenbank wurde erfolgreich importiert. Fahre fort, um das Datenbank-Schema zu überprüfen.","ui.setup.backend-user.success":"Es ist bereits ein Benutzerkonto in der Datenbank vorhanden. Weitere Konten können über das Backend hinzugefügt werden.","ui.setup.backend-user.error":"Die Benutzerliste konnte nicht gelesen werden. Weitere Details findest du in der Konsolen-Ausgabe.","ui.setup.backend-user.headline":"Backend-Konto","ui.setup.backend-user.description":"Um deine Webseite zu verwalten, benötigst du mindestens ein Administratorkonto für das Contao Backend. Beachte, dass dieses Konto nicht mit dem Contao Manager zusammenhängt.","ui.setup.backend-user.formTitle":"Benutzerkonto erstellen","ui.setup.backend-user.formText":"Bitte gib die Details für das neue Backend-Konto ein.","ui.setup.backend-user.username":"Benutzername","ui.setup.backend-user.name":"Name","ui.setup.backend-user.email":"E-Mail-Adresse","ui.setup.backend-user.emailInvalid":"Bitte gib eine gültige E-Mail-Adresse ein","ui.setup.backend-user.password":"Passwort","ui.setup.backend-user.passwordPlaceholder":"min. 8 Zeichen","ui.setup.backend-user.passwordLength":"Bitte gib mindestens 8 Zeichen ein.","ui.setup.backend-user.create":"Konto hinzufügen","ui.task.headline":"Hintergrund-Prozess","ui.task.loading":"Lade Details …","ui.task.created":"Lade Details …","ui.task.active":"Bitte warte, während der Contao Manager die nötigen Operationen im Hintergrund ausführt.","ui.task.complete":"Alle Operationen erfolgreich abgeschlossen. Weitere Details findest du in der Konsolen-Ausgabe.","ui.task.aborting":"Bitte warte, während der Hintergrund-Prozess abgebrochen wird.","ui.task.stopped":"Einige Operationen wurden abgebrochen. Bitte prüfe die Konsolen-Ausgabe.","ui.task.error":"Ein Hintergrund-Prozess wurde unerwartet beendet. Bitte prüfe die Konsolen-Ausgabe.","ui.task.failed":"Der Contao Manager konnte den Hintergrund-Prozess nicht starten.","ui.task.failedDescription1":"Die Ausführung der Aufgabe ist fehlgeschlagen.","ui.task.failedDescription2":"Sollte dies wiederholt geschehen, wird dein Server möglicherweise nicht unterstützt.","ui.task.reportProblem":"Probleme melden","ui.task.sponsor":"Composer Cloud gesponsert von {sponsor}","ui.task.buttonAudit":"Datenbank aktualisieren","ui.task.buttonClose":"Schließen","ui.task.buttonConfirm":"Bestätigen & Schließen","ui.task.buttonCancel":"Abbrechen","ui.task.confirmCancel":"Möchtest du diesen Prozess wirklich abbrechen? Deine Contao-Installation könnte in einem defekten Zustand zurückbleiben!","ui.task.autoclose":"Fenster bei Erfolg schließen","ui.console.toggle":"Konsolenausgabe anzeigen/verstecken","ui.console.showLog":"Vollständige Konsole anzeigen","ui.console.copyLog":"Konsole in Zwischenablage kopieren","ui.migrate.headline":"Datenbank-Änderungen","ui.migrate.migrationsOnly":"(nur Migrationen)","ui.migrate.schemaOnly":"(nur Schema)","ui.migrate.loading":"Bitte warten, die Datenbank wird überprüft …","ui.migrate.empty":"Keine ausstehenden Migrationen oder Schema-Änderungen gefunden. Deine Datenbank ist auf dem aktuellsten Stand.","ui.migrate.emptyMigrations":"Keine ausstehenden Migrationen gefunden. Bitte prüfe auch die Schema-Änderungen.","ui.migrate.emptySchema":"Keine ausstehenden Schema-Änderungen gefunden. Bitte prüfe auch die Migrationen.","ui.migrate.pending":"Die Datenbank ist nicht aktuell. Bitte prüfe die untenstehende Konsolenausgabe und führe die Änderungen aus.","ui.migrate.previousChanges":"Eine vorherige Datenbankmigration wurde nicht bestätigt.\\nBitte prüfen die untenstehende Konsolenausgabe und klicke weiter, um die nächsten Änderungen zu sehen.","ui.migrate.previousComplete":"Eine vorherige Datenbankmigration wurde nicht bestätigt, bitte prüfe die untenstehende Konsolenausgabe.\\nEs gibt keine weiteren ausstehenden Änderungen.","ui.migrate.appliedChanges":"Die Datenbankänderungen wurden übernommen.\\nBitte prüfe die untenstehende Konsolenausgabe, dann klicke weiter, um die nächsten Änderungen zu sehen.","ui.migrate.appliedComplete":"Die Datenbankänderungen wurden übernommen.\\nEs gibt keine weiteren Migrationen oder Schema-Änderungen. Deine Datenbank ist auf dem aktuellen Stand.","ui.migrate.problem":"Contao hat ein Problem mit dem Datenbank-Server gefunden.\\nBitte prüfe die Konsolen-Ausgabe unten, um zu sehen was angepasst werden muss. | Contao hat Probleme mit dem Datenbank-Server gefunden.\\nBitte prüfe die Konsolen-Ausgabe unten, um zu sehen was angepasst werden muss.","ui.migrate.warning":"Contao hat eine Fehlkonfiguration des Datenbank-Servers gefunden.\\nDie unten stehenden Warnungen sollten für optimalen Betrieb und Datensicherheit behoben werden.","ui.migrate.error":"Die Änderungen konnten nicht angewendet werden. Möglicherweise wurde die Datenbank geändert, bitte prüfe nochmals und versuche es erneut.","ui.migrate.execute":"Ausführen","ui.migrate.close":"Schließen","ui.migrate.confirm":"Bestätigen & Schließen","ui.migrate.cancel":"Abbrechen","ui.migrate.continue":"Weiter","ui.migrate.setup":"Einrichtung","ui.migrate.skip":"Überspringen","ui.migrate.retry":"Erneut prüfen","ui.migrate.retryAll":"Alles überprüfen","ui.migrate.withDeletes":"Alle Änderungen inklusive Löschungen anwenden.","ui.migrate.migrationTitle":"Datenbank-Migrationen","ui.migrate.schemaTitle":"Schema-Änderungen","ui.migrate.problemTitle":"Datenbank-Probleme","ui.migrate.warningTitle":"Datenbank-Warnungen","ui.migrate.addTable":"Tabelle {table} hinzufügen","ui.migrate.dropTable":"Tabelle {table} löschen","ui.migrate.addField":"Feld {table}.{field} hinzufügen","ui.migrate.changeField":"Feld {table}.{field} ändern","ui.migrate.dropField":"Feld {table}.{field} löschen","ui.migrate.createIndex":"Index \\"{name}\\" zu {table} hinzufügen","ui.migrate.dropIndex":"Index \\"{name}\\" aus {table} löschen","ui.widget.mandatory":"Dieses Feld darf nicht leer sein.","ui.widget.blankOption":"Bitte wählen …","ui.widget.showPassword":"Passwort anzeigen","ui.widget.hidePassword":"Passwort ausblenden","ui.error.title":"HTTP-Anfrage für \\"{method} {url}\\" fehlgeschlagen.","ui.error.server500":"Es scheint ein unbekannter Fehler aufgetreten zu sein. Prüfe die Log-Dateien deines Webservers (Apache/Nginx) und des Contao Managers im Ordner \\"contao-manager/logs\\".","ui.error.response":"Der Server hat eine Antwort mit Status-Code {status} gesendet.","ui.error.moreLink":"Weitere Informationen","ui.error.support":"Contao Support","ui.error.permission":"Du hast keine Berechtigung für diese Funktion.","ui.footer.help":"Hilfe","ui.footer.reportProblem":"Probleme melden","ui.navigation.discover":"Entdecken","ui.navigation.packages":"Pakete","ui.navigation.tools":"Tools","ui.navigation.installTool":"Installtool","ui.navigation.backend":"Contao-Backend","ui.navigation.debug":"Contao-Debug-Modus","ui.navigation.logViewer":"System-Log","ui.navigation.phpinfo":"PHP-Informationen","ui.navigation.phpinfoLoading":"Lade PHP-Informationen…","ui.navigation.maintenance":"Systemwartung","ui.navigation.rebuildCache":"Cache erneuern","ui.navigation.users":"Konten","ui.navigation.systemCheck":"Systemprüfung","ui.navigation.advanced":"Fortgeschritten","ui.navigation.logout":"Abmelden","ui.maintenance.database.title":"Datenbank-Migrationen und -Backups","ui.maintenance.database.description":"Datenbankmigrationen stellen konsistente Daten und Tabellenschemas sicher.","ui.maintenance.database.migrations":"Eine ausstehende Datenbank-Migration | {count} ausstehende Datenbank-Migrationen","ui.maintenance.database.schemaUpdates":"Eine ausstehende Schema-Änderung | {count} ausstehende Schema-Änderungen","ui.maintenance.database.error":"Datenbank-Problem gefunden.","ui.maintenance.database.warning":"Datenbank-Warnung gefunden.","ui.maintenance.database.button":"Datenbank prüfen","ui.maintenance.database.migrationOnly":"Nur Migrationen prüfen","ui.maintenance.database.schemaOnly":"Nur Schema prüfen","ui.maintenance.database.installTool":"Install-Tool öffnen","ui.maintenance.database.createBackup":"Backup erstellen","ui.maintenance.database.backupUnsupported":"Datenbank-Backups werden von deiner Contao-Version nicht unterstützt.","ui.maintenance.database.backupList":"Du hast ein Datenbank-Backup, erstellt am {date}. | Du hast {count} Datenbank-Backups, das neuste wurde am {date} erstellt.","ui.maintenance.database.backupEmpty":"Du hast noch keine Datenbank-Backups.","ui.maintenance.rebuildCache.title":"Anwendungs-Cache","ui.maintenance.rebuildCache.description":"Nach dem Ändern einer der Konfigurationsdateien muss der Anwendungs-Cache neu aufgebaut werden.","ui.maintenance.rebuildCache.rebuildProd":"Prod.-Cache erneuern","ui.maintenance.rebuildCache.rebuildDev":"Dev.-Cache erneuern","ui.maintenance.rebuildCache.clearProd":"Prod.-Cache leeren","ui.maintenance.rebuildCache.clearDev":"Dev.-Cache leeren","ui.maintenance.installTool.title":"Contao-Installtool","ui.maintenance.installTool.description":"Das Contao-Installtool wird automatisch gesperrt, wenn das Passwort drei Mal falsch eingegeben wird.","ui.maintenance.installTool.unlock":"Installtool entsperren","ui.maintenance.installTool.lock":"Installtool sperren","ui.maintenance.dumpAutoload.title":"Composer Class Loader","ui.maintenance.dumpAutoload.description":"Der Composer-Autoloader ist für das Laden der PHP-Klassen verantwortlich. Der Autoloader muss nach dem Hinzufügen von eigenen Namespaces in die composer.json neu geschrieben werden.","ui.maintenance.dumpAutoload.button":"Datei aktualisieren","ui.maintenance.composerInstall.title":"Composer-Abhängigkeiten","ui.maintenance.composerInstall.description":"Composer-Abhängigkeiten befinden sich im Ordner {vendor} im Hauptverzeichnis deiner Anwendung. Eine Neuinstallation der Abhängigkeiten kann nach der Bearbeitung oder dem manuellen Hochladen der Datei {composerLock} notwendig sein.","ui.maintenance.composerInstall.button":"Installer ausführen","ui.maintenance.composerInstall.update":"Composer Update ausführen","ui.maintenance.composerCache.title":"Composer-Cache","ui.maintenance.composerCache.description":"Composer speichert heruntergeladene Pakete im Cache, um die Performance zu verbessern. Wenn Du z. B. Probleme mit korrupten Dateien hast, kannst du den Composer-Cache leeren, um einen neuen Download zu erzwingen.","ui.maintenance.composerCache.button":"Cache leeren","ui.maintenance.maintenanceMode.title":"Wartungsmodus","ui.maintenance.maintenanceMode.description":"Im Wartungsmodus zeigt Contao das \\"503 Dienst nicht verfügbar\\"-Template anstelle der Webseite an.","ui.maintenance.maintenanceMode.enable":"Aktivieren","ui.maintenance.maintenanceMode.disable":"Deaktivieren","ui.maintenance.debugMode.title":"Debug-Modus","ui.maintenance.debugMode.description":"Aktiviere den Debug-Modus, indem du einen Benutzer und ein Passwort für den Einstiegspunkt {appDevPhp} festlegen.","ui.maintenance.debugMode.descriptionJwt":"Aktiviert den Debug-Modus, indem für die aktuelle Domain ein entsprechendes Cookie gesetzt wird.","ui.maintenance.debugMode.activate":"Aktivieren","ui.maintenance.debugMode.deactivate":"Deaktivieren","ui.maintenance.debugMode.credentials":"Anmeldedaten","ui.maintenance.debugMode.user":"Bitte gib einen Benutzernamen für den Debug-Modus ein.","ui.maintenance.debugMode.password":"Bitte gib ein Passwort für den Debug-Modus ein.","ui.maintenance.opcodeCache.title":"Opcode-Cache","ui.maintenance.opcodeCache.description":"Der Opcode-Cache speichert PHP-Dateien im Webprozess für eine schnellere Ausführung. Er muss unter Umständen gelöscht werden, wenn Dateien nach dem Ändern nicht erkannt werden.","ui.maintenance.opcodeCache.button":"Cache leeren","ui.maintenance.safeMode":"Deaktiviert im abgesicherten Modus","ui.maintenance.unsupported":"Von deiner Contao-Version nicht unterstützt","ui.packages.updateButton":"Pakete aktualisieren","ui.packages.searchButton":"Pakete suchen","ui.packages.searchPlaceholder":"Pakete suchen …","ui.packages.uploadOverlay":"Lege Dateien hier ab, um sie hochzuladen","ui.packages.uploadButton":"Pakete hochladen","ui.packages.uploadMessage":"Du hast einen unbestätigten Upload. | Du hast {count} unbestätigte Uploads.","ui.packages.uploadApply":"Uploads bestätigen","ui.packages.uploadReset":"Uploads löschen","ui.packages.uploadIncomplete":"Diese Datei wurde nicht vollständig hochgeladen. Bitte entferne sie und versuchen es noch einmal.","ui.packages.uploadDuplicate":"Diese Datei scheint mehrfach hochgeladen worden zu sein. Bitte entferne die Duplikate.","ui.packages.uploadInstalled":"Diese Datei ist bereits installiert. Bitte entferne die Duplikate.","ui.packages.uploadUnsupported":"Uploads werden in deiner Installation nicht unterstützt. Stelle sicher, dass die PHP ZIP-Erweiterung installiert ist und aktualisiere die Abhängigkeiten.","ui.packages.changesMessage":"Du hast eine unbestätigte Änderung. | Du hast {count} unbestätigte Änderungen.","ui.packages.changesDryrun":"Testlauf","ui.packages.changesApply":"Änderungen anwenden","ui.packages.changesApplyAll":"Alle Pakete aktualisieren","ui.packages.changesDryrunAll":"Testlauf mit allen Paketen","ui.packages.changesReset":"Änderungen verwerfen","ui.packages.changesReview":"Änderungen prüfen","ui.packagelist.loading":"Laden …","ui.packagelist.uploads":"Uploads","ui.packagelist.added":"Neue Pakete","ui.packagelist.installed":"Installierte Pakete","ui.package.hintRevert":"Änderung verwerfen","ui.package.hintNoupdate":"Nicht aktualisieren","ui.package.hintConstraint":"Dieses Paket wird mit der Versionsbedingung {constraint} installiert, wenn du die Änderungen anwendest.","ui.package.hintConstraintBest":"Dieses Paket wird in der besten verfügbaren Version installiert, wenn du die Änderungen anwendest.","ui.package.hintConstraintChange":"Die Versionsbedingung dieses Pakets wird von \\"{from}\\" in \\"{to}\\" geändert, wenn du die Änderungen anwendest.","ui.package.hintConstraintUpdate":"Dieses Paket wird aktualisiert, wenn du die Änderungen anwendest.","ui.package.hintAdded":"Dieses Paket wird installiert, wenn du die Änderungen anwendest.","ui.package.hintRemoved":"Dieses Paket wird entfernt, wenn du die Änderungen anwendest.","ui.package.requiredTitle":"manuell hinzugefügt","ui.package.requiredText":"Dieses Paket wurde in der composer.json hinzugefügt, ist aber nicht installiert.","ui.package.removedTitle":"manuell entfernt","ui.package.removedText":"Dieses Paket wurde aus der composer.json entfernt.","ui.package.installed":"Aktuell installiert:","ui.package.version":"Version {version}","ui.package.additionalDownloads":"{count} Download | {count} Downloads","ui.package.additionalStars":"{count} Stern | {count} Sterne","ui.package.editConstraint":"Bearbeiten","ui.package.uploadConstraint":"Diese Versionsbedingung wird von dem hochgeladenen Paket definiert.","ui.package.updateButton":"Aktualisieren","ui.package.removeButton":"Entfernen","ui.package.installButton":"Paket hinzufügen","ui.package.installButtonShort":"Hinzufügen","ui.package.detailsButton":"Details","ui.package.latestConstraint":"neuste Version","ui.package.update":"Update verfügbar","ui.package.updateLatest":"neuste Version","ui.package.updateAvailable":"{version} verfügbar","ui.package.updateUnknown":"unbekannte Version","ui.package.updateConstraint":"Es ist eine neuere Version ausserhalb der Versionsbedingung verfügbar.","ui.package.incompatible":"{package} funktioniert nicht mit Contao {constraint}.","ui.cloudStatus.headline":"Composer Resolver Cloud","ui.cloudStatus.version":"Version {version}","ui.cloudStatus.waitingTime":"Wartezeit","ui.cloudStatus.jobs":"Aktive Aufgaben","ui.cloudStatus.workers":"Server","ui.cloudStatus.approx":"{minutes} min","ui.cloudStatus.none":"keine","ui.cloudStatus.short":"ca. {minutes} min","ui.cloudStatus.long":"ca. {minutes} min {seconds} sek","ui.cloudStatus.error":"Status der Composer Resolver Cloud konnte nicht abgerufen werden. Möglicherweise gibt es ein Wartungsfenster oder Systemprobleme.","ui.cloudStatus.button":"Cloud-Status","ui.cloudStatus.refresh":"Cloud-Status aktualisieren","ui.log-viewer.loading":"Laden …","ui.log-viewer.empty":"Auf dem Server sind keine Logdateien vorhanden.","ui.log-viewer.reload":"Neu laden","ui.log-viewer.file":"Logdatei","ui.log-viewer.channel":"Kanal","ui.log-viewer.channelTitle":"Kanal in welcher die Nachricht geschrieben wurde.","ui.log-viewer.level":"Stufe","ui.log-viewer.levelTitle":"Wichtigkeit der Log-Nachricht.","ui.log-viewer.timeHeader":"Uhrzeit","ui.log-viewer.messageHeader":"Nachricht","ui.log-viewer.showContext":"Kontext anzeigen","ui.log-viewer.hideContext":"Kontext ausblenden","ui.log-viewer.showExtra":"Extras anzeigen","ui.log-viewer.hideExtra":"Extras ausblenden","ui.log-viewer.more":"Mehr laden …","ui.log-viewer.download":"Herunterladen","ui.log-viewer.downloadTitle":"Datei \\"{file}\\" herunterladen","ui.log-viewer.prodEnvironment":"Produktivumgebung","ui.log-viewer.devEnvironment":"Entwicklungsumgebung (Debug Modus)","ui.user-manager.loading":"Lade Benutzer:innen …","ui.user-manager.changePassword":"Passwort ändern","ui.user-manager.setupTotp":"Zwei-Faktor konfigurieren","ui.user-manager.disableTotp":"Zwei-Faktor deaktivieren","ui.user-manager.invite":"Benutzer:in einladen","ui.user-manager.delete":"Löschen","ui.user-manager.deleteConfirm":"Möchtest du das Konto von \\"{username}\\" wirklich löschen?","ui.user-manager.deleted":"Das Konto für {username} wurde gelöscht.","ui.user-manager.passwordHeadline":"Passwort ändern","ui.user-manager.passwordText":"Um dein Passwort zu ändern, gibt dein bestehendes und ein neues Passwort in den entsprechenden Feldern ein.","ui.user-manager.currentPassword":"Aktuelles Passwort","ui.user-manager.newPassword":"Neues Passwort","ui.user-manager.passwordPlaceholder":"min. 8 Zeichen","ui.user-manager.submitPassword":"Absenden","ui.user-manager.passwordChanged":"Dein Passwort wurde erfolgreich geändert.","ui.user-manager.passwordError":"Dieses Passwort stimmt nicht.","ui.user-manager.inviteHeadline":"Benutzer:in einladen","ui.user-manager.inviteText":"Falls du mehrere Logins zum Contao Manager benötigst, kannst du hier einen Einladungs-Link erstellen. Teile diesen Link mit jemandem oder benutze ihn auf einem anderen Gerät, um ein neues Konto mit den entsprechenden Berechtigungen zu erstellen.","ui.user-manager.inviteSuccess1":"Ein Einladungs-Link wurde erstellt. Mit der untenstehenden URL kann ein neues Konto für diesen Contao Manager erstellt werden. Die Einladung läuft ab am {expires} (eine Woche ab jetzt).","ui.user-manager.inviteSuccess2":"Kopiere den Link in deine Zwischenablage. Er funktioniert nur einmal, und du kannst ihn nach dem Schliessen dieses Fensterns nicht mehr sehen.","ui.user-manager.createInvitation":"Einladungs-Link erstellen","ui.user-manager.clipboard":"In Zwischenablage kopieren","ui.user-manager.permissions":"Mehr über Berechtigungen","ui.user-manager.cancel":"Abbrechen","ui.user-manager.close":"Schließen","ui.user-manager.you":"Du","ui.user-manager.2fa":"2FA","ui.user-manager.2faEnabled":"Dieses Konto ist duch Zwei-Faktor-Anmeldung abgesichert.","ui.user-manager.2faDisabled":"Dieses Konto ist unsicher, da keine Zwei-Faktor-Anmeldung konfiguriert wurde.","ui.user-manager.passkey":"Passkey","ui.user-manager.passkeyTitle":"Dieses Konto ist durch einen Passkey abgesichert.","ui.totp.headline":"Zwei-Faktor Anmeldung","ui.totp.setupQr":"Scanne den QR-Code mit deiner 2FA/TOTP-Applikation.","ui.totp.setupCode":"Falls du den QR-Code nicht scannen kannst, gibt folgenden Schlüssel ein:","ui.totp.codeLabel":"Sicherheitscode","ui.totp.codeDescription":"Bitte gibt den Sicherheitscode ein, welcher von deiner 2FA/TOTP-Applikation generiert wurde.","ui.totp.disableText":"Gib den Sicherheitscode ein, um die Zwei-Faktor-Anmeldung zu deaktivieren.","ui.totp.invalid":"Der Sicherheitscode ist ungültig.","ui.totp.enable":"Aktivieren","ui.totp.disable":"Deaktivieren","ui.totp.cancel":"Abbrechen","ui.totp.enabled":"Die Zwei-Faktor-Anmeldung wurde erfolgreich aktiviert.","ui.totp.disabled":"Die Zwei-Faktor-Anmeldung wurde erfolgreich deaktiviert.","ui.totp.setup":"Zwei-Faktor-Anmeldung konfigurieren","ui.totp.skip":"Two-Factor-Anmeldung überspringen"}')}}]);"use strict";(self["webpackChunkcontao_manager"]=self["webpackChunkcontao_manager"]||[]).push([[599],{1599:function(e,i,o){o.r(i),o.d(i,{default:function(){return C}});var t=o(641),n=o(3751),s=o(33),l=o(6894);const a={key:0,class:"view-login__locked"},r={key:0,class:"view-login__form"},g={class:"view-login__headline"},d={class:"view-login__description"},u={class:"view-login__or"},p=["href"],c={key:1,class:"view-login__form"},_={class:"view-login__headline"},h={class:"view-login__description"};function m(e,i,o,m,k,w){const b=(0,t.g2)("i18n-t"),f=(0,t.g2)("text-field"),v=(0,t.g2)("loading-button"),y=(0,t.g2)("boxed-layout");return(0,t.uX)(),(0,t.Wv)(y,{slotClass:"view-login"},{default:(0,t.k6)((()=>[i[7]||(i[7]=(0,t.Lk)("header",{class:"view-login__header"},[(0,t.Lk)("img",{src:l,width:"80",height:"80",alt:"Contao Logo"}),(0,t.Lk)("p",{class:"view-login__product"},"Contao Manager")],-1)),e.locked?((0,t.uX)(),(0,t.CE)("main",a,[(0,t.bF)(b,{tag:"p",keypath:"ui.login.locked"},{lockFile:(0,t.k6)((()=>i[6]||(i[6]=[(0,t.Lk)("strong",null,"contao-manager/login.lock",-1),(0,t.Lk)("br",null,null,-1)]))),_:1})])):((0,t.uX)(),(0,t.Wv)(n.eB,{key:1,name:"animate-flip",type:"transition",mode:"out-in"},{default:(0,t.k6)((()=>[e.requires_totp?((0,t.uX)(),(0,t.CE)("main",c,[(0,t.Lk)("form",{onSubmit:i[5]||(i[5]=(0,n.D$)((function(){return w.login&&w.login(...arguments)}),["prevent"]))},[(0,t.Lk)("h1",_,(0,s.v_)(e.$t("ui.login.totpHeadline")),1),(0,t.Lk)("p",h,(0,s.v_)(e.$t("ui.login.totpDescription")),1),(0,t.bF)(f,{name:"totp",required:"",minlength:"6",maxlength:"6",autocomplete:"one-time-code",label:e.$t("ui.login.totp"),placeholder:e.$t("ui.login.totp"),class:(0,s.C4)(["view-login__totp",e.login_failed?"widget--error":""]),disabled:e.logging_in,modelValue:e.totp,"onUpdate:modelValue":i[3]||(i[3]=i=>e.totp=i),onInput:w.reset},null,8,["label","placeholder","class","disabled","modelValue","onInput"]),(0,t.bF)(v,{submit:"",class:"view-login__button",color:"primary",disabled:!w.totpValid||e.login_failed,loading:e.logging_in},{default:(0,t.k6)((()=>[(0,t.eW)((0,s.v_)(e.$t("ui.login.button")),1)])),_:1},8,["disabled","loading"]),(0,t.Lk)("button",{class:"widget-button view-login__button",onClick:i[4]||(i[4]=function(){return w.cancelTotp&&w.cancelTotp(...arguments)})},(0,s.v_)(e.$t("ui.login.cancel")),1)],32)])):((0,t.uX)(),(0,t.CE)("main",r,[(0,t.Lk)("form",{onSubmit:i[2]||(i[2]=(0,n.D$)((function(){return w.login&&w.login(...arguments)}),["prevent"]))},[(0,t.Lk)("h1",g,(0,s.v_)(e.$t("ui.login.headline")),1),(0,t.Lk)("p",d,(0,s.v_)(e.$t("ui.login.description")),1),(0,t.bF)(f,{ref:"username",name:"username",autocomplete:"username webauthn",label:e.$t("ui.login.username"),placeholder:e.$t("ui.login.username"),class:(0,s.C4)(["view-login__user",e.login_failed?"widget--error":""]),disabled:e.logging_in||e.passkey_login,modelValue:e.username,"onUpdate:modelValue":i[0]||(i[0]=i=>e.username=i),onInput:w.reset},null,8,["label","placeholder","class","disabled","modelValue","onInput"]),(0,t.bF)(f,{type:"password",name:"password",autocomplete:"current-password",label:e.$t("ui.login.password"),placeholder:e.$t("ui.login.password"),minlength:"8",class:(0,s.C4)(["view-login__password",e.login_failed?"widget--error":""]),disabled:e.logging_in||e.passkey_login,modelValue:e.password,"onUpdate:modelValue":i[1]||(i[1]=i=>e.password=i),onInput:w.reset},null,8,["label","placeholder","class","disabled","modelValue","onInput"]),(0,t.bF)(v,{submit:"",class:"view-login__button",color:"primary",disabled:!w.inputValid||e.login_failed||e.passkey_login,loading:e.logging_in&&!e.passkey_login},{default:(0,t.k6)((()=>[(0,t.eW)((0,s.v_)(e.$t("ui.login.button")),1)])),_:1},8,["disabled","loading"]),(0,t.Lk)("p",u,(0,s.v_)(e.$t("ui.login.or")),1),e.showPasskey?((0,t.uX)(),(0,t.Wv)(v,{key:0,class:"view-login__button",color:"primary",loading:e.passkey_login,disabled:e.logging_in,onClick:(0,n.D$)(w.passkeyLogin,["prevent"])},{default:(0,t.k6)((()=>[(0,t.eW)((0,s.v_)(e.$t("ui.login.passkey")),1)])),_:1},8,["loading","disabled","onClick"])):(0,t.Q3)("",!0),(0,t.Lk)("a",{href:`https://to.contao.org/docs/manager-password?lang=${e.$i18n.locale}`,target:"_blank",class:"view-login__link"},(0,s.v_)(e.$t("ui.login.forgotPassword")),9,p)],32)]))])),_:1}))])),_:1})}var k=o(6278),w=o(60),b=o(707),f=o(5404),v=o(683),y=o(6966),$={components:{BoxedLayout:f.A,TextField:v.A,LoadingButton:y.A},data:()=>({username:"",password:"",totp:"",logging_in:!1,passkey_login:!1,requires_totp:!1,login_failed:!1,showPasskey:!1}),computed:{...(0,k.aH)(["locked"]),inputValid(){return""!==this.username&&""!==this.password&&this.password.length>=8},totpValid(){return""!==this.totp&&/^\d{6}$/.test(this.totp)}},methods:{async login(){this.inputValid&&this.doLogin({username:this.username,password:this.password,totp:this.totp})},async passkeyLogin(e){let{useBrowserAutofill:i}=e;this.passkey_login=!i;const o=(await this.$request.get("api/session/options")).data;try{const e=await(0,w.HS)({optionsJSON:o,useBrowserAutofill:!!i});await this.doLogin({passkey:JSON.stringify(e)})}catch(t){}this.passkey_login=!1},async doLogin(e){this.logging_in=!0;const i=await this.$store.dispatch("auth/login",e);201===i.status?this.$store.commit("setView",b.A.BOOT):401===i.status&&i.data.totp_enabled?(this.logging_in=!1,this.requires_totp=!0,this.login_failed=!!this.totp):(this.logging_in=!1,this.login_failed=!0)},reset(){this.login_failed=!1},cancelTotp(){this.username="",this.password="",this.totp="",this.logging_in=!1,this.requires_totp=!1,this.login_failed=!1}},async mounted(){if(this.$store.commit("setError",null),this.locked)return;if(this.$refs.username&&this.$refs.username.focus(),"https:"!==location.protocol)return void(this.showPasskey=!1);const e=(0,w.zZ)(),i=await(0,w.ZF)();this.showPasskey=e,e&&i&&this.passkeyLogin({useBrowserAutofill:!0})}},L=o(6262);const V=(0,L.A)($,[["render",m]]);var C=V}}]);"use strict";(self["webpackChunkcontao_manager"]=self["webpackChunkcontao_manager"]||[]).push([[545,976],{4686:function(e,t){var s=this&&this.__extends||function(){var e=function(t,s){return e=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(e,t){e.__proto__=t}||function(e,t){for(var s in t)Object.prototype.hasOwnProperty.call(t,s)&&(e[s]=t[s])},e(t,s)};return function(t,s){if("function"!==typeof s&&null!==s)throw new TypeError("Class extends value "+String(s)+" is not a constructor or null");function i(){this.constructor=t}e(t,s),t.prototype=null===s?Object.create(s):(i.prototype=s.prototype,new i)}}();Object.defineProperty(t,"__esModule",{value:!0}),t.treeifyPaths=t.Node=t.PathTree=void 0;var i=function(){function e(e){void 0===e&&(e=""),this.path=e,this.name="",this.children=[]}return e}();t.PathTree=i;var a=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return s(t,e),t}(i);function o(e,t,s){void 0===s&&(s={});var a={};t.forEach((function(t){var s=t[0],o=t[1],n=r(s).split("/"),l=n[0];if(!a[l]){var u="".concat(e.path,"/").concat(n[0]);a[l]={paths:[],obj:new i(r(u))}}if(1==n.length)a[l].obj.name=l,a[l].obj.ctx=o;else{n.shift();var c=n.join("/");a[l].paths.push([c,o]),a[l].obj.ctx=o}}));var n=Object.keys(a);return s.caseInsensitive?n.sort((function(e,t){return e.toLocaleLowerCase().localeCompare(t.toLocaleLowerCase())})):n.sort(),n.forEach((function(t){var i=a[t].obj;o(i,a[t].paths,s),(i.name||i.path||i.children.length)&&e.children.push(i)})),s.directoriesFirst?e.children.sort((function(e,t){return e.children.length&&!t.children.length?-1:t.children.length&&!e.children.length?1:0})):s.directoriesLast&&e.children.sort((function(e,t){return e.children.length&&!t.children.length?1:t.children.length&&!e.children.length?-1:0})),e}function n(e,t){void 0===e&&(e=[]),void 0===t&&(t={});var s=l(e)?e.map((function(e){return[e,void 0]})):e;return o(new i,s,t)}t.Node=a,t.treeifyPaths=n,t["default"]=n;var r=function(e){return e.replace(/^\/*/,"").replace(/\/*$/,"")},l=function(e){return"string"===typeof e[0]}},8165:function(e,t,s){s.r(t),s.d(t,{default:function(){return ki}});var i=s(641),a=s(33),o=s(3382),n=s(6894);const r={key:0,class:"view-setup__steps"},l=["onClick","disabled"],u=["src"],c={key:1,class:"view-setup__main"},d={class:"view-setup__headline"},p={class:"view-setup__description"},h={class:"view-setup__description"},m={href:"/contao/install",class:"widget-button widget-button--primary view-setup__continue"},_={class:"view-setup__description"},v={href:"/contao",class:"widget-button widget-button--primary view-setup__continue"},k={class:"view-setup__funding"},b={class:"view-setup__funding-link widget-button widget-button--small widget-button--funding widget-button--link",href:"https://to.contao.org/donate",target:"_blank"},g={key:3,class:"view-setup__main"},f={class:"view-setup__headline"},y={class:"view-setup__description"},w={href:"https://to.contao.org/support",target:"_blank"};function L(e,t,s,L,$,C){const E=(0,i.g2)("i18n-t"),X=(0,i.g2)("boxed-layout");return(0,i.uX)(),(0,i.Wv)(X,{wide:!0,slotClass:"view-setup"},{default:(0,i.k6)((()=>[C.currentStep>0?((0,i.uX)(),(0,i.CE)("section",r,[(0,i.Lk)("ul",null,[((0,i.uX)(!0),(0,i.CE)(i.FK,null,(0,i.pI)(C.steps,((e,t)=>((0,i.uX)(),(0,i.CE)("li",{class:(0,a.C4)({active:C.currentStep>t}),key:e.name},[(0,i.Lk)("button",{onClick:e=>C.currentStep=t+1,disabled:C.currentStep<=t+1},[(0,i.Lk)("img",{src:e.icon,width:"24",height:"24",alt:""},null,8,u)],8,l)],2)))),128)),(0,i.Lk)("li",{class:(0,a.C4)({active:C.currentStep>C.steps.length})},t[4]||(t[4]=[(0,i.Lk)("button",{disabled:""},[(0,i.Lk)("svg",{xmlns:"http://www.w3.org/2000/svg",height:"24px",viewBox:"0 0 24 24",width:"24px"},[(0,i.Lk)("path",{d:"M0 0h24v24H0z",fill:"none"}),(0,i.Lk)("path",{d:"M9 16.2L4.8 12l-1.4 1.4L9 19 21 7l-1.4-1.4L9 16.2z"})])],-1)]),2)])])):(0,i.Q3)("",!0),C.currentStep>C.steps.length?((0,i.uX)(),(0,i.CE)("main",c,[t[6]||(t[6]=(0,i.Lk)("span",{class:"view-setup__party"},"🎉",-1)),(0,i.Lk)("h1",d,(0,a.v_)(e.$t("ui.setup.complete")),1),(0,i.Lk)("p",p,(0,a.v_)(e.$t("ui.setup.complete1",{version:e.contaoVersion})),1),e.showInstallTool?((0,i.uX)(),(0,i.CE)(i.FK,{key:0},[(0,i.Lk)("p",h,(0,a.v_)(e.$t("ui.setup.complete2")),1),(0,i.Lk)("button",{class:"widget-button widget-button--inline",onClick:t[0]||(t[0]=function(){return C.launch&&C.launch(...arguments)})},(0,a.v_)(e.$t("ui.setup.manager")),1),(0,i.Lk)("a",m,(0,a.v_)(e.$t("ui.setup.installTool")),1)],64)):((0,i.uX)(),(0,i.CE)(i.FK,{key:1},[(0,i.Lk)("p",_,(0,a.v_)(e.$t("ui.setup.complete3")),1),(0,i.Lk)("button",{class:"widget-button view-setup__continue",onClick:t[1]||(t[1]=function(){return C.launch&&C.launch(...arguments)})},(0,a.v_)(e.$t("ui.setup.manager")),1),(0,i.Lk)("a",v,(0,a.v_)(e.$t("ui.setup.login")),1)],64)),(0,i.Lk)("div",k,[t[5]||(t[5]=(0,i.Lk)("figure",null,[(0,i.Lk)("img",{src:o,width:"80",height:"80",alt:""})],-1)),(0,i.Lk)("div",null,[((0,i.uX)(!0),(0,i.CE)(i.FK,null,(0,i.pI)(e.$t("ui.setup.funding").split("\n"),((e,t)=>((0,i.uX)(),(0,i.CE)("p",{key:t},(0,a.v_)(e),1)))),128)),(0,i.Lk)("p",null,[(0,i.Lk)("a",b,(0,a.v_)(e.$t("ui.setup.fundingLink")),1)])])])])):C.currentStep>0?((0,i.uX)(),(0,i.Wv)((0,i.$y)(C.steps[C.currentStep-1].component),{key:2,onContinue:t[2]||(t[2]=e=>C.currentStep+=1)},null,32)):((0,i.uX)(),(0,i.CE)("main",g,[t[7]||(t[7]=(0,i.Lk)("img",{src:n,width:"100",height:"100",alt:"Contao Logo",class:"view-setup__icon"},null,-1)),(0,i.Lk)("h1",f,(0,a.v_)(e.$t("ui.setup.welcome")),1),(0,i.Lk)("p",y,(0,a.v_)(e.$t("ui.setup.welcome1")),1),(0,i.bF)(E,{tag:"p",class:"view-setup__description",keypath:"ui.setup.welcome2"},{support:(0,i.k6)((()=>[(0,i.Lk)("a",w,(0,a.v_)(e.$t("ui.setup.support")),1)])),_:1}),(0,i.Lk)("button",{class:"widget-button widget-button--inline widget-button--primary view-setup__start",onClick:t[3]||(t[3]=e=>C.currentStep=1)},(0,a.v_)(e.$t("ui.setup.start")),1)]))])),_:1})}s(4114);var $=s(707),C=s(6278),E=s(5404),X=s(3751),F=s.p+"img/document-root.0e6dd2e4.svg",j=s.p+"img/button-update.ad79c617.svg";const A={class:"setup__header"},V={class:"setup__headline"},U={key:0,class:"setup__warning"},x={class:"setup__description"},D={class:"setup__description"},S=["href"],P={class:"setup__form setup__form--center",key:"updated"},W={class:"setup__fields"},T={class:"setup__fielddesc"},I={class:"setup__directories"},q={key:0},R={key:1},M={key:2},B={key:3},O={key:4},H={key:5},Q={key:6},K={class:"setup__actions setup__actions--center"},J={class:"setup__form",key:"conflicts"},N={class:"setup__fields"},z={class:"setup__fieldtitle"},Z={class:"setup__fielddesc"},Y={key:0},G={class:"setup__actions setup__actions--center"},ee=["disabled"],te={class:"setup__form",key:"setup"},se={class:"setup__fields"},ie={class:"setup__fieldtitle"},ae={class:"setup__fielddesc"},oe={class:"setup__directories"},ne={key:0},re={key:1},le={key:2},ue={key:3},ce={key:4},de={key:5},pe={key:6},he={class:"setup__actions setup__actions--center"},me=["disabled"],_e={class:"setup__form",key:"confirmation"},ve={class:"setup__fields setup__fields--center"},ke={class:"setup__fielddesc"},be={class:"setup__actions setup__actions--center"};function ge(e,t,s,o,n,r){const l=(0,i.g2)("loading-button"),u=(0,i.g2)("check-box"),c=(0,i.g2)("text-field"),d=(0,i.g2)("radio-button"),p=(0,i.g2)("i18n-t");return(0,i.uX)(),(0,i.CE)("section",null,[(0,i.Lk)("header",A,[t[10]||(t[10]=(0,i.Lk)("img",{src:F,width:"80",height:"80",alt:"",class:"setup__icon"},null,-1)),(0,i.Lk)("h1",V,(0,a.v_)(e.$t("ui.setup.document-root.headline")),1),r.needsFix?((0,i.uX)(),(0,i.CE)("p",U,(0,a.v_)(e.$t("ui.setup.document-root.warning")),1)):(0,i.Q3)("",!0),(0,i.Lk)("p",x,(0,a.v_)(e.$t("ui.setup.document-root.description1")),1),(0,i.Lk)("p",D,(0,a.v_)(e.$t("ui.setup.document-root.description2")),1),(0,i.Lk)("a",{class:"widget-button widget-button--inline widget-button--info widget-button--link",href:`https://to.contao.org/docs/webroot?lang=${e.$i18n.locale}`,target:"_blank"},(0,a.v_)(e.$t("ui.setup.document-root.documentation")),9,S)]),null!==e.projectDir?((0,i.uX)(),(0,i.Wv)(X.eB,{key:0,name:e.forceInstall?"none":"animate-flip",type:"transition",mode:"out-in"},{default:(0,i.k6)((()=>[r.needsFix||e.wantsFix?((0,i.uX)(),(0,i.CE)(i.FK,{key:0},[e.directoryUpdated?((0,i.uX)(),(0,i.CE)("main",P,[(0,i.Lk)("div",W,[t[13]||(t[13]=(0,i.Lk)("svg",{class:"setup__check",xmlns:"http://www.w3.org/2000/svg",width:"24",height:"24",viewBox:"0 0 24 24"},[(0,i.Lk)("path",{d:"M12,2A10,10 0 0,1 22,12A10,10 0 0,1 12,22A10,10 0 0,1 2,12A10,10 0 0,1 12,2M12,4A8,8 0 0,0 4,12A8,8 0 0,0 12,20A8,8 0 0,0 20,12A8,8 0 0,0 12,4M11,16.5L6.5,12L7.91,10.59L11,13.67L16.59,8.09L18,9.5L11,16.5Z"})],-1)),(0,i.Lk)("p",T,(0,a.v_)(e.$t("ui.setup.document-root.confirmation")),1),(0,i.Lk)("dl",I,[(0,i.Lk)("dt",null,(0,a.v_)(e.$t("ui.setup.document-root.currentRoot")),1),e.isWeb?((0,i.uX)(),(0,i.CE)("dd",q,(0,a.v_)(e.projectDir)+"/web",1)):e.isPublic?((0,i.uX)(),(0,i.CE)("dd",R,(0,a.v_)(e.projectDir)+"/public",1)):((0,i.uX)(),(0,i.CE)("dd",M,(0,a.v_)(e.projectDir),1)),(0,i.Lk)("dt",null,(0,a.v_)(e.$t("ui.setup.document-root.newRoot")),1),!e.isEmpty||e.wantsFix&&e.directory||!r.canUsePublicDir||!e.usePublicDir?!e.isEmpty||e.wantsFix&&e.directory?r.canUsePublicDir&&e.usePublicDir?((0,i.uX)(),(0,i.CE)("dd",H,[(0,i.eW)((0,a.v_)(e.projectDir),1),(0,i.Lk)("span",null,"/"+(0,a.v_)(e.directory)+"/public",1)])):((0,i.uX)(),(0,i.CE)("dd",Q,[(0,i.eW)((0,a.v_)(e.projectDir),1),(0,i.Lk)("span",null,"/"+(0,a.v_)(e.directory)+"/web",1)])):((0,i.uX)(),(0,i.CE)("dd",O,[(0,i.eW)((0,a.v_)(e.projectDir),1),t[12]||(t[12]=(0,i.Lk)("span",null,"/web",-1))])):((0,i.uX)(),(0,i.CE)("dd",B,[(0,i.eW)((0,a.v_)(e.projectDir),1),t[11]||(t[11]=(0,i.Lk)("span",null,"/public",-1))]))])]),(0,i.Lk)("div",K,[(0,i.bF)(l,{inline:"",loading:e.processing,color:"primary",icon:"update",onClick:r.reload},{default:(0,i.k6)((()=>[(0,i.eW)((0,a.v_)(e.$t("ui.setup.document-root.reload")),1)])),_:1},8,["loading","onClick"])])])):e.conflicts.length?((0,i.uX)(),(0,i.CE)("main",J,[(0,i.Lk)("div",N,[(0,i.Lk)("h2",z,(0,a.v_)(e.$t("ui.setup.document-root.conflictsTitle")),1),(0,i.Lk)("p",Z,(0,a.v_)(e.$t("ui.setup.document-root.conflictsDirectory",{count:e.conflicts.length})),1),(0,i.Lk)("ul",null,[((0,i.uX)(!0),(0,i.CE)(i.FK,null,(0,i.pI)(e.conflicts.slice(0,5),(e=>((0,i.uX)(),(0,i.CE)("li",{key:e},(0,a.v_)(e),1)))),128)),e.conflicts.length>5?((0,i.uX)(),(0,i.CE)("li",Y,"...")):(0,i.Q3)("",!0)]),e.isPublic||e.isWeb?((0,i.uX)(),(0,i.Wv)(u,{key:0,name:"ignoreConflicts",label:e.$t("ui.setup.document-root.ignoreConflicts"),disabled:e.processing,modelValue:e.forceInstall,"onUpdate:modelValue":t[0]||(t[0]=t=>e.forceInstall=t)},null,8,["label","disabled","modelValue"])):(0,i.Q3)("",!0)]),(0,i.Lk)("div",G,[e.forceInstall?((0,i.uX)(),(0,i.CE)("button",{key:0,class:"widget-button widget-button--alert widget-button--run",onClick:t[1]||(t[1]=t=>e.$emit("continue"))},(0,a.v_)(e.$t("ui.server.contao.setup")),1)):((0,i.uX)(),(0,i.CE)(i.FK,{key:1},[(0,i.bF)(l,{inline:"",icon:"update",loading:e.processing,onClick:t[2]||(t[2]=e=>r.init(!1))},{default:(0,i.k6)((()=>[(0,i.eW)((0,a.v_)(e.$t("ui.setup.document-root.check")),1)])),_:1},8,["loading"]),(0,i.Lk)("button",{class:"widget-button widget-button--inline widget-button--primary widget-button--gear",disabled:e.processing,onClick:t[3]||(t[3]=t=>e.conflicts=[])},(0,a.v_)(e.$t("ui.setup.document-root.create")),9,ee)],64))])])):((0,i.uX)(),(0,i.CE)("main",te,[t[14]||(t[14]=(0,i.Lk)("img",{src:j,class:"invisible",alt:""},null,-1)),(0,i.Lk)("div",se,[(0,i.Lk)("h2",ie,(0,a.v_)(e.$t("ui.setup.document-root.formTitle")),1),(0,i.Lk)("p",ae,[(0,i.eW)((0,a.v_)(e.$t("ui.setup.document-root.formText1"))+" ",1),(0,i.Lk)("u",null,(0,a.v_)(e.$t("ui.setup.document-root.formText2")),1)]),!e.isEmpty||e.wantsFix?((0,i.uX)(),(0,i.Wv)(c,{key:0,ref:"directory",name:"directory",label:e.$t("ui.setup.document-root.directory"),error:r.directoryError,required:!e.isEmpty,pattern:"^[^/]+$",validate:"",modelValue:e.directory,"onUpdate:modelValue":t[4]||(t[4]=t=>e.directory=t)},null,8,["label","error","required","modelValue"])):(0,i.Q3)("",!0),r.canUsePublicDir?((0,i.uX)(),(0,i.Wv)(d,{key:1,name:"usePublicDir",options:r.publicDirOptions,"allow-html":"",modelValue:e.usePublicDir,"onUpdate:modelValue":t[5]||(t[5]=t=>e.usePublicDir=t)},null,8,["options","modelValue"])):(0,i.Q3)("",!0),(0,i.Lk)("dl",oe,[(0,i.Lk)("dt",null,(0,a.v_)(e.$t("ui.setup.document-root.currentRoot")),1),e.isWeb?((0,i.uX)(),(0,i.CE)("dd",ne,(0,a.v_)(e.projectDir)+(0,a.v_)(e.directorySeparator)+"web",1)):e.isPublic?((0,i.uX)(),(0,i.CE)("dd",re,(0,a.v_)(e.projectDir)+(0,a.v_)(e.directorySeparator)+"public",1)):((0,i.uX)(),(0,i.CE)("dd",le,(0,a.v_)(e.projectDir),1)),(0,i.Lk)("dt",null,(0,a.v_)(e.$t("ui.setup.document-root.newRoot")),1),!e.isEmpty||e.wantsFix&&e.directory||!r.canUsePublicDir||!e.usePublicDir?!e.isEmpty||e.wantsFix&&e.directory?r.canUsePublicDir&&e.usePublicDir?((0,i.uX)(),(0,i.CE)("dd",de,[(0,i.eW)((0,a.v_)(e.projectDir),1),(0,i.Lk)("span",null,(0,a.v_)(e.directorySeparator)+(0,a.v_)(e.directory)+(0,a.v_)(e.directorySeparator)+"public",1)])):((0,i.uX)(),(0,i.CE)("dd",pe,[(0,i.eW)((0,a.v_)(e.projectDir),1),(0,i.Lk)("span",null,(0,a.v_)(e.directorySeparator)+(0,a.v_)(e.directory)+(0,a.v_)(e.directorySeparator)+"web",1)])):((0,i.uX)(),(0,i.CE)("dd",ce,[(0,i.eW)((0,a.v_)(e.projectDir),1),(0,i.Lk)("span",null,(0,a.v_)(e.directorySeparator)+"web",1)])):((0,i.uX)(),(0,i.CE)("dd",ue,[(0,i.eW)((0,a.v_)(e.projectDir),1),(0,i.Lk)("span",null,(0,a.v_)(e.directorySeparator)+"public",1)]))]),(0,i.bF)(u,{name:"autoconfig",label:e.$t("ui.setup.document-root.autoconfig"),disabled:e.processing,modelValue:e.autoconfig,"onUpdate:modelValue":t[6]||(t[6]=t=>e.autoconfig=t)},null,8,["label","disabled","modelValue"])]),(0,i.Lk)("div",he,[(0,i.bF)(l,{color:"primary",icon:"run",loading:e.processing,disabled:!e.autoconfig||!!r.directoryError||e.wantsFix&&!e.directory&&(e.isPublic&&e.usePublicDir||e.isWeb&&!e.usePublicDir),onClick:r.setupDocroot},{default:(0,i.k6)((()=>[(0,i.eW)((0,a.v_)(e.$t("ui.setup.document-root.finish")),1)])),_:1},8,["loading","disabled","onClick"]),e.wantsFix?((0,i.uX)(),(0,i.CE)("button",{key:0,type:"button",class:"widget-button",disabled:e.processing,onClick:t[7]||(t[7]=function(){return r.init&&r.init(...arguments)})},(0,a.v_)(e.$t("ui.setup.cancel")),9,me)):(0,i.Q3)("",!0)])]))],64)):((0,i.uX)(),(0,i.CE)("main",_e,[(0,i.Lk)("div",ve,[t[15]||(t[15]=(0,i.Lk)("svg",{class:"setup__check",xmlns:"http://www.w3.org/2000/svg",width:"24",height:"24",viewBox:"0 0 24 24"},[(0,i.Lk)("path",{d:"M12,2A10,10 0 0,1 22,12A10,10 0 0,1 12,22A10,10 0 0,1 2,12A10,10 0 0,1 12,2M12,4A8,8 0 0,0 4,12A8,8 0 0,0 12,20A8,8 0 0,0 20,12A8,8 0 0,0 12,4M11,16.5L6.5,12L7.91,10.59L11,13.67L16.59,8.09L18,9.5L11,16.5Z"})],-1)),(0,i.Lk)("p",ke,(0,a.v_)(e.$t("ui.setup.document-root.success")),1),(0,i.bF)(p,{tag:"p",class:"setup__fielddesc",keypath:`ui.setup.document-root.${e.contaoVersion?"installed":"installing"}ProjectDir`},{dir:(0,i.k6)((()=>[(0,i.Lk)("code",null,(0,a.v_)(e.projectDir),1)])),_:1},8,["keypath"]),(0,i.bF)(p,{tag:"p",class:"setup__fielddesc",keypath:`ui.setup.document-root.${e.contaoVersion?"installed":"installing"}PublicDir`},{dir:(0,i.k6)((()=>[(0,i.Lk)("code",null,(0,a.v_)(r.publicDir),1)])),_:1},8,["keypath"])]),(0,i.Lk)("div",be,[e.contaoVersion?(0,i.Q3)("",!0):((0,i.uX)(),(0,i.CE)("button",{key:0,class:"widget-button widget-button--inline widget-button--gear",onClick:t[8]||(t[8]=t=>e.wantsFix=!0)},(0,a.v_)(e.$t("ui.setup.document-root.change")),1)),(0,i.Lk)("button",{class:"widget-button widget-button--inline widget-button--primary",onClick:t[9]||(t[9]=t=>e.$emit("continue"))},(0,a.v_)(e.$t("ui.setup.continue")),1)])]))])),_:1},8,["name"])):(0,i.Q3)("",!0)])}var fe=s(683);const ye={key:0},we=["id","name","disabled","required","checked","onClick"],Le=["for","innerHTML"],$e=["for"];function Ce(e,t,s,o,n,r){return(0,i.uX)(),(0,i.CE)("fieldset",{class:(0,a.C4)(["widget widget-radio-button",{"widget--required":s.required}])},[s.label||e.$slots.label?((0,i.uX)(),(0,i.CE)("legend",ye,[(0,i.RG)(e.$slots,"label",{},(()=>[(0,i.eW)((0,a.v_)(s.label),1)]))])):(0,i.Q3)("",!0),((0,i.uX)(!0),(0,i.CE)(i.FK,null,(0,i.pI)(s.options,((e,t)=>((0,i.uX)(),(0,i.CE)("div",{key:t},[(0,i.Lk)("input",{ref_for:!0,ref:"input",type:"radio",id:`ctrl_${s.name}_${e.value}`,name:s.name,disabled:e.disabled,required:s.required,checked:s.modelValue===e.value,onClick:t=>r.input(e.value)},null,8,we),s.allowHtml?((0,i.uX)(),(0,i.CE)("label",{key:0,for:`ctrl_${s.name}_${e.value}`,innerHTML:e.label},null,8,Le)):((0,i.uX)(),(0,i.CE)("label",{key:1,for:`ctrl_${s.name}_${e.value}`},(0,a.v_)(e.label),9,$e))])))),128))],2)}var Ee={emits:["input","update:modelValue"],props:{name:{type:String,required:!0},options:{type:Array,required:!0},label:String,modelValue:{required:!0},disabled:Boolean,required:Boolean,allowHtml:{type:Boolean,default:!1}},methods:{input(e){this.$emit("input"),this.$emit("update:modelValue",e)}}},Xe=s(6262);const Fe=(0,Xe.A)(Ee,[["render",Ce]]);var je=Fe,Ae=s(948),Ve=s(6966),Ue={components:{TextField:fe.A,RadioButton:je,CheckBox:Ae.A,LoadingButton:Ve.A},data:()=>({processing:!1,usePublicDir:!1,wantsFix:!1,conflicts:[],isEmpty:!0,isWeb:!0,isPublic:!1,projectDir:null,autoconfig:!1,forceInstall:!1,directory:"",directoryExists:!1,directoryUpdated:!1,directorySeparator:"/"}),computed:{...(0,C.aH)("server/php-web",["phpVersionId"]),...(0,C.aH)("server/contao",["contaoVersion"]),needsFix:e=>!e.isEmpty||!e.isWeb&&(!e.isPublic||!e.canUsePublicDir),publicDirOptions:e=>[{label:e.$t("ui.setup.document-root.publicDir",{dir:"<code>web</code>",version:"4.9+"}),value:!1},{label:e.$t("ui.setup.document-root.publicDir",{dir:"<code>public</code>",version:"4.13+"}),value:!0}],canUsePublicDir:e=>e.phpVersionId>=70400,publicDir:e=>e.isWeb?`${e.projectDir}${e.directorySeparator}web`:`${e.projectDir}${e.directorySeparator}public`,directoryError(){return this.directoryExists?this.$t("ui.setup.document-root.directoryExists"):this.directory&&!this.directory.match(/^[^/]+$/)?this.$t("ui.setup.document-root.directoryInvalid"):this.wantsFix||this.isEmpty||this.directory?"":this.$t("ui.setup.document-root.directoryInvalid")}},methods:{reload(){this.processing=!0,window.location.reload()},async setupDocroot(){this.processing=!0;const e=await this.$store.dispatch("server/contao/documentRoot",{directory:!this.isEmpty||this.wantsFix?this.directory:null,usePublicDir:this.canUsePublicDir&&this.usePublicDir});if(403===e.status)return this.directoryExists=!0,this.processing=!1,void this.$refs.directory.focus();this.processing=!1,this.directoryUpdated=!0,this.$store.commit("auth/resetCountdown")},async init(){let e=!(arguments.length>0&&void 0!==arguments[0])||arguments[0];this.processing=!0;const t=await this.$store.dispatch("server/contao/get",e);this.projectDir=t.data.project_dir,this.conflicts=t.data.conflicts,this.isEmpty=0===t.data.conflicts.length,this.isWeb="web"===t.data.public_dir,this.isPublic="public"===t.data.public_dir,this.usePublicDir="public"===t.data.public_dir,this.wantsFix=!1,this.directory=this.isEmpty?"":location.hostname,this.directorySeparator=t.data.directory_separator,this.processing=!1}},watch:{directory(){this.directoryExists=!1}},async mounted(){this.init()}};const xe=(0,Xe.A)(Ue,[["render",ge]]);var De=xe,Se=(s(8111),s(1701),s.p+"img/create-project.b22522ee.svg"),Pe=s(7591);const We={class:"setup__header"},Te=["src","alt"],Ie={key:1,src:Se,width:"80",height:"80",alt:"",class:"setup__icon"},qe={class:"setup__headline"},Re={class:"setup__description"},Me={class:"setup__version"},Be={class:"setup__version"},Oe={key:2,class:"setup__version"},He={key:3,class:"setup__version"},Qe={key:4,class:"setup__version"},Ke=["href"],Je={class:"setup__form"},Ne={key:0,class:"setup__fields"},ze={class:"setup__fieldtitle"},Ze={class:"setup__fielddesc"},Ye={class:"setup__tabs"},Ge={class:"setup__tab-controls"},et={key:0,class:"setup__tab"},tt={class:"setup__requires"},st={key:1,class:"setup__tab setup__tab--files"},it={class:"setup__fielddesc setup__fielddesc--warning"},at={class:"setup__actions"},ot=["disabled"],nt={class:"setup__header"},rt={class:"setup__headline"},lt={href:"https://semver.org",target:"_blank",rel:"noreferrer noopener"},ut={class:"setup__versions"},ct={class:"setup__version--warning"},dt=["href"],pt={key:0,class:"setup__form"},ht={class:"setup__fields setup__fields--center"},mt={class:"setup__fielddesc"},_t={class:"setup__actions setup__actions--center"},vt={key:1,class:"setup__form"},kt={class:"setup__fields"},bt={class:"setup__fieldtitle"},gt={class:"setup__fielddesc setup__fielddesc--version"},ft={key:0,class:"setup__theme"},yt={href:"https://themes.contao.org",target:"_blank"},wt={class:"package-uploads__overlay"},Lt={href:"https://themes.contao.org",target:"_blank"},$t={class:"setup__fields"},Ct={class:"setup__or"},Et=["disabled"],Xt=["disabled"],Ft={key:2,class:"setup__themes"},jt={key:1,class:"setup__theme-search setup__theme-search--offline"},At={key:2,class:"setup__theme-search setup__theme-search--empty"},Vt={class:"setup__themes-results"},Ut={class:"setup__themes-more"};function xt(e,t,s,o,n,r){const l=(0,i.g2)("file-upload"),u=(0,i.g2)("file-tree"),c=(0,i.g2)("loading-button"),d=(0,i.g2)("i18n-t"),p=(0,i.g2)("radio-button"),h=(0,i.g2)("check-box"),m=(0,i.g2)("search-input"),_=(0,i.g2)("button-group"),v=(0,i.g2)("loading-spinner"),k=(0,i.g2)("discover-package");return(0,i.uX)(),(0,i.CE)("div",null,[(0,i.bF)(l,{name:"package",ref:"uploader","post-action":"api/packages/uploads",multiple:!0,drop:!0,"drop-directory":!1,"chunk-enabled":!0,chunk:{action:"api/packages/uploads"},onInputFile:r.uploadTheme,onInputFilter:r.filterTheme},null,8,["onInputFile","onInputFilter"]),e.theme?((0,i.uX)(),(0,i.CE)(i.FK,{key:0},[(0,i.Lk)("header",We,[e.themeImage?((0,i.uX)(),(0,i.CE)("img",{key:0,class:"setup__theme-image",src:e.themeImage,alt:e.theme.composerJson.name},null,8,Te)):((0,i.uX)(),(0,i.CE)("img",Ie)),(0,i.Lk)("h1",qe,(0,a.v_)(e.$t("ui.setup.create-project.headline")),1),(0,i.Lk)("p",Re,(0,a.v_)(e.$t("ui.setup.create-project.theme.uploaded")),1),(0,i.Lk)("div",Me,[(0,i.Lk)("strong",null,(0,a.v_)(e.$t("ui.setup.create-project.theme.packageName"))+":",1),(0,i.eW)(" "+(0,a.v_)(e.theme.composerJson.name),1)]),(0,i.Lk)("div",Be,[(0,i.Lk)("strong",null,(0,a.v_)(e.$t("ui.setup.create-project.theme.version"))+":",1),(0,i.eW)(" "+(0,a.v_)(e.theme.composerJson.version),1)]),e.theme.composerJson.authors||e.theme.authors?((0,i.uX)(),(0,i.CE)("div",Oe,[(0,i.Lk)("strong",null,(0,a.v_)(e.$t("ui.setup.create-project.theme.authors"))+":",1),e.theme.composerJson.authors?((0,i.uX)(),(0,i.CE)(i.FK,{key:0},[(0,i.eW)((0,a.v_)(e.theme.composerJson.authors.map((e=>e.name)).join(", ")),1)],64)):((0,i.uX)(),(0,i.CE)(i.FK,{key:1},[(0,i.eW)((0,a.v_)(e.theme.authors),1)],64))])):(0,i.Q3)("",!0),e.theme.composerJson.license?((0,i.uX)(),(0,i.CE)("div",He,[(0,i.Lk)("strong",null,(0,a.v_)(e.$t("ui.package-details.license"))+":",1),(0,i.eW)(" "+(0,a.v_)(Array.isArray(e.theme.composerJson.license)?e.theme.composerJson.license.join(", "):e.theme.composerJson.license),1)])):(0,i.Q3)("",!0),e.theme.composerJson.homepage?((0,i.uX)(),(0,i.CE)("div",Qe,[(0,i.Lk)("strong",null,(0,a.v_)(e.$t("ui.package.homepage"))+": ",1),(0,i.Lk)("a",{href:e.theme.composerJson.homepage,target:"_blank"},(0,a.v_)(e.theme.composerJson.homepage),9,Ke)])):(0,i.Q3)("",!0),(0,i.Lk)("button",{class:"widget-button widget-button--info widget-button--details",onClick:t[0]||(t[0]=function(){return r.themeDetails&&r.themeDetails(...arguments)})},(0,a.v_)(e.$t("ui.package.detailsButton")),1)]),(0,i.Lk)("main",Je,[e.theme.files?((0,i.uX)(),(0,i.CE)("div",Ne,[(0,i.Lk)("h2",ze,(0,a.v_)(e.$t("ui.setup.create-project.themeTitle")),1),(0,i.Lk)("p",Ze,(0,a.v_)(e.$t("ui.setup.create-project.themeDetails")),1),(0,i.Lk)("div",Ye,[(0,i.Lk)("div",Ge,[(0,i.Lk)("button",{class:(0,a.C4)(["setup__tab-control",{"setup__tab-control--active":"require"===e.view}]),onClick:t[1]||(t[1]=t=>e.view="require")},(0,a.v_)(e.$tc("ui.setup.create-project.themeRequire",Object.keys(e.theme.composerJson.require).length)),3),(0,i.Lk)("button",{class:(0,a.C4)(["setup__tab-control",{"setup__tab-control--active":"files"===e.view}]),onClick:t[2]||(t[2]=t=>e.view="files")},(0,a.v_)(e.$tc("ui.setup.create-project.themeFiles",e.theme.files.length)),3)]),"require"===e.view?((0,i.uX)(),(0,i.CE)("div",et,[(0,i.Lk)("table",tt,[(0,i.Lk)("tbody",null,[((0,i.uX)(!0),(0,i.CE)(i.FK,null,(0,i.pI)(e.theme.composerJson.require,((e,t)=>((0,i.uX)(),(0,i.CE)("tr",{key:t},[(0,i.Lk)("td",null,(0,a.v_)(t)+":",1),(0,i.Lk)("td",null,(0,a.v_)(e),1)])))),128))])])])):(0,i.Q3)("",!0),"files"===e.view?((0,i.uX)(),(0,i.CE)("div",st,[(0,i.bF)(u,{files:r.themeFiles},null,8,["files"])])):(0,i.Q3)("",!0)]),(0,i.Lk)("p",it,(0,a.v_)(e.$t("ui.setup.create-project.themeWarning")),1)])):(0,i.Q3)("",!0),(0,i.Lk)("div",at,[(0,i.bF)(c,{color:"primary",icon:"run",loading:e.processing,onClick:r.installTheme},{default:(0,i.k6)((()=>[(0,i.eW)((0,a.v_)(e.$t("ui.setup.create-project.install")),1)])),_:1},8,["loading","onClick"]),(0,i.Lk)("button",{class:"widget-button",onClick:t[3]||(t[3]=function(){return r.cancelTheme&&r.cancelTheme(...arguments)}),disabled:e.processing},(0,a.v_)(e.$t("ui.setup.create-project.cancel")),9,ot)])])],64)):((0,i.uX)(),(0,i.CE)(i.FK,{key:1},[(0,i.Lk)("header",nt,[t[14]||(t[14]=(0,i.Lk)("img",{src:Se,width:"80",height:"80",alt:"",class:"setup__icon"},null,-1)),(0,i.Lk)("h1",rt,(0,a.v_)(e.$t("ui.setup.create-project.headline")),1),(0,i.bF)(d,{tag:"p",keypath:"ui.setup.create-project.description",class:"setup__description"},{semver:(0,i.k6)((()=>[(0,i.Lk)("a",lt,(0,a.v_)(e.$t("ui.setup.create-project.semver")),1)])),_:1}),(0,i.Lk)("ul",ut,[((0,i.uX)(!0),(0,i.CE)(i.FK,null,(0,i.pI)(r.versions,(e=>((0,i.uX)(),(0,i.CE)(i.FK,null,[e.description?((0,i.uX)(),(0,i.CE)(i.FK,{key:0},[e.disabled?((0,i.uX)(),(0,i.CE)("li",{class:"setup__version",key:e.value},[(0,i.Lk)("strong",null,(0,a.v_)(e.label),1),t[13]||(t[13]=(0,i.Lk)("br",null,null,-1)),(0,i.Lk)("span",ct,(0,a.v_)(e.problem),1)])):((0,i.uX)(),(0,i.CE)("li",{class:"setup__version",key:e.value},[(0,i.Lk)("strong",null,(0,a.v_)(e.label),1),t[12]||(t[12]=(0,i.Lk)("br",null,null,-1)),(0,i.eW)(" "+(0,a.v_)(e.description),1)]))],64)):(0,i.Q3)("",!0)],64)))),256))]),(0,i.bF)(d,{tag:"p",keypath:"ui.setup.create-project.releaseplan",class:"setup__releaseplan"},{contaoReleasePlan:(0,i.k6)((()=>[(0,i.Lk)("a",{href:`https://to.contao.org/release-plan?lang=${e.$i18n.locale}`,target:"_blank",rel:"noreferrer noopener"},(0,a.v_)(e.$t("ui.setup.create-project.releaseplanLink")),9,dt)])),_:1})]),e.contaoVersion?((0,i.uX)(),(0,i.CE)("main",pt,[(0,i.Lk)("div",ht,[t[15]||(t[15]=(0,i.Lk)("svg",{class:"setup__check",xmlns:"http://www.w3.org/2000/svg",width:"24",height:"24",viewBox:"0 0 24 24"},[(0,i.Lk)("path",{d:"M12,2A10,10 0 0,1 22,12A10,10 0 0,1 12,22A10,10 0 0,1 2,12A10,10 0 0,1 12,2M12,4A8,8 0 0,0 4,12A8,8 0 0,0 12,20A8,8 0 0,0 20,12A8,8 0 0,0 12,4M11,16.5L6.5,12L7.91,10.59L11,13.67L16.59,8.09L18,9.5L11,16.5Z"})],-1)),(0,i.Lk)("p",mt,(0,a.v_)(e.$t("ui.setup.create-project.installed",{version:e.contaoVersion})),1)]),(0,i.Lk)("div",_t,[(0,i.Lk)("button",{class:"widget-button widget-button--inline",onClick:t[4]||(t[4]=function(){return r.launch&&r.launch(...arguments)})},(0,a.v_)(e.$t("ui.setup.manager")),1),(0,i.Lk)("button",{class:"widget-button widget-button--inline widget-button--primary",onClick:t[5]||(t[5]=t=>e.$emit("continue"))},(0,a.v_)(e.$t("ui.setup.continue")),1)])])):((0,i.uX)(),(0,i.CE)("main",vt,[(0,i.Lk)("div",kt,[(0,i.Lk)("h2",bt,(0,a.v_)(e.$t("ui.setup.create-project.formTitle")),1),(0,i.Lk)("p",gt,(0,a.v_)(e.$t("ui.setup.create-project.formText")),1),(0,i.bF)(p,{name:"version",options:r.versions,disabled:e.processing,modelValue:e.version,"onUpdate:modelValue":t[6]||(t[6]=t=>e.version=t)},null,8,["options","disabled","modelValue"]),"theme"===e.version?((0,i.uX)(),(0,i.CE)("div",ft,[(0,i.Lk)("p",null,(0,a.v_)(e.$t("ui.setup.create-project.themeInstall")),1),(0,i.bF)(d,{keypath:"ui.setup.create-project.themeBuy",tag:"p"},{store:(0,i.k6)((()=>[(0,i.Lk)("a",yt,(0,a.v_)(e.$t("ui.setup.create-project.themeStore")),1)])),_:1}),(0,i.bo)((0,i.Lk)("div",wt,[(0,i.Lk)("div",null,[t[16]||(t[16]=(0,i.Lk)("img",{src:Pe,alt:"",width:"128",height:"128"},null,-1)),(0,i.Lk)("p",null,(0,a.v_)(e.$t("ui.packages.uploadOverlay")),1)])],512),[[X.aG,e.$refs.uploader&&e.$refs.uploader.dropActive]])])):((0,i.uX)(),(0,i.Wv)(h,{key:1,name:"demo",label:e.$t("ui.setup.create-project.demo"),disabled:e.processing,modelValue:e.demo,"onUpdate:modelValue":t[7]||(t[7]=t=>e.demo=t)},{description:(0,i.k6)((()=>[(0,i.bF)(d,{tag:"p",keypath:"ui.setup.create-project.demoDescription"},{store:(0,i.k6)((()=>[(0,i.Lk)("a",Lt,(0,a.v_)(e.$t("ui.setup.create-project.themeStore")),1)])),_:1})])),_:1},8,["label","disabled","modelValue"]))]),(0,i.Lk)("div",$t,["theme"===e.version?((0,i.uX)(),(0,i.CE)(i.FK,{key:0},[(0,i.bF)(c,{color:"primary",icon:"upload",loading:e.processing,onClick:r.openFileSelector},{default:(0,i.k6)((()=>[(0,i.eW)((0,a.v_)(e.$t("ui.setup.create-project.themeUpload")),1)])),_:1},8,["loading","onClick"]),(0,i.Lk)("div",Ct,[(0,i.Lk)("span",null,(0,a.v_)(e.$t("ui.setup.create-project.theme.or")),1)]),(0,i.bF)(m,{placeholder:e.$t("ui.setup.create-project.theme.search"),disabled:e.processing},null,8,["placeholder","disabled"])],64)):((0,i.uX)(),(0,i.Wv)(_,{key:1,color:"primary",icon:"run",disabled:!e.version,loading:e.processing,onClick:t[10]||(t[10]=()=>r.install()),label:e.$t("ui.setup.create-project.install")},{default:(0,i.k6)((()=>[e.demo?(0,i.Q3)("",!0):((0,i.uX)(),(0,i.CE)("button",{key:0,class:"widget-button",disabled:!e.version||e.processing,onClick:t[8]||(t[8]=function(){return r.installCoreOnly&&r.installCoreOnly(...arguments)})},(0,a.v_)(e.$t("ui.setup.create-project.coreOnly")),9,Et)),(0,i.Lk)("button",{class:"widget-button",disabled:!e.version||e.processing,onClick:t[9]||(t[9]=function(){return r.installNoUpdate&&r.installNoUpdate(...arguments)})},(0,a.v_)(e.$t("ui.setup.create-project.noUpdate")),9,Xt)])),_:1},8,["disabled","loading","label"]))])])),t[17]||(t[17]=(0,i.Lk)("div",{class:"clearfix"},null,-1)),e.searching||e.results||e.offline?((0,i.uX)(),(0,i.CE)("div",Ft,[e.searching&&!e.results?((0,i.uX)(),(0,i.Wv)(v,{key:0,class:"setup__theme-search setup__theme-search--loader"},{default:(0,i.k6)((()=>[(0,i.Lk)("p",null,(0,a.v_)(e.$t("ui.discover.loading")),1)])),_:1})):e.offline?((0,i.uX)(),(0,i.CE)("div",jt,[(0,i.Lk)("p",null,(0,a.v_)(e.$t("ui.discover.offline")),1),(0,i.Lk)("p",null,(0,a.v_)(e.$t("ui.discover.offlineExplain")),1),(0,i.Lk)("button",{class:"widget-button widget-button--inline widget-button--update",onClick:t[11]||(t[11]=function(){return r.searchThemes&&r.searchThemes(...arguments)})},(0,a.v_)(e.$t("ui.discover.offlineButton")),1)])):e.isSearching&&e.results&&!Object.keys(e.results).length?((0,i.uX)(),(0,i.CE)("div",At,[(0,i.bF)(d,{tag:"p",keypath:"ui.setup.create-project.theme.empty"},{query:(0,i.k6)((()=>[(0,i.Lk)("i",null,(0,a.v_)(e.query),1)])),_:1})])):e.isSearching&&e.results?((0,i.uX)(),(0,i.CE)(i.FK,{key:3},[(0,i.Lk)("div",Vt,[((0,i.uX)(!0),(0,i.CE)(i.FK,null,(0,i.pI)(e.results,(e=>((0,i.uX)(),(0,i.Wv)(k,{class:"setup__themes-item",data:e,key:e.name},null,8,["data"])))),128))]),(0,i.Lk)("div",Ut,[e.hasMore?((0,i.uX)(),(0,i.Wv)(c,{key:0,inline:"",icon:"search",loading:e.searching,onClick:e.loadMore},{default:(0,i.k6)((()=>[(0,i.eW)((0,a.v_)(e.$t("ui.setup.create-project.theme.more")),1)])),_:1},8,["loading","onClick"])):(0,i.Q3)("",!0)])],64)):(0,i.Q3)("",!0)])):(0,i.Q3)("",!0)],64))])}s(2489),s(116),s(7588),s(4603),s(7566),s(8721);var Dt=s(4686),St=s.n(Dt),Pt=s(1881),Wt=s(8568),Tt=s.n(Wt);const It=["href"],qt=["href"],Rt={key:3};function Mt(e,t,s,o,n,r){const l=(0,i.g2)("package-constraint"),u=(0,i.g2)("package-details");return(0,i.uX)(),(0,i.Wv)(u,null,{"package-actions":(0,i.k6)((()=>[!e.isTheme||r.data.uploaded||r.isPrivate?r.data.homepage||e.metadata.homepage?((0,i.uX)(),(0,i.CE)("a",{key:1,class:"widget-button widget-button--primary widget-button--link",target:"_blank",href:r.data.homepage||e.metadata.homepage},(0,a.v_)(e.$t("ui.package.homepage")),9,It)):r.isPrivate?((0,i.uX)(),(0,i.CE)("div",Rt)):((0,i.uX)(),(0,i.CE)("a",{key:2,class:"widget-button widget-button--primary widget-button--link",target:"_blank",href:`https://packagist.org/packages/${r.data.name}`},(0,a.v_)(e.$t("ui.package-details.packagist")),9,qt)):((0,i.uX)(),(0,i.CE)(i.FK,{key:0},[(0,i.Lk)("button",{class:"widget-button widget-button--primary widget-button--run",onClick:t[0]||(t[0]=function(){return r.install&&r.install(...arguments)})},(0,a.v_)(e.$t("ui.setup.create-project.install")),1),(0,i.bF)(l,{class:"theme-details__constraint",emit:!0,data:r.data,modelValue:e.version,"onUpdate:modelValue":t[1]||(t[1]=t=>e.version=t)},null,8,["data","modelValue"])],64))])),_:1})}var Bt=s(7661),Ot=s(3629),Ht=s(416),Qt=s(8200),Kt={mixins:[Ht.A,Qt.A],components:{PackageConstraint:Ot.A,PackageDetails:Bt["default"]},data:()=>({version:""}),computed:{...(0,C.aH)("packages",{allInstalled:"installed"}),current:e=>e.$route.query.p,data:e=>e.allInstalled&&e.allInstalled[e.current]||{name:e.current},isPrivate:e=>e.metadata&&!!e.metadata.private},methods:{install(){this.$store.commit("contao/installTheme",{package:this.data.name,version:this.version})}}};const Jt=(0,Xe.A)(Kt,[["render",Mt]]);var Nt=Jt,zt=s(4070),Zt=s(4999),Yt=s(6183);const Gt={class:"file-tree"},es=["onClick"],ts={key:1,class:"file-tree__file"};function ss(e,t,s,o,n,r){const l=(0,i.g2)("file-tree",!0);return(0,i.uX)(),(0,i.CE)("ul",Gt,[((0,i.uX)(!0),(0,i.CE)(i.FK,null,(0,i.pI)(s.files,((e,t)=>((0,i.uX)(),(0,i.CE)(i.FK,{key:t},[e.children.length?((0,i.uX)(),(0,i.CE)("li",{key:0,class:(0,a.C4)("file-tree__folder"+(r.isOpen(e)?" file-tree__folder--open":""))},[(0,i.Lk)("button",{onClick:t=>r.toggle(e)},(0,a.v_)(r.name(e)),9,es),r.isOpen(e)?((0,i.uX)(),(0,i.Wv)(l,{key:0,files:e.children},null,8,["files"])):(0,i.Q3)("",!0)],2)):((0,i.uX)(),(0,i.CE)("li",ts,[(0,i.Lk)("span",null,(0,a.v_)(r.name(e)),1)]))],64)))),128))])}var is={name:"FileTree",props:{files:{type:Array,required:!0}},data:()=>({open:[]}),computed:{name:()=>e=>e.name?e.name:e.path.substring(e.path.lastIndexOf("/")+1),isOpen:e=>t=>e.open.includes(t)},methods:{toggle(e){this.open.includes(e)?this.open=this.open.filter((t=>t!==e)):this.open.push(e)}}};const as=(0,Xe.A)(is,[["render",ss]]);var os=as,ns=s(4779),rs={mixins:[Pt.A],components:{ButtonGroup:ns.A,FileTree:os,DiscoverPackage:Yt.A,LoadingSpinner:Zt.A,SearchInput:zt.A,FileUpload:Tt(),RadioButton:je,CheckBox:Ae.A,LoadingButton:Ve.A},data:()=>({processing:!1,isWeb:!0,version:"5.5",demo:!1,view:"require",theme:null,themeImage:null,searching:!1,results:null,hasMore:!1,offline:!1}),computed:{...(0,C.aH)("tasks",{taskStatus:"status"}),...(0,C.aH)("server/php-web",["phpVersionId","phpVersion"]),...(0,C.aH)("server/contao",["contaoVersion"]),...(0,C.aH)("contao",{themeName:"package",themeVersion:"version"}),themeFiles:e=>St()(e.theme.files,{directoriesFirst:!0}).children,versions(){const e=[];return e.push({value:"5.5",label:`Contao 5.5 (${this.$t("ui.setup.create-project.latestTitle")})`,disabled:this.phpVersionId<80200,description:this.$t("ui.setup.create-project.latestQ3",{year:"2025"}),problem:this.$t("ui.setup.create-project.requiresPHP",{version:"8.2.0",current:this.phpVersion})}),e.push({value:"5.3",label:`Contao 5.3 (${this.$t("ui.setup.create-project.ltsTitle")})`,disabled:this.phpVersionId<80100,description:this.$t("ui.setup.create-project.ltsText",{year:"2027"}),problem:this.$t("ui.setup.create-project.requiresPHP",{version:"8.1.0",current:this.phpVersion})}),e.push({value:"4.13",label:`Contao 4.13 (${this.$t("ui.setup.create-project.ltsTitle")})`,disabled:this.phpVersionId<70400,description:this.$t("ui.setup.create-project.pltsText",{year:"2025"}),problem:this.$t("ui.setup.create-project.requiresPHP",{version:"7.4.0",current:this.phpVersion})}),e.push({value:"theme",label:this.$t("ui.setup.create-project.theme")}),e}},watch:{version(){this.stopSearch(),this.searching=!1,this.results=null,this.hasMore=!1},sorting(){this.searchThemes()},query(){this.results=null,this.query?this.searchThemes():(this.searching=!1,this.hasMore=!1)},pages(){this.searchThemes()},themeName(){this.closePopup(),this.install({package:this.themeName,version:this.themeVersion})}},methods:{...(0,C.PY)("packages/details",{closePopup:"clearCurrent"}),async searchThemes(){this.searching=!0,this.offline=!1;try{const e={facetFilters:["type:contao-theme"],hitsPerPage:10*this.pages};this.query?e.query=this.query:this.sorting&&(e.sorting=this.sorting);const t=await this.$store.dispatch("algolia/findPackages",e);if(this.hasMore=t.nbPages>1,0===t.nbHits)return void(this.results={});const s={};t.hits.forEach((e=>{s[e.name]=e})),this.results=s}catch(e){this.offline=!0}this.searching=!1},async install(e){let t,s=arguments.length>1&&void 0!==arguments[1]?arguments[1]:null;this.processing=!0,t=e||(this.theme?{upload:this.theme.upload.id}:this.demo?{package:"contao/contao-demo",version:this.version,"no-update":"no-update"===s?"1":"0"}:{version:this.version,"core-only":"core-only"===s?"1":"0","no-update":"no-update"===s?"1":"0"}),await this.$store.dispatch("contao/install",t),"complete"===this.taskStatus&&(this.$store.commit("tasks/setDeleting",!0),"no-update"===s?(this.$store.commit("setSafeMode",!0),this.$store.commit("setView",$.A.READY)):(this.isWeb="web"===(await this.$store.dispatch("server/contao/get",!1)).data.public_dir,await Promise.all([this.$store.dispatch("contao/install-tool/fetch",!1),this.$store.dispatch("server/database/get",!1),this.$store.dispatch("contao/backup/fetch",!1)]),this.$store.commit("contao/backup/setRestore",!0),this.$store.commit("setup",3)),this.$store.dispatch("tasks/deleteCurrent"))},installNoUpdate(){this.install(null,"no-update")},installCoreOnly(){this.install(null,"core-only")},launch(){this.$store.commit("setView",$.A.READY)},openFileSelector(){this.$refs.uploader&&this.$refs.uploader.$el.querySelector("input").click()},async filterTheme(e,t,s){if(e&&!t&&!/(\.cto|\.zip)$/i.test(e.name))return console&&console.debug(`${e.name} is not a .zip or .cto`),alert(this.$t("ui.setup.create-project.themeInvalid")),s()},async uploadTheme(e,t){if(e){if(this.processing=!0,this.$refs.uploader.uploaded&&e&&t&&!e.active&&t.active)return this.theme.upload=e.response.data,void(e.success&&this.install());e.url=URL.createObjectURL(e.file);try{const t=new File([e.file],e.name,{type:e.type}),a=(await s.e(710).then(s.t.bind(s,1710,23))).default,o=await a.loadAsync(t),n=o.filter((e=>!["composer.json","theme.xml"].includes(e)&&!e.startsWith("__MACOSX/")&&!e.includes(".DS_Store")&&!e.endsWith("/"))).map((e=>e.name));let r=n[0].substring(0,n[0].indexOf("/")+1);n.find((e=>e.substr(0,r.length)!==r))&&(r="");const l=JSON.parse(await o.file(`${r}composer.json`).async("string")),u=await o.file(`${r}theme.xml`).async("string"),c=new DOMParser,d=c.parseFromString(u,"application/xml");if(this.theme={tstamp:d.querySelector('table[name="tl_theme"] field[name="tstamp"]')?.innerHTML,name:d.querySelector('table[name="tl_theme"] field[name="name"]')?.innerHTML,author:d.querySelector('table[name="tl_theme"] field[name="author"]')?.innerHTML,screenshot:d.querySelector('table[name="tl_theme"] field[name="screenshot"]')?.innerHTML,composerJson:l,files:n},this.theme.screenshot&&"NULL"!==this.theme.screenshot)try{const e=await o.file(`${r}${this.theme.screenshot}`);this.themeImage=e?URL.createObjectURL(await e.async("blob")):null}catch(i){}}catch(i){console&&console.debug(i),alert(this.$t("ui.setup.create-project.themeInvalid")),this.cancelTheme()}this.processing=!1}},cancelTheme(){this.theme=null,this.$refs.uploader.clear()},themeDetails(){this.$store.commit("packages/setInstalled",{local:{[this.theme.composerJson.name]:Object.assign({},this.theme.composerJson,{uploaded:!0})}}),this.$store.commit("packages/details/setCurrent",this.theme.composerJson.name)},installTheme(){this.$refs.uploader.active||(this.processing=!0,this.$refs.uploader.active=!0)}},async mounted(){await this.$router.isReady(),Object.keys(this.$route.query).length&&this.$router.replace({query:null}),await this.$store.dispatch("packages/details/init",{vue:this,component:Nt}),this.$store.commit("packages/setInstalled",{}),this.isWeb="web"===(await this.$store.dispatch("server/contao/get")).data.public_dir,this.version=this.versions.find((e=>!e.disabled)).value}};const ls=(0,Xe.A)(rs,[["render",xt]]);var us=ls,cs=s(9472);const ds={class:"setup__header"},ps={class:"setup__headline"},hs={class:"setup__form",key:"setup"},ms={class:"setup__fields"},_s={class:"setup__fieldtitle"},vs={class:"setup__fielddesc"},ks={key:0,class:"setup__warning"},bs={class:"setup__or"},gs={class:"setup__actions"},fs=["disabled"],ys={class:"setup__form",key:"confirmation"},ws={class:"setup__fields"},Ls={class:"setup__fieldtitle"},$s={key:"migrate"},Cs={class:"setup__fields"},Es={class:"setup__fieldtitle"},Xs={key:0,class:"setup__fielddesc setup__warning"},Fs={key:1,class:"setup__fielddesc"},js={class:"setup__actions setup__actions--center"},As={key:"restored"},Vs={class:"setup__fields"},Us={class:"setup__fieldtitle"},xs={class:"setup__fielddesc"},Ds={class:"setup__actions setup__actions--center"},Ss={key:"backup"},Ps={class:"setup__fields"},Ws={class:"setup__fieldtitle"},Ts={class:"setup__fielddesc"},Is={class:"setup__fielddesc setup__warning"},qs={class:"setup__actions"},Rs=["disabled"];function Ms(e,t,s,o,n,r){const l=(0,i.g2)("i18n-t"),u=(0,i.g2)("text-field"),c=(0,i.g2)("loading-button"),d=(0,i.g2)("radio-button");return(0,i.uX)(),(0,i.CE)("section",null,[(0,i.Lk)("header",ds,[t[17]||(t[17]=(0,i.Lk)("img",{src:cs,width:"80",height:"80",class:"setup__icon",alt:""},null,-1)),(0,i.Lk)("h1",ps,(0,a.v_)(e.$t("ui.setup.database-connection.headline")),1),(0,i.bF)(l,{tag:"p",keypath:"ui.setup.database-connection.description",class:"setup__description"},{env:(0,i.k6)((()=>t[16]||(t[16]=[(0,i.Lk)("code",null,".env.local",-1)]))),_:1})]),e.currentState?((0,i.uX)(),(0,i.Wv)(X.eB,{key:0,name:"animate-flip",type:"transition",mode:"out-in"},{default:(0,i.k6)((()=>["error"===e.currentState||"edit"===e.currentState?((0,i.uX)(),(0,i.CE)("main",hs,[(0,i.Lk)("form",{onSubmit:t[7]||(t[7]=(0,X.D$)((function(){return r.save&&r.save(...arguments)}),["prevent"]))},[(0,i.Lk)("div",ms,[(0,i.Lk)("h2",_s,(0,a.v_)(e.$t("ui.setup.database-connection.formTitle")),1),(0,i.Lk)("p",vs,(0,a.v_)(e.$t("ui.setup.database-connection.formText")),1),"edit"!==e.currentState&&""!==e.currentUrl?((0,i.uX)(),(0,i.CE)("p",ks,(0,a.v_)(e.$t("ui.setup.database-connection.error")),1)):(0,i.Q3)("",!0),(0,i.bF)(u,{ref:"url",name:"url",type:"url",label:e.$t("ui.setup.database-connection.url"),placeholder:"mysql://user:password@server:port/database",required:"",pattern:e.urlPattern,validate:"",disabled:e.processing,modelValue:e.url,"onUpdate:modelValue":t[0]||(t[0]=t=>e.url=t),onKeyup:t[1]||(t[1]=t=>e.validUrl=!0),onBlur:r.parseUrl,error:e.validUrl?void 0:e.$t("ui.setup.database-connection.validUrl")},null,8,["label","pattern","disabled","modelValue","onBlur","error"]),(0,i.Lk)("div",bs,[(0,i.Lk)("span",null,(0,a.v_)(e.$t("ui.setup.database-connection.or")),1)]),(0,i.bF)(u,{name:"user",label:e.$t("ui.setup.database-connection.user"),disabled:e.processing,modelValue:e.user,"onUpdate:modelValue":t[2]||(t[2]=t=>e.user=t)},null,8,["label","disabled","modelValue"]),(0,i.bF)(u,{name:"password",type:"password",label:e.$t("ui.setup.database-connection.password"),disabled:e.processing,modelValue:e.password,"onUpdate:modelValue":t[3]||(t[3]=t=>e.password=t)},null,8,["label","disabled","modelValue"]),(0,i.bF)(u,{name:"server",label:e.$t("ui.setup.database-connection.server"),disabled:e.processing,required:"",modelValue:e.server,"onUpdate:modelValue":t[4]||(t[4]=t=>e.server=t)},null,8,["label","disabled","modelValue"]),(0,i.bF)(u,{name:"database",label:e.$t("ui.setup.database-connection.database"),disabled:e.processing,required:"",modelValue:e.database,"onUpdate:modelValue":t[5]||(t[5]=t=>e.database=t)},null,8,["label","disabled","modelValue"])]),(0,i.Lk)("div",gs,[(0,i.bF)(c,{submit:"",color:"primary",icon:"save",loading:e.processing,disabled:!e.valid},{default:(0,i.k6)((()=>[(0,i.eW)((0,a.v_)(e.$t("ui.setup.database-connection.save")),1)])),_:1},8,["loading","disabled"]),"edit"===e.currentState?((0,i.uX)(),(0,i.CE)("button",{key:0,type:"button",class:"widget-button",disabled:e.processing,onClick:t[6]||(t[6]=function(){return r.load&&r.load(...arguments)})},(0,a.v_)(e.$t("ui.setup.cancel")),9,fs)):(0,i.Q3)("",!0)])],32)])):((0,i.uX)(),(0,i.CE)("main",ys,[(0,i.Lk)("div",ws,[(0,i.Lk)("h2",Ls,(0,a.v_)(e.$t("ui.setup.database-connection.formTitle")),1),e.url?((0,i.uX)(),(0,i.Wv)(l,{key:0,tag:"p",keypath:"ui.setup.database-connection.connected",class:"setup__fielddesc"},{database:(0,i.k6)((()=>[(0,i.Lk)("i",null,(0,a.v_)(e.database),1)])),server:(0,i.k6)((()=>[(0,i.Lk)("i",null,(0,a.v_)(e.server),1)])),_:1})):(0,i.Q3)("",!0),(0,i.Lk)("button",{type:"button",class:"widget-button widget-button--edit widget-button--small",onClick:t[8]||(t[8]=t=>e.currentState="edit")},(0,a.v_)(e.$t("ui.setup.database-connection.change")),1)]),(0,i.bF)(X.eB,{name:"animate-flip",type:"transition",mode:"out-in"},{default:(0,i.k6)((()=>[!e.hasDatabaseError&&e.backupRestore&&e.hasBackups?e.backupRestored?((0,i.uX)(),(0,i.CE)("div",As,[(0,i.Lk)("div",Vs,[(0,i.Lk)("h2",Us,(0,a.v_)(e.$t("ui.setup.database-connection.restoreTitle")),1),t[18]||(t[18]=(0,i.Lk)("svg",{class:"setup__check",xmlns:"http://www.w3.org/2000/svg",width:"24",height:"24",viewBox:"0 0 24 24"},[(0,i.Lk)("path",{d:"M12,2A10,10 0 0,1 22,12A10,10 0 0,1 12,22A10,10 0 0,1 2,12A10,10 0 0,1 12,2M12,4A8,8 0 0,0 4,12A8,8 0 0,0 12,20A8,8 0 0,0 20,12A8,8 0 0,0 12,4M11,16.5L6.5,12L7.91,10.59L11,13.67L16.59,8.09L18,9.5L11,16.5Z"})],-1)),(0,i.Lk)("p",xs,(0,a.v_)(e.$t("ui.setup.database-connection.restored")),1)]),(0,i.Lk)("div",Ds,[(0,i.Lk)("button",{type:"button",class:"widget-button widget-button--primary",onClick:t[12]||(t[12]=t=>e.$store.commit("contao/backup/setRestore",!1))},(0,a.v_)(e.$t("ui.setup.continue")),1)])])):((0,i.uX)(),(0,i.CE)("div",Ss,[(0,i.Lk)("div",Ps,[(0,i.Lk)("h2",Ws,(0,a.v_)(e.$t("ui.setup.database-connection.restoreTitle")),1),(0,i.Lk)("p",Ts,(0,a.v_)(e.$tc("ui.setup.database-connection.restoreText",e.files.length)),1),e.files.length>1?((0,i.uX)(),(0,i.Wv)(d,{key:0,required:"","allow-html":"",options:r.fileOptions,name:"selection",modelValue:e.selection,"onUpdate:modelValue":t[13]||(t[13]=t=>e.selection=t)},null,8,["options","modelValue"])):(0,i.Q3)("",!0),(0,i.Lk)("p",Is,(0,a.v_)(e.$t("ui.setup.database-connection.backupWarning")),1)]),(0,i.Lk)("div",qs,[(0,i.Lk)("button",{type:"button",class:"widget-button widget-button--inline",onClick:t[14]||(t[14]=t=>e.$store.commit("contao/backup/setRestore",!1))},(0,a.v_)(e.$t("ui.setup.database-connection.skip")),1),(0,i.Lk)("button",{type:"button",class:"widget-button widget-button--inline widget-button--primary",disabled:e.files.length>1&&!e.selection,onClick:t[15]||(t[15]=function(){return r.restore&&r.restore(...arguments)})},(0,a.v_)(e.$t("ui.setup.database-connection.restore")),9,Rs)])])):((0,i.uX)(),(0,i.CE)("div",$s,[(0,i.Lk)("div",Cs,[(0,i.Lk)("h2",Es,(0,a.v_)(e.$t("ui.setup.database-connection.schemaTitle")),1),e.status&&e.status.total>0?((0,i.uX)(),(0,i.CE)("p",Xs,(0,a.v_)(e.$tc(`ui.setup.database-connection.${e.currentState}`,e.status.total)),1)):((0,i.uX)(),(0,i.CE)("p",Fs,(0,a.v_)(e.$t("ui.setup.database-connection.noChanges")),1))]),(0,i.Lk)("div",js,[e.status&&e.status.total>0?((0,i.uX)(),(0,i.CE)(i.FK,{key:0},[e.hasDatabaseError?(0,i.Q3)("",!0):((0,i.uX)(),(0,i.CE)("button",{key:0,type:"button",class:"widget-button widget-button--inline",onClick:t[9]||(t[9]=t=>e.$emit("continue"))},(0,a.v_)(e.$t("ui.setup.database-connection.skip")),1)),(0,i.Lk)("button",{type:"button",class:"widget-button widget-button--inline widget-button--primary",onClick:t[10]||(t[10]=function(){return r.checkMigrations&&r.checkMigrations(...arguments)})},(0,a.v_)(e.$t("ui.setup.database-connection.check")),1)],64)):((0,i.uX)(),(0,i.CE)("button",{key:1,type:"button",class:"widget-button widget-button--primary",onClick:t[11]||(t[11]=t=>e.$emit("continue"))},(0,a.v_)(e.$t("ui.setup.continue")),1))])]))])),_:1})]))])),_:1})):(0,i.Q3)("",!0)])}var Bs=s(4210),Os=s(4960),Hs={components:{RadioButton:je,TextField:fe.A,LoadingButton:Ve.A},data:()=>({processing:!1,validUrl:!0,valid:!1,validating:!1,currentState:null,url:"",user:"",password:"",server:"localhost",database:"",backup:!0,selection:null}),computed:{...(0,C.aH)("tasks",{taskStatus:"status"}),...(0,C.aH)("contao/backup",{backupRestored:"restored",backupRestore:"restore"}),...(0,C.aH)("server/database",{currentUrl:"url",urlPattern:"pattern",status:"status"}),...(0,C.aH)("contao/backup",["files"]),...(0,C.L8)("server/database",{hasDatabaseError:"hasError"}),...(0,C.L8)("contao/backup",["hasBackups"]),fileOptions(){return this.files.map((e=>({value:e.name,label:this.$t("ui.setup.database-connection.restoreOption",{date:(0,Bs.A)(e.createdAt),size:(0,Os.A)(e.size)})})))}},methods:{datimFormat(e){return(0,Bs.A)(e,"short","long")},checkMigrations(){this.$store.commit("checkMigrations")},parseUrl(){if(!this.validateUrl())return;this.validating=!0;const e=new RegExp(this.urlPattern,"i").exec(this.url);this.user=e[3]?decodeURIComponent(e[3]):"",this.password=e[5]?decodeURIComponent(e[5]):"",this.server=decodeURIComponent(e[6]),this.database=decodeURIComponent(e[8]),":3306"===this.server.substring(this.server.length-5)?this.server=this.server.substring(0,this.server.length-5):this.server.includes(":")||(this.server=`${this.server}:3306`),this.valid=this.validateUrl(),this.validating=!1},updateUrl(){if(this.validating)return;if(this.valid=!1,!this.server)return;const e=this.server.split(":",2),t=`${encodeURIComponent(e[0])}:${e[1]||"3306"}`;let s="mysql://";this.user&&(s+=encodeURIComponent(this.user),this.password&&(s+=":"+encodeURIComponent(this.password)),s+="@"),s+=t,this.database&&(s+="/"+encodeURIComponent(this.database)),this.url=s,this.valid=this.validateUrl()},validateUrl(){return this.validUrl=!0,this.valid=!1,""!==this.url&&(this.validUrl=new RegExp(this.urlPattern,"i").test(this.url),this.validUrl)},async load(){this.url=(await this.$store.dispatch("server/database/get")).data.url,this.currentState=this.status?.type,this.parseUrl(),"error"===this.currentState&&(this.validUrl=!1,this.valid=!1)},async save(){this.processing=!0;const e=await this.$store.dispatch("server/database/set",this.url);if("error"===e.data.status.type)return this.processing=!1,this.validUrl=!1,void(this.valid=!1);await this.$store.dispatch("server/adminUser/get",!1),this.processing=!1},async restore(){await this.$store.dispatch("tasks/execute",{name:"contao/backup-restore",config:{file:this.files.length>1?this.selection:this.files[0].name,backup:!1}}),"complete"===this.taskStatus&&(this.$store.commit("contao/backup/setRestored"),await this.$store.dispatch("tasks/deleteCurrent"))}},watch:{user(){this.updateUrl()},password(){this.updateUrl()},server(){this.updateUrl()},database(){this.updateUrl()},status(){this.currentState=this.status?.type}},mounted(){this.load(),this.selection=null,this.backup=!0}};const Qs=(0,Xe.A)(Hs,[["render",Ms]]);var Ks=Qs,Js=s.p+"img/user.129e863d.svg";const Ns={class:"setup__header"},zs={class:"setup__headline"},Zs={class:"setup__description"},Ys={key:0,class:"setup__form"},Gs={class:"setup__fields"},ei={class:"setup__warning"},ti={class:"setup__form setup__form--center",key:"confirmation"},si={class:"setup__fields"},ii={class:"setup__fielddesc"},ai={class:"setup__actions setup__actions--center"},oi={class:"setup__form",key:"setup"},ni={class:"setup__fields"},ri={class:"setup__fieldtitle"},li={class:"setup__fielddesc"},ui={class:"setup__actions setup__actions--center"};function ci(e,t,s,o,n,r){const l=(0,i.g2)("console-output"),u=(0,i.g2)("text-field"),c=(0,i.g2)("loading-button");return(0,i.uX)(),(0,i.CE)("section",null,[(0,i.Lk)("header",Ns,[t[8]||(t[8]=(0,i.Lk)("img",{src:Js,width:"80",height:"80",class:"setup__icon",alt:""},null,-1)),(0,i.Lk)("h1",zs,(0,a.v_)(e.$t("ui.setup.backend-user.headline")),1),(0,i.Lk)("p",Zs,(0,a.v_)(e.$t("ui.setup.backend-user.description")),1)]),null===e.hasUser?((0,i.uX)(),(0,i.CE)("main",Ys,[(0,i.Lk)("div",Gs,[(0,i.Lk)("p",ei,(0,a.v_)(e.$t("ui.setup.backend-user.error")),1),502===e.response.status?((0,i.uX)(),(0,i.Wv)(l,{key:0,class:"view-recovery__console",title:e.$t("ui.recovery.console"),operations:[{status:"error",summary:"vendor/bin/contao-console contao:user:list",console:e.response.data.detail}],"console-output":e.response.data.detail,"show-console":"","force-console":""},null,8,["title","operations","console-output"])):(0,i.Q3)("",!0)])])):((0,i.uX)(),(0,i.Wv)(X.eB,{key:1,name:"animate-flip",type:"transition",mode:"out-in"},{default:(0,i.k6)((()=>[e.hasUser?((0,i.uX)(),(0,i.CE)("main",ti,[(0,i.Lk)("div",si,[t[9]||(t[9]=(0,i.Lk)("svg",{class:"setup__check",xmlns:"http://www.w3.org/2000/svg",width:"24",height:"24",viewBox:"0 0 24 24"},[(0,i.Lk)("path",{d:"M12,2A10,10 0 0,1 22,12A10,10 0 0,1 12,22A10,10 0 0,1 2,12A10,10 0 0,1 12,2M12,4A8,8 0 0,0 4,12A8,8 0 0,0 12,20A8,8 0 0,0 20,12A8,8 0 0,0 12,4M11,16.5L6.5,12L7.91,10.59L11,13.67L16.59,8.09L18,9.5L11,16.5Z"})],-1)),(0,i.Lk)("p",ii,(0,a.v_)(e.$t("ui.setup.backend-user.success")),1)]),(0,i.Lk)("div",ai,[(0,i.Lk)("button",{type:"button",class:"widget-button widget-button--inline widget-button--primary",onClick:t[0]||(t[0]=t=>e.$emit("continue"))},(0,a.v_)(e.$t("ui.setup.continue")),1)])])):((0,i.uX)(),(0,i.CE)("main",oi,[(0,i.Lk)("form",{onSubmit:t[7]||(t[7]=(0,X.D$)((function(){return r.save&&r.save(...arguments)}),["prevent"]))},[(0,i.Lk)("div",ni,[(0,i.Lk)("h2",ri,(0,a.v_)(e.$t("ui.setup.backend-user.formTitle")),1),(0,i.Lk)("p",li,(0,a.v_)(e.$t("ui.setup.backend-user.formText")),1),(0,i.bF)(u,{ref:"username",name:"username",label:e.$t("ui.setup.backend-user.username"),disabled:e.processing,required:"",validate:"",modelValue:e.username,"onUpdate:modelValue":t[1]||(t[1]=t=>e.username=t)},null,8,["label","disabled","modelValue"]),(0,i.bF)(u,{ref:"name",name:"name",label:e.$t("ui.setup.backend-user.name"),disabled:e.processing,required:"",validate:"",modelValue:e.name,"onUpdate:modelValue":t[2]||(t[2]=t=>e.name=t)},null,8,["label","disabled","modelValue"]),(0,i.bF)(u,{ref:"email",name:"email",type:"email",label:e.$t("ui.setup.backend-user.email"),disabled:e.processing,required:"",validate:"",error:e.errors.email,onFocus:t[3]||(t[3]=t=>e.errors.email=""),onBlur:r.validateEmail,modelValue:e.email,"onUpdate:modelValue":t[4]||(t[4]=t=>e.email=t)},null,8,["label","disabled","error","onBlur","modelValue"]),(0,i.bF)(u,{ref:"password",name:"password",type:"password",label:e.$t("ui.setup.backend-user.password"),placeholder:e.$t("ui.setup.backend-user.passwordPlaceholder"),disabled:e.processing,required:"",minlength:"8",validate:"",error:e.errors.password,onFocus:t[5]||(t[5]=t=>e.errors.password=""),onBlur:r.validatePassword,modelValue:e.password,"onUpdate:modelValue":t[6]||(t[6]=t=>e.password=t)},null,8,["label","placeholder","disabled","error","onBlur","modelValue"])]),(0,i.Lk)("div",ui,[(0,i.bF)(c,{submit:"",color:"primary",loading:e.processing,disabled:!e.valid},{default:(0,i.k6)((()=>[(0,i.eW)((0,a.v_)(e.$t("ui.setup.backend-user.create")),1)])),_:1},8,["loading","disabled"])])],32)]))])),_:1}))])}var di=s(7308),pi={components:{TextField:fe.A,LoadingButton:Ve.A,ConsoleOutput:di.A},data:()=>({processing:!1,valid:!1,username:"",name:"",email:"",password:"",errors:{email:"",password:""}}),computed:{...(0,C.aH)("server/adminUser",{hasUser:"hasUser",response:"cache"})},methods:{validate(){this.valid=this.$refs.username.checkValidity()&&this.$refs.name.checkValidity()&&this.$refs.email.checkValidity()&&this.$refs.password.checkValidity()},validateEmail(){this.errors.email=null,""!==this.email&&(this.$refs.email.checkValidity()||(this.errors.email=this.$t("ui.setup.backend-user.emailInvalid")))},validatePassword(){this.errors.password=null,""!==this.password&&this.password.length<8&&(this.errors.password=this.$t("ui.setup.backend-user.passwordLength"))},async save(){this.processing=!0,await this.$store.dispatch("server/adminUser/set",{username:this.username,name:this.name,email:this.email,password:this.password}),this.processing=!1,this.$store.commit("setup",5)}},watch:{username(){this.validate()},name(){this.validate()},email(){this.validate()},password(){this.validate()}}};const hi=(0,Xe.A)(pi,[["render",ci]]);var mi=hi,_i={components:{BoxedLayout:E.A,DocumentRoot:De,CreateProject:us,DatabaseConnection:Ks,BackendUser:mi},computed:{...(0,C.aH)(["setupStep"]),...(0,C.aH)("server/contao",["contaoVersion"]),...(0,C.aH)("server/database",{databaseSupported:"supported"}),...(0,C.aH)("server/adminUser",{userSupported:"supported"}),...(0,C.aH)("contao/install-tool",{showInstallTool:"isSupported"}),currentStep:{get(){return this.setupStep},set(e){this.$store.commit("setup",e)}},steps(){const e=[];return e.push({name:"document-root",icon:F,component:De}),e.push({name:"create-project",icon:Se,component:us}),this.databaseSupported&&e.push({name:"database-connection",icon:cs,component:Ks}),this.userSupported&&e.push({name:"backend-user",icon:Js,component:mi}),e}},methods:{launch(){this.$store.commit("setView",$.A.READY)}},mounted(){this.$store.dispatch("server/adminUser/get"),this.$store.dispatch("contao/backup/fetch")}};const vi=(0,Xe.A)(_i,[["render",L]]);var ki=vi},9472:function(e,t,s){e.exports=s.p+"img/database.7f0a8c49.svg"}}]);"use strict";(self["webpackChunkcontao_manager"]=self["webpackChunkcontao_manager"]||[]).push([[669],{9669:function(e){e.exports=JSON.parse('{"ui.app.title":"افزونه‌های کنتائو","ui.app.loading":"بارگذاری لیست افزونه...","ui.app.language":"Switch language for the Contao Manager","ui.app.colorDark":"Dark Mode","ui.app.colorDarkTitle":"Switch color scheme to dark","ui.app.colorLight":"Light Mode","ui.app.colorLightTitle":"Switch color scheme to light","ui.discover.advertisement":"Advertisement in the extension list","ui.discover.loading":"بارگذاری ...","ui.discover.offline":"Could not fetch any results.","ui.discover.offlineExplain":"Check your internet connection and disable JavaScript blockers in your browser.","ui.discover.offlineButton":"دوباره تلاش کنید","ui.discover.searchPlaceholder":"Search in {count} extensions …","ui.discover.empty":"هیچ نتیجه‌ای برای {query}","ui.discover.more":"نتایج بیشتر","ui.discover.sortBy":"مرتب‌سازی براساس","ui.discover.sortReleased":"Released","ui.discover.sortReleasedTitle":"Sort results by release date","ui.discover.sortLatest":"بروزرسانی شده","ui.discover.sortLatestTitle":"Sort results by last updated","ui.discover.sortDownloads":"دانلودها","ui.discover.sortDownloadsTitle":"Sort results by number of downloads","ui.discover.sortFavers":"امتیاز","ui.discover.sortFaversTitle":"Sort results by rating","ui.discover.detailsButton":"جزئیات","ui.discover.latestPackages":"Latest and updated extensions","ui.discover.faversPackages":"افزونه‌های با امتیاز بالا","ui.discover.downloadsPackages":"Most downloaded extensions","ui.package.homepage":"وب‌سایت پروژه","ui.package.private":"بسته اختصاصی","ui.package.privateTitle":"Private packages are only available from the vendor (e.g. as a ZIP download). Please visit the website for more information.","ui.package.abandoned":"منع شده","ui.package.abandonedText":"This package is abandoned and no longer maintained.","ui.package.abandonedReplace":"This package is abandoned and no longer maintained. The author suggests using the {replacement} package instead.","ui.package.contaoVersion":"Available for Contao","ui.package-details.previous":"جزئیات افزونه قبلی","ui.package-details.close":"بستن جزئیات افزونه","ui.package-details.loading":"بارگذاری ...","ui.package-details.tabDescription":"توضیح","ui.package-details.tabRequire":"نیازمندی‌ها","ui.package-details.tabFeatures":"ویژگی‌ها","ui.package-details.tabSuggest":"پیشنهادها","ui.package-details.tabConflict":"ناسازگاری‌ها","ui.package-details.tabDependents":"وابسته‌ها","ui.package-details.linkRequires":"نیاز دارد","ui.package-details.linkReplaces":"جایگزین می‌کند","ui.package-details.linkProvides":"فراهم می‌کند","ui.package-details.linkConflicts":"ناسازگار است","ui.package-details.funding":"Fund package maintenance!","ui.package-details.contaoVersions":"Supported Contao version(s)","ui.package-details.latest":"آخرین نسخه","ui.package-details.released":"منتشر شده در","ui.package-details.license":"مجوز(ها)","ui.package-details.authors":"از","ui.package-details.more":"بیشتر","ui.package-details.packagist":"جژئیات بسته","ui.package-details.metadata":"ویرایش فرداده","ui.package-details.support_docs":"مستندات","ui.package-details.support_wiki":"ویکی","ui.package-details.support_forum":"انجمن پشتیبانی","ui.package-details.support_issues":"مشکلات / گزارش باگ","ui.package-details.support_source":"کد منبع","ui.package-details.support_irc":"IRC / چت","ui.package-details.support_email":"ایمیل پشتیبانی","ui.package-details.support_rss":"خوراک RSS"}')}}]);"use strict";(self["webpackChunkcontao_manager"]=self["webpackChunkcontao_manager"]||[]).push([[60],{60:function(e,t,r){function n(e){const t=new Uint8Array(e);let r="";for(const o of t)r+=String.fromCharCode(o);const n=btoa(r);return n.replace(/\+/g,"-").replace(/\//g,"_").replace(/=/g,"")}function o(e){const t=e.replace(/-/g,"+").replace(/_/g,"/"),r=(4-t.length%4)%4,n=t.padEnd(t.length+r,"="),o=atob(n),i=new ArrayBuffer(o.length),a=new Uint8Array(i);for(let s=0;s<o.length;s++)a[s]=o.charCodeAt(s);return i}function i(){return a.stubThis(void 0!==globalThis?.PublicKeyCredential&&"function"===typeof globalThis.PublicKeyCredential)}r.d(t,{zZ:function(){return i},ZF:function(){return w},HS:function(){return m},Ct:function(){return R}});const a={stubThis:e=>e};function s(e){const{id:t}=e;return{...e,id:o(t),transports:e.transports}}function c(e){return"localhost"===e||/^([a-z0-9]+(-[a-z0-9]+)*\.)+[a-z]{2,}$/i.test(e)}class l extends Error{constructor({message:e,code:t,cause:r,name:n}){super(e,{cause:r}),Object.defineProperty(this,"code",{enumerable:!0,configurable:!0,writable:!0,value:void 0}),this.name=n??r.name,this.code=t}}function u({error:e,options:t}){const{publicKey:r}=t;if(!r)throw Error("options was missing required publicKey property");if("AbortError"===e.name){if(t.signal instanceof AbortSignal)return new l({message:"Registration ceremony was sent an abort signal",code:"ERROR_CEREMONY_ABORTED",cause:e})}else if("ConstraintError"===e.name){if(!0===r.authenticatorSelection?.requireResidentKey)return new l({message:"Discoverable credentials were required but no available authenticator supported it",code:"ERROR_AUTHENTICATOR_MISSING_DISCOVERABLE_CREDENTIAL_SUPPORT",cause:e});if("conditional"===t.mediation&&"required"===r.authenticatorSelection?.userVerification)return new l({message:"User verification was required during automatic registration but it could not be performed",code:"ERROR_AUTO_REGISTER_USER_VERIFICATION_FAILURE",cause:e});if("required"===r.authenticatorSelection?.userVerification)return new l({message:"User verification was required but no available authenticator supported it",code:"ERROR_AUTHENTICATOR_MISSING_USER_VERIFICATION_SUPPORT",cause:e})}else{if("InvalidStateError"===e.name)return new l({message:"The authenticator was previously registered",code:"ERROR_AUTHENTICATOR_PREVIOUSLY_REGISTERED",cause:e});if("NotAllowedError"===e.name)return new l({message:e.message,code:"ERROR_PASSTHROUGH_SEE_CAUSE_PROPERTY",cause:e});if("NotSupportedError"===e.name){const t=r.pubKeyCredParams.filter((e=>"public-key"===e.type));return 0===t.length?new l({message:'No entry in pubKeyCredParams was of type "public-key"',code:"ERROR_MALFORMED_PUBKEYCREDPARAMS",cause:e}):new l({message:"No available authenticator supported any of the specified pubKeyCredParams algorithms",code:"ERROR_AUTHENTICATOR_NO_SUPPORTED_PUBKEYCREDPARAMS_ALG",cause:e})}if("SecurityError"===e.name){const t=globalThis.location.hostname;if(!c(t))return new l({message:`${globalThis.location.hostname} is an invalid domain`,code:"ERROR_INVALID_DOMAIN",cause:e});if(r.rp.id!==t)return new l({message:`The RP ID "${r.rp.id}" is invalid for this domain`,code:"ERROR_INVALID_RP_ID",cause:e})}else if("TypeError"===e.name){if(r.user.id.byteLength<1||r.user.id.byteLength>64)return new l({message:"User ID was not between 1 and 64 characters",code:"ERROR_INVALID_USER_ID_LENGTH",cause:e})}else if("UnknownError"===e.name)return new l({message:"The authenticator was unable to process the specified options, or could not create a new credential",code:"ERROR_AUTHENTICATOR_GENERAL_ERROR",cause:e})}return e}class d{constructor(){Object.defineProperty(this,"controller",{enumerable:!0,configurable:!0,writable:!0,value:void 0})}createNewAbortSignal(){if(this.controller){const e=new Error("Cancelling existing WebAuthn API call for new one");e.name="AbortError",this.controller.abort(e)}const e=new AbortController;return this.controller=e,e.signal}cancelCeremony(){if(this.controller){const e=new Error("Manually cancelling existing WebAuthn API call");e.name="AbortError",this.controller.abort(e),this.controller=void 0}}}const h=new d,p=["cross-platform","platform"];function f(e){if(e&&!(p.indexOf(e)<0))return e}async function R(e){!e.optionsJSON&&e.challenge&&(console.warn("startRegistration() was not called correctly. It will try to continue with the provided options, but this call should be refactored to use the expected call structure instead. See https://simplewebauthn.dev/docs/packages/browser#typeerror-cannot-read-properties-of-undefined-reading-challenge for more information."),e={optionsJSON:e});const{optionsJSON:t,useAutoRegister:r=!1}=e;if(!i())throw new Error("WebAuthn is not supported in this browser");const a={...t,challenge:o(t.challenge),user:{...t.user,id:o(t.user.id)},excludeCredentials:t.excludeCredentials?.map(s)},c={};let l;r&&(c.mediation="conditional"),c.publicKey=a,c.signal=h.createNewAbortSignal();try{l=await navigator.credentials.create(c)}catch(y){throw u({error:y,options:c})}if(!l)throw new Error("Registration was not completed");const{id:d,rawId:p,response:R,type:w}=l;let b,E,m,A;if("function"===typeof R.getTransports&&(b=R.getTransports()),"function"===typeof R.getPublicKeyAlgorithm)try{E=R.getPublicKeyAlgorithm()}catch(_){g("getPublicKeyAlgorithm()",_)}if("function"===typeof R.getPublicKey)try{const e=R.getPublicKey();null!==e&&(m=n(e))}catch(_){g("getPublicKey()",_)}if("function"===typeof R.getAuthenticatorData)try{A=n(R.getAuthenticatorData())}catch(_){g("getAuthenticatorData()",_)}return{id:d,rawId:n(p),response:{attestationObject:n(R.attestationObject),clientDataJSON:n(R.clientDataJSON),transports:b,publicKeyAlgorithm:E,publicKey:m,authenticatorData:A},type:w,clientExtensionResults:l.getClientExtensionResults(),authenticatorAttachment:f(l.authenticatorAttachment)}}function g(e,t){console.warn(`The browser extension that intercepted this WebAuthn API call incorrectly implemented ${e}. You should report this error to them.\n`,t)}function w(){if(!i())return b.stubThis(new Promise((e=>e(!1))));const e=globalThis.PublicKeyCredential;return void 0===e?.isConditionalMediationAvailable?b.stubThis(new Promise((e=>e(!1)))):b.stubThis(e.isConditionalMediationAvailable())}const b={stubThis:e=>e};function E({error:e,options:t}){const{publicKey:r}=t;if(!r)throw Error("options was missing required publicKey property");if("AbortError"===e.name){if(t.signal instanceof AbortSignal)return new l({message:"Authentication ceremony was sent an abort signal",code:"ERROR_CEREMONY_ABORTED",cause:e})}else{if("NotAllowedError"===e.name)return new l({message:e.message,code:"ERROR_PASSTHROUGH_SEE_CAUSE_PROPERTY",cause:e});if("SecurityError"===e.name){const t=globalThis.location.hostname;if(!c(t))return new l({message:`${globalThis.location.hostname} is an invalid domain`,code:"ERROR_INVALID_DOMAIN",cause:e});if(r.rpId!==t)return new l({message:`The RP ID "${r.rpId}" is invalid for this domain`,code:"ERROR_INVALID_RP_ID",cause:e})}else if("UnknownError"===e.name)return new l({message:"The authenticator was unable to process the specified options, or could not create a new assertion signature",code:"ERROR_AUTHENTICATOR_GENERAL_ERROR",cause:e})}return e}async function m(e){!e.optionsJSON&&e.challenge&&(console.warn("startAuthentication() was not called correctly. It will try to continue with the provided options, but this call should be refactored to use the expected call structure instead. See https://simplewebauthn.dev/docs/packages/browser#typeerror-cannot-read-properties-of-undefined-reading-challenge for more information."),e={optionsJSON:e});const{optionsJSON:t,useBrowserAutofill:r=!1,verifyBrowserAutofillInput:a=!0}=e;if(!i())throw new Error("WebAuthn is not supported in this browser");let c;0!==t.allowCredentials?.length&&(c=t.allowCredentials?.map(s));const l={...t,challenge:o(t.challenge),allowCredentials:c},u={};if(r){if(!await w())throw Error("Browser does not support WebAuthn autofill");const e=document.querySelectorAll("input[autocomplete$='webauthn']");if(e.length<1&&a)throw Error('No <input> with "webauthn" as the only or last value in its `autocomplete` attribute was detected');u.mediation="conditional",l.allowCredentials=[]}let d;u.publicKey=l,u.signal=h.createNewAbortSignal();try{d=await navigator.credentials.get(u)}catch(A){throw E({error:A,options:u})}if(!d)throw new Error("Authentication was not completed");const{id:p,rawId:R,response:g,type:b}=d;let m;return g.userHandle&&(m=n(g.userHandle)),{id:p,rawId:n(R),response:{authenticatorData:n(g.authenticatorData),clientDataJSON:n(g.clientDataJSON),signature:n(g.signature),userHandle:m},type:b,clientExtensionResults:d.getClientExtensionResults(),authenticatorAttachment:f(d.authenticatorAttachment)}}}}]);"use strict";(self["webpackChunkcontao_manager"]=self["webpackChunkcontao_manager"]||[]).push([[638],{3638:function(e){e.exports=JSON.parse('{"ui.app.httpsHeadline":"!! Niebezpieczne połączenie !!","ui.app.httpsDescription":"Bez HTTPS twoje poufne dane będą wysyłane bez szyfrowania.","ui.app.httpsLink":"Więcej informacji","ui.app.httpsHref":"https://https.cio.gov/everything/","ui.app.safeModeHeadline":"!! Bezpieczny Tryb włączony !!","ui.app.safeModeDescription":"Niektóre funkcje Contao Manager nie są dostępne.","ui.app.safeModeExit":"Wyłącz Bezpieczny Tryb","ui.app.limitedHeadline":"Zdalne Poświadczenie","ui.app.limitedDescription":"You have limited permissions due to passwordless login.","ui.app.limitedLogout":"Re-authenticate","ui.app.totpHeadline":"Security Notice","ui.app.totpDescription":"Configure two-factor authentication now to secure your account.","ui.app.totpSetup":"Instalacja","ui.app.loading":"Ładowanie Contao Manager …","ui.app.apiError":"Nieoczekiwany status API","ui.app.configSecurity1":"ALERT BEZPIECZEŃSTWA !!! Wykryto niezabezpieczony folder konfiguracji","ui.app.configSecurity2":"Contao Manager wykrył, że pliki konfiguracji są dostępne publicznie. Wszystkie operacje zostały zablokowane do czasu, aż folder zostanie zabezpieczony. W przeciwnym wypadku atakujący mógłby uzyskać dostęp do wrażliwych danych twojej instalacji.\\n\\nAby naprawić ten problem, zabezpiecz dostęp do katalogu \\"contao-manager\\" na serwerze. Jeśli nie wiesz jak to zrobić, odwołaj się dokumentacji twojego serwera lub skontaktuj z dostawcą usług.","ui.account.welcome":"Witaj","ui.account.intro1":"Witaj w Contao Manager, uniwersalnym narzędziu do instalacji i zarządzania Contao Open Source CMS. Jeśli jesteś tu nowy, proszę {readTheManualToGetStarted}.","ui.account.introGetStarted":"{readTheManual}, żeby zacząć","ui.account.introManual":"przeczytaj instrukcję","ui.account.intro2":"Jeśli masz jakiekolwiek problemy, sprawdź {ourGithubIssues} i utwórz nowe zgłoszenie na dowolny temat, który nie był jeszcze raportowany.","ui.account.introIssues":"naszą listę problemów na GitHub","ui.account.headline":"Konto użytkownika","ui.account.description":"Aby zarządzać twoją instalacją, utwórz konto w Contao Manager. Uwaga – to konto nie jest powiązane z kontem w backendzie ani frontendzie Contao!","ui.account.username":"Nazwa użytkownika","ui.account.password":"Hasło","ui.account.passwordPlaceholder":"min 8 znaków","ui.account.passwordLength":"Wprowadź przynajmniej 8 znaków.","ui.account.loginInvalid":"There was an error when creating the account. Please try a different username.","ui.account.submit":"Utwórz konto","ui.account.usePassword":"Use password for login","ui.account.usePasskey":"Use Passkey for login","ui.account.totpHeadline":"Two-factor authentication","ui.account.totpDescription":"Please enable two-factor authentication, which adds an extra layer of security to your account. In addition to your username and password, you will need to enter a verification code generated by a two-factor app such as 1Password, Authy, Google Authenticator, Microsoft Authenticator, LastPass Authenticator or any other TOTP app.","ui.account.totpSetup":"Configure now","ui.account.totpSkip":"Configure later","ui.account.login":"Decline Invitation","ui.account.contribute1":"Contao i Contao Manager są sponsorowane przez charytatywną organizację Contao Association.","ui.account.contribute2":"Rozważ uczestnictwo w projektach open source poprzez {donate}.","ui.account.contributeDonate":"przekazanie darowizny","ui.login.headline":"Zaloguj się","ui.login.description":"Zaloguj się, aby zarządzać instalacją.","ui.login.username":"Nazwa użytkownika","ui.login.password":"Hasło","ui.login.totpHeadline":"Two-factor authentication","ui.login.totpDescription":"Please enter your verification code to complete the login process.","ui.login.totp":"Verification code","ui.login.forgotPassword":"Zapomniałeś hasła?","ui.login.button":"Zaloguj się","ui.login.passkey":"Sign In with Passkey","ui.login.cancel":"Anuluj","ui.login.or":"lub","ui.login.locked":"Odmówiono dostępu, ponieważ Contao Manager jest zablokowany. Aby odblokować, usuń plik {lockFile} w folderze głównym instalacji Contao.","ui.logout.headline":"Limit czasu sesji","ui.logout.warning":"Byłeś nieaktywny przez więcej niż 25 minut. Z powodu bezpieczeństwa twoja sesja zostanie wkrótce zakończona.","ui.logout.expired":"Twoja sesja została zakończona, ponieważ byłeś nieaktywny przez więcej niż 30 minut.","ui.logout.renew":"Nie wylogowuj się","ui.logout.logout":"Wyloguj","ui.logout.login":"Powrót do logowania","ui.oauth.error":"Nieudana próba OAuth. Sprawdź parametry żądania.","ui.oauth.https":"URI przekierowania MUSI używać bezpiecznego protokołu (https:), aby nie przesyłać tokena poświadczenia otwartym tekstem.","ui.oauth.headline":"Zdalne Poświadczenie","ui.oauth.description":"Następująca aplikacja lub usługa żąda zdalnego dostępu do twojej instancji Contao Manager.","ui.oauth.domain":"Zanim zezwolisz na dostęp, upewnij się, że znasz ten adres URL i ufasz jego właścicielowi!","ui.oauth.outOfScope":"Unfortunately, you do not have the necessary permissions to grant this access.","ui.oauth.allow":"Zezwól na dostęp","ui.oauth.deny":"Odmów dostępu","ui.oauth.switchUser":"Switch User","ui.scope.admin":"Admin access including user management","ui.scope.install":"Install new packages and change Contao configuration","ui.scope.update":"Update packages and execute maintenance tasks","ui.scope.read":"Read packages and configuration","ui.boot.headline":"Sprawdzenie Systemu","ui.boot.description":"Proszę czekać, analizujemy twój serwer …","ui.boot.issue1":"Wykryto nieprawidłowości instalacji","ui.boot.issue2":"Twoja instalacja zawiera błędy, które muszą być rozwiązane, zanim zaczniesz używać Contao Manager.","ui.boot.run":"Otwórz Contao Manager","ui.boot.safeMode":"Uruchom w Bezpiecznym Trybie","ui.recovery.headline":"Odzyskiwanie Systemu","ui.recovery.description":"Contao Manager wykrył pliki, które wyglądają jak z Contao, ale interfejs linii komend (CLI) nie działa tak jak powinien.","ui.recovery.console":"Wyjście Konsolie","ui.recovery.repairOptions":"Wybierz opcję naprawy twojej instalacji.","ui.recovery.repairHeadline":"Automatyczna Naprawa","ui.recovery.repairDescription":"Próba automatycznego naprawienia instalacji poprzez przebudowanie pamięci cache aplikacji i ponownej instalacji pakietów Composera.","ui.recovery.repairWarning":"Jakakolwiek modyfikacja plików vendor może zostać skasowana podczas tego procesu!","ui.recovery.repairFailed":"Automatyczna naprawa nie zakończyła się sukcesem. Spróbuj Bezpiecznego Trybu w celu naprawy instalacji.","ui.recovery.repairButton":"Uruchom naprawę systemu","ui.recovery.safeModeHeadline":"Bezpieczny Tryb","ui.recovery.safeModeDescription":"Uruchamianie Contao Managera w Bezpiecznym Trybie pozwala na zarządzanie pakietami i wykonywanie określonych czynności konserwacyjnych, ale funkcje, które wymagają działającego Contao będą niedostępne.","ui.recovery.safeModeButton":"Uruchom w Bezpiecznym Trybie","ui.server.pending":"Czekam …","ui.server.running":"Analizuję …","ui.server.error":"Sprawdzenie nie powiodło się z powodu niespodziewanej odpowiedzi serwera.","ui.server.details":"Szczegóły","ui.server.prerequisite":"Sprawdzenie anulowane z powodu brakującego warunku wstępnego.","ui.server.selfUpdate.title":"Aktualizacje Contao Managera","ui.server.selfUpdate.update":"Nowa wersja Contao Managera {latest} jest dostępna.","ui.server.selfUpdate.manualUpdate":"Nowa wersja Contao Managera {latest} jest dostępna. Twój serwer nie wspiera automatycznych aktualizacji, nową wersję możesz pobrać z {download}.","ui.server.selfUpdate.latest":"Używasz najnowszej wersji {current}.","ui.server.selfUpdate.dev":"Buildy deweloperskie nie wspierają automatycznych aktualizacji.","ui.server.selfUpdate.unsupported":"Nowa wersja jest dostępna, ale nie wspiera ona twojej wersji PHP.","ui.server.selfUpdate.button":"Uruchom Aktualizację","ui.server.selfUpdate.continue":"Kontynuuj","ui.server.config.title":"Konfiguracja Serwera","ui.server.config.setup":"Konfiguruj","ui.server.config.change":"Zmień","ui.server.config.save":"Zapisz","ui.server.config.cancel":"Anuluj","ui.server.config.customOption":"Inne …","ui.server.config.description":"Aby zadania w tle poprawnie działały, Contao Manager musi wiedzieć, gdzie znaleźć wykonywalny plik PHP linii komend i jak uruchamiać działania niezależnie od procesów serwera www.","ui.server.config.formTitle":"Konfiguracja Serwera","ui.server.config.formText":"Wprowadź ścieżkę do PHP binary. Upewnij się, że wersja PHP binary jest taka sama jak w procesie web.","ui.server.config.cloudTitle":"Composer Resolver Cloud","ui.server.config.cloudText":"Composer Resolver Cloud pozwala na instalowanie pakietów Composera nawet jeśli twój serwer nie posiada wystarczającej ilości pamięci. Informacja o twoich pakietach będzie przesłana na serwer operowany przez Contao Association.","ui.server.config.cloud":"Użyj Composer Resolver Cloud","ui.server.config.cli":"Plik binarny PHP","ui.server.config.stateErrorCli":"Nie znaleziono poprawnego pliku binarnego PHP na serwerze.","ui.server.config.stateErrorCloud":"Composer Resolver Cloud jest niewspierany.","ui.server.config.stateSuccess":"Plik binarny PHP pod {php_cli}.","ui.server.php_web.title":"PHP Web Process","ui.server.php_web.below7":"Znaleziono wersję PHP {version}. Zaktualizuj ją do PHP 7 tak szybko, jak to możliwe!","ui.server.php_web.success":"Znaleziono wersję PHP {version}, brak nieprawidłowości.","ui.server.php_cli.title":"PHP Command Line Interface","ui.server.php_cli.success":"Znaleziono wersję PHP {version}, brak nieprawidłowości.","ui.server.composer.title":"Środowisko Composera","ui.server.composer.success":"Brak nieprawidłowości.","ui.server.composer.install":"Pakiety Composera nie są zainstalowane.","ui.server.composer.button":"Instalacja","ui.server.contao.title":"Instalacja Contao","ui.server.contao.setup":"Instalacja","ui.server.contao.check":"Sprawdź bazę danych","ui.server.contao.empty":"Nie znaleziono instalacji Contao.","ui.server.contao.old":"Wersja Contao {version} jest niekompatybilna z Contao Manager, aktualizuj swoją instalację ręcznie.","ui.server.contao.found":"Znaleziono Contao {version} (wersja API {api}).","ui.server.contao.connectionError":"Brak połączenia z serwerem bazy danych.","ui.server.contao.connectionProblem":"Problem z bazą danych został znaleziony.","ui.server.contao.missingUser":"Nie znaleziono konta administratora.","ui.setup.continue":"Kontynuuj","ui.setup.manager":"Otwórz Contao Manager","ui.setup.cancel":"Anuluj","ui.setup.welcome":"Witaj","ui.setup.welcome1":"Ten kreator przeprowadzi Cię przez niezbędne kroki, aby skonfigurować instalację Contao Open Source CMS.","ui.setup.welcome2":"Jeśli masz jakieś pytania, odwiedź dokumentację, fora, kanał Slack i więcej na stronie {support}.","ui.setup.support":"wsparcie społeczności","ui.setup.start":"Rozpocznij","ui.setup.complete":"Gratulacje!","ui.setup.complete1":"Contao {version} zostało zainstalowane pomyślnie.","ui.setup.complete2":"Aby zakończyć proces konfiguracji, otwórz narzędzie instalacyjne, aby skonfigurować połączenie z bazą danych i utworzyć użytkownika.","ui.setup.complete3":"Możesz teraz rozpocząć tworzenie swojej strony internetowej w Contao. Jeśli potrzebujesz dodatkowych rozszerzeń, przejdź dalej do Contao Manager.","ui.setup.installTool":"Otwórz instalator","ui.setup.login":"Zaloguj się do Contao","ui.setup.funding":"Free software is \\"free\\" as in \\"free speech\\", not as in \\"free beer\\". An Open Source project like Contao requires amounts of money that can\'t be raised by a single person or company.\\nIf you have a website or sell websites built with Contao, we would love to see you contribute back financially to the product your business relies upon.","ui.setup.fundingLink":"Dowiedz się więcej","ui.setup.document-root.headline":"Konfiguracja serwera www","ui.setup.document-root.warning":"Aby zainstalować Contao przez Contao Manager, musisz poprawić ustawienie katalogu głównego - document root - w konfiguracji serwera www.","ui.setup.document-root.description1":"Contao używa osobnego folderu dla plików publicznych, a pliki aplikacji są instalowane w folderze nadrzędnym. Contao nie może być zainstalowany, jeśli struktura folderów nie jest poprawna lub foldery nie są puste.","ui.setup.document-root.description2":"Jeśli wiesz, jak skonfigurować katalog główny - document root, zapoznaj się z dokumentacją Contao lub skontaktuj się z administratorem serwera.","ui.setup.document-root.documentation":"Przeczytaj Dokumentację","ui.setup.document-root.conflictsTitle":"Katalog instalacyjny nie jest pusty","ui.setup.document-root.conflictsDirectory":"Katalog główny Twojej przyszłej instalacji Contao nie jest pusty, znaleźliśmy {count} plik(i), które mogą zostać nadpisane przez proces instalacji. Zaleca się utworzenie pustej struktury katalogów dla Contao, ale możesz również usunąć następujące pliki i sprawdzić ponownie, jeśli jesteś pewien, że są one nieużywane.","ui.setup.document-root.ignoreConflicts":"Chcę zainstalować Contao w katalogu, który nie jest pusty. Rozumiem, że może to spowodować nadpisanie wszelkich istniejących plików na mojej przestrzeni dyskowej.","ui.setup.document-root.check":"Sprawdź ponownie","ui.setup.document-root.create":"Utwórz katalogi","ui.setup.document-root.change":"Zmień katalogi","ui.setup.document-root.formTitle":"Konfiguracja Katalogu","ui.setup.document-root.formText1":"Contao Manager może automatycznie utworzyć nową strukturę katalogów na serwerze.","ui.setup.document-root.formText2":"Będziesz musiał ręcznie skonfigurować nowy katalog główny - document root (np. przez panel administracyjny serwera).","ui.setup.document-root.autoconfig":"Rozumiem, że muszę zmienić konfigurację mojego serwera. Niepoprawne ustawienie katalogu głównego może uniemożliwić działanie Contao Manager i uwidocznić publicznie pliki konfiguracyjne (włącznie ze szczegółami konta i hasłami)!","ui.setup.document-root.directory":"Nowy Katalog","ui.setup.document-root.currentRoot":"Aktualny Katalog Główny","ui.setup.document-root.newRoot":"Nowy Katalog Główny","ui.setup.document-root.finish":"Ustawienia Katalogów","ui.setup.document-root.publicDir":"Użyj {dir} dla plików publicznych (dla Contao {version})","ui.setup.document-root.directoryInvalid":"Wprowadź prawidłową nazwę katalogu.","ui.setup.document-root.directoryExists":"Docelowy katalog już istnieje. Podaj inną nazwę.","ui.setup.document-root.confirmation":"Contao Manager utworzył potrzebne katalogi dla twojej instalacji Contao. Teraz powinieneś skonfigurować główny katalog serwera www - document root. Nie przeładowuj wcześniej tej strony.","ui.setup.document-root.reload":"Przeładuj Stronę","ui.setup.document-root.success":"Struktura katalogów na Twoim serwerze jest ustawiona prawidłowo!","ui.setup.document-root.installingProjectDir":"Pliki aplikacji zostaną zainstalowane w {dir}.","ui.setup.document-root.installingPublicDir":"Pliki publiczne zostaną zainstalowane do {dir}.","ui.setup.document-root.installedProjectDir":"Pliki aplikacji są zainstalowane w {dir}.","ui.setup.document-root.installedPublicDir":"Pliki publiczne są instalowane w {dir}.","ui.setup.create-project.headline":"Instalacja Contao","ui.setup.create-project.description":"Rozwój Contao odbywa się zgodnie z zasadą {semver}, co pół roku wydawana jest nowa wersja minor. Obecnie wspierane wydania to:","ui.setup.create-project.semver":"Wersjonowanie semantyczne","ui.setup.create-project.latestTitle":"Najnowsza","ui.setup.create-project.ltsTitle":"Long Term Support","ui.setup.create-project.latestQ1":"Nasza najnowsza wersja, oferuje najwięcej funkcji ze wsparciem do lutego {year}.","ui.setup.create-project.latestQ3":"Nasza najnowsza wersja oferuje najwięcej funkcji z wsparciem do sierpnia {year}.","ui.setup.create-project.ltsText":"Nasza aktualna wersja LTS, jeśli stawiasz na stabilność. Oferuje długoterminowe wsparcie do lutego {year}.","ui.setup.create-project.pltsText":"Poprzednia wersja LTS, nadal posiada długoterminowe wsparcie do lutego {year}.","ui.setup.create-project.requiresPHP":"Wymaga co najmniej PHP {version}, ty masz PHP {current}.","ui.setup.create-project.releaseplan":"Zobacz {contaoReleasePlan}, aby uzyskać szczegółowe informacje.","ui.setup.create-project.releaseplanLink":"Plan Rozwoju Contao","ui.setup.create-project.installed":"Contao {version} zostało pomyślnie zainstalowane na serwerze. Kontynuuj konfigurację bazy danych lub uruchom Contao Manager, aby zainstalować inną wersję.","ui.setup.create-project.formTitle":"Wybierz dystrybucję","ui.setup.create-project.formText":"Wybierz, która wersja ma być zainstalowana.","ui.setup.create-project.version":"Wersja","ui.setup.create-project.demo":"Zainstaluj witrynę demonstracyjną Contao","ui.setup.create-project.demoDescription":"Strona demonstracyjna pomaga Ci zapoznać się z Contao i wszystkimi jego podstawowymi funkcjami. Więcej motywów można znaleźć w {store}.","ui.setup.create-project.coreOnly":"Minimalna Instalacja (tylko Core)","ui.setup.create-project.noUpdate":"Pomiń Instalację (tylko dla ekspertów!)","ui.setup.create-project.theme":"Motyw Contao","ui.setup.create-project.themeInstall":"Aby zainstalować motyw Contao, użyj pola wyszukiwania lub załaduj plik motywu (.cto/.zip), który obsługuje instalację za pośrednictwem menedżera Contao.","ui.setup.create-project.themeBuy":"Upewnij się, że odwiedzisz oficjalny {sklep}.","ui.setup.create-project.themeStore":"Sklep z motywami Contao","ui.setup.create-project.themeUpload":"Prześlij plik motywu (.cto/.zip)","ui.setup.create-project.themeInvalid":"Przesłany plik nie jest motywem Contao lub nie obsługuje Contao Managera.","ui.setup.create-project.themeWarning":"Contao Manager nie może stwierdzić, czy ten motyw jest kompatybilny z Twoim serwerem. Prosimy skontaktować się z dostawcą motywu, jeśli masz jakiekolwiek pytania.","ui.setup.create-project.themeTitle":"Przejrzyj szczegóły motywu","ui.setup.create-project.themeDetails":"Następujące zależności i pliki zostaną zainstalowane wraz z tym motywem.","ui.setup.create-project.themeRequire":"{count} Zależności | {count} Zależności","ui.setup.create-project.themeFiles":"{count} Plik | {count} Pliki","ui.setup.create-project.theme.or":"lub wyszukaj publiczne motywy","ui.setup.create-project.theme.search":"Wyszukiwanie motywów","ui.setup.create-project.theme.more":"Więcej motywów","ui.setup.create-project.theme.empty":"Brak motywów pasujących do {query}","ui.setup.create-project.theme.uploaded":"Plik motywu został pomyślnie przesłany.","ui.setup.create-project.theme.packageName":"Nazwa pakietu","ui.setup.create-project.theme.version":"Wersja","ui.setup.create-project.theme.authors":"Autor(zy)","ui.setup.create-project.install":"Instalacja","ui.setup.create-project.cancel":"Anuluj","ui.setup.database-connection.headline":"Połączenie z bazą danych","ui.setup.database-connection.description":"Contao wymaga bazy danych MySQL (lub kompatybilnego forka jak MariaDB) do przechowywania stron, treści, użytkowników i innych danych relacyjnych. Parametry połączenia są przechowywane w pliku {env} w katalogu głównym twojej instalacji Contao.","ui.setup.database-connection.formTitle":"Parametry połączenia","ui.setup.database-connection.formText":"Podaj adres URL bazy danych lub wypełnij osobno pola nazwa użytkownika, hasło, serwer i baza danych.","ui.setup.database-connection.url":"URL bazy danych","ui.setup.database-connection.validUrl":"URL bazy danych jest nieprawidłowy lub połączenie z serwerem nie powiodło się.","ui.setup.database-connection.or":"lub","ui.setup.database-connection.user":"Nazwa użytkownika","ui.setup.database-connection.password":"Hasło","ui.setup.database-connection.server":"Serwer (:Port)","ui.setup.database-connection.database":"Nazwa bazy danych","ui.setup.database-connection.connected":"Pomyślnie połączono z bazą danych {database} na {server}.","ui.setup.database-connection.error":"Błąd połączenia z bazą danych.","ui.setup.database-connection.problem":"Contao wykrył problem z serwerem bazy danych.","ui.setup.database-connection.schemaTitle":"Schemat bazy danych","ui.setup.database-connection.migration":"Jest jedna oczekująca migracja. | Jest {count} oczekujących migracji.","ui.setup.database-connection.schema":"Istnieje jedna oczekująca aktualizacja schematu. | Istnieje {count} oczekujących aktualizacji schematu.","ui.setup.database-connection.noChanges":"Schemat Twojej bazy danych jest aktualny.","ui.setup.database-connection.check":"Sprawdź bazę danych","ui.setup.database-connection.skip":"Pomiń","ui.setup.database-connection.save":"Zapisz","ui.setup.database-connection.change":"Zmień dane dostępowe","ui.setup.database-connection.restoreTitle":"Import bazy danych","ui.setup.database-connection.restoreText":"Temat, który właśnie zainstalowałeś, zawiera kopię zapasową bazy danych. Przywróć bazę danych, aby zaimportować dane motywu, lub pomini ten krok, aby rozpocząć instalację Contao od nowa. | Temat, który właśnie zainstalowałeś, zawiera wiele kopii zapasowych bazy danych. Wybierz plik kopii zapasowej do zaimportowania danych motywu lub pomiń ten krok, aby rozpocząć instalację Contao od nowa.","ui.setup.database-connection.backup":"Zrób kopię zapasową bieżącej bazy danych przed importem","ui.setup.database-connection.backupWarning":"Wszystkie dane w bazie danych zostaną nadpisane podczas importu! Jeśli baza danych nie jest pusta, utwórz najpierw kopię zapasową.","ui.setup.database-connection.restore":"Importuj bazę danych motywu","ui.setup.database-connection.restoreOption":"Kopia zapasowa z {date} ({size})","ui.setup.database-connection.restored":"Twoja baza danych motywu została pomyślnie zaimportowana. Kontynuuj walidację schematu bazy danych.","ui.setup.backend-user.success":"W Twojej bazie danych znaleziono konto administratora Contao. Użyj Contao, aby dodać więcej użytkowników.","ui.setup.backend-user.error":"Nie można pobrać listy użytkowników. Sprawdź wynik konsoli w celu uzyskania szczegółów.","ui.setup.backend-user.headline":"Konto użytkownika","ui.setup.backend-user.description":"Aby zarządzać swoją stroną internetową, musisz mieć co najmniej jedno konto administratora w Contao. Należy pamiętać, że to konto nie jest powiązane z Contao Manager.","ui.setup.backend-user.formTitle":"Utwórz konto","ui.setup.backend-user.formText":"Proszę wprowadzić dane dla nowego konta backend.","ui.setup.backend-user.username":"Nazwa użytkownika","ui.setup.backend-user.name":"Nazwa","ui.setup.backend-user.email":"Adres e-mail","ui.setup.backend-user.emailInvalid":"Wprowadź prawidłowy adres e-mail","ui.setup.backend-user.password":"Hasło","ui.setup.backend-user.passwordPlaceholder":"min 8 znaków","ui.setup.backend-user.passwordLength":"Wprowadź przynajmniej 8 znaków.","ui.setup.backend-user.create":"Dodaj konto","ui.task.headline":"Zadanie w Tle","ui.task.loading":"Ładowanie szczegółów ...","ui.task.created":"Ładowanie szczegółów ...","ui.task.active":"Czekaj, dopóki trwa wykonywanie zadań w tle przez Contao Manager.","ui.task.complete":"Wszystkie operacje wykonane poprawnie. Sprawdź szczegóły w treści konsoli.","ui.task.aborting":"Czekaj, dopóki trwa anulowanie operacji w tle.","ui.task.stopped":"Niektóre operacje w tle zostały anulowane. Zobacz szczegóły w konsoli.","ui.task.error":"Operacja w tle niespodziewanie przestała pracować. Sprawdź szczegóły w konsoli.","ui.task.failed":"Contao Manager nie mógł uruchomić zadania w tle!","ui.task.failedDescription1":"Coś poszło źle podczas próby wykonania operacji w tle.","ui.task.failedDescription2":"Jeśli sytuacja się powtórzy, być może twój serwer nie ma wsparcia.","ui.task.reportProblem":"Zgłoś problem","ui.task.sponsor":"Composer Cloud sponsorowane przez {sponsor}","ui.task.buttonAudit":"Aktualizacja Bazy Danych","ui.task.buttonClose":"Zamknij","ui.task.buttonConfirm":"Potwierdź i zamknij","ui.task.buttonCancel":"Anuluj","ui.task.confirmCancel":"Czy na pewno chcesz anulować to zadanie? To może pozostawić twoją instalację w nieznanym stanie.","ui.task.autoclose":"Zamknij szczegóły zadania, gdy udane","ui.console.toggle":"Pokaż/Ukryj Konsolę","ui.console.showLog":"Pokaż pełny dziennik konsoli","ui.console.copyLog":"Skopiuj dziennik do schowka","ui.migrate.headline":"Aktualizacje bazy danych","ui.migrate.migrationsOnly":"(tylko migracje)","ui.migrate.schemaOnly":"(tylko struktura)","ui.migrate.loading":"Proszę czekać, sprawdzamy twoją bazę danych …","ui.migrate.empty":"Nie znaleziono żadnych oczekujących migracji ani aktualizacji schematów. Twoja baza danych jest aktualna.","ui.migrate.emptyMigrations":"Nie znaleziono żadnych oczekujących migracji. Upewnij się, że sprawdziłeś również aktualizacje schematu.","ui.migrate.emptySchema":"Nie znaleziono oczekujących aktualizacji schematu. Upewnij się, że sprawdzisz również migracje.","ui.migrate.pending":"Twoja baza danych nie jest aktualna. Proszę przejrzyj poniższe wyjście konsoli i wykonaj zmiany.","ui.migrate.previousChanges":"Poprzednia migracja bazy danych nie została potwierdzona.\\nProszę przejrzeć poniższe wyniki konsoli, a następnie kontynuować, aby zobaczyć kolejne zmiany.","ui.migrate.previousComplete":"Poprzednia migracja bazy danych nie została potwierdzona, proszę sprawdzić poniższe wyniki konsoli.\\nNie ma więcej oczekujących zmian.","ui.migrate.appliedChanges":"Aktualizacje bazy danych zostały zastosowane.\\nProszę przejrzeć poniższe wyjście konsoli, a następnie kontynuować, aby zobaczyć kolejne zmiany.","ui.migrate.appliedComplete":"Baza danych została zaktualizowana.\\nNie ma więcej oczekujących migracji ani aktualizacji schematu. Twoja baza danych jest aktualna.","ui.migrate.problem":"Contao wykrył problem z serwerem bazy danych.\\nProszę przejrzyj poniżej wynik konsoli, aby dowiedzieć się, co należy naprawić. | Contao wykrył problemy z serwerem bazy danych.\\nProszę przejrzyj poniżej wynik konsoli, aby dowiedzieć się, co należy naprawić.","ui.migrate.warning":"Contao wykrył błędną konfigurację serwera bazy danych.\\nOstrzeżenia można tymczasowo pominąć, ale należy je naprawić dla optymalnej wydajności i integralności danych.","ui.migrate.error":"Zmiany nie mogły zostać zastosowane. Twoja baza danych mogła zostać zmieniona, sprawdź ponownie, aby ponowić próbę.","ui.migrate.execute":"Wykonaj","ui.migrate.close":"Zamknij","ui.migrate.confirm":"Potwierdź i zamknij","ui.migrate.cancel":"Anuluj","ui.migrate.continue":"Kontynuuj","ui.migrate.setup":"Instalacja","ui.migrate.skip":"Pomiń","ui.migrate.retry":"Sprawdź ponownie","ui.migrate.retryAll":"Sprawdź wszystkie","ui.migrate.withDeletes":"Wykonaj wszystkie zmiany w bazie danych, włączając zapytania DROP.","ui.migrate.migrationTitle":"Migracje baz danych","ui.migrate.schemaTitle":"Aktualizacje schematu","ui.migrate.problemTitle":"Problemy z bazą danych","ui.migrate.warningTitle":"Ostrzeżenia bazy danych","ui.migrate.addTable":"Dodaj tabelę {table}","ui.migrate.dropTable":"Usuń tabelę {table}","ui.migrate.addField":"Dodaj pole {table}.{field}","ui.migrate.changeField":"Zmień pole {table}.{field}","ui.migrate.dropField":"Usuń pole {table}.{field}","ui.migrate.createIndex":"Utwórz indeks \\"{name}\\" w {table}","ui.migrate.dropIndex":"Usuń indeks \\"{name}\\" w {table}","ui.widget.mandatory":"To pole nie może być puste.","ui.widget.blankOption":"Proszę wybrać …","ui.widget.showPassword":"Pokaż hasło","ui.widget.hidePassword":"Ukryj hasło","ui.error.title":"Żądanie HTTP dla \\"{method}{url}\\" nie powiodło się.","ui.error.server500":"Wygląda na to, że wystąpił nieoczekiwany błąd na twoim serwerze. Sprawdź dziennik zdarzeń serwera www (Apache/Nginx) oraz dziennik Contao Manager w \\"contao-manager/logs\\".","ui.error.response":"Serwer zwrócił odpowiedź z kodem {status}.","ui.error.moreLink":"Więcej informacji","ui.error.support":"Wsparcie Contao","ui.error.permission":"You do not have permission to use this feature.","ui.footer.help":"Pomoc","ui.footer.reportProblem":"Zgłoś problem","ui.navigation.discover":"Odkrywaj","ui.navigation.packages":"Pakiety","ui.navigation.tools":"Narzędzia","ui.navigation.installTool":"Instalator","ui.navigation.backend":"Contao Backend","ui.navigation.debug":"Contao Tryb Debug","ui.navigation.logViewer":"Czytnik logów","ui.navigation.phpinfo":"Informacja PHP","ui.navigation.phpinfoLoading":"Ładowanie informacji PHP…","ui.navigation.maintenance":"Konserwacja","ui.navigation.rebuildCache":"Przebuduj cache","ui.navigation.users":"Accounts","ui.navigation.systemCheck":"Sprawdzenie Systemu","ui.navigation.advanced":"Zaawansowane","ui.navigation.logout":"Wyloguj","ui.maintenance.database.title":"Bazy danych Migracje i Kopie Zapasowe","ui.maintenance.database.description":"Migracje baz danych zapewniają spójność danych i schematów tabel.","ui.maintenance.database.migrations":"Jedna oczekująca migracja bazy danych | {count} oczekujących migracji bazy danych","ui.maintenance.database.schemaUpdates":"Jedna oczekująca aktualizacja schematu | {count} oczekujące aktualizacje schematu","ui.maintenance.database.error":"Problem z bazą danych został znaleziony.","ui.maintenance.database.warning":"Wykryto ostrzeżenia w bazie danych.","ui.maintenance.database.button":"Sprawdź bazę danych","ui.maintenance.database.migrationOnly":"Sprawdź tylko migracje","ui.maintenance.database.schemaOnly":"Sprawdź tylko strukturę","ui.maintenance.database.installTool":"Otwórz instalator","ui.maintenance.database.createBackup":"Utwórz kopię zapasową","ui.maintenance.database.backupUnsupported":"Kopie zapasowe bazy danych nie są obsługiwane przez Twoją wersję Contao.","ui.maintenance.database.backupList":"Masz jedno kopię zapasową bazy danych, utworzoną {date}. | Masz {count} kopii zapasowych bazy danych, najnowsza została utworzona {date}.","ui.maintenance.database.backupEmpty":"Nie masz obecnie żadnych kopii zapasowych bazy danych.","ui.maintenance.rebuildCache.title":"Cache Aplikacji","ui.maintenance.rebuildCache.description":"Przebudowanie cache\'u aplikacji jest wymagane po jakichkolwiek modyfikacjach plików konfiguracyjnych.","ui.maintenance.rebuildCache.rebuildProd":"Przebuduj Cache Production","ui.maintenance.rebuildCache.rebuildDev":"Przebuduj Cache Development","ui.maintenance.rebuildCache.clearProd":"Wyczyść Cache Production","ui.maintenance.rebuildCache.clearDev":"Wyczyść Cache Development","ui.maintenance.installTool.title":"Instalator Contao","ui.maintenance.installTool.description":"Instalator Contao jest automatycznie blokowany jeśli wprowadzisz błędne hasło trzy razy z rzędu.","ui.maintenance.installTool.unlock":"Odblokuj instalator","ui.maintenance.installTool.lock":"Zablokuj instalator","ui.maintenance.dumpAutoload.title":"Composer Class Loader","ui.maintenance.dumpAutoload.description":"Autoloader Composera jest odpowiedzialny za ładowanie klas PHP. Autoloader musi być odświeżony po dodaniu własnych namespace\'ów do pliku composer.json.","ui.maintenance.dumpAutoload.button":"Odśwież Autoloader","ui.maintenance.composerInstall.title":"Pakiety Composera","ui.maintenance.composerInstall.description":"Zależności Composer\'a są umieszczone w folderze {vendor} w głównym katalogu aplikacji. Przeinstalowanie zależności może być konieczne po zmianach lub ręcznym wgraniu pliku {composerLock}.","ui.maintenance.composerInstall.button":"Uruchom Instalator","ui.maintenance.composerInstall.update":"Uruchom Composer Update","ui.maintenance.composerCache.title":"Cache Composera","ui.maintenance.composerCache.description":"Composer cache\'uje pobrane pakiety w celu lepszej wydajności. Jeśli masz problemy z zepsutymi plikami, spróbuj usunąć cache Composera, aby wymusić nowe pobranie plików.","ui.maintenance.composerCache.button":"Wyczyść Cache","ui.maintenance.maintenanceMode.title":"Tryb konserwacji","ui.maintenance.maintenanceMode.description":"Przełączenie Contao w tryb konserwacji spowoduje wyświetlenie szablonu \\"503 Service Unavailable\\" dla strony internetowej.","ui.maintenance.maintenanceMode.enable":"Włącz","ui.maintenance.maintenanceMode.disable":"Wyłącz","ui.maintenance.debugMode.title":"Tryb Debug","ui.maintenance.debugMode.description":"Aktywuj tryb diagnostyczny podając nazwę użytkownika i hasło do {appDevPhp} punktu dostępowego.","ui.maintenance.debugMode.descriptionJwt":"Aktywuj tryb debug poprzez ustawienie ciasteczka debug dla obecnej domeny.","ui.maintenance.debugMode.activate":"Aktywuj","ui.maintenance.debugMode.deactivate":"Deaktywuj","ui.maintenance.debugMode.credentials":"Uwierzytelnianie","ui.maintenance.debugMode.user":"Proszę wprowadzić nazwę użytkownika dla trybu debug.","ui.maintenance.debugMode.password":"Proszę wprowadzić hasło dla trybu debug.","ui.maintenance.opcodeCache.title":"Cache Opcode","ui.maintenance.opcodeCache.description":"Opcode cache\'uje pliki PHP procesu web w celu szybszego ich wykonywania. Cache musi zostać usunięty w pewnych okolicznościach, jeśli pliki nie są rozpoznawane po ich zmianie.","ui.maintenance.opcodeCache.button":"Wyczyść Cache","ui.maintenance.safeMode":"Niedostępne w Bezpiecznym Trybie","ui.maintenance.unsupported":"Niewspierane przez twoją wersję Contao","ui.packages.updateButton":"Zaktualizuj pakiety","ui.packages.searchButton":"Szukaj Pakietów","ui.packages.searchPlaceholder":"Szukaj pakietów …","ui.packages.uploadOverlay":"Przeciągnij i upuść pliki","ui.packages.uploadButton":"Wgraj pakiety","ui.packages.uploadMessage":"Masz jedną niepotwierdzoną wysyłkę. | Masz {count} niepotwierdzonych wysyłek.","ui.packages.uploadApply":"Potwierdź pliki","ui.packages.uploadReset":"Usuń pliki","ui.packages.uploadIncomplete":"Ten plik nie został wgrany całkowicie. Usuń go i spróbuj ponownie.","ui.packages.uploadDuplicate":"Ten plik wygląda na wgrany kilka razy. Usuń duplikaty.","ui.packages.uploadInstalled":"Ten plik jest już zainstalowany. Usuń duplikaty.","ui.packages.uploadUnsupported":"Przesyłki nie są obsługiwane w Twojej instalacji. Upewnij się, że rozszerzenie PHP ZIP jest zainstalowane i zaktualizuj swoje zależności.","ui.packages.changesMessage":"Masz jedną niepotwierdzoną zmianę. | Masz {count} niepotwierdzonych zmian.","ui.packages.changesDryrun":"Dry Run","ui.packages.changesApply":"Zapisz zmiany","ui.packages.changesApplyAll":"Zaktualizuj wszystkie pakiety","ui.packages.changesDryrunAll":"Próbnie zaktualizuj wszystkie pakiety","ui.packages.changesReset":"Zresetuj zmiany","ui.packages.changesReview":"Zapisz Zmiany","ui.packagelist.loading":"Ładowanie …","ui.packagelist.uploads":"Wgrane pliki","ui.packagelist.added":"Nowe pakiety","ui.packagelist.installed":"Zainstalowane pakiety","ui.package.hintRevert":"Cofnij zmiany","ui.package.hintNoupdate":"Nie aktualizuj","ui.package.hintConstraint":"Ten pakiet zostanie zainstalowany z wymogiem {constraint} kiedy zapiszesz zmiany.","ui.package.hintConstraintBest":"Ten pakiet zostanie zainstalowany w najlepszej możliwej wersji kiedy zapiszesz zmiany.","ui.package.hintConstraintChange":"Wymóg dla tego pakietu zostanie zmieniony z \\"{from}\\" do \\"{to}\\" kiedy zapiszesz zmiany.","ui.package.hintConstraintUpdate":"Ten pakiet zostanie zaktualizowany, kiedy zapiszesz zmiany.","ui.package.hintAdded":"Ten pakiet zostanie zainstalowana, kiedy zapiszesz zmiany.","ui.package.hintRemoved":"Ten pakiet zostanie usunięty kiedy zapiszesz zmiany.","ui.package.requiredTitle":"dodane ręcznie","ui.package.requiredText":"Ten pakiet jest jako wymagany w pliku composer.json, ale nie jest zainstalowany.","ui.package.removedTitle":"usunięte ręcznie","ui.package.removedText":"Ten pakiet został usunięty z twojego composer.json.","ui.package.installed":"Obecnie zainstalowane:","ui.package.version":"Wersja {version}","ui.package.additionalDownloads":"{count} Pobranie | {count} Pobrania","ui.package.additionalStars":"{count} Gwiazdka | {count} Gwiazdki","ui.package.editConstraint":"Edytuj","ui.package.uploadConstraint":"To ograniczenie zdefiniowane jest przez przesłany pakiet.","ui.package.updateButton":"Aktualizuj","ui.package.removeButton":"Usuń","ui.package.installButton":"Dodaj Pakiet","ui.package.installButtonShort":"Dodaj","ui.package.detailsButton":"Szczegóły","ui.package.latestConstraint":"ostatnia wersja","ui.package.update":"Dostępna aktualizacja","ui.package.updateLatest":"ostatnia wersja","ui.package.updateAvailable":"{version} dostępna","ui.package.updateUnknown":"nieznana wersja","ui.package.updateConstraint":"Dostępna jest nowsza wersja spoza ograniczenia wersji Twojego oprogramowania.","ui.package.incompatible":"{package} does not work with Contao {constraint}.","ui.cloudStatus.headline":"Composer Resolver Cloud","ui.cloudStatus.version":"Wersja {version}","ui.cloudStatus.waitingTime":"Czas Oczekiwania","ui.cloudStatus.jobs":"Aktualne Zadania","ui.cloudStatus.workers":"Workers","ui.cloudStatus.approx":"{minutes} min","ui.cloudStatus.none":"żaden","ui.cloudStatus.short":"ok. {minutes} min","ui.cloudStatus.long":"ok. {minutes} min {seconds} sek","ui.cloudStatus.error":"Nie udało się uzyskać stanu Composer Resolver Cloud. Może być w trakcie serwisowania lub ma awarię.","ui.cloudStatus.button":"Status Chmury","ui.cloudStatus.refresh":"Odśwież Status Chmury","ui.log-viewer.loading":"Ładowanie …","ui.log-viewer.empty":"Nie ma plików dziennika na Twoim serwerze.","ui.log-viewer.reload":"Odśwież","ui.log-viewer.file":"Plik logów","ui.log-viewer.channel":"Kanał","ui.log-viewer.channelTitle":"Kanał, do którego została zapisana ta wiadomość.","ui.log-viewer.level":"Poziom","ui.log-viewer.levelTitle":"Ważność wiadomości log.","ui.log-viewer.timeHeader":"Czas","ui.log-viewer.messageHeader":"Wiadomość","ui.log-viewer.showContext":"Pokaż kontekst","ui.log-viewer.hideContext":"Ukryj kontekst","ui.log-viewer.showExtra":"Pokaż Dodatkowe","ui.log-viewer.hideExtra":"Ukryj Dodatkowe","ui.log-viewer.more":"Wczytaj więcej ...","ui.log-viewer.download":"Pobierz","ui.log-viewer.downloadTitle":"Pobierz plik \\"{file}\\"","ui.log-viewer.prodEnvironment":"Środowisko produkcyjne","ui.log-viewer.devEnvironment":"Środowisko deweloperskie (tryb debugowania)","ui.user-manager.loading":"Loading users …","ui.user-manager.changePassword":"Change Password","ui.user-manager.setupTotp":"Setup Two-Factor Authentication","ui.user-manager.disableTotp":"Disable Two-Factor Authentication","ui.user-manager.invite":"Invite User","ui.user-manager.delete":"Delete","ui.user-manager.deleteConfirm":"Do you really want to delete user \\"{username}\\"?","ui.user-manager.deleted":"User {username} deleted successfully","ui.user-manager.passwordHeadline":"Change Password","ui.user-manager.passwordText":"To change your password, please enter the current and a new password in the respective fields.","ui.user-manager.currentPassword":"Current password","ui.user-manager.newPassword":"New password","ui.user-manager.passwordPlaceholder":"min 8 znaków","ui.user-manager.submitPassword":"Submit","ui.user-manager.passwordChanged":"Your password has been changed successfully.","ui.user-manager.passwordError":"This password is incorrect.","ui.user-manager.inviteHeadline":"Invite User","ui.user-manager.inviteText":"If you need multiple logins for the Contao Manager, you can create an invitation link here. Share this link with someone or use it on another device to create a new account with the given permissions.","ui.user-manager.inviteSuccess1":"A new invitation link was created. The URL below can be used to create a new user account for this Contao Manager. The invitation expires on {expires} (one week from now).","ui.user-manager.inviteSuccess2":"Please copy the link to your clipboard. It will only work once and you will not be able to see it again after closing this dialog.","ui.user-manager.createInvitation":"Create Invitation Link","ui.user-manager.clipboard":"Copy to clipboard","ui.user-manager.permissions":"Learn about permissions","ui.user-manager.cancel":"Anuluj","ui.user-manager.close":"Zamknij","ui.user-manager.you":"You","ui.user-manager.2fa":"2FA","ui.user-manager.2faEnabled":"This account is secured by two-factor authentication.","ui.user-manager.2faDisabled":"This account is insecure due to missing two-factor authentication.","ui.user-manager.passkey":"Passkey","ui.user-manager.passkeyTitle":"This account is secured by a Passkey.","ui.totp.headline":"Two-Factor Authentication","ui.totp.setupQr":"Please scan the QR code with your 2FA/TOTP app.","ui.totp.setupCode":"If you cannot scan the QR code, enter this key instead:","ui.totp.codeLabel":"Verification code","ui.totp.codeDescription":"Please enter the verification code generated by your 2FA/TOTP app.","ui.totp.disableText":"Please enter the verification code to disable two-factor authentication.","ui.totp.invalid":"The verification code is invalid.","ui.totp.enable":"Włącz","ui.totp.disable":"Wyłącz","ui.totp.cancel":"Anuluj","ui.totp.enabled":"Two-factor authentication was enabled successfully.","ui.totp.disabled":"Two-factor authentication was disabled successfully.","ui.totp.setup":"Setup Two-Factor Authentication","ui.totp.skip":"Skip Two-Factor Authentication"}')}}]);"use strict";(self["webpackChunkcontao_manager"]=self["webpackChunkcontao_manager"]||[]).push([[518],{2518:function(e){e.exports=JSON.parse('{"ui.app.title":"Contao Extensies","ui.app.loading":"Extensie Lijst laden …","ui.app.language":"Wijzig de taal voor de Contao Manager","ui.app.colorDark":"Donkere modus","ui.app.colorDarkTitle":"Verander het kleurenschema naar donker","ui.app.colorLight":"Lichte modus","ui.app.colorLightTitle":"Verander het kleurenschema naar licht","ui.discover.advertisement":"Advertentie in de extensielijst","ui.discover.loading":"Bezig met laden ...","ui.discover.offline":"Kon geen resultaten ophalen.","ui.discover.offlineExplain":"Controleer uw internetverbinding en schakel JavaScript blokkers uit in uw browser.","ui.discover.offlineButton":"Probeer opnieuw","ui.discover.searchPlaceholder":"Zoeken in {count} extensies…","ui.discover.empty":"Geen resultaten voor {query}","ui.discover.more":"Meer resultaten","ui.discover.sortBy":"Sorteren op","ui.discover.sortReleased":"Uitgebracht","ui.discover.sortReleasedTitle":"Sorteer de resultaten op releasedatum","ui.discover.sortLatest":"Updated","ui.discover.sortLatestTitle":"Sorteer de resultaten op laatst bijgewerkt","ui.discover.sortDownloads":"Downloads","ui.discover.sortDownloadsTitle":"Sorteer resultaten op aantal downloads","ui.discover.sortFavers":"Beoordeling","ui.discover.sortFaversTitle":"Sorteer de resultaten op beoordeling","ui.discover.detailsButton":"Details","ui.discover.latestPackages":"Nieuwste en bijgewerkte extensies","ui.discover.faversPackages":"Best beoordeelde extensies","ui.discover.downloadsPackages":"Meest gedownloade extensies","ui.package.homepage":"Project Website","ui.package.private":"Privépakket","ui.package.privateTitle":"Privépakketten zijn alleen verkrijgbaar bij de leverancier (bijvoorbeeld als ZIP-download). Bezoek de website voor meer informatie.","ui.package.abandoned":"niet meer ondersteund","ui.package.abandonedText":"Dit pakket wordt niet langer ondersteund en onderhouden.","ui.package.abandonedReplace":"Dit pakket wordt niet langer ondersteund en onderhouden. De auteur stelt voor om in plaats daarvan het {vervangend} pakket te gebruiken.","ui.package.contaoVersion":"Beschikbaar voor Contao","ui.package-details.previous":"Vorige Extensie Details","ui.package-details.close":"Sluit Extensie Details","ui.package-details.loading":"Bezig met laden ...","ui.package-details.tabDescription":"Beschrijving","ui.package-details.tabRequire":"Vereisten","ui.package-details.tabFeatures":"Kenmerken","ui.package-details.tabSuggest":"Suggesties","ui.package-details.tabConflict":"Conflicten","ui.package-details.tabDependents":"Afhankelijkheden","ui.package-details.linkRequires":"vereist","ui.package-details.linkReplaces":"vervangt","ui.package-details.linkProvides":"biedt","ui.package-details.linkConflicts":"conflicten","ui.package-details.funding":"Fund package maintenance!","ui.package-details.contaoVersions":"Ondersteunde Contao versie(s)","ui.package-details.latest":"Laatste versie","ui.package-details.released":"uitgebracht op","ui.package-details.license":"Licentie(s)","ui.package-details.authors":"van","ui.package-details.more":"Meer","ui.package-details.packagist":"Details bundel","ui.package-details.metadata":"Bewerk Metadata","ui.package-details.support_docs":"Documentatie","ui.package-details.support_wiki":"Wiki","ui.package-details.support_forum":"Support Forum","ui.package-details.support_issues":"Problemen / Foutrapport","ui.package-details.support_source":"Broncode","ui.package-details.support_irc":"IRC / Chat","ui.package-details.support_email":"Support E-Mail","ui.package-details.support_rss":"RSS Feed"}')}}]);"use strict";(self["webpackChunkcontao_manager"]=self["webpackChunkcontao_manager"]||[]).push([[661],{7661:function(a,e,t){t.r(e),t.d(e,{default:function(){return Ba}});var s=t(641),n=t(33);const i={class:"package-popup__installed"},l=["dateTime","title"],o=["href"],p={key:3},c={class:"package-popup__update"},r={class:"package-popup__incompatible"};function u(a,e,t,u,d,k){const g=(0,s.g2)("package-constraint"),m=(0,s.g2)("install-button"),h=(0,s.g2)("package-details",!0);return(0,s.uX)(),(0,s.Wv)(h,{local:k.data,dependents:k.dependents},(0,s.eX)({"package-actions":(0,s.k6)((()=>[(0,s.RG)(a.$slots,"package-actions",{},(()=>[a.isInstalled?((0,s.uX)(),(0,s.CE)(s.FK,{key:0},[!a.isFeature&&a.isVisible?((0,s.uX)(),(0,s.Wv)(g,{key:0,data:k.data},null,8,["data"])):(0,s.Q3)("",!0),(0,s.Lk)("p",i,[(0,s.Lk)("strong",null,(0,n.v_)(a.$t("ui.package.installed")),1),a.installedTime?((0,s.uX)(),(0,s.CE)("time",{key:0,dateTime:a.installedTime,title:k.datimFormat(a.installedTime)},(0,n.v_)(a.$t("ui.package.version",{version:a.installedVersion})),9,l)):((0,s.uX)(),(0,s.CE)(s.FK,{key:1},[(0,s.eW)((0,n.v_)(a.$t("ui.package.version",{version:a.installedVersion})),1)],64))])],64)):a.canBeInstalled||a.isRequired?((0,s.uX)(),(0,s.CE)(s.FK,{key:1},[(0,s.bF)(m,{data:k.data},null,8,["data"]),a.isAdded||a.isRequired?((0,s.uX)(),(0,s.Wv)(g,{key:0,data:k.data},null,8,["data"])):(0,s.Q3)("",!0)],64)):a.isPrivate?((0,s.uX)(),(0,s.CE)("a",{key:2,class:"widget-button widget-button--primary widget-button--link",target:"_blank",href:a.metadata.homepage},(0,n.v_)(a.$t("ui.package.homepage")),9,o)):((0,s.uX)(),(0,s.CE)("div",p))]))])),"suggest-actions":(0,s.k6)((e=>{let{name:t}=e;return[a.packageSuggested(t)?((0,s.uX)(),(0,s.Wv)(m,{key:0,inline:"",small:"",data:{name:t}},null,8,["data"])):(0,s.Q3)("",!0)]})),"features-actions":(0,s.k6)((e=>{let{name:t}=e;return[!a.hasRoot||a.packageInstalled(t)||a.packageRoot(t)?(0,s.Q3)("",!0):((0,s.uX)(),(0,s.Wv)(m,{key:0,inline:"",small:"",data:{name:t}},null,8,["data"]))]})),_:2},[a.metadata.update&&a.metadata.update.valid&&!a.metadata.update.latest?{name:"package-update",fn:(0,s.k6)((()=>[(0,s.Lk)("p",c,[(0,s.Lk)("strong",null,(0,n.v_)(a.$t("ui.package.update"))+":",1),(0,s.eW)(" "+(0,n.v_)(a.$t("ui.package.version",{version:a.metadata.update.version}))+" ("+(0,n.v_)(a.$t("ui.package-details.released"))+" "+(0,n.v_)(k.datimFormat(a.metadata.update.time,"short","long"))+")",1)])])),key:"0"}:a.isCompatible?void 0:{name:"package-update",fn:(0,s.k6)((()=>[(0,s.Lk)("p",r,(0,n.v_)(a.$t("ui.package.incompatible",{package:k.data.name,constraint:a.packageConstraint("contao/manager-bundle")})),1)])),key:"1"}]),1032,["local","dependents"])}t(8111),t(7588);var d=t(6278),k=t(4210),g=t(8200);const m={class:"package-popup__headline"},h=["title"],_=["title"],v={key:0,class:"package-popup__loader"},b={class:"package-popup__summary"},f={class:"package-popup__text"},y={class:"package-popup__title"},$={key:0,class:"package-popup__authors"},C=["href"],X={class:"package-popup__statistics"},E=["title"],L={key:1,class:"package-popup__stats package-popup__stats--updated"},w={key:2,class:"package-popup__stats package-popup__stats--downloads"},F={key:3,class:"package-popup__stats package-popup__stats--favers"},A={class:"package-popup__actions"},W=["href"],Q=["href"],T={class:"package-popup__tabs"},x={class:"package-popup__tabs-list"},P={key:0,class:"package-popup__abandoned"},R={key:2},q={key:3},B={key:4},I={class:"package-popup__description"};function G(a,e,t,i,l,o){const p=(0,s.g2)("loading-spinner"),c=(0,s.g2)("package-logo"),r=(0,s.g2)("more-links"),u=(0,s.g2)("details-tab"),d=(0,s.g2)("router-link"),k=(0,s.g2)("i18n-t"),g=(0,s.g2)("package-funding"),G=(0,s.g2)("details-content"),O=(0,s.g2)("popup-overlay");return(0,s.uX)(),(0,s.Wv)(O,{fixed:!0,"popup-class":"package-popup",tabindex:"-1",onClear:e[8]||(e[8]=e=>a.clearCurrent())},{content:(0,s.k6)((()=>[(0,s.Lk)("div",m,[a.hasPrevious?((0,s.uX)(),(0,s.CE)("button",{key:0,class:"package-popup__button package-popup__button--previous",title:a.$t("ui.package-details.previous"),onClick:e[0]||(e[0]=e=>a.$router.go(-1))},e[9]||(e[9]=[(0,s.Lk)("svg",{xmlns:"http://www.w3.org/2000/svg",fill:"#fff",width:"24",height:"24",viewBox:"0 0 24 24"},[(0,s.Lk)("path",{d:"M0 0h24v24H0z",fill:"none"}),(0,s.Lk)("path",{d:"M21 11H6.83l3.58-3.59L9 6l-6 6 6 6 1.41-1.41L6.83 13H21z"})],-1)]),8,h)):(0,s.Q3)("",!0),(0,s.eW)(" "+(0,n.v_)(o.data.name)+" ",1),(0,s.Lk)("button",{class:"package-popup__button package-popup__button--close",title:a.$t("ui.package-details.close"),onClick:e[1]||(e[1]=e=>a.clearCurrent())},e[10]||(e[10]=[(0,s.Lk)("svg",{height:"24",viewBox:"0 0 24 24",width:"24",fill:"#fff",xmlns:"http://www.w3.org/2000/svg"},[(0,s.Lk)("path",{d:"M19 6.41L17.59 5 12 10.59 6.41 5 5 6.41 10.59 12 5 17.59 6.41 19 12 13.41 17.59 19 19 17.59 13.41 12z"}),(0,s.Lk)("path",{d:"M0 0h24v24H0z",fill:"none"})],-1)]),8,_)]),a.metadata&&a.metadata.hasOwnProperty("name")?((0,s.uX)(),(0,s.CE)(s.FK,{key:1},[(0,s.Lk)("div",b,[(0,s.bF)(c,{class:"package-popup__logo","component-class":"package-popup__icon",src:a.metadata.logo},null,8,["src"]),(0,s.Lk)("div",f,[(0,s.Lk)("h1",y,(0,n.v_)(a.metadata.title||o.data.name),1),o.authors?((0,s.uX)(),(0,s.CE)("p",$,[(0,s.eW)((0,n.v_)(a.$t("ui.package-details.authors"))+" ",1),((0,s.uX)(!0),(0,s.CE)(s.FK,null,(0,s.pI)(o.authors,((a,e)=>((0,s.uX)(),(0,s.CE)(s.FK,null,[a.homepage?((0,s.uX)(),(0,s.CE)("a",{class:"package-popup__author",key:e,href:a.homepage,target:"_blank",rel:"noreferrer noopener"},(0,n.v_)(a.name),9,C)):((0,s.uX)(),(0,s.CE)("span",{class:"package-popup__author",key:e},(0,n.v_)(a.name),1))],64)))),256))])):(0,s.Q3)("",!0),(0,s.Lk)("p",X,[a.metadata.private?((0,s.uX)(),(0,s.CE)("span",{key:0,class:"package-popup__stats package-popup__stats--private",title:a.$t("ui.package.privateTitle")},(0,n.v_)(a.$t("ui.package.private")),9,E)):(0,s.Q3)("",!0),a.metadata.updated?((0,s.uX)(),(0,s.CE)("span",L,(0,n.v_)(o.datimFormat(a.metadata.updated,!1)),1)):(0,s.Q3)("",!0),a.metadata.downloads>0?((0,s.uX)(),(0,s.CE)("span",w,(0,n.v_)(o.numberFormat(a.metadata.downloads)),1)):(0,s.Q3)("",!0),a.metadata.favers>0?((0,s.uX)(),(0,s.CE)("span",F,(0,n.v_)(o.numberFormat(a.metadata.favers)),1)):(0,s.Q3)("",!0),(0,s.bF)(r,{name:a.metadata.name,homepage:a.metadata.homepage,support:Object.assign({},a.metadata.support),metadata:a.metadata.metadata,"hide-packagist":a.metadata.private},null,8,["name","homepage","support","metadata","hide-packagist"])])]),(0,s.Lk)("div",A,[(0,s.RG)(a.$slots,"package-actions",(0,n._B)((0,s.Ng)({data:a.metadata})),(()=>[a.metadata&&a.metadata.homepage?((0,s.uX)(),(0,s.CE)("a",{key:0,class:"widget-button widget-button--primary widget-button--link",target:"_blank",href:a.metadata.homepage},(0,n.v_)(a.$t("ui.package.homepage")),9,W)):a.metadata.private?(0,s.Q3)("",!0):((0,s.uX)(),(0,s.CE)("a",{key:1,class:"widget-button widget-button--primary widget-button--link",target:"_blank",href:`https://packagist.org/packages/${o.data.name}`},(0,n.v_)(a.$t("ui.package-details.packagist")),9,Q))]))])]),(0,s.Lk)("div",T,[(0,s.Lk)("ul",x,[(0,s.bF)(u,{"show-empty":"",links:!1,active:""===o.tab,onClick:e[2]||(e[2]=a=>o.setTab(""))},{default:(0,s.k6)((()=>[(0,s.eW)((0,n.v_)(a.$t("ui.package-details.tabDescription")),1)])),_:1},8,["active"]),a.metadata.features?((0,s.uX)(),(0,s.Wv)(u,{key:0,highlight:"",links:a.metadata.features,active:"features"===o.tab,onClick:e[3]||(e[3]=a=>o.setTab("features"))},{default:(0,s.k6)((()=>[(0,s.eW)((0,n.v_)(a.$t("ui.package-details.tabFeatures")),1)])),_:1},8,["links","active"])):(0,s.Q3)("",!0),(0,s.bF)(u,{highlight:"",active:"suggest"===o.tab,links:a.metadata.suggest,onClick:e[4]||(e[4]=a=>o.setTab("suggest"))},{default:(0,s.k6)((()=>[(0,s.eW)((0,n.v_)(a.$t("ui.package-details.tabSuggest")),1)])),_:1},8,["active","links"]),(0,s.bF)(u,{"show-empty":"",active:"require"===o.tab,links:a.metadata.require,onClick:e[5]||(e[5]=a=>o.setTab("require"))},{default:(0,s.k6)((()=>[(0,s.eW)((0,n.v_)(a.$t("ui.package-details.tabRequire")),1)])),_:1},8,["active","links"]),(0,s.bF)(u,{"show-empty":"",active:"conflict"===o.tab,links:a.metadata.conflict,onClick:e[6]||(e[6]=a=>o.setTab("conflict"))},{default:(0,s.k6)((()=>[(0,s.eW)((0,n.v_)(a.$t("ui.package-details.tabConflict")),1)])),_:1},8,["active","links"]),t.dependents?((0,s.uX)(),(0,s.Wv)(u,{key:1,active:"dependents"===o.tab,links:t.dependents,onClick:e[7]||(e[7]=a=>o.setTab("dependents"))},{default:(0,s.k6)((()=>[(0,s.eW)((0,n.v_)(a.$t("ui.package-details.tabDependents")),1)])),_:1},8,["active","links"])):(0,s.Q3)("",!0)])]),(0,s.bF)(G,{active:""===o.tab},{default:(0,s.k6)((()=>[a.metadata.abandoned?((0,s.uX)(),(0,s.CE)("div",P,[!0===a.metadata.abandoned?((0,s.uX)(),(0,s.CE)(s.FK,{key:0},[(0,s.eW)((0,n.v_)(a.$t("ui.package.abandonedText")),1)],64)):((0,s.uX)(),(0,s.Wv)(k,{key:1,keypath:"ui.package.abandonedReplace"},{replacement:(0,s.k6)((()=>[(0,s.bF)(d,{to:{query:{p:a.metadata.abandoned}}},{default:(0,s.k6)((()=>[(0,s.eW)((0,n.v_)(a.metadata.abandoned),1)])),_:1},8,["to"])])),_:1}))])):(0,s.Q3)("",!0),a.metadata.funding?((0,s.uX)(),(0,s.Wv)(g,{key:1,class:"package-popup__funding",items:a.metadata.funding},null,8,["items"])):(0,s.Q3)("",!0),(0,s.RG)(a.$slots,"package-update"),a.metadata.contaoVersions?((0,s.uX)(),(0,s.CE)("p",R,[(0,s.Lk)("strong",null,(0,n.v_)(a.$t("ui.package-details.contaoVersions"))+":",1),(0,s.eW)(" "+(0,n.v_)(a.metadata.contaoVersions.join(", ")),1)])):(0,s.Q3)("",!0),a.metadata.latest?((0,s.uX)(),(0,s.CE)("p",q,[(0,s.Lk)("strong",null,(0,n.v_)(a.$t("ui.package-details.latest"))+":",1),(0,s.eW)(" "+(0,n.v_)(a.metadata.latest.version)+" ("+(0,n.v_)(a.$t("ui.package-details.released"))+" "+(0,n.v_)(o.datimFormat(a.metadata.latest.time,"short","long"))+")",1)])):(0,s.Q3)("",!0),a.metadata.license?((0,s.uX)(),(0,s.CE)("p",B,[(0,s.Lk)("strong",null,(0,n.v_)(a.$t("ui.package-details.license"))+":",1),(0,s.eW)(" "+(0,n.v_)(o.license),1)])):(0,s.Q3)("",!0),(0,s.Lk)("p",I,(0,n.v_)(a.metadata.description),1)])),_:3},8,["active"]),a.metadata.features?((0,s.uX)(),(0,s.Wv)(G,{key:0,active:"features"===o.tab,links:a.metadata.features},{actions:(0,s.k6)((({name:e})=>[(0,s.RG)(a.$slots,"features-actions",(0,n._B)((0,s.Ng)({name:e})))])),_:3},8,["active","links"])):(0,s.Q3)("",!0),(0,s.bF)(G,{active:"suggest"===o.tab,links:a.metadata.suggest},{actions:(0,s.k6)((({name:e})=>[(0,s.RG)(a.$slots,"suggest-actions",(0,n._B)((0,s.Ng)({name:e})))])),_:3},8,["active","links"]),(0,s.bF)(G,{active:"require"===o.tab,links:a.metadata.require},{actions:(0,s.k6)((({name:e})=>[(0,s.RG)(a.$slots,"require-actions",(0,n._B)((0,s.Ng)({name:e})))])),_:3},8,["active","links"]),(0,s.bF)(G,{active:"conflict"===o.tab,links:a.metadata.conflict},{actions:(0,s.k6)((({name:e})=>[(0,s.RG)(a.$slots,"conflict-actions",(0,n._B)((0,s.Ng)({name:e})))])),_:3},8,["active","links"]),t.dependents?((0,s.uX)(),(0,s.Wv)(G,{key:1,active:"dependents"===o.tab,links:t.dependents},{actions:(0,s.k6)((({name:e})=>[(0,s.RG)(a.$slots,"dependents-actions",(0,n._B)((0,s.Ng)({name:e})))])),_:3},8,["active","links"])):(0,s.Q3)("",!0)],64)):((0,s.uX)(),(0,s.CE)("div",v,[(0,s.bF)(p,{horizontal:""}),(0,s.Lk)("p",null,(0,n.v_)(a.$t("ui.package-details.loading")),1)]))])),_:3})}var O=t(9376),S=t(416),j=t(266),K=t(5951),V=t(4999);const D={key:0,class:"link-more"};function H(a,e,t,i,l,o){const p=(0,s.g2)("link-menu");return o.linkItems.length?((0,s.uX)(),(0,s.CE)("div",D,[(0,s.Lk)("button",{onClick:e[0]||(e[0]=(...a)=>o.toggle&&o.toggle(...a))},(0,n.v_)(a.$t("ui.package-details.more")),1),a.visible?((0,s.uX)(),(0,s.CE)("div",{key:0,ref:"menu",class:"link-more__menu",tabindex:"-1",onFocusout:e[1]||(e[1]=(...a)=>o.close&&o.close(...a)),onClick:e[2]||(e[2]=(...a)=>o.close&&o.close(...a))},[(0,s.bF)(p,{items:o.linkItems,color:"contao"},null,8,["items"])],544)):(0,s.Q3)("",!0)])):(0,s.Q3)("",!0)}var M=t(2471),N={components:{LinkMenu:M.A},props:{name:String,homepage:String,support:Object,metadata:String,hidePackagist:Boolean},data:()=>({visible:!1}),computed:{linkItems(){const a=[];return this.homepage&&a.push({label:this.$t("ui.package.homepage"),href:this.homepage,target:"_blank"}),this.name&&!this.hidePackagist&&a.push({label:this.$t("ui.package-details.packagist"),href:`https://packagist.org/packages/${this.name}`,target:"_blank"}),this.support&&Object.keys(this.support).forEach((e=>{const t=`ui.package-details.support_${e}`;let s=this.$t(`ui.package-details.support_${e}`);s===t&&(s=e),"email"===e?a.push({label:s,href:`mailto:${this.support[e]}`}):a.push({label:s,href:this.support[e],target:"_blank"})})),this.metadata&&a.push({label:this.$t("ui.package-details.metadata"),href:this.metadata,target:"_blank"}),a}},methods:{open(){this.visible=!0,setTimeout((()=>this.$refs.menu?.focus()),0)},close(a){a&&this.$refs.menu?.contains(a.relatedTarget)||(this.$refs.menu.blur(),setTimeout((()=>{this.visible=!1}),100))},toggle(){this.visible?this.close():this.open()}}},z=t(6262);const U=(0,z.A)(N,[["render",H]]);var Y=U;const J=["disabled"];function Z(a,e,t,i,l,o){return t.showEmpty||o.count>0?((0,s.uX)(),(0,s.CE)("li",{key:0,class:(0,n.C4)(["package-popup__tab",{"package-popup__tab--active":t.active}])},[(0,s.Lk)("button",{onClick:e[0]||(e[0]=e=>a.$emit("click")),disabled:0===o.count&&!1!==t.links},[(0,s.RG)(a.$slots,"default"),!1!==t.links?((0,s.uX)(),(0,s.CE)("span",{key:0,class:(0,n.C4)({"package-popup__pill":!0,"package-popup__pill--highlight":t.highlight&&o.count>0})},(0,n.v_)(o.count),3)):(0,s.Q3)("",!0)],8,J)],2)):(0,s.Q3)("",!0)}var aa={emits:["click"],props:{active:Boolean,showEmpty:Boolean,highlight:Boolean,links:[Object,Array,Boolean]},computed:{count(){return this.links?this.links instanceof Array?this.links.length:Object.values(this.links).length:0}}};const ea=(0,z.A)(aa,[["render",Z]]);var ta=ea,sa=t(3751);const na={class:"package-popup__tabcontent",tabindex:"-1"},ia={key:0,class:"package-popup__packagelist"};function la(a,e,t,n,i,l){const o=(0,s.g2)("package-link");return(0,s.bo)(((0,s.uX)(),(0,s.CE)("div",na,[(0,s.RG)(a.$slots,"default",{},(()=>[t.links?((0,s.uX)(),(0,s.CE)("div",ia,[((0,s.uX)(!0),(0,s.CE)(s.FK,null,(0,s.pI)(l.iterableLinks,((e,t)=>(0,s.RG)(a.$slots,"links",(0,s.v6)({ref_for:!0},{name:t,text:e}),(()=>[((0,s.uX)(),(0,s.Wv)(o,{name:t,key:t,text:e},{default:(0,s.k6)((()=>[(0,s.RG)(a.$slots,"actions",(0,s.v6)({ref_for:!0},{name:t}))])),_:2},1032,["name","text"]))])))),256))])):(0,s.Q3)("",!0)]))],512)),[[sa.aG,t.active]])}const oa={class:"package-link__details"},pa=["title"],ca={class:"package-link__text"},ra={class:"package-link__actions"};function ua(a,e,t,i,l,o){const p=(0,s.g2)("details-button");return(0,s.uX)(),(0,s.CE)("article",{class:(0,n.C4)(["package-link",{"package-link--limit":!t.text}])},[(0,s.Lk)("div",oa,[(0,s.Lk)("p",{class:"package-link__name",title:t.name},(0,n.v_)(a.metadata&&a.metadata.title||t.name),9,pa),(0,s.Lk)("p",ca,(0,n.v_)(t.text||a.metadata&&a.metadata.description),1)]),(0,s.Lk)("div",ra,[(0,s.RG)(a.$slots,"default"),(0,s.bF)(p,{small:"",name:t.name},null,8,["name"])])],2)}var da=t(9071),ka={mixins:[S.A],components:{DetailsButton:da.A},props:{name:String,text:String},computed:{data:a=>({name:a.name})}};const ga=(0,z.A)(ka,[["render",ua]]);var ma=ga,ha={components:{PackageLink:ma},props:{active:Boolean,links:[Object,Array]},computed:{iterableLinks(){if(this.links instanceof Array){const a={};return this.links.forEach((e=>{a[e]=null})),a}return this.links}},watch:{active(){setTimeout((()=>{this.$el.focus()}),0)}}};const _a=(0,z.A)(ha,[["render",la]]);var va=_a,ba=t(4387);const fa={key:0,class:"package-funding"},ya=["href"],$a=["href"],Ca=["href"],Xa=["href"],Ea=["href"];function La(a,e,t,i,l,o){return t.items&&t.items.length?((0,s.uX)(),(0,s.CE)("div",fa,[(0,s.Lk)("div",null,[(0,s.Lk)("span",null,(0,n.v_)(a.$t("ui.package-details.funding")),1),((0,s.uX)(!0),(0,s.CE)(s.FK,null,(0,s.pI)(t.items,((a,e)=>((0,s.uX)(),(0,s.CE)(s.FK,null,["github"===a.type?((0,s.uX)(),(0,s.CE)("a",{href:o.githubUrl(a),target:"_blank",rel:"noreferrer noopener",key:e},"GitHub",8,ya)):"tidelift"===a.type?((0,s.uX)(),(0,s.CE)("a",{href:a.url,target:"_blank",rel:"noreferrer noopener",key:e},"Tidelift",8,$a)):"patreon"===a.type?((0,s.uX)(),(0,s.CE)("a",{href:a.url,target:"_blank",rel:"noreferrer noopener",key:e},"Patreon",8,Ca)):"opencollective"===a.type?((0,s.uX)(),(0,s.CE)("a",{href:a.url,target:"_blank",rel:"noreferrer noopener",key:e},"OpenCollective",8,Xa)):((0,s.uX)(),(0,s.CE)("a",{href:a.url,target:"_blank",rel:"noreferrer noopener",key:e},(0,n.v_)(a.url.replace(/^https?:\/\/(www.)?([^/]+).*$/,"$2")),9,Ea))],64)))),256))])])):(0,s.Q3)("",!0)}var wa={name:"PackageFunding",props:{items:{type:Array,required:!0}},computed:{githubUrl:()=>a=>a.url.replace(/^https:\/\/github.com\/([^/]+)$/,"https://github.com/sponsors/$1")}};const Fa=(0,z.A)(wa,[["render",La],["__scopeId","data-v-5a8fd14b"]]);var Aa=Fa,Wa={mixins:[S.A],components:{PopupOverlay:ba.A,MoreLinks:Y,LoadingSpinner:V.A,PackageLogo:K.A,PackageFunding:Aa,DetailsTab:ta,DetailsContent:va},props:{local:{type:Object},dependents:{type:Object}},data:()=>({appTitle:"",links:[],hasPrevious:!1}),computed:{current:a=>a.$route.query.p,tab:a=>String(a.$route.hash).substring(1),exists:a=>a.metadata,data:a=>a.local||{name:a.current},authors:a=>a.metadata.authors&&a.metadata.authors.length?a.metadata.authors.filter((a=>!!a.name)):null,license:a=>a.metadata.license?a.metadata.license instanceof Array?a.metadata.license.join(", "):a.metadata.license:"–",contaoVersions:a=>a.metadata.contaoVersions||null},methods:{datimFormat:k.A,numberFormat:j.A,...(0,d.PY)("packages/details",["clearCurrent"]),setTab(a){this.$router.replace({query:this.$route.query,hash:`#${a}`,append:!0})},updatePage(){let a=`${this.current} - ${this.appTitle}`,e="";this.metadata&&(this.metadata.title&&(a=`${this.metadata.title} (${this.current}) - ${this.appTitle}`),e=this.metadata.description||""),document.title=a,document.head.querySelector('meta[name="description"]').setAttribute("content",e)},addLink(a,e,t=null){const s=new URL(location.pathname,location);s.search=a;const n=document.createElement("link");n.setAttribute("rel",e),n.setAttribute("href",s.toString()),t&&n.setAttribute("hrefLang",t),document.head.appendChild(n),this.links.push(n)}},watch:{current(){this.updatePage(),this.hasPrevious=/[?&]p=/.test(window.history.state?.back)},exists(a){a||this.clearCurrent()},metadata(){this.updatePage()}},created(){this.appTitle=document.title},mounted(){document.head.querySelector('meta[name="robots"]').setAttribute("content","index,follow"),this.updatePage(),this.addLink(`?p=${this.current}&_locale=${this.$i18n.locale}`,"canonical"),Object.keys(O.A).forEach((a=>{this.addLink(`?p=${this.current}&_locale=${a}`,"alternate",a)}))},beforeUnmount(){document.title=this.appTitle,document.head.querySelector('meta[name="description"]').setAttribute("content",""),this.links.forEach((a=>{document.head.removeChild(a)}))}};const Qa=(0,z.A)(Wa,[["render",G]]);var Ta=Qa,xa=t(1909),Pa=t(3629),Ra={mixins:[g.A],components:{PackageConstraint:Pa.A,PackageDetails:Ta,InstallButton:xa.A},computed:{...(0,d.aH)("packages",{allInstalled:"installed"}),...(0,d.L8)("packages",["packageConstraint"]),current:a=>a.$route.query.p,data:a=>a.add[a.current]||a.allInstalled&&a.allInstalled[a.current]||{name:a.current},dependents(){if(!this.allInstalled[this.data.name]?.dependents)return null;const a={},e=["requires","replaces","provides","conflicts"];return Object.values(this.allInstalled[this.data.name].dependents).forEach((t=>{if("__root__"===t.source||!e.includes(t.description)||t.source===this.data.name&&"replaces"===t.description)return;const s=this.$t(`ui.package-details.link${t.description[0].toUpperCase()}${t.description.slice(1)}`);let n=t.target;n===this.data.name&&this.metadata&&this.metadata.title&&(n=this.metadata.title),a[t.source]=`${s} ${n} ${t.constraint}`})),a}},methods:{datimFormat:k.A}};const qa=(0,z.A)(Ra,[["render",u]]);var Ba=qa}}]);"use strict";(self["webpackChunkcontao_manager"]=self["webpackChunkcontao_manager"]||[]).push([[44],{44:function(e){e.exports=JSON.parse('{"ui.app.httpsHeadline":"!! Bağlantı güvenli değil !!","ui.app.httpsDescription":"HTTPS olmadan verileriniz şifrelenmeden aktarılır ve başkaları tarafından görülebilir.","ui.app.httpsLink":"Ayrıntılı bilgi alın","ui.app.httpsHref":"https://https.cio.gov/everything/","ui.app.safeModeHeadline":"!! Güvenli kip etkin !!","ui.app.safeModeDescription":"Bazı Contao Manager özellikleri kullanılamaz.","ui.app.safeModeExit":"Güvenli kipten çık","ui.app.limitedHeadline":"Uzaktan kimlik doğrulama","ui.app.limitedDescription":"Parolasız oturum açma kullandığınızdan izinleriniz sınırlı.","ui.app.limitedLogout":"Kimliği yeniden doğrula","ui.app.totpHeadline":"Güvenlik bildirimi","ui.app.totpDescription":"Hesabınızın güvenliğini sağlamak için iki adımlı doğrulamayı yapılandırın.","ui.app.totpSetup":"Kurulum","ui.app.loading":"Contao Manager yükleniyor…","ui.app.apiError":"Beklenmeyen API durumu","ui.app.configSecurity1":"GÜVENLİK UYARISI !!! Yapılandırma klasörünün korunmadığı algılandı","ui.app.configSecurity2":"Contao Manager, yapılandırma dosyalarının herkese açık olduğunu algıladı. Klasörün güvenliği sağlanana kadar tüm işlemler etkisizleştirilecek. Yoksa bir saldırgan kurulumunuzun hassas verilerine erişebilir.\\n\\nBu sorunu gidermek için sunucunuzdaki \\"contao-manager\\" klasörüne erişimi engellediğinizden emin olun. Bunu nasıl yapacağınızı öğrenmek için site sunucunuzun belgelerine bakın veya barındırma hizmeti sağlayıcınızla görüşün.","ui.account.welcome":"Hoş geldiniz","ui.account.intro1":"Contao açık kaynaklı içerik yönetimi sistemini kurmak ve yönetmek için kullanılan Contao Manager uygulamasına hoş geldiniz. İlk kez kullanıyorsanız {readTheManualToGetStarted}.","ui.account.introGetStarted":"Başlamak için {readTheManualToGetStarted}.","ui.account.introManual":"rehberi okuyun","ui.account.intro2":"Herhangi bir sorunla karşılaşırsanız,  {ourGithubIssues} bakın ve henüz bildirilmemiş bir sorunu bildirmekten çekinmeyin.","ui.account.introIssues":"GitHub sorunlarımıza","ui.account.headline":"Kullanıcı hesabı","ui.account.description":"Kuurlumunuzu yönetmek için bir Contao Manager hesabı açın. Bu hesabın Contao ön yüzü ve yönetim bölümü ile ilgili olmadığını unutmayın. ","ui.account.username":"Kullanıcı adı","ui.account.password":"Parola","ui.account.passwordPlaceholder":"en az 8 karakter","ui.account.passwordLength":"Lütfen en az 8 karakter yazın.","ui.account.loginInvalid":"Hesap açılırken bir sorun çıktı. Başka bir kullanıcı adı deneyin.","ui.account.submit":"Hesap aç","ui.account.usePassword":"Parola ile oturum aç","ui.account.usePasskey":"Geçiş anahtarı ile oturum aç","ui.account.totpHeadline":"İki adımlı doğrulama","ui.account.totpDescription":"Hesabınıza ek bir güvenlik katmanı ekleyen iki adımlı doğrulamayı açın. Kullanıcı adınız ve parolanıza ek olarak, 1Password, Authy, Google Authenticator, Microsoft Authenticator, LastPass Authenticator veya başka herhangi bir tek kullanımlık parola uygulaması gibi bir iki adımlı doğrulama uygulaması tarafından oluşturulan bir kodu yazmanız gerekir.","ui.account.totpSetup":"Şimdi yapılandır","ui.account.totpSkip":"Sonra yapılandır","ui.account.login":"Daveti reddet","ui.account.contribute1":"Contao ve Contao Manager kar amacı gütmeyen Contao Association tarafından desteklenmektedir.","ui.account.contribute2":"Lütfen {donate} açık kaynak dünyasına destek vermeyi değerlendirin.","ui.account.contributeDonate":"bir bağış yaparak","ui.login.headline":"Oturum aç","ui.login.description":"Kurulumunuzu yönetmek için oturum açın.","ui.login.username":"Kullanıcı adı","ui.login.password":"Parola","ui.login.totpHeadline":"İki adımlı doğrulama","ui.login.totpDescription":"Oturum açmak için lütfen doğrulama kodunuzu yazın.","ui.login.totp":"Doğrulama kodu","ui.login.forgotPassword":"Parolamı unuttum","ui.login.button":"Oturum aç","ui.login.passkey":"Geçiş anahtarı ile oturum aç","ui.login.cancel":"İptal","ui.login.or":"ya da","ui.login.locked":"Contao Manager kilitlenmiş olduğundan erişim reddedildi. Kilidi açmak için Contao kök klasöründeki {lockFile} dosyasını silin.","ui.logout.headline":"Oturum zaman aşımına uğradı","ui.logout.warning":"25 dakikadan uzun süredir işlem yapmadınız. Güvenlik nedeniyle oturumunuz kısa bir süre içinde sonlandırılacak.","ui.logout.expired":"30 dakikadan uzun süredir işlem yapmadığınız için oturumunuz otomatik olarak sonlandırıldı.","ui.logout.renew":"Oturumu açık tut","ui.logout.logout":"Oturumu kapat","ui.logout.login":"Oturum açmaya dön","ui.oauth.error":"OAuth girişimi geçersiz. İstek parametrelerini denetleyin.","ui.oauth.https":"Yönlendirme adresi, kimlik doğrulama belirtecinin düz metin olarak iletilmesini önlemek için güvenli bir iletişim kuralı (https:) kullanmalıdır.","ui.oauth.headline":"Uzaktan kimlik doğrulama","ui.oauth.description":"Şu uygulama ya da hizmet Contao Manager kopyanıza uzaktan erişmek istiyor.","ui.oauth.domain":"Erişim izni vermeden önce bu adresi bildiğinizden ve sahibine güvendiğinizden emin olun!","ui.oauth.outOfScope":"Ne yazık ki, bu izni vermek için yeterli izinleriniz yok.","ui.oauth.allow":"Erişme izni ver","ui.oauth.deny":"Erişimi reddet","ui.oauth.switchUser":"Kullanıcıyı değiştir","ui.scope.admin":"Yönetici erişiminde kullanıcı yönetimi bulunur","ui.scope.install":"Yeni paketleri kurun ve Contao yapılandırmasını değiştirin","ui.scope.update":"Paketleri güncelleyin ve bakım görevlerini yürütün","ui.scope.read":"Paketleri ve yapılandırmayı okuyun","ui.boot.headline":"Sistem denetimi","ui.boot.description":"Lütfen sunucunuz incelenirken bekleyin…","ui.boot.issue1":"Kurulum sorunları algılandı","ui.boot.issue2":"Kurulumunuzda Contao Manager kullanabilmek için düzeltmeniz gereken sorunlar var.","ui.boot.run":"Contao Manager uygulamasını başlat","ui.boot.safeMode":"Güvenli kipte başlat","ui.recovery.headline":"Sistem kurtarma","ui.recovery.description":"Contao Manager, Contao kurulumuna benzeyen dosyalar algıladı, ancak komut satırı arabirimi beklendiği gibi çalışmıyor.","ui.recovery.console":"Konsol çıktısı","ui.recovery.repairOptions":"Lütfen kurulumunuzu onarmak için bir seçim yapın.","ui.recovery.repairHeadline":"Otomatik onarım","ui.recovery.repairDescription":"Uygulama ön belleğini yeniden oluşturup Composer paketlerini yeniden kurarak kurulumu otomatik olarak onarmayı dener.","ui.recovery.repairWarning":"İşlem sırasında üretici dosyalarında yapılmış herhangi bir değişiklik silinebilir!","ui.recovery.repairFailed":"Otomatik onarım başarılı olmadı. Kurulumu el ile onarmak için güvenli kipi deneyin.","ui.recovery.repairButton":"Sistem onarımını başlat","ui.recovery.safeModeHeadline":"Güvenli kip","ui.recovery.safeModeDescription":"Contao Manager güvenli kipte çalıştırıldığında, paketlerin yönetimine ve belirli bakım işlemlerine izin verir. Ancak çalışan bir Contao kurulumu ile ilgili özellikleri kullanılamaz.","ui.recovery.safeModeButton":"Güvenli kipte başlat","ui.server.pending":"Bekleniyor…","ui.server.running":"İnceleniyor…","ui.server.error":"Sunucudan alınan beklenmeyen bir yanıt nedeniyle denetim tamamlanamadı.","ui.server.details":"Ayrıntılar","ui.server.prerequisite":"Eksik bir ön koşul nedeniyle denetim iptal edildi.","ui.server.selfUpdate.title":"Contao Manager güncellemeleri","ui.server.selfUpdate.update":"Yeni Contao Manager {latest} sürümü yayınlanmış.","ui.server.selfUpdate.manualUpdate":"Yeni Contao Manager {latest} sürümü yayınlanmış. Sunucunuz otomatik güncellemeleri desteklemiyor. Lütfen {download} adresinden yeni sürümü indirin.","ui.server.selfUpdate.latest":"Güncel {current} sürümünü kullanıyorsunuz.","ui.server.selfUpdate.dev":"Geliştirme yapımları otomatik güncellemeleri desteklemez.","ui.server.selfUpdate.unsupported":"Yeni bir sürüm yayınlanmış ancak PHP sürümünüzü desteklemiyor.","ui.server.selfUpdate.button":"Otomatik güncelle","ui.server.selfUpdate.continue":"İlerle","ui.server.config.title":"Sunucu yapılandırması","ui.server.config.setup":"Yapılandır","ui.server.config.change":"Değiştir","ui.server.config.save":"Kaydet","ui.server.config.cancel":"İptal","ui.server.config.customOption":"Diğer…","ui.server.config.description":"Arka plan görevlerini doğru bir şekilde çalıştırmak için Contao Manager uygulamasının, PHP komut satırı binary dosyasını nerede bulacağını ve site sürecinden ayrı olarak komutları nasıl çalıştıracağını bilmesi gerekir.","ui.server.config.formTitle":"Sunucu yapılandırması","ui.server.config.formText":"Lütfen PHP binary dosyanızın yolunu yazın. Binary programın PHP sürümünün site işleminizle aynı olduğundan emin olun.","ui.server.config.cloudTitle":"Composer Resolver Cloud","ui.server.config.cloudText":"Composer Resolver Cloud, sunucunuz yeterli yerel bellek sunmasa bile Composer bağımlılıklarının kurulmasını sağlar. Paket bilgilerinizin Contao Association tarafından işletilen bir bulut sunucusuna aktarılacağını unutmayın.","ui.server.config.cloud":"Composer Resolver Cloud kullanılsın","ui.server.config.cli":"PHP binary dosyası","ui.server.config.stateErrorCli":"Sunucuda geçerli bir PHP binary dosyası bulunamadı.","ui.server.config.stateErrorCloud":"Composer Resolver Cloud desteklenmiyor.","ui.server.config.stateSuccess":"PHP binary dosyası {php_cli} konumunda.","ui.server.php_web.title":"PHP site işlemi","ui.server.php_web.below7":"PHP {version} sürümü bulundu. Lütfen en kısa sürede PHP 7 sürümüne geçin!","ui.server.php_web.success":"PHP {version} sürümü bulundu. Bilinen bir sorun bulunamadı.","ui.server.php_cli.title":"PHP komut satırı arayüzü","ui.server.php_cli.success":"PHP {version} sürümü bulundu. Bilinen bir sorun bulunamadı.","ui.server.composer.title":"Composer ortamı","ui.server.composer.success":"Bilinen bir sorun bulunamadı.","ui.server.composer.install":"Composer bağımlılıkları kurulmamış.","ui.server.composer.button":"Kur","ui.server.contao.title":"Contao kurulumu","ui.server.contao.setup":"Kurulum","ui.server.contao.check":"Veri tabanını denetle","ui.server.contao.empty":"Herhangi bir Contao sürümünü bulunamadı.","ui.server.contao.old":"Contao {version} sürümü Contao Manager ile uyumlu değil. Lütfen kurulumunuzu el ile güncelleyin.","ui.server.contao.found":"Contao {version} sürümü bulundu (API sürümü {api}).","ui.server.contao.connectionError":"Veri tabanı sunucusu ile bağlantı kurulamadı.","ui.server.contao.connectionProblem":"Veri tabanı sorunu bulundu.","ui.server.contao.missingUser":"Yönetici hesabı bulunamadı.","ui.setup.continue":"İlerle","ui.setup.manager":"Contao Manager uygulamasını başlat","ui.setup.cancel":"İptal","ui.setup.welcome":"Hoş geldiniz","ui.setup.welcome1":"Bu yardımcı, açık kaynaklı Contao içerik yönetimi sistemi kurulumunu yapmanız için gerekli adımlarda size yol gösterecek.","ui.setup.welcome2":"Herhangi bir sorunuz varsa belgelere, forumlara, Slack kanalına ve {destek} sayfasına bakabilirsiniz.","ui.setup.support":"topluluk desteği","ui.setup.start":"Başlayalım","ui.setup.complete":"Tebrikler!","ui.setup.complete1":"Contao {version} kuruldu.","ui.setup.complete2":"Kurulum işlemini tamamlamak için gereken veri tabanı bağlantısını yapılandırmak ve yönetim bölümü kullanıcısı oluşturacak kurulum aracını açın.","ui.setup.complete3":"Artık Contao yönetim bölümüne giderek sitenizi oluşturmaya başlayabilirsiniz. Çeşitli eklentilere gerek duyuyorsanız Contao Manager ile ilerleyin.","ui.setup.installTool":"Kurulum aracını açın","ui.setup.login":"Contao oturumu açın","ui.setup.funding":"Özgür yazılım, \\"konuşma özgürlüğü\\" ifadesindeki gibi \\"özgürdür\\". \\"Ücretsiz\\" olmasına rağmen o anlama gelmez. Contao gibi bir açık kaynaklı proje, tek bir kişi veya şirket tarafından toplanamayacak miktarda para gerektirir.\\nContao ile oluşturulmuş bir siteniz varsa veya böyle siteler satıyorsanız, işinizin destekleyen ürüne mali katkıda bulunduğunuzu görmek isteriz.","ui.setup.fundingLink":"Ayrıntılı bilgi alın","ui.setup.document-root.headline":"Site sunucusu kurulumu","ui.setup.document-root.warning":"Contao Manager ile Contao kurmak için site sunucusunun belge kök klasörünü düzeltmeniz gerekir.","ui.setup.document-root.description1":"Contao, herkese açık dosyalar için ayrı bir klasör kullanır. Uygulama dosyaları bu klasörün üst klasörüne kurulur. Klasör yapısı doğru değilse veya klasörler boş değilse Contao kurulamaz.","ui.setup.document-root.description2":"Belge kök klasörünüzü nasıl yapılandıracağınızı bilmiyorsanız, Contao belgelerini okuyun ya da barındırma hizmeti sağlayıcınızla görüşün.","ui.setup.document-root.documentation":"Belgeleri okuyun","ui.setup.document-root.conflictsTitle":"Kurulum klasörü boş değil","ui.setup.document-root.conflictsDirectory":"Gelecekteki Contao kurulumunuzun kök klasörü boş değil. Kurulum işlemi tarafından üzerine yazılabilecek {count} dosya bulundu. Contao için boş bir klasör yapısı oluşturmanız önerilir. Ancak kullanılmadıklarından eminseniz aşağıdaki dosyaları silerek yeniden denetleyebilirsiniz.","ui.setup.document-root.ignoreConflicts":"Boş olmayan bir klasöre Contao kurmak istiyorum. Bu işlemin site alanımdaki var olabilecek dosyaların üzerine yazabileceğini anlıyorum.","ui.setup.document-root.check":"Yeniden denetle","ui.setup.document-root.create":"Klasörleri oluştur","ui.setup.document-root.change":"Klasörleri değiştir","ui.setup.document-root.formTitle":"Klasör kurulumu","ui.setup.document-root.formText1":"Contao Manager, otomatik olarak sunucuda yeni bir klasör yapısı oluşturabilir.","ui.setup.document-root.formText2":"Yeni belge kök klasörünü el ile yapılandırmanız gerekir (örneğin, bir barındırma hizmeti yönetim panosu üzerinden).","ui.setup.document-root.autoconfig":"Sunucu yapılandırmamı değiştirmem gerektiğini anlıyorum. Belge kök klasörünü yapılandırmamak Contao Manager uygulamasını bozacak ve yapılandırma dosyalarını (hesap bilgileri ve parolalar ile birlikte) açığa çıkaracak!","ui.setup.document-root.directory":"Yeni klasör","ui.setup.document-root.currentRoot":"Geçerli belge kök klasörü","ui.setup.document-root.newRoot":"Yeni belge kök klasörü","ui.setup.document-root.finish":"Klasörleri kur","ui.setup.document-root.publicDir":"Herkese açık dosyalar için {dir} klasörünü kullanın (Contao {version} için)","ui.setup.document-root.directoryInvalid":"Lütfen geçerli bir klasör adı yazın.","ui.setup.document-root.directoryExists":"Hedef klasör zaten var. Lütfen farklı bir ad yazın.","ui.setup.document-root.confirmation":"Contao Manager, Contao kurulumunuz için gerekli klasörü oluşturdu. Şimdi site sunucunuzda belge kök klasörünü yapılandırmanız gerekiyor. Bu işlemi yapana kadar bu sayfayı yeniden yüklemeyin.","ui.setup.document-root.reload":"Sayfayı yeniden yükle","ui.setup.document-root.success":"Site sunucunuzdaki klasör yapısı doğru şekilde hazırlanmış!","ui.setup.document-root.installingProjectDir":"Uygulama dosyaları {dir} klasörüne kurulacak.","ui.setup.document-root.installingPublicDir":"Herkese açık dosyalar {dir} klasörüne kurulacak.","ui.setup.document-root.installedProjectDir":"Uygulama dosyaları {dir} klasörüne kuruldu.","ui.setup.document-root.installedPublicDir":"Herkese açık dosyalar {dir} klasörüne kuruldu.","ui.setup.create-project.headline":"Contao kurulumu","ui.setup.create-project.description":"Contao geliştirmesi {semver} ilkesini izler. Her altı ayda bir yeni bir küçük sürüm yayınlanır. Şu anda desteklenen sürümler şunlardır:","ui.setup.create-project.semver":"Anlamsal sürümleme","ui.setup.create-project.latestTitle":"Güncel","ui.setup.create-project.ltsTitle":"Uzun dönemli destek","ui.setup.create-project.latestQ1":"Güncel sürümümüz en fazla özelliği sunar ve {year} Şubat ayına kadar desteklenir.","ui.setup.create-project.latestQ3":"Güncel sürümümüz en fazla özelliği sunar ve {year} Ağustos ayına kadar desteklenir.","ui.setup.create-project.ltsText":"Güncel uzun dönem desteklenen sürümümümüz, kararlılık isteyenler içindir. {year} Şubat ayına kadar uzun dönem desteği sunar.","ui.setup.create-project.pltsText":"Önceki uzun dönem desteklenen sürümümüz. Hala {year} Şubat ayına kadar uzun dönem desteği sunuyor.","ui.setup.create-project.requiresPHP":"En az PHP {version} sürümü gereklidir. Sizin sürümünüz PHP {current}.","ui.setup.create-project.releaseplan":"Ayrıntılı bilgi almak için {contaoReleasePlan} bölümüne bakabilirsiniz.","ui.setup.create-project.releaseplanLink":"Contao yayınlanma planı","ui.setup.create-project.installed":"Contao {version} sunucuya kuruldu. Veri tabanınızı kurmaya geçin ya da farklı bir sürüm kurmak için Contao Manager uygulamasını başlatın.","ui.setup.create-project.formTitle":"Bir dağıtım seçin","ui.setup.create-project.formText":"Lütfen kurmak istediğiniz sürümü seçin.","ui.setup.create-project.version":"Sürüm","ui.setup.create-project.demo":"Contao tanıtım sitesini kur","ui.setup.create-project.demoDescription":"Tanıtım sitesi Contao ve onun tüm temel özelliklerini tanımanıza yardımcı olur. Daha fazla temayı {store} üzerinde bulabilirsiniz.","ui.setup.create-project.coreOnly":"En küçük kurulum (yalnızca çekirdek)","ui.setup.create-project.noUpdate":"Kurulumu atla (yalnızca uzmanlar)","ui.setup.create-project.theme":"Contao teması","ui.setup.create-project.themeInstall":"Bir Contao teması kurmak için arama girişini kullanın ya da Contao Manager ile kurulabilen bir tema dosyası (.cto/.zip) yükleyin.","ui.setup.create-project.themeBuy":"Resmi {store} adresini açtığınızdan emin olun.","ui.setup.create-project.themeStore":"Contao tema mağazası","ui.setup.create-project.themeUpload":"Tema dosyasını yükle (.cto/.zip)","ui.setup.create-project.themeInvalid":"Yüklenen dosya bir Contao teması değil ya da Contao Manager uygulamasını desteklemiyor.","ui.setup.create-project.themeWarning":"Contao Manager bu temanın sunucunuzla uyumlu olup olmadığını söyleyemez. Sorularınız varsa lütfen tema satıcısına sorun.","ui.setup.create-project.themeTitle":"Tema bilgilerini gözden geçir","ui.setup.create-project.themeDetails":"Bu temayla birlikte şu bağımlılıklar ve dosyalar yüklenecek.","ui.setup.create-project.themeRequire":"{count} bağımlılık | {count} bağımlılık","ui.setup.create-project.themeFiles":"{count} dosya | {count} dosya","ui.setup.create-project.theme.or":"ya da herkese açık temalar arayın","ui.setup.create-project.theme.search":"Tema ara","ui.setup.create-project.theme.more":"Diğer temalar","ui.setup.create-project.theme.empty":"{query} ile eşleşen bir tema yok","ui.setup.create-project.theme.uploaded":"Tema dosyası yüklendi.","ui.setup.create-project.theme.packageName":"Paket adı","ui.setup.create-project.theme.version":"Sürüm","ui.setup.create-project.theme.authors":"Geliştirici(ler)","ui.setup.create-project.install":"Kur","ui.setup.create-project.cancel":"İptal","ui.setup.database-connection.headline":"Veri tabanı bağlantısı","ui.setup.database-connection.description":"Contao, sayfaları, içerikleri, kullanıcıları ve diğer ilişkisel verileri depolamak için bir MySQL veri tabanı (ya da MariaDB gibi uyumlu bir dalı) kullanır. Bağlantı parametreleri, Contao kurulumunuzun proje kök klasöründeki {env} dosyasında bulunur.","ui.setup.database-connection.formTitle":"Bağlantı parametreleri","ui.setup.database-connection.formText":"Bir veri tabanı adresi yazın ya da tek tek kullanıcı adı, parola, sunucu ve veri tabanı alanlarını doldurun.","ui.setup.database-connection.url":"Veri tabanı adresi","ui.setup.database-connection.validUrl":"Veri tabanı adresi geçersiz ya da sunucu bağlantısı kurulamadı.","ui.setup.database-connection.or":"ya da","ui.setup.database-connection.user":"Kullanıcı adı","ui.setup.database-connection.password":"Parola","ui.setup.database-connection.server":"Sunucu (:bağlantı noktası)","ui.setup.database-connection.database":"Veri tabanı adı","ui.setup.database-connection.connected":"{server} üzerindeki {database} veri tabanı ile bağlantı kuruldu.","ui.setup.database-connection.error":"Veri tabanı bağlantısı kurulurken sorun çıktı.","ui.setup.database-connection.problem":"Contao veri tabanı sunucunuzda bir sorunla karşılaştı.","ui.setup.database-connection.schemaTitle":"Veri tabanı şeması","ui.setup.database-connection.migration":"Bekleyen bir aktarım var. | Bekleyen {count} aktarım var.","ui.setup.database-connection.schema":"Bekleyen bir şema güncellemesi var. | Bekleyen {count} şema güncellemesi var.","ui.setup.database-connection.noChanges":"Veri tabanı şemanız güncel","ui.setup.database-connection.check":"Veri tabanını denetle","ui.setup.database-connection.skip":"Atla","ui.setup.database-connection.save":"Kaydet","ui.setup.database-connection.change":"Kimlik doğrulama bilgilerini değiştir","ui.setup.database-connection.restoreTitle":"Veri tabanı içe aktarma","ui.setup.database-connection.restoreText":"Yeni kurduğunuz temada bir veri tabanı yedeği var. Tema verilerini içe aktarmak için veri tabanını geri yükleyin ya da boş bir Contao kurulumuyla başlamak için bu adımı atlayın. | Yeni kurduğunuz temada birkaç veri tabanı yedeği var. Tema verilerini içe aktarmak için bir yedekleme dosyası seçin ya da boş bir Contao kurulumuyla başlamak için bu adımı atlayın.","ui.setup.database-connection.backup":"İçe aktarma işleminden önce geçerli veri tabanının yedeğini alın","ui.setup.database-connection.backupWarning":"İçe aktarım işlemi sırasında veri tabanındaki tüm verilerin üzerine yazılır! Veri tabanı boş değilse öncelikle bir yedeğini alın.","ui.setup.database-connection.restore":"Tema veri tabanını içe aktar","ui.setup.database-connection.restoreOption":"{date} yedeği ({size})","ui.setup.database-connection.restored":"Tema veri tabanınız içe aktarıldı. Veri tabanı şemanızı doğrulamak için ilerleyin.","ui.setup.backend-user.success":"Veri tabanınızda Contao yönetim bölümü için bir yönetici hesabı bulundu. Daha fazla kullanıcı eklemek için Contao yönetim bölümünü kullanın.","ui.setup.backend-user.error":"Kullanıcı listesi alınamadı. Ayrıntılar için konsol çıktısına bakın.","ui.setup.backend-user.headline":"Yönetim bölümü hesabı","ui.setup.backend-user.description":"Sitenizi yönetmek için Contao yönetim bölümüne erişebilecek en az bir yönetici hesabınızın olması gerekir. Bu hesabın Contao Manager ile ilgili olmadığını unutmayın.","ui.setup.backend-user.formTitle":"Hesap aç","ui.setup.backend-user.formText":"Yeni yönetim bölümü hesabının ayrıntılarını yazın.","ui.setup.backend-user.username":"Kullanıcı adı","ui.setup.backend-user.name":"Ad","ui.setup.backend-user.email":"E-posta adresi","ui.setup.backend-user.emailInvalid":"Lütfen geçerli bir e-posta adresi yazın","ui.setup.backend-user.password":"Parola","ui.setup.backend-user.passwordPlaceholder":"en az 8 karakter","ui.setup.backend-user.passwordLength":"Lütfen en az 8 karakter yazın.","ui.setup.backend-user.create":"Hesap ekle","ui.task.headline":"Arka plan görevi","ui.task.loading":"Ayrıntılar yükleniyor…","ui.task.created":"Ayrıntılar yükleniyor…","ui.task.active":"Lütfen Contao Manager arka planda görev işlemlerini yürütürken bekleyin.","ui.task.complete":"Tüm işlemler tamamlandı. Ayrıntılı bilgi almak için konsol çıktısına bakın.","ui.task.aborting":"Lütfen arka plan işlemleri iptal edilirken bekleyin.","ui.task.stopped":"Bazı arka plan görevleri iptal edildi. Lütfen konsol çıktısını denetleyin.","ui.task.error":"Bir arka plan görevi beklenmedik şekilde durdu. Lütfen konsol çıktısını denetleyin.","ui.task.failed":"Contao Manager bir arka plan görevini başlatamadı!","ui.task.failedDescription1":"İşlemler arka planda yürütülmeye çalışılırken bir sorun çıktı.","ui.task.failedDescription2":"Bu sorun yeniden yaşanırsa sunucunuz desteklenmiyor olabilir.","ui.task.reportProblem":"Sorun bildir","ui.task.sponsor":"Composer Cloud {sponsor} tarafından destekleniyor","ui.task.buttonAudit":"Veri tabanını güncelle","ui.task.buttonClose":"Kapat","ui.task.buttonConfirm":"Onaylayıp kapat","ui.task.buttonCancel":"İptal","ui.task.confirmCancel":"Bu görevi iptal etmek istediğinize emin misiniz? Bu durum Contoa kurulumunuzu bozuk bir durumda bırakabilir!","ui.task.autoclose":"Başarılı işlemlerin görev ayrıntıları kapatılsın","ui.console.toggle":"Konsol çıktısını görüntüle/gizle","ui.console.showLog":"Tüm konsol günlüğünü görüntüle","ui.console.copyLog":"Günlüğü panoya kopyala","ui.migrate.headline":"Veri tabanı güncellemeleri","ui.migrate.migrationsOnly":"(yalnızca aktarımlar)","ui.migrate.schemaOnly":"(yalnızca şema)","ui.migrate.loading":"Lütfen veri tabanınız incelenirken bekleyin…","ui.migrate.empty":"Bekleyen bir aktarım ya da şema güncellemesi bulunamadı. Veri tabanınız güncel.","ui.migrate.emptyMigrations":"Bekleyen bir aktarım bulunamadı. Şema güncellemelerini de denetlediğinizden emin olun.","ui.migrate.emptySchema":"Bekleyen bir şema güncellemesi bulunamadı. Aktarımları da denetlediğinizden emin olun.","ui.migrate.pending":"Veri tabanınız güncel değil. Lütfen aşağıdaki konsol çıktısını denetleyip istenilen değişiklikleri yapın.","ui.migrate.previousChanges":"Daha önceki bir veri tabanı aktarma işlemi onaylanmamış.\\nLütfen aşağıdaki konsol çıktısını denetleyip sonraki değişiklikleri görmek için ilerleyin.","ui.migrate.previousComplete":"Daha önceki bir veri tabanı aktarma işlemi onaylanmamış. Lütfen aşağıdaki konsol çıktısını denetleyin. Bekleyen başka bir değişiklik yok.","ui.migrate.appliedChanges":"Veri tabanı güncellemeleri yapıldı.\\nLütfen aşağıdaki konsol çıktısını denetleyip sonraki değişiklikleri görmek için ilerleyin.","ui.migrate.appliedComplete":"Veri tabanı güncellemeleri yapıldı.\\nBekleyen başka bir aktarım ya da şema güncellemesi yok. Veri tabanınız güncel.","ui.migrate.problem":"Contao, veri tabanı sunucunuzda bazı sorunlarla karşılaştı.\\nNeyin düzeltilmesi gerektiğini öğrenmek için aşağıdaki konsol çıktısını inceleyin. | Contao, veri tabanı sunucunuzda bazı sorunlarla karşılaştı.\\nNeyin düzeltilmesi gerektiğini öğrenmek için aşağıdaki konsol çıktısını inceleyin.","ui.migrate.warning":"Contao, veri tabanı sunucunuzun yanlış yapılandırıldığını algıladı.\\nUyarıları geçici olarak atlayabilirsiniz. Ancak en iyi başarım ve veri bütünlüğü için bu sorunları düzeltmelisiniz.","ui.migrate.error":"Değişiklikler uygulanamadı. Veri tabanınız değişmiş olabilir. Lütfen yeniden denetleyin.","ui.migrate.execute":"Yürüt","ui.migrate.close":"Kapat","ui.migrate.confirm":"Onaylayıp kapat","ui.migrate.cancel":"İptal","ui.migrate.continue":"İlerle","ui.migrate.setup":"Kurulum","ui.migrate.skip":"Atla","ui.migrate.retry":"Yeniden denetle","ui.migrate.retryAll":"Tümünü denetle","ui.migrate.withDeletes":"DROP sorguları ile birlikte tüm veri tabanı değişikliklerini yürütür.","ui.migrate.migrationTitle":"Veri tabanı aktarımları","ui.migrate.schemaTitle":"Şema güncellemeleri","ui.migrate.problemTitle":"Veri tabanı sorunları","ui.migrate.warningTitle":"Veri tabanı uyarıları","ui.migrate.addTable":"{table} tablosunu ekle","ui.migrate.dropTable":"{table} tablosunu sil","ui.migrate.addField":"{table}.{field} alanını ekle","ui.migrate.changeField":"{table}.{field} alanını değiştir","ui.migrate.dropField":"{table}.{field} alanını sil","ui.migrate.createIndex":"{table} tablosuna \\"{name}\\" dizinini ekle ","ui.migrate.dropIndex":"{table} tablosundan \\"{name}\\" dizinini kaldır","ui.widget.mandatory":"Bu alan boş bırakılamaz.","ui.widget.blankOption":"Lütfen seçin…","ui.widget.showPassword":"Parolayı görüntüle","ui.widget.hidePassword":"Parolayı gizle","ui.error.title":"\\"{method} {url}\\" için HTTP isteği başarısız oldu.","ui.error.server500":"Sunucunuzda beklenmeyen bir sorun çıkmış gibi görünüyor. Lütfen site sunucunuzun (Apache/Nginx) günlük dosyalarını ve \\"contao-manager/logs\\" konumundaki Contao Manager günlüklerini denetleyin.","ui.error.response":"Sunucu, {status} durum koduyla bir yanıt verdi.","ui.error.moreLink":"Ayrıntılı bilgiler","ui.error.support":"Contao desteği","ui.error.permission":"Bu özelliği kullanma izniniz yok.","ui.footer.help":"Yardım","ui.footer.reportProblem":"Sorun bildir","ui.navigation.discover":"Keşfet","ui.navigation.packages":"Paketler","ui.navigation.tools":"Araçlar","ui.navigation.installTool":"Kurulum aracı","ui.navigation.backend":"Contao yönetim bölümü","ui.navigation.debug":"Contao hata ayıklama kipi","ui.navigation.logViewer":"Günlük görüntüleyici","ui.navigation.phpinfo":"PHP bilgileri","ui.navigation.phpinfoLoading":"PHP bilgileri yükleniyor…","ui.navigation.maintenance":"Bakım","ui.navigation.rebuildCache":"Ön belleği yeniden oluştur","ui.navigation.users":"Hesaplar","ui.navigation.systemCheck":"Sistem denetimi","ui.navigation.advanced":"Gelişmiş","ui.navigation.logout":"Oturumu kapat","ui.maintenance.database.title":"Veri tabanı aktarımları ve yedekler","ui.maintenance.database.description":"Veri tabanı aktarımları verilerin ve tablo şemalarının tutarlı olduğundan emin olur.","ui.maintenance.database.migrations":"Bekleyen bir veri tabanı aktarımı var | Bekleyen {count} veri tabanı aktarımı var","ui.maintenance.database.schemaUpdates":"Bekleyen bir şema güncellemesi var. | Bekleyen {count} şema güncellemesi var","ui.maintenance.database.error":"Veri tabanı sorunu bulundu.","ui.maintenance.database.warning":"Veri tabanı uyarıları bulundu.","ui.maintenance.database.button":"Veri tabanını denetle","ui.maintenance.database.migrationOnly":"Yalnızca aktarımları denetle","ui.maintenance.database.schemaOnly":"Yalnızca şemayı denetle","ui.maintenance.database.installTool":"Kurulum aracını aç","ui.maintenance.database.createBackup":"Yedek oluştur","ui.maintenance.database.backupUnsupported":"Contao sürümünüzde veri tabanı yedekleri desteklenmiyor.","ui.maintenance.database.backupList":"{date} tarihinde oluşturulmuş bir veri tabanı yedeğiniz var. | {count} veri tabanı yedeğiniz var. En sonuncusu {date} tarihinde oluşturulmuş.","ui.maintenance.database.backupEmpty":"Şu anda herhangi bir veri tabanı yedeğiniz yok.","ui.maintenance.rebuildCache.title":"Uygulama ön belleği","ui.maintenance.rebuildCache.description":"Yapılandırma dosyalarında bir değişiklik yapıldığında uygulama ön belleğinin yeniden oluşturulması gerekir.","ui.maintenance.rebuildCache.rebuildProd":"Üretim ön belleğini yeniden oluştur","ui.maintenance.rebuildCache.rebuildDev":"Geliştirme ön belleğini yeniden oluştur","ui.maintenance.rebuildCache.clearProd":"Üretim ön belleğini temizle","ui.maintenance.rebuildCache.clearDev":"Geliştirme ön belleğini temizle","ui.maintenance.installTool.title":"Contao kurulum aracı","ui.maintenance.installTool.description":"Arka arkaya üç kez yanlış parola yazarsanız Contao kurulum aracı otomatik olarak kilitlenir.","ui.maintenance.installTool.unlock":"Kurulum aracının kilidini aç","ui.maintenance.installTool.lock":"Kurulum aracını kilitle","ui.maintenance.dumpAutoload.title":"Composer sınıf yükleyicisi","ui.maintenance.dumpAutoload.description":"Composer otomatik yükleyici, PHP sınıfının yüklenmesinden sorumludur. Kök klasördeki composer.json dıosyasına özel ad alanları eklendikten sonra otomatik yükleyici indirilmelidir.","ui.maintenance.dumpAutoload.button":"Otomatik yükleyiciyi indir","ui.maintenance.composerInstall.title":"Composer bağımlılıkları","ui.maintenance.composerInstall.description":"Composer bağımlılıkları uygulama kök klasörünüzün altındaki [vendor] klasöründe bulunur. [composerLock] dosyası değiştirildikten ya da el ile yüklendikten sonra bağımlılıkları yeniden kurmak gerekebilir.","ui.maintenance.composerInstall.button":"Kurucuyu başlat","ui.maintenance.composerInstall.update":"Composer güncellemesini başlat","ui.maintenance.composerCache.title":"Composer ön belleği","ui.maintenance.composerCache.description":"Composer, daha iyi başarım sağlamak için indirilen paketleri ön belleğe alır. Ön bellekte bozuk dosyalar gibi sorunlarınız varsa, paketlerin yeniden indirilmesini dayatmak için Composer ön belleğini silmeyi deneyin.","ui.maintenance.composerCache.button":"Ön belleği temizle","ui.maintenance.maintenanceMode.title":"Bakım kipi","ui.maintenance.maintenanceMode.description":"Contao bakım kipine geçirildiğinde, sitede \\"503 Hizmet Kullanılamıyor\\" kalıbı görüntülenir.","ui.maintenance.maintenanceMode.enable":"Etkinleştir","ui.maintenance.maintenanceMode.disable":"Etkisizleştir","ui.maintenance.debugMode.title":"Hata ayıklama kipi","ui.maintenance.debugMode.description":"[appDevPhp] giriş noktası için bir kullanıcı adı ve parola ayarlayarak hata ayıklama kipini etkinleştirin.","ui.maintenance.debugMode.descriptionJwt":"Geçerli etki alanı için hata ayıklama çerezini ayarlayarak hata ayıklama kipini etkinleştirin.","ui.maintenance.debugMode.activate":"Etkinleştir","ui.maintenance.debugMode.deactivate":"Etkisizleştir","ui.maintenance.debugMode.credentials":"Kimlik doğrulama bilgileri","ui.maintenance.debugMode.user":"Lütfen hata ayıklama kipi için bir kullanıcı adı yazın.","ui.maintenance.debugMode.password":"Lütfen hata ayıklama kipi için bir parola yazın.","ui.maintenance.opcodeCache.title":"Opcode ön belleği","ui.maintenance.opcodeCache.description":"Opcode, daha hızlı işlem yapmak için PHP dosyalarını site işleminde ön belleğe alır. Dosyaların değiştirildikten sonra tanınmaması gibi belirli durumlarda silinmelidir.","ui.maintenance.opcodeCache.button":"Ön belleği buda","ui.maintenance.safeMode":"Güvenli kipte kullanılamaz","ui.maintenance.unsupported":"Contao sürümünüz tarafından desteklenmiyor","ui.packages.updateButton":"Paketleri güncelle","ui.packages.searchButton":"Paket arama","ui.packages.searchPlaceholder":"Paketleri ara…","ui.packages.uploadOverlay":"Yüklemek için dosyaları sürükleyip buraya bırakın","ui.packages.uploadButton":"Paketleri yükle","ui.packages.uploadMessage":"Bir onaylanmamış yüklemeniz var. | {count} onaylanmamış yüklemeniz var.","ui.packages.uploadApply":"Yüklemeleri onayla","ui.packages.uploadReset":"Yüklemeleri sil","ui.packages.uploadIncomplete":"Bu dosya tam olarak yüklenmedi. Lütfen kaldırıp yeniden deneyin.","ui.packages.uploadDuplicate":"Bu dosya birden çok kez yüklenmiş gibi görünüyor. Lütfen kopyaları kaldırın.","ui.packages.uploadInstalled":"Bu dosya zaten kurulmuş. Lütfen kopyaları kaldırın.","ui.packages.uploadUnsupported":"Kurulumunuzda yükleme özelliği desteklenmiyor. Lütfen PHP ZIP eklentisinin kurulmuş olduğundan ve bağımlılıklarınızı güncellediğinizden emin olun.","ui.packages.changesMessage":"Bir onaylanmamış değişikliğiniz var. | {count} onaylanmamış değişikliğiniz var.","ui.packages.changesDryrun":"Değişiklik yapmadan dene","ui.packages.changesApply":"Değişiklikleri uygula","ui.packages.changesApplyAll":"Tüm paketleri güncelle","ui.packages.changesDryrunAll":"Tüm paketleri değişiklik yapmadan dene","ui.packages.changesReset":"Değişiklikleri sıfırla","ui.packages.changesReview":"Değişiklikleri gözden geçir","ui.packagelist.loading":"Yükleniyor…","ui.packagelist.uploads":"Yüklemeler","ui.packagelist.added":"Yeni paketler","ui.packagelist.installed":"Kurulmuş paketler","ui.package.hintRevert":"Değişiklikleri geri al","ui.package.hintNoupdate":"Güncelleme","ui.package.hintConstraint":"Değişiklikleri uyguladığınızda, bu paket {constraint} kısıtlaması ile kurulacak.","ui.package.hintConstraintBest":"Değişiklikleri uyguladığınızda, bu paket kullanılabilecek en iyi sürüm ile kurulacak.","ui.package.hintConstraintChange":"Değişiklikleri uyguladığınızda, bu paketin kısıtlamaları \\"{from}\\" yerine \\"{to}\\" olarak değiştirilecek.","ui.package.hintConstraintUpdate":"Değişiklikleri uyguladığınızda, bu paket güncellenecek.","ui.package.hintAdded":"Değişiklikleri uyguladığınızda, bu paket kurulacak.","ui.package.hintRemoved":"Değişiklikleri uyguladığınızda, bu paket kaldırılacak.","ui.package.requiredTitle":"el ile eklendi","ui.package.requiredText":"Bu paket composer.json dosyanızda gerekli olarak belirtilmiş ancak kurulmamış.","ui.package.removedTitle":"el ile kaldırıldı","ui.package.removedText":"Bu paket composer.json dosyanızdan kaldırılmış.","ui.package.installed":"Şu anda kurulu olan:","ui.package.version":"{version} sürümü","ui.package.additionalDownloads":"{count} indirme | {count} indirme","ui.package.additionalStars":"{count} yıldız | {count} yıldız","ui.package.editConstraint":"Düzenle","ui.package.uploadConstraint":"Bu kısıtlama yüklenen paket tarafından tanımlandı.","ui.package.updateButton":"Güncelle","ui.package.removeButton":"Kaldır","ui.package.installButton":"Paket ekle","ui.package.installButtonShort":"Ekle","ui.package.detailsButton":"Ayrıntılar","ui.package.latestConstraint":"güncel sürüm","ui.package.update":"Güncelleme yayınlanmış","ui.package.updateLatest":"güncel sürüm","ui.package.updateAvailable":"{version} yayınlanmış","ui.package.updateUnknown":"sürüm bilinmiyor","ui.package.updateConstraint":"Sürüm kısıtlamanızın dışında yeni bir sürüm yayınlanmış.","ui.package.incompatible":"{package} Contao {constraint} ile çalışmayacak.","ui.cloudStatus.headline":"Composer Resolver Cloud","ui.cloudStatus.version":"{version} sürümü","ui.cloudStatus.waitingTime":"Bekleme zamanı","ui.cloudStatus.jobs":"Geçerli görevler","ui.cloudStatus.workers":"İşlemler","ui.cloudStatus.approx":"{minutes} dakika","ui.cloudStatus.none":"yok","ui.cloudStatus.short":"ca. {minutes} dakika","ui.cloudStatus.long":"ca. {minutes} dakika {seconds} saniye","ui.cloudStatus.error":"Composer Resolver Cloud durumu alınamıyor. Kaynak bakım yüzünden kapalı ya da sorunlar nedeniyle erişilemiyor olabilir.","ui.cloudStatus.button":"Cloud durumu","ui.cloudStatus.refresh":"Cloud durumunu yenile","ui.log-viewer.loading":"Yükleniyor…","ui.log-viewer.empty":"Sunucunuzda herhangi bir günlük dosyası yok.","ui.log-viewer.reload":"Yeniden yükle","ui.log-viewer.file":"Günlük dosyası","ui.log-viewer.channel":"Kanal","ui.log-viewer.channelTitle":"Bu iletinin günlüğe kaydedileceği kanal.","ui.log-viewer.level":"Düzey","ui.log-viewer.levelTitle":"Günlük iletisinin önem düzeyi.","ui.log-viewer.timeHeader":"Zaman","ui.log-viewer.messageHeader":"İleti","ui.log-viewer.showContext":"Bağlamı görüntüle","ui.log-viewer.hideContext":"Bağlamı gizle","ui.log-viewer.showExtra":"Ekleri görüntüle","ui.log-viewer.hideExtra":"Ekleri gizle","ui.log-viewer.more":"Sonrakileri yükle…","ui.log-viewer.download":"İndir","ui.log-viewer.downloadTitle":"\\"{file}\\" dosyasını indir","ui.log-viewer.prodEnvironment":"Üretim ortamı","ui.log-viewer.devEnvironment":"Geliştirme ortamı (hata ayıklama kipi)","ui.user-manager.loading":"Kullanıcılar yükleniyor…","ui.user-manager.changePassword":"Parolayı değiştir","ui.user-manager.setupTotp":"İki adımlı doğrulamayı kur","ui.user-manager.disableTotp":"İki adımlı doğrulamayı kapat","ui.user-manager.invite":"Kullanıcı davet et","ui.user-manager.delete":"Sil","ui.user-manager.deleteConfirm":"\\"{username}\\" kullanıcısını silmek istediğinize emin misiniz?","ui.user-manager.deleted":"{username} kullanıcı adı silindi","ui.user-manager.passwordHeadline":"Parolayı değiştir","ui.user-manager.passwordText":"Parolanızı değiştirmek için, ilgili alanlara geçerli ve yeni parolayı yazın.","ui.user-manager.currentPassword":"Geçerli parola","ui.user-manager.newPassword":"Yeni parola","ui.user-manager.passwordPlaceholder":"en az 8 karakter","ui.user-manager.submitPassword":"Gönder","ui.user-manager.passwordChanged":"Parolanız değiştirildi.","ui.user-manager.passwordError":"Parola yanlış.","ui.user-manager.inviteHeadline":"Kullanıcı davet et","ui.user-manager.inviteText":"Contao Manager için birden fazla oturum açmaya gerek duyuyorsanız, buradan bir davet bağlantısı oluşturabilirsiniz. Bu bağlantıyı biriyle paylaşın veya verilen izinlerle yeni bir hesap açmak için başka bir aygıt üzerinde kullanın.","ui.user-manager.inviteSuccess1":"Yeni bir davet bağlantısı oluşturuldu. Aşağıdaki adres, bu Contao Manager üzerinde yeni bir kullanıcı hesabı oluşturmak için kullanılabilir. Davetiyenin geçerliliği {expires} tarihinde sona erecek (bir hafta sonra).","ui.user-manager.inviteSuccess2":"Lütfen bağlantıyı panonuza kopyalayın. Yalnızca bir kez çalışacak ve bu pencereyi kapattıktan sonra yeniden göremeyeceksiniz.","ui.user-manager.createInvitation":"Davet bağlantısı oluştur","ui.user-manager.clipboard":"Panoya kopyala","ui.user-manager.permissions":"İzinler hakkında bilgi alın","ui.user-manager.cancel":"İptal","ui.user-manager.close":"Kapat","ui.user-manager.you":"Siz","ui.user-manager.2fa":"2FA","ui.user-manager.2faEnabled":"This account is secured by two-factor authentication.","ui.user-manager.2faDisabled":"This account is insecure due to missing two-factor authentication.","ui.user-manager.passkey":"Passkey","ui.user-manager.passkeyTitle":"This account is secured by a Passkey.","ui.totp.headline":"İki adımlı doğrulama","ui.totp.setupQr":"Lütfen kare kodu iki adımlı doğrulama uygulamanızla tarayın.","ui.totp.setupCode":"Kare kodu tarayamıyorsanız şu anahtarı yazabilirsiniz:","ui.totp.codeLabel":"Doğrulama kodu","ui.totp.codeDescription":"Lütfen iki adımlı doğrulama uygulamanızın ürettiği doğrulama kodunu yazın.","ui.totp.disableText":"İki adımlı doğrulamayı kapatmak için lütfen doğrulama kodunu yazın.","ui.totp.invalid":"Doğrulama kodu geçersiz.","ui.totp.enable":"Etkinleştir","ui.totp.disable":"Etkisizleştir","ui.totp.cancel":"İptal","ui.totp.enabled":"İki adımlı doğrulama açıldı.","ui.totp.disabled":"İki adımlı doğrulama kapatıldı.","ui.totp.setup":"İki adımlı doğrulamayı kur","ui.totp.skip":"İki adımlı doğrulamayı atla"}')}}]);"use strict";(self["webpackChunkcontao_manager"]=self["webpackChunkcontao_manager"]||[]).push([[606],{2225:function(e){e.exports=JSON.parse('{"ui.app.httpsHeadline":"!! Ligação Insegura !!","ui.app.httpsDescription":"Sem recurso a HTTPS os seus dados confidenciais serão transferidos sem encriptação.","ui.app.httpsLink":"Mais info","ui.app.httpsHref":"https://https.cio.gov/everything/","ui.app.safeModeHeadline":"!! Modo Guardar activado !!","ui.app.safeModeDescription":"Algumas características do Gestor de Contacto não estão disponíveis.","ui.app.safeModeExit":"Sair do modo seguro","ui.app.limitedHeadline":"Autenticação remota","ui.app.limitedDescription":"You have limited permissions due to passwordless login.","ui.app.limitedLogout":"Re-authenticate","ui.app.totpHeadline":"Security Notice","ui.app.totpDescription":"Configure two-factor authentication now to secure your account.","ui.app.totpSetup":"Configuração","ui.app.loading":"A iniciar o Contao Manager ...","ui.app.apiError":"API status não esperado -erro","ui.app.configSecurity1":"ALERTA DE SEGURANÇA!!! Directório de configuração sem protecção detectado","ui.app.configSecurity2":"O Contao Manager detetou que os seus ficheiros de configuração estão acessíveis publicamente. Todas as operações estão desativadas até que o directório esteja seguro, caso contrário um atacante poderá aceder a informações sensíveis sobre a sua instalação.\\n\\nPara corrigir esta situação, certifique-se que previne o acesso ao directório \\"contao-manager\\" no seu servidor. Para saber como o fazer, consulte o manual do seu webserver ou contacte o fornecedor de alojamento web.","ui.account.welcome":"Bem Vindo","ui.account.intro1":"Bem-vindo ao Contao Manager, uma ferramenta universal para instalar e gerir o Contao Open Source CMS. Se é novo nele, por favor {readTheManualToGetStarted}.","ui.account.introGetStarted":"{readTheManual} para começar","ui.account.introManual":"ler o manual","ui.account.intro2":"Se encontrar algum problema, verifique {ourGithubIssues} e sinta-se à vontade para criar um novo para qualquer coisa que ainda não tenha sido relatada.","ui.account.introIssues":"as nossas edições GitHub","ui.account.headline":"Utilizador","ui.account.description":"Para gerir a sua instalação, por favor crie uma conta para utilizar no Contao Manager. Certifique-se que é distinta da conta utilizada no Contao back e front end.","ui.account.username":"Utilizador","ui.account.password":"Senha","ui.account.passwordPlaceholder":"min. 8 caracteres","ui.account.passwordLength":"Por favor utilize o minimo de 8 caracteres.","ui.account.loginInvalid":"There was an error when creating the account. Please try a different username.","ui.account.submit":"Criar Conta","ui.account.usePassword":"Use password for login","ui.account.usePasskey":"Use Passkey for login","ui.account.totpHeadline":"Two-factor authentication","ui.account.totpDescription":"Please enable two-factor authentication, which adds an extra layer of security to your account. In addition to your username and password, you will need to enter a verification code generated by a two-factor app such as 1Password, Authy, Google Authenticator, Microsoft Authenticator, LastPass Authenticator or any other TOTP app.","ui.account.totpSetup":"Configure now","ui.account.totpSkip":"Configure later","ui.account.login":"Decline Invitation","ui.account.contribute1":"O Contao e o Contao Manager são patrocinados pela Associação Contao sem fins lucrativos.","ui.account.contribute2":"Por favor, considere contribuir para o código aberto por {donate}.","ui.account.contributeDonate":"fazer um donativo","ui.login.headline":"Iniciar sessão","ui.login.description":"Iniciar sessão para gerir a sua instalação.","ui.login.username":"Utilizador","ui.login.password":"Senha","ui.login.totpHeadline":"Two-factor authentication","ui.login.totpDescription":"Please enter your verification code to complete the login process.","ui.login.totp":"Verification code","ui.login.forgotPassword":"Esqueceu a sua senha?","ui.login.button":"Iniciar sessão","ui.login.passkey":"Sign In with Passkey","ui.login.cancel":"Cancelar","ui.login.or":"or","ui.login.locked":"O acesso foi negado porque o Gestor de Contacto está bloqueado. Para desbloquear, apagar o ficheiro {lockFile} no directório raiz do seu Contao.","ui.logout.headline":"Tempo de Sessão expirado.","ui.logout.warning":"Esteve inactivo por mais de 25 minutos. Por razões de segurança a sua sessão será terminada em breve.","ui.logout.expired":"A sua sessão foi terminada automaticamente porque esteve inactivo por mais de 30 minutos.","ui.logout.renew":"Manter sessão ativa","ui.logout.logout":"Terminar Sessão","ui.logout.login":"Voltar para inicio de sessão","ui.oauth.error":"Tentativa OAuth inválida. Verifique os parâmetros pedidos.","ui.oauth.https":"O redireccionamento do URI DEVE utilizar um protocolo seguro (https:) para evitar que o símbolo de autenticação seja transmitido em texto claro.","ui.oauth.headline":"Autenticação remota","ui.oauth.description":"A seguinte aplicação ou serviço está a solicitar acesso remoto ao Contao Manager.","ui.oauth.domain":"Antes de permitir o acesso, certifique-se de que conhece este URL e confie no seu proprietário!","ui.oauth.outOfScope":"Unfortunately, you do not have the necessary permissions to grant this access.","ui.oauth.allow":"Permitir Acesso","ui.oauth.deny":"Negar Acesso","ui.oauth.switchUser":"Switch User","ui.scope.admin":"Admin access including user management","ui.scope.install":"Install new packages and change Contao configuration","ui.scope.update":"Update packages and execute maintenance tasks","ui.scope.read":"Read packages and configuration","ui.boot.headline":"Verificar Sistema","ui.boot.description":"Por favor espere, estamos a analisar o seu servidor...","ui.boot.issue1":"Problemas com a instalação detectados","ui.boot.issue2":"A sua instalação tem problemas que têm de ser resolvidos antes que o Gestor de Contacto possa ser utilizado.","ui.boot.run":"Iniciar o Contao Manager","ui.boot.safeMode":"Executar em Modo de Segurança","ui.recovery.headline":"Recuperação de Sistema","ui.recovery.description":"O Contao Manager detectou ficheiros que podem pertencer ao Contao, mas a linha de comandos não funciona como previsto.","ui.recovery.console":"Saída da Consola","ui.recovery.repairOptions":"Por favor escolha uma opção para reparar a sua instalação.","ui.recovery.repairHeadline":"Reparação Automática","ui.recovery.repairDescription":"Efectua uma tentativa de reparar automaticamente a instalação ao reconstruir a cache da aplicação e reinstalando os pacotes Composer.","ui.recovery.repairWarning":"Quaisquer modificações aos ficheiros vendor poderão ser apagadas durante o processo!","ui.recovery.repairFailed":"A reparação automática não teve sucesso. Usar o modo de segurança para reparar manualmente a instalação poderá resolver o problema.","ui.recovery.repairButton":"Executar Reparação de Sistema","ui.recovery.safeModeHeadline":"Modo de Segurança ","ui.recovery.safeModeDescription":"Executar o Contao Manager em Modo de Segurança permite gerir pacotes e correr tarefas de manutenção específicas, mas implementações que dependam de uma instalação Contao funcional não estarão disponíveis.","ui.recovery.safeModeButton":"Executar em Modo de Segurança","ui.server.pending":"Aguarde ...","ui.server.running":"A analisar ...","ui.server.error":"A verificação falhou devido a uma resposta inesperada do servidor.","ui.server.details":"Detalhes","ui.server.prerequisite":"A verificação falhou devido a um pré-requisito em falta.","ui.server.selfUpdate.title":"Actualizações Contao Manager","ui.server.selfUpdate.update":"Uma nova versão do Contao Manager {latest} está disponivel.","ui.server.selfUpdate.manualUpdate":"Está disponível uma nova versão do Contao Manager {latest}. O seu servidor não suporta actualizações automáticas, por favor descarregue a nova versão a partir de {download}.","ui.server.selfUpdate.latest":"Está a usar a versão mais recente {current}.","ui.server.selfUpdate.dev":"Versões de testes não suportam actualizações automáticas.","ui.server.selfUpdate.unsupported":"Uma nova versão está disponível mas não é  compatível com a sua versão de PHP.","ui.server.selfUpdate.button":"Executar Auto-Update","ui.server.selfUpdate.continue":"Continuar","ui.server.config.title":"Configuração do Servidor","ui.server.config.setup":"Configurar","ui.server.config.change":"Alterar","ui.server.config.save":"Guardar","ui.server.config.cancel":"Cancelar","ui.server.config.customOption":"Outros ...","ui.server.config.description":"Para executar correctamente as tarefas de fundo, o Gestor de Contacto precisa de saber onde encontrar o binário de linha de comando PHP e como executar comandos separados do processo web.","ui.server.config.formTitle":"Configuração do Servidor","ui.server.config.formText":"Por favor introduza o caminho para o seu binário PHP. Certifique-se que o seu binário usa a mesma versao PHP que o seu processo web.","ui.server.config.cloudTitle":"Composer Resolver Cloud","ui.server.config.cloudText":"A Composer Resolver Cloud permite instalar dependências Composer mesmo se o seu servidor não possuir memória local suficiente. Tenha em consideração que a sua informação de pacotes será transmitida para um servidor em nuvem mantido pela Contao Association.","ui.server.config.cloud":"Usar a Composer Resolver Cloud","ui.server.config.cli":"Binário PHP","ui.server.config.stateErrorCli":"Nenhum binário PHP válido foi encontrado no servidor. ","ui.server.config.stateErrorCloud":"A Composer Resolver Cloud não é suportada.","ui.server.config.stateSuccess":"Binário PHP em {php_cli}.","ui.server.php_web.title":"Processo Web PHP","ui.server.php_web.below7":"Encontrada a versão {version} PHP. Actualize para a versão PHP 7 assim que possivel!","ui.server.php_web.success":"Encontrada a versão PHP {version}, nenhum problema a reportar.","ui.server.php_cli.title":"Interface PHP Linha de Comandos","ui.server.php_cli.success":"Encontrada a versão PHP {version}, nenhum problema a reportar.","ui.server.composer.title":"Ambiente Composer","ui.server.composer.success":"Nenhum problema encontrado.","ui.server.composer.install":"Dependências Composer não instaladas.","ui.server.composer.button":"Instalar","ui.server.contao.title":"Instalação Contao","ui.server.contao.setup":"Configuração","ui.server.contao.check":"Check database","ui.server.contao.empty":"Nenhuma instalação Contao foi encontrada.","ui.server.contao.old":"A versão {version} do Contao não é compatível com o Contao Manager,  actualize a sua instalação manualmente.","ui.server.contao.found":"Encontrado Contao com versão {version} (Versão API {api}).","ui.server.contao.connectionError":"Incapaz de se ligar ao servidor da base de dados.","ui.server.contao.connectionProblem":"Database problem found.","ui.server.contao.missingUser":"Conta administrativa não encontrada.","ui.setup.continue":"Continuar","ui.setup.manager":"Iniciar o Contao Manager","ui.setup.cancel":"Cancelar","ui.setup.welcome":"Bem Vindo","ui.setup.welcome1":"Este assistente irá levá-lo através dos passos necessários para configurar a sua instalação do CMS Contao Open Source.","ui.setup.welcome2":"If you have any questions, please find documentation, forums, a Slack channel and more on the {support} page.","ui.setup.support":"Apoio à Comunidade","ui.setup.start":"ComeceComece","ui.setup.complete":"Parabéns!","ui.setup.complete1":"Contao {version} has been installed successfully.","ui.setup.complete2":"To finish the setup process, please open the install tool to configure the database connection and create a back end user.","ui.setup.complete3":"You can now start to create your website in the Contao back end. If you need additional extensions, continue to the Contao Manager.","ui.setup.installTool":"Open the Install Tool","ui.setup.login":"Login to Contao","ui.setup.funding":"Free software is \\"free\\" as in \\"free speech\\", not as in \\"free beer\\". An Open Source project like Contao requires amounts of money that can\'t be raised by a single person or company.\\nIf you have a website or sell websites built with Contao, we would love to see you contribute back financially to the product your business relies upon.","ui.setup.fundingLink":"Learn more","ui.setup.document-root.headline":"Configuração do Webserver","ui.setup.document-root.warning":"Para instalar o Contao através do Contao Manager, é necessário fixar a raiz do documento no servidor web.","ui.setup.document-root.description1":"Contao uses a separate folder for public files, application files are installed in its parent folder. Contao cannot be installed if the folder structure is not correct or the folders are not empty.","ui.setup.document-root.description2":"Se não souber como configurar a raiz do seu documento, leia a documentação do Contacto ou contacte o seu fornecedor de alojamento.","ui.setup.document-root.documentation":"Ler a Documentação","ui.setup.document-root.conflictsTitle":"Directório de instalação não vazio","ui.setup.document-root.conflictsDirectory":"The root directory of your future Contao installation is not empty, we have found {count} file(s) that might be overwritten by the installation process. It is recommended to create an empty directory structure for Contao, but you can also remove the following files and check again if you are sure they are unused.","ui.setup.document-root.ignoreConflicts":"Quero instalar o Contao no directório dos não vazios. Compreendo que isto pode substituir quaisquer ficheiros existentes no meu espaço web.","ui.setup.document-root.check":"Check again","ui.setup.document-root.create":"Criar directórios","ui.setup.document-root.change":"Change directories","ui.setup.document-root.formTitle":"Configuração de directório","ui.setup.document-root.formText1":"O Contao Manager pode criar automaticamente uma nova estrutura de directório no servidor.","ui.setup.document-root.formText2":"Será necessário configurar manualmente a raiz do novo documento (por exemplo, através de um painel de administração de alojamento).","ui.setup.document-root.autoconfig":"Compreendo que tenho de alterar a configuração do meu servidor. Não configurar a raiz do documento irá quebrar o Contao Manager e expor os ficheiros de configuração (incluindo detalhes de conta e palavras-passe)!","ui.setup.document-root.directory":"Novo Directório","ui.setup.document-root.currentRoot":"Raiz do documento actual","ui.setup.document-root.newRoot":"Novo Documento Raiz","ui.setup.document-root.finish":"Directórios de configuração","ui.setup.document-root.publicDir":"Utilizar {dir} para ficheiros públicos (para Contao {version})","ui.setup.document-root.directoryInvalid":"Por favor, introduza um nome de directório válido.","ui.setup.document-root.directoryExists":"O directório alvo já existe. Por favor, introduza um nome diferente.","ui.setup.document-root.confirmation":"O Contao Manager criou com sucesso o directório necessário para a sua instalação de Contao. Tem agora de configurar a raiz do documento no seu servidor web. Não volte a carregar esta página até lá.","ui.setup.document-root.reload":"Recarregar Página","ui.setup.document-root.success":"The directory structure on your web server is set up correctly!","ui.setup.document-root.installingProjectDir":"Application files will be installed to {dir}.","ui.setup.document-root.installingPublicDir":"Public files will be installed to {dir}.","ui.setup.document-root.installedProjectDir":"Application files are installed in {dir}.","ui.setup.document-root.installedPublicDir":"Public files are installed in {dir}.","ui.setup.create-project.headline":"Instalação Contao","ui.setup.create-project.description":"Contao development follows the principle of {semver}, a new minor version is released every six months. The currently supported releases are:","ui.setup.create-project.semver":"Semantic Versioning","ui.setup.create-project.latestTitle":"Mais Recente","ui.setup.create-project.ltsTitle":"Suporte a Longo Prazo (LTS)","ui.setup.create-project.latestQ1":"Our latest version, offers the most features with support until February {year}.","ui.setup.create-project.latestQ3":"Our latest version, offers the most features with support until August {year}.","ui.setup.create-project.ltsText":"Our current LTS version, if you focus on stability. Offers long term support until February {year}.","ui.setup.create-project.pltsText":"The previous LTS version, still has long term support until February {year}.","ui.setup.create-project.requiresPHP":"Requires at least PHP {version}, you have PHP {current}.","ui.setup.create-project.releaseplan":"Ver o {contaoReleasePlan} para informações detalhadas.","ui.setup.create-project.releaseplanLink":"Plano de lançamento do Contao","ui.setup.create-project.installed":"Contao {version} is successfully installed on the server. Continue to set up your database or launch the Contao Manager to install a different version.","ui.setup.create-project.formTitle":"Select a distribution","ui.setup.create-project.formText":"Please choose which version should be installed.","ui.setup.create-project.version":"Versão","ui.setup.create-project.demo":"Install the Contao demo website","ui.setup.create-project.demoDescription":"The demo website helps you to get familiar with Contao and all of its core features. More themes can be found in the {store}.","ui.setup.create-project.coreOnly":"Instalação Mínima ( Apenas o \\"core\\")","ui.setup.create-project.noUpdate":"Ignorar Instalação (Utilizador avançado!)","ui.setup.create-project.theme":"Contao Theme","ui.setup.create-project.themeInstall":"To install a Contao theme, use the search input or upload a theme file (.cto/.zip) that supports installation through the Contao Manager.","ui.setup.create-project.themeBuy":"Make sure to visit the official {store}.","ui.setup.create-project.themeStore":"Contao Themes Store","ui.setup.create-project.themeUpload":"Upload theme file (.cto/.zip)","ui.setup.create-project.themeInvalid":"The uploaded file is not a Contao theme or does not support the Contao Manager.","ui.setup.create-project.themeWarning":"The Contao Manager cannot tell whether this theme is compatible with your server. Please check with the theme vendor if you have any questions.","ui.setup.create-project.themeTitle":"Review theme details","ui.setup.create-project.themeDetails":"The following dependencies and files will be installed with this theme.","ui.setup.create-project.themeRequire":"{count} Dependencies | {count} Dependencies","ui.setup.create-project.themeFiles":"{count} File | {count} Files","ui.setup.create-project.theme.or":"or search public themes","ui.setup.create-project.theme.search":"Search themes","ui.setup.create-project.theme.more":"More themes","ui.setup.create-project.theme.empty":"No themes matching {query}","ui.setup.create-project.theme.uploaded":"The theme file was uploaded successfully.","ui.setup.create-project.theme.packageName":"Package name","ui.setup.create-project.theme.version":"Versão","ui.setup.create-project.theme.authors":"Author(s)","ui.setup.create-project.install":"Instalar","ui.setup.create-project.cancel":"Cancelar","ui.setup.database-connection.headline":"Database Connection","ui.setup.database-connection.description":"Contao requires a MySQL database (or a compatible fork like MariaDB) to store pages, content, users and other relational data. Connection parameters are stored in the {env} file in the project root of your Contao installation.","ui.setup.database-connection.formTitle":"Connection Parameters","ui.setup.database-connection.formText":"Enter a database URL or fill in the username, password, server and database fields separately.","ui.setup.database-connection.url":"Database URL","ui.setup.database-connection.validUrl":"Database URL is invalid or connection to server failed.","ui.setup.database-connection.or":"or","ui.setup.database-connection.user":"Utilizador","ui.setup.database-connection.password":"Senha","ui.setup.database-connection.server":"Server (:Port)","ui.setup.database-connection.database":"Database Name","ui.setup.database-connection.connected":"Successfully connected to database {database} on {server}.","ui.setup.database-connection.error":"Error connecting to the database.","ui.setup.database-connection.problem":"Contao has detected a problem with your database server.","ui.setup.database-connection.schemaTitle":"Database Schema","ui.setup.database-connection.migration":"There is one pending migration. | There are {count} pending migrations.","ui.setup.database-connection.schema":"There is one pending schema update. | There are {count} pending schema updates.","ui.setup.database-connection.noChanges":"Your database schema is up to date.","ui.setup.database-connection.check":"Check database","ui.setup.database-connection.skip":"Skip","ui.setup.database-connection.save":"Guardar","ui.setup.database-connection.change":"Change credentials","ui.setup.database-connection.restoreTitle":"Database Import","ui.setup.database-connection.restoreText":"The theme you just installed contains a database backup. Restore the database to import theme data or skip this step to start with a blank Contao installation. | The theme you just installed contains multiple database backups. Select a backup file to import theme data or skip this step to start with a blank Contao installation.","ui.setup.database-connection.backup":"Backup current database before import","ui.setup.database-connection.backupWarning":"All data in database will be overwritten on import! Create a backup first if the database is not empty.","ui.setup.database-connection.restore":"Import theme database","ui.setup.database-connection.restoreOption":"Backup from {date} ({size})","ui.setup.database-connection.restored":"Your theme database was successfully imported. Continue to validate your database schema.","ui.setup.backend-user.success":"An admin account for the Contao back end was found in your database. Use the Contao back end to add more users.","ui.setup.backend-user.error":"Unable to retrieve user list. Check the console output for details.","ui.setup.backend-user.headline":"Backend Account","ui.setup.backend-user.description":"To manage your website, you need to have at least one admin account for the Contao back end. Be aware that this account is not related to the Contao Manager.","ui.setup.backend-user.formTitle":"Criar Conta","ui.setup.backend-user.formText":"Please enter the details for the new back end account.","ui.setup.backend-user.username":"Utilizador","ui.setup.backend-user.name":"Name","ui.setup.backend-user.email":"E-mail address","ui.setup.backend-user.emailInvalid":"Please enter a valid e-mail address","ui.setup.backend-user.password":"Senha","ui.setup.backend-user.passwordPlaceholder":"min. 8 caracteres","ui.setup.backend-user.passwordLength":"Por favor utilize o minimo de 8 caracteres.","ui.setup.backend-user.create":"Add account","ui.task.headline":"Tarefa de fundo","ui.task.loading":"Carregamento de detalhes ...","ui.task.created":"Carregamento de detalhes ...","ui.task.active":"Por favor aguarde enquanto o Gestor de Contacto está a executar operações de tarefas em segundo plano.","ui.task.complete":"Todas as operações são concluídas com sucesso. Verifique a saída da consola para mais detalhes.","ui.task.aborting":"Por favor aguarde enquanto as operações de fundo estão a ser canceladas.","ui.task.stopped":"Algumas operações de fundo foram canceladas. Por favor, verifique a saída da consola.","ui.task.error":"Uma operação de fundo parou inesperadamente. Por favor, verifique a saída da consola.","ui.task.failed":"O Gestor de Contao não conseguiu iniciar uma tarefa de fundo!","ui.task.failedDescription1":"Alguma coisa correu mal ao tentar executar operações em segundo plano.","ui.task.failedDescription2":"Se isto acontecer novamente, o seu servidor poderá não ser suportado.","ui.task.reportProblem":"Reportar um Problema","ui.task.sponsor":"Composer Cloud sponsored by {sponsor}","ui.task.buttonAudit":"Actualizar base de dados ","ui.task.buttonClose":"Fechar","ui.task.buttonConfirm":"Confirmar e Fechar","ui.task.buttonCancel":"Cancelar","ui.task.confirmCancel":"Tem a certeza que pretende interromper esta tarefa? Poderá afectar a instalação do Contao negativamente!","ui.task.autoclose":"Detalhes sobre o sucesso da tarefa","ui.console.toggle":"Mostrar/Esconder saída de Consola","ui.console.showLog":"Mostrar registo completo da consola","ui.console.copyLog":"Copiar log para prancheta","ui.migrate.headline":"Database Updates","ui.migrate.migrationsOnly":"(migrations only)","ui.migrate.schemaOnly":"(schema only)","ui.migrate.loading":"Please wait, we are checking your database …","ui.migrate.empty":"No pending migrations or schema updates found. Your database is up to date.","ui.migrate.emptyMigrations":"No pending migrations found. Make sure to also check for schema updates.","ui.migrate.emptySchema":"No pending schema updates found. Make sure to also check for migrations.","ui.migrate.pending":"Your database is not up to date. Please review the console output below and execute the changes.","ui.migrate.previousChanges":"A previous database migration was not confirmed.\\nPlease review the console output below, then continue to see the next changes.","ui.migrate.previousComplete":"A previous database migration was not confirmed, please review the console output below.\\nThere are no more pending changes.","ui.migrate.appliedChanges":"Database updates have been applied.\\nPlease review the console output below, then continue to see the next changes.","ui.migrate.appliedComplete":"Database updates have been applied.\\nThere are no more pending migrations or schema updates. Your database is up to date.","ui.migrate.problem":"Contao has detected a problem with your database server.\\nPlease review the console output below to find out what needs to be fixed. | Contao has detected problems with your database server.\\nPlease review the console output below to find out what needs to be fixed.","ui.migrate.warning":"Contao has detected a misconfiguration of your database server.\\nWarnings can be skipped temporarily, but should be fixed for optimal performance and data integrity.","ui.migrate.error":"The changes could not be applied. Your database might have been changed, please check again to retry.","ui.migrate.execute":"Execute","ui.migrate.close":"Fechar","ui.migrate.confirm":"Confirmar e Fechar","ui.migrate.cancel":"Cancelar","ui.migrate.continue":"Continuar","ui.migrate.setup":"Configuração","ui.migrate.skip":"Skip","ui.migrate.retry":"Check again","ui.migrate.retryAll":"Check all","ui.migrate.withDeletes":"Execute all database changes including DROP queries.","ui.migrate.migrationTitle":"Database Migrations","ui.migrate.schemaTitle":"Schema Updates","ui.migrate.problemTitle":"Database Problems","ui.migrate.warningTitle":"Database Warnings","ui.migrate.addTable":"Add table {table}","ui.migrate.dropTable":"Drop table {table}","ui.migrate.addField":"Add field {table}.{field}","ui.migrate.changeField":"Change field {table}.{field}","ui.migrate.dropField":"Drop field {table}.{field}","ui.migrate.createIndex":"Create index \\"{name}\\" on {table}","ui.migrate.dropIndex":"Drop index \\"{name}\\" on {table}","ui.widget.mandatory":"Este campo não pode estar vazio.","ui.widget.blankOption":"Por favor seleccione ...","ui.widget.showPassword":"Show password","ui.widget.hidePassword":"Hide password","ui.error.title":"O pedido HTTP de \\"{method} {url}\\" falhou.","ui.error.server500":"Parece que ocorreu um erro inesperado no seu servidor. Por favor verifique os ficheiros de registo do seu servidor web (Apache/Nginx) e os registos do Contao Manager em \\"Contao-manager/logs\\".","ui.error.response":"O servidor devolveu uma resposta com o código de estado {status}.","ui.error.moreLink":"Mais informação ","ui.error.support":"Contao Support","ui.error.permission":"You do not have permission to use this feature.","ui.footer.help":"Ajuda","ui.footer.reportProblem":"Reportar um Problema","ui.navigation.discover":"Descubra","ui.navigation.packages":"Pacotes","ui.navigation.tools":"Ferramentas","ui.navigation.installTool":"Ferramenta de Instalação","ui.navigation.backend":"Backend Contao","ui.navigation.debug":"Depuração Contao","ui.navigation.logViewer":"Log Viewer","ui.navigation.phpinfo":"Informação PHP","ui.navigation.phpinfoLoading":"Carregamento de informação PHP","ui.navigation.maintenance":"Manutenção","ui.navigation.rebuildCache":"Reconstruir Cache","ui.navigation.users":"Accounts","ui.navigation.systemCheck":"Verificar Sistema","ui.navigation.advanced":"Avançado","ui.navigation.logout":"Terminar Sessão","ui.maintenance.database.title":"Database Migrations and Backups","ui.maintenance.database.description":"Database migrations ensure consistent data and table schemas.","ui.maintenance.database.migrations":"One pending database migration | {count} pending database migrations","ui.maintenance.database.schemaUpdates":"One pending schema update | {count} pending schema updates","ui.maintenance.database.error":"Database problem found.","ui.maintenance.database.warning":"Database warnings found.","ui.maintenance.database.button":"Check database","ui.maintenance.database.migrationOnly":"Check migrations only","ui.maintenance.database.schemaOnly":"Check schema only","ui.maintenance.database.installTool":"Open Install Tool","ui.maintenance.database.createBackup":"Create Backup","ui.maintenance.database.backupUnsupported":"Database backups are not supported by your Contao version.","ui.maintenance.database.backupList":"You have one database backup, created on {date}. | You have {count} database backups, the latest one was created on {date}.","ui.maintenance.database.backupEmpty":"You currently have no database backups.","ui.maintenance.rebuildCache.title":"Cache de Aplicação","ui.maintenance.rebuildCache.description":"Reconstruir a cache da aplicação é necessário após modificar quaisquer dos ficheiros de configuração.","ui.maintenance.rebuildCache.rebuildProd":"Reconstruir Cache de Produção","ui.maintenance.rebuildCache.rebuildDev":"Reconstruir Cache Desenvolvimento","ui.maintenance.rebuildCache.clearProd":"Limpar Cache Produção","ui.maintenance.rebuildCache.clearDev":"Limpar Cache Desenvolvimento","ui.maintenance.installTool.title":"Ferramenta de Instalação do Contao","ui.maintenance.installTool.description":"A Ferramenta de Instalação do Contao bloqueia automaticamente caso a senha seja introduzida erradamente três vezes.","ui.maintenance.installTool.unlock":"Desbloquear ferramenta de instalação","ui.maintenance.installTool.lock":"Bloquear ferramenta de instalação","ui.maintenance.dumpAutoload.title":"Carregador de Classes Composer","ui.maintenance.dumpAutoload.description":"O Composer autoloader é responsável por carregar classes PHP. O autoloader tem que ser \\"dumped\\" após adicionar namespaces personalizados ao root compser.json .","ui.maintenance.dumpAutoload.button":"Dump Autoloader","ui.maintenance.composerInstall.title":"Dependências Composer ","ui.maintenance.composerInstall.description":"As dependências dos Composer estão localizadas na pasta {vendor} na raiz da sua aplicação. A reinstalação das dependências pode ser necessária após manipulação ou carregamento manual do ficheiro {composerLock}.","ui.maintenance.composerInstall.button":"Executar Instalador","ui.maintenance.composerInstall.update":"Executar Actualizador Composer","ui.maintenance.composerCache.title":"Cache Composer","ui.maintenance.composerCache.description":"O Composer guarda cache de pacotes provenientes de download para melhor performance. Caso tenha problemas com ficheiros não funcionais, apagar a Composer cache para forçar um novo download poderá resolver o problema.","ui.maintenance.composerCache.button":"Apagar Cache","ui.maintenance.maintenanceMode.title":"Modo Manutenção","ui.maintenance.maintenanceMode.description":"Colocar o Contao em modo de manutenção exibirá um modelo \\"503 Serviço Indisponível\\" para o website.","ui.maintenance.maintenanceMode.enable":"Activar","ui.maintenance.maintenanceMode.disable":"Desactivar","ui.maintenance.debugMode.title":"Modo Depuração","ui.maintenance.debugMode.description":"Activar o modo de depuração definindo um utilizador e uma palavra-passe para o ponto de entrada {appDevPhp}.","ui.maintenance.debugMode.descriptionJwt":"Active o modo de depuração ao definir o cookie de depuração para o domínio corrente.","ui.maintenance.debugMode.activate":"Activar","ui.maintenance.debugMode.deactivate":"Desactivar","ui.maintenance.debugMode.credentials":"Credenciais","ui.maintenance.debugMode.user":"Por favor introduza um nome de utilizador para o modo de depuração.","ui.maintenance.debugMode.password":"Por favor introduza uma senha para o modo de depuração.","ui.maintenance.opcodeCache.title":"Cache Opcode","ui.maintenance.opcodeCache.description":"O Opcode efectua cache de ficheiros PHP no processo web para mais rápida execução. Deverá ser apagado dentro de certas  circunstâncias caso ficheiros não sejam reconhecidos após edição.","ui.maintenance.opcodeCache.button":"Truncar Cache","ui.maintenance.safeMode":"Nao disponível em Modo Segurança","ui.maintenance.unsupported":"Não suportado pela sua versão Contao","ui.packages.updateButton":"Actualizar Pacotes","ui.packages.searchButton":"Procurar Pacotes","ui.packages.searchPlaceholder":"Procurar Pacotes ...","ui.packages.uploadOverlay":"Arrastar e largar ficheiros para upload","ui.packages.uploadButton":"Carregar Packages","ui.packages.uploadMessage":"Tem um carregamento não confirmado. | Tem {count} uploads não confirmados.","ui.packages.uploadApply":"Confirmar Uploads","ui.packages.uploadReset":"Apagar Uploads","ui.packages.uploadIncomplete":"Este ficheiro não foi uploaded completamente. Por favor remova-o e tente novamente.","ui.packages.uploadDuplicate":"Este ficheiro aparenta ter sido uploaded  várias vezes. Por favor remova os duplicados.","ui.packages.uploadInstalled":"Este ficheiro já se encontra instalado. Por favor remova os duplicados.","ui.packages.uploadUnsupported":"Uploads are not supported in your installation. Please make sure that the PHP ZIP extension is installed and update your dependencies.","ui.packages.changesMessage":"Tem uma alteração não confirmada. | Tem {count} alterações não confirmadas.","ui.packages.changesDryrun":"Dry Run","ui.packages.changesApply":"Aplicar Alterações","ui.packages.changesApplyAll":"Actualizar todos os pacotes","ui.packages.changesDryrunAll":"Funcionamento a seco todos os pacotes","ui.packages.changesReset":"Reverter Alterações","ui.packages.changesReview":"Rever Alterações","ui.packagelist.loading":"A Carregar ...","ui.packagelist.uploads":"Uploads","ui.packagelist.added":"Novos pacotes","ui.packagelist.installed":"Pacotes instalados","ui.package.hintRevert":"Reverter Alterações","ui.package.hintNoupdate":"Não actualizar","ui.package.hintConstraint":" Este pacote será instalado com limitações de entrada {constraint} quando aplicar alterações.","ui.package.hintConstraintBest":"Este pacote será instalado com a melhor versão disponível quando aplicar alterações.","ui.package.hintConstraintChange":"As limitações de entrada para este pacote serão alteradas de \\"{from}\\" para \\"{to}\\" quando  aplicar alterações.","ui.package.hintConstraintUpdate":"Este pacote será actualizado quando aplicar alterações. ","ui.package.hintAdded":"Este pacote vai ser instalado quando aplicar as alterações.","ui.package.hintRemoved":"Este pacote será removido quando aplicar alterações.","ui.package.requiredTitle":"manualmente adicionado","ui.package.requiredText":"Este pacote é requerido pelo seu composer.json mas não está instalado.","ui.package.removedTitle":"manualmente removido","ui.package.removedText":"Este pacote vai ser removido do seu composer.json.","ui.package.installed":"Actualmente instalado:","ui.package.version":"Versão {version}","ui.package.additionalDownloads":"{count} Descarregar | {count} Descarregar","ui.package.additionalStars":"{count} Estrela | {count} Estrelas","ui.package.editConstraint":"Editar","ui.package.uploadConstraint":"Esta restrição está definida pelo pacote que foi uploaded.","ui.package.updateButton":"Actualizar","ui.package.removeButton":"Remover","ui.package.installButton":"Adicionar Pacote","ui.package.installButtonShort":"Adicionar","ui.package.detailsButton":"Detalhes","ui.package.latestConstraint":"versão mais recente","ui.package.update":"Actualização disponível","ui.package.updateLatest":"versão mais recente","ui.package.updateAvailable":"{version} disponível","ui.package.updateUnknown":"versão desconhecida","ui.package.updateConstraint":"A newer version outside your version constraint is available.","ui.package.incompatible":"{package} does not work with Contao {constraint}.","ui.cloudStatus.headline":"Composer Resolver Cloud","ui.cloudStatus.version":"Versão {version}","ui.cloudStatus.waitingTime":"Tempo de Espera","ui.cloudStatus.jobs":"Tarefas Actuais","ui.cloudStatus.workers":"Trabalhadores","ui.cloudStatus.approx":"{minutes} min","ui.cloudStatus.none":"nenhum","ui.cloudStatus.short":"ca. {minutes} min","ui.cloudStatus.long":"ca. {minutes} min {seconds} seg","ui.cloudStatus.error":"Incapaz de obter o estatuto de Composer Resolver Cloud. Pode ser para questões de manutenção ou de experiência.","ui.cloudStatus.button":"Estado das nuvens","ui.cloudStatus.refresh":"Actualizar o estado das nuvens","ui.log-viewer.loading":"A Carregar ...","ui.log-viewer.empty":"There are no log files on your server.","ui.log-viewer.reload":"Reload","ui.log-viewer.file":"Log file","ui.log-viewer.channel":"Channel","ui.log-viewer.channelTitle":"The channel this message was logged to.","ui.log-viewer.level":"Level","ui.log-viewer.levelTitle":"Severity of the log message.","ui.log-viewer.timeHeader":"Time","ui.log-viewer.messageHeader":"Message","ui.log-viewer.showContext":"Show Context","ui.log-viewer.hideContext":"Hide Context","ui.log-viewer.showExtra":"Show Extra","ui.log-viewer.hideExtra":"Hide Extra","ui.log-viewer.more":"Load more …","ui.log-viewer.download":"Download","ui.log-viewer.downloadTitle":"Download file \\"{file}\\"","ui.log-viewer.prodEnvironment":"Production Environment","ui.log-viewer.devEnvironment":"Development Environment (Debug Mode)","ui.user-manager.loading":"Loading users …","ui.user-manager.changePassword":"Change Password","ui.user-manager.setupTotp":"Setup Two-Factor Authentication","ui.user-manager.disableTotp":"Disable Two-Factor Authentication","ui.user-manager.invite":"Invite User","ui.user-manager.delete":"Delete","ui.user-manager.deleteConfirm":"Do you really want to delete user \\"{username}\\"?","ui.user-manager.deleted":"User {username} deleted successfully","ui.user-manager.passwordHeadline":"Change Password","ui.user-manager.passwordText":"To change your password, please enter the current and a new password in the respective fields.","ui.user-manager.currentPassword":"Current password","ui.user-manager.newPassword":"New password","ui.user-manager.passwordPlaceholder":"min. 8 caracteres","ui.user-manager.submitPassword":"Submit","ui.user-manager.passwordChanged":"Your password has been changed successfully.","ui.user-manager.passwordError":"This password is incorrect.","ui.user-manager.inviteHeadline":"Invite User","ui.user-manager.inviteText":"If you need multiple logins for the Contao Manager, you can create an invitation link here. Share this link with someone or use it on another device to create a new account with the given permissions.","ui.user-manager.inviteSuccess1":"A new invitation link was created. The URL below can be used to create a new user account for this Contao Manager. The invitation expires on {expires} (one week from now).","ui.user-manager.inviteSuccess2":"Please copy the link to your clipboard. It will only work once and you will not be able to see it again after closing this dialog.","ui.user-manager.createInvitation":"Create Invitation Link","ui.user-manager.clipboard":"Copy to clipboard","ui.user-manager.permissions":"Learn about permissions","ui.user-manager.cancel":"Cancelar","ui.user-manager.close":"Fechar","ui.user-manager.you":"You","ui.user-manager.2fa":"2FA","ui.user-manager.2faEnabled":"This account is secured by two-factor authentication.","ui.user-manager.2faDisabled":"This account is insecure due to missing two-factor authentication.","ui.user-manager.passkey":"Passkey","ui.user-manager.passkeyTitle":"This account is secured by a Passkey.","ui.totp.headline":"Two-Factor Authentication","ui.totp.setupQr":"Please scan the QR code with your 2FA/TOTP app.","ui.totp.setupCode":"If you cannot scan the QR code, enter this key instead:","ui.totp.codeLabel":"Verification code","ui.totp.codeDescription":"Please enter the verification code generated by your 2FA/TOTP app.","ui.totp.disableText":"Please enter the verification code to disable two-factor authentication.","ui.totp.invalid":"The verification code is invalid.","ui.totp.enable":"Activar","ui.totp.disable":"Desactivar","ui.totp.cancel":"Cancelar","ui.totp.enabled":"Two-factor authentication was enabled successfully.","ui.totp.disabled":"Two-factor authentication was disabled successfully.","ui.totp.setup":"Setup Two-Factor Authentication","ui.totp.skip":"Skip Two-Factor Authentication"}')}}]);"use strict";(self["webpackChunkcontao_manager"]=self["webpackChunkcontao_manager"]||[]).push([[682],{7598:function(t,e,o){o.r(e),o.d(e,{default:function(){return wt}});var s=o(641),i=o(33),r=o.p+"img/boot.92149bf5.svg";const a={class:"view-boot__header"},n={class:"view-boot__headline"},c={class:"view-boot__description"},u={key:0,class:"view-boot__checks"},h={key:0,class:"view-boot__summary view-boot__summary--error"},l={class:"view-boot__issue"},d={class:"view-boot__issue"},p={key:1,class:"view-boot__summary"},b={key:2,class:"view-boot__summary"},v=["disabled"],g={key:1,class:"view-boot__loading"};function m(t,e,o,m,f,w){const k=(0,s.g2)("boot-php-web"),_=(0,s.g2)("boot-config"),$=(0,s.g2)("boot-php-cli"),S=(0,s.g2)("boot-self-update"),y=(0,s.g2)("boot-composer"),C=(0,s.g2)("boot-contao"),L=(0,s.g2)("loading-spinner"),A=(0,s.g2)("boxed-layout");return(0,s.uX)(),(0,s.Wv)(A,{wide:!0,slotClass:"view-boot"},{default:(0,s.k6)((()=>[(0,s.Lk)("header",a,[e[9]||(e[9]=(0,s.Lk)("img",{src:r,width:"80",height:"80",alt:"",class:"view-boot__icon"},null,-1)),(0,s.Lk)("h1",n,(0,i.v_)(t.$t("ui.boot.headline")),1),(0,s.Lk)("p",c,(0,i.v_)(t.$t("ui.boot.description")),1)]),t.tasksInitialized?((0,s.uX)(),(0,s.CE)("main",u,[(0,s.Lk)("div",null,[(0,s.bF)(k,{ready:w.canShow("PhpWeb"),onResult:e[0]||(e[0]=function(){for(var t=arguments.length,e=new Array(t),o=0;o<t;o++)e[o]=arguments[o];return w.result("PhpWeb",...e)})},null,8,["ready"]),(0,s.bF)(_,{ready:w.canShow("Config"),onResult:e[1]||(e[1]=function(){for(var t=arguments.length,e=new Array(t),o=0;o<t;o++)e[o]=arguments[o];return w.result("Config",...e)})},null,8,["ready"]),(0,s.bF)($,{ready:w.canShow("PhpCli"),onResult:e[2]||(e[2]=function(){for(var t=arguments.length,e=new Array(t),o=0;o<t;o++)e[o]=arguments[o];return w.result("PhpCli",...e)})},null,8,["ready"]),t.isGranted(w.scopes.UPDATE)?((0,s.uX)(),(0,s.Wv)(S,{key:0,ready:w.canShow("SelfUpdate"),onResult:e[3]||(e[3]=function(){for(var t=arguments.length,e=new Array(t),o=0;o<t;o++)e[o]=arguments[o];return w.result("SelfUpdate",...e)})},null,8,["ready"])):(0,s.Q3)("",!0),w.isOAuth?(0,s.Q3)("",!0):((0,s.uX)(),(0,s.Wv)(y,{key:1,ready:w.canShow("Composer"),onResult:e[4]||(e[4]=function(){for(var t=arguments.length,e=new Array(t),o=0;o<t;o++)e[o]=arguments[o];return w.result("Composer",...e)})},null,8,["ready"])),w.isOAuth?(0,s.Q3)("",!0):((0,s.uX)(),(0,s.Wv)(C,{key:2,ready:w.canShow("Contao"),onResult:e[5]||(e[5]=function(){for(var t=arguments.length,e=new Array(t),o=0;o<t;o++)e[o]=arguments[o];return w.result("Contao",...e)})},null,8,["ready"]))]),e[11]||(e[11]=(0,s.Lk)("div",{class:"clearfix"},null,-1)),w.hasError?((0,s.uX)(),(0,s.CE)("div",h,[e[10]||(e[10]=(0,s.Lk)("svg",{height:"24",viewBox:"0 0 24 24",width:"24",xmlns:"http://www.w3.org/2000/svg"},[(0,s.Lk)("path",{d:"M0 0h24v24H0z",fill:"none"}),(0,s.Lk)("path",{d:"M12 2C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm1 15h-2v-2h2v2zm0-4h-2V7h2v6z"})],-1)),(0,s.Lk)("h1",l,(0,i.v_)(t.$t("ui.boot.issue1")),1),(0,s.Lk)("p",d,(0,i.v_)(t.$t("ui.boot.issue2")),1),t.safeMode?((0,s.uX)(),(0,s.CE)("button",{key:0,onClick:e[6]||(e[6]=function(){return w.runSafeMode&&w.runSafeMode(...arguments)}),class:"widget-button widget-button--warning view-boot__safeMode"},(0,i.v_)(t.$t("ui.boot.safeMode")),1)):(0,s.Q3)("",!0)])):t.safeMode?((0,s.uX)(),(0,s.CE)("div",p,[(0,s.Lk)("button",{onClick:e[7]||(e[7]=function(){return w.runSafeMode&&w.runSafeMode(...arguments)}),class:"widget-button widget-button--warning view-boot__safeMode"},(0,i.v_)(t.$t("ui.boot.safeMode")),1)])):w.autoContinue?(0,s.Q3)("",!0):((0,s.uX)(),(0,s.CE)("div",b,[(0,s.Lk)("button",{onClick:e[8]||(e[8]=function(){return w.finish&&w.finish(...arguments)}),class:"widget-button widget-button--primary view-boot__continue",disabled:!w.canContinue},(0,i.v_)(t.$t("ui.boot.run")),9,v)]))])):((0,s.uX)(),(0,s.CE)("main",g,[(0,s.bF)(L)]))])),_:1})}var f=o(6278),w=o(70),k=o(707),_=o(3723),$=o(5404),S=o(4999);const y=["href"];function C(t,e,o,r,a,n){const c=(0,s.g2)("boot-check");return(0,s.uX)(),(0,s.Wv)(c,{progress:t.bootState,title:t.$t("ui.server.php_web.title"),description:t.bootDescription,detail:t.problem&&t.problem.detail},{default:(0,s.k6)((()=>[t.problem&&t.problem.type?((0,s.uX)(),(0,s.CE)("a",{key:0,href:t.problem.type,target:"_blank"},(0,i.v_)(t.$t("ui.server.details")),9,y)):(0,s.Q3)("",!0)])),_:1},8,["progress","title","description","detail"])}var L={props:{ready:!1,current:!1},data:()=>({booted:!1,bootState:"loading",bootDescription:""}),watch:{ready(t){t&&(this.booted=!0,this.boot())}},created(){this.bootDescription=this.$t("ui.server.pending"),this.ready&&(this.booted=!0,this.boot())}};const A={class:"boot-check"},D={key:1,class:"boot-check__icon boot-check__icon--success"},x={key:2,class:"boot-check__icon boot-check__icon--info"},E={key:3,class:"boot-check__icon boot-check__icon--warning"},X={key:4,class:"boot-check__icon boot-check__icon--error"},U={class:"boot-check__label"},O={class:"boot-check__title"},M={class:"boot-check__description"},P={key:0,class:"boot-check__detail"},j={class:"boot-check__action"};function z(t,e,o,r,a,n){const c=(0,s.g2)("loading-spinner");return(0,s.uX)(),(0,s.CE)("div",A,["loading"===o.progress?((0,s.uX)(),(0,s.Wv)(c,{key:0,class:"boot-check__icon"})):"success"===o.progress?((0,s.uX)(),(0,s.CE)("div",D,e[0]||(e[0]=[(0,s.Lk)("svg",{height:"24",viewBox:"0 0 24 24",width:"24",xmlns:"http://www.w3.org/2000/svg"},[(0,s.Lk)("circle",{cx:"12",cy:"12",r:"8",fill:"#fff"}),(0,s.Lk)("path",{d:"M12 2C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm-2 15l-5-5 1.41-1.41L10 14.17l7.59-7.59L19 8l-9 9z"})],-1)]))):"info"===o.progress||"action"===o.progress?((0,s.uX)(),(0,s.CE)("div",x,e[1]||(e[1]=[(0,s.Lk)("svg",{height:"24",viewBox:"0 0 24 24",width:"24",xmlns:"http://www.w3.org/2000/svg"},[(0,s.Lk)("circle",{cx:"12",cy:"12",r:"8",fill:"#fff"}),(0,s.Lk)("path",{d:"M12 2C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm1 15h-2v-6h2v6zm0-8h-2V7h2v2z"})],-1)]))):"warning"===o.progress?((0,s.uX)(),(0,s.CE)("div",E,e[2]||(e[2]=[(0,s.Lk)("svg",{xmlns:"http://www.w3.org/2000/svg",width:"24",height:"24",viewBox:"0 0 24 24"},[(0,s.Lk)("path",{d:"M5 19h15L12 5",fill:"#fff"}),(0,s.Lk)("path",{d:"M1 21h22L12 2 1 21zm12-3h-2v-2h2v2zm0-4h-2v-4h2v4z"})],-1)]))):((0,s.uX)(),(0,s.CE)("div",X,e[3]||(e[3]=[(0,s.Lk)("svg",{height:"24",viewBox:"0 0 24 24",width:"24",xmlns:"http://www.w3.org/2000/svg"},[(0,s.Lk)("circle",{cx:"12",cy:"12",r:"8",fill:"#fff"}),(0,s.Lk)("path",{d:"M12 2C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm1 15h-2v-2h2v2zm0-4h-2V7h2v6z"})],-1)]))),(0,s.Lk)("div",U,[(0,s.Lk)("h2",O,(0,i.v_)(o.title),1),(0,s.Lk)("p",M,[(0,s.RG)(t.$slots,"description",{},(()=>[(0,s.eW)((0,i.v_)(o.description),1)]))]),o.detail?((0,s.uX)(),(0,s.CE)("p",P,(0,i.v_)(o.detail),1)):(0,s.Q3)("",!0)]),(0,s.Lk)("div",j,[(0,s.RG)(t.$slots,"default")])])}var G={components:{LoadingSpinner:S.A},props:{title:String,description:String,detail:String,progress:{type:String,required:!0,validator:t=>-1!==["ready","loading","success","info","warning","error","action"].indexOf(t)}}},B=o(6262);const I=(0,B.A)(G,[["render",z]]);var W=I,Q={mixins:[L],components:{BootCheck:W},data:()=>({problem:{}}),methods:{async boot(){this.bootDescription=this.$t("ui.server.running");const t=await this.$store.dispatch("server/php-web/get");200===t.status?t.data.problem?(this.problem=t.data.problem,this.bootState="error",this.bootDescription=t.data.problem.title):t.data.version_id<7e4?(this.bootState="info",this.bootDescription=this.$t("ui.server.php_web.below7",t.data)):(this.bootState="success",this.bootDescription=this.$t("ui.server.php_web.success",t.data)):(this.bootState="error",this.bootDescription=this.$t("ui.server.error")),this.$emit("result",this.bootState)}}};const R=(0,B.A)(Q,[["render",C]]);var T=R;const N=["disabled"],V=["disabled"];function F(t,e,o,r,a,n){const c=(0,s.g2)("boot-check");return(0,s.uX)(),(0,s.Wv)(c,{progress:t.bootState,title:t.$t("ui.server.config.title"),description:t.bootDescription},{default:(0,s.k6)((()=>["error"===t.bootState||"action"===t.bootState?((0,s.uX)(),(0,s.CE)("button",{key:0,class:"widget-button widget-button--alert",disabled:!t.isGranted(n.scopes.INSTALL),onClick:e[0]||(e[0]=function(){return n.showConfiguration&&n.showConfiguration(...arguments)})},(0,i.v_)(t.$t("ui.server.config.setup")),9,N)):"loading"!==t.bootState?((0,s.uX)(),(0,s.CE)("button",{key:1,class:"widget-button widget-button--edit",disabled:!t.isGranted(n.scopes.INSTALL),onClick:e[1]||(e[1]=function(){return n.showConfiguration&&n.showConfiguration(...arguments)})},(0,i.v_)(t.$t("ui.server.config.change")),9,V)):(0,s.Q3)("",!0)])),_:1},8,["progress","title","description"])}var H={mixins:[L],components:{BootCheck:W},computed:{...(0,f.L8)("auth",["isGranted"]),scopes:()=>w.A},methods:{async boot(){this.bootDescription=this.$t("ui.server.running"),this.$store.dispatch("server/config/get").then((t=>{this.php_cli=t.php_cli,this.cloud=t.cloud.enabled,this.cloudIssues=t.cloud.issues,t.php_cli?t.cloud.enabled&&t.cloud.issues.length>0?(this.bootState="error",this.bootDescription=this.$t("ui.server.config.stateErrorCloud")):(this.bootState="success",this.bootDescription=this.$t("ui.server.config.stateSuccess",{php_cli:t.php_cli})):(this.bootState="error",this.bootDescription=this.$t("ui.server.config.stateErrorCli"))})).catch((()=>{this.bootState="error",this.bootDescription=this.$t("ui.server.error")})).then((()=>{this.$emit("result",this.bootState)}))},showConfiguration(){this.$store.commit("setView",k.A.CONFIG)}}};const q=(0,B.A)(H,[["render",F]]);var Y=q;const J=["href"];function K(t,e,o,r,a,n){const c=(0,s.g2)("boot-check");return(0,s.uX)(),(0,s.Wv)(c,{progress:t.bootState,title:t.$t("ui.server.php_cli.title"),description:t.bootDescription,detail:t.problem&&t.problem.detail},{default:(0,s.k6)((()=>[t.problem&&t.problem.type?((0,s.uX)(),(0,s.CE)("a",{key:0,href:t.problem.type,target:"_blank"},(0,i.v_)(t.$t("ui.server.details")),9,J)):(0,s.Q3)("",!0)])),_:1},8,["progress","title","description","detail"])}var Z={mixins:[L],components:{BootCheck:W},data:()=>({problem:{}}),methods:{boot(){this.bootDescription=this.$t("ui.server.running"),this.$store.dispatch("server/php-cli/get").then((t=>{t.problem?(this.problem=t.problem,this.bootState="error",this.bootDescription=t.problem.title):(this.bootState="success",this.bootDescription=this.$t("ui.server.php_cli.success",{version:t.version}))})).catch((t=>{503===t.status?(this.bootState="error",this.bootDescription=this.$t("ui.server.prerequisite")):(this.bootState="error",this.bootDescription=this.$t("ui.server.error"))})).then((()=>{this.$emit("result",this.bootState)}))}}};const tt=(0,B.A)(Z,[["render",K]]);var et=tt;function ot(t,e,o,r,a,n){const c=(0,s.g2)("i18n-t"),u=(0,s.g2)("boot-check");return(0,s.uX)(),(0,s.Wv)(u,{progress:t.bootState,title:t.$t("ui.server.selfUpdate.title"),description:t.bootDescription},(0,s.eX)({default:(0,s.k6)((()=>[t.isSupported||"action"!==t.bootState?t.hasUpdate?((0,s.uX)(),(0,s.CE)("button",{key:1,class:"widget-button widget-button--alert",onClick:e[1]||(e[1]=function(){return n.update&&n.update(...arguments)})},(0,i.v_)(t.$t("ui.server.selfUpdate.button")),1)):(0,s.Q3)("",!0):((0,s.uX)(),(0,s.CE)("button",{key:0,class:"widget-button widget-button--warning",onClick:e[0]||(e[0]=function(){return n.next&&n.next(...arguments)})},(0,i.v_)(t.$t("ui.server.selfUpdate.continue")),1))])),_:2},[t.latestDownload?{name:"description",fn:(0,s.k6)((()=>[(0,s.bF)(c,{keypath:"ui.server.selfUpdate.manualUpdate"},{latest:(0,s.k6)((()=>[(0,s.eW)((0,i.v_)(t.latestDownload),1)])),download:(0,s.k6)((()=>e[2]||(e[2]=[(0,s.Lk)("a",{href:"https://to.contao.org/download?lang=${this.$i18n.l