### Copyright (C) 1995-2000 Jesper K. Pedersen
### This program is free software; you can redistribute it and/or modify
### it under the terms of the GNU General Public License as published by
### the Free Software Foundation; either version 2 of the License, or
### (at your option) any later version.
###
### This program is distributed in the hope that it will be useful,
### but WITHOUT ANY WARRANTY; without even the implied warranty of
### MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
### GNU General Public License for more details.
###
### You should have received a copy of the GNU General Public License
### along with this program; if not, write to the Free Software
### Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.


############################################################
### setting names of the options, and tk element names
### The first one in the list is the default option.
############################################################
set __wtypes(checkbox) {checkbutton frame packFrame pack}
set __wtypes(radio) {radio packRadio frame packFrame subFrame packSubFrame
  label packLabel}
set __wtypes(entry) {entry frame packFrame label entry labelAfter packLabel
  packEntry packLabelAfter button packButton}
set __wtypes(int) $__wtypes(entry) 
set __wtypes(float) $__wtypes(entry)
set __wtypes(textbox) {text scrollbar label packLabel packText
  frame packFrame packScrollbar}
set __wtypes(menu) {button frame packFrame label
  labelAfter packLabel packButton packLabelAfter menu}
set __wtypes(listbox) {listbox frame packFrame label
  listboxFrame packListboxFrame packLabel scrollbar packListbox packScrollbar}
set __wtypes(line) {frame pack}
set __wtypes(header) {label packLabel frame packFrame}
set __wtypes(label) {label labelBefore labelAfter packLabel frame packFrame packLabelBefore packLabelAfter button packButton}
set __wtypes(frame) {frame packFrame}
set __wtypes(filloutelm) ""
set __wtypes(fillout) {entry packEntry frame packFrame
  label packLabel listbox packListbox scrollbar packScrollbar
  scrollEntry packScrollEntry packScrollbar}
set __wtypes(extentry) {frame packFrame label packLabel scrollbar
  packScrollbar subFrame packSubFrame line packLine scrollbarFrame
  packScrollbarFrame}
set __wtypes(command) {button frame packFrame label labelAfter packLabel
  packButton packLabelAfter}
set __wtypes(window) $__wtypes(command)
set __wtypes(combobox) {entry frame packFrame label labelAfter button packLabel packEntry packLabelAfter packButton}

set __wnames(checkbox) {}
set __wnames(radio) {count entries entryhelp defaultIndex}
set __wnames(entry) {textafter orient comboWidth}
set __wnames(int) $__wnames(entry)
set __wnames(float) $__wnames(entry)
set __wnames(textbox) {}
set __wnames(menu) {entries textafter entryhelp defaultIndex}
set __wnames(listbox) {entries entryhelp defaultIndex}
set __wnames(line) {orient}
set __wnames(header) {}
set __wnames(label) {textafter comboWidth}
set __wnames(frame) {entries orient}
set __wnames(filloutelm) {entries change save show init showPage}
set __wnames(fillout) {entries tp}
set __wnames(extentry) {entries count orient maxentries noscissor lines index}
set __wnames(command) {textafter setvalue invoke enable disable inactive}
set __wnames(window) {textafter textbefore entries title pageEnd orient}
set __wnames(combobox) {textafter entries count comboWidth entryhelp noedit
  defaultIndex}
foreach elm [array names __wnames] {
  lappend __wnames($elm) text default help type export
}

############################################################
#                          Basic Objects
############################################################
proc CheckBox {name args} {
  global __widgetArgs __editInfo
  set function $__editInfo(name)
  set __widgetArgs(${function}__${name}__default) 0
  widget $name checkbox $args
}
proc Radio {name args} {
  global __widgetArgs __editInfo
  set function $__editInfo(name)
  set __widgetArgs(${function}__${name}__count) 5
  widget $name radio $args
  if {![info exists  __widgetArgs(${function}__${name}__default)]} {
    set __widgetArgs(${function}__${name}__default) \
      [lindex $__widgetArgs(${function}__${name}__entries) 0]
  }
}
proc Int {name args} {
  global __widgetArgs __editInfo
  set function $__editInfo(name)
  set __widgetArgs(${function}__${name}__default) {}
  set __widgetArgs(${function}__${name}__textafter) {}
  set __widgetArgs(${function}__${name}__orient) left
  set __widgetArgs(${function}__${name}__comboWidth) 0
  widget $name int $args
}
proc Float {name args} {
  global __widgetArgs __editInfo
  set function $__editInfo(name)
  set __widgetArgs(${function}__${name}__default) {}
  set __widgetArgs(${function}__${name}__textafter) {}
  set __widgetArgs(${function}__${name}__orient) left
  set __widgetArgs(${function}__${name}__comboWidth) 0
  widget $name float $args
}
proc Entry {name args} {
  global __widgetArgs __editInfo
  set function $__editInfo(name)
  set __widgetArgs(${function}__${name}__default) {}
  set __widgetArgs(${function}__${name}__textafter) {}
  set __widgetArgs(${function}__${name}__orient) left
  set __widgetArgs(${function}__${name}__comboWidth) 0
  widget $name entry $args
}
proc TextBox {name args} {
  global __widgetArgs __editInfo
  set function $__editInfo(name)
  set __widgetArgs(${function}__${name}__default) {}
  widget $name textbox $args
}
proc Menu {name args} {
  global __widgetArgs __editInfo
  set function $__editInfo(name)
  set __widgetArgs(${function}__${name}__textafter) {}
  set __widgetArgs(${function}__${name}__entries) {}
  widget $name menu $args

  if {$__widgetArgs(${function}__${name}__entries) == {}} {
    error "No entries in Menu widget \"$name\" on page \"$function\""
  }
  if {![info exists __widgetArgs(${function}__${name}__default)]} {
    set __widgetArgs(${function}__${name}__default) \
      [lindex $__widgetArgs(${function}__${name}__entries) 0]
  }
}
proc ListBox {name args} {
  global __widgetArgs __editInfo
  set function $__editInfo(name)
  set __widgetArgs(${function}__${name}__selectmode) extended
  set __widgetArgs(${function}__${name}__default) {}
  set __widgetArgs(${function}__${name}__entries) {}
  widget $name listbox $args

  if {$__widgetArgs(${function}__${name}__entries) == {}} {
    error "No entries in ListBox widget \"$name\" on page \"$function\""
  }
}
proc ComboBox {name args} {
  global __widgetArgs __editInfo
  set function $__editInfo(name)
  set __widgetArgs(${function}__${name}__default) {}
  set __widgetArgs(${function}__${name}__textafter) {}
  set __widgetArgs(${function}__${name}__entries) {}
  set __widgetArgs(${function}__${name}__count) 10
  set __widgetArgs(${function}__${name}__noedit) 0
  set __widgetArgs(${function}__${name}__comboWidth) 0
  widget $name combobox $args
}
proc Line {name args} {
  global __widgetArgs __editInfo
  set function $__editInfo(name)
  set __widgetArgs(${function}__${name}__default) ""
  set __widgetArgs(${function}__${name}__orient) "horizontal"
  widget $name line $args
}
proc Header {name args} {
  global __widgetArgs __editInfo
  set function $__editInfo(name)
  set __widgetArgs(${function}__${name}__default) ""
  widget $name header $args
}
proc Label {name args} {
  global __widgetArgs __editInfo
  set function $__editInfo(name)
  set __widgetArgs(${function}__${name}__default) ""
  set __widgetArgs(${function}__${name}__textafter) {}
  set __widgetArgs(${function}__${name}__comboWidth) 0
  widget $name label $args
}
proc Frame {name args} {
  global __children __editInfo __widgetArgs __parent
  set function $__editInfo(name)
  set __widgetArgs(${function}__${name}__orient) left
  set __widgetArgs(${function}__${name}__entries) {}
  set __widgetArgs(${function}__${name}__default) {}
  
  widget $name frame $args
  # See Hsapce in tcsh/util.tcl
  # Sun Feb  9 19:07:59 2000 -- Jesper Pedersen
  #   if {$__widgetArgs(${function}__${name}__entries) == ""} {
  #      error "Frame \"$name\" doesn't have an -entries option"
  #    }
  set __children(${function}__$name) $__widgetArgs(${function}__${name}__entries)
  foreach var $__children(${function}__$name) {
    set newlist [lremove $__children(${function}__top) $var]
    if {$newlist == "__error__"} {
      error "element \"$var\" didn't exists for frame \"$name\""
    }
    set __children(${function}__top) $newlist
    set __parent(${function}__$var) $name
  }
}
proc Window {name args} {
  global __children __editInfo __widgetArgs __parent
  set function $__editInfo(name)
  set __widgetArgs(${function}__${name}__entries) {}
  set __widgetArgs(${function}__${name}__default) {}
  set __widgetArgs(${function}__${name}__textafter) {}
  set __widgetArgs(${function}__${name}__textbefore) {}
  set __widgetArgs(${function}__${name}__title) {}
  set __widgetArgs(${function}__${name}__pageEnd) {}
  set __widgetArgs(${function}__${name}__orient) top
  set __widgetAtgs(${function}__${name}__pageEnd) {}
  
  widget $name window $args
  if {$__widgetArgs(${function}__${name}__entries) == ""} {
    error "Window \"$name\" doesn't have an -entries option"
  }
  set __children(${function}__$name) $__widgetArgs(${function}__${name}__entries)
  foreach var $__children(${function}__$name) {
    set newlist [lremove $__children(${function}__top) $var]
    if {$newlist == "__error__"} {
      error "element \"$var\" didn't exists for window \"$name\""
    }
    set __children(${function}__top) $newlist
    set __parent(${function}__$var) $name
  }
}
proc Command {name args} {
  global __widgetArgs __editInfo
  set function $__editInfo(name)
  set __widgetArgs(${function}__${name}__default) {}
  set __widgetArgs(${function}__${name}__textafter) {}
  set __widgetArgs(${function}__${name}__disable) {}
  set __widgetArgs(${function}__${name}__enable) {}
  set __widgetArgs(${function}__${name}__inactive) {}
  widget $name command $args
  if {![info exists __widgetArgs(${function}__${name}__setvalue)]} {
    error "No -setvalue option for widget \"$name\""
  }
  if {![info exists __widgetArgs(${function}__${name}__invoke)]} {
    error "No -invoke option for widget \"$name\""
  }
}  
############################################################
#                         Fill Outs
############################################################
proc FillOutElm {name args} {
  global __widgetArgs __editInfo __children __parent
  set function $__editInfo(name)
  set __widgetArgs(${function}__${name}__default) ""
  set __widgetArgs(${function}__${name}__entries) {}
  set __widgetArgs(${function}__${name}__init) ""
  set __widgetArgs(${function}__${name}__change) ""
  set __widgetArgs(${function}__${name}__showPage) ""
  widget $name filloutelm $args

  set __children(${function}__$name) $__widgetArgs(${function}__${name}__entries)
  if {$__widgetArgs(${function}__${name}__text) == ""} {
    set __widgetArgs(${function}__${name}__text) $name
  }
  if {![info exists __widgetArgs(${function}__${name}__save)]} {
    set __widgetArgs(${function}__${name}__save) \
      "print $name"
  }
  if {![info exists __widgetArgs(${function}__${name}__show)]} {
    set __widgetArgs(${function}__${name}__show) \
      "print \\\[$name\\\]"
  }
  if {![info exists __widgetArgs(${function}__${name}__pageEnd)]} {
    set __widgetArgs(${function}__${name}__pageEnd) {}
  }
  foreach var $__widgetArgs(${function}__${name}__entries) {
    set newlist [lremove $__children(${function}__top) $var]
    if {$newlist == "__error__"} {
      error "Element \"$var\" didn't exists for FillOutElm \"$name\""
    }
    set __children(${function}__top) $newlist
    set __parent(${function}__$var) $name
  }
}
proc FillOut {name args} {
  global __children __editInfo __widgetArgs __parent
  set function $__editInfo(name)
  set __widgetArgs(${function}__${name}__entries) ""
  set __widgetArgs(${function}__${name}__default) {}
  set __widgetArgs(${function}__${name}__tp) "entry"
  
  widget $name fillout $args
  if {$__widgetArgs(${function}__${name}__entries) == ""} {
    error "FillOut \"$name\" doesn't have an -entries option"
  }
  set __children(${function}__$name) $__widgetArgs(${function}__${name}__entries)

  # checking that the type is correct
  if {$__widgetArgs(${function}__${name}__tp) != "entry" &&
      $__widgetArgs(${function}__${name}__tp) != "text"} {
    error "wrong type: \"$__widgetArgs(${function}__${name}__tp)\" for FillOut $name"
  }

  foreach var $__widgetArgs(${function}__${name}__entries) {
    set newlist [lremove $__children(${function}__top) $var]
    if {$newlist == "__error__"} {
      error "FillOutElm \"$var\" didn't exist for FillOut \"$name\""
    } 
    set __children(${function}__top) $newlist
    set __parent(${function}__$var) $name
  }
}
############################################################
#                         ExtEntry
############################################################
proc ExtEntry {name args} {
  global __children __editInfo __widgetArgs __parent
  set function $__editInfo(name)
  set __widgetArgs(${function}__${name}__orient) left
  set __widgetArgs(${function}__${name}__count) 3
  set __widgetArgs(${function}__${name}__entries) {}
  set __widgetArgs(${function}__${name}__default) {}
  set __widgetArgs(${function}__${name}__maxentries) Inf
  set __widgetArgs(${function}__${name}__noscissor) 0
  set __widgetArgs(${function}__${name}__lines) 0
  set __widgetArgs(${function}__${name}__index) ""

  widget $name extentry $args
  if { $__widgetArgs(${function}__${name}__count) > \
         $__widgetArgs(${function}__${name}__maxentries)} {
    set __widgetArgs(${function}__${name}__count) \
      $__widgetArgs(${function}__${name}__maxentries)
  }

  if {$__widgetArgs(${function}__${name}__entries) == ""} {
    error "Extentry \"$name\" doesn't have an -entries option"
  }
  set __children(${function}__$name) $__widgetArgs(${function}__${name}__entries)
  foreach var $__widgetArgs(${function}__${name}__entries) {
    set __parent(${function}__$var) $name
  }
  foreach var $__children(${function}__$name) {
    set newlist [lremove $__children(${function}__top) $var]
    if {$newlist == "__error__"} {
      error "element \"$var\" didn't exists for ExtEntry \"$name\""
    }
    set __children(${function}__top) $newlist
  }

  # checking for an index element
  set index $__widgetArgs(${function}__${name}__index)
  if {$index != ""} {
    if {[lsearch  -exact $__children(${function}__$name) $index] == -1} {
      error "index element \"$index\" not a child of ExtEntry \"$name\""
    }
    set type $__widgetArgs(${function}__${index}__type)
    if {$type != "entry" && $type != "int" && $type != "float"
        && $type != "label"} {
      error "Index element \"$index\" have to have one of the types\"entry, int, float, label\" in the extentry widget \"$name\""
    }
  }

  if {[regexp {.*[0-9]+$} $name] &&
      $__widgetArgs(${function}__${name}__index) != ""} {
    error [concat "It is not allowed to use ExtEntries"\
             "with names which end with a number, when the elemet"\
             "has an index element"]
  }
}
############################################################
#                     Object constructor
############################################################
proc widget {name type rest} {
  global __children __widgetArgs __editInfo __checkList __parent
  global __wnames

  set function $__editInfo(name)
  set prefix ${function}__$name
  set __widgetArgs(${prefix}__type) $type
  set __widgetArgs(${prefix}__export) 1
  parseOptions $rest $name

  if {![info exist __widgetArgs(${prefix}__help)]} {
    set __widgetArgs(${prefix}__help) "No Help"
  }

  if {[info exists __checkList] && [lsearch -exact $__checkList $name] != -1} {
    error "two element had the name \"$name\" in function \"$function\""
  }
  if {[info exists __checkList]} {
    lappend __checkList $name
  }


  ### converting -entryhelp into -entry
  ### for listbox,menu, combobox and radio
  if {[info exists __widgetArgs(${prefix}__entryhelp)]} {
    set count 0
    set __widgetArgs(${prefix}__entries) ""
    foreach elm $__widgetArgs(${prefix}__entryhelp) {
      if {$count%2 == 0} {
        lappend __widgetArgs(${prefix}__entries) $elm
      }
      incr count
    }
  }

  ### creating the entry help if it doesn't exists.
  if {($type == "menu" || $type == "listbox" || $type =="combobox" ||
       $type == "radio") && ![info exists __widgetArgs(${prefix}__entryhelp)]} {
    set __widgetArgs(${prefix}__entryhelp) ""
  }
  ### converting -defaultIndex to -default
  ### for listbox,menu, combobox and radio
  if {[info exists __widgetArgs(${prefix}__defaultIndex)]} {
    if {$type == "listbox"} {
      foreach elm $__widgetArgs(${prefix}__defaultIndex) {
        lappend __widgetArgs(${prefix}__default) \
          [lindex $__widgetArgs(${prefix}__entries) $elm]
      }
    } else {
      set __widgetArgs(${prefix}__default) \
        [lindex $__widgetArgs(${prefix}__entries) \
           $__widgetArgs(${prefix}__defaultIndex)]
    }
  }

  lappend __children(${function}__top) $name
  set __parent($prefix) top
  if {![info exist __widgetArgs(${prefix}__text)]} {
    set __widgetArgs(${prefix}__text) ""
  }
}
############################################################
#     This procedure is the general packing procedure.
############################################################
proc packAll {path function new {pack 1}} {
  global __children __widgetArgs __editInfo
  set function $__editInfo(name)
  foreach child $__children(${function}__top) {
    set default $__widgetArgs(${function}__${child}__default)
    set type $__widgetArgs(${function}__${child}__type)
    Pack $path __$function $child $pack top 0 1
    if {$new} {
      setVariable $function $child $function $default 1
    }
  }
}
############################################################
#     This is the genal procedure for packing objects
############################################################
proc Pack {path prefix name pack orient row active} {
  global __widgetArgs __editInfo __var2path

  set function $__editInfo(name)
  set default $__widgetArgs(${function}__${name}__default)

  set type $__widgetArgs(${function}__${name}__type)
  eval pack_$type \"$path\" \"$prefix\" \"$name\" \"$pack\" \"$orient\" $row \
    $active

  set __var2path(${prefix}_$name) $path
  setState $function $path $prefix $name $active
}
proc pack_checkbox {path prefix name pack orient row active} {
  global ${prefix}_$name 
  if {$pack} {
    global __widgetArgs __editInfo __TKargs
    set function $__editInfo(name)

    set text $__widgetArgs(${function}__${name}__text)
    eval frame $path._$name  $__TKargs(${function}__${name}__frame)
    eval pack $path._$name -anchor w -side $orient \
      $__TKargs(${function}__${name}__packFrame)
    eval checkbutton $path._$name.cb -text \{$text\} -variable ${prefix}_$name \
      -relief flat $__TKargs(${function}__${name}__checkbutton)
    eval pack $path._$name.cb $__TKargs(${function}__${name}__pack)
    foreach elm {"" .cb} {
      bind $path._$name$elm <3> "help $name $path"
    }
  } else {
    $path._$name.cb configure -variable ${prefix}_$name 
  }
  if {$active} {
    $path._$name.cb configure -command "makeChange $name $prefix"
  } else {
    $path._$name.cb configure -command ""
    global ${prefix}_$name
    set ${prefix}_$name 0
  }
}
proc pack_radio {path prefix name pack orient row active} {
  global __widgetArgs __editInfo ${prefix}_$name __TKargs
  set function $__editInfo(name)
  set entries $__widgetArgs(${function}__${name}__entries)
  set w $path._$name

  if {$pack} {
    set text $__widgetArgs(${function}__${name}__text)
    set count $__widgetArgs(${function}__${name}__count)
    set frames [min [llength $entries] $count]
    
    eval frame $w $__TKargs(${function}__${name}__frame)
    eval pack $w -anchor w -expand 1 -side $orient \
      $__TKargs(${function}__${name}__packFrame)
    
    ### makeing the label
    if {$text != ""} {
      eval label $w.label -text \{$text\} $__TKargs(${function}__${name}__label)
      eval pack $w.label -side top -fill x \
        $__TKargs(${function}__${name}__packLabel)
      bind $w.label <3> "help $name $path"
    }
    ### makeing the subframes
    for {set i 0} {$i <$frames} {incr i} {
      eval frame $w.$i $__TKargs(${function}__${name}__subFrame)
      eval pack $w.$i -side left -expand 1 -anchor n \
        $__TKargs(${function}__${name}__packSubFrame)
      bind $w.$i <3> "help $name $path"
    }
    
    ### inserting the elements
    set i 0
    foreach elm $entries {
      eval radiobutton $w.radio$i -text \{$elm\} -variable ${prefix}_$name \
        -value $i $__TKargs(${function}__${name}__radio)
      eval pack $w.radio$i -in $w.[expr $i % $frames] -anchor w \
        $__TKargs(${function}__${name}__packRadio)
      bind $w.radio$i <3> "menu_help $name $i $path;break"
      bindtags $w.radio$i "$w.radio$i Radiobutton .edit all"
      incr i
    }
  } else {
    set i 0
    foreach elm $entries {
      $w.radio$i configure -variable ${prefix}_$name           
      incr i
    }
  }
  set i 0
  foreach elm $entries {
    if {$active} {
      $w.radio$i configure -command "makeChange $name $prefix"
    } else {
      $w.radio$i configure -command ""
    }
    incr i
  }
  if {!$active} {
    global ${prefix}_$name
    set ${prefix}_$name ""
  }
}
proc pack_entry {path prefix name pack orient row active} {
  global __editInfo __widgetArgs
  set w $path._$name
  set function $__editInfo(name)
  
  if {$pack} {
    global __widgetArgs __editInfo __TKargs __parent argv

    ### checking wether this is the index element in an extentry.
    set indexElm 0
    set par $__parent(${function}__$name)
    if {[info exists __widgetArgs(${function}__${par}__type)]} {
      set partype $__widgetArgs(${function}__${par}__type)
      if {$partype == "extentry" &&
          $__widgetArgs(${function}__${par}__index) == $name} {
        set indexElm 1
      }
    }

    set function $__editInfo(name)

    set textBefore $__widgetArgs(${function}__${name}__text)
    set textAfter $__widgetArgs(${function}__${name}__textafter)
    set orien $__widgetArgs(${function}__${name}__orient)
    set comboWidth $__widgetArgs(${function}__${name}__comboWidth)

    ### the outer frame
    eval frame $w $__TKargs(${function}__${name}__frame)

    eval pack $w  -anchor w -fill x -side $orient \
      $__TKargs(${function}__${name}__packFrame)

    ### the label before
    eval label $w.1 -text \{$textBefore\} \
      $__TKargs(${function}__${name}__label)

    ### the entry
    eval entry $w.2 -textvariable ${prefix}_$name -relief sunken \
      $__TKargs(${function}__${name}__entry)

    ### the fast index button
    if {$indexElm} {
      if {$row == 0} {
        eval button $w.combo -bitmap @[lindex $argv 0]/bitmaps/idx.xbm \
          $__TKargs(${function}__${name}__button)
        bind $w.combo <3> "help`gotoTag extentry_index"
        bind $w.combo <ButtonPress-1> "indexList $w $prefix $name $comboWidth;break"
      } else {
        frame $w.combo -width 26
      }
    }

    ### the label after
    eval label $w.3 -text \{$textAfter\} \
      $__TKargs(${function}__${name}__labelAfter)


    ### packing the elements
    eval pack $w.1  -side left -anchor w \
      $__TKargs(${function}__${name}__packLabel)
    eval pack $w.2 -side $orien \
      $__TKargs(${function}__${name}__packEntry)
    if {$indexElm} {
      eval pack $w.combo -side left \
        $__TKargs(${function}__${name}__packButton)
    }
    eval pack $w.3 -side left \
      $__TKargs(${function}__${name}__packLabelAfter)
    
    bindtags $w.2 "Entry $path._$name.2 .edit all"

    ### binding help
    foreach elm {"" .1 .2 .3} {
      bind $w$elm <3> "help $name $path"
    }
  } else {
    $w.2 configure -textvariable ${prefix}_$name
  }
  if {$active} {
    bind $path._$name.2 <KeyPress> "makeChange $name $prefix"
    bind $path._$name.2 <Button> "makeChange $name $prefix"
  } else {
    bind $path._$name.2 <KeyPress> ""
    bind $path._$name.2 <Button> ""
    global ${prefix}_$name
    set ${prefix}_$name ""
  } 
}
proc pack_int {path prefix name pack orient row active} {
  pack_entry "$path" "$prefix" "$name" "$pack" "$orient" $row $active
  if {$pack} {
    eval $path._$name.2 configure -width 5
    bind $path._$name.2 <KeyPress> "+checkInt %W"
  }
}
proc pack_float {path prefix name pack orient row active} {
  pack_entry "$path" "$prefix" "$name" "$pack" "$orient" $row $active
  if {$pack} {
    eval $path._$name.2 configure -width 5
    bind $path._$name.2 <KeyPress> "+checkFloat %W"
  }
}
proc pack_textbox {path prefix name pack orient row active} {
  global ${prefix}_$name __traceTable __editInfo __TKargs
  set w $path._$name
  set function $__editInfo(name)
  if {[info exists __traceTable(${function}_$w)]} {
    uplevel \#0 \
      "trace vdelete $__traceTable(${function}_$w) w {trace_textbox $w.text}"
    unset __traceTable(${function}_$w)
  }
  
  if {$pack} {
    global __widgetArgs __editInfo
    set function $__editInfo(name)
    
    set text $__widgetArgs(${function}__${name}__text)
    eval frame $w $__TKargs(${function}__${name}__frame)
    eval pack $w -anchor w -fill x -side $orient \
      $__TKargs(${function}__${name}__packFrame)
    if {$text != ""} {
      eval label $w.label -text \{$text\} $__TKargs(${function}__${name}__label)
      eval pack $w.label -fill x \
        $__TKargs(${function}__${name}__packLabel)
      bind $w.label <3> "help $name $path"
    }
    eval text $w.text -relief raised  -yscrollcommand \"$w.scroll set\" \
      -wrap word -width 0 -height 5 $__TKargs(${function}__${name}__text)
    eval scrollbar $w.scroll -command \"$w.text yview\" \
      $__TKargs(${function}__${name}__scrollbar)
    eval pack $w.text -side left -fill x -expand 1\
      $__TKargs(${function}__${name}__packText)
    eval pack $w.scroll -fill y -expand 1 \
      $__TKargs(${function}__${name}__packScrollbar)

    ### binding help
    foreach elm {"" .text .scroll} {
      bind $w$elm <3> "help $name $path"
    }
  } else {
    ${path}._$name.text delete 1.0 end
  }
  # I have to enable it, to insert element into it.
  ${path}._$name.text configure -state normal
  global ${prefix}_$name ${prefix}_${name}_scroll
  if {[info exists ${prefix}_$name]} {
    $w.text insert 1.0 [set ${prefix}_$name]
    if {[info exists ${prefix}_${name}_scroll]} {
      $w.text mark set insert [lindex [set ${prefix}_${name}_scroll] 1]
      $w.text yview [lindex [set ${prefix}_${name}_scroll] 0]
    }
  } else {
    set ${prefix}_$name ""
  }
  trace variable ${prefix}_$name w "trace_textbox $w.text"
  set __traceTable(${function}_$w) ${prefix}_$name
  bindtags $w.text "Text $w.text .edit all"
  if {$active} {
    bind $w.text <KeyPress> "set __copyingTextBoxFlag 1;set ${prefix}_$name \[$w.text get 1.0 end-1c\];set ${prefix}_${name}_scroll \[list \[$w.text index @1,0\] \[$w.text index insert\]\];set __copyingTextBoxFlag 0;makeChange $name $prefix"
  } else {
    bind $w.text <KeyPress> ""
    global ${prefix}_$name
    set ${prefix}_$name ""
  }
}
proc pack_menu {path prefix name pack orient row active} {
  global ${prefix}_$name __widgetArgs __editInfo __TKargs
  set function $__editInfo(name)
  
  set entries $__widgetArgs(${function}__${name}__entries)
  set w $path._$name
  if {$pack} {
    set tleft $__widgetArgs(${function}__${name}__text)
    set tright $__widgetArgs(${function}__${name}__textafter)

    eval frame $w $__TKargs(${function}__${name}__frame)
    eval pack $w -anchor w -side $orient \
      $__TKargs(${function}__${name}__packFrame)
    eval label $w.tleft -text \{$tleft\} \
      $__TKargs(${function}__${name}__label)
    eval menubutton $w.bar -textvariable ${prefix}_$name -indicatoron 1 \
      -menu $w.bar.menu \
      -relief raised -bd 2 -padx 4p -pady 4p -highlightthickness 2 \
      -anchor c $__TKargs(${function}__${name}__button)
    eval label $w.tright -text \{$tright\} \
      $__TKargs(${function}__${name}__labelAfter)
    eval pack $w.tleft -side left $__TKargs(${function}__${name}__packLabel)
    eval pack $w.bar -side left $__TKargs(${function}__${name}__packButton)
    eval pack $w.tright -side left \
      $__TKargs(${function}__${name}__packLabelAfter)
    eval menu $w.bar.menu -tearoff 0 $__TKargs(${function}__${name}__menu)
    foreach entry $entries {
      $path._$name.bar.menu add command -label $entry 
    }

    ### binding help
    foreach elm {"" .tleft .tright} {
      bind $w$elm <3> "help $name $path"
    }
  } else {
    $w.bar configure -textvariable ${prefix}_$name
  }
  bind $w.bar <ButtonPress-3> {
    if {$tkPriv(inMenubutton) != ""} {
      tkMbPost $tkPriv(inMenubutton) %X %Y
    }
    break
  }
  
  bind  $w.bar.menu <ButtonRelease-3> "tkMenuUnpost %W; menu_help $name \[%W index @%y\] $path; break;"
  set i 0
  foreach entry $entries {
    if {$active} {
      $path._$name.bar.menu entryconfigure $i \
        -command "[list set ${prefix}_$name $entry];makeChange $name $prefix"
    } else {
      $path._$name.bar.menu entryconfigure $i -command ""
    }
    incr i
  }
  if {!$active} {
    global ${prefix}_$name
    set ${prefix}_$name ""
  }
}
proc pack_listbox {path prefix name pack orient row active} {
  global __widgetArgs __editInfo __traceTable ${prefix}_$name
  global ${prefix}_${name}_scroll __TKargs
  set function $__editInfo(name)
  set text $__widgetArgs(${function}__${name}__text)
  set entries $__widgetArgs(${function}__${name}__entries)
  set selectmode $__widgetArgs(${function}__${name}__selectmode)
  set w $path._$name

  if {[info exists __traceTable(${function}_$w)]} {
    uplevel \#0 \
      "trace vdelete $__traceTable(${function}_$w) w {trace_listbox $w.box}"
    unset __traceTable(${function}_$w)
  }

  if {$pack} {

    eval frame $w $__TKargs(${function}__${name}__frame)
    eval pack $w -anchor w -side $orient \
      $__TKargs(${function}__${name}__packFrame)
    if {$text != ""} {
      eval label $w.label -text \{$text\} $__TKargs(${function}__${name}__label)
      eval pack $w.label -fill x -expand 1 \
        $__TKargs(${function}__${name}__packLabel)
      bind $w.label <3> "help $name $path"
    }
    eval frame $w.listBoxFrame $__TKargs(${function}__${name}__listboxFrame)
    eval pack $w.listBoxFrame -expand 1 \
      $__TKargs(${function}__${name}__packListboxFrame)
    eval listbox $w.box -yscrollcommand \"$w.scroll set\" -relief raised \
      -borderwidth 2 -height 5 -exportselection off \
      $__TKargs(${function}__${name}__listbox)
    eval scrollbar $w.scroll $__TKargs(${function}__${name}__scrollbar) \
      -command \"scroll_listbox $w.box ${prefix}_$name\" 
    eval pack $w.box -side left -fill y \
      $__TKargs(${function}__${name}__packListbox) -in $w.listBoxFrame
    eval pack $w.scroll -side left -fill y \
      $__TKargs(${function}__${name}__packScrollbar) -in $w.listBoxFrame
    foreach entry $entries {
      $w.box insert end $entry
    }

    ### binding help
    foreach elm {""  .listBoxFrame .scroll .box} {
      bind $w$elm <3> "help $name $path"
    }
  } else {
    $w.box selection clear 0 end
  }
  if {$active} {
    if {[info exists ${prefix}_${name}_scroll]} {
      eval $w.box yview  [set ${prefix}_${name}_scroll]
    } else {
      eval $w.box yview 0
      if {[info exists ${prefix}_$name] && [set ${prefix}_$name] != ""} {
        $w.box yview [lindex [set ${prefix}_$name] 0]
      }
    }
    if {[info exists ${prefix}_$name]} {
      foreach sel [set ${prefix}_$name] {
        $w.box selection set $sel
      }
    } else {
      set ${prefix}_$name ""
    }
    uplevel \#0 "trace variable ${prefix}_$name w {trace_listbox $w.box}"
    bind $w.box <ButtonRelease-1> "set __copyingListBoxFlag 1;set ${prefix}_$name \[$w.box curselection\];set __copyingListBoxFlag 0;makeChange $name $prefix"
  } else {
    bind $w.box <ButtonRelease-1> ""
    $w.box selection clear 0 end
  }
  bind $w.box <ButtonPress-3> "listbox_help $w $name %y $w;break"
}
proc pack_combobox {path prefix name pack orient row active} {
  global __widgetArgs __editInfo __TKargs argv
  set function $__editInfo(name)
  set entries $__widgetArgs(${function}__${name}__entries)
  set w $path._$name

  if {$pack} {
    set text $__widgetArgs(${function}__${name}__text)
    set textafter $__widgetArgs(${function}__${name}__textafter)
    set noedit $__widgetArgs(${function}__${name}__noedit)

    ### The frame containing it all
    eval frame $w $__TKargs(${function}__${name}__frame)
    eval pack $w -anchor w -side $orient \
      $__TKargs(${function}__${name}__packFrame)

    ### The label
    eval label $w.label -text \{$text\} \
      $__TKargs(${function}__${name}__label)

    ### The entry
    eval entry $w.2 -textvariable ${prefix}_$name -relief sunken \
      $__TKargs(${function}__${name}__entry)
    if ($noedit) {
      $w.2 configure -state disabled
    }

    ### the button
    eval button $w.combo $__TKargs(${function}__${name}__button) \
      $__TKargs(${function}__${name}__button) \
      -bitmap @[lindex $argv 0]/bitmaps/ComboBox.xbm

    ### The label after
    eval label $w.labelafter -text \{$textafter\} \
      $__TKargs(${function}__${name}__labelAfter)

    ### packing the elements
    eval pack $w.label -side left -anchor w \
      $__TKargs(${function}__${name}__packLabel)
    eval pack $w.2  -side left -anchor w \
      $__TKargs(${function}__${name}__packEntry)
    eval pack $w.combo -side left -anchor w \
      $__TKargs(${function}__${name}__packButton)
    eval pack $w.labelafter -side left -anchor w \
      $__TKargs(${function}__${name}__packLabelAfter)

    ### binding help
    foreach widget {.label .2 .labelafter .combo ""} {
      bind $w$widget <3> "help $name $path"
    }

  } else {
    $w.2 configure -textvariable ${prefix}_$name
  }
  ### Why did I had a break at the end of these bindings?
  ### Sat Aug  3 14:18:52 1996 -- Jesper Pedersen
  if {$active} {
    bind $w.combo <ButtonPress-1> "popUpCombo $w $prefix $name;makeChange $name $prefix;"
    bind $w.2 <1> "makeChange $name $prefix"
    bind $w.2 <KeyPress> "makeChange $name $prefix"
    bindtags $w.2 "Entry $w.2 all"
  } else {
    bind $w.combo <ButtonPress-1> ""
    bind $w.2 <1> ""
    bind $w.2 <KeyPress> ""
    global ${prefix}_$name
    set ${prefix}_$name ""
  }
}
proc pack_command {path prefix name pack orient row active} {
  set w $path._$name
  global widget $name ${prefix}_$name __editInfo __widgetArgs
  set function $__editInfo(name)
  set setvalue $__widgetArgs(${function}__${name}__setvalue)
  set inactive $__widgetArgs(${function}__${name}__inactive)
  if {$pack} {
    global __TKargs

    set textBefore $__widgetArgs(${function}__${name}__text)
    set textAfter $__widgetArgs(${function}__${name}__textafter)

    eval frame $w $__TKargs(${function}__${name}__frame)
    eval pack $w  -anchor w -expand 1 -fill x -side $orient \
      $__TKargs(${function}__${name}__packFrame)
    bind $w <3> "help $name $path"

    ### label before
    if {$textBefore != "" ||
        $__TKargs(${function}__${name}__label) != ""} {
      eval label $w.1 -text \"$textBefore\" \
        $__TKargs(${function}__${name}__label)
      eval pack $w.1 -side left $__TKargs(${function}__${name}__packLabel)
      bind $w.1 <3> "help $name $path"
    }
    
    ### the button
    eval button $w.2 $__TKargs(${function}__${name}__button) \
      -command \"comandInvoke $w $prefix $name\"\
      $__TKargs(${function}__${name}__button)
    eval pack $w.2 -side left $__TKargs(${function}__${name}__packButton)
    bind $w.2 <3> "help $name $path"

    ### label after
    if {$textAfter != "" || $__TKargs(${function}__${name}__labelAfter) != ""} {
      eval label $w.3 -text \"$textAfter\" \
        $__TKargs(${function}__${name}__labelAfter)
      eval pack $w.3 -side left $__TKargs(${function}__${name}__packLabelAfter)
      bind $w.3 <3> "help $name $path"
    }

  } else {
    if {$active} {
      $w.2 configure -command "comandInvoke $w $prefix $name"
      catch unset widget
      set widget $w.2
      UpdateActive $name $prefix
      uplevel \#0 $setvalue
      unset widget
    }
  }

  ### Set the text in the command widget
  catch "unset widget"
  set widget $w.2
  if {$active} {
    UpdateActive $name $prefix
    uplevel \#0 $setvalue
  } else {
    uplevel  \#0 $inactive
  }
  unset widget
}
proc pack_extentry {path prefix name pack orient row active} {
  global __widgetArgs __children __editInfo __scrollBar __traceTable
  global __TKargs argv __language
  set function $__editInfo(name)
  set w $path._$name
  set count $__widgetArgs(${function}__${name}__count)
  set noscissor $__widgetArgs(${function}__${name}__noscissor)
  set maxentries $__widgetArgs(${function}__${name}__maxentries)
  
  if {$pack} {
    set text $__widgetArgs(${function}__${name}__text)
    set subOrient $__widgetArgs(${function}__${name}__orient)
    set lines $__widgetArgs(${function}__${name}__lines)
    set index $__widgetArgs(${function}__${name}__index)

    if {![info exists __scrollBar(${prefix}_$name)]} {
      # This can happend if the extentry is inside another extentry.
      set __scrollBar(${prefix}_$name) {0 0}
    }
    set offset [lindex $__scrollBar(${prefix}_$name) 0]
    set total  [lindex $__scrollBar(${prefix}_$name) 1]

    ### the frame and the title
    eval frame $w $__TKargs(${function}__${name}__frame)
    eval pack $w -side $orient -anchor w \
      $__TKargs(${function}__${name}__packFrame)

    if {$text != ""} {
      eval label $w.header -text \"$text\" \
        $__TKargs(${function}__${name}__label)
      eval pack $w.header -expand 1 -fill x \
        $__TKargs(${function}__${name}__packLabel)
      bind $w.header <3> "help $name $path"
    }

    ### The scrollbar
    eval frame $w.scrollFrame $__TKargs(${function}__${name}__scrollbarFrame)
    eval pack  $w.scrollFrame -side right -fill y -anchor e \
      $__TKargs(${function}__${name}__packScrollbarFrame)
    eval scrollbar $w.scroll $__TKargs(${function}__${name}__scrollbar)

    if {$maxentries == "Inf"} {
      eval button $w.new -bitmap @[lindex $argv 0]/bitmaps/new.xbm \
        -padx 0 -pady 0 -relief groove -bd 1
      bind $w.new <3> "help`gotoTag extentry_newElm"
    }

    eval pack $w.scroll -fill y -expand 1 -anchor e \
      -in $w.scrollFrame $__TKargs(${function}__${name}__packScrollbar) \
      -pady 0

    if {$maxentries == "Inf"} {
      eval pack $w.new -in $w.scrollFrame
    }

    bind $w.scroll <3> "help $name $path"

    ### packing recursive
    set first 1
    for {set row 0} {$row < $count} {incr row} {
      if {!$first && $lines} {
        ### draw a line
        eval frame $w.line$row -height 0.05c -relief sunken -bd 1\
          $__TKargs(${function}__${name}__line)
        eval pack $w.line$row -fill x -pady 3 \
          $__TKargs(${function}__${name}__packLine)
      }
      set first 0

      ### packing the frame
      eval frame $w.row$row  $__TKargs(${function}__${name}__subFrame)
      eval pack $w.row$row -fill x -anchor e \
        $__TKargs(${function}__${name}__packSubFrame)

      ### is the sub element active
      if {$row >= $total} {
        set subActive 0
      } else {
        set subActive 1
      }
      
      ### packing each child
      foreach child $__children(${function}__$name) {
        Pack $w.row$row ${prefix}_$name[expr $row + $offset] $child 1 \
          $subOrient $row $subActive
      }
      
      ### packing the edit menu
      if {$noscissor == 0} {
        menubutton $w.row$row.edit \
          -bitmap @[lindex $argv 0]/bitmaps/scissors.xbm \
          -indicatoron 0 -menu $w.row$row.edit.menu  -relief raised -bd 2 \
          -padx 4p -pady 4p -highlightthickness 2 -anchor c
        pack $w.row$row.edit -anchor se -side right
        menu $w.row$row.edit.menu -tearoff 0 -postcommand "if {\$__clipboardName == {$name}} {$w.row$row.edit.menu entryconfigure 2 -state normal} else {$w.row$row.edit.menu entryconfigure 2 -state disabled}"

        ### inserting element into the cut/paste menu
        foreach elm "{Cut \"$__language(types,2)\"} {Copy \"$__language(types,3)\"} {Paste \"$__language(types,4)\"} {Insert \"$__language(types,5)\"}" {
          $w.row$row.edit.menu add command -label [lindex $elm 1]\
            -command "extEntry[lindex $elm 0] $path $prefix $name [expr $row + $offset]"
        }
        bind $w.row$row.edit <3> "help`gotoTag scissors"
      }

      ### if the element is outside the visual region then disable them
      if {!$subActive} {
        if {!$noscissor} {
          $w.row$row.edit configure -state disabled
        }
        foreach child $__children(${function}__$name) {
          changeState $function ${prefix}_$name[expr $row + $offset] \
            $child disabled 0
        }
      } else {
        if {!$noscissor} {
          $w.row$row.edit configure -state normal
        }
      }
      
      bind $w.row$row <3> "help $name $path"
    }
  } else {
    set offset [lindex $__scrollBar(${prefix}_$name) 0]
    set total [lindex $__scrollBar(${prefix}_$name) 1]
    for {set row 0} {$row < $count} {incr row} {

      ### is the sub element active
      if {$row >= $total} {
        set subActive 0
      } else {
        set subActive 1
      }

      foreach child $__children(${function}__$name) {
        Pack $w.row$row ${prefix}_$name[expr $row + $offset] $child 0 top $row \
          $subActive
        ### if the element is outside the visual region then disable them
        if {!$subActive} {
          if {!$noscissor} {
            $w.row$row.edit configure -state disabled
          }
          foreach child $__children(${function}__$name) {
            changeState $function ${prefix}_$name[expr $row + $offset] \
              $child disabled 0
          } 
        } else {
          if {!$noscissor} {
            $w.row$row.edit configure -state normal
          }
        }
      }
      if {$__widgetArgs(${function}__${name}__noscissor) == 0} {
        set list {Cut Copy Paste Insert}
        for {set i 0} {$i < 4} {incr i} {
          $w.row$row.edit.menu entryconfigure $i -command \
            "extEntry[lindex $list $i] $path $prefix $name [expr $row + $offset]"
        }
      }
    }
  }
  ### update the scrollbar
  setScrollBar $w.scroll $offset $total $count
  $w.scroll configure -command "scroll $path $prefix $name"

  if {$maxentries == "Inf"} {
    $w.new configure -command "newTuple $function $path $prefix $name"
  }
  
}
proc pack_line {path prefix name pack orient row active} {
  global __TKargs __editInfo __widgetArgs
  set function $__editInfo(name)
  set orient $__widgetArgs(${function}__${name}__orient)
  if {$pack} {
    if {$orient == "horizontal"} {
      eval frame $path._$name -height 0.1c -relief sunken -bd 1 \
        $__TKargs(${function}__${name}__frame)
      eval pack $path._$name -fill x -expand 1 -pady 3 \
        $__TKargs(${function}__${name}__pack)
    } else {
      eval frame $path._$name -width 0.1c -relief sunken -bd 1 \
        $__TKargs(${function}__${name}__frame)
      eval pack $path._$name -fill y  -expand 1 -padx 3 -side left\
        $__TKargs(${function}__${name}__pack)
    }
  }
}
proc pack_header {path prefix name pack orient row active} {
  if {$pack} {
    global __widgetArgs __editInfo __TKargs
    set function $__editInfo(name)
    set text $__widgetArgs(${function}__${name}__text)
    set w $path._$name
    eval frame $w -bd 3 -relief groove $__TKargs(${function}__${name}__frame)
    eval pack $w -expand 1 -fill x $__TKargs(${function}__${name}__packFrame)

    eval label $w.label -text \{$text\} $__TKargs(${function}__${name}__label)
    eval pack $w.label -expand 1 -fill x \
      $__TKargs(${function}__${name}__packLabel)

    ### binding help
    foreach elm {"" .label} {
      bind $w$elm <3> "help $name $path"
    }
  }
}
proc pack_label {path prefix name pack orient row active} {
  set w $path._$name
  if {$pack} {
    global __widgetArgs __editInfo __TKargs __parent argv
    set function $__editInfo(name)

    set textBefore $__widgetArgs(${function}__${name}__text)
    set textAfter $__widgetArgs(${function}__${name}__textafter)
    set comboWidth $__widgetArgs(${function}__${name}__comboWidth) 
    ### checking wether this is the index element in an extentry.
    set indexElm 0
    set par $__parent(${function}__$name)
    if {[info exists __widgetArgs(${function}__${par}__type)]} {
      set partype $__widgetArgs(${function}__${par}__type)
      if {$partype == "extentry" && $row == 0 &&
          $__widgetArgs(${function}__${par}__index) == $name} {
        set indexElm 1
      }
    }

    ### creating the outer frame
    eval frame $w $__TKargs(${function}__${name}__frame) 
    eval pack $w  -anchor w  -side $orient \
      $__TKargs(${function}__${name}__packFrame)
    bind $w <3> "help $name $path"

    ### create the label before
    if {$textBefore != ""
        || $__TKargs(${function}__${name}__labelBefore) != ""} {
      eval label $w.1 -text \"$textBefore\" \
        $__TKargs(${function}__${name}__labelBefore)
      eval pack $w.1 -side left $__TKargs(${function}__${name}__packLabelBefore)
      bind $w.1 <3> "help $name $path"
    }

    ### create the label
    eval label $w.2  -textvariable ${prefix}_$name\
      $__TKargs(${function}__${name}__label)
    eval pack $w.2 -side left $__TKargs(${function}__${name}__packLabel)
    bind $w.2 <3> "help $name $path"

    ### create the index button
    if {$indexElm} {
      if {$row == 0} {
        eval button $w.combo -bitmap @[lindex $argv 0]/bitmaps/idx.xbm \
          $__TKargs(${function}__${name}__button)
        bind $w.combo <3> "help`gotoTag extentry_index"
        bind $w.combo <ButtonPress-1> "indexList $w $prefix $name $comboWidth;break"
      } else {
        frame $w.combo -width 26
      }
      eval pack $w.combo -side left $__TKargs(${function}__${name}__button)
    }

    ### create the label after
    if {$textAfter != "" || $__TKargs(${function}__${name}__labelAfter) != ""} {
      eval label $w.3 -text \"$textAfter\" \
        $__TKargs(${function}__${name}__labelAfter)
      eval pack $w.3 -side left $__TKargs(${function}__${name}__packLabelAfter)
      bind $w.3 <3> "help $name $path"
    }

  } else {
    $w.2 configure -textvariable ${prefix}_$name
  }
  if {!$active} {
    global ${prefix}_$name
    set ${prefix}_$name ""
  }
}
proc pack_frame {path prefix name pack orient row active} {
  global __widgetArgs __children __editInfo __TKargs
  set function $__editInfo(name)
  set w $path._$name
  set subOrient $__widgetArgs(${function}__${name}__orient)

  if {$pack} {
    ### packing the frame
    eval frame $w $__TKargs(${function}__${name}__frame) 
    eval pack $w -side $orient -anchor w -fill both -expand 1\
      $__TKargs(${function}__${name}__packFrame)
  }

  ### calling recursive
  foreach child $__children(${function}__$name) {
    Pack $w $prefix $child $pack $subOrient $row $active
  }
}
proc pack_window {path prefix name pack orient row active} {
  global __widgetArgs __children __editInfo __TKargs
  set function $__editInfo(name)
  set w $path._${name}_inline
  set text $__widgetArgs(${function}__${name}__text)
  set textBefore $__widgetArgs(${function}__${name}__textbefore)
  set textAfter $__widgetArgs(${function}__${name}__textafter)

  if {$pack} {
    ### the outer frame
    eval frame $w $__TKargs(${function}__${name}__frame)

    eval pack $w  -anchor w -fill x -side $orient \
      $__TKargs(${function}__${name}__packFrame)

    ### label before
    if {$textBefore != "" ||
        $__TKargs(${function}__${name}__label) != ""} {
      eval label $w.1 -text \"$textBefore\" \
        $__TKargs(${function}__${name}__label)
      bind $w.1 <3> "help $name $path"
      eval pack $w.1 -side left -anchor w \
        $__TKargs(${function}__${name}__packLabel) 
    }
    
    ### the button
    eval button $w.2 $__TKargs(${function}__${name}__button) \
      -command \"showWindow $path $prefix $name $row\" \
      $__TKargs(${function}__${name}__button) \
      -text \"$text\"
    eval pack $w.2 -side left \
      $__TKargs(${function}__${name}__packButton)
    bind $w.2 <3> "help $name $path"

    ### label after
    eval label $w.3 -text \"$textAfter\" \
      $__TKargs(${function}__${name}__labelAfter)
    eval pack $w.3 -side left $__TKargs(${function}__${name}__packLabelAfter)
    bind $w.3 <3> "help $name $path"

  } else {
    ### calling recursive
    $w.2 configure -command "showWindow $w $prefix $name $row"
  }
}
proc pack_fillout {path prefix name pack orient row active} {
  global __editInfo __widgetArgs
  set w $path._$name
  set function $__editInfo(name)
  set type $__widgetArgs(${function}__${name}__tp)
  if {$pack} {
    global __TKargs 
    set text $__widgetArgs(${function}__${name}__text)
    set entries $__widgetArgs(${function}__${name}__entries)

    ### frame and title
    eval frame $w $__TKargs(${function}__${name}__frame)
    eval pack $w -anchor w -side $orient \
      $__TKargs(${function}__${name}__packFrame)
    if {$text != ""} {
      eval label $w.1 -text \"$text\" -anchor c \
        $__TKargs(${function}__${name}__label)
      eval pack $w.1 -fill x $__TKargs(${function}__${name}__packLabel)
      bind $w.1 <3> "help $name $path"
    }

    ### entry or textbox
    if {$type == "entry"} {
      eval entry $w.2 -textvariable ${prefix}_$name -relief sunken \
          -xscrollcommand \"$w.scrollEntry set\" \
          $__TKargs(${function}__${name}__entry)
      eval scrollbar $w.scrollEntry -relief sunken -orient horizontal -command \
          \"$w.2 xview\" $__TKargs(${function}__${name}__scrollEntry)
      eval pack $w.2 -fill x $__TKargs(${function}__${name}__packEntry)
      eval pack $w.scrollEntry -fill x $__TKargs(${function}__${name}__scrollEntry)
    } else {
      pack [frame $w.frame]
      eval text $w.2 -height 5 -yscrollcommand \"$w.scrollEntry set\"\
          $__TKargs(${function}__${name}__entry)
      eval scrollbar $w.scrollEntry -command \"$w.2 yview\"
      eval pack $w.2 -in $w.frame -side left \
          $__TKargs(${function}__${name}__packEntry)
      eval pack $w.scrollEntry -fill y -expand 1 -in $w.frame \
          $__TKargs(${function}__${name}__scrollEntry)
    }
    focus $w.2
    bindtags $w.2 "$w.2 .edit all"

    ### listbox
    eval listbox $w.box  -relief raised -borderwidth 2 -height 5 \
      -exportselection off $__TKargs(${function}__${name}__listbox) \
      -selectmode single
    if {[$w.box cget -height] !=0 && [$w.box cget -height]<[llength $entries]} {
      eval scrollbar $w.scroll -command \"$w.box yview\" \
        $__TKargs(${function}__${name}__scrollbar)
      $w.box configure -yscrollcommand "$w.scroll set"
      eval pack $w.box -side left -fill both -expand 1\
        $__TKargs(${function}__${name}__packListbox)
      eval pack $w.scroll -side left -fill y \
        $__TKargs(${function}__${name}__packScrollbar)
      bind $w.scroll <3> "help $name $path"
    } else {
      eval pack $w.box -expand 1 -fill both \
          $__TKargs(${function}__${name}__packListbox)
    }

    ### inserting elements in the listbox
    foreach entry $entries {
      set entrytext $__widgetArgs(${function}__${entry}__text)
      $w.box insert end $entrytext
    }

    ### binding help
    foreach elm {"" .2 .box} {
      bind $w$elm <3> "help $name $path"
    }
  } else {
    $w.2 configure -textvariable ${prefix}_$name
  }

  if {$active} {
    bind $w.box <ButtonPress-1> \
      "fillout_list ${prefix}_$name $w $name $name;makeChange $name $prefix"
    bind $w.2 <KeyPress> \
      "fillOutInsert $w ${prefix}_$name $name \[$w.2 index insert\] %A %s %K;makeChange $name $prefix"
    bind $w.2 <1> "fillOutSet $w ${prefix}_$name $name %x %y;makeChange $name $prefix"
    bind $w.2 <2> "fillOutPaste $w ${prefix}_$name $name %x %y;makeChange $name $prefix"
    fillOut_setShow $function $name $prefix
    if {$type == "text"} {
      global ${prefix}_$name
      $w.2 delete 1.0 end
      $w.2 insert 1.0 [set ${prefix}_$name]
    }
  } else {
    bind $w.box <ButtonPress-1> ""
    bind $w.2 <KeyPress> ""
    bind $w.2 <1> ""
    global ${prefix}_$name
    set ${prefix}_$name ""
  }
  bind $w.box <ButtonPress-3> "fillout_help $w $name %y;break"

}
proc pack_filloutelm {path prefix name pack orient active} {
  error "\"$name\" is a FillOutElm which isn't packed in any FillOut"
}
######################################################################
### This function sets the default variables
### if recursive is true, ExtEntries will be initialized too
### otherwise, they will be set to contain 0 elements.
######################################################################
proc setVariable {function name prefix default recursive} {
  global __widgetArgs __children __editInfo __state
  set type $__widgetArgs(${function}__${name}__type)
  if {$default == ""} {
    set default $__widgetArgs(${function}__${name}__default)
  }

  upvar \#0 ${prefix}_$name variable
  
  switch -exact $type {
    checkbox -
    int      -
    float    -
    label    -
    command -
    textbox -
    combobox -
    entry {
      if {$type == "checkbox" && $default == ""} {
        set variable 0
      } else {
        set variable $default
      }
    }
    radio -
    menu {
      set entries $__widgetArgs(${function}__${name}__entries)
      if {$default == ""} {
        # The default value have to be a valid element.
        set default [lindex $entries 0]
      }
      set index [lsearch -exact $entries $default]
      if {$index == -1} {
        warning "Setting value: \"$default\" isn't an index or element in"\
          "[capitalize $type] \"$name\" on page \"$function\","\
          "should be one of: \"$entries\""
        set default [lindex $entries 0]
        set index 0
      }
      if {$type == "radio"} {
        set variable $index
      } else {
        set variable $default
      }
    }
    listbox {
      set entries $__widgetArgs(${function}__${name}__entries)
      set variable {}
      foreach entry $default {
        if {$entry == ""} {
          # element have to be valid
          continue
        }
        set index [lsearch -exact $entries $entry]
        if {$index == -1} {
          warning "Setting value: \"$entry\" isn't a index or element in"\
            "ListBox \"$name\" on page \"$function\" should be one of:"\
            "\"$entries\""
        } else {
          lappend variable $index
        }
      }
    }
    extentry {
      global __scrollBar
      set count $__widgetArgs(${function}__${name}__count)
      if {$recursive} {
        set maxentries $__widgetArgs(${function}__${name}__maxentries)
        set max [llength $default]
        set childs $__children(${function}__$name)
        if {$maxentries != "Inf"} {
          set max $maxentries 
        }
        for {set row 0} {$row < $max} {incr row} {
          set defaultVal [lindex $default $row]
          set i 0
          foreach child $childs {
            set type $__widgetArgs(${function}__${child}__type)
            if {$type == "header" || $type == "line"} continue
            set j [noOfVariableChildren $function $child]
            if {$i != [expr $i+ $j -1]} {
              setVariable $function $child ${prefix}_$name$row \
                [lrange $defaultVal $i [expr $i+ $j -1]] $recursive
            } else {
              setVariable $function $child ${prefix}_$name$row \
                [lindex $defaultVal $i] $recursive
            }
            incr i $j
          }
        }

        # setting the scrollbar
        set __scrollBar(${prefix}_${name}) "0 $max"
      } else {
        set __scrollBar(${prefix}_${name}) {0 0}
      }
    }
    fillout {
      fillOut_setDefault $function $name $prefix $default
    }
    frame -
    window {
      set i 0
      foreach child $__children(${function}__$name) {
        set type $__widgetArgs(${function}__${child}__type)
        if {$type == "header" || $type == "line"} continue
        set j [noOfVariableChildren $function $child]
        setVariable $function $child $prefix \
          [join [lrange $default $i [expr $i+$j-1]]] $recursive
        incr i $j
      }
    }
    line -
    header {} ;# please ignore.
    default {
      warning "setVariable: unknow widget type: \"$type\""
    }
  }
}
############################################################
#                      scroll bars
############################################################
proc scroll {path prefix name newTop} {
  global __widgetArgs __scrollBar __children __editInfo
  global __initFunc changeElm __activeNivau
  set function $__editInfo(name)
  set w $path._$name
  
  ### reading the scrollbar
  set scrollbar ${w}.scroll
  set oldTop [lindex $__scrollBar(${prefix}_$name) 0]
  set count $__widgetArgs(${function}__${name}__count)
  set total [lindex $__scrollBar(${prefix}_$name) 1]

  if {$newTop < 0} {set newTop 0}
  if {$newTop > $total-$count} {
    set newTop [expr $total-$count]
  }
  if {$count >= $total} return
  
  setScrollBar $scrollbar $newTop $total $count
  set __scrollBar(${prefix}_$name) \
    [list $newTop [lindex $__scrollBar(${prefix}_$name) 1]]
  ### removing the information about that the variable is bound to a widget
  for {set i $oldTop} {$i < $oldTop+$count} {incr i} {
    foreach child $__children(${function}__$name) {
      pack_forget $function ${prefix}_$name$i $child 0
    }
  }

  ### Rebinding the ExtEntry
  for {set row 0} {$row < $count} {incr row} {
    foreach child $__children(${function}__$name) {
      Pack $w.row$row ${prefix}_$name[expr $row+$newTop] $child 0 top $row 1
    }
    if {$__widgetArgs(${function}__${name}__noscissor) == 0} {
      set list {Cut Copy Paste Insert}
      for {set i 0} {$i < 4} {incr i} {
        $w.row$row.edit.menu entryconfigure $i -command \
          "extEntry[lindex $list $i] $path $prefix $name [expr $row+$newTop]"
      }
    }
  }

  ### Calling the cleanUp function
  ### I would love to give progress information here, but a bug in TK
  ### does scroll infinity.
  ### Sun Aug 25 15:32:05 1996 -- Jesper Pedersen
###  startBusy "Updating dependencies..."
  cleanUp $function $prefix $name
###  endBusy

  ### removing the active element from this extentry and below.
  unlink $function $name ""
  resetBelow $name ""
}
############################################################
#              trace function
############################################################
proc trace_textbox {path variable subvar operation} {
  global __copyingTextBoxFlag
  if {[info exists __copyingTextBoxFlag] && $__copyingTextBoxFlag == 1} return
  if {[info command $path] == ""} {
    # the path has disapeared, but we forgot to remove the trace
    uplevel \#0 trace vdelete $variable $operation \"trace_textbox $path\"
    return
  }
  upvar $variable x
  set insert [$path index insert]
  $path delete 1.0 end
  $path insert 1.0 $x
  $path mark set insert $insert
}
proc trace_listbox {path variable subvar operation} {
  global __copyingListBoxFlag
  upvar $variable x
  if {[info exists __copyingListBoxFlag] && $__copyingListBoxFlag == 1} return
  if {[info command $path] == ""} {
    # the path has disapeared, but we forgot to remove the trace
    uplevel \#0 trace vdelete $variable $operation \"trace_listbox $path\"
    return
  }
  $path selection clear 0 end
  foreach index $x {
    $path selection set $index
  }
}
proc scroll_listbox {path prefix args} {
  global ${prefix}_scroll
  eval $path yview $args
  set ${prefix}_scroll [$path nearest 0]
}
############################################################
# This function takes care of the states of the widgets
############################################################
proc setState {function path prefix name active} {
  global __widgetArgs __state __editInfo
  set type $__widgetArgs(${function}__${name}__type)
  if {![info exists __state(${prefix}_$name)]} {
    set __state(${prefix}_$name) "normal"
  }
  set w $path._$name

  switch $type {
    checkbox {
      $path._$name.cb configure -state $__state(${prefix}_$name)
    }
    entry -
    int -
    float -
    label {
      if {$__state(${prefix}_$name) == "normal"} {
        set color black
      } else {
        set color grey
      }
      if {[info commands $w.1] != ""} {
        $w.1 configure -foreground $color
      }
      $w.2 configure -foreground $color

      if {$type != "label"} {
        $w.2 configure -state $__state(${prefix}_$name)
      }
      
      if {[info commands $w.3] != ""} {
        $w.3 configure -foreground $color
      }
    }
    radio {
      set entries $__widgetArgs(${function}__${name}__entries)
      if {$__widgetArgs(${function}__${name}__text) != ""} {
        if {$__state(${prefix}_$name) == "normal"} {
          $w.label configure -foreground black
        } else {
          $w.label configure -foreground grey
        }
      }
      set i 0
      foreach elm $entries {
        $path._$name.radio$i configure -state $__state(${prefix}_$name)
        incr i
      }
    }
    textbox {
      $path._$name.text configure -state $__state(${prefix}_$name)
      set w $path._$name
      if {$__state(${prefix}_$name) == "normal"} {
        $w.scroll configure -command "$w.text yview"
        if {[winfo exists $w.label]} {
          $w.label configure -foreground black
        }
        $w.text configure -foreground black
      } else {
        $w.scroll configure -command ""
        if {[winfo exists $w.label]} {
          $w.label configure -foreground grey
        }
        $w.text configure -foreground grey
      }
    }
    menu {
      set w $path._$name
      $w.bar configure -state $__state(${prefix}_$name)
      if {$__state(${prefix}_$name) == "normal"} {
        $w.tleft configure -foreground black
      } else {
        $w.tleft configure -foreground grey
      }
    }
    listbox {
      set w $path._$name
      if {$__state(${prefix}_$name) == "normal"} {
        $w.scroll configure -command "scroll_listbox $w.box ${prefix}_$name"
        $w.box configure -foreground black -selectforeground white \
          -selectbackground black
        bind $w.box <ButtonRelease-1> "set __copyingListBoxFlag 1;set ${prefix}_$name \[$w.box curselection\];set __copyingListBoxFlag 0;makeChange $name $prefix"
        bindtags $w.box "Listbox $w.box .edit all"
        set color black
      } else {
        bind $w.box <Enter> ""
        bind $w.box <ButtonRelease-1> break
        bind $w.box <ButtonPress-1> break
        bindtags $w.box {$w.box .edit}
        $w.scroll configure -command ""
        $w.box configure -foreground grey -selectforeground black \
          -selectbackground white
        set color grey
      }
      if {$__widgetArgs(${function}__${name}__text) != ""} {
        $w.label configure -fg $color
      }
    }
    combobox {
      set w $path._$name
      if {$__state(${prefix}_$name) == "normal"} {
        set color black
      } else {
        set color grey
      }
      $w.label configure -fg $color
      $w.2 configure -fg $color
      if {$__state(${prefix}_$name) == "normal"} {
        if {!$__widgetArgs(${function}__${name}__noedit)} {
          $w.2 configure -state normal
        }
        $w.combo configure -state normal
        bindtags $w.combo $w.combo
      } else {
        $w.2 configure -state disabled
        $w.combo configure -state disabled
        bindtags $w.combo NONE
      }        
    }
    command {
      set w $path._$name
      global widget $name ${prefix}_$name
      if {$__state(${prefix}_$name) == "normal"} {
        if {$__widgetArgs(${function}__${name}__text) != ""} {
          $w.1 configure -fg black
        }
        set enable $__widgetArgs(${function}__${name}__enable)
        set setvalue $__widgetArgs(${function}__${name}__setvalue)
        $w.2 configure -state normal
        if {$enable != "" && $active} {
          catch {unset widget}
          set widget $w.2
          UpdateActive $name $prefix
          uplevel \#0 $setvalue
          uplevel \#0 $enable
          unset widget
        }
        
      } else {
        set disable $__widgetArgs(${function}__${name}__disable)
        $w.2 configure -state disabled
        if {$__widgetArgs(${function}__${name}__text) != ""} {
          $w.1 configure -fg grey
        }
        if {$disable != "" && $active} {
          catch "unset widget"
          set widget $w.2
          UpdateActive $name $prefix
          uplevel \#0 $disable
          unset widget
        }
      }
    }
    extentry {
      set w $path._$name
      set count $__widgetArgs(${function}__${name}__count)
      set noscissor  $__widgetArgs(${function}__${name}__noscissor)
      if {$__widgetArgs(${function}__${name}__maxentries) == "Inf"} {
        $path._$name.new configure -state $__state(${prefix}_$name)
      }
      if {$__state(${prefix}_$name) == "normal"} {
        $w.scroll configure -command "scroll $path $prefix $name"
        if {!$noscissor} {
          for {set i 0} {$i < $count} {incr i} {
            bindtags $path._$name.row$i.edit \
              "$path._$name.row$i.edit Menubutton .edit all"
          }
        }
        
      } else {
        $w.scroll configure -command ""
        if {!$noscissor} {
          for {set i 0} {$i < $count} {incr i} {
            bindtags $path._$name.row$i.edit None
          }
        }
      }
    }
    fillout {
      set w $path._$name
      if {$__state(${prefix}_$name) == "normal"} {
        bindtags $w.2 "$w.2  .edit all"
        bindtags $w.box "Listbox $w.box .edit all"
        if {[info command $w.scroll] != ""} {
          bindtags $w.scroll "$w.box Scrollbar .edit all"
        }
        bindtags $w.scrollEntry "$w.box Scrollbar .edit all"
        if {[winfo exist $w.1]} {
          $w.1 configure -foreground black
        }
        $w.box configure -foreground black
        $w.2 configure -foreground black
      } else {
        bindtags $w.2 {None}
        bindtags $w.box {None}
        if {[info command $w.scroll] != ""} {
          bindtags $w.scroll {None}
        }
        bindtags $w.scrollEntry {None}
        if {[winfo exist $w.1]} {
          $w.1 configure -foreground grey
        }
        $w.box configure -foreground grey
        $w.2 configure -foreground grey
      }  
    }
    line   -
    frame {}
    header {
      if {$__state(${prefix}_$name) == "normal"} {
        set color black
      } else {
        set color grey
      }
      $w.label configure -fg $color
    }
    window {
      set w $path._${name}_inline
      set state $__state(${prefix}_$name)
      $w.2 configure -state $state
    }
    default {
      error "unknow type $type"
    }
  }
}

############################################################
# this procedure parses the list of elements given to a
# command linke CheckBox, and sort out those for TK.
############################################################
proc parseOptions {list name} {
  global __widgetArgs __TKargs __editInfo __wtypes __wnames

  set function $__editInfo(name) 
  set option ""
  set widget ""
  set nextValue 0
  set type $__widgetArgs(${function}__${name}__type)

  # setting blanks for all tk options
  foreach widget $__wtypes($type) {
    set __TKargs(${function}__${name}__$widget) ""
  }
  set widget ""
  
  foreach var $list {
    if {[string index $var 0] == "-" && [string index $var 1] != "-"} {
      if {$nextValue == 1} {
        error "No value to option \"$option\" in \"$name\""
      }

      # seting the tk option for the last element.
      if {$widget != ""} {
        append __TKargs(${function}__${name}__$widget) \
          " -$option $__widgetArgs(${function}__${name}__$option)"
      }

      set nextValue 1
      set option [string range $var 1 end]
      set first 1

      # checking if the option is one for TK
      if {[lsearch $__wnames($type) $option] == -1} {
        # the option name was not one of the standard options like
        # -text -default etc.
        if {![regexp {^([^:]+):([^:]+)$} $option all widget option]} {
          # There were no colon in the name, so the option goes to the
          # default element.
          set widget [lindex [split $__wtypes($type)] 0]
        } else {
          # a colon was found so we now know the widget and the option
          # so lets check if the widget is known
          if {[lsearch -exact $__wtypes($type) $widget] == -1} {
            error [concat "bad widget: \"$widget\" in option $all," \
                     "should be one of: \"$__wtypes($type)\""]
          }
        }
      } else {
        set widget ""
      }
    } else {
      set nextValue 0
      if {$option == ""} {
        error [concat "value without option: \"$name\"" \
                 "in $function, input string: \"$var\""]
      }
      if {[string index $var 0] == "-"} {
        set var [string range $var 1 end]
      }
      if {[info exists __widgetArgs(${function}__${name}__$option)] & !$first} {
        append __widgetArgs(${function}__${name}__$option) " $var"
      } else {
        set __widgetArgs(${function}__${name}__$option) $var
      }
      set first 0
    }
  }
  
  # seting the tk option for the last element.
  if {$widget != ""} {
    append __TKargs(${function}__${name}__$widget) \
      " -$option $__widgetArgs(${function}__${name}__$option)"
  }
}

proc comandInvoke {w prefix name} {
  global __widgetArgs __editInfo $name ${prefix}_$name widget
  set function $__editInfo(name)
  set invoke $__widgetArgs(${function}__${name}__invoke)
  set setvalue $__widgetArgs(${function}__${name}__setvalue)
  catch "unset widget"
  UpdateActive $name $prefix
  set widget $w.2
  set result [uplevel \#0 $invoke]
  set ${prefix}_$name $result
  set $name $result
  uplevel \#0 $setvalue
  unset widget
}


######################################################################
### This function is called, when the window is opened.
######################################################################
proc showWindow {path prefix name row} {
  global __editInfo __children __widgetArgs __parent __clean __windows
  set w .window_${prefix}_$name
  set function $__editInfo(name)
  set orient $__widgetArgs(${function}__${name}__orient)

  UpdateActive [lindex $__children(${function}__$name) 0] $prefix
  if {[winfo exists $w]} {
    wm deiconify $w
    raise $w
  } else {
    toplevel $w
    wm resizable $w 0 0
    set __windows(${prefix}_$name) [list $function $path $prefix $name]
    
    ### set the title
    if {$__widgetArgs(${function}__${name}__title) != ""} {
      set text $__widgetArgs(${function}__${name}__title)
    } else {
      set text $__widgetArgs(${function}__${name}__text)
    }

    ### 
    set par $__parent(${function}__$name)
    if {[info exists __widgetArgs(${function}__${par}__type)]} {
      set partype $__widgetArgs(${function}__${par}__type)
      if {$partype == "extentry" &&
          $__widgetArgs(${function}__${par}__index) != ""} {
        set indexElm $__widgetArgs(${function}__${par}__index)
        global ${prefix}_$indexElm
        set text "$text - [set ${prefix}_$indexElm]"
      }
    }
    wm title $w $text

    ### creating the frame for the options
    frame $w.options -borderwidth 1 -relief sunken
    pack $w.options  -expand 1 -fill both -expand 1

    ### calling recursive
    foreach child $__children(${function}__$name) {
      Pack $w.options $prefix $child 1 $orient $row 1
    }

    ### Creating the description field
    pack [frame $w.description -bd 0] -fill x
    label $w.description.desc -justify left
    pack $w.description.desc -fill x
    help $name $w
    bind $w.description.desc <3> "help $name $w"
    
    pack [frame $w.line -height 0.1c -relief sunken -bd 1] -fill x -expand yes

    ### Creating the close button
    button $w.close -text Close \
      -command "closeWindow $path $prefix $name"
    pack $w.close

    wm protocol $w WM_DELETE_WINDOW "closeWindow $path $prefix $name"

    ### take grab if another window has it, and give it back, when
    ### the window is closed.

    ### There seems to be a bug in TK 8.0, so I have to catch errors
    ### from the following commmand
    catch "tkwait visibility $w"
    if {[winfo exists $w] && [grab current $w] != {}} {
      update
      pushGrab [grab status [grab current $w]] $w
      tkwait window $w
      popGrab
    }
  }
}

proc closeWindow {path prefix name} {
  global __widgetArgs __editInfo __var2path __children __windows
  set function  $__editInfo(name)
  UpdateActive [lindex $__children(${function}__$name) 0] $prefix
  set err [catch {uplevel \#0 $__widgetArgs(${function}__${name}__pageEnd)} errmsg]
  if {$err} {
    tk_dialog .errmsg "Error in page" $errmsg error 0 OK
    return error
  } else {
    foreach child $__children(${function}__${name}) {
      pack_forget $function $prefix $child 1
    }
    destroy .window_${prefix}_$name
    unset __windows(${prefix}_$name)
    return ok
  }
}

proc popUpCombo {path prefix name} {
  global __widgetArgs __editInfo ${prefix}_$name

  set function $__editInfo(name)
  set entries $__widgetArgs(${function}__${name}__entries)
  set count $__widgetArgs(${function}__${name}__count)
  set width $__widgetArgs(${function}__${name}__comboWidth)

  set index [popUpComboBox $path $entries $count $width $name [set ${prefix}_$name]]
  if {$index == -1} {
    return
  } else {
    set ${prefix}_$name [lindex $entries $index]
  }
}

######################################################################
### This function is used when an element is removed from the screen
### At this point it is only called, when the Window element
### removes it window. It unsets the variable __var2path
######################################################################
proc pack_forget {function prefix name windowsToo} {
  global __widgetArgs __children __var2path __scrollBar
  set type $__widgetArgs(${function}__${name}__type)
  if {![info exists __var2path(${prefix}_$name)]} return
  unset __var2path(${prefix}_$name)
  switch $type {
    checkbox -
    radio -
    int -
    float -
    entry -
    textbox -
    listbox -
    menu -
    combobox -
    label -
    line -
    fillout -
    filloutelm -
    command -
    header {}

    frame -
    window {
      if {$windowsToo || $type =="frame"} {
        foreach child $__children(${function}__$name) {
          pack_forget $function $prefix $child $windowsToo
        }
      }
    }
    extentry {
      set count $__widgetArgs(${function}__${name}__count)
      catch "unset __var2path(${prefix}_$name)"
      set offset [lindex $__scrollBar(${prefix}_$name) 0]
      for {set row 0} {$row < $count} {incr row} {
        foreach child $__children(${function}__$name) {
          pack_forget $function ${prefix}_$name[expr $row + $offset] $child \
            $windowsToo
        }
      }
    }
    default {
      error "pack_forget: unknow type \"$type\" of element \"$name\""
    }
  }
}

######################################################################
###
######################################################################
proc setScrollBar {path first total window} {
  if {$total == 0} {
    $path  set 0 0 0 0
  } else {
    $path  set $total $window $first [expr $first+$window-1]
  }
  
}

######################################################################
### This function is called, when the user press the "new tuple"
### button in extentries.
######################################################################
proc newTuple {function path prefix name} {
  global __scrollBar __widgetArgs __children __initFunc __activeNivau 
  global changeElm

  startBusy "Adding tuple..."
  set total [lindex $__scrollBar(${prefix}_$name) 1]
  set childs $__children(${function}__$name)
  set count $__widgetArgs(${function}__${name}__count)
  set __scrollBar(${prefix}_$name) \
    [list [lindex $__scrollBar(${prefix}_$name) 0] [expr $total+1]]
  # initializing the new value
  foreach child $childs {
    setVariable $function $child ${prefix}_${name}$total \
      $__widgetArgs(${function}__${child}__default) 1
  }
  UpdateActive [lindex $childs 0] ${prefix}_${name}$total
  set __activeNivau($name) $total

  ### Call the Init function
  set changeElm $name
  uplevel \#0 $__initFunc($function)

  if {$total < $count} {
    ### a new element of those which initialy were disabled are now
    ### enabled
    foreach child $childs {
      changeState $function ${prefix}_$name$total $child normal 1
    }
    $path._$name.row$total.edit configure -state normal
    foreach child $childs {
      Pack $path._$name.row$total ${prefix}_$name$total $child 0 \
        $__widgetArgs(${function}__${name}__orient) $total 1
    }
  }

  ### set the scrollbar
  if {$total >= $count} {
    scroll $path $prefix $name [expr $total+1 - $count]
  }

  ### Call the Change function
  cleanUp $function $prefix $name $total
  endBusy
}
