/*
 * Decompiled with CFR 0.152.
 */
package net.sf.gogui.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.util.HashMap;
import java.util.HashSet;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.Scrollable;
import javax.swing.SpringLayout;
import javax.swing.UIManager;
import net.sf.gogui.game.GameTree;
import net.sf.gogui.game.Node;
import net.sf.gogui.game.NodeUtils;
import net.sf.gogui.gui.GameTreeJunction;
import net.sf.gogui.gui.GameTreeNode;
import net.sf.gogui.gui.GameTreeViewer;
import net.sf.gogui.gui.GuiUtils;
import net.sf.gogui.gui.SimpleDialogs;
import net.sf.gogui.gui.TextViewer;

public class GameTreePanel
extends JPanel
implements Scrollable {
    public static final int LABEL_NUMBER = 0;
    public static final int LABEL_MOVE = 1;
    public static final int LABEL_NONE = 2;
    public static final int SIZE_LARGE = 0;
    public static final int SIZE_NORMAL = 1;
    public static final int SIZE_SMALL = 2;
    public static final int SIZE_TINY = 3;
    public static final Color BACKGROUND;
    private final boolean m_fastPaint;
    private boolean m_showSubtreeSizes;
    private int m_currentNodeX;
    private int m_currentNodeY;
    private int m_labelMode;
    private int m_minHeight;
    private int m_minWidth;
    private int m_sizeMode;
    private int m_nodeSize;
    private int m_nodeFullSize;
    private static final int MARGIN = 15;
    private int m_maxX;
    private int m_maxY;
    private static final long serialVersionUID = 0L;
    private Dimension m_preferredNodeSize;
    private Font m_font;
    private GameTree m_gameTree;
    private final GameTreeViewer.Listener m_listener;
    private final JDialog m_owner;
    private JScrollPane m_scrollPane;
    private Node m_currentNode;
    private Node m_popupNode;
    private final HashMap m_map = new HashMap(500, 0.8f);
    private final HashSet m_expanded = new HashSet(200);
    private final MouseListener m_mouseListener;
    private Point m_popupLocation;
    static final /* synthetic */ boolean $assertionsDisabled;

    public GameTreePanel(JDialog jDialog, GameTreeViewer.Listener listener, boolean bl, int n, int n2) {
        super(new SpringLayout());
        this.m_owner = jDialog;
        this.m_fastPaint = bl;
        this.setBackground(BACKGROUND);
        this.m_labelMode = n;
        this.m_sizeMode = n2;
        this.computeSizes(n2);
        this.setFocusable(false);
        this.setFocusTraversalKeysEnabled(false);
        this.setAutoscrolls(true);
        this.addMouseMotionListener(new MouseMotionListener());
        this.m_listener = listener;
        this.m_mouseListener = new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getButton() != 1) {
                    return;
                }
                GameTreeNode gameTreeNode = (GameTreeNode)mouseEvent.getSource();
                if (mouseEvent.getClickCount() == 2) {
                    Node node = gameTreeNode.getNode();
                    if (node.getNumberChildren() > 1) {
                        if (GameTreePanel.this.m_expanded.contains(node)) {
                            GameTreePanel.this.hideSubtree(node);
                        } else {
                            GameTreePanel.this.showVariations(node);
                        }
                    }
                } else {
                    GameTreePanel.this.gotoNode(gameTreeNode.getNode());
                }
            }

            public void mousePressed(MouseEvent mouseEvent) {
                if (mouseEvent.isPopupTrigger()) {
                    GameTreeNode gameTreeNode = (GameTreeNode)mouseEvent.getSource();
                    int n = mouseEvent.getX();
                    int n2 = mouseEvent.getY();
                    GameTreePanel.this.showPopup(n, n2, gameTreeNode);
                }
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                if (mouseEvent.isPopupTrigger()) {
                    GameTreeNode gameTreeNode = (GameTreeNode)mouseEvent.getSource();
                    int n = mouseEvent.getX();
                    int n2 = mouseEvent.getY();
                    GameTreePanel.this.showPopup(n, n2, gameTreeNode);
                }
            }
        };
    }

    public Node getCurrentNode() {
        return this.m_currentNode;
    }

    public boolean getFastPaint() {
        return this.m_fastPaint;
    }

    public int getLabelMode() {
        return this.m_labelMode;
    }

    public int getNodeFullSize() {
        return this.m_nodeFullSize;
    }

    public int getNodeSize() {
        return this.m_nodeSize;
    }

    public Dimension getPreferredScrollableViewportSize() {
        return new Dimension(this.m_nodeFullSize * 10, this.m_nodeFullSize * 3);
    }

    public int getScrollableBlockIncrement(Rectangle rectangle, int n, int n2) {
        int n3 = n == 1 ? rectangle.height : rectangle.width;
        n3 = n3 / this.m_nodeFullSize * this.m_nodeFullSize;
        return n3;
    }

    public boolean getScrollableTracksViewportHeight() {
        return false;
    }

    public boolean getScrollableTracksViewportWidth() {
        return false;
    }

    public int getScrollableUnitIncrement(Rectangle rectangle, int n, int n2) {
        return this.m_nodeFullSize;
    }

    public boolean getShowSubtreeSizes() {
        return this.m_showSubtreeSizes;
    }

    public int getSizeMode() {
        return this.m_sizeMode;
    }

    public void gotoNode(Node node) {
        if (this.m_listener != null) {
            this.m_listener.cbGotoNode(node);
        }
    }

    public boolean isCurrent(Node node) {
        return node == this.m_currentNode;
    }

    public boolean isExpanded(Node node) {
        return this.m_expanded.contains(node);
    }

    public void paintComponent(Graphics graphics) {
        if (!this.getFastPaint()) {
            GuiUtils.setAntiAlias(graphics);
        }
        super.paintComponent(graphics);
    }

    public void redrawCurrentNode() {
        GameTreeNode gameTreeNode = this.getGameTreeNode(this.m_currentNode);
        gameTreeNode.repaint();
    }

    public void scrollToCurrent() {
        this.scrollRectToVisible(new Rectangle(this.m_currentNodeX - 2 * this.m_nodeSize, this.m_currentNodeY, 5 * this.m_nodeSize, 3 * this.m_nodeSize));
    }

    public void setLabelMode(int n) {
        switch (n) {
            case 0: 
            case 1: 
            case 2: {
                this.m_labelMode = n;
                break;
            }
            default: {
                if (!$assertionsDisabled) {
                    throw new AssertionError();
                }
                break;
            }
        }
    }

    public void setScrollPane(JScrollPane jScrollPane) {
        this.m_scrollPane = jScrollPane;
    }

    public void setShowSubtreeSizes(boolean bl) {
        this.m_showSubtreeSizes = bl;
    }

    public void setSizeMode(int n) {
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                if (n == this.m_sizeMode) break;
                this.m_sizeMode = n;
                this.computeSizes(this.m_sizeMode);
                break;
            }
            default: {
                if (!$assertionsDisabled) {
                    throw new AssertionError();
                }
                break;
            }
        }
    }

    public void addNewSingleChild(Node node) {
        if (!$assertionsDisabled && node.getNumberChildren() != 0) {
            throw new AssertionError();
        }
        Node node2 = node.getFather();
        if (!$assertionsDisabled && node2 == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && node2.getNumberChildren() != 1) {
            throw new AssertionError();
        }
        GameTreeNode gameTreeNode = this.getGameTreeNode(node2);
        if (!$assertionsDisabled && this.isExpanded(node2)) {
            throw new AssertionError();
        }
        int n = NodeUtils.getMoveNumber(node);
        GameTreeNode gameTreeNode2 = new GameTreeNode(node, n, this, this.m_mouseListener, this.m_font, this.m_preferredNodeSize);
        this.m_map.put(node, gameTreeNode2);
        this.add(gameTreeNode2);
        this.putConstraint(gameTreeNode, gameTreeNode2, this.m_nodeFullSize, 0);
        gameTreeNode2.setLocation(gameTreeNode.getX() + this.m_nodeFullSize, gameTreeNode.getY());
        gameTreeNode2.setSize(this.m_nodeFullSize, this.m_nodeFullSize);
        this.m_maxX = Math.max(gameTreeNode.getX() + 2 * this.m_nodeFullSize, this.m_maxX);
        this.setPreferredSize(new Dimension(this.m_maxX + this.m_nodeFullSize + 15, this.m_maxY + this.m_nodeFullSize + 15));
    }

    public void showPopup() {
        if (this.m_currentNode == null) {
            return;
        }
        this.scrollToCurrent();
        GameTreeNode gameTreeNode = this.getGameTreeNode(this.m_currentNode);
        if (gameTreeNode == null) {
            return;
        }
        this.showPopup(gameTreeNode.getWidth() / 2, gameTreeNode.getHeight() / 2, gameTreeNode);
    }

    public void update(GameTree gameTree, Node node, int n, int n2) {
        boolean bl;
        if (!$assertionsDisabled && node == null) {
            throw new AssertionError();
        }
        this.m_minWidth = n;
        this.m_minHeight = n2;
        boolean bl2 = bl = gameTree != this.m_gameTree;
        if (bl) {
            this.m_expanded.clear();
        }
        this.ensureVisible(node);
        this.m_gameTree = gameTree;
        this.m_currentNode = node;
        this.removeAll();
        this.m_map.clear();
        this.m_maxX = n;
        this.m_maxY = n2;
        try {
            Node node2 = this.m_gameTree.getRoot();
            this.createNodes(this, node2, 0, 0, 15, 15, 0);
            if (bl) {
                if (NodeUtils.subtreeGreaterThan(node2, 10000)) {
                    this.showVariations(node2);
                } else {
                    this.showSubtree(node2);
                }
            }
        }
        catch (OutOfMemoryError outOfMemoryError) {
            this.m_expanded.clear();
            this.removeAll();
            SimpleDialogs.showError(this.m_owner, "Could not show game tree\nOut of memory");
            this.update(gameTree, node, n, n2);
        }
        this.setPreferredSize(new Dimension(this.m_maxX + this.m_nodeFullSize + 15, this.m_maxY + this.m_nodeFullSize + 15));
        this.revalidate();
        this.scrollToCurrent();
        if (this.m_scrollPane != null) {
            this.m_scrollPane.requestFocusInWindow();
        }
    }

    public void update(Node node, int n, int n2) {
        if (!$assertionsDisabled && node == null) {
            throw new AssertionError();
        }
        if (this.ensureVisible(node)) {
            this.update(this.m_gameTree, node, n, n2);
            return;
        }
        GameTreeNode gameTreeNode = this.getGameTreeNode(this.m_currentNode);
        gameTreeNode.repaint();
        gameTreeNode = this.getGameTreeNode(node);
        Point point = gameTreeNode.getLocation();
        this.m_currentNodeX = point.x;
        this.m_currentNodeY = point.y;
        gameTreeNode.repaint();
        this.m_currentNode = node;
        this.scrollToCurrent();
        if (this.m_scrollPane != null) {
            this.m_scrollPane.requestFocusInWindow();
        }
    }

    private void computeSizes(int n) {
        Font font;
        double d;
        switch (n) {
            case 0: {
                d = 1.0;
                break;
            }
            case 1: {
                d = 0.7;
                break;
            }
            case 2: {
                d = 0.5;
                break;
            }
            case 3: {
                d = 0.2;
                break;
            }
            default: {
                d = 0.7;
                if (!$assertionsDisabled) {
                    throw new AssertionError();
                }
                break;
            }
        }
        this.m_nodeSize = 25;
        this.m_nodeFullSize = 35;
        Font font2 = UIManager.getFont("Label.font");
        if (font2 != null && (font = font2.deriveFont((float)((double)font2.getSize() * d))) != null) {
            font2 = font;
        }
        if (font2 != null) {
            this.m_nodeSize = font2.getSize() * 2;
            if (this.m_nodeSize % 2 == 0) {
                ++this.m_nodeSize;
            }
            this.m_nodeFullSize = font2.getSize() * 3;
            if (this.m_nodeFullSize % 2 == 0) {
                ++this.m_nodeFullSize;
            }
        }
        this.m_font = font2;
        this.m_preferredNodeSize = new Dimension(this.m_nodeFullSize, this.m_nodeFullSize);
    }

    private int createNodes(Component component, Node node, int n, int n2, int n3, int n4, int n5) {
        int n6;
        Object object;
        boolean bl;
        this.m_maxX = Math.max(n, this.m_maxX);
        this.m_maxY = Math.max(n2, this.m_maxY);
        if (node.getMove() != null) {
            ++n5;
        }
        GameTreeNode gameTreeNode = new GameTreeNode(node, n5, this, this.m_mouseListener, this.m_font, this.m_preferredNodeSize);
        this.m_map.put(node, gameTreeNode);
        this.add(gameTreeNode);
        this.putConstraint(component, gameTreeNode, n3, n4);
        int n7 = node.getNumberChildren();
        n3 = this.m_nodeFullSize;
        n4 = 0;
        int n8 = n7;
        boolean bl2 = bl = n7 > 1 && !this.m_expanded.contains(node);
        if (bl) {
            if (!this.m_showSubtreeSizes) {
                n8 = Math.min(n7, 1);
            } else {
                n8 = 0;
                object = Integer.toString(NodeUtils.subtreeSize(node));
                n6 = ((String)object).length() * this.m_nodeFullSize / 3;
                this.m_maxX = Math.max(n + n6, this.m_maxX);
                JLabel jLabel = new JLabel((String)object);
                jLabel.setFont(this.m_font);
                this.add(jLabel);
                this.putConstraint(gameTreeNode, jLabel, n3, this.m_nodeFullSize / 2);
            }
        }
        if (n8 > 0) {
            object = new int[n8];
            for (n6 = 0; n6 < n8; ++n6) {
                object[n6] = n4;
                n4 += this.createNodes(gameTreeNode, node.getChild(n6), n + n3, n2 + n4, n3, n4, n5);
                if (bl || n6 >= n7 - 1) continue;
                n4 += this.m_nodeFullSize;
            }
            if (n8 > 1) {
                GameTreeJunction gameTreeJunction = new GameTreeJunction((int[])object, this);
                this.add(gameTreeJunction);
                this.putConstraint(gameTreeNode, gameTreeJunction, 0, this.m_nodeFullSize);
            }
        }
        if (node == this.m_currentNode) {
            this.m_currentNodeX = n;
            this.m_currentNodeY = n2;
        }
        return n4;
    }

    private GameTreeNode getGameTreeNode(Node node) {
        return (GameTreeNode)this.m_map.get(node);
    }

    private boolean ensureVisible(Node node) {
        boolean bl = false;
        boolean bl2 = this.getShowSubtreeSizes();
        while (node != null) {
            Node node2 = node.getFather();
            if (node2 != null && (node2.getChild() != node || bl2 && node2.getNumberChildren() > 1) && this.m_expanded.add(node2)) {
                bl = true;
            }
            node = node2;
        }
        return bl;
    }

    private void hideOthers(Node node) {
        this.m_expanded.clear();
        this.ensureVisible(node);
        this.update(this.m_gameTree, this.m_currentNode, this.getWidth(), this.getHeight());
    }

    private void hideSubtree(Node node) {
        boolean bl = false;
        boolean bl2 = false;
        int n = NodeUtils.getDepth(node);
        Node node2 = node;
        while (node2 != null) {
            if (node2 == this.m_currentNode) {
                this.m_currentNode = node;
                bl2 = true;
                bl = true;
            }
            if (this.m_expanded.remove(node2)) {
                bl = true;
            }
            node2 = NodeUtils.nextNode(node2, n);
        }
        if (bl2) {
            this.gotoNode(this.m_currentNode);
            node = this.m_currentNode;
        }
        if (bl) {
            this.update(this.m_gameTree, this.m_currentNode, this.m_minWidth, this.m_minHeight);
            this.scrollTo(node);
        }
    }

    private void nodeInfo(Point point, Node node) {
        String string = NodeUtils.nodeInfo(node);
        String string2 = "Node Info";
        TextViewer textViewer = new TextViewer(this.m_owner, string2, string, true, null, this.m_fastPaint);
        textViewer.setLocation(point);
        textViewer.setVisible(true);
    }

    private void putConstraint(Component component, Component component2, int n, int n2) {
        SpringLayout springLayout = (SpringLayout)this.getLayout();
        springLayout.putConstraint("West", component2, n, "West", component);
        springLayout.putConstraint("North", component2, n2, "North", component);
    }

    private void scrollTo(Node node) {
        if (node == null) {
            return;
        }
        GameTreeNode gameTreeNode = this.getGameTreeNode(node);
        Rectangle rectangle = new Rectangle();
        rectangle.x = gameTreeNode.getLocation().x;
        rectangle.y = gameTreeNode.getLocation().y;
        rectangle.width = 3 * this.m_nodeFullSize;
        rectangle.height = 3 * this.m_nodeFullSize;
        this.scrollRectToVisible(rectangle);
    }

    private void showPopup(int n, int n2, GameTreeNode gameTreeNode) {
        JMenuItem jMenuItem;
        Node node;
        this.m_popupNode = node = gameTreeNode.getNode();
        ActionListener actionListener = new ActionListener(){
            static final /* synthetic */ boolean $assertionsDisabled;

            public void actionPerformed(ActionEvent actionEvent) {
                String string = actionEvent.getActionCommand();
                if (string.equals("goto")) {
                    GameTreePanel.this.gotoNode(GameTreePanel.this.m_popupNode);
                } else if (string.equals("show-variations")) {
                    GameTreePanel.this.showVariations(GameTreePanel.this.m_popupNode);
                } else if (string.equals("show-subtree")) {
                    GameTreePanel.this.showSubtree(GameTreePanel.this.m_popupNode);
                } else if (string.equals("hide-others")) {
                    GameTreePanel.this.hideOthers(GameTreePanel.this.m_popupNode);
                } else if (string.equals("hide-subtree")) {
                    GameTreePanel.this.hideSubtree(GameTreePanel.this.m_popupNode);
                } else if (string.equals("node-info")) {
                    GameTreePanel.this.nodeInfo(GameTreePanel.this.m_popupLocation, GameTreePanel.this.m_popupNode);
                } else if (string.equals("scroll-to-current")) {
                    GameTreePanel.this.scrollTo(GameTreePanel.this.m_currentNode);
                } else if (string.equals("tree-info")) {
                    GameTreePanel.this.treeInfo(GameTreePanel.this.m_popupLocation, GameTreePanel.this.m_popupNode);
                } else if (!$assertionsDisabled) {
                    throw new AssertionError();
                }
            }

            static {
                $assertionsDisabled = !(class$net$sf$gogui$gui$GameTreePanel == null ? (class$net$sf$gogui$gui$GameTreePanel = GameTreePanel.class$("net.sf.gogui.gui.GameTreePanel")) : class$net$sf$gogui$gui$GameTreePanel).desiredAssertionStatus();
            }
        };
        JPopupMenu jPopupMenu = new JPopupMenu();
        if (node != this.m_currentNode) {
            jMenuItem = new JMenuItem("Go To");
            jMenuItem.setActionCommand("goto");
            jMenuItem.addActionListener(actionListener);
            jPopupMenu.add(jMenuItem);
            jMenuItem = new JMenuItem("Scroll to Current");
            jMenuItem.setActionCommand("scroll-to-current");
            jMenuItem.addActionListener(actionListener);
            jPopupMenu.add(jMenuItem);
            jPopupMenu.addSeparator();
        }
        jMenuItem = new JMenuItem("Hide Variations");
        if (node.getNumberChildren() == 0) {
            jMenuItem.setEnabled(false);
        }
        jMenuItem.setActionCommand("hide-subtree");
        jMenuItem.addActionListener(actionListener);
        jPopupMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Hide Others");
        jMenuItem.setActionCommand("hide-others");
        jMenuItem.addActionListener(actionListener);
        jPopupMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Show Variations");
        if (this.m_expanded.contains(node) || node.getNumberChildren() <= 1) {
            jMenuItem.setEnabled(false);
        }
        jMenuItem.setActionCommand("show-variations");
        jMenuItem.addActionListener(actionListener);
        jPopupMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Show Subtree");
        if (node.getNumberChildren() == 0) {
            jMenuItem.setEnabled(false);
        }
        jMenuItem.setActionCommand("show-subtree");
        jMenuItem.addActionListener(actionListener);
        jPopupMenu.add(jMenuItem);
        jPopupMenu.addSeparator();
        jMenuItem = new JMenuItem("Node Info");
        jMenuItem.setActionCommand("node-info");
        jMenuItem.addActionListener(actionListener);
        jPopupMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Subtree Statistics");
        jMenuItem.setActionCommand("tree-info");
        jMenuItem.addActionListener(actionListener);
        jPopupMenu.add(jMenuItem);
        jPopupMenu.putClientProperty("jgoodies.noIcons", Boolean.TRUE);
        jPopupMenu.show(gameTreeNode, n, n2);
        this.m_popupLocation = jPopupMenu.getLocationOnScreen();
    }

    private void showSubtree(Node node) {
        if (NodeUtils.subtreeGreaterThan(node, 10000) && !SimpleDialogs.showQuestion(this.m_owner, "Really expand large subtree?")) {
            return;
        }
        boolean bl = false;
        Node node2 = node;
        int n = NodeUtils.getDepth(node2);
        while (node2 != null) {
            if (node2.getNumberChildren() > 1 && this.m_expanded.add(node2)) {
                bl = true;
            }
            node2 = NodeUtils.nextNode(node2, n);
        }
        if (bl) {
            this.update(this.m_gameTree, this.m_currentNode, this.m_minWidth, this.m_minHeight);
            if (this.getGameTreeNode(node) == null) {
                this.ensureVisible(node);
                this.update(this.m_gameTree, this.m_currentNode, this.m_minWidth, this.m_minHeight);
            }
            this.scrollTo(node);
        }
    }

    private void showVariations(Node node) {
        if (node.getNumberChildren() > 1 && this.m_expanded.add(node)) {
            this.update(this.m_gameTree, this.m_currentNode, this.m_minWidth, this.m_minHeight);
            this.scrollTo(node);
        }
    }

    private void treeInfo(Point point, Node node) {
        String string = NodeUtils.treeInfo(node);
        String string2 = "Subtree Info";
        TextViewer textViewer = new TextViewer(this.m_owner, string2, string, true, null, this.m_fastPaint);
        textViewer.setLocation(point);
        textViewer.setVisible(true);
    }

    static {
        $assertionsDisabled = !GameTreePanel.class.desiredAssertionStatus();
        BACKGROUND = new Color(192, 192, 192);
    }

    private static class MouseMotionListener
    extends MouseMotionAdapter {
        private MouseMotionListener() {
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            int n = mouseEvent.getX();
            int n2 = mouseEvent.getY();
            JPanel jPanel = (JPanel)mouseEvent.getSource();
            Rectangle rectangle = new Rectangle(n, n2, 1, 1);
            jPanel.scrollRectToVisible(rectangle);
        }
    }
}

