/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.launcher.daemon.client;

import org.gradle.internal.jvm.JavaInfo;
import org.gradle.internal.jvm.Jvm;
import org.gradle.internal.jvm.UnsupportedJavaRuntimeException;
import org.gradle.internal.jvm.inspection.JvmVersionDetector;
import org.gradle.internal.service.scopes.Scope;
import org.gradle.internal.service.scopes.ServiceScope;

@ServiceScope(value={Scope.Global.class})
public class JvmVersionValidator {
    private final JvmVersionDetector versionDetector;

    public JvmVersionValidator(JvmVersionDetector versionDetector) {
        this.versionDetector = versionDetector;
    }

    public void validate(JavaInfo resolvedJvm) {
        if (resolvedJvm == Jvm.current()) {
            return;
        }
        int javaVersionMajor = this.versionDetector.getJavaVersionMajor(resolvedJvm);
        UnsupportedJavaRuntimeException.assertIsSupportedDaemonJvmVersion((int)javaVersionMajor);
    }
}

