/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.tribble.util;

import htsjdk.samtools.util.ftp.FTPClient;
import htsjdk.samtools.util.ftp.FTPStream;
import htsjdk.samtools.util.ftp.FTPUtils;
import htsjdk.tribble.util.URLHelper;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;

public class FTPHelper
implements URLHelper {
    private URL url;

    public FTPHelper(URL url) {
        if (!url.getProtocol().toLowerCase().equals("ftp")) {
            throw new IllegalArgumentException("FTPHelper can only be used with ftp protocol, not " + url.getProtocol());
        }
        this.url = url;
    }

    @Override
    public URL getUrl() {
        return this.url;
    }

    @Override
    public long getContentLength() throws IOException {
        return FTPUtils.getContentLength(this.url);
    }

    @Override
    public InputStream openInputStream() throws IOException {
        String file = this.url.getPath();
        FTPClient ftp = FTPUtils.connect(this.url.getHost(), this.url.getUserInfo(), null);
        ftp.pasv();
        ftp.retr(file);
        return new FTPStream(ftp);
    }

    @Override
    public InputStream openInputStreamForRange(long start, long end) throws IOException {
        throw new UnsupportedOperationException("Cannot perform range operations over FTP");
    }

    @Override
    public boolean exists() throws IOException {
        return FTPUtils.resourceAvailable(this.url);
    }
}

