/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ic.doc.scenebeans.bounds;

import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import uk.ac.ic.doc.scenebeans.CompositeNode;
import uk.ac.ic.doc.scenebeans.Input;
import uk.ac.ic.doc.scenebeans.Primitive;
import uk.ac.ic.doc.scenebeans.SceneGraph;
import uk.ac.ic.doc.scenebeans.SceneGraphProcessor;
import uk.ac.ic.doc.scenebeans.Style;
import uk.ac.ic.doc.scenebeans.Transform;

public class LastDrawnBounds
implements SceneGraphProcessor {
    private Rectangle2D _bounds = null;
    private Graphics2D _graphics;
    private AffineTransform _transform;

    public static Rectangle2D getBounds(SceneGraph sceneGraph, Graphics2D graphics2D) {
        LastDrawnBounds lastDrawnBounds = new LastDrawnBounds(graphics2D);
        try {
            sceneGraph.accept(lastDrawnBounds);
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception.getMessage());
        }
        return lastDrawnBounds.getBounds();
    }

    public LastDrawnBounds(Graphics2D graphics2D) {
        this._graphics = graphics2D;
        this._transform = new AffineTransform();
    }

    public LastDrawnBounds(Graphics2D graphics2D, AffineTransform affineTransform) {
        this._graphics = graphics2D;
        this._transform = new AffineTransform(affineTransform);
    }

    public Rectangle2D getBounds() {
        return this._bounds;
    }

    public void process(Primitive primitive) {
        GeneralPath generalPath = new GeneralPath(primitive.getLastDrawnShape());
        generalPath.transform(this._transform);
        this.addBounds(generalPath.getBounds2D());
    }

    public void process(Transform transform) {
        AffineTransform affineTransform = new AffineTransform(this._transform);
        this._transform.concatenate(transform.getLastDrawnTransform());
        transform.getLastDrawnTransformedGraph().accept(this);
        this._transform = affineTransform;
    }

    public void process(Input input) {
        input.getSensitiveGraph().accept(this);
    }

    public void process(Style style) {
        Style.Change change = style.getLastDrawnStyle();
        change.reapplyStyle(this._graphics);
        style.getLastDrawnStyledGraph().accept(this);
        change.restoreStyle(this._graphics);
    }

    public void process(CompositeNode compositeNode) {
        int n = 0;
        while (n < compositeNode.getLastDrawnSubgraphCount()) {
            compositeNode.getLastDrawnSubgraph(n).accept(this);
            ++n;
        }
    }

    protected void addBounds(Rectangle2D rectangle2D) {
        if (rectangle2D != null) {
            if (this._bounds == null) {
                this._bounds = rectangle2D;
            } else {
                this._bounds.add(rectangle2D);
            }
        }
    }
}

