/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.CellRendererPane;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultListSelectionModel;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ActionMapUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.InputMapUIResource;
import javax.swing.plaf.TableUI;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class BasicTableUI
extends TableUI {
    protected FocusListener focusListener;
    protected KeyListener keyListener;
    protected MouseInputListener mouseInputListener;
    protected CellRendererPane rendererPane;
    protected JTable table;
    Border cellBorder;
    TableAction action;
    private PropertyChangeListener propertyChangeListener;

    public static ComponentUI createUI(JComponent jComponent) {
        return new BasicTableUI();
    }

    protected FocusListener createFocusListener() {
        return new FocusHandler();
    }

    protected MouseInputListener createMouseInputListener() {
        return new MouseInputHandler();
    }

    protected KeyListener createKeyListener() {
        return new KeyHandler();
    }

    public Dimension getMaximumSize(JComponent jComponent) {
        int n = 0;
        int n2 = 0;
        while (n2 < this.table.getColumnCount()) {
            n += this.table.getColumnModel().getColumn(n2).getMaxWidth();
            ++n2;
        }
        if (n == 0 || this.table.getRowCount() == 0) {
            return null;
        }
        return new Dimension(n, this.table.getRowCount() * (this.table.getRowHeight() + this.table.getRowMargin()));
    }

    public Dimension getMinimumSize(JComponent jComponent) {
        int n = 0;
        int n2 = 0;
        while (n2 < this.table.getColumnCount()) {
            n += this.table.getColumnModel().getColumn(n2).getMinWidth();
            ++n2;
        }
        if (n == 0 || this.table.getRowCount() == 0) {
            return null;
        }
        return new Dimension(n, this.table.getRowCount() * this.table.getRowHeight());
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        int n = this.table.getColumnModel().getTotalColumnWidth();
        int n2 = this.table.getRowCount() * (this.table.getRowHeight() + this.table.getRowMargin());
        return new Dimension(n, n2);
    }

    protected void installDefaults() {
        LookAndFeel.installColorsAndFont(this.table, "Table.background", "Table.foreground", "Table.font");
        this.table.setGridColor(UIManager.getColor("Table.gridColor"));
        this.table.setSelectionForeground(UIManager.getColor("Table.selectionForeground"));
        this.table.setSelectionBackground(UIManager.getColor("Table.selectionBackground"));
        this.table.setOpaque(true);
        this.rendererPane = new CellRendererPane();
    }

    protected void installKeyboardActions() {
        InputMap inputMap = (InputMap)UIManager.get("Table.ancestorInputMap");
        InputMapUIResource inputMapUIResource = new InputMapUIResource();
        ActionMapUIResource actionMapUIResource = new ActionMapUIResource();
        this.action = new TableAction();
        KeyStroke[] keyStrokeArray = inputMap.allKeys();
        int n = 0;
        while (n < keyStrokeArray.length) {
            KeyStroke keyStroke = keyStrokeArray[n];
            String string = (String)inputMap.get(keyStroke);
            inputMapUIResource.put(KeyStroke.getKeyStroke(keyStroke.getKeyCode(), keyStroke.getModifiers()), string);
            actionMapUIResource.put(string, new ActionListenerProxy(this.action, string));
            ++n;
        }
        inputMapUIResource.setParent(this.table.getInputMap(1).getParent());
        actionMapUIResource.setParent(this.table.getActionMap().getParent());
        this.table.getInputMap(1).setParent(inputMapUIResource);
        this.table.getActionMap().setParent(actionMapUIResource);
    }

    protected void installListeners() {
        if (this.focusListener == null) {
            this.focusListener = this.createFocusListener();
        }
        this.table.addFocusListener(this.focusListener);
        if (this.keyListener == null) {
            this.keyListener = this.createKeyListener();
        }
        this.table.addKeyListener(this.keyListener);
        if (this.mouseInputListener == null) {
            this.mouseInputListener = this.createMouseInputListener();
        }
        this.table.addMouseListener(this.mouseInputListener);
        this.table.addMouseMotionListener(this.mouseInputListener);
        if (this.propertyChangeListener == null) {
            this.propertyChangeListener = new PropertyChangeHandler();
        }
        this.table.addPropertyChangeListener(this.propertyChangeListener);
    }

    protected void uninstallDefaults() {
    }

    protected void uninstallKeyboardActions() {
    }

    protected void uninstallListeners() {
        this.table.removeFocusListener(this.focusListener);
        this.table.removeKeyListener(this.keyListener);
        this.table.removeMouseListener(this.mouseInputListener);
        this.table.removeMouseMotionListener(this.mouseInputListener);
        this.table.removePropertyChangeListener(this.propertyChangeListener);
        this.propertyChangeListener = null;
    }

    public void installUI(JComponent jComponent) {
        this.table = (JTable)jComponent;
        this.installDefaults();
        this.installKeyboardActions();
        this.installListeners();
    }

    public void uninstallUI(JComponent jComponent) {
        this.uninstallListeners();
        this.uninstallKeyboardActions();
        this.uninstallDefaults();
    }

    void paintCell(Graphics graphics, int n, int n2, Rectangle rectangle, TableCellRenderer tableCellRenderer) {
        Component component = this.table.prepareRenderer(tableCellRenderer, n, n2);
        this.rendererPane.paintComponent(graphics, component, this.table, rectangle);
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        int n;
        int n2;
        int n3;
        Point point;
        int n4;
        int n5;
        int n6 = this.table.getColumnCount();
        int n7 = this.table.getRowCount();
        if (n7 == 0 || n6 == 0) {
            return;
        }
        Rectangle rectangle = graphics.getClipBounds();
        Point point2 = new Point(rectangle.x, rectangle.y);
        int n8 = this.table.columnAtPoint(point2);
        if (n8 == -1) {
            n8 = 0;
        }
        if ((n5 = this.table.rowAtPoint(point2)) == -1) {
            n5 = 0;
        }
        if ((n4 = this.table.columnAtPoint(point = new Point(rectangle.x + rectangle.width, rectangle.y + rectangle.height))) == -1) {
            n4 = this.table.getColumnCount() - 1;
        }
        if ((n3 = this.table.rowAtPoint(point)) == -1) {
            n3 = this.table.getRowCount() - 1;
        }
        TableColumnModel tableColumnModel = this.table.getColumnModel();
        int[] nArray = new int[n4 + 1];
        int n9 = n8;
        while (n9 <= n4) {
            nArray[n9] = tableColumnModel.getColumn(n9).getWidth();
            ++n9;
        }
        Rectangle rectangle2 = this.table.getCellRect(n5, n8, false);
        rectangle2.height = this.table.getRowHeight() + this.table.getRowMargin();
        int n10 = rectangle2.x;
        int n11 = rectangle2.y;
        int n12 = rectangle2.height;
        Color color = this.table.getGridColor();
        int n13 = n5;
        while (n13 <= n3) {
            n2 = n8;
            while (n2 <= n4) {
                rectangle2.width = nArray[n2];
                this.paintCell(graphics, n13, n2, rectangle2, this.table.getCellRenderer(n13, n2));
                rectangle2.x += nArray[n2];
                ++n2;
            }
            rectangle2.y += n12;
            rectangle2.x = n10;
            ++n13;
        }
        int n14 = rectangle2.y;
        if (color != null && this.table.getShowVerticalLines()) {
            Color color2 = graphics.getColor();
            graphics.setColor(color);
            n2 = n10;
            n = n8;
            while (n <= n4) {
                graphics.drawLine(n2, n11, n2, n14);
                n2 += nArray[n];
                ++n;
            }
            graphics.setColor(color2);
        }
        if (color != null && this.table.getShowHorizontalLines()) {
            Color color3 = graphics.getColor();
            graphics.setColor(color);
            n2 = n11;
            n = n5;
            while (n <= n3) {
                graphics.drawLine(n10, n2, point.x, n2);
                n2 += n12;
                ++n;
            }
            graphics.setColor(color3);
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public class FocusHandler
    implements FocusListener {
        public void focusGained(FocusEvent focusEvent) {
        }

        public void focusLost(FocusEvent focusEvent) {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public class MouseInputHandler
    implements MouseInputListener {
        Point begin;
        Point curr;

        private final void updateSelection(boolean bl) {
            int n = BasicTableUI.this.table.rowAtPoint(this.begin);
            int n2 = BasicTableUI.this.table.rowAtPoint(this.curr);
            ListSelectionModel listSelectionModel = BasicTableUI.this.table.getSelectionModel();
            if (n != -1 && n2 != -1) {
                if (bl && listSelectionModel.getSelectionMode() != 0) {
                    listSelectionModel.addSelectionInterval(n, n2);
                } else {
                    listSelectionModel.setSelectionInterval(n, n2);
                }
            }
            int n3 = BasicTableUI.this.table.columnAtPoint(this.begin);
            int n4 = BasicTableUI.this.table.columnAtPoint(this.curr);
            ListSelectionModel listSelectionModel2 = BasicTableUI.this.table.getColumnModel().getSelectionModel();
            if (n3 != -1 && n4 != -1) {
                if (bl && listSelectionModel2.getSelectionMode() != 0) {
                    listSelectionModel2.addSelectionInterval(n3, n4);
                } else {
                    listSelectionModel2.setSelectionInterval(n3, n4);
                }
            }
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            int n;
            Point point = mouseEvent.getPoint();
            int n2 = BasicTableUI.this.table.rowAtPoint(point);
            if (BasicTableUI.this.table.isCellEditable(n2, n = BasicTableUI.this.table.columnAtPoint(point))) {
                TableCellEditor tableCellEditor = BasicTableUI.this.table.getCellEditor(n2, n);
                if (tableCellEditor instanceof DefaultCellEditor) {
                    DefaultCellEditor defaultCellEditor = (DefaultCellEditor)tableCellEditor;
                    if (mouseEvent.getClickCount() < defaultCellEditor.getClickCountToStart()) {
                        return;
                    }
                } else if (mouseEvent.getClickCount() < 2) {
                    return;
                }
                BasicTableUI.this.table.editCellAt(n2, n);
            }
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            if (BasicTableUI.this.table.isEnabled()) {
                this.curr = new Point(mouseEvent.getX(), mouseEvent.getY());
                this.updateSelection(mouseEvent.isControlDown());
            }
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }

        public void mouseMoved(MouseEvent mouseEvent) {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (BasicTableUI.this.table.isEnabled()) {
                ListSelectionModel listSelectionModel = BasicTableUI.this.table.getSelectionModel();
                ListSelectionModel listSelectionModel2 = BasicTableUI.this.table.getColumnModel().getSelectionModel();
                int n = listSelectionModel.getLeadSelectionIndex();
                int n2 = listSelectionModel2.getLeadSelectionIndex();
                this.begin = new Point(mouseEvent.getX(), mouseEvent.getY());
                this.curr = new Point(mouseEvent.getX(), mouseEvent.getY());
                if (mouseEvent.isControlDown() && BasicTableUI.this.table.isCellSelected(BasicTableUI.this.table.rowAtPoint(this.begin), BasicTableUI.this.table.columnAtPoint(this.begin))) {
                    BasicTableUI.this.table.getSelectionModel().removeSelectionInterval(BasicTableUI.this.table.rowAtPoint(this.begin), BasicTableUI.this.table.rowAtPoint(this.begin));
                    BasicTableUI.this.table.getColumnModel().getSelectionModel().removeSelectionInterval(BasicTableUI.this.table.columnAtPoint(this.begin), BasicTableUI.this.table.columnAtPoint(this.begin));
                } else {
                    this.updateSelection(mouseEvent.isControlDown());
                }
                if ((n != listSelectionModel.getLeadSelectionIndex() || n2 != listSelectionModel2.getLeadSelectionIndex()) && BasicTableUI.this.table.isEditing()) {
                    BasicTableUI.this.table.editingStopped(new ChangeEvent(mouseEvent));
                }
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (BasicTableUI.this.table.isEnabled()) {
                this.begin = null;
                this.curr = null;
            }
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public class KeyHandler
    implements KeyListener {
        public void keyTyped(KeyEvent keyEvent) {
            int n;
            int n2;
            if (!BasicTableUI.this.table.isEditing() && BasicTableUI.this.table.isEnabled() && BasicTableUI.this.table.isCellEditable(n2 = BasicTableUI.this.table.getSelectedRow(), n = BasicTableUI.this.table.getSelectedColumn())) {
                BasicTableUI.this.table.editCellAt(n2, n);
            }
        }

        public void keyPressed(KeyEvent keyEvent) {
        }

        public void keyReleased(KeyEvent keyEvent) {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class TableAction
    extends AbstractAction {
        public void actionPerformed(ActionEvent actionEvent) {
            DefaultListSelectionModel defaultListSelectionModel = (DefaultListSelectionModel)BasicTableUI.this.table.getSelectionModel();
            DefaultListSelectionModel defaultListSelectionModel2 = (DefaultListSelectionModel)BasicTableUI.this.table.getColumnModel().getSelectionModel();
            int n = defaultListSelectionModel.getLeadSelectionIndex();
            int n2 = BasicTableUI.this.table.getModel().getRowCount() - 1;
            int n3 = defaultListSelectionModel2.getLeadSelectionIndex();
            int n4 = BasicTableUI.this.table.getModel().getColumnCount() - 1;
            String string = actionEvent.getActionCommand();
            if (string.equals("selectPreviousRowExtendSelection")) {
                defaultListSelectionModel.setLeadSelectionIndex(Math.max(n - 1, 0));
                defaultListSelectionModel2.setLeadSelectionIndex(n3);
            } else if (string.equals("selectLastColumn")) {
                defaultListSelectionModel.setSelectionInterval(n, n);
                defaultListSelectionModel2.setSelectionInterval(n4, n4);
            } else if (string.equals("startEditing")) {
                if (BasicTableUI.this.table.isCellEditable(n, n3)) {
                    BasicTableUI.this.table.editCellAt(n, n3);
                }
            } else if (string.equals("selectFirstRowExtendSelection")) {
                defaultListSelectionModel.setLeadSelectionIndex(0);
                defaultListSelectionModel2.setLeadSelectionIndex(n3);
            } else if (string.equals("selectFirstColumn")) {
                defaultListSelectionModel.setSelectionInterval(n, n);
                defaultListSelectionModel2.setSelectionInterval(0, 0);
            } else if (string.equals("selectFirstColumnExtendSelection")) {
                defaultListSelectionModel2.setLeadSelectionIndex(0);
                defaultListSelectionModel.setLeadSelectionIndex(n);
            } else if (string.equals("selectLastRow")) {
                defaultListSelectionModel.setSelectionInterval(n2, n2);
                defaultListSelectionModel2.setSelectionInterval(n3, n3);
            } else if (string.equals("selectNextRowExtendSelection")) {
                defaultListSelectionModel.setLeadSelectionIndex(Math.min(n + 1, n2));
                defaultListSelectionModel2.setLeadSelectionIndex(n3);
            } else if (string.equals("selectFirstRow")) {
                defaultListSelectionModel.setSelectionInterval(0, 0);
                defaultListSelectionModel2.setSelectionInterval(n3, n3);
            } else if (string.equals("selectNextColumnExtendSelection")) {
                defaultListSelectionModel2.setLeadSelectionIndex(Math.min(n3 + 1, n4));
                defaultListSelectionModel.setLeadSelectionIndex(n);
            } else if (string.equals("selectLastColumnExtendSelection")) {
                defaultListSelectionModel2.setLeadSelectionIndex(n4);
                defaultListSelectionModel.setLeadSelectionIndex(n);
            } else if (string.equals("selectPreviousColumnExtendSelection")) {
                defaultListSelectionModel2.setLeadSelectionIndex(Math.max(n3 - 1, 0));
                defaultListSelectionModel.setLeadSelectionIndex(n);
            } else if (string.equals("selectNextRow")) {
                defaultListSelectionModel.setSelectionInterval(Math.min(n + 1, n2), Math.min(n + 1, n2));
                defaultListSelectionModel2.setSelectionInterval(n3, n3);
            } else if (string.equals("scrollUpExtendSelection")) {
                int n5 = n == this.getFirstVisibleRowIndex() ? Math.max(0, n - (this.getLastVisibleRowIndex() - this.getFirstVisibleRowIndex() + 1)) : this.getFirstVisibleRowIndex();
                defaultListSelectionModel.setLeadSelectionIndex(n5);
                defaultListSelectionModel2.setLeadSelectionIndex(n3);
            } else if (string.equals("selectPreviousRow")) {
                defaultListSelectionModel.setSelectionInterval(Math.max(n - 1, 0), Math.max(n - 1, 0));
                defaultListSelectionModel2.setSelectionInterval(n3, n3);
            } else if (string.equals("scrollRightChangeSelection")) {
                int n6 = n3 == this.getLastVisibleColumnIndex() ? Math.min(n4, n3 + (this.getLastVisibleColumnIndex() - this.getFirstVisibleColumnIndex() + 1)) : this.getLastVisibleColumnIndex();
                defaultListSelectionModel2.setSelectionInterval(n6, n6);
                defaultListSelectionModel.setSelectionInterval(n, n);
            } else if (string.equals("selectPreviousColumn")) {
                defaultListSelectionModel.setSelectionInterval(n, n);
                defaultListSelectionModel2.setSelectionInterval(Math.max(n3 - 1, 0), Math.max(n3 - 1, 0));
            } else if (string.equals("scrollLeftChangeSelection")) {
                int n7 = n3 == this.getFirstVisibleColumnIndex() ? Math.max(0, n3 - (this.getLastVisibleColumnIndex() - this.getFirstVisibleColumnIndex() + 1)) : this.getFirstVisibleColumnIndex();
                defaultListSelectionModel2.setSelectionInterval(n7, n7);
                defaultListSelectionModel.setSelectionInterval(n, n);
            } else if (string.equals("clearSelection")) {
                BasicTableUI.this.table.clearSelection();
            } else if (string.equals("cancel")) {
                if (BasicTableUI.this.table.isEditing()) {
                    BasicTableUI.this.table.editingCanceled(new ChangeEvent("cancel"));
                }
            } else if (string.equals("selectNextRowCell") || string.equals("selectPreviousRowCell") || string.equals("selectNextColumnCell") || string.equals("selectPreviousColumnCell")) {
                int n8;
                boolean bl;
                if (BasicTableUI.this.table.getSelectedRowCount() == 0 && BasicTableUI.this.table.getSelectedColumnCount() == 0) {
                    defaultListSelectionModel.setSelectionInterval(0, 0);
                    defaultListSelectionModel2.setSelectionInterval(0, 0);
                    return;
                }
                if (!BasicTableUI.this.table.isCellSelected(n, n3)) {
                    defaultListSelectionModel.addSelectionInterval(defaultListSelectionModel.getMinSelectionIndex(), defaultListSelectionModel.getMinSelectionIndex());
                    defaultListSelectionModel2.addSelectionInterval(defaultListSelectionModel2.getMinSelectionIndex(), defaultListSelectionModel2.getMinSelectionIndex());
                    return;
                }
                boolean bl2 = false;
                if (BasicTableUI.this.table.getSelectedRowCount() > 1 && BasicTableUI.this.table.getRowSelectionAllowed()) {
                    bl2 = true;
                }
                boolean bl3 = bl2;
                boolean bl4 = false;
                if (BasicTableUI.this.table.getSelectedColumnCount() > 1 && BasicTableUI.this.table.getColumnSelectionAllowed()) {
                    bl4 = true;
                }
                if (!(bl = bl4) && !bl3) {
                    if (string.indexOf("Column") != -1) {
                        this.advanceSingleSelection(defaultListSelectionModel2, n4, defaultListSelectionModel, n2, string.equals("selectPreviousColumnCell"));
                    } else {
                        this.advanceSingleSelection(defaultListSelectionModel, n2, defaultListSelectionModel2, n4, string.equals("selectPreviousRowCell"));
                    }
                    return;
                }
                int n9 = BasicTableUI.this.table.getRowSelectionAllowed() ? defaultListSelectionModel.getMaxSelectionIndex() : BasicTableUI.this.table.getModel().getRowCount() - 1;
                int n10 = 0;
                if (BasicTableUI.this.table.getRowSelectionAllowed()) {
                    n10 = defaultListSelectionModel.getMinSelectionIndex();
                }
                int n11 = n10;
                int n12 = BasicTableUI.this.table.getColumnSelectionAllowed() ? defaultListSelectionModel2.getMaxSelectionIndex() : BasicTableUI.this.table.getModel().getColumnCount() - 1;
                int n13 = 0;
                if (BasicTableUI.this.table.getColumnSelectionAllowed()) {
                    n13 = n8 = defaultListSelectionModel2.getMinSelectionIndex();
                }
                if (string.indexOf("Column") != -1) {
                    this.advanceMultipleSelection(defaultListSelectionModel2, n8, n12, defaultListSelectionModel, n11, n9, string.equals("selectPreviousColumnCell"), true);
                } else {
                    this.advanceMultipleSelection(defaultListSelectionModel, n11, n9, defaultListSelectionModel2, n8, n12, string.equals("selectPreviousRowCell"), false);
                }
            } else if (string.equals("selectNextColumn")) {
                defaultListSelectionModel.setSelectionInterval(n, n);
                defaultListSelectionModel2.setSelectionInterval(Math.min(n3 + 1, n4), Math.min(n3 + 1, n4));
            } else if (string.equals("scrollLeftExtendSelection")) {
                int n14 = n3 == this.getFirstVisibleColumnIndex() ? Math.max(0, n3 - (this.getLastVisibleColumnIndex() - this.getFirstVisibleColumnIndex() + 1)) : this.getFirstVisibleColumnIndex();
                defaultListSelectionModel2.setLeadSelectionIndex(n14);
                defaultListSelectionModel.setLeadSelectionIndex(n);
            } else if (string.equals("scrollDownChangeSelection")) {
                int n15 = n == this.getLastVisibleRowIndex() ? Math.min(n2, n + (this.getLastVisibleRowIndex() - this.getFirstVisibleRowIndex() + 1)) : this.getLastVisibleRowIndex();
                defaultListSelectionModel.setSelectionInterval(n15, n15);
                defaultListSelectionModel2.setSelectionInterval(n3, n3);
            } else if (string.equals("scrollRightExtendSelection")) {
                int n16 = n3 == this.getLastVisibleColumnIndex() ? Math.min(n4, n3 + (this.getLastVisibleColumnIndex() - this.getFirstVisibleColumnIndex() + 1)) : this.getLastVisibleColumnIndex();
                defaultListSelectionModel2.setLeadSelectionIndex(n16);
                defaultListSelectionModel.setLeadSelectionIndex(n);
            } else if (string.equals("selectAll")) {
                BasicTableUI.this.table.selectAll();
            } else if (string.equals("selectLastRowExtendSelection")) {
                defaultListSelectionModel.setLeadSelectionIndex(n2);
                defaultListSelectionModel2.setLeadSelectionIndex(n3);
            } else if (string.equals("scrollDownExtendSelection")) {
                int n17 = n == this.getLastVisibleRowIndex() ? Math.min(n2, n + (this.getLastVisibleRowIndex() - this.getFirstVisibleRowIndex() + 1)) : this.getLastVisibleRowIndex();
                defaultListSelectionModel.setLeadSelectionIndex(n17);
                defaultListSelectionModel2.setLeadSelectionIndex(n3);
            } else if (string.equals("scrollUpChangeSelection")) {
                int n18 = n == this.getFirstVisibleRowIndex() ? Math.max(0, n - (this.getLastVisibleRowIndex() - this.getFirstVisibleRowIndex() + 1)) : this.getFirstVisibleRowIndex();
                defaultListSelectionModel.setSelectionInterval(n18, n18);
                defaultListSelectionModel2.setSelectionInterval(n3, n3);
            } else if (string.equals("selectNextRowChangeLead")) {
                if (defaultListSelectionModel.getSelectionMode() != 2) {
                    defaultListSelectionModel.setSelectionInterval(Math.min(n + 1, n2), Math.min(n + 1, n2));
                    defaultListSelectionModel2.setSelectionInterval(n3, n3);
                } else {
                    defaultListSelectionModel.moveLeadSelectionIndex(Math.min(n + 1, n2));
                }
            } else if (string.equals("selectPreviousRowChangeLead")) {
                if (defaultListSelectionModel.getSelectionMode() != 2) {
                    defaultListSelectionModel.setSelectionInterval(Math.max(n - 1, 0), Math.min(n - 1, 0));
                    defaultListSelectionModel2.setSelectionInterval(n3, n3);
                } else {
                    defaultListSelectionModel.moveLeadSelectionIndex(Math.max(n - 1, 0));
                }
            } else if (string.equals("selectNextColumnChangeLead")) {
                if (defaultListSelectionModel2.getSelectionMode() != 2) {
                    defaultListSelectionModel.setSelectionInterval(n, n);
                    defaultListSelectionModel2.setSelectionInterval(Math.min(n3 + 1, n4), Math.min(n3 + 1, n4));
                } else {
                    defaultListSelectionModel2.moveLeadSelectionIndex(Math.min(n3 + 1, n4));
                }
            } else if (string.equals("selectPreviousColumnChangeLead")) {
                if (defaultListSelectionModel2.getSelectionMode() != 2) {
                    defaultListSelectionModel.setSelectionInterval(n, n);
                    defaultListSelectionModel2.setSelectionInterval(Math.max(n3 - 1, 0), Math.max(n3 - 1, 0));
                } else {
                    defaultListSelectionModel2.moveLeadSelectionIndex(Math.max(n3 - 1, 0));
                }
            } else if (string.equals("addToSelection")) {
                if (!BasicTableUI.this.table.isEditing()) {
                    int n19 = defaultListSelectionModel.getAnchorSelectionIndex();
                    int n20 = defaultListSelectionModel2.getAnchorSelectionIndex();
                    defaultListSelectionModel.addSelectionInterval(n, n);
                    defaultListSelectionModel2.addSelectionInterval(n3, n3);
                    defaultListSelectionModel.setAnchorSelectionIndex(n19);
                    defaultListSelectionModel2.setAnchorSelectionIndex(n20);
                }
            } else if (string.equals("extendTo")) {
                defaultListSelectionModel.setSelectionInterval(defaultListSelectionModel.getAnchorSelectionIndex(), n);
                defaultListSelectionModel2.setSelectionInterval(defaultListSelectionModel2.getAnchorSelectionIndex(), n3);
            } else if (string.equals("toggleAndAnchor")) {
                if (defaultListSelectionModel.isSelectedIndex(n)) {
                    defaultListSelectionModel.removeSelectionInterval(n, n);
                } else {
                    defaultListSelectionModel.addSelectionInterval(n, n);
                }
                if (defaultListSelectionModel2.isSelectedIndex(n3)) {
                    defaultListSelectionModel2.removeSelectionInterval(n3, n3);
                } else {
                    defaultListSelectionModel2.addSelectionInterval(n3, n3);
                }
                defaultListSelectionModel.setAnchorSelectionIndex(n);
                defaultListSelectionModel2.setAnchorSelectionIndex(n3);
            } else if (string.equals("stopEditing")) {
                BasicTableUI.this.table.editingStopped(new ChangeEvent(string));
            }
            if (BasicTableUI.this.table.isEditing() && string != "startEditing" && string != "addToSelection") {
                BasicTableUI.this.table.editingStopped(new ChangeEvent("update"));
            }
            BasicTableUI.this.table.scrollRectToVisible(BasicTableUI.this.table.getCellRect(defaultListSelectionModel.getLeadSelectionIndex(), defaultListSelectionModel2.getLeadSelectionIndex(), false));
            BasicTableUI.this.table.repaint();
        }

        int getFirstVisibleColumnIndex() {
            ComponentOrientation componentOrientation = BasicTableUI.this.table.getComponentOrientation();
            Rectangle rectangle = BasicTableUI.this.table.getVisibleRect();
            if (!componentOrientation.isLeftToRight()) {
                rectangle.translate((int)rectangle.getWidth() - 1, 0);
            }
            return BasicTableUI.this.table.columnAtPoint(rectangle.getLocation());
        }

        int getLastVisibleColumnIndex() {
            ComponentOrientation componentOrientation = BasicTableUI.this.table.getComponentOrientation();
            Rectangle rectangle = BasicTableUI.this.table.getVisibleRect();
            if (componentOrientation.isLeftToRight()) {
                rectangle.translate((int)rectangle.getWidth() - 1, 0);
            }
            return BasicTableUI.this.table.columnAtPoint(rectangle.getLocation());
        }

        int getFirstVisibleRowIndex() {
            ComponentOrientation componentOrientation = BasicTableUI.this.table.getComponentOrientation();
            Rectangle rectangle = BasicTableUI.this.table.getVisibleRect();
            if (!componentOrientation.isLeftToRight()) {
                rectangle.translate((int)rectangle.getWidth() - 1, 0);
            }
            return BasicTableUI.this.table.rowAtPoint(rectangle.getLocation());
        }

        int getLastVisibleRowIndex() {
            ComponentOrientation componentOrientation = BasicTableUI.this.table.getComponentOrientation();
            Rectangle rectangle = BasicTableUI.this.table.getVisibleRect();
            rectangle.translate(0, (int)rectangle.getHeight() - 1);
            if (componentOrientation.isLeftToRight()) {
                rectangle.translate((int)rectangle.getWidth() - 1, 0);
            }
            if (BasicTableUI.this.table.rowAtPoint(rectangle.getLocation()) == -1) {
                if (this.getFirstVisibleRowIndex() == -1) {
                    return -1;
                }
                return BasicTableUI.this.table.getModel().getRowCount() - 1;
            }
            return BasicTableUI.this.table.rowAtPoint(rectangle.getLocation());
        }

        /*
         * Unable to fully structure code
         */
        void advanceMultipleSelection(ListSelectionModel var1_1, int var2_2, int var3_3, ListSelectionModel var4_4, int var5_5, int var6_6, boolean var7_7, boolean var8_8) {
            block14: {
                block16: {
                    block12: {
                        block15: {
                            block13: {
                                var9_9 = var1_1.getLeadSelectionIndex();
                                var10_10 = var4_4.getLeadSelectionIndex();
                                var11_11 = var8_8 != false ? BasicTableUI.this.table.getModel().getColumnCount() : BasicTableUI.this.table.getModel().getRowCount();
                                v0 = var12_12 = var8_8 != false ? BasicTableUI.this.table.getModel().getRowCount() : BasicTableUI.this.table.getModel().getColumnCount();
                                if ((var9_9 != var3_3 || var7_7) && (!var7_7 || var9_9 != var2_2)) break block12;
                                var1_1.addSelectionInterval(var7_7 != false ? var3_3 : var2_2, var7_7 != false ? var3_3 : var2_2);
                                if ((var10_10 != var6_6 || var7_7) && (!var7_7 || var10_10 != var5_5)) break block13;
                                var4_4.addSelectionInterval(var7_7 != false ? var6_6 : var5_5, var7_7 != false ? var6_6 : var5_5);
                                break block14;
                            }
                            if (var8_8 && BasicTableUI.this.table.getRowSelectionAllowed() || !var8_8 && BasicTableUI.this.table.getColumnSelectionAllowed()) {
                                var13_13 = var8_8 != false ? BasicTableUI.this.table.getSelectedRows() : BasicTableUI.this.table.getSelectedColumns();
                            } else {
                                var13_13 = new int[var12_12];
                                var14_15 = 0;
                                while (var14_15 < var12_12) {
                                    var13_13[var14_15] = var14_15;
                                    ++var14_15;
                                }
                            }
                            v1 = 0;
                            if (var7_7) {
                                v1 = var14_15 = var13_13.length - 1;
                            }
                            if (var7_7) ** GOTO lbl29
                            while (var13_13[var14_15] <= var10_10) {
                                ++var14_15;
                            }
                            break block15;
lbl-1000:
                            // 1 sources

                            {
                                --var14_15;
lbl29:
                                // 2 sources

                                ** while (var13_13[var14_15] >= var10_10)
                            }
                        }
                        var4_4.addSelectionInterval(var13_13[var14_15], var13_13[var14_15]);
                        break block14;
                    }
                    if (var8_8 && BasicTableUI.this.table.getColumnSelectionAllowed() || !var8_8 && BasicTableUI.this.table.getRowSelectionAllowed()) {
                        var13_14 = var8_8 != false ? BasicTableUI.this.table.getSelectedColumns() : BasicTableUI.this.table.getSelectedRows();
                    } else {
                        var13_14 = new int[var11_11];
                        var14_16 = 0;
                        while (var14_16 < var11_11) {
                            var13_14[var14_16] = var14_16;
                            ++var14_16;
                        }
                    }
                    v2 = 0;
                    if (var7_7) {
                        v2 = var14_16 = var13_14.length - 1;
                    }
                    if (var7_7) ** GOTO lbl52
                    while (var13_14[var14_16] <= var9_9) {
                        ++var14_16;
                    }
                    break block16;
lbl-1000:
                    // 1 sources

                    {
                        --var14_16;
lbl52:
                        // 2 sources

                        ** while (var13_14[var14_16] >= var9_9)
                    }
                }
                var1_1.addSelectionInterval(var13_14[var14_16], var13_14[var14_16]);
                var4_4.addSelectionInterval(var10_10, var10_10);
            }
        }

        void advanceSingleSelection(ListSelectionModel listSelectionModel, int n, ListSelectionModel listSelectionModel2, int n2, boolean bl) {
            int n3 = listSelectionModel.getLeadSelectionIndex();
            int n4 = listSelectionModel2.getLeadSelectionIndex();
            if (bl && n3 == 0) {
                if (n4 == 0) {
                    n4 += n2 + 1;
                }
                n4 -= 2;
            }
            if (bl && n3 == 0 || !bl && n3 == n) {
                listSelectionModel2.setSelectionInterval((n4 + 1) % (n2 + 1), (n4 + 1) % (n2 + 1));
            } else {
                listSelectionModel2.setSelectionInterval(n4, n4);
            }
            if (bl) {
                if (n3 == 0) {
                    n3 += n + 1;
                }
                n3 -= 2;
            }
            listSelectionModel.setSelectionInterval((n3 + 1) % (n + 1), (n3 + 1) % (n + 1));
        }

        TableAction() {
        }
    }

    private static class ActionListenerProxy
    extends AbstractAction {
        ActionListener target;
        String bindingCommandName;

        public void actionPerformed(ActionEvent actionEvent) {
            ActionEvent actionEvent2 = new ActionEvent(actionEvent.getSource(), actionEvent.getID(), this.bindingCommandName, actionEvent.getModifiers());
            this.target.actionPerformed(actionEvent2);
        }

        public ActionListenerProxy(ActionListener actionListener, String string) {
            this.target = actionListener;
            this.bindingCommandName = string;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class PropertyChangeHandler
    implements PropertyChangeListener {
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (string.equals("model")) {
                ListSelectionModel listSelectionModel = BasicTableUI.this.table.getSelectionModel();
                listSelectionModel.clearSelection();
                ListSelectionModel listSelectionModel2 = BasicTableUI.this.table.getColumnModel().getSelectionModel();
                listSelectionModel2.clearSelection();
                TableModel tableModel = BasicTableUI.this.table.getModel();
                if (tableModel.getRowCount() > 0) {
                    listSelectionModel.setAnchorSelectionIndex(0);
                    listSelectionModel.setLeadSelectionIndex(0);
                } else {
                    listSelectionModel.setAnchorSelectionIndex(-1);
                    listSelectionModel.setLeadSelectionIndex(-1);
                }
                if (tableModel.getColumnCount() > 0) {
                    listSelectionModel2.setAnchorSelectionIndex(0);
                    listSelectionModel2.setLeadSelectionIndex(0);
                } else {
                    listSelectionModel2.setAnchorSelectionIndex(-1);
                    listSelectionModel2.setLeadSelectionIndex(-1);
                }
            }
        }

        private PropertyChangeHandler() {
        }
    }
}

