;;Example of a ViDAL (ViSta Data Analysis Language) script file.
;;Load this file with the Load-Edit command.

;;Performs the tutorial example in Chapter 2 of the ViSta User's guide.
;;The step numbers correspond to the numbers of the steps in the tutorial.


(when *guidemap* (send *guidemap* :close))  
(show-workmap)

;1 These steps for showing the guidemap and hiding it are not necessary
;(show-guidemap)
;(hide-guidemap)

;2 Load the data.  
(load-data (strcat *examples-data-dir-name* "carprefs.lsp"))

;3 Explore the data.
(show-datasheet)
(list-observations)
(list-variables)
(visualize-data)
(report-data)
(summarize-data)

;4 Subset the data.
(select-variables '("pgmr1"  "pgmr2"  "pgmr3"  "pgmr4"  "pgmr5"  "pgmr6" 
    "pgmr7" "pgmr8" "pgmr9"  "pgmr10" "prsdnt" "mktng1" "mktng2" "grandma"))
(create-data "subset")

;5 Save the data.
(save-data "filename")

;6 Load another dataset.
(load-data (strcat *data-dir-name* "carrats.lsp"))

;7 Explore the second data.
(show-datasheet)
(list-observations)
(list-variables)
(visualize-data)
(report-data)
(summarize-data)

;8 Normalize the second data.
(normalize-data)
(summarize-data)

;9 Do a Principal Component Analysis of the second data, creating a model.
(principal-components :data subset)

;10 Explore the principal component model.
(visualize-model)
(report-model)

;11 Create output data from the model
(create-data)

;12 Merge data objects
(setcd norm-carratings)
(setcd scores-pca-subset)
(merge-variables "Ratings-and-Scores")

;13 Toolbar is already showing
;(show-toolbar)

;14 Save the merged data.
(save-data "ratscors")

;15 Save the Principal Component model
(setcm pca-subset)
(save-model "pcacarpf")

;16 Load the model back into ViSta.
(load-model "pcacarpf.lsp")

(vista-message "Tutorial script is finished.")