/*
 * Decompiled with CFR 0.152.
 */
package phase;

import blbutil.BitList;
import blbutil.DoubleArray;
import ints.IntArray;
import ints.IntList;
import vcf.Markers;

public final class SamplePhase {
    private final Markers markers;
    private BitList hap1;
    private BitList hap2;
    private IntArray unphased;
    private final IntArray missing;
    private final byte[] clustSize;

    public SamplePhase(Markers markers, DoubleArray doubleArray, int[] nArray, int[] nArray2, IntArray intArray, IntArray intArray2) {
        int n = markers.size();
        if (n != doubleArray.size()) {
            throw new IllegalArgumentException(String.valueOf(doubleArray.size()));
        }
        if (nArray.length != n) {
            throw new IllegalArgumentException(String.valueOf(nArray.length));
        }
        if (nArray2.length != n) {
            throw new IllegalArgumentException(String.valueOf(nArray2.length));
        }
        SamplePhase.checkIncreasing(intArray, n);
        SamplePhase.checkIncreasing(intArray2, n);
        this.markers = markers;
        this.hap1 = new BitList(markers.sumHapBits());
        this.hap2 = new BitList(markers.sumHapBits());
        markers.allelesToBits(nArray, this.hap1);
        markers.allelesToBits(nArray2, this.hap2);
        this.unphased = intArray;
        this.missing = intArray2;
        float f = 0.005f;
        this.clustSize = SamplePhase.clustSize(nArray, nArray2, intArray2, doubleArray, f);
    }

    private static void checkIncreasing(IntArray intArray, int n) {
        int n2 = -1;
        int n3 = intArray.size();
        for (int i = 0; i < n3; ++i) {
            if (intArray.get(i) <= n2) {
                throw new IllegalArgumentException(intArray.toString());
            }
            n2 = intArray.get(i);
        }
        if (n2 >= n) {
            throw new IllegalArgumentException(intArray.toString());
        }
    }

    private static byte[] clustSize(int[] nArray, int[] nArray2, IntArray intArray, DoubleArray doubleArray, float f) {
        IntList intList = new IntList(4096);
        int n = doubleArray.size();
        double d = doubleArray.get(0) + (double)f;
        boolean bl = false;
        int n2 = 0;
        int n3 = 0;
        int n4 = n3 < intArray.size() ? intArray.get(n3++) : -1;
        for (int i = 0; i < n; ++i) {
            boolean bl2;
            boolean bl3;
            int n5 = i - n2;
            boolean bl4 = bl3 = i == n4;
            if (bl3) {
                n4 = n3 < intArray.size() ? intArray.get(n3++) : -1;
            }
            boolean bl5 = bl2 = bl3 || nArray[i] != nArray2[i];
            if ((bl || bl2 || doubleArray.get(i) > d || n5 == 255) && i > 0) {
                intList.add(n5);
                d = doubleArray.get(i) + (double)f;
                n2 = i;
            }
            bl = bl2;
        }
        intList.add(n - n2);
        return SamplePhase.toByteArray(intList);
    }

    private static byte[] toByteArray(IntList intList) {
        byte[] byArray = new byte[intList.size()];
        for (int i = 0; i < byArray.length; ++i) {
            byArray[i] = (byte)intList.get(i);
        }
        return byArray;
    }

    public int[] clustEnds() {
        int[] nArray = new int[this.clustSize.length];
        int n = 0;
        for (int i = 0; i < this.clustSize.length; ++i) {
            nArray[i] = n += this.clustSize[i] & 0xFF;
        }
        return nArray;
    }

    public Markers markers() {
        return this.markers;
    }

    public IntArray missing() {
        return this.missing;
    }

    public IntArray unphased() {
        return this.unphased;
    }

    public void setUnphased(IntArray intArray) {
        SamplePhase.checkIncreasing(intArray, this.markers.size());
        this.unphased = intArray;
    }

    public void getHaps(BitList bitList, BitList bitList2) {
        int n = this.markers.sumHapBits();
        if (bitList.size() != n || bitList2.size() != n) {
            throw new IllegalArgumentException("inconsistent data");
        }
        bitList.copyFrom(this.hap1, 0, this.hap1.size());
        bitList2.copyFrom(this.hap2, 0, this.hap2.size());
    }

    public int allele1(int n) {
        return this.markers.allele(this.hap1, n);
    }

    public int allele2(int n) {
        return this.markers.allele(this.hap2, n);
    }

    public void setAllele1(int n, int n2) {
        this.markers.setAllele(n, n2, this.hap1);
    }

    public void setAllele2(int n, int n2) {
        this.markers.setAllele(n, n2, this.hap2);
    }

    public void swapHaps(int n, int n2) {
        int n3 = this.markers.sumHapBits(n);
        int n4 = this.markers.sumHapBits(n2);
        BitList.swapBits(this.hap1, this.hap2, n3, n4);
    }

    public BitList hap1() {
        return new BitList(this.hap1);
    }

    public BitList hap2() {
        return new BitList(this.hap2);
    }
}

