/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.security.x509;

import java.security.cert.PolicyNode;
import java.security.cert.PolicyQualifierInfo;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class PolicyNodeImpl
implements PolicyNode {
    private String policy;
    private final Set expectedPolicies = new HashSet();
    private final Set qualifiers = new HashSet();
    private final Set children = new HashSet();
    private PolicyNodeImpl parent;
    private int depth;
    private boolean critical = false;
    private boolean readOnly = false;
    static /* synthetic */ Class class$gnu$java$security$x509$PolicyNodeImpl;

    public final void addChild(PolicyNodeImpl policyNodeImpl) {
        if (this.readOnly) {
            throw new IllegalStateException("read only");
        }
        if (policyNodeImpl.getParent() != null) {
            throw new IllegalStateException("already a child node");
        }
        policyNodeImpl.parent = this;
        policyNodeImpl.setDepth(this.depth + 1);
        this.children.add(policyNodeImpl);
    }

    public final Iterator getChildren() {
        return Collections.unmodifiableSet(this.children).iterator();
    }

    public final int getDepth() {
        return this.depth;
    }

    public final void setDepth(int n) {
        if (this.readOnly) {
            throw new IllegalStateException("read only");
        }
        this.depth = n;
    }

    public final void addAllExpectedPolicies(Set set) {
        if (this.readOnly) {
            throw new IllegalStateException("read only");
        }
        this.expectedPolicies.addAll(set);
    }

    public final void addExpectedPolicy(String string) {
        if (this.readOnly) {
            throw new IllegalStateException("read only");
        }
        this.expectedPolicies.add(string);
    }

    public final Set getExpectedPolicies() {
        return Collections.unmodifiableSet(this.expectedPolicies);
    }

    public final PolicyNode getParent() {
        return this.parent;
    }

    public final void addAllPolicyQualifiers(Collection collection) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            if (iterator.next() instanceof PolicyQualifierInfo) continue;
            throw new IllegalArgumentException("can only add PolicyQualifierInfos");
        }
        collection.addAll(collection);
    }

    public final void addPolicyQualifier(PolicyQualifierInfo policyQualifierInfo) {
        if (this.readOnly) {
            throw new IllegalStateException("read only");
        }
        this.qualifiers.add(policyQualifierInfo);
    }

    public final Set getPolicyQualifiers() {
        return Collections.unmodifiableSet(this.qualifiers);
    }

    public final String getValidPolicy() {
        return this.policy;
    }

    public final void setValidPolicy(String string) {
        if (this.readOnly) {
            throw new IllegalStateException("read only");
        }
        this.policy = string;
    }

    public final boolean isCritical() {
        return this.critical;
    }

    public final void setCritical(boolean bl) {
        if (this.readOnly) {
            throw new IllegalStateException("read only");
        }
        this.critical = bl;
    }

    public final void setReadOnly() {
        if (this.readOnly) {
            return;
        }
        this.readOnly = true;
        Iterator iterator = this.getChildren();
        while (iterator.hasNext()) {
            ((PolicyNodeImpl)iterator.next()).setReadOnly();
        }
    }

    public final String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < this.depth) {
            stringBuffer.append("  ");
            ++n;
        }
        stringBuffer.append("(");
        Class clazz = class$gnu$java$security$x509$PolicyNodeImpl;
        if (clazz == null) {
            clazz = class$gnu$java$security$x509$PolicyNodeImpl = PolicyNodeImpl.class("[Lgnu.java.security.x509.PolicyNodeImpl;", false);
        }
        stringBuffer.append(clazz.getName());
        stringBuffer.append(" (oid ");
        stringBuffer.append(this.policy);
        stringBuffer.append(") (depth ");
        stringBuffer.append(this.depth);
        stringBuffer.append(") (qualifiers ");
        stringBuffer.append(this.qualifiers);
        stringBuffer.append(") (critical ");
        stringBuffer.append(this.critical);
        stringBuffer.append(") (expectedPolicies ");
        stringBuffer.append(this.expectedPolicies);
        stringBuffer.append(") (children (");
        String string = System.getProperty("line.separator");
        Iterator iterator = this.getChildren();
        while (iterator.hasNext()) {
            stringBuffer.append(string);
            stringBuffer.append(iterator.next().toString());
        }
        stringBuffer.append(")))");
        return stringBuffer.toString();
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }
}

