/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.util.Hashtable;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class JLayeredPane
extends JComponent
implements Accessible {
    private static final long serialVersionUID = 5534920399324590459L;
    public static final String LAYER_PROPERTY = "layeredContainerLayer";
    public static final Integer FRAME_CONTENT_LAYER = new Integer(-30000);
    public static final Integer DEFAULT_LAYER = new Integer(0);
    public static final Integer PALETTE_LAYER = new Integer(100);
    public static final Integer MODAL_LAYER = new Integer(200);
    public static final Integer POPUP_LAYER = new Integer(300);
    public static final Integer DRAG_LAYER = new Integer(400);
    private Hashtable componentToLayer = new Hashtable();
    static /* synthetic */ Class class$javax$swing$JLayeredPane;

    public int getLayer(Component component) {
        Integer n;
        if (component instanceof JComponent) {
            JComponent jComponent = (JComponent)component;
            n = (Integer)jComponent.getClientProperty(LAYER_PROPERTY);
        } else {
            n = (Integer)this.componentToLayer.get(component);
        }
        if (n == null) {
            n = DEFAULT_LAYER;
        }
        return n;
    }

    public static int getLayer(JComponent jComponent) {
        Integer n = (Integer)jComponent.getClientProperty(LAYER_PROPERTY);
        if (n == null) {
            n = DEFAULT_LAYER;
        }
        return n;
    }

    public static JLayeredPane getLayeredPaneAbove(Component component) {
        Class clazz = class$javax$swing$JLayeredPane;
        if (clazz == null) {
            clazz = class$javax$swing$JLayeredPane = JLayeredPane.class("[Ljavax.swing.JLayeredPane;", false);
        }
        JLayeredPane jLayeredPane = (JLayeredPane)SwingUtilities.getAncestorOfClass(clazz, component);
        return jLayeredPane;
    }

    public int highestLayer() {
        int n;
        Component[] componentArray = this.getComponents();
        if (componentArray.length == 0) {
            n = 0;
        } else {
            n = Integer.MIN_VALUE;
            int n2 = 0;
            while (n2 < componentArray.length) {
                n = Math.max(n, this.getLayer(componentArray[n2]));
                ++n2;
            }
        }
        return n;
    }

    public int lowestLayer() {
        int n;
        Component[] componentArray = this.getComponents();
        if (componentArray.length == 0) {
            n = 0;
        } else {
            n = Integer.MAX_VALUE;
            int n2 = 0;
            while (n2 < componentArray.length) {
                n = Math.max(n, this.getLayer(componentArray[n2]));
                ++n2;
            }
        }
        return n;
    }

    public void moveToFront(Component component) {
        this.setPosition(component, 0);
    }

    public void moveToBack(Component component) {
        this.setPosition(component, -1);
    }

    public int getPosition(Component component) {
        int n = -1;
        int n2 = this.getIndexOf(component);
        Component[] componentArray = this.getComponents();
        int n3 = this.getLayer(component);
        if (n2 >= 0) {
            int n4 = n2;
            while (n4 >= 0) {
                if (n3 != this.getLayer(componentArray[n4])) break;
                ++n;
                --n4;
            }
        }
        return n;
    }

    public void setPosition(Component component, int n) {
        int n2 = this.getLayer(component);
        int n3 = this.insertIndexForLayer(n2, n);
        this.setComponentZOrder(component, n3);
    }

    public Component[] getComponentsInLayer(int n) {
        Component[] componentArray = new Component[this.getComponentCountInLayer(n)];
        Component[] componentArray2 = this.getComponents();
        int n2 = 0;
        int n3 = 0;
        while (n3 < componentArray2.length) {
            if (n == this.getLayer(componentArray2[n3])) {
                componentArray[n2] = componentArray2[n3];
                ++n2;
            }
            ++n3;
        }
        return componentArray;
    }

    public int getComponentCountInLayer(int n) {
        Component[] componentArray = this.getComponents();
        int n2 = 0;
        int n3 = componentArray.length - 1;
        while (n3 >= 0) {
            if (this.getLayer(componentArray[n3]) == n) {
                ++n2;
            }
            --n3;
        }
        return n2;
    }

    protected Hashtable getComponentToLayer() {
        return this.componentToLayer;
    }

    public int getIndexOf(Component component) {
        return this.getComponentZOrder(component);
    }

    protected Integer getObjectForLayer(int n) {
        switch (n) {
            case -30000: {
                return FRAME_CONTENT_LAYER;
            }
            case 0: {
                return DEFAULT_LAYER;
            }
            case 100: {
                return PALETTE_LAYER;
            }
            case 200: {
                return MODAL_LAYER;
            }
            case 300: {
                return POPUP_LAYER;
            }
            case 400: {
                return DRAG_LAYER;
            }
        }
        return new Integer(n);
    }

    protected int insertIndexForLayer(int n, int n2) {
        if (n2 < 0) {
            n2 = Integer.MAX_VALUE;
        }
        Component[] componentArray = this.getComponents();
        int n3 = 0;
        int n4 = -1;
        int n5 = 0;
        while (n5 < componentArray.length) {
            int n6 = this.getLayer(componentArray[n5]);
            if (n6 > n) {
                ++n3;
            } else {
                if (n6 != n || ++n4 >= n2) break;
                ++n3;
            }
            ++n5;
        }
        return n3;
    }

    public void remove(int n) {
        Component component = this.getComponent(n);
        if (!(component instanceof JComponent)) {
            this.componentToLayer.remove(component);
        }
        super.remove(n);
    }

    public void removeAll() {
        this.componentToLayer.clear();
        super.removeAll();
    }

    public void setLayer(Component component, int n) {
        this.setLayer(component, n, -1);
    }

    public void setLayer(Component component, int n, int n2) {
        Integer n3 = this.getObjectForLayer(n);
        if (component instanceof JComponent) {
            JComponent jComponent = (JComponent)component;
            jComponent.putClientProperty(LAYER_PROPERTY, n3);
        } else {
            this.componentToLayer.put(component, n3);
        }
        if (this.getIndexOf(component) != -1) {
            this.setPosition(component, n2);
        }
    }

    protected void addImpl(Component component, Object object, int n) {
        int n2 = object != null && object instanceof Integer ? ((Integer)object).intValue() : this.getLayer(component);
        int n3 = this.insertIndexForLayer(n2, n);
        this.setLayer(component, n2);
        super.addImpl(component, object, n3);
    }

    public static void putLayer(JComponent jComponent, int n) {
        jComponent.putClientProperty(LAYER_PROPERTY, new Integer(n));
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleJLayeredPane();
        }
        return this.accessibleContext;
    }

    public void paint(Graphics graphics) {
        if (this.isOpaque()) {
            Color color = graphics.getColor();
            Rectangle rectangle = graphics.getClipBounds();
            graphics.setColor(this.getBackground());
            graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            graphics.setColor(color);
        }
        super.paint(graphics);
    }

    public boolean isOptimizedDrawingEnabled() {
        int n = this.getComponentCount();
        boolean bl = true;
        int n2 = 0;
        while (n2 < n) {
            Rectangle rectangle;
            Component component = this.getComponent(n2);
            if (component.isVisible() && !(rectangle = component.getBounds()).isEmpty()) {
                int n3 = n2 + 1;
                while (n3 < n) {
                    Rectangle rectangle2;
                    Component component2 = this.getComponent(n3);
                    if (component2.isVisible() && !(rectangle2 = component2.getBounds()).isEmpty()) {
                        if (rectangle.intersects(rectangle2)) {
                            bl = false;
                            break;
                        }
                        if (!bl) break;
                    }
                    ++n3;
                }
            }
            ++n2;
        }
        return bl;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    public JLayeredPane() {
        this.setLayout(null);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    protected class AccessibleJLayeredPane
    extends JComponent.AccessibleJComponent {
        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.LAYERED_PANE;
        }

        protected AccessibleJLayeredPane() {
        }
    }
}

