/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.security.x509;

import gnu.java.security.OID;
import gnu.java.security.der.DEREncodingException;
import gnu.java.security.der.DERReader;
import gnu.java.security.der.DERValue;
import gnu.java.security.x509.X509Certificate;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.cert.CertPath;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class X509CertPath
extends CertPath {
    public static final List ENCODINGS = Collections.unmodifiableList(Arrays.asList(new String[]{"PkiPath", "PKCS7"}));
    private static final OID PKCS7_SIGNED_DATA = new OID("1.2.840.113549.1.7.2");
    private static final OID PKCS7_DATA = new OID("1.2.840.113549.1.7.1");
    private List path;
    private byte[] pkcs_encoded;
    private byte[] pki_encoded;

    public List getCertificates() {
        return this.path;
    }

    public byte[] getEncoded() throws CertificateEncodingException {
        return this.getEncoded((String)ENCODINGS.get(0));
    }

    public byte[] getEncoded(String string) throws CertificateEncodingException {
        if (string.equalsIgnoreCase("PkiPath")) {
            if (this.pki_encoded == null) {
                try {
                    this.pki_encoded = this.encodePki();
                }
                catch (IOException iOException) {
                    throw new CertificateEncodingException();
                }
            }
            return (byte[])this.pki_encoded.clone();
        }
        if (string.equalsIgnoreCase("PKCS7")) {
            if (this.pkcs_encoded == null) {
                try {
                    this.pkcs_encoded = this.encodePKCS();
                }
                catch (IOException iOException) {
                    throw new CertificateEncodingException();
                }
            }
            return (byte[])this.pkcs_encoded.clone();
        }
        throw new CertificateEncodingException("unknown encoding: " + string);
    }

    public Iterator getEncodings() {
        return ENCODINGS.iterator();
    }

    private final void parse(InputStream inputStream, String string) throws CertificateEncodingException, IOException {
        Object object;
        DERReader dERReader = new DERReader(inputStream);
        DERValue dERValue = null;
        if (string.equalsIgnoreCase("PkiPath")) {
            dERValue = dERReader.read();
            if (!dERValue.isConstructed()) {
                throw new DEREncodingException("malformed PkiPath");
            }
        } else if (string.equalsIgnoreCase("PKCS7")) {
            object = dERReader.read();
            if (!((DERValue)object).isConstructed()) {
                throw new DEREncodingException("malformed ContentInfo");
            }
            object = dERReader.read();
            if (!(((DERValue)object).getValue() instanceof OID) || ((OID)((DERValue)object).getValue()).equals(PKCS7_SIGNED_DATA)) {
                throw new DEREncodingException("not a SignedData");
            }
            object = dERReader.read();
            if (!((DERValue)object).isConstructed() || ((DERValue)object).getTag() != 0) {
                throw new DEREncodingException("malformed content");
            }
            object = dERReader.read();
            if (((DERValue)object).getTag() != 2) {
                throw new DEREncodingException("malformed Version");
            }
            object = dERReader.read();
            if (!((DERValue)object).isConstructed() || ((DERValue)object).getTag() != 17) {
                throw new DEREncodingException("malformed DigestAlgorithmIdentifiers");
            }
            dERReader.skip(((DERValue)object).getLength());
            object = dERReader.read();
            if (!((DERValue)object).isConstructed()) {
                throw new DEREncodingException("malformed ContentInfo");
            }
            dERReader.skip(((DERValue)object).getLength());
            dERValue = dERReader.read();
            if (!dERValue.isConstructed() || dERValue.getTag() != 0) {
                throw new DEREncodingException("no certificates");
            }
        } else {
            throw new CertificateEncodingException("unknown encoding: " + string);
        }
        object = new LinkedList();
        int n = 0;
        while (n < dERValue.getLength()) {
            DERValue dERValue2 = dERReader.read();
            try {
                ((LinkedList)object).add(new X509Certificate(new ByteArrayInputStream(dERValue2.getEncoded())));
            }
            catch (CertificateException certificateException) {
                throw new CertificateEncodingException(certificateException.getMessage());
            }
            n += dERValue2.getEncodedLength();
            dERReader.skip(dERValue2.getLength());
        }
        this.path = Collections.unmodifiableList((List)object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final byte[] encodePki() throws CertificateEncodingException, IOException {
        List list2 = this.path;
        synchronized (list2) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            Object object = this.path.iterator();
            while (true) {
                if (!object.hasNext()) {
                    object = byteArrayOutputStream.toByteArray();
                    DERValue dERValue = new DERValue(48, ((Object)object).length, object, null);
                    return dERValue.getEncoded();
                }
                byteArrayOutputStream.write(((Certificate)object.next()).getEncoded());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final byte[] encodePKCS() throws CertificateEncodingException, IOException {
        List list2 = this.path;
        synchronized (list2) {
            ArrayList arrayList = new ArrayList(5);
            arrayList.add(new DERValue(2, BigInteger.ONE));
            arrayList.add(new DERValue(49, Collections.EMPTY_SET));
            arrayList.add(new DERValue(48, Collections.singletonList(new DERValue(6, PKCS7_DATA))));
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            Object object = this.path.iterator();
            while (true) {
                if (!object.hasNext()) {
                    object = byteArrayOutputStream.toByteArray();
                    arrayList.add(new DERValue(160, ((Object)object).length, object, null));
                    DERValue dERValue = new DERValue(48, arrayList);
                    ArrayList arrayList2 = new ArrayList(2);
                    arrayList2.add(new DERValue(6, PKCS7_SIGNED_DATA));
                    arrayList2.add(new DERValue(160, dERValue));
                    return new DERValue(48, arrayList2).getEncoded();
                }
                byteArrayOutputStream.write(((Certificate)object.next()).getEncoded());
            }
        }
    }

    public X509CertPath(List list2) {
        super("X.509");
        this.path = Collections.unmodifiableList(list2);
    }

    public X509CertPath(InputStream inputStream) throws CertificateEncodingException {
        this(inputStream, (String)ENCODINGS.get(0));
    }

    public X509CertPath(InputStream inputStream, String string) throws CertificateEncodingException {
        super("X.509");
        try {
            this.parse(inputStream, string);
        }
        catch (IOException iOException) {
            throw new CertificateEncodingException();
        }
    }
}

