/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import javax.swing.CellRendererPane;
import javax.swing.JComponent;
import javax.swing.LookAndFeel;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.TableHeaderUI;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class BasicTableHeaderUI
extends TableHeaderUI {
    static int COLUMN_BOUNDARY_TOLERANCE = 3;
    protected JTableHeader header;
    protected MouseInputListener mouseInputListener = this.createMouseInputListener();
    protected CellRendererPane rendererPane;
    private Border cellBorder;
    Rectangle draggingHeaderRect;

    public static ComponentUI createUI(JComponent jComponent) {
        return new BasicTableHeaderUI();
    }

    protected MouseInputListener createMouseInputListener() {
        return new MouseInputHandler();
    }

    protected void installDefaults() {
        LookAndFeel.installColorsAndFont(this.header, "TableHeader.background", "TableHeader.foreground", "TableHeader.font");
        this.cellBorder = UIManager.getBorder("TableHeader.cellBorder");
    }

    protected void installKeyboardActions() {
    }

    protected void installListeners() {
        this.header.addMouseListener(this.mouseInputListener);
        this.header.addMouseMotionListener(this.mouseInputListener);
    }

    public void installUI(JComponent jComponent) {
        this.header = (JTableHeader)jComponent;
        this.rendererPane = new CellRendererPane();
        this.installDefaults();
        this.installKeyboardActions();
        this.installListeners();
    }

    protected void uninstallDefaults() {
        this.header.setBackground(null);
        this.header.setForeground(null);
        this.header.setFont(null);
    }

    protected void uninstallKeyboardActions() {
    }

    protected void uninstallListeners() {
        this.header.removeMouseListener(this.mouseInputListener);
        this.header.removeMouseMotionListener(this.mouseInputListener);
    }

    public void uninstallUI(JComponent jComponent) {
        this.uninstallListeners();
        this.uninstallKeyboardActions();
        this.uninstallDefaults();
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        TableColumnModel tableColumnModel = this.header.getColumnModel();
        int n = tableColumnModel.getColumnCount();
        if (n == 0) {
            return;
        }
        Rectangle rectangle = graphics.getClipBounds();
        TableCellRenderer tableCellRenderer = this.header.getDefaultRenderer();
        int n2 = 0;
        while (n2 < n) {
            Rectangle rectangle2 = this.header.getHeaderRect(n2);
            if (rectangle2.intersects(rectangle)) {
                Rectangle rectangle3 = graphics.getClipBounds();
                TableColumn tableColumn = tableColumnModel.getColumn(n2);
                TableCellRenderer tableCellRenderer2 = tableColumn.getHeaderRenderer();
                if (tableCellRenderer2 == null) {
                    tableCellRenderer2 = tableCellRenderer;
                }
                Object object = tableColumn.getHeaderValue();
                Component component = tableCellRenderer2.getTableCellRendererComponent(this.header.getTable(), object, false, false, -1, n2);
                component.setFont(this.header.getFont());
                component.setBackground(this.header.getBackground());
                component.setForeground(this.header.getForeground());
                if (component instanceof JComponent) {
                    ((JComponent)component).setBorder(this.cellBorder);
                }
                this.rendererPane.paintComponent(graphics, component, this.header, rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
            }
            ++n2;
        }
        if (this.draggingHeaderRect != null) {
            graphics.setColor(this.header.getForeground());
            graphics.drawRect(this.draggingHeaderRect.x, this.draggingHeaderRect.y + 2, this.draggingHeaderRect.width - 1, this.draggingHeaderRect.height - 6);
        }
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        TableColumnModel tableColumnModel = this.header.getColumnModel();
        TableCellRenderer tableCellRenderer = this.header.getDefaultRenderer();
        int n = tableColumnModel.getColumnCount();
        Dimension dimension = new Dimension(0, 0);
        int n2 = 0;
        if (this.header.getTable() != null && this.header.getTable().getIntercellSpacing() != null) {
            n2 = this.header.getTable().getIntercellSpacing().width;
        }
        int n3 = 0;
        while (n3 < n) {
            TableColumn tableColumn = tableColumnModel.getColumn(n3);
            TableCellRenderer tableCellRenderer2 = tableColumn.getHeaderRenderer();
            if (tableCellRenderer2 == null) {
                tableCellRenderer2 = tableCellRenderer;
            }
            Object object = tableColumn.getHeaderValue();
            Component component = tableCellRenderer2.getTableCellRendererComponent(this.header.getTable(), object, false, false, -1, n3);
            component.setFont(this.header.getFont());
            component.setBackground(this.header.getBackground());
            component.setForeground(this.header.getForeground());
            if (component instanceof JComponent) {
                ((JComponent)component).setBorder(this.cellBorder);
            }
            Dimension dimension2 = component.getPreferredSize();
            dimension.width += n2;
            dimension.height = Math.max(dimension2.height, dimension.height);
            ++n3;
        }
        dimension.width = tableColumnModel.getTotalColumnWidth();
        return dimension;
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public class MouseInputHandler
    implements MouseInputListener {
        boolean showingResizeCursor;
        int draggingFrom;
        int draggingColumnNumber;
        int prevPrefWidth;
        Timer timer;

        public void mouseClicked(MouseEvent mouseEvent) {
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            TableColumn tableColumn = BasicTableHeaderUI.this.header.getResizingColumn();
            if (tableColumn != null && BasicTableHeaderUI.this.header.getResizingAllowed()) {
                if (this.timer == null) {
                    this.timer = new Timer(1, new ActionListener(){

                        public final void actionPerformed(ActionEvent actionEvent) {
                            BasicTableHeaderUI.this.header.getTable().doLayout();
                        }
                    });
                    this.timer.setRepeats(false);
                    this.timer.setCoalesce(true);
                }
                tableColumn.setPreferredWidth(this.prevPrefWidth + mouseEvent.getX() - this.draggingFrom);
                this.timer.restart();
            } else if (BasicTableHeaderUI.this.draggingHeaderRect != null && BasicTableHeaderUI.this.header.getReorderingAllowed()) {
                BasicTableHeaderUI.this.draggingHeaderRect.x = mouseEvent.getX() + this.draggingFrom;
                BasicTableHeaderUI.this.header.repaint();
            }
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
            if (BasicTableHeaderUI.this.header.getResizingColumn() != null && BasicTableHeaderUI.this.header.getResizingAllowed()) {
                this.endResizing();
            }
            if (BasicTableHeaderUI.this.header.getDraggedColumn() != null && BasicTableHeaderUI.this.header.getReorderingAllowed()) {
                this.endDragging(null);
            }
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            if (mouseEvent.getButton() == 0 && BasicTableHeaderUI.this.header.getResizingAllowed()) {
                TableColumnModel tableColumnModel = BasicTableHeaderUI.this.header.getColumnModel();
                int n = tableColumnModel.getColumnCount();
                if (n < 2) {
                    return;
                }
                boolean bl = false;
                int n2 = mouseEvent.getX();
                int n3 = n2 - COLUMN_BOUNDARY_TOLERANCE;
                int n4 = n2 + COLUMN_BOUNDARY_TOLERANCE;
                int n5 = 0;
                int n6 = 0;
                while (n6 < n - 1) {
                    if ((n5 += tableColumnModel.getColumn(n6).getWidth()) >= n3 && n5 <= n4) {
                        TableColumn tableColumn = tableColumnModel.getColumn(n6);
                        bl = true;
                        this.draggingFrom = n2;
                        this.prevPrefWidth = tableColumn.getWidth();
                        BasicTableHeaderUI.this.header.setResizingColumn(tableColumn);
                        break;
                    }
                    ++n6;
                }
                if (bl != this.showingResizeCursor) {
                    if (bl) {
                        if (n5 < n2) {
                            BasicTableHeaderUI.this.header.setCursor(Cursor.getPredefinedCursor(10));
                        } else {
                            BasicTableHeaderUI.this.header.setCursor(Cursor.getPredefinedCursor(11));
                        }
                    } else {
                        BasicTableHeaderUI.this.header.setCursor(Cursor.getDefaultCursor());
                        BasicTableHeaderUI.this.header.setResizingColumn(null);
                    }
                    this.showingResizeCursor = bl;
                }
            }
        }

        public void mousePressed(MouseEvent mouseEvent) {
            Object object;
            if (BasicTableHeaderUI.this.header.getResizingAllowed() && (object = BasicTableHeaderUI.this.header.getResizingColumn()) != null) {
                ((TableColumn)object).setPreferredWidth(((TableColumn)object).getWidth());
                return;
            }
            if (BasicTableHeaderUI.this.header.getReorderingAllowed()) {
                object = BasicTableHeaderUI.this.header.getColumnModel();
                int n = object.getColumnCount();
                if (n < 2) {
                    return;
                }
                boolean bl = false;
                int n2 = mouseEvent.getX();
                int n3 = 0;
                int n4 = -1;
                int n5 = 0;
                while (n5 < n) {
                    if ((n3 += object.getColumn(n5).getWidth()) > n2) {
                        n4 = n5;
                        break;
                    }
                    ++n5;
                }
                if (n4 < 0) {
                    return;
                }
                TableColumn tableColumn = object.getColumn(n4);
                BasicTableHeaderUI.this.header.setDraggedColumn(tableColumn);
                this.draggingFrom = n3 - tableColumn.getWidth() - n2;
                BasicTableHeaderUI.this.draggingHeaderRect = new Rectangle(BasicTableHeaderUI.this.header.getHeaderRect(n4));
                this.draggingColumnNumber = n4;
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (BasicTableHeaderUI.this.header.getResizingColumn() != null && BasicTableHeaderUI.this.header.getResizingAllowed()) {
                this.endResizing();
            }
            if (BasicTableHeaderUI.this.header.getDraggedColumn() != null && BasicTableHeaderUI.this.header.getReorderingAllowed()) {
                this.endDragging(mouseEvent);
            }
        }

        void endResizing() {
            TableColumnModel tableColumnModel = BasicTableHeaderUI.this.header.getColumnModel();
            int n = tableColumnModel.getColumnCount();
            if (n > 2) {
                int n2 = 0;
                while (n2 < n) {
                    TableColumn tableColumn = tableColumnModel.getColumn(n2);
                    tableColumn.setPreferredWidth(tableColumn.getWidth());
                    ++n2;
                }
            }
            BasicTableHeaderUI.this.header.setResizingColumn(null);
            this.showingResizeCursor = false;
            if (this.timer != null) {
                this.timer.stop();
            }
            BasicTableHeaderUI.this.header.setCursor(Cursor.getDefaultCursor());
        }

        void endDragging(MouseEvent mouseEvent) {
            BasicTableHeaderUI.this.header.setDraggedColumn(null);
            if (mouseEvent == null) {
                BasicTableHeaderUI.this.header.repaint(BasicTableHeaderUI.this.draggingHeaderRect);
                BasicTableHeaderUI.this.draggingHeaderRect = null;
                return;
            }
            BasicTableHeaderUI.this.draggingHeaderRect = null;
            TableColumnModel tableColumnModel = BasicTableHeaderUI.this.header.getColumnModel();
            int n = mouseEvent.getX();
            int n2 = 0;
            int n3 = -1;
            int n4 = tableColumnModel.getColumnCount();
            int n5 = 0;
            while (n5 < n4) {
                if ((n2 += tableColumnModel.getColumn(n5).getWidth()) > n) {
                    n3 = n5;
                    break;
                }
                ++n5;
            }
            if (n3 >= 0) {
                BasicTableHeaderUI.this.header.getTable().moveColumn(this.draggingColumnNumber, n3);
            }
        }

        private final /* synthetic */ void this() {
            this.draggingFrom = -1;
            this.prevPrefWidth = -1;
        }

        public MouseInputHandler() {
            this.this();
        }
    }
}

