/*
 * Decompiled with CFR 0.152.
 */
package net.pflaeging.PortableSigner;

import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.cert.X509Certificate;
import java.util.Date;

public class PSCertificate {
    public static int count = 0;
    public String aliasname;
    public String name;
    public Boolean isKey;
    public X509Certificate issuer;
    public X509Certificate certificate;
    public String serial;
    public String subject;
    public Date from;
    public Date to;

    public PSCertificate(String alias, KeyStore ks) {
        try {
            this.aliasname = alias;
            this.certificate = (X509Certificate)ks.getCertificate(alias);
            this.name = this.certificate.toString();
            this.issuer = this.certificate;
            if (ks.getCertificateChain(alias) != null && ks.getCertificateChain(alias).length >= 2) {
                this.issuer = (X509Certificate)ks.getCertificateChain(alias)[1];
            }
            this.isKey = ks.isKeyEntry(alias);
            this.serial = this.certificate.getSerialNumber().toString();
            this.subject = this.certificate.getSubjectX500Principal().toString();
            this.from = this.certificate.getNotBefore();
            this.to = this.certificate.getNotAfter();
        }
        catch (KeyStoreException e) {
            System.err.println("Beim Lesen des Zertifikates trat ein Fehler auf (Zertifikatsfehler)");
        }
        ++count;
    }
}

