/*
 * Decompiled with CFR 0.152.
 */
package net.sf.gogui.go;

import java.util.ArrayList;
import net.sf.gogui.go.GoPoint;

public final class BoardConstants {
    private final int m_size;
    private int m_handicapLine1;
    private int m_handicapLine2;
    private int m_handicapLine3;

    public BoardConstants(int n) {
        this.m_size = n;
        this.m_handicapLine1 = -1;
        this.m_handicapLine2 = -1;
        this.m_handicapLine3 = -1;
        if (n >= 13) {
            this.m_handicapLine1 = 3;
            this.m_handicapLine3 = n - 4;
        } else if (n >= 8) {
            this.m_handicapLine1 = 2;
            this.m_handicapLine3 = n - 3;
        }
        if (n >= 11 && n % 2 != 0) {
            this.m_handicapLine2 = n / 2;
        }
    }

    public ArrayList getHandicapStones(int n) {
        ArrayList<GoPoint> arrayList = new ArrayList<GoPoint>(9);
        if (n == 0) {
            return arrayList;
        }
        int n2 = this.m_handicapLine1;
        int n3 = this.m_handicapLine2;
        int n4 = this.m_handicapLine3;
        if (n2 < 0) {
            return null;
        }
        if (n > 4 && n3 < 0) {
            return null;
        }
        if (n >= 1) {
            arrayList.add(GoPoint.get(n2, n2));
        }
        if (n >= 2) {
            arrayList.add(GoPoint.get(n4, n4));
        }
        if (n >= 3) {
            arrayList.add(GoPoint.get(n2, n4));
        }
        if (n >= 4) {
            arrayList.add(GoPoint.get(n4, n2));
        }
        if (n >= 5 && n % 2 != 0) {
            arrayList.add(GoPoint.get(n3, n3));
            --n;
        }
        if (n >= 5) {
            arrayList.add(GoPoint.get(n2, n3));
        }
        if (n >= 6) {
            arrayList.add(GoPoint.get(n4, n3));
        }
        if (n >= 7) {
            arrayList.add(GoPoint.get(n3, n2));
        }
        if (n >= 8) {
            arrayList.add(GoPoint.get(n3, n4));
        }
        return arrayList;
    }

    public int getSize() {
        return this.m_size;
    }

    public boolean isEdgeLine(int n) {
        return n == 0 || n == this.m_size - 1;
    }

    public boolean isHandicapLine(int n) {
        return n == this.m_handicapLine1 || n == this.m_handicapLine2 || n == this.m_handicapLine3;
    }

    public boolean isHandicap(GoPoint goPoint) {
        int n = goPoint.getX();
        int n2 = goPoint.getY();
        return this.isHandicapLine(n) && this.isHandicapLine(n2);
    }
}

