/*
 * Decompiled with CFR 0.152.
 */
package java.awt.geom;

import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.util.NoSuchElementException;

public abstract class RoundRectangle2D
extends RectangularShape {
    public abstract double getArcHeight();

    public abstract double getArcWidth();

    public abstract void setRoundRect(double var1, double var3, double var5, double var7, double var9, double var11);

    public boolean contains(double d, double d2) {
        double d3 = this.getX();
        double d4 = this.getWidth();
        if (d < d3 || d >= d3 + d4) {
            return false;
        }
        double d5 = this.getY();
        double d6 = this.getHeight();
        if (d2 < d5 || d2 >= d5 + d6) {
            return false;
        }
        double d7 = Math.min(Math.abs(d5 - d2), Math.abs(d5 + d6 - d2));
        double d8 = Math.min(Math.abs(d3 - d), Math.abs(d3 + d4 - d));
        double d9 = this.getArcWidth() / (double)2;
        double d10 = this.getArcHeight() / (double)2;
        if (d8 > d9 || d7 > d10) {
            return true;
        }
        d7 = (d10 - d7) / d10;
        d8 = (d9 - d8) / d9;
        boolean bl = false;
        if (d8 * d8 + d7 * d7 <= 1.0) {
            bl = true;
        }
        return bl;
    }

    public boolean contains(double d, double d2, double d3, double d4) {
        boolean bl = false;
        if (this.contains(d, d2) && this.contains(d, d2 + d4) && this.contains(d + d3, d2 + d4) && this.contains(d + d3, d2)) {
            bl = true;
        }
        return bl;
    }

    public PathIterator getPathIterator(final AffineTransform affineTransform) {
        final double d = this.getX();
        final double d2 = this.getY();
        final double d3 = d + this.getWidth();
        final double d4 = d2 + this.getHeight();
        final double d5 = this.getArcWidth();
        final double d6 = this.getArcHeight();
        return new PathIterator(){
            private int current;
            private PathIterator corner;
            private Arc2D arc;
            private double[] temp;

            public final int getWindingRule() {
                return 1;
            }

            public final boolean isDone() {
                boolean bl = false;
                if (this.current > 9) {
                    bl = true;
                }
                return bl;
            }

            private final void getPoint(int n) {
                switch (n) {
                    case 0: 
                    case 8: {
                        this.temp[0] = d3;
                        this.temp[1] = d2 + d6;
                        break;
                    }
                    case 7: {
                        this.temp[0] = d3;
                        this.temp[1] = d4 - d6;
                        break;
                    }
                    case 6: {
                        this.temp[0] = d3 - d5;
                        this.temp[1] = d4;
                        break;
                    }
                    case 5: {
                        this.temp[0] = d + d5;
                        this.temp[1] = d4;
                        break;
                    }
                    case 4: {
                        this.temp[0] = d;
                        this.temp[1] = d4 - d6;
                        break;
                    }
                    case 3: {
                        this.temp[0] = d;
                        this.temp[1] = d2 + d6;
                        break;
                    }
                    case 2: {
                        this.temp[0] = d + d5;
                        this.temp[1] = d2;
                        break;
                    }
                    case 1: {
                        this.temp[0] = d3 - d5;
                        this.temp[1] = d2;
                        break;
                    }
                }
            }

            public final void next() {
                if (this.current >= 8) {
                    ++this.current;
                } else if (this.corner != null) {
                    this.corner.next();
                    if (this.corner.isDone()) {
                        this.corner = null;
                        ++this.current;
                    }
                } else {
                    this.getPoint(this.current);
                    double d7 = this.temp[0];
                    double d22 = this.temp[1];
                    this.getPoint(this.current + 1);
                    Rectangle2D.Double double_ = new Rectangle2D.Double(Math.min(d7, this.temp[0]), Math.min(d22, this.temp[1]), Math.abs(d7 - this.temp[0]), Math.abs(d22 - this.temp[1]));
                    this.arc.setArc(double_, (double)(this.current >> 1) * 90.0, 90.0, 0);
                    this.corner = this.arc.getPathIterator(affineTransform);
                }
            }

            public final int currentSegment(float[] fArray) {
                if (this.corner != null) {
                    int n = this.corner.currentSegment(fArray);
                    if (n == 0) {
                        n = 1;
                    }
                    return n;
                }
                if (this.current >= 9) {
                    if (this.current == 9) {
                        return 4;
                    }
                    throw new NoSuchElementException("rect iterator out of bounds");
                }
                this.getPoint(this.current);
                fArray[0] = (float)this.temp[0];
                fArray[1] = (float)this.temp[1];
                if (affineTransform != null) {
                    affineTransform.transform(fArray, 0, fArray, 0, 1);
                }
                int n = 0;
                if (this.current == 0) {
                    n = 1;
                }
                return 1 - n;
            }

            public final int currentSegment(double[] dArray) {
                if (this.corner != null) {
                    int n = this.corner.currentSegment(dArray);
                    if (n == 0) {
                        n = 1;
                    }
                    return n;
                }
                if (this.current >= 9) {
                    if (this.current == 9) {
                        return 4;
                    }
                    throw new NoSuchElementException("rect iterator out of bounds");
                }
                this.getPoint(this.current);
                dArray[0] = this.temp[0];
                dArray[1] = this.temp[1];
                if (affineTransform != null) {
                    affineTransform.transform(dArray, 0, dArray, 0, 1);
                }
                int n = 0;
                if (this.current == 0) {
                    n = 1;
                }
                return 1 - n;
            }

            private final /* synthetic */ void this() {
                this.current = 0;
                this.arc = new Arc2D.Double();
                this.temp = new double[2];
            }
            {
                this.this();
            }
        };
    }

    public boolean intersects(double d, double d2, double d3, double d4) {
        boolean bl = false;
        if (this.contains(d, d2) || this.contains(d, d2 + d4) || this.contains(d + d3, d2 + d4) || this.contains(d + d3, d2)) {
            bl = true;
        }
        return bl;
    }

    public void setFrame(double d, double d2, double d3, double d4) {
        this.setRoundRect(d, d2, d3, d4, this.getArcWidth(), this.getArcHeight());
    }

    public void setRoundRect(RoundRectangle2D roundRectangle2D) {
        this.setRoundRect(roundRectangle2D.getX(), roundRectangle2D.getY(), roundRectangle2D.getWidth(), roundRectangle2D.getHeight(), roundRectangle2D.getArcWidth(), roundRectangle2D.getArcHeight());
    }

    protected RoundRectangle2D() {
    }

    public static class Float
    extends RoundRectangle2D {
        public float archeight;
        public float arcwidth;
        public float x;
        public float y;
        public float width;
        public float height;

        public double getArcHeight() {
            return this.archeight;
        }

        public double getArcWidth() {
            return this.arcwidth;
        }

        public Rectangle2D getBounds2D() {
            return new Rectangle2D.Float(this.x, this.y, this.width, this.height);
        }

        public double getX() {
            return this.x;
        }

        public double getY() {
            return this.y;
        }

        public double getWidth() {
            return this.width;
        }

        public double getHeight() {
            return this.height;
        }

        public boolean isEmpty() {
            boolean bl = false;
            if (this.width <= 0.0f || this.height <= 0.0f) {
                bl = true;
            }
            return bl;
        }

        public void setRoundRect(float f, float f2, float f3, float f4, float f5, float f6) {
            this.x = f;
            this.y = f2;
            this.width = f3;
            this.height = f4;
            this.arcwidth = f5;
            this.archeight = f6;
        }

        public void setRoundRect(double d, double d2, double d3, double d4, double d5, double d6) {
            this.x = (float)d;
            this.y = (float)d2;
            this.width = (float)d3;
            this.height = (float)d4;
            this.arcwidth = (float)d5;
            this.archeight = (float)d6;
        }

        public Float() {
        }

        public Float(float f, float f2, float f3, float f4, float f5, float f6) {
            this.x = f;
            this.y = f2;
            this.width = f3;
            this.height = f4;
            this.arcwidth = f5;
            this.archeight = f6;
        }
    }

    public static class Double
    extends RoundRectangle2D {
        public double archeight;
        public double arcwidth;
        public double x;
        public double y;
        public double width;
        public double height;

        public double getArcHeight() {
            return this.archeight;
        }

        public double getArcWidth() {
            return this.arcwidth;
        }

        public Rectangle2D getBounds2D() {
            return new Rectangle2D.Double(this.x, this.y, this.width, this.height);
        }

        public double getX() {
            return this.x;
        }

        public double getY() {
            return this.y;
        }

        public double getWidth() {
            return this.width;
        }

        public double getHeight() {
            return this.height;
        }

        public boolean isEmpty() {
            boolean bl = false;
            if (this.width <= 0.0 || this.height <= 0.0) {
                bl = true;
            }
            return bl;
        }

        public void setRoundRect(double d, double d2, double d3, double d4, double d5, double d6) {
            this.x = d;
            this.y = d2;
            this.width = d3;
            this.height = d4;
            this.arcwidth = d5;
            this.archeight = d6;
        }

        public Double() {
        }

        public Double(double d, double d2, double d3, double d4, double d5, double d6) {
            this.x = d;
            this.y = d2;
            this.width = d3;
            this.height = d4;
            this.arcwidth = d5;
            this.archeight = d6;
        }
    }
}

