/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public class IdentityHashMap
extends AbstractMap
implements Map,
Serializable,
Cloneable {
    private static final int DEFAULT_CAPACITY = 21;
    static final Object tombstone = new Object();
    static final Object emptyslot = new Object();
    private static final long serialVersionUID = 8188218128353913216L;
    int size;
    transient Object[] table;
    transient int modCount;
    private transient Set entries;
    private transient int threshold;

    public void clear() {
        if (this.size != 0) {
            ++this.modCount;
            Arrays.fill(this.table, emptyslot);
            this.size = 0;
        }
    }

    public Object clone() {
        try {
            IdentityHashMap identityHashMap = (IdentityHashMap)super.clone();
            identityHashMap.table = (Object[])this.table.clone();
            identityHashMap.entries = null;
            return identityHashMap;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public boolean containsKey(Object object) {
        boolean bl = false;
        if (object == this.table[this.hash(object)]) {
            bl = true;
        }
        return bl;
    }

    public boolean containsValue(Object object) {
        int n = this.table.length - 1;
        while (n > 0) {
            if (this.table[n] == object) {
                return true;
            }
            n -= 2;
        }
        return false;
    }

    public Set entrySet() {
        if (this.entries == null) {
            this.entries = new AbstractSet(){

                public final int size() {
                    return IdentityHashMap.this.size;
                }

                public final Iterator iterator() {
                    return new IdentityIterator(2);
                }

                public final void clear() {
                    IdentityHashMap.this.clear();
                }

                public final boolean contains(Object object) {
                    if (!(object instanceof Map.Entry)) {
                        return false;
                    }
                    Map.Entry entry = (Map.Entry)object;
                    boolean bl = false;
                    if (entry.getValue() == IdentityHashMap.this.table[IdentityHashMap.this.hash(entry.getKey()) + 1]) {
                        bl = true;
                    }
                    return bl;
                }

                public final int hashCode() {
                    return IdentityHashMap.this.hashCode();
                }

                public final boolean remove(Object object) {
                    if (!(object instanceof Map.Entry)) {
                        return false;
                    }
                    Object object2 = ((Map.Entry)object).getKey();
                    int n = IdentityHashMap.this.hash(object2);
                    if (IdentityHashMap.this.table[n] == object2) {
                        --IdentityHashMap.this.size;
                        ++IdentityHashMap.this.modCount;
                        IdentityHashMap.this.table[n] = tombstone;
                        IdentityHashMap.this.table[n + 1] = tombstone;
                        return true;
                    }
                    return false;
                }
            };
        }
        return this.entries;
    }

    public boolean equals(Object object) {
        return super.equals(object);
    }

    public Object get(Object object) {
        int n = this.hash(object);
        return this.table[n] == object ? this.table[n + 1] : null;
    }

    public int hashCode() {
        int n = 0;
        int n2 = this.table.length - 2;
        while (n2 >= 0) {
            Object object = this.table[n2];
            if (object != emptyslot && object != tombstone) {
                n += System.identityHashCode(object) ^ System.identityHashCode(this.table[n2 + 1]);
            }
            n2 -= 2;
        }
        return n;
    }

    public boolean isEmpty() {
        boolean bl = false;
        if (this.size == 0) {
            bl = true;
        }
        return bl;
    }

    public Set keySet() {
        if (this.keys == null) {
            this.keys = new AbstractSet(){

                public final int size() {
                    return IdentityHashMap.this.size;
                }

                public final Iterator iterator() {
                    return new IdentityIterator(0);
                }

                public final void clear() {
                    IdentityHashMap.this.clear();
                }

                public final boolean contains(Object object) {
                    return IdentityHashMap.this.containsKey(object);
                }

                public final int hashCode() {
                    int n = 0;
                    int n2 = IdentityHashMap.this.table.length - 2;
                    while (n2 >= 0) {
                        Object object = IdentityHashMap.this.table[n2];
                        if (object != emptyslot && object != tombstone) {
                            n += System.identityHashCode(object);
                        }
                        n2 -= 2;
                    }
                    return n;
                }

                public final boolean remove(Object object) {
                    int n = IdentityHashMap.this.hash(object);
                    if (IdentityHashMap.this.table[n] == object) {
                        --IdentityHashMap.this.size;
                        ++IdentityHashMap.this.modCount;
                        IdentityHashMap.this.table[n] = tombstone;
                        IdentityHashMap.this.table[n + 1] = tombstone;
                        return true;
                    }
                    return false;
                }
            };
        }
        return this.keys;
    }

    public Object put(Object object, Object object2) {
        int n;
        if (this.size > this.threshold) {
            Object[] objectArray = this.table;
            this.table = new Object[objectArray.length * 2 + 2];
            Arrays.fill(this.table, emptyslot);
            this.size = 0;
            this.threshold = (this.table.length >>> 3) * 3;
            int n2 = objectArray.length - 2;
            while (n2 >= 0) {
                Object object3 = objectArray[n2];
                if (object3 != tombstone && object3 != emptyslot) {
                    this.put(object3, objectArray[n2 + 1]);
                }
                n2 -= 2;
            }
        }
        if (this.table[n = this.hash(object)] == object) {
            Object object4 = this.table[n + 1];
            this.table[n + 1] = object2;
            return object4;
        }
        ++this.modCount;
        ++this.size;
        this.table[n] = object;
        this.table[n + 1] = object2;
        return null;
    }

    public void putAll(Map map) {
        super.putAll(map);
    }

    public Object remove(Object object) {
        int n = this.hash(object);
        if (this.table[n] == object) {
            ++this.modCount;
            --this.size;
            Object object2 = this.table[n + 1];
            this.table[n] = tombstone;
            this.table[n + 1] = tombstone;
            return object2;
        }
        return null;
    }

    public int size() {
        return this.size;
    }

    public Collection values() {
        if (this.values == null) {
            this.values = new AbstractCollection(){

                public final int size() {
                    return IdentityHashMap.this.size;
                }

                public final Iterator iterator() {
                    return new IdentityIterator(1);
                }

                public final void clear() {
                    IdentityHashMap.this.clear();
                }

                public final boolean remove(Object object) {
                    int n = IdentityHashMap.this.table.length - 1;
                    while (n > 0) {
                        if (IdentityHashMap.this.table[n] == object) {
                            ++IdentityHashMap.this.modCount;
                            IdentityHashMap.this.table[n - 1] = tombstone;
                            IdentityHashMap.this.table[n] = tombstone;
                            --IdentityHashMap.this.size;
                            return true;
                        }
                        n -= 2;
                    }
                    return false;
                }
            };
        }
        return this.values;
    }

    int hash(Object object) {
        int n = Math.abs(System.identityHashCode(object) % (this.table.length >> 1)) << 1;
        int n2 = -1;
        int n3 = n;
        do {
            if (this.table[n] == object) {
                return n;
            }
            if (this.table[n] == emptyslot) break;
            if (this.table[n] == tombstone && n2 < 0) {
                n2 = n;
            }
            if ((n -= 2) >= 0) continue;
            n = this.table.length - 2;
        } while (n != n3);
        return n2 < 0 ? n : n2;
    }

    private final void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        int n = objectInputStream.readInt();
        this.table = new Object[Math.max(n << 1, 21) << 1];
        while (--n >= 0) {
            this.put(objectInputStream.readObject(), objectInputStream.readObject());
        }
    }

    private final void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeInt(this.size);
        int n = this.table.length - 2;
        while (n >= 0) {
            Object object = this.table[n];
            if (object != tombstone && object != emptyslot) {
                objectOutputStream.writeObject(object);
                objectOutputStream.writeObject(this.table[n + 1]);
            }
            n -= 2;
        }
    }

    public IdentityHashMap() {
        this(21);
    }

    public IdentityHashMap(int n) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        if (n < 2) {
            n = 2;
        }
        this.table = new Object[n << 1];
        Arrays.fill(this.table, emptyslot);
        this.threshold = (n >> 2) * 3;
    }

    public IdentityHashMap(Map map) {
        this(Math.max(map.size() << 1, 21));
        this.putAll(map);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private final class IdentityEntry
    implements Map.Entry {
        final int loc;
        final int knownMod;

        public final boolean equals(Object object) {
            if (this.knownMod != IdentityHashMap.this.modCount || IdentityHashMap.this.table[this.loc] == tombstone) {
                throw new ConcurrentModificationException();
            }
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            boolean bl = false;
            if (IdentityHashMap.this.table[this.loc] == entry.getKey() && IdentityHashMap.this.table[this.loc + 1] == entry.getValue()) {
                bl = true;
            }
            return bl;
        }

        public final Object getKey() {
            if (this.knownMod != IdentityHashMap.this.modCount || IdentityHashMap.this.table[this.loc] == tombstone) {
                throw new ConcurrentModificationException();
            }
            return IdentityHashMap.this.table[this.loc];
        }

        public final Object getValue() {
            if (this.knownMod != IdentityHashMap.this.modCount || IdentityHashMap.this.table[this.loc] == tombstone) {
                throw new ConcurrentModificationException();
            }
            return IdentityHashMap.this.table[this.loc + 1];
        }

        public final int hashCode() {
            if (this.knownMod != IdentityHashMap.this.modCount || IdentityHashMap.this.table[this.loc] == tombstone) {
                throw new ConcurrentModificationException();
            }
            return System.identityHashCode(IdentityHashMap.this.table[this.loc]) ^ System.identityHashCode(IdentityHashMap.this.table[this.loc + 1]);
        }

        public final Object setValue(Object object) {
            if (this.knownMod != IdentityHashMap.this.modCount || IdentityHashMap.this.table[this.loc] == tombstone) {
                throw new ConcurrentModificationException();
            }
            Object object2 = IdentityHashMap.this.table[this.loc + 1];
            IdentityHashMap.this.table[this.loc + 1] = object;
            return object2;
        }

        public final String toString() {
            if (this.knownMod != IdentityHashMap.this.modCount || IdentityHashMap.this.table[this.loc] == tombstone) {
                throw new ConcurrentModificationException();
            }
            return "" + IdentityHashMap.this.table[this.loc] + '=' + IdentityHashMap.this.table[this.loc + 1];
        }

        private final /* synthetic */ void this() {
            this.knownMod = IdentityHashMap.this.modCount;
        }

        IdentityEntry(int n) {
            this.this();
            this.loc = n;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class IdentityIterator
    implements Iterator {
        final int type;
        int knownMod;
        int count;
        int loc;

        public boolean hasNext() {
            if (this.knownMod != IdentityHashMap.this.modCount) {
                throw new ConcurrentModificationException();
            }
            boolean bl = false;
            if (this.count > 0) {
                bl = true;
            }
            return bl;
        }

        public Object next() {
            Object object;
            if (this.knownMod != IdentityHashMap.this.modCount) {
                throw new ConcurrentModificationException();
            }
            if (this.count == 0) {
                throw new NoSuchElementException();
            }
            --this.count;
            do {
                this.loc -= 2;
            } while ((object = IdentityHashMap.this.table[this.loc]) == emptyslot || object == tombstone);
            return this.type == 0 ? object : (this.type == 1 ? IdentityHashMap.this.table[this.loc + 1] : new IdentityEntry(this.loc));
        }

        public void remove() {
            if (this.knownMod != IdentityHashMap.this.modCount) {
                throw new ConcurrentModificationException();
            }
            if (this.loc == IdentityHashMap.this.table.length || IdentityHashMap.this.table[this.loc] == tombstone) {
                throw new IllegalStateException();
            }
            ++IdentityHashMap.this.modCount;
            --IdentityHashMap.this.size;
            IdentityHashMap.this.table[this.loc] = tombstone;
            IdentityHashMap.this.table[this.loc + 1] = tombstone;
            ++this.knownMod;
        }

        private final /* synthetic */ void this() {
            this.knownMod = IdentityHashMap.this.modCount;
            this.count = IdentityHashMap.this.size;
            this.loc = IdentityHashMap.this.table.length;
        }

        IdentityIterator(int n) {
            this.this();
            this.type = n;
        }
    }
}

